/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.nfc.Entry;
import android.nfc.INfcOemExtensionCallback;
import android.nfc.NdefMessage;
import android.nfc.NfcAdapter;
import android.nfc.NfcRoutingTableEntry;
import android.nfc.OemLogItems;
import android.nfc.RoutingStatus;
import android.nfc.RoutingTableAidEntry;
import android.nfc.RoutingTableProtocolEntry;
import android.nfc.RoutingTableSystemCodeEntry;
import android.nfc.RoutingTableTechnologyEntry;
import android.nfc.T4tNdefNfcee;
import android.nfc.Tag;
import android.nfc.cardemulation.ApduServiceInfo;
import android.nfc.cardemulation.CardEmulation;
import android.os.Binder;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

@SystemApi
@FlaggedApi(value="android.nfc.nfc_oem_extension")
public class NfcOemExtension {
    private static final String TAG = "NfcOemExtension";
    private static final int OEM_EXTENSION_RESPONSE_THRESHOLD_MS = 2000;
    private static final int TYPE_TECHNOLOGY = 0;
    private static final int TYPE_PROTOCOL = 1;
    private static final int TYPE_AID = 2;
    private static final int TYPE_SYSTEMCODE = 3;
    private final NfcAdapter mAdapter;
    private final NfcOemExtensionCallback mOemNfcExtensionCallback;
    private boolean mIsRegistered = false;
    private final Map<Callback, Executor> mCallbackMap = new HashMap<Callback, Executor>();
    private final Context mContext;
    private final Object mLock = new Object();
    private boolean mCardEmulationActivated = false;
    private boolean mRfFieldActivated = false;
    private boolean mRfDiscoveryStarted = false;
    private boolean mEeListenActivated = false;
    public static final String ACTION_OEM_EXTENSION_INIT = "android.nfc.action.OEM_EXTENSION_INIT";
    @SystemApi
    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    public static final int ENABLE_DEFAULT = 1;
    @SystemApi
    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    public static final int ENABLE_TRANSPARENT = 2;
    @SystemApi
    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    public static final int ENABLE_EE = 3;
    @SystemApi
    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    public static final int DISABLE = 0;
    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    public static final int NFCEE_TECH_NONE = 0;
    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    public static final int NFCEE_TECH_A = 1;
    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    public static final int NFCEE_TECH_B = 2;
    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    public static final int NFCEE_TECH_F = 4;
    public static final int HCE_ACTIVATE = 1;
    public static final int HCE_DATA_TRANSFERRED = 2;
    public static final int HCE_DEACTIVATE = 3;
    public static final int POLLING_STATE_CHANGE_SUCCEEDED = 1;
    public static final int POLLING_STATE_CHANGE_ALREADY_IN_REQUESTED_STATE = 2;
    public static final int STATUS_OK = 0;
    public static final int STATUS_UNKNOWN_ERROR = 1;
    public static final int COMMIT_ROUTING_STATUS_OK = 0;
    public static final int COMMIT_ROUTING_STATUS_FAILED = 3;
    public static final int COMMIT_ROUTING_STATUS_FAILED_UPDATE_IN_PROGRESS = 6;

    NfcOemExtension(@NonNull Context context, @NonNull NfcAdapter adapter) {
        this.mContext = context;
        this.mAdapter = adapter;
        this.mOemNfcExtensionCallback = new NfcOemExtensionCallback();
    }

    @VisibleForTesting
    public NfcOemExtensionCallback getOemNfcExtensionCallback() {
        return this.mOemNfcExtensionCallback;
    }

    @SystemApi
    @NonNull
    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    public T4tNdefNfcee getT4tNdefNfcee() {
        return T4tNdefNfcee.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public void registerCallback(@NonNull Executor executor, @NonNull Callback callback) {
        Object object = this.mLock;
        synchronized (object) {
            if (executor == null || callback == null) {
                Log.e(TAG, "Executor and Callback must not be null!");
                throw new IllegalArgumentException();
            }
            if (this.mCallbackMap.containsKey(callback)) {
                Log.e(TAG, "Callback already registered. Unregister existing callback beforeregistering");
                throw new IllegalArgumentException();
            }
            this.mCallbackMap.put(callback, executor);
            if (!this.mIsRegistered) {
                NfcAdapter.callService(() -> {
                    NfcAdapter.sService.registerOemExtensionCallback(this.mOemNfcExtensionCallback);
                    this.mIsRegistered = true;
                });
            } else {
                this.updateNfCState(callback, executor);
            }
        }
    }

    private void updateNfCState(Callback callback, Executor executor) {
        if (callback != null) {
            Log.i(TAG, "updateNfCState");
            executor.execute(() -> {
                callback.onCardEmulationActivated(this.mCardEmulationActivated);
                callback.onRfFieldDetected(this.mRfFieldActivated);
                callback.onRfDiscoveryStarted(this.mRfDiscoveryStarted);
                callback.onEeListenActivated(this.mEeListenActivated);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public void unregisterCallback(@NonNull Callback callback) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mCallbackMap.containsKey(callback) || !this.mIsRegistered) {
                Log.e(TAG, "Callback not registered");
                throw new IllegalArgumentException();
            }
            if (this.mCallbackMap.size() == 1) {
                NfcAdapter.callService(() -> {
                    NfcAdapter.sService.unregisterOemExtensionCallback(this.mOemNfcExtensionCallback);
                    this.mIsRegistered = false;
                    this.mCallbackMap.remove(callback);
                });
            } else {
                this.mCallbackMap.remove(callback);
            }
        }
    }

    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public void clearPreference() {
        NfcAdapter.callService(() -> NfcAdapter.sService.clearPreference());
    }

    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public void synchronizeScreenState() {
        NfcAdapter.callService(() -> NfcAdapter.sService.setScreenState());
    }

    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public void maybeTriggerFirmwareUpdate() {
        NfcAdapter.callService(() -> NfcAdapter.sService.checkFirmware());
    }

    @NonNull
    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    public Map<String, Integer> getActiveNfceeList() {
        return NfcAdapter.callServiceReturn(() -> NfcAdapter.sService.fetchActiveNfceeList(), new HashMap());
    }

    @SystemApi
    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    @RequiresPermission(value="android.permission.NFC_SET_CONTROLLER_ALWAYS_ON")
    public void setControllerAlwaysOnMode(int mode) {
        if (!NfcAdapter.sHasNfcFeature && !NfcAdapter.sHasCeFeature) {
            throw new UnsupportedOperationException();
        }
        NfcAdapter.callService(() -> NfcAdapter.sService.setControllerAlwaysOn(mode));
    }

    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public void triggerInitialization() {
        NfcAdapter.callService(() -> NfcAdapter.sService.triggerInitialization());
    }

    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public boolean hasUserEnabledNfc() {
        return NfcAdapter.callServiceReturn(() -> NfcAdapter.sService.getSettingStatus(), false);
    }

    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public boolean isTagPresent() {
        return NfcAdapter.callServiceReturn(() -> NfcAdapter.sService.isTagPresent(), false);
    }

    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public int pausePolling(long timeoutInMs) {
        return NfcAdapter.callServiceReturn(() -> NfcAdapter.sService.pausePolling(timeoutInMs), 2);
    }

    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public int resumePolling() {
        return NfcAdapter.callServiceReturn(() -> NfcAdapter.sService.resumePolling(), 2);
    }

    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public long getMaxPausePollingTimeoutMills() {
        return NfcAdapter.callServiceReturn(() -> NfcAdapter.sService.getMaxPausePollingTimeoutMs(), 0L);
    }

    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public void setAutoChangeEnabled(boolean state) {
        NfcAdapter.callService(() -> NfcAdapter.sCardEmulationService.setAutoChangeStatus(state));
    }

    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public boolean isAutoChangeEnabled() {
        return NfcAdapter.callServiceReturn(() -> NfcAdapter.sCardEmulationService.isAutoChangeEnabled(), false);
    }

    @NonNull
    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public RoutingStatus getRoutingStatus() {
        List status = NfcAdapter.callServiceReturn(() -> NfcAdapter.sCardEmulationService.getRoutingStatus(), new ArrayList());
        return new RoutingStatus(this.routeStringToInt((String)status.get(0)), this.routeStringToInt((String)status.get(1)), this.routeStringToInt((String)status.get(2)));
    }

    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    public void overwriteRoutingTable(int protocol, int technology, int emptyAid, int systemCode) {
        String protocolRoute = CardEmulation.routeIntToString(protocol);
        String technologyRoute = CardEmulation.routeIntToString(technology);
        String emptyAidRoute = CardEmulation.routeIntToString(emptyAid);
        String systemCodeRoute = CardEmulation.routeIntToString(systemCode);
        NfcAdapter.callService(() -> NfcAdapter.sCardEmulationService.overwriteRoutingTable(this.mContext.getUser().getIdentifier(), emptyAidRoute, protocolRoute, technologyRoute, systemCodeRoute));
    }

    @NonNull
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    public List<NfcRoutingTableEntry> getRoutingTable() {
        List entryList = NfcAdapter.callServiceReturn(() -> NfcAdapter.sService.getRoutingTableEntryList(), null);
        ArrayList<NfcRoutingTableEntry> result = new ArrayList<NfcRoutingTableEntry>();
        for (Entry entry : entryList) {
            switch (entry.getType()) {
                case 0: {
                    result.add(new RoutingTableTechnologyEntry(entry.getNfceeId(), RoutingTableTechnologyEntry.techStringToInt(entry.getEntry()), this.routeStringToInt(entry.getRoutingType())));
                    break;
                }
                case 1: {
                    result.add(new RoutingTableProtocolEntry(entry.getNfceeId(), RoutingTableProtocolEntry.protocolStringToInt(entry.getEntry()), this.routeStringToInt(entry.getRoutingType())));
                    break;
                }
                case 2: {
                    result.add(new RoutingTableAidEntry((int)entry.getNfceeId(), entry.getEntry(), this.routeStringToInt(entry.getRoutingType())));
                    break;
                }
                case 3: {
                    result.add(new RoutingTableSystemCodeEntry((int)entry.getNfceeId(), entry.getEntry().getBytes(StandardCharsets.UTF_8), this.routeStringToInt(entry.getRoutingType())));
                }
            }
        }
        return result;
    }

    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    public int forceRoutingTableCommit() {
        return NfcAdapter.callServiceReturn(() -> NfcAdapter.sService.commitRouting(), 3);
    }

    private int routeStringToInt(String route) {
        if (route.equals("DH")) {
            return 0;
        }
        if (route.startsWith("eSE")) {
            return 1;
        }
        if (route.startsWith("SIM")) {
            return 2;
        }
        if (route.startsWith("NDEF-NFCEE")) {
            return 4;
        }
        throw new IllegalStateException("Unexpected value: " + route);
    }

    public class NfcOemExtensionCallback
    extends INfcOemExtensionCallback.Stub {
        @Override
        public void onTagConnected(boolean connected) throws RemoteException {
            NfcOemExtension.this.mCallbackMap.forEach((cb, ex) -> this.handleVoidCallback(connected, cb::onTagConnected, (Executor)ex));
        }

        @Override
        public void onCardEmulationActivated(boolean isActivated) throws RemoteException {
            NfcOemExtension.this.mCardEmulationActivated = isActivated;
            NfcOemExtension.this.mCallbackMap.forEach((cb, ex) -> this.handleVoidCallback(isActivated, cb::onCardEmulationActivated, (Executor)ex));
        }

        @Override
        public void onRfFieldDetected(boolean isActive) throws RemoteException {
            NfcOemExtension.this.mRfFieldActivated = isActive;
            NfcOemExtension.this.mCallbackMap.forEach((cb, ex) -> this.handleVoidCallback(isActive, cb::onRfFieldDetected, (Executor)ex));
        }

        @Override
        public void onRfDiscoveryStarted(boolean isDiscoveryStarted) throws RemoteException {
            NfcOemExtension.this.mRfDiscoveryStarted = isDiscoveryStarted;
            NfcOemExtension.this.mCallbackMap.forEach((cb, ex) -> this.handleVoidCallback(isDiscoveryStarted, cb::onRfDiscoveryStarted, (Executor)ex));
        }

        @Override
        public void onEeListenActivated(boolean isActivated) throws RemoteException {
            NfcOemExtension.this.mEeListenActivated = isActivated;
            NfcOemExtension.this.mCallbackMap.forEach((cb, ex) -> this.handleVoidCallback(isActivated, cb::onEeListenActivated, (Executor)ex));
        }

        @Override
        public void onEeUpdated() throws RemoteException {
            NfcOemExtension.this.mCallbackMap.forEach((cb, ex) -> this.handleVoidCallback(null, input -> cb.onEeUpdated(), (Executor)ex));
        }

        @Override
        public void onStateUpdated(int state) throws RemoteException {
            NfcOemExtension.this.mCallbackMap.forEach((cb, ex) -> this.handleVoidCallback(state, cb::onStateUpdated, (Executor)ex));
        }

        @Override
        public void onApplyRouting(ResultReceiver isSkipped) throws RemoteException {
            NfcOemExtension.this.mCallbackMap.forEach((cb, ex) -> this.handleVoidCallback((Object)new ReceiverWrapper(NfcOemExtension.this, isSkipped), cb::onApplyRouting, (Executor)ex));
        }

        @Override
        public void onNdefRead(ResultReceiver isSkipped) throws RemoteException {
            NfcOemExtension.this.mCallbackMap.forEach((cb, ex) -> this.handleVoidCallback((Object)new ReceiverWrapper(NfcOemExtension.this, isSkipped), cb::onNdefRead, (Executor)ex));
        }

        @Override
        public void onEnable(ResultReceiver isAllowed) throws RemoteException {
            NfcOemExtension.this.mCallbackMap.forEach((cb, ex) -> this.handleVoidCallback((Object)new ReceiverWrapper(NfcOemExtension.this, isAllowed), cb::onEnableRequested, (Executor)ex));
        }

        @Override
        public void onDisable(ResultReceiver isAllowed) throws RemoteException {
            NfcOemExtension.this.mCallbackMap.forEach((cb, ex) -> this.handleVoidCallback((Object)new ReceiverWrapper(NfcOemExtension.this, isAllowed), cb::onDisableRequested, (Executor)ex));
        }

        @Override
        public void onBootStarted() throws RemoteException {
            NfcOemExtension.this.mCallbackMap.forEach((cb, ex) -> this.handleVoidCallback(null, input -> cb.onBootStarted(), (Executor)ex));
        }

        @Override
        public void onEnableStarted() throws RemoteException {
            NfcOemExtension.this.mCallbackMap.forEach((cb, ex) -> this.handleVoidCallback(null, input -> cb.onEnableStarted(), (Executor)ex));
        }

        @Override
        public void onDisableStarted() throws RemoteException {
            NfcOemExtension.this.mCallbackMap.forEach((cb, ex) -> this.handleVoidCallback(null, input -> cb.onDisableStarted(), (Executor)ex));
        }

        @Override
        public void onBootFinished(int status) throws RemoteException {
            NfcOemExtension.this.mCallbackMap.forEach((cb, ex) -> this.handleVoidCallback(status, cb::onBootFinished, (Executor)ex));
        }

        @Override
        public void onEnableFinished(int status) throws RemoteException {
            NfcOemExtension.this.mCallbackMap.forEach((cb, ex) -> this.handleVoidCallback(status, cb::onEnableFinished, (Executor)ex));
        }

        @Override
        public void onDisableFinished(int status) throws RemoteException {
            NfcOemExtension.this.mCallbackMap.forEach((cb, ex) -> this.handleVoidCallback(status, cb::onDisableFinished, (Executor)ex));
        }

        @Override
        public void onTagDispatch(ResultReceiver isSkipped) throws RemoteException {
            NfcOemExtension.this.mCallbackMap.forEach((cb, ex) -> this.handleVoidCallback((Object)new ReceiverWrapper(NfcOemExtension.this, isSkipped), cb::onTagDispatch, (Executor)ex));
        }

        @Override
        public void onRoutingChanged(ResultReceiver isSkipped) throws RemoteException {
            NfcOemExtension.this.mCallbackMap.forEach((cb, ex) -> this.handleVoidCallback((Object)new ReceiverWrapper(NfcOemExtension.this, isSkipped), cb::onRoutingChanged, (Executor)ex));
        }

        @Override
        public void onHceEventReceived(int action) throws RemoteException {
            NfcOemExtension.this.mCallbackMap.forEach((cb, ex) -> this.handleVoidCallback(action, cb::onHceEventReceived, (Executor)ex));
        }

        @Override
        public void onReaderOptionChanged(boolean enabled) throws RemoteException {
            NfcOemExtension.this.mCallbackMap.forEach((cb, ex) -> this.handleVoidCallback(enabled, cb::onReaderOptionChanged, (Executor)ex));
        }

        @Override
        public void onRoutingTableFull() throws RemoteException {
            NfcOemExtension.this.mCallbackMap.forEach((cb, ex) -> this.handleVoidCallback(null, input -> cb.onRoutingTableFull(), (Executor)ex));
        }

        @Override
        public void onGetOemAppSearchIntent(List<String> packages, ResultReceiver intentConsumer) throws RemoteException {
            NfcOemExtension.this.mCallbackMap.forEach((cb, ex) -> this.handleVoid2ArgCallback((Object)packages, (Object)new ReceiverWrapper(NfcOemExtension.this, intentConsumer), cb::onGetOemAppSearchIntent, (Executor)ex));
        }

        @Override
        public void onNdefMessage(Tag tag, NdefMessage message, ResultReceiver hasOemExecutableContent) throws RemoteException {
            NfcOemExtension.this.mCallbackMap.forEach((cb, ex) -> {
                Object object = NfcOemExtension.this.mLock;
                synchronized (object) {
                    long identity = Binder.clearCallingIdentity();
                    try {
                        ex.execute(() -> cb.onNdefMessage(tag, message, new ReceiverWrapper<Boolean>(NfcOemExtension.this, hasOemExecutableContent)));
                    }
                    catch (RuntimeException exception) {
                        throw exception;
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                }
            });
        }

        @Override
        public void onLaunchHceAppChooserActivity(String selectedAid, List<ApduServiceInfo> services, ComponentName failedComponent, String category) throws RemoteException {
            NfcOemExtension.this.mCallbackMap.forEach((cb, ex) -> {
                Object object = NfcOemExtension.this.mLock;
                synchronized (object) {
                    long identity = Binder.clearCallingIdentity();
                    try {
                        ex.execute(() -> cb.onLaunchHceAppChooserActivity(selectedAid, services, failedComponent, category));
                    }
                    catch (RuntimeException exception) {
                        throw exception;
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                }
            });
        }

        @Override
        public void onLaunchHceTapAgainActivity(ApduServiceInfo service, String category) throws RemoteException {
            NfcOemExtension.this.mCallbackMap.forEach((cb, ex) -> this.handleVoid2ArgCallback((Object)service, (Object)category, cb::onLaunchHceTapAgainDialog, (Executor)ex));
        }

        @Override
        public void onLogEventNotified(OemLogItems item) throws RemoteException {
            NfcOemExtension.this.mCallbackMap.forEach((cb, ex) -> this.handleVoidCallback((Object)item, cb::onLogEventNotified, (Executor)ex));
        }

        @Override
        public void onExtractOemPackages(NdefMessage message, ResultReceiver packageConsumer) throws RemoteException {
            NfcOemExtension.this.mCallbackMap.forEach((cb, ex) -> this.handleVoid2ArgCallback((Object)message, (Object)new ReceiverWrapper(NfcOemExtension.this, packageConsumer), cb::onExtractOemPackages, (Executor)ex));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> void handleVoidCallback(T input, Consumer<T> callbackMethod, Executor executor) {
            Object object = NfcOemExtension.this.mLock;
            synchronized (object) {
                long identity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> callbackMethod.accept(input));
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T1, T2> void handleVoid2ArgCallback(T1 input1, T2 input2, BiConsumer<T1, T2> callbackMethod, Executor executor) {
            Object object = NfcOemExtension.this.mLock;
            synchronized (object) {
                long identity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> callbackMethod.accept(input1, input2));
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <S, T> S handleNonVoidCallbackWithInput(S defaultValue, T input, Function<T, S> callbackMethod) throws RemoteException {
            Object object = NfcOemExtension.this.mLock;
            synchronized (object) {
                long identity = Binder.clearCallingIdentity();
                Object result = defaultValue;
                try {
                    ExecutorService executor = Executors.newSingleThreadExecutor();
                    FutureTask<Object> futureTask = new FutureTask<Object>(() -> callbackMethod.apply(input));
                    Future<?> unused = executor.submit(futureTask);
                    try {
                        result = futureTask.get(2000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException | ExecutionException e) {
                        e.printStackTrace();
                    }
                    catch (TimeoutException e) {
                        Log.w(NfcOemExtension.TAG, "Callback timed out: " + callbackMethod);
                        e.printStackTrace();
                    }
                    finally {
                        executor.shutdown();
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> T handleNonVoidCallbackWithoutInput(T defaultValue, Supplier<T> callbackMethod) throws RemoteException {
            Object object = NfcOemExtension.this.mLock;
            synchronized (object) {
                long identity = Binder.clearCallingIdentity();
                Object result = defaultValue;
                try {
                    ExecutorService executor = Executors.newSingleThreadExecutor();
                    FutureTask<Object> futureTask = new FutureTask<Object>(callbackMethod::get);
                    Future<?> unused = executor.submit(futureTask);
                    try {
                        result = futureTask.get(2000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException | ExecutionException e) {
                        e.printStackTrace();
                    }
                    catch (TimeoutException e) {
                        Log.w(NfcOemExtension.TAG, "Callback timed out: " + callbackMethod);
                        e.printStackTrace();
                    }
                    finally {
                        executor.shutdown();
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
                return result;
            }
        }
    }

    public static interface Callback {
        public void onTagConnected(boolean var1);

        public void onStateUpdated(int var1);

        public void onApplyRouting(@NonNull Consumer<Boolean> var1);

        public void onNdefRead(@NonNull Consumer<Boolean> var1);

        public void onEnableRequested(@NonNull Consumer<Boolean> var1);

        public void onDisableRequested(@NonNull Consumer<Boolean> var1);

        public void onBootStarted();

        public void onEnableStarted();

        public void onDisableStarted();

        public void onBootFinished(int var1);

        public void onEnableFinished(int var1);

        public void onDisableFinished(int var1);

        public void onTagDispatch(@NonNull Consumer<Boolean> var1);

        public void onRoutingChanged(@NonNull Consumer<Boolean> var1);

        public void onHceEventReceived(int var1);

        public void onReaderOptionChanged(boolean var1);

        public void onCardEmulationActivated(boolean var1);

        public void onRfFieldDetected(boolean var1);

        public void onRfDiscoveryStarted(boolean var1);

        public void onEeListenActivated(boolean var1);

        public void onEeUpdated();

        public void onGetOemAppSearchIntent(@NonNull List<String> var1, @NonNull Consumer<Intent> var2);

        public void onNdefMessage(@NonNull Tag var1, @NonNull NdefMessage var2, @NonNull Consumer<Boolean> var3);

        public void onLaunchHceAppChooserActivity(@NonNull String var1, @NonNull List<ApduServiceInfo> var2, @NonNull ComponentName var3, @NonNull String var4);

        public void onLaunchHceTapAgainDialog(@NonNull ApduServiceInfo var1, @NonNull String var2);

        public void onRoutingTableFull();

        public void onLogEventNotified(@NonNull OemLogItems var1);

        public void onExtractOemPackages(@NonNull NdefMessage var1, @NonNull Consumer<List<String>> var2);
    }

    private class ReceiverWrapper<T>
    implements Consumer<T> {
        private final ResultReceiver mResultReceiver;

        ReceiverWrapper(NfcOemExtension nfcOemExtension, ResultReceiver resultReceiver) {
            this.mResultReceiver = resultReceiver;
        }

        @Override
        public void accept(T result) {
            if (result instanceof Boolean) {
                this.mResultReceiver.send((Boolean)result != false ? 1 : 0, null);
            } else if (result instanceof Intent) {
                Bundle bundle = new Bundle();
                bundle.putParcelable("intent", (Intent)result);
                this.mResultReceiver.send(0, bundle);
            } else if (result instanceof List) {
                List list = (List)result;
                if (list.stream().allMatch(String.class::isInstance)) {
                    Bundle bundle = new Bundle();
                    bundle.putStringArray("packageNames", (String[])list.stream().map(pkg -> (String)pkg).toArray(String[]::new));
                    this.mResultReceiver.send(0, bundle);
                }
            }
        }

        @Override
        public Consumer<T> andThen(Consumer<? super T> after) {
            return Consumer.super.andThen(after);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CommitRoutingStatusCode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StatusCode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PollingStateChangeStatusCode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HostCardEmulationAction {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NfceeTechnology {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ControllerMode {
    }
}

