/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.annotation.RequiresPermission;
import android.app.PendingIntent;
import android.content.IntentFilter;
import android.nfc.Entry;
import android.nfc.IAppCallback;
import android.nfc.INfcAdapterExtras;
import android.nfc.INfcCardEmulation;
import android.nfc.INfcControllerAlwaysOnListener;
import android.nfc.INfcDta;
import android.nfc.INfcFCardEmulation;
import android.nfc.INfcOemExtensionCallback;
import android.nfc.INfcTag;
import android.nfc.INfcUnlockHandler;
import android.nfc.INfcVendorNciCallback;
import android.nfc.INfcWlcStateListener;
import android.nfc.IT4tNdefNfcee;
import android.nfc.ITagRemovedCallback;
import android.nfc.NfcAntennaInfo;
import android.nfc.Tag;
import android.nfc.TechListParcel;
import android.nfc.WlcListenerDeviceInfo;
import android.nfc.cardemulation.PollingFrame;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface INfcAdapter
extends IInterface {
    public INfcTag getNfcTagInterface() throws RemoteException;

    public INfcCardEmulation getNfcCardEmulationInterface() throws RemoteException;

    public INfcFCardEmulation getNfcFCardEmulationInterface() throws RemoteException;

    public INfcAdapterExtras getNfcAdapterExtrasInterface(String var1) throws RemoteException;

    public INfcDta getNfcDtaInterface(String var1) throws RemoteException;

    public int getState() throws RemoteException;

    public boolean disable(boolean var1, String var2) throws RemoteException;

    public boolean enable(String var1) throws RemoteException;

    public int pausePolling(long var1) throws RemoteException;

    public int resumePolling() throws RemoteException;

    public void setForegroundDispatch(PendingIntent var1, IntentFilter[] var2, TechListParcel var3) throws RemoteException;

    public void setAppCallback(IAppCallback var1) throws RemoteException;

    public boolean ignore(int var1, int var2, ITagRemovedCallback var3) throws RemoteException;

    public void dispatch(Tag var1) throws RemoteException;

    public void setReaderMode(IBinder var1, IAppCallback var2, int var3, Bundle var4, String var5) throws RemoteException;

    public void addNfcUnlockHandler(INfcUnlockHandler var1, int[] var2) throws RemoteException;

    public void removeNfcUnlockHandler(INfcUnlockHandler var1) throws RemoteException;

    public void verifyNfcPermission() throws RemoteException;

    public boolean isNfcSecureEnabled() throws RemoteException;

    public boolean deviceSupportsNfcSecure() throws RemoteException;

    public boolean setNfcSecure(boolean var1) throws RemoteException;

    public NfcAntennaInfo getNfcAntennaInfo() throws RemoteException;

    public void setControllerAlwaysOn(int var1) throws RemoteException;

    public boolean isControllerAlwaysOn() throws RemoteException;

    public boolean isControllerAlwaysOnSupported() throws RemoteException;

    public void registerControllerAlwaysOnListener(INfcControllerAlwaysOnListener var1) throws RemoteException;

    public void unregisterControllerAlwaysOnListener(INfcControllerAlwaysOnListener var1) throws RemoteException;

    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public boolean isTagIntentAppPreferenceSupported() throws RemoteException;

    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public Map getTagIntentAppPreferenceForUser(int var1) throws RemoteException;

    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public int setTagIntentAppPreferenceForUser(int var1, String var2, boolean var3) throws RemoteException;

    public boolean isReaderOptionEnabled() throws RemoteException;

    public boolean isReaderOptionSupported() throws RemoteException;

    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public boolean enableReaderOption(boolean var1, String var2) throws RemoteException;

    public boolean isReaderModeAnnotationSupported() throws RemoteException;

    public boolean isObserveModeSupported() throws RemoteException;

    public boolean isObserveModeEnabled() throws RemoteException;

    public boolean setObserveMode(boolean var1, String var2) throws RemoteException;

    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public boolean setWlcEnabled(boolean var1) throws RemoteException;

    public boolean isWlcEnabled() throws RemoteException;

    public void registerWlcStateListener(INfcWlcStateListener var1) throws RemoteException;

    public void unregisterWlcStateListener(INfcWlcStateListener var1) throws RemoteException;

    public WlcListenerDeviceInfo getWlcListenerDeviceInfo() throws RemoteException;

    public void updateDiscoveryTechnology(IBinder var1, int var2, int var3, String var4) throws RemoteException;

    public void notifyPollingLoop(PollingFrame var1) throws RemoteException;

    public void notifyHceDeactivated() throws RemoteException;

    public void notifyTestHceData(int var1, byte[] var2) throws RemoteException;

    public int sendVendorNciMessage(int var1, int var2, int var3, byte[] var4) throws RemoteException;

    public void registerVendorExtensionCallback(INfcVendorNciCallback var1) throws RemoteException;

    public void unregisterVendorExtensionCallback(INfcVendorNciCallback var1) throws RemoteException;

    public void registerOemExtensionCallback(INfcOemExtensionCallback var1) throws RemoteException;

    public void unregisterOemExtensionCallback(INfcOemExtensionCallback var1) throws RemoteException;

    public void clearPreference() throws RemoteException;

    public void setScreenState() throws RemoteException;

    public void checkFirmware() throws RemoteException;

    public Map fetchActiveNfceeList() throws RemoteException;

    public void triggerInitialization() throws RemoteException;

    public boolean getSettingStatus() throws RemoteException;

    public boolean isTagPresent() throws RemoteException;

    public List<Entry> getRoutingTableEntryList() throws RemoteException;

    public void indicateDataMigration(boolean var1, String var2) throws RemoteException;

    public int commitRouting() throws RemoteException;

    public boolean isTagIntentAllowed(String var1, int var2) throws RemoteException;

    public IT4tNdefNfcee getT4tNdefNfceeInterface() throws RemoteException;

    public long getMaxPausePollingTimeoutMs() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INfcAdapter {
        public static final String DESCRIPTOR = "android.nfc.INfcAdapter";
        static final int TRANSACTION_getNfcTagInterface = 1;
        static final int TRANSACTION_getNfcCardEmulationInterface = 2;
        static final int TRANSACTION_getNfcFCardEmulationInterface = 3;
        static final int TRANSACTION_getNfcAdapterExtrasInterface = 4;
        static final int TRANSACTION_getNfcDtaInterface = 5;
        static final int TRANSACTION_getState = 6;
        static final int TRANSACTION_disable = 7;
        static final int TRANSACTION_enable = 8;
        static final int TRANSACTION_pausePolling = 9;
        static final int TRANSACTION_resumePolling = 10;
        static final int TRANSACTION_setForegroundDispatch = 11;
        static final int TRANSACTION_setAppCallback = 12;
        static final int TRANSACTION_ignore = 13;
        static final int TRANSACTION_dispatch = 14;
        static final int TRANSACTION_setReaderMode = 15;
        static final int TRANSACTION_addNfcUnlockHandler = 16;
        static final int TRANSACTION_removeNfcUnlockHandler = 17;
        static final int TRANSACTION_verifyNfcPermission = 18;
        static final int TRANSACTION_isNfcSecureEnabled = 19;
        static final int TRANSACTION_deviceSupportsNfcSecure = 20;
        static final int TRANSACTION_setNfcSecure = 21;
        static final int TRANSACTION_getNfcAntennaInfo = 22;
        static final int TRANSACTION_setControllerAlwaysOn = 23;
        static final int TRANSACTION_isControllerAlwaysOn = 24;
        static final int TRANSACTION_isControllerAlwaysOnSupported = 25;
        static final int TRANSACTION_registerControllerAlwaysOnListener = 26;
        static final int TRANSACTION_unregisterControllerAlwaysOnListener = 27;
        static final int TRANSACTION_isTagIntentAppPreferenceSupported = 28;
        static final int TRANSACTION_getTagIntentAppPreferenceForUser = 29;
        static final int TRANSACTION_setTagIntentAppPreferenceForUser = 30;
        static final int TRANSACTION_isReaderOptionEnabled = 31;
        static final int TRANSACTION_isReaderOptionSupported = 32;
        static final int TRANSACTION_enableReaderOption = 33;
        static final int TRANSACTION_isReaderModeAnnotationSupported = 34;
        static final int TRANSACTION_isObserveModeSupported = 35;
        static final int TRANSACTION_isObserveModeEnabled = 36;
        static final int TRANSACTION_setObserveMode = 37;
        static final int TRANSACTION_setWlcEnabled = 38;
        static final int TRANSACTION_isWlcEnabled = 39;
        static final int TRANSACTION_registerWlcStateListener = 40;
        static final int TRANSACTION_unregisterWlcStateListener = 41;
        static final int TRANSACTION_getWlcListenerDeviceInfo = 42;
        static final int TRANSACTION_updateDiscoveryTechnology = 43;
        static final int TRANSACTION_notifyPollingLoop = 44;
        static final int TRANSACTION_notifyHceDeactivated = 45;
        static final int TRANSACTION_notifyTestHceData = 46;
        static final int TRANSACTION_sendVendorNciMessage = 47;
        static final int TRANSACTION_registerVendorExtensionCallback = 48;
        static final int TRANSACTION_unregisterVendorExtensionCallback = 49;
        static final int TRANSACTION_registerOemExtensionCallback = 50;
        static final int TRANSACTION_unregisterOemExtensionCallback = 51;
        static final int TRANSACTION_clearPreference = 52;
        static final int TRANSACTION_setScreenState = 53;
        static final int TRANSACTION_checkFirmware = 54;
        static final int TRANSACTION_fetchActiveNfceeList = 55;
        static final int TRANSACTION_triggerInitialization = 56;
        static final int TRANSACTION_getSettingStatus = 57;
        static final int TRANSACTION_isTagPresent = 58;
        static final int TRANSACTION_getRoutingTableEntryList = 59;
        static final int TRANSACTION_indicateDataMigration = 60;
        static final int TRANSACTION_commitRouting = 61;
        static final int TRANSACTION_isTagIntentAllowed = 62;
        static final int TRANSACTION_getT4tNdefNfceeInterface = 63;
        static final int TRANSACTION_getMaxPausePollingTimeoutMs = 64;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static INfcAdapter asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof INfcAdapter) {
                return (INfcAdapter)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getNfcTagInterface";
                }
                case 2: {
                    return "getNfcCardEmulationInterface";
                }
                case 3: {
                    return "getNfcFCardEmulationInterface";
                }
                case 4: {
                    return "getNfcAdapterExtrasInterface";
                }
                case 5: {
                    return "getNfcDtaInterface";
                }
                case 6: {
                    return "getState";
                }
                case 7: {
                    return "disable";
                }
                case 8: {
                    return "enable";
                }
                case 9: {
                    return "pausePolling";
                }
                case 10: {
                    return "resumePolling";
                }
                case 11: {
                    return "setForegroundDispatch";
                }
                case 12: {
                    return "setAppCallback";
                }
                case 13: {
                    return "ignore";
                }
                case 14: {
                    return "dispatch";
                }
                case 15: {
                    return "setReaderMode";
                }
                case 16: {
                    return "addNfcUnlockHandler";
                }
                case 17: {
                    return "removeNfcUnlockHandler";
                }
                case 18: {
                    return "verifyNfcPermission";
                }
                case 19: {
                    return "isNfcSecureEnabled";
                }
                case 20: {
                    return "deviceSupportsNfcSecure";
                }
                case 21: {
                    return "setNfcSecure";
                }
                case 22: {
                    return "getNfcAntennaInfo";
                }
                case 23: {
                    return "setControllerAlwaysOn";
                }
                case 24: {
                    return "isControllerAlwaysOn";
                }
                case 25: {
                    return "isControllerAlwaysOnSupported";
                }
                case 26: {
                    return "registerControllerAlwaysOnListener";
                }
                case 27: {
                    return "unregisterControllerAlwaysOnListener";
                }
                case 28: {
                    return "isTagIntentAppPreferenceSupported";
                }
                case 29: {
                    return "getTagIntentAppPreferenceForUser";
                }
                case 30: {
                    return "setTagIntentAppPreferenceForUser";
                }
                case 31: {
                    return "isReaderOptionEnabled";
                }
                case 32: {
                    return "isReaderOptionSupported";
                }
                case 33: {
                    return "enableReaderOption";
                }
                case 34: {
                    return "isReaderModeAnnotationSupported";
                }
                case 35: {
                    return "isObserveModeSupported";
                }
                case 36: {
                    return "isObserveModeEnabled";
                }
                case 37: {
                    return "setObserveMode";
                }
                case 38: {
                    return "setWlcEnabled";
                }
                case 39: {
                    return "isWlcEnabled";
                }
                case 40: {
                    return "registerWlcStateListener";
                }
                case 41: {
                    return "unregisterWlcStateListener";
                }
                case 42: {
                    return "getWlcListenerDeviceInfo";
                }
                case 43: {
                    return "updateDiscoveryTechnology";
                }
                case 44: {
                    return "notifyPollingLoop";
                }
                case 45: {
                    return "notifyHceDeactivated";
                }
                case 46: {
                    return "notifyTestHceData";
                }
                case 47: {
                    return "sendVendorNciMessage";
                }
                case 48: {
                    return "registerVendorExtensionCallback";
                }
                case 49: {
                    return "unregisterVendorExtensionCallback";
                }
                case 50: {
                    return "registerOemExtensionCallback";
                }
                case 51: {
                    return "unregisterOemExtensionCallback";
                }
                case 52: {
                    return "clearPreference";
                }
                case 53: {
                    return "setScreenState";
                }
                case 54: {
                    return "checkFirmware";
                }
                case 55: {
                    return "fetchActiveNfceeList";
                }
                case 56: {
                    return "triggerInitialization";
                }
                case 57: {
                    return "getSettingStatus";
                }
                case 58: {
                    return "isTagPresent";
                }
                case 59: {
                    return "getRoutingTableEntryList";
                }
                case 60: {
                    return "indicateDataMigration";
                }
                case 61: {
                    return "commitRouting";
                }
                case 62: {
                    return "isTagIntentAllowed";
                }
                case 63: {
                    return "getT4tNdefNfceeInterface";
                }
                case 64: {
                    return "getMaxPausePollingTimeoutMs";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    INfcTag _result = this.getNfcTagInterface();
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 2: {
                    INfcCardEmulation _result = this.getNfcCardEmulationInterface();
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 3: {
                    INfcFCardEmulation _result = this.getNfcFCardEmulationInterface();
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    INfcAdapterExtras _result = this.getNfcAdapterExtrasInterface(_arg0);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    INfcDta _result = this.getNfcDtaInterface(_arg0);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 6: {
                    int _result = this.getState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 7: {
                    boolean _arg0 = data.readBoolean();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.disable(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.enable(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 9: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    int _result = this.pausePolling(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 10: {
                    int _result = this.resumePolling();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 11: {
                    PendingIntent _arg0 = data.readTypedObject(PendingIntent.CREATOR);
                    IntentFilter[] _arg1 = data.createTypedArray(IntentFilter.CREATOR);
                    TechListParcel _arg2 = data.readTypedObject(TechListParcel.CREATOR);
                    data.enforceNoDataAvail();
                    this.setForegroundDispatch(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    IAppCallback _arg0 = IAppCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setAppCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    ITagRemovedCallback _arg2 = ITagRemovedCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.ignore(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 14: {
                    Tag _arg0 = data.readTypedObject(Tag.CREATOR);
                    data.enforceNoDataAvail();
                    this.dispatch(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    IBinder _arg0 = data.readStrongBinder();
                    IAppCallback _arg1 = IAppCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg2 = data.readInt();
                    Bundle _arg3 = data.readTypedObject(Bundle.CREATOR);
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.setReaderMode(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    INfcUnlockHandler _arg0 = INfcUnlockHandler.Stub.asInterface(data.readStrongBinder());
                    int[] _arg1 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.addNfcUnlockHandler(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    INfcUnlockHandler _arg0 = INfcUnlockHandler.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeNfcUnlockHandler(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    this.verifyNfcPermission();
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    boolean _result = this.isNfcSecureEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 20: {
                    boolean _result = this.deviceSupportsNfcSecure();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 21: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.setNfcSecure(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 22: {
                    NfcAntennaInfo _result = this.getNfcAntennaInfo();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 23: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setControllerAlwaysOn(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    boolean _result = this.isControllerAlwaysOn();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 25: {
                    boolean _result = this.isControllerAlwaysOnSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 26: {
                    INfcControllerAlwaysOnListener _arg0 = INfcControllerAlwaysOnListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerControllerAlwaysOnListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 27: {
                    INfcControllerAlwaysOnListener _arg0 = INfcControllerAlwaysOnListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterControllerAlwaysOnListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    boolean _result = this.isTagIntentAppPreferenceSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 29: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    Map _result = this.getTagIntentAppPreferenceForUser(_arg0);
                    reply.writeNoException();
                    reply.writeMap(_result);
                    break;
                }
                case 30: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    int _result = this.setTagIntentAppPreferenceForUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 31: {
                    boolean _result = this.isReaderOptionEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 32: {
                    boolean _result = this.isReaderOptionSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 33: {
                    boolean _arg0 = data.readBoolean();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.enableReaderOption(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 34: {
                    boolean _result = this.isReaderModeAnnotationSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 35: {
                    boolean _result = this.isObserveModeSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 36: {
                    boolean _result = this.isObserveModeEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 37: {
                    boolean _arg0 = data.readBoolean();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.setObserveMode(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 38: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.setWlcEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 39: {
                    boolean _result = this.isWlcEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 40: {
                    INfcWlcStateListener _arg0 = INfcWlcStateListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerWlcStateListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 41: {
                    INfcWlcStateListener _arg0 = INfcWlcStateListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterWlcStateListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 42: {
                    WlcListenerDeviceInfo _result = this.getWlcListenerDeviceInfo();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 43: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.updateDiscoveryTechnology(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 44: {
                    PollingFrame _arg0 = data.readTypedObject(PollingFrame.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyPollingLoop(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 45: {
                    this.notifyHceDeactivated();
                    reply.writeNoException();
                    break;
                }
                case 46: {
                    int _arg0 = data.readInt();
                    byte[] _arg1 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.notifyTestHceData(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 47: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    byte[] _arg3 = data.createByteArray();
                    data.enforceNoDataAvail();
                    int _result = this.sendVendorNciMessage(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 48: {
                    INfcVendorNciCallback _arg0 = INfcVendorNciCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerVendorExtensionCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 49: {
                    INfcVendorNciCallback _arg0 = INfcVendorNciCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterVendorExtensionCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 50: {
                    INfcOemExtensionCallback _arg0 = INfcOemExtensionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerOemExtensionCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 51: {
                    INfcOemExtensionCallback _arg0 = INfcOemExtensionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterOemExtensionCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 52: {
                    this.clearPreference();
                    reply.writeNoException();
                    break;
                }
                case 53: {
                    this.setScreenState();
                    reply.writeNoException();
                    break;
                }
                case 54: {
                    this.checkFirmware();
                    reply.writeNoException();
                    break;
                }
                case 55: {
                    Map _result = this.fetchActiveNfceeList();
                    reply.writeNoException();
                    reply.writeMap(_result);
                    break;
                }
                case 56: {
                    this.triggerInitialization();
                    reply.writeNoException();
                    break;
                }
                case 57: {
                    boolean _result = this.getSettingStatus();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 58: {
                    boolean _result = this.isTagPresent();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 59: {
                    List<Entry> _result = this.getRoutingTableEntryList();
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 60: {
                    boolean _arg0 = data.readBoolean();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.indicateDataMigration(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 61: {
                    int _result = this.commitRouting();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 62: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isTagIntentAllowed(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 63: {
                    IT4tNdefNfcee _result = this.getT4tNdefNfceeInterface();
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 64: {
                    long _result = this.getMaxPausePollingTimeoutMs();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 63;
        }

        private static class Proxy
        implements INfcAdapter {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public INfcTag getNfcTagInterface() throws RemoteException {
                INfcTag _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = INfcTag.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public INfcCardEmulation getNfcCardEmulationInterface() throws RemoteException {
                INfcCardEmulation _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = INfcCardEmulation.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public INfcFCardEmulation getNfcFCardEmulationInterface() throws RemoteException {
                INfcFCardEmulation _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = INfcFCardEmulation.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public INfcAdapterExtras getNfcAdapterExtrasInterface(String pkg) throws RemoteException {
                INfcAdapterExtras _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = INfcAdapterExtras.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public INfcDta getNfcDtaInterface(String pkg) throws RemoteException {
                INfcDta _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = INfcDta.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean disable(boolean saveState, String pkg) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(saveState);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean enable(String pkg) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int pausePolling(long timeoutInMs) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(timeoutInMs);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int resumePolling() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setForegroundDispatch(PendingIntent intent, IntentFilter[] filters, TechListParcel techLists) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(intent, 0);
                    _data.writeTypedArray(filters, 0);
                    _data.writeTypedObject(techLists, 0);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAppCallback(IAppCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean ignore(int nativeHandle, int debounceMs, ITagRemovedCallback callback) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(nativeHandle);
                    _data.writeInt(debounceMs);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatch(Tag tag) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(tag, 0);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setReaderMode(IBinder b, IAppCallback callback, int flags, Bundle extras, String pkg) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(b);
                    _data.writeStrongInterface(callback);
                    _data.writeInt(flags);
                    _data.writeTypedObject(extras, 0);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addNfcUnlockHandler(INfcUnlockHandler unlockHandler, int[] techList) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(unlockHandler);
                    _data.writeIntArray(techList);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeNfcUnlockHandler(INfcUnlockHandler unlockHandler) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(unlockHandler);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void verifyNfcPermission() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isNfcSecureEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean deviceSupportsNfcSecure() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setNfcSecure(boolean enable) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enable);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NfcAntennaInfo getNfcAntennaInfo() throws RemoteException {
                NfcAntennaInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(NfcAntennaInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setControllerAlwaysOn(int mode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(mode);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isControllerAlwaysOn() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isControllerAlwaysOnSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerControllerAlwaysOnListener(INfcControllerAlwaysOnListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterControllerAlwaysOnListener(INfcControllerAlwaysOnListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isTagIntentAppPreferenceSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map getTagIntentAppPreferenceForUser(int userId) throws RemoteException {
                HashMap _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readHashMap(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setTagIntentAppPreferenceForUser(int userId, String pkg, boolean allow) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(pkg);
                    _data.writeBoolean(allow);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isReaderOptionEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isReaderOptionSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean enableReaderOption(boolean enable, String pkg) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enable);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isReaderModeAnnotationSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isObserveModeSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isObserveModeEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setObserveMode(boolean enabled, String pkg) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setWlcEnabled(boolean enable) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enable);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isWlcEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerWlcStateListener(INfcWlcStateListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterWlcStateListener(INfcWlcStateListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WlcListenerDeviceInfo getWlcListenerDeviceInfo() throws RemoteException {
                WlcListenerDeviceInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(WlcListenerDeviceInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateDiscoveryTechnology(IBinder b, int pollFlags, int listenFlags, String pkg) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(b);
                    _data.writeInt(pollFlags);
                    _data.writeInt(listenFlags);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyPollingLoop(PollingFrame frame) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(frame, 0);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyHceDeactivated() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyTestHceData(int technology, byte[] data) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(technology);
                    _data.writeByteArray(data);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int sendVendorNciMessage(int mt, int gid, int oid, byte[] payload) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(mt);
                    _data.writeInt(gid);
                    _data.writeInt(oid);
                    _data.writeByteArray(payload);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerVendorExtensionCallback(INfcVendorNciCallback callbacks) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callbacks);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterVendorExtensionCallback(INfcVendorNciCallback callbacks) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callbacks);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerOemExtensionCallback(INfcOemExtensionCallback callbacks) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callbacks);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterOemExtensionCallback(INfcOemExtensionCallback callbacks) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callbacks);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearPreference() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setScreenState() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void checkFirmware() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map fetchActiveNfceeList() throws RemoteException {
                HashMap _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readHashMap(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void triggerInitialization() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(56, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean getSettingStatus() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(57, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isTagPresent() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(58, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Entry> getRoutingTableEntryList() throws RemoteException {
                ArrayList<Entry> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(59, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(Entry.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void indicateDataMigration(boolean inProgress, String pkg) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(inProgress);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(60, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int commitRouting() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(61, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isTagIntentAllowed(String pkg, int Userid) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(Userid);
                    boolean _status = this.mRemote.transact(62, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IT4tNdefNfcee getT4tNdefNfceeInterface() throws RemoteException {
                IT4tNdefNfcee _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(63, _data, _reply, 0);
                    _reply.readException();
                    _result = IT4tNdefNfcee.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getMaxPausePollingTimeoutMs() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(64, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements INfcAdapter {
        @Override
        public INfcTag getNfcTagInterface() throws RemoteException {
            return null;
        }

        @Override
        public INfcCardEmulation getNfcCardEmulationInterface() throws RemoteException {
            return null;
        }

        @Override
        public INfcFCardEmulation getNfcFCardEmulationInterface() throws RemoteException {
            return null;
        }

        @Override
        public INfcAdapterExtras getNfcAdapterExtrasInterface(String pkg) throws RemoteException {
            return null;
        }

        @Override
        public INfcDta getNfcDtaInterface(String pkg) throws RemoteException {
            return null;
        }

        @Override
        public int getState() throws RemoteException {
            return 0;
        }

        @Override
        public boolean disable(boolean saveState, String pkg) throws RemoteException {
            return false;
        }

        @Override
        public boolean enable(String pkg) throws RemoteException {
            return false;
        }

        @Override
        public int pausePolling(long timeoutInMs) throws RemoteException {
            return 0;
        }

        @Override
        public int resumePolling() throws RemoteException {
            return 0;
        }

        @Override
        public void setForegroundDispatch(PendingIntent intent, IntentFilter[] filters, TechListParcel techLists) throws RemoteException {
        }

        @Override
        public void setAppCallback(IAppCallback callback) throws RemoteException {
        }

        @Override
        public boolean ignore(int nativeHandle, int debounceMs, ITagRemovedCallback callback) throws RemoteException {
            return false;
        }

        @Override
        public void dispatch(Tag tag) throws RemoteException {
        }

        @Override
        public void setReaderMode(IBinder b, IAppCallback callback, int flags, Bundle extras, String pkg) throws RemoteException {
        }

        @Override
        public void addNfcUnlockHandler(INfcUnlockHandler unlockHandler, int[] techList) throws RemoteException {
        }

        @Override
        public void removeNfcUnlockHandler(INfcUnlockHandler unlockHandler) throws RemoteException {
        }

        @Override
        public void verifyNfcPermission() throws RemoteException {
        }

        @Override
        public boolean isNfcSecureEnabled() throws RemoteException {
            return false;
        }

        @Override
        public boolean deviceSupportsNfcSecure() throws RemoteException {
            return false;
        }

        @Override
        public boolean setNfcSecure(boolean enable) throws RemoteException {
            return false;
        }

        @Override
        public NfcAntennaInfo getNfcAntennaInfo() throws RemoteException {
            return null;
        }

        @Override
        public void setControllerAlwaysOn(int mode) throws RemoteException {
        }

        @Override
        public boolean isControllerAlwaysOn() throws RemoteException {
            return false;
        }

        @Override
        public boolean isControllerAlwaysOnSupported() throws RemoteException {
            return false;
        }

        @Override
        public void registerControllerAlwaysOnListener(INfcControllerAlwaysOnListener listener) throws RemoteException {
        }

        @Override
        public void unregisterControllerAlwaysOnListener(INfcControllerAlwaysOnListener listener) throws RemoteException {
        }

        @Override
        public boolean isTagIntentAppPreferenceSupported() throws RemoteException {
            return false;
        }

        @Override
        public Map getTagIntentAppPreferenceForUser(int userId) throws RemoteException {
            return null;
        }

        @Override
        public int setTagIntentAppPreferenceForUser(int userId, String pkg, boolean allow) throws RemoteException {
            return 0;
        }

        @Override
        public boolean isReaderOptionEnabled() throws RemoteException {
            return false;
        }

        @Override
        public boolean isReaderOptionSupported() throws RemoteException {
            return false;
        }

        @Override
        public boolean enableReaderOption(boolean enable, String pkg) throws RemoteException {
            return false;
        }

        @Override
        public boolean isReaderModeAnnotationSupported() throws RemoteException {
            return false;
        }

        @Override
        public boolean isObserveModeSupported() throws RemoteException {
            return false;
        }

        @Override
        public boolean isObserveModeEnabled() throws RemoteException {
            return false;
        }

        @Override
        public boolean setObserveMode(boolean enabled, String pkg) throws RemoteException {
            return false;
        }

        @Override
        public boolean setWlcEnabled(boolean enable) throws RemoteException {
            return false;
        }

        @Override
        public boolean isWlcEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void registerWlcStateListener(INfcWlcStateListener listener) throws RemoteException {
        }

        @Override
        public void unregisterWlcStateListener(INfcWlcStateListener listener) throws RemoteException {
        }

        @Override
        public WlcListenerDeviceInfo getWlcListenerDeviceInfo() throws RemoteException {
            return null;
        }

        @Override
        public void updateDiscoveryTechnology(IBinder b, int pollFlags, int listenFlags, String pkg) throws RemoteException {
        }

        @Override
        public void notifyPollingLoop(PollingFrame frame) throws RemoteException {
        }

        @Override
        public void notifyHceDeactivated() throws RemoteException {
        }

        @Override
        public void notifyTestHceData(int technology, byte[] data) throws RemoteException {
        }

        @Override
        public int sendVendorNciMessage(int mt, int gid, int oid, byte[] payload) throws RemoteException {
            return 0;
        }

        @Override
        public void registerVendorExtensionCallback(INfcVendorNciCallback callbacks) throws RemoteException {
        }

        @Override
        public void unregisterVendorExtensionCallback(INfcVendorNciCallback callbacks) throws RemoteException {
        }

        @Override
        public void registerOemExtensionCallback(INfcOemExtensionCallback callbacks) throws RemoteException {
        }

        @Override
        public void unregisterOemExtensionCallback(INfcOemExtensionCallback callbacks) throws RemoteException {
        }

        @Override
        public void clearPreference() throws RemoteException {
        }

        @Override
        public void setScreenState() throws RemoteException {
        }

        @Override
        public void checkFirmware() throws RemoteException {
        }

        @Override
        public Map fetchActiveNfceeList() throws RemoteException {
            return null;
        }

        @Override
        public void triggerInitialization() throws RemoteException {
        }

        @Override
        public boolean getSettingStatus() throws RemoteException {
            return false;
        }

        @Override
        public boolean isTagPresent() throws RemoteException {
            return false;
        }

        @Override
        public List<Entry> getRoutingTableEntryList() throws RemoteException {
            return null;
        }

        @Override
        public void indicateDataMigration(boolean inProgress, String pkg) throws RemoteException {
        }

        @Override
        public int commitRouting() throws RemoteException {
            return 0;
        }

        @Override
        public boolean isTagIntentAllowed(String pkg, int Userid) throws RemoteException {
            return false;
        }

        @Override
        public IT4tNdefNfcee getT4tNdefNfceeInterface() throws RemoteException {
            return null;
        }

        @Override
        public long getMaxPausePollingTimeoutMs() throws RemoteException {
            return 0L;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

