/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.net.MacAddress;
import android.net.wifi.OuiKeyedData;
import android.net.wifi.ParcelUtil;
import android.net.wifi.p2p.WifiP2pDevice;
import android.net.wifi.util.Environment;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import com.android.wifi.x.com.android.modules.utils.build.SdkLevel;
import com.android.wifi.x.com.android.wifi.flags.Flags;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WifiP2pGroup
implements Parcelable {
    public static final int NETWORK_ID_TEMPORARY = -1;
    @UnsupportedAppUsage
    public static final int TEMPORARY_NET_ID = -1;
    public static final int NETWORK_ID_PERSISTENT = -2;
    @FlaggedApi(value="com.android.wifi.flags.wifi_direct_r2")
    public static final int SECURITY_TYPE_UNKNOWN = -1;
    @FlaggedApi(value="com.android.wifi.flags.wifi_direct_r2")
    public static final int SECURITY_TYPE_WPA2_PSK = 0;
    @FlaggedApi(value="com.android.wifi.flags.wifi_direct_r2")
    public static final int SECURITY_TYPE_WPA3_COMPATIBILITY = 1;
    @FlaggedApi(value="com.android.wifi.flags.wifi_direct_r2")
    public static final int SECURITY_TYPE_WPA3_SAE = 2;
    @UnsupportedAppUsage
    public byte[] interfaceAddress;
    private String mNetworkName;
    private WifiP2pDevice mOwner;
    private boolean mIsGroupOwner;
    private List<WifiP2pDevice> mClients = new ArrayList<WifiP2pDevice>();
    private String mPassphrase;
    private int mSecurityType;
    private String mInterface;
    private int mNetId;
    private int mFrequency;
    @NonNull
    private List<OuiKeyedData> mVendorData = Collections.emptyList();
    public P2pGroupClientEapolIpAddressData p2pClientEapolIpInfo;
    private static final Pattern groupStartedPattern = Pattern.compile("ssid=\"(.+)\" freq=(\\d+) (?:psk=)?([0-9a-fA-F]{64})?(?:passphrase=)?(?:\"(.{0,63})\")? go_dev_addr=((?:[0-9a-f]{2}:){5}[0-9a-f]{2}) ?(\\[PERSISTENT\\])?");
    @NonNull
    public static final Parcelable.Creator<WifiP2pGroup> CREATOR = new Parcelable.Creator<WifiP2pGroup>(){

        @Override
        public WifiP2pGroup createFromParcel(Parcel in) {
            WifiP2pGroup group = new WifiP2pGroup();
            group.setNetworkName(in.readString());
            group.setOwner((WifiP2pDevice)in.readParcelable(WifiP2pDevice.class.getClassLoader()));
            group.setIsGroupOwner(in.readByte() == 1);
            int clientCount = in.readInt();
            for (int i = 0; i < clientCount; ++i) {
                group.addClient((WifiP2pDevice)in.readParcelable(WifiP2pDevice.class.getClassLoader()));
            }
            group.setPassphrase(in.readString());
            group.setInterface(in.readString());
            group.setNetworkId(in.readInt());
            if (Environment.isSdkAtLeastB() && Flags.wifiDirectR2()) {
                group.setSecurityType(in.readInt());
            }
            group.setFrequency(in.readInt());
            if (SdkLevel.isAtLeastV()) {
                group.setVendorData(ParcelUtil.readOuiKeyedDataList(in));
            }
            return group;
        }

        public WifiP2pGroup[] newArray(int size) {
            return new WifiP2pGroup[size];
        }
    };

    public WifiP2pGroup() {
    }

    @UnsupportedAppUsage
    public WifiP2pGroup(String supplicantEvent) throws IllegalArgumentException {
        String[] tokens = supplicantEvent.split(" ");
        if (tokens.length < 3) {
            throw new IllegalArgumentException("Malformed supplicant event");
        }
        if (tokens[0].startsWith("P2P-GROUP")) {
            this.mInterface = tokens[1];
            this.mIsGroupOwner = tokens[2].equals("GO");
            Matcher match = groupStartedPattern.matcher(supplicantEvent);
            if (!match.find()) {
                return;
            }
            this.mNetworkName = match.group(1);
            this.mFrequency = Integer.parseInt(match.group(2));
            this.mPassphrase = match.group(4);
            this.mOwner = new WifiP2pDevice(match.group(5));
            this.mNetId = match.group(6) != null ? -2 : -1;
        } else if (tokens[0].equals("P2P-INVITATION-RECEIVED")) {
            String sa = null;
            this.mNetId = -2;
            for (String token : tokens) {
                String[] nameValue = token.split("=");
                if (nameValue.length != 2) continue;
                if (nameValue[0].equals("sa")) {
                    sa = nameValue[1];
                    WifiP2pDevice dev = new WifiP2pDevice();
                    dev.deviceAddress = nameValue[1];
                    this.mClients.add(dev);
                    continue;
                }
                if (nameValue[0].equals("go_dev_addr")) {
                    this.mOwner = new WifiP2pDevice(nameValue[1]);
                    continue;
                }
                if (!nameValue[0].equals("persistent")) continue;
                this.mNetId = Integer.parseInt(nameValue[1]);
            }
        } else {
            throw new IllegalArgumentException("Malformed supplicant event");
        }
    }

    public void setNetworkName(String networkName) {
        this.mNetworkName = networkName;
    }

    public String getNetworkName() {
        return this.mNetworkName;
    }

    @UnsupportedAppUsage
    public void setIsGroupOwner(boolean isGo) {
        this.mIsGroupOwner = isGo;
    }

    public boolean isGroupOwner() {
        return this.mIsGroupOwner;
    }

    public void setOwner(WifiP2pDevice device) {
        this.mOwner = device;
    }

    public WifiP2pDevice getOwner() {
        return this.mOwner;
    }

    public void addClient(String address) {
        this.addClient(new WifiP2pDevice(address));
    }

    public void addClient(WifiP2pDevice device) {
        for (WifiP2pDevice client : this.mClients) {
            if (!client.equals(device)) continue;
            return;
        }
        this.mClients.add(new WifiP2pDevice(device));
    }

    public void setClientInterfaceMacAddress(@NonNull String deviceAddress, @NonNull MacAddress interfaceMacAddress) {
        if (null == interfaceMacAddress) {
            Log.e("setClientInterfaceMacAddress", "cannot set null interface mac address");
            return;
        }
        for (WifiP2pDevice client : this.mClients) {
            if (!client.deviceAddress.equals(deviceAddress)) continue;
            Log.i("setClientInterfaceMacAddress", "device: " + deviceAddress + " interfaceAddress: " + ((Object)interfaceMacAddress).toString());
            client.setInterfaceMacAddress(interfaceMacAddress);
            break;
        }
    }

    public void setClientIpAddress(@NonNull MacAddress interfaceMacAddress, @NonNull InetAddress ipAddress) {
        if (null == interfaceMacAddress) {
            Log.e("setClientIpAddress", "cannot set IP address with null interface mac address");
            return;
        }
        if (null == ipAddress) {
            Log.e("setClientIpAddress", "Null IP - Failed to set IP address in WifiP2pDevice");
            return;
        }
        for (WifiP2pDevice client : this.mClients) {
            if (!((Object)interfaceMacAddress).equals(client.getInterfaceMacAddress())) continue;
            Log.i("setClientIpAddress", "Update the IP address device: " + client.deviceAddress + " interfaceAddress: " + ((Object)interfaceMacAddress).toString() + " IP: " + ipAddress.getHostAddress());
            client.setIpAddress(ipAddress);
            break;
        }
    }

    public boolean removeClient(String address) {
        return this.mClients.remove(new WifiP2pDevice(address));
    }

    public boolean removeClient(WifiP2pDevice device) {
        return this.mClients.remove(device);
    }

    @UnsupportedAppUsage
    public boolean isClientListEmpty() {
        return this.mClients.size() == 0;
    }

    public boolean contains(@Nullable WifiP2pDevice device) {
        return this.mOwner.equals(device) || this.mClients.contains(device);
    }

    public Collection<WifiP2pDevice> getClientList() {
        return Collections.unmodifiableCollection(this.mClients);
    }

    public void setPassphrase(String passphrase) {
        this.mPassphrase = passphrase;
    }

    public String getPassphrase() {
        return this.mPassphrase;
    }

    public void setSecurityType(int securityType) {
        this.mSecurityType = securityType;
    }

    @RequiresApi(value=36)
    @FlaggedApi(value="com.android.wifi.flags.wifi_direct_r2")
    public int getSecurityType() {
        if (!Environment.isSdkAtLeastB()) {
            throw new UnsupportedOperationException();
        }
        return this.mSecurityType;
    }

    @UnsupportedAppUsage
    public void setInterface(String intf) {
        this.mInterface = intf;
    }

    public String getInterface() {
        return this.mInterface;
    }

    public int getNetworkId() {
        return this.mNetId;
    }

    @UnsupportedAppUsage
    public void setNetworkId(int netId) {
        this.mNetId = netId;
    }

    public int getFrequency() {
        return this.mFrequency;
    }

    public void setFrequency(int freq) {
        this.mFrequency = freq;
    }

    @SystemApi
    @RequiresApi(value=35)
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @NonNull
    public List<OuiKeyedData> getVendorData() {
        if (!SdkLevel.isAtLeastV()) {
            throw new UnsupportedOperationException();
        }
        return this.mVendorData;
    }

    @SystemApi
    @RequiresApi(value=35)
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public void setVendorData(@NonNull List<OuiKeyedData> vendorData) {
        if (!SdkLevel.isAtLeastV()) {
            throw new UnsupportedOperationException();
        }
        if (vendorData == null) {
            throw new IllegalArgumentException("setVendorData received a null value");
        }
        this.mVendorData = new ArrayList<OuiKeyedData>(vendorData);
    }

    @RequiresApi(value=36)
    @FlaggedApi(value="com.android.wifi.flags.wifi_direct_r2")
    @Nullable
    public MacAddress getGroupOwnerBssid() {
        if (!Environment.isSdkAtLeastB()) {
            throw new UnsupportedOperationException();
        }
        if (this.isGroupOwner() && this.getSecurityType() == 2 && this.interfaceAddress != null) {
            return MacAddress.fromBytes(this.interfaceAddress);
        }
        return null;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("network: ").append(this.mNetworkName);
        sbuf.append("\n isGO: ").append(this.mIsGroupOwner);
        sbuf.append("\n GO: ").append(this.mOwner);
        for (WifiP2pDevice client : this.mClients) {
            sbuf.append("\n Client: ").append(client);
        }
        sbuf.append("\n interface: ").append(this.mInterface);
        sbuf.append("\n networkId: ").append(this.mNetId);
        sbuf.append("\n securityType: ").append(this.mSecurityType);
        sbuf.append("\n frequency: ").append(this.mFrequency);
        sbuf.append("\n vendorData: ").append(this.mVendorData);
        return sbuf.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public WifiP2pGroup(WifiP2pGroup source) {
        if (source != null) {
            this.mNetworkName = source.getNetworkName();
            this.mOwner = new WifiP2pDevice(source.getOwner());
            this.mIsGroupOwner = source.mIsGroupOwner;
            for (WifiP2pDevice d : source.getClientList()) {
                this.mClients.add(d);
            }
            this.mPassphrase = source.getPassphrase();
            this.mInterface = source.getInterface();
            this.mNetId = source.getNetworkId();
            if (Environment.isSdkAtLeastB() && Flags.wifiDirectR2()) {
                this.mSecurityType = source.getSecurityType();
            }
            this.mFrequency = source.getFrequency();
            if (SdkLevel.isAtLeastV()) {
                this.mVendorData = new ArrayList<OuiKeyedData>(source.getVendorData());
            }
        }
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mNetworkName);
        dest.writeParcelable(this.mOwner, flags);
        dest.writeByte(this.mIsGroupOwner ? (byte)1 : 0);
        dest.writeInt(this.mClients.size());
        for (WifiP2pDevice client : this.mClients) {
            dest.writeParcelable(client, flags);
        }
        dest.writeString(this.mPassphrase);
        dest.writeString(this.mInterface);
        dest.writeInt(this.mNetId);
        if (Environment.isSdkAtLeastB() && Flags.wifiDirectR2()) {
            dest.writeInt(this.mSecurityType);
        }
        dest.writeInt(this.mFrequency);
        if (SdkLevel.isAtLeastV()) {
            dest.writeList(this.mVendorData);
        }
    }

    public static class P2pGroupClientEapolIpAddressData {
        public final Inet4Address mIpAddressClient;
        public final Inet4Address mIpAddressGo;
        public final Inet4Address mIpAddressMask;

        public P2pGroupClientEapolIpAddressData(Inet4Address ipAddressClient, Inet4Address ipAddressGo, Inet4Address ipAddressMask) {
            this.mIpAddressClient = ipAddressClient;
            this.mIpAddressGo = ipAddressGo;
            this.mIpAddressMask = ipAddressMask;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SecurityType {
    }
}

