/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.net.MacAddress;
import android.net.wifi.OuiKeyedData;
import android.net.wifi.ParcelUtil;
import android.net.wifi.WpsInfo;
import android.net.wifi.p2p.WifiP2pPairingBootstrappingConfig;
import android.net.wifi.util.Environment;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import com.android.wifi.x.com.android.modules.utils.build.SdkLevel;
import com.android.wifi.x.com.android.wifi.flags.Flags;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.PatternSyntaxException;

public class WifiP2pConfig
implements Parcelable {
    static final int PSK_PASSWORD_MIN_LEN = 8;
    static final int PSK_PASSWORD_MAX_LEN = 63;
    static final int SAE_PASSWORD_MAX_LEN = 128;
    public String deviceAddress = "";
    public WpsInfo wps;
    public String networkName = "";
    public String passphrase = "";
    public int groupOwnerBand = 0;
    public static final int GROUP_CLIENT_IP_PROVISIONING_MODE_IPV4_DHCP = 0;
    public static final int GROUP_CLIENT_IP_PROVISIONING_MODE_IPV6_LINK_LOCAL = 1;
    public static final int GROUP_OWNER_BAND_AUTO = 0;
    public static final int GROUP_OWNER_BAND_2GHZ = 1;
    public static final int GROUP_OWNER_BAND_5GHZ = 2;
    @FlaggedApi(value="com.android.wifi.flags.wifi_direct_r2")
    public static final int GROUP_OWNER_BAND_6GHZ = 3;
    public static final int GROUP_OWNER_INTENT_MIN = 0;
    public static final int GROUP_OWNER_INTENT_MAX = 15;
    public static final int GROUP_OWNER_INTENT_AUTO = -1;
    public int groupOwnerIntent = -1;
    private int mGroupClientIpProvisioningMode = 0;
    private boolean mJoinExistingGroup = false;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int netId = -2;
    @NonNull
    private List<OuiKeyedData> mVendorData = Collections.emptyList();
    public static final int PCC_MODE_DEFAULT_CONNECTION_TYPE_LEGACY_ONLY = 0;
    @FlaggedApi(value="com.android.wifi.flags.wifi_direct_r2")
    public static final int PCC_MODE_CONNECTION_TYPE_LEGACY_ONLY = 0;
    @FlaggedApi(value="com.android.wifi.flags.wifi_direct_r2")
    public static final int PCC_MODE_CONNECTION_TYPE_LEGACY_OR_R2 = 1;
    @FlaggedApi(value="com.android.wifi.flags.wifi_direct_r2")
    public static final int PCC_MODE_CONNECTION_TYPE_R2_ONLY = 2;
    private int mPccModeConnectionType = 0;
    public static final int P2P_DEFAULT_VERSION_1 = 0;
    @FlaggedApi(value="com.android.wifi.flags.wifi_direct_r2")
    public static final int P2P_VERSION_1 = 0;
    @FlaggedApi(value="com.android.wifi.flags.wifi_direct_r2")
    public static final int P2P_VERSION_2 = 1;
    private int mGroupOwnerVersion = 0;
    @Nullable
    private WifiP2pPairingBootstrappingConfig mPairingBootstrappingConfig;
    private boolean mIsAuthorizeConnectionFromPeerEnabled = false;
    @NonNull
    public static final Parcelable.Creator<WifiP2pConfig> CREATOR = new Parcelable.Creator<WifiP2pConfig>(){

        @Override
        public WifiP2pConfig createFromParcel(Parcel in) {
            WifiP2pConfig config = new WifiP2pConfig();
            config.deviceAddress = in.readString();
            config.wps = (WpsInfo)in.readParcelable(WpsInfo.class.getClassLoader());
            config.groupOwnerIntent = in.readInt();
            config.netId = in.readInt();
            config.networkName = in.readString();
            config.passphrase = in.readString();
            config.mPccModeConnectionType = in.readInt();
            config.groupOwnerBand = in.readInt();
            config.mGroupClientIpProvisioningMode = in.readInt();
            config.mJoinExistingGroup = in.readBoolean();
            config.mVendorData = ParcelUtil.readOuiKeyedDataList(in);
            config.mGroupOwnerVersion = in.readInt();
            if (Environment.isSdkAtLeastB() && Flags.wifiDirectR2()) {
                config.mPairingBootstrappingConfig = (WifiP2pPairingBootstrappingConfig)in.readParcelable(WifiP2pPairingBootstrappingConfig.class.getClassLoader());
            }
            config.mIsAuthorizeConnectionFromPeerEnabled = in.readBoolean();
            return config;
        }

        public WifiP2pConfig[] newArray(int size) {
            return new WifiP2pConfig[size];
        }
    };

    @Nullable
    public String getNetworkName() {
        return this.networkName;
    }

    @Nullable
    public String getPassphrase() {
        return this.passphrase;
    }

    public int getGroupOwnerBand() {
        return this.groupOwnerBand;
    }

    @SystemApi
    public boolean isJoinExistingGroup() {
        return this.mJoinExistingGroup;
    }

    public int getNetworkId() {
        return this.netId;
    }

    @SystemApi
    @RequiresApi(value=35)
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public void setVendorData(@NonNull List<OuiKeyedData> vendorData) {
        if (!SdkLevel.isAtLeastV()) {
            throw new UnsupportedOperationException();
        }
        if (vendorData == null) {
            throw new IllegalArgumentException("setVendorData received a null value");
        }
        this.mVendorData = new ArrayList<OuiKeyedData>(vendorData);
    }

    @SystemApi
    @RequiresApi(value=35)
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @NonNull
    public List<OuiKeyedData> getVendorData() {
        if (!SdkLevel.isAtLeastV()) {
            throw new UnsupportedOperationException();
        }
        return this.mVendorData;
    }

    @RequiresApi(value=36)
    @FlaggedApi(value="com.android.wifi.flags.wifi_direct_r2")
    public int getPccModeConnectionType() {
        if (!Environment.isSdkAtLeastB()) {
            throw new UnsupportedOperationException();
        }
        return this.mPccModeConnectionType;
    }

    @RequiresApi(value=36)
    @FlaggedApi(value="com.android.wifi.flags.wifi_direct_r2")
    public int getGroupOwnerVersion() {
        if (!Environment.isSdkAtLeastB()) {
            throw new UnsupportedOperationException();
        }
        return this.mGroupOwnerVersion;
    }

    @RequiresApi(value=36)
    @FlaggedApi(value="com.android.wifi.flags.wifi_direct_r2")
    public void setGroupOwnerVersion(int version) {
        if (!Environment.isSdkAtLeastB()) {
            throw new UnsupportedOperationException();
        }
        this.mGroupOwnerVersion = version;
    }

    @RequiresApi(value=36)
    @FlaggedApi(value="com.android.wifi.flags.wifi_direct_r2")
    @Nullable
    public WifiP2pPairingBootstrappingConfig getPairingBootstrappingConfig() {
        if (!Environment.isSdkAtLeastB()) {
            throw new UnsupportedOperationException();
        }
        return this.mPairingBootstrappingConfig;
    }

    @RequiresApi(value=36)
    @FlaggedApi(value="com.android.wifi.flags.wifi_direct_r2")
    public boolean isAuthorizeConnectionFromPeerEnabled() {
        if (!Environment.isSdkAtLeastB()) {
            throw new UnsupportedOperationException();
        }
        return this.mIsAuthorizeConnectionFromPeerEnabled;
    }

    public WifiP2pConfig() {
        this.wps = new WpsInfo();
        this.wps.setup = 0;
    }

    public void invalidate() {
        this.deviceAddress = "";
    }

    @UnsupportedAppUsage
    public WifiP2pConfig(String supplicantEvent) throws IllegalArgumentException {
        String[] tokens = supplicantEvent.split(" ");
        if (tokens.length < 2 || !tokens[0].equals("P2P-GO-NEG-REQUEST")) {
            throw new IllegalArgumentException("Malformed supplicant event");
        }
        this.deviceAddress = tokens[1];
        this.wps = new WpsInfo();
        if (tokens.length > 2) {
            int devPasswdId;
            String[] nameVal = tokens[2].split("=");
            try {
                devPasswdId = Integer.parseInt(nameVal[1]);
            }
            catch (NumberFormatException e) {
                devPasswdId = 0;
            }
            switch (devPasswdId) {
                case 1: {
                    this.wps.setup = 1;
                    break;
                }
                case 4: {
                    this.wps.setup = 0;
                    break;
                }
                case 5: {
                    this.wps.setup = 2;
                    break;
                }
                default: {
                    this.wps.setup = 0;
                }
            }
        }
    }

    public int getGroupClientIpProvisioningMode() {
        return this.mGroupClientIpProvisioningMode;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("\n address: ").append(this.deviceAddress);
        sbuf.append("\n wps: ").append(this.wps);
        sbuf.append("\n groupOwnerIntent: ").append(this.groupOwnerIntent);
        sbuf.append("\n persist: ").append(this.netId);
        sbuf.append("\n networkName: ").append(this.networkName);
        sbuf.append("\n passphrase: ").append(TextUtils.isEmpty(this.passphrase) ? "<empty>" : "<non-empty>");
        sbuf.append("\n pccModeConnectionType: ").append(this.mPccModeConnectionType);
        sbuf.append("\n groupOwnerBand: ").append(this.groupOwnerBand);
        sbuf.append("\n groupClientIpProvisioningMode: ").append(this.mGroupClientIpProvisioningMode);
        sbuf.append("\n joinExistingGroup: ").append(this.mJoinExistingGroup);
        sbuf.append("\n vendorData: ").append(this.mVendorData);
        sbuf.append("\n Group Owner Version: ").append(this.mGroupOwnerVersion);
        if (Environment.isSdkAtLeastB() && Flags.wifiDirectR2()) {
            sbuf.append("\n Pairing bootstrapping config : ").append(this.mPairingBootstrappingConfig == null ? "<null>" : this.mPairingBootstrappingConfig.toString());
        }
        sbuf.append("\n authorizeConnectionFromPeerEnabled: ").append(this.mIsAuthorizeConnectionFromPeerEnabled);
        return sbuf.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public WifiP2pConfig(WifiP2pConfig source) {
        if (source != null) {
            this.deviceAddress = source.deviceAddress;
            this.wps = new WpsInfo(source.wps);
            this.groupOwnerIntent = source.groupOwnerIntent;
            this.netId = source.netId;
            this.networkName = source.networkName;
            this.passphrase = source.passphrase;
            this.mPccModeConnectionType = source.mPccModeConnectionType;
            this.groupOwnerBand = source.groupOwnerBand;
            this.mGroupClientIpProvisioningMode = source.mGroupClientIpProvisioningMode;
            this.mJoinExistingGroup = source.mJoinExistingGroup;
            this.mVendorData = new ArrayList<OuiKeyedData>(source.mVendorData);
            this.mGroupOwnerVersion = source.mGroupOwnerVersion;
            this.mPairingBootstrappingConfig = source.mPairingBootstrappingConfig;
            this.mIsAuthorizeConnectionFromPeerEnabled = source.mIsAuthorizeConnectionFromPeerEnabled;
        }
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.deviceAddress);
        dest.writeParcelable(this.wps, flags);
        dest.writeInt(this.groupOwnerIntent);
        dest.writeInt(this.netId);
        dest.writeString(this.networkName);
        dest.writeString(this.passphrase);
        dest.writeInt(this.mPccModeConnectionType);
        dest.writeInt(this.groupOwnerBand);
        dest.writeInt(this.mGroupClientIpProvisioningMode);
        dest.writeBoolean(this.mJoinExistingGroup);
        dest.writeList(this.mVendorData);
        dest.writeInt(this.mGroupOwnerVersion);
        if (Environment.isSdkAtLeastB() && Flags.wifiDirectR2()) {
            dest.writeParcelable(this.mPairingBootstrappingConfig, flags);
        }
        dest.writeBoolean(this.mIsAuthorizeConnectionFromPeerEnabled);
    }

    public static class Builder {
        private static final MacAddress MAC_ANY_ADDRESS = MacAddress.fromString("02:00:00:00:00:00");
        private static final int MAX_SSID_BYTES = 32;
        private MacAddress mDeviceAddress = MAC_ANY_ADDRESS;
        private String mNetworkName = "";
        private String mPassphrase = "";
        private int mGroupOperatingBand = 0;
        private int mGroupOperatingFrequency = 0;
        private int mNetId = -1;
        private int mGroupClientIpProvisioningMode = 0;
        private boolean mJoinExistingGroup = false;
        private int mPccModeConnectionType = 0;
        @Nullable
        private WifiP2pPairingBootstrappingConfig mPairingBootstrappingConfig;
        private boolean mIsAuthorizeConnectionFromPeerEnabled = false;

        @NonNull
        public Builder setDeviceAddress(@Nullable MacAddress deviceAddress) {
            this.mDeviceAddress = deviceAddress == null ? MAC_ANY_ADDRESS : deviceAddress;
            return this;
        }

        @NonNull
        public Builder setNetworkName(@NonNull String networkName) {
            if (TextUtils.isEmpty(networkName)) {
                throw new IllegalArgumentException("network name must be non-empty.");
            }
            if (networkName.getBytes(StandardCharsets.UTF_8).length > 32) {
                throw new IllegalArgumentException("network name exceeds 32 bytes.");
            }
            try {
                if (!networkName.matches("^DIRECT-[a-zA-Z0-9]{2}.*")) {
                    throw new IllegalArgumentException("network name must starts with the prefix DIRECT-xy.");
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
            this.mNetworkName = networkName;
            return this;
        }

        @NonNull
        public Builder setPassphrase(@NonNull String passphrase) {
            Objects.requireNonNull(passphrase, "passphrase cannot be null");
            if (TextUtils.isEmpty(passphrase)) {
                throw new IllegalArgumentException("passphrase must be non-empty.");
            }
            if (passphrase.length() > 128) {
                throw new IllegalArgumentException("The length of a passphrase must be less than 128");
            }
            this.mPassphrase = passphrase;
            return this;
        }

        @RequiresApi(value=36)
        @FlaggedApi(value="com.android.wifi.flags.wifi_direct_r2")
        @NonNull
        public Builder setPccModeConnectionType(int connectionType) {
            if (!Environment.isSdkAtLeastB()) {
                throw new UnsupportedOperationException();
            }
            switch (connectionType) {
                case 0: 
                case 1: 
                case 2: {
                    this.mPccModeConnectionType = connectionType;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid constant for the PCC Mode connection type!");
                }
            }
            return this;
        }

        @NonNull
        public Builder setGroupOperatingBand(int band) {
            if (!(0 == band || 1 == band || 2 == band || Environment.isSdkAtLeastB() && Flags.wifiDirectR2() && 3 == band)) {
                throw new IllegalArgumentException("Invalid constant for the group operating band!");
            }
            this.mGroupOperatingBand = band;
            return this;
        }

        @NonNull
        public Builder setGroupOperatingFrequency(int frequency) {
            if (frequency < 0) {
                throw new IllegalArgumentException("Invalid group operating frequency!");
            }
            this.mGroupOperatingFrequency = frequency;
            return this;
        }

        @NonNull
        public Builder enablePersistentMode(boolean persistent) {
            this.mNetId = persistent ? -2 : -1;
            return this;
        }

        @RequiresApi(value=33)
        @NonNull
        public Builder setGroupClientIpProvisioningMode(int groupClientIpProvisioningMode) {
            if (!SdkLevel.isAtLeastT()) {
                throw new UnsupportedOperationException("IPv6 link-local provisioning not supported");
            }
            switch (groupClientIpProvisioningMode) {
                case 0: 
                case 1: {
                    this.mGroupClientIpProvisioningMode = groupClientIpProvisioningMode;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid constant for the group client IP provisioning mode!");
                }
            }
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setJoinExistingGroup(boolean join) {
            this.mJoinExistingGroup = join;
            return this;
        }

        @RequiresApi(value=36)
        @FlaggedApi(value="com.android.wifi.flags.wifi_direct_r2")
        @NonNull
        public Builder setPairingBootstrappingConfig(@NonNull WifiP2pPairingBootstrappingConfig config) {
            if (!Environment.isSdkAtLeastB()) {
                throw new UnsupportedOperationException();
            }
            Objects.requireNonNull(config, "config cannot be null");
            this.mPairingBootstrappingConfig = config;
            return this;
        }

        @RequiresApi(value=36)
        @FlaggedApi(value="com.android.wifi.flags.wifi_direct_r2")
        @NonNull
        public Builder setAuthorizeConnectionFromPeerEnabled(boolean enabled) {
            this.mIsAuthorizeConnectionFromPeerEnabled = enabled;
            return this;
        }

        @NonNull
        public WifiP2pConfig build() {
            if (TextUtils.isEmpty(this.mNetworkName) && !TextUtils.isEmpty(this.mPassphrase) || !TextUtils.isEmpty(this.mNetworkName) && TextUtils.isEmpty(this.mPassphrase)) {
                throw new IllegalStateException("network name and passphrase must be non-empty or empty both.");
            }
            if (TextUtils.isEmpty(this.mNetworkName) && ((Object)this.mDeviceAddress).equals(MAC_ANY_ADDRESS)) {
                throw new IllegalStateException("peer address must be set if network name and passphrase are not set.");
            }
            if (!(TextUtils.isEmpty(this.mNetworkName) || TextUtils.isEmpty(this.mPassphrase) || this.mPccModeConnectionType != 0 && this.mPccModeConnectionType != 1 || this.mPassphrase.length() >= 8 && this.mPassphrase.length() <= 63)) {
                throw new IllegalArgumentException("The length of a passphrase must be between 8 and 63 for legacy connection type");
            }
            if (this.mGroupOperatingFrequency > 0 && this.mGroupOperatingBand > 0) {
                throw new IllegalStateException("Preferred frequency and band are mutually exclusive.");
            }
            WifiP2pConfig config = new WifiP2pConfig();
            config.deviceAddress = ((Object)this.mDeviceAddress).toString();
            config.networkName = this.mNetworkName;
            config.passphrase = this.mPassphrase;
            config.mPccModeConnectionType = this.mPccModeConnectionType;
            config.groupOwnerBand = 0;
            if (this.mGroupOperatingFrequency > 0) {
                config.groupOwnerBand = this.mGroupOperatingFrequency;
            } else if (this.mGroupOperatingBand > 0) {
                config.groupOwnerBand = this.mGroupOperatingBand;
            }
            config.netId = this.mNetId;
            config.mGroupClientIpProvisioningMode = this.mGroupClientIpProvisioningMode;
            config.mJoinExistingGroup = this.mJoinExistingGroup;
            if (this.mPairingBootstrappingConfig != null) {
                config.mPairingBootstrappingConfig = this.mPairingBootstrappingConfig;
                config.mGroupClientIpProvisioningMode = 1;
                config.wps.setup = 4;
            }
            config.mIsAuthorizeConnectionFromPeerEnabled = this.mIsAuthorizeConnectionFromPeerEnabled;
            return config;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface P2pVersion {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PccModeConnectionType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GroupClientIpProvisioningMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GroupOperatingBandType {
    }
}

