/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.hotspot2.pps;

import android.annotation.NonNull;
import android.net.wifi.ParcelUtil;
import android.net.wifi.hotspot2.pps.Credential;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Objects;

public class UpdateParameter
implements Parcelable {
    private static final String TAG = "UpdateParameter";
    public static final long UPDATE_CHECK_INTERVAL_NEVER = 0xFFFFFFFFL;
    public static final String UPDATE_METHOD_OMADM = "OMA-DM-ClientInitiated";
    public static final String UPDATE_METHOD_SPP = "SPP-ClientInitiated";
    public static final String UPDATE_RESTRICTION_HOMESP = "HomeSP";
    public static final String UPDATE_RESTRICTION_ROAMING_PARTNER = "RoamingPartner";
    public static final String UPDATE_RESTRICTION_UNRESTRICTED = "Unrestricted";
    private static final int MAX_URI_BYTES = 1023;
    private static final int MAX_URL_BYTES = 1023;
    private static final int MAX_USERNAME_BYTES = 63;
    private static final int MAX_PASSWORD_BYTES = 255;
    private static final int CERTIFICATE_SHA256_BYTES = 32;
    private long mUpdateIntervalInMinutes = Long.MIN_VALUE;
    private String mUpdateMethod = null;
    private String mRestriction = null;
    private String mServerUri = null;
    private String mUsername = null;
    private String mBase64EncodedPassword = null;
    private String mTrustRootCertUrl = null;
    private byte[] mTrustRootCertSha256Fingerprint = null;
    private X509Certificate mCaCertificate;
    @NonNull
    public static final Parcelable.Creator<UpdateParameter> CREATOR = new Parcelable.Creator<UpdateParameter>(){

        @Override
        public UpdateParameter createFromParcel(Parcel in) {
            UpdateParameter updateParam = new UpdateParameter();
            updateParam.setUpdateIntervalInMinutes(in.readLong());
            updateParam.setUpdateMethod(in.readString());
            updateParam.setRestriction(in.readString());
            updateParam.setServerUri(in.readString());
            updateParam.setUsername(in.readString());
            updateParam.setBase64EncodedPassword(in.readString());
            updateParam.setTrustRootCertUrl(in.readString());
            updateParam.setTrustRootCertSha256Fingerprint(in.createByteArray());
            updateParam.setCaCertificate(ParcelUtil.readCertificate(in));
            return updateParam;
        }

        public UpdateParameter[] newArray(int size) {
            return new UpdateParameter[size];
        }
    };

    public void setUpdateIntervalInMinutes(long updateIntervalInMinutes) {
        this.mUpdateIntervalInMinutes = updateIntervalInMinutes;
    }

    public long getUpdateIntervalInMinutes() {
        return this.mUpdateIntervalInMinutes;
    }

    public void setUpdateMethod(String updateMethod) {
        this.mUpdateMethod = updateMethod;
    }

    public String getUpdateMethod() {
        return this.mUpdateMethod;
    }

    public void setRestriction(String restriction) {
        this.mRestriction = restriction;
    }

    public String getRestriction() {
        return this.mRestriction;
    }

    public void setServerUri(String serverUri) {
        this.mServerUri = serverUri;
    }

    public String getServerUri() {
        return this.mServerUri;
    }

    public void setUsername(String username) {
        this.mUsername = username;
    }

    public String getUsername() {
        return this.mUsername;
    }

    public void setBase64EncodedPassword(String password) {
        this.mBase64EncodedPassword = password;
    }

    public String getBase64EncodedPassword() {
        return this.mBase64EncodedPassword;
    }

    public void setTrustRootCertUrl(String trustRootCertUrl) {
        this.mTrustRootCertUrl = trustRootCertUrl;
    }

    public String getTrustRootCertUrl() {
        return this.mTrustRootCertUrl;
    }

    public void setTrustRootCertSha256Fingerprint(byte[] fingerprint) {
        this.mTrustRootCertSha256Fingerprint = fingerprint;
    }

    public byte[] getTrustRootCertSha256Fingerprint() {
        return this.mTrustRootCertSha256Fingerprint;
    }

    public void setCaCertificate(X509Certificate caCertificate) {
        this.mCaCertificate = caCertificate;
    }

    public X509Certificate getCaCertificate() {
        return this.mCaCertificate;
    }

    public UpdateParameter() {
    }

    public UpdateParameter(UpdateParameter source) {
        if (source == null) {
            return;
        }
        this.mUpdateIntervalInMinutes = source.mUpdateIntervalInMinutes;
        this.mUpdateMethod = source.mUpdateMethod;
        this.mRestriction = source.mRestriction;
        this.mServerUri = source.mServerUri;
        this.mUsername = source.mUsername;
        this.mBase64EncodedPassword = source.mBase64EncodedPassword;
        this.mTrustRootCertUrl = source.mTrustRootCertUrl;
        if (source.mTrustRootCertSha256Fingerprint != null) {
            this.mTrustRootCertSha256Fingerprint = Arrays.copyOf(source.mTrustRootCertSha256Fingerprint, source.mTrustRootCertSha256Fingerprint.length);
        }
        this.mCaCertificate = source.mCaCertificate;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mUpdateIntervalInMinutes);
        dest.writeString(this.mUpdateMethod);
        dest.writeString(this.mRestriction);
        dest.writeString(this.mServerUri);
        dest.writeString(this.mUsername);
        dest.writeString(this.mBase64EncodedPassword);
        dest.writeString(this.mTrustRootCertUrl);
        dest.writeByteArray(this.mTrustRootCertSha256Fingerprint);
        ParcelUtil.writeCertificate(dest, this.mCaCertificate);
    }

    public boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        }
        if (!(thatObject instanceof UpdateParameter)) {
            return false;
        }
        UpdateParameter that = (UpdateParameter)thatObject;
        return this.mUpdateIntervalInMinutes == that.mUpdateIntervalInMinutes && TextUtils.equals(this.mUpdateMethod, that.mUpdateMethod) && TextUtils.equals(this.mRestriction, that.mRestriction) && TextUtils.equals(this.mServerUri, that.mServerUri) && TextUtils.equals(this.mUsername, that.mUsername) && TextUtils.equals(this.mBase64EncodedPassword, that.mBase64EncodedPassword) && TextUtils.equals(this.mTrustRootCertUrl, that.mTrustRootCertUrl) && Arrays.equals(this.mTrustRootCertSha256Fingerprint, that.mTrustRootCertSha256Fingerprint) && Credential.isX509CertificateEquals(this.mCaCertificate, that.mCaCertificate);
    }

    public int hashCode() {
        return Objects.hash(this.mUpdateIntervalInMinutes, this.mUpdateMethod, this.mRestriction, this.mServerUri, this.mUsername, this.mBase64EncodedPassword, this.mTrustRootCertUrl, Arrays.hashCode(this.mTrustRootCertSha256Fingerprint), this.mCaCertificate);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("UpdateInterval: ").append(this.mUpdateIntervalInMinutes).append("\n");
        builder.append("UpdateMethod: ").append(this.mUpdateMethod).append("\n");
        builder.append("Restriction: ").append(this.mRestriction).append("\n");
        builder.append("ServerURI: ").append(this.mServerUri).append("\n");
        builder.append("Username: ").append(this.mUsername).append("\n");
        builder.append("TrustRootCertURL: ").append(this.mTrustRootCertUrl).append("\n");
        return builder.toString();
    }

    public boolean validate() {
        if (this.mUpdateIntervalInMinutes == Long.MIN_VALUE) {
            Log.d(TAG, "Update interval not specified");
            return false;
        }
        if (this.mUpdateIntervalInMinutes == 0xFFFFFFFFL) {
            return true;
        }
        if (!TextUtils.equals(this.mUpdateMethod, UPDATE_METHOD_OMADM) && !TextUtils.equals(this.mUpdateMethod, UPDATE_METHOD_SPP)) {
            Log.d(TAG, "Unknown update method: " + this.mUpdateMethod);
            return false;
        }
        if (!(TextUtils.equals(this.mRestriction, UPDATE_RESTRICTION_HOMESP) || TextUtils.equals(this.mRestriction, UPDATE_RESTRICTION_ROAMING_PARTNER) || TextUtils.equals(this.mRestriction, UPDATE_RESTRICTION_UNRESTRICTED))) {
            Log.d(TAG, "Unknown restriction: " + this.mRestriction);
            return false;
        }
        if (TextUtils.isEmpty(this.mServerUri)) {
            Log.d(TAG, "Missing update server URI");
            return false;
        }
        if (this.mServerUri.getBytes(StandardCharsets.UTF_8).length > 1023) {
            Log.d(TAG, "URI bytes exceeded the max: " + this.mServerUri.getBytes(StandardCharsets.UTF_8).length);
            return false;
        }
        if (TextUtils.isEmpty(this.mUsername)) {
            Log.d(TAG, "Missing username");
            return false;
        }
        if (this.mUsername.getBytes(StandardCharsets.UTF_8).length > 63) {
            Log.d(TAG, "Username bytes exceeded the max: " + this.mUsername.getBytes(StandardCharsets.UTF_8).length);
            return false;
        }
        if (TextUtils.isEmpty(this.mBase64EncodedPassword)) {
            Log.d(TAG, "Missing username");
            return false;
        }
        if (this.mBase64EncodedPassword.getBytes(StandardCharsets.UTF_8).length > 255) {
            Log.d(TAG, "Password bytes exceeded the max: " + this.mBase64EncodedPassword.getBytes(StandardCharsets.UTF_8).length);
            return false;
        }
        try {
            Base64.decode(this.mBase64EncodedPassword, 0);
        }
        catch (IllegalArgumentException e) {
            Log.d(TAG, "Invalid encoding for password: " + this.mBase64EncodedPassword);
            return false;
        }
        if (TextUtils.isEmpty(this.mTrustRootCertUrl)) {
            Log.d(TAG, "Missing trust root certificate URL");
            return false;
        }
        if (this.mTrustRootCertUrl.getBytes(StandardCharsets.UTF_8).length > 1023) {
            Log.d(TAG, "Trust root cert URL bytes exceeded the max: " + this.mTrustRootCertUrl.getBytes(StandardCharsets.UTF_8).length);
            return false;
        }
        if (this.mTrustRootCertSha256Fingerprint == null) {
            Log.d(TAG, "Missing trust root certificate SHA-256 fingerprint");
            return false;
        }
        if (this.mTrustRootCertSha256Fingerprint.length != 32) {
            Log.d(TAG, "Incorrect size of trust root certificate SHA-256 fingerprint: " + this.mTrustRootCertSha256Fingerprint.length);
            return false;
        }
        return true;
    }
}

