/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.ActivityManager;
import android.app.admin.WifiSsidPolicy;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.net.DhcpInfo;
import android.net.DhcpOption;
import android.net.MacAddress;
import android.net.Network;
import android.net.TetheringManager;
import android.net.Uri;
import android.net.wifi.BlockingOption;
import android.net.wifi.CoexUnsafeChannel;
import android.net.wifi.EasyConnectStatusCallback;
import android.net.wifi.IActionListener;
import android.net.wifi.IBooleanListener;
import android.net.wifi.IByteArrayListener;
import android.net.wifi.ICoexCallback;
import android.net.wifi.IDppCallback;
import android.net.wifi.IIntegerListener;
import android.net.wifi.IInterfaceCreationInfoCallback;
import android.net.wifi.ILastCallerListener;
import android.net.wifi.IListListener;
import android.net.wifi.ILocalOnlyConnectionStatusListener;
import android.net.wifi.ILocalOnlyHotspotCallback;
import android.net.wifi.IMacAddressListListener;
import android.net.wifi.IMapListener;
import android.net.wifi.INetworkRequestMatchCallback;
import android.net.wifi.INetworkRequestUserSelectionCallback;
import android.net.wifi.IOnWifiActivityEnergyInfoListener;
import android.net.wifi.IOnWifiDriverCountryCodeChangedListener;
import android.net.wifi.IOnWifiUsabilityStatsListener;
import android.net.wifi.IPnoScanResultsCallback;
import android.net.wifi.IScanResultsCallback;
import android.net.wifi.IScoreUpdateObserver;
import android.net.wifi.ISoftApCallback;
import android.net.wifi.IStringListener;
import android.net.wifi.ISubsystemRestartCallback;
import android.net.wifi.ISuggestionConnectionStatusListener;
import android.net.wifi.ISuggestionUserApprovalStatusListener;
import android.net.wifi.ITrafficStateCallback;
import android.net.wifi.ITwtCallback;
import android.net.wifi.ITwtCapabilitiesListener;
import android.net.wifi.ITwtStatsListener;
import android.net.wifi.IWifiBandsListener;
import android.net.wifi.IWifiConnectedNetworkScorer;
import android.net.wifi.IWifiLowLatencyLockListener;
import android.net.wifi.IWifiManager;
import android.net.wifi.IWifiNetworkSelectionConfigListener;
import android.net.wifi.IWifiNetworkStateChangedListener;
import android.net.wifi.IWifiStateChangedListener;
import android.net.wifi.IWifiVerboseLoggingStatusChangedListener;
import android.net.wifi.MscsParams;
import android.net.wifi.QosPolicyParams;
import android.net.wifi.ScanResult;
import android.net.wifi.SoftApCapability;
import android.net.wifi.SoftApConfiguration;
import android.net.wifi.SoftApInfo;
import android.net.wifi.SoftApState;
import android.net.wifi.WifiAvailableChannel;
import android.net.wifi.WifiBands;
import android.net.wifi.WifiClient;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiConnectedSessionInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiNetworkSelectionConfig;
import android.net.wifi.WifiNetworkSpecifier;
import android.net.wifi.WifiNetworkSuggestion;
import android.net.wifi.WifiSsid;
import android.net.wifi.WifiTwtSession;
import android.net.wifi.WifiUsabilityStatsEntry;
import android.net.wifi.WpsInfo;
import android.net.wifi.hotspot2.IProvisioningCallback;
import android.net.wifi.hotspot2.OsuProvider;
import android.net.wifi.hotspot2.PasspointConfiguration;
import android.net.wifi.hotspot2.ProvisioningCallback;
import android.net.wifi.twt.TwtRequest;
import android.net.wifi.twt.TwtSessionCallback;
import android.net.wifi.util.Environment;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.WorkSource;
import android.os.connectivity.WifiActivityEnergyInfo;
import android.security.advancedprotection.AdvancedProtectionFeature;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.CloseGuard;
import android.util.Log;
import android.util.Pair;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import com.android.wifi.x.android.security.Flags;
import com.android.wifi.x.com.android.modules.utils.HandlerExecutor;
import com.android.wifi.x.com.android.modules.utils.ParceledListSlice;
import com.android.wifi.x.com.android.modules.utils.StringParceledListSlice;
import com.android.wifi.x.com.android.modules.utils.build.SdkLevel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntConsumer;

public class WifiManager {
    private static final String TAG = "WifiManager";
    public static final long NOT_OVERRIDE_EXISTING_NETWORKS_ON_RESTORE = 234793325L;
    @Deprecated
    public static final int ERROR_AUTHENTICATING = 1;
    @Deprecated
    public static final int ERROR_AUTH_FAILURE_NONE = 0;
    @Deprecated
    public static final int ERROR_AUTH_FAILURE_TIMEOUT = 1;
    @Deprecated
    public static final int ERROR_AUTH_FAILURE_WRONG_PSWD = 2;
    @Deprecated
    public static final int ERROR_AUTH_FAILURE_EAP_FAILURE = 3;
    public static final int NETWORK_SUGGESTIONS_MAX_PER_APP_LOW_RAM = 256;
    public static final int NETWORK_SUGGESTIONS_MAX_PER_APP_HIGH_RAM = 1024;
    public static final int STATUS_NETWORK_SUGGESTIONS_SUCCESS = 0;
    public static final int STATUS_NETWORK_SUGGESTIONS_ERROR_INTERNAL = 1;
    public static final int STATUS_NETWORK_SUGGESTIONS_ERROR_APP_DISALLOWED = 2;
    public static final int STATUS_NETWORK_SUGGESTIONS_ERROR_ADD_DUPLICATE = 3;
    public static final int STATUS_NETWORK_SUGGESTIONS_ERROR_ADD_EXCEEDS_MAX_PER_APP = 4;
    public static final int STATUS_NETWORK_SUGGESTIONS_ERROR_REMOVE_INVALID = 5;
    public static final int STATUS_NETWORK_SUGGESTIONS_ERROR_ADD_NOT_ALLOWED = 6;
    public static final int STATUS_NETWORK_SUGGESTIONS_ERROR_ADD_INVALID = 7;
    public static final int STATUS_NETWORK_SUGGESTIONS_ERROR_RESTRICTED_BY_ADMIN = 8;
    public static final int STATUS_SUGGESTION_CONNECTION_FAILURE_UNKNOWN = 0;
    public static final int STATUS_SUGGESTION_CONNECTION_FAILURE_ASSOCIATION = 1;
    public static final int STATUS_SUGGESTION_CONNECTION_FAILURE_AUTHENTICATION = 2;
    public static final int STATUS_SUGGESTION_CONNECTION_FAILURE_IP_PROVISIONING = 3;
    public static final int STATUS_LOCAL_ONLY_CONNECTION_FAILURE_UNKNOWN = 0;
    public static final int STATUS_LOCAL_ONLY_CONNECTION_FAILURE_ASSOCIATION = 1;
    public static final int STATUS_LOCAL_ONLY_CONNECTION_FAILURE_AUTHENTICATION = 2;
    public static final int STATUS_LOCAL_ONLY_CONNECTION_FAILURE_IP_PROVISIONING = 3;
    public static final int STATUS_LOCAL_ONLY_CONNECTION_FAILURE_NOT_FOUND = 4;
    public static final int STATUS_LOCAL_ONLY_CONNECTION_FAILURE_NO_RESPONSE = 5;
    @FlaggedApi(value="com.android.wifi.flags.local_only_connection_optimization")
    public static final int STATUS_LOCAL_ONLY_CONNECTION_FAILURE_USER_REJECT = 6;
    public static final int STATUS_SUGGESTION_APPROVAL_UNKNOWN = 0;
    public static final int STATUS_SUGGESTION_APPROVAL_PENDING = 1;
    public static final int STATUS_SUGGESTION_APPROVAL_APPROVED_BY_USER = 2;
    public static final int STATUS_SUGGESTION_APPROVAL_REJECTED_BY_USER = 3;
    public static final int STATUS_SUGGESTION_APPROVAL_APPROVED_BY_CARRIER_PRIVILEGE = 4;
    @SystemApi
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static final int PNO_SCAN_STATE_DISABLED_UNTIL_REBOOT = 0;
    @SystemApi
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static final int PNO_SCAN_STATE_DISABLED_UNTIL_WIFI_TOGGLE = 1;
    @SystemApi
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static final int PNO_SCAN_STATE_ENABLED = 2;
    public static final int ACTION_REMOVE_SUGGESTION_LINGER = 1;
    public static final int ACTION_REMOVE_SUGGESTION_DISCONNECT = 2;
    public static final String EXTRA_PARAM_KEY_ATTRIBUTION_SOURCE = "EXTRA_PARAM_KEY_ATTRIBUTION_SOURCE";
    public static final String ACTION_WIFI_SCAN_AVAILABILITY_CHANGED = "android.net.wifi.action.WIFI_SCAN_AVAILABILITY_CHANGED";
    public static final String EXTRA_SCAN_AVAILABLE = "android.net.wifi.extra.SCAN_AVAILABLE";
    @SystemApi
    public static final String WIFI_CREDENTIAL_CHANGED_ACTION = "android.net.wifi.WIFI_CREDENTIAL_CHANGED";
    @SystemApi
    public static final String EXTRA_WIFI_CREDENTIAL_EVENT_TYPE = "et";
    @SystemApi
    public static final String EXTRA_WIFI_CREDENTIAL_SSID = "ssid";
    @SystemApi
    public static final int WIFI_CREDENTIAL_SAVED = 0;
    @SystemApi
    public static final int WIFI_CREDENTIAL_FORGOT = 1;
    @SystemApi
    public static final int PASSPOINT_HOME_NETWORK = 0;
    @SystemApi
    public static final int PASSPOINT_ROAMING_NETWORK = 1;
    @SystemApi
    public static final int API_SCANNING_ENABLED = 1;
    @SystemApi
    public static final int API_WIFI_ENABLED = 2;
    @SystemApi
    public static final int API_SOFT_AP = 3;
    @SystemApi
    public static final int API_TETHERED_HOTSPOT = 4;
    @SystemApi
    public static final int API_AUTOJOIN_GLOBAL = 5;
    @SystemApi
    public static final int API_SET_SCAN_SCHEDULE = 6;
    @SystemApi
    public static final int API_SET_ONE_SHOT_SCREEN_ON_CONNECTIVITY_SCAN_DELAY = 7;
    @SystemApi
    public static final int API_SET_NETWORK_SELECTION_CONFIG = 8;
    @SystemApi
    public static final int API_SET_THIRD_PARTY_APPS_ENABLING_WIFI_CONFIRMATION_DIALOG = 9;
    @SystemApi
    public static final int API_ADD_NETWORK = 10;
    @SystemApi
    public static final int API_UPDATE_NETWORK = 11;
    @SystemApi
    public static final int API_ALLOW_AUTOJOIN = 12;
    @SystemApi
    public static final int API_CONNECT_CONFIG = 13;
    @SystemApi
    public static final int API_CONNECT_NETWORK_ID = 14;
    @SystemApi
    public static final int API_DISABLE_NETWORK = 15;
    @SystemApi
    public static final int API_ENABLE_NETWORK = 16;
    @SystemApi
    public static final int API_FORGET = 17;
    @SystemApi
    public static final int API_SAVE = 18;
    @SystemApi
    public static final int API_START_SCAN = 19;
    @SystemApi
    public static final int API_START_LOCAL_ONLY_HOTSPOT = 20;
    @SystemApi
    public static final int API_P2P_DISCOVER_PEERS = 21;
    @SystemApi
    public static final int API_P2P_DISCOVER_PEERS_ON_SOCIAL_CHANNELS = 22;
    @SystemApi
    public static final int API_P2P_DISCOVER_PEERS_ON_SPECIFIC_FREQUENCY = 23;
    @SystemApi
    public static final int API_P2P_STOP_PEER_DISCOVERY = 24;
    @SystemApi
    public static final int API_P2P_CONNECT = 25;
    @SystemApi
    public static final int API_P2P_CANCEL_CONNECT = 26;
    @SystemApi
    public static final int API_P2P_CREATE_GROUP = 27;
    @SystemApi
    public static final int API_P2P_CREATE_GROUP_P2P_CONFIG = 28;
    @SystemApi
    public static final int API_P2P_REMOVE_GROUP = 29;
    @SystemApi
    public static final int API_P2P_START_LISTENING = 30;
    @SystemApi
    public static final int API_P2P_STOP_LISTENING = 31;
    @SystemApi
    public static final int API_P2P_SET_CHANNELS = 32;
    @SystemApi
    public static final int API_WIFI_SCANNER_START_SCAN = 33;
    @SystemApi
    public static final int API_SET_TDLS_ENABLED = 34;
    @SystemApi
    public static final int API_SET_TDLS_ENABLED_WITH_MAC_ADDRESS = 35;
    @SystemApi
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static final int API_SET_PNO_SCAN_ENABLED = 36;
    @SystemApi
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static final int API_P2P_DISCOVER_PEERS_WITH_CONFIG_PARAMS = 37;
    public static final int API_MAX = 38;
    public static final String ACTION_PASSPOINT_ICON = "android.net.wifi.action.PASSPOINT_ICON";
    public static final String EXTRA_BSSID_LONG = "android.net.wifi.extra.BSSID_LONG";
    public static final String EXTRA_ICON = "android.net.wifi.extra.ICON";
    public static final String EXTRA_FILENAME = "android.net.wifi.extra.FILENAME";
    public static final String ACTION_PASSPOINT_OSU_PROVIDERS_LIST = "android.net.wifi.action.PASSPOINT_OSU_PROVIDERS_LIST";
    public static final String EXTRA_ANQP_ELEMENT_DATA = "android.net.wifi.extra.ANQP_ELEMENT_DATA";
    public static final String ACTION_PASSPOINT_DEAUTH_IMMINENT = "android.net.wifi.action.PASSPOINT_DEAUTH_IMMINENT";
    public static final String EXTRA_ESS = "android.net.wifi.extra.ESS";
    public static final String EXTRA_DELAY = "android.net.wifi.extra.DELAY";
    public static final String ACTION_PASSPOINT_SUBSCRIPTION_REMEDIATION = "android.net.wifi.action.PASSPOINT_SUBSCRIPTION_REMEDIATION";
    public static final String EXTRA_SUBSCRIPTION_REMEDIATION_METHOD = "android.net.wifi.extra.SUBSCRIPTION_REMEDIATION_METHOD";
    @SystemApi
    public static final String ACTION_PASSPOINT_LAUNCH_OSU_VIEW = "android.net.wifi.action.PASSPOINT_LAUNCH_OSU_VIEW";
    @SystemApi
    public static final String EXTRA_OSU_NETWORK = "android.net.wifi.extra.OSU_NETWORK";
    @SystemApi
    public static final String EXTRA_URL = "android.net.wifi.extra.URL";
    public static final String WIFI_STATE_CHANGED_ACTION = "android.net.wifi.WIFI_STATE_CHANGED";
    public static final String EXTRA_WIFI_STATE = "wifi_state";
    public static final String EXTRA_PREVIOUS_WIFI_STATE = "previous_wifi_state";
    public static final int WIFI_STATE_DISABLING = 0;
    public static final int WIFI_STATE_DISABLED = 1;
    public static final int WIFI_STATE_ENABLING = 2;
    public static final int WIFI_STATE_ENABLED = 3;
    public static final int WIFI_STATE_UNKNOWN = 4;
    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public static final String WIFI_AP_STATE_CHANGED_ACTION = "android.net.wifi.WIFI_AP_STATE_CHANGED";
    @SystemApi
    public static final String EXTRA_WIFI_AP_STATE = "wifi_state";
    @SystemApi
    public static final String EXTRA_WIFI_AP_FAILURE_REASON = "android.net.wifi.extra.WIFI_AP_FAILURE_REASON";
    @SystemApi
    public static final String EXTRA_PREVIOUS_WIFI_AP_STATE = "previous_wifi_state";
    @SystemApi
    public static final String EXTRA_WIFI_AP_INTERFACE_NAME = "android.net.wifi.extra.WIFI_AP_INTERFACE_NAME";
    @SystemApi
    public static final String EXTRA_WIFI_AP_MODE = "android.net.wifi.extra.WIFI_AP_MODE";
    @SystemApi
    public static final int WIFI_AP_STATE_DISABLING = 10;
    @SystemApi
    public static final int WIFI_AP_STATE_DISABLED = 11;
    @SystemApi
    public static final int WIFI_AP_STATE_ENABLING = 12;
    @SystemApi
    public static final int WIFI_AP_STATE_ENABLED = 13;
    @SystemApi
    public static final int WIFI_AP_STATE_FAILED = 14;
    @SystemApi
    public static final int SAP_START_FAILURE_GENERAL = 0;
    @SystemApi
    public static final int SAP_START_FAILURE_NO_CHANNEL = 1;
    @SystemApi
    public static final int SAP_START_FAILURE_UNSUPPORTED_CONFIGURATION = 2;
    @SystemApi
    public static final int SAP_START_FAILURE_USER_REJECTED = 3;
    @SystemApi
    public static final int SAP_CLIENT_BLOCK_REASON_CODE_BLOCKED_BY_USER = 0;
    @SystemApi
    public static final int SAP_CLIENT_BLOCK_REASON_CODE_NO_MORE_STAS = 1;
    public static final int SAP_CLIENT_DISCONNECT_REASON_CODE_UNSPECIFIED = 2;
    @SystemApi
    public static final int IFACE_IP_MODE_UNSPECIFIED = -1;
    @SystemApi
    public static final int IFACE_IP_MODE_CONFIGURATION_ERROR = 0;
    @SystemApi
    public static final int IFACE_IP_MODE_TETHERED = 1;
    @SystemApi
    public static final int IFACE_IP_MODE_LOCAL_ONLY = 2;
    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_CARRIER_PROVISIONING")
    public static final String ACTION_NETWORK_SETTINGS_RESET = "android.net.wifi.action.NETWORK_SETTINGS_RESET";
    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_CARRIER_PROVISIONING")
    public static final String ACTION_REFRESH_USER_PROVISIONING = "android.net.wifi.action.REFRESH_USER_PROVISIONING";
    @Deprecated
    public static final String SUPPLICANT_CONNECTION_CHANGE_ACTION = "android.net.wifi.supplicant.CONNECTION_CHANGE";
    @Deprecated
    public static final String EXTRA_SUPPLICANT_CONNECTED = "connected";
    public static final String NETWORK_STATE_CHANGED_ACTION = "android.net.wifi.STATE_CHANGE";
    public static final String EXTRA_NETWORK_INFO = "networkInfo";
    @Deprecated
    public static final String EXTRA_BSSID = "bssid";
    @Deprecated
    public static final String EXTRA_WIFI_INFO = "wifiInfo";
    @Deprecated
    public static final String SUPPLICANT_STATE_CHANGED_ACTION = "android.net.wifi.supplicant.STATE_CHANGE";
    @Deprecated
    public static final String EXTRA_NEW_STATE = "newState";
    @Deprecated
    public static final String EXTRA_SUPPLICANT_ERROR = "supplicantError";
    @Deprecated
    public static final String EXTRA_SUPPLICANT_ERROR_REASON = "supplicantErrorReason";
    @SystemApi
    public static final String CONFIGURED_NETWORKS_CHANGED_ACTION = "android.net.wifi.CONFIGURED_NETWORKS_CHANGE";
    @Deprecated
    @SystemApi
    public static final String EXTRA_WIFI_CONFIGURATION = "wifiConfiguration";
    @Deprecated
    @SystemApi
    public static final String EXTRA_MULTIPLE_NETWORKS_CHANGED = "multipleChanges";
    @SystemApi
    public static final String EXTRA_CHANGE_REASON = "changeReason";
    @SystemApi
    public static final int CHANGE_REASON_ADDED = 0;
    @SystemApi
    public static final int CHANGE_REASON_REMOVED = 1;
    @SystemApi
    public static final int CHANGE_REASON_CONFIG_CHANGE = 2;
    public static final String SCAN_RESULTS_AVAILABLE_ACTION = "android.net.wifi.SCAN_RESULTS";
    public static final String EXTRA_RESULTS_UPDATED = "resultsUpdated";
    @Deprecated
    public static final String BATCHED_SCAN_RESULTS_AVAILABLE_ACTION = "android.net.wifi.BATCHED_RESULTS";
    public static final String RSSI_CHANGED_ACTION = "android.net.wifi.RSSI_CHANGED";
    public static final String EXTRA_NEW_RSSI = "newRssi";
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final String LINK_CONFIGURATION_CHANGED_ACTION = "android.net.wifi.LINK_CONFIGURATION_CHANGED";
    @SystemApi
    public static final String ACTION_LINK_CONFIGURATION_CHANGED = "android.net.wifi.LINK_CONFIGURATION_CHANGED";
    @Deprecated
    @SystemApi
    public static final String EXTRA_LINK_PROPERTIES = "android.net.wifi.extra.LINK_PROPERTIES";
    public static final String EXTRA_NETWORK_CAPABILITIES = "networkCapabilities";
    public static final String NETWORK_IDS_CHANGED_ACTION = "android.net.wifi.NETWORK_IDS_CHANGED";
    public static final String ACTION_REQUEST_SCAN_ALWAYS_AVAILABLE = "android.net.wifi.action.REQUEST_SCAN_ALWAYS_AVAILABLE";
    public static final String ACTION_PICK_WIFI_NETWORK = "android.net.wifi.PICK_WIFI_NETWORK";
    @SystemApi
    public static final String ACTION_REQUEST_ENABLE = "android.net.wifi.action.REQUEST_ENABLE";
    @SystemApi
    public static final String ACTION_REQUEST_DISABLE = "android.net.wifi.action.REQUEST_DISABLE";
    public static final String ACTION_WIFI_NETWORK_SUGGESTION_POST_CONNECTION = "android.net.wifi.action.WIFI_NETWORK_SUGGESTION_POST_CONNECTION";
    public static final String EXTRA_NETWORK_SUGGESTION = "android.net.wifi.extra.NETWORK_SUGGESTION";
    public static final int WIFI_MODE_NO_LOCKS_HELD = 0;
    @Deprecated
    public static final int WIFI_MODE_FULL = 1;
    @Deprecated
    public static final int WIFI_MODE_SCAN_ONLY = 2;
    @Deprecated
    public static final int WIFI_MODE_FULL_HIGH_PERF = 3;
    public static final int WIFI_MODE_FULL_LOW_LATENCY = 4;
    @UnsupportedAppUsage
    private static final int MIN_RSSI = -100;
    @UnsupportedAppUsage
    private static final int MAX_RSSI = -55;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int RSSI_LEVELS = 5;
    @UnsupportedAppUsage
    public static final int WIFI_FREQUENCY_BAND_AUTO = 0;
    @UnsupportedAppUsage
    public static final int WIFI_FREQUENCY_BAND_5GHZ = 1;
    @UnsupportedAppUsage
    public static final int WIFI_FREQUENCY_BAND_2GHZ = 2;
    public static final boolean DEFAULT_POOR_NETWORK_AVOIDANCE_ENABLED = false;
    private static final int MAX_ACTIVE_LOCKS = 50;
    public static final String UNKNOWN_SSID = "<unknown ssid>";
    public static final MacAddress ALL_ZEROS_MAC_ADDRESS = MacAddress.fromString("00:00:00:00:00:00");
    public static final int WIFI_MULTI_INTERNET_MODE_DISABLED = 0;
    public static final int WIFI_MULTI_INTERNET_MODE_DBS_AP = 1;
    public static final int WIFI_MULTI_INTERNET_MODE_MULTI_AP = 2;
    public static final String CHANNEL_DATA_KEY_FREQUENCY_MHZ = "CHANNEL_DATA_KEY_FREQUENCY_MHZ";
    public static final String CHANNEL_DATA_KEY_NUM_AP = "CHANNEL_DATA_KEY_NUM_AP";
    @SystemApi
    public static final int QOS_REQUEST_STATUS_TRACKING = 0;
    @SystemApi
    public static final int QOS_REQUEST_STATUS_ALREADY_ACTIVE = 1;
    @SystemApi
    public static final int QOS_REQUEST_STATUS_INSUFFICIENT_RESOURCES = 2;
    @SystemApi
    public static final int QOS_REQUEST_STATUS_INVALID_PARAMETERS = 3;
    @SystemApi
    public static final int QOS_REQUEST_STATUS_FAILURE_UNKNOWN = 4;
    private static final int MAX_POLICIES_PER_QOS_REQUEST = 16;
    @UnsupportedAppUsage
    private int mActiveLockCount;
    private Context mContext;
    @UnsupportedAppUsage
    IWifiManager mService;
    private final int mTargetSdkVersion;
    private Looper mLooper;
    private boolean mVerboseLoggingEnabled = false;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private LocalOnlyHotspotCallbackProxy mLOHSCallbackProxy;
    @GuardedBy(value={"mLock"})
    private LocalOnlyHotspotObserverProxy mLOHSObserverProxy;
    private static final SparseArray<IOnWifiUsabilityStatsListener> sOnWifiUsabilityStatsListenerMap = new SparseArray();
    private static final SparseArray<ISuggestionConnectionStatusListener> sSuggestionConnectionStatusListenerMap = new SparseArray();
    private static final SparseArray<ISuggestionUserApprovalStatusListener> sSuggestionUserApprovalStatusListenerMap = new SparseArray();
    private static final SparseArray<IWifiVerboseLoggingStatusChangedListener> sWifiVerboseLoggingStatusChangedListenerMap = new SparseArray();
    private static final SparseArray<INetworkRequestMatchCallback> sNetworkRequestMatchCallbackMap = new SparseArray();
    private static final SparseArray<ITrafficStateCallback> sTrafficStateCallbackMap = new SparseArray();
    private static final SparseArray<ISoftApCallback> sSoftApCallbackMap = new SparseArray();
    private static final SparseArray<IOnWifiDriverCountryCodeChangedListener> sActiveCountryCodeChangedCallbackMap = new SparseArray();
    private static final SparseArray<ISoftApCallback> sLocalOnlyHotspotSoftApCallbackMap = new SparseArray();
    private static final SparseArray<ILocalOnlyConnectionStatusListener> sLocalOnlyConnectionStatusListenerMap = new SparseArray();
    private static final SparseArray<IWifiNetworkStateChangedListener> sOnWifiNetworkStateChangedListenerMap = new SparseArray();
    private static final SparseArray<IWifiLowLatencyLockListener> sWifiLowLatencyLockListenerMap = new SparseArray();
    private static final SparseArray<IWifiStateChangedListener> sWifiStateChangedListenerMap = new SparseArray();
    @SystemApi
    public static final int MLO_MODE_DEFAULT = 0;
    @SystemApi
    public static final int MLO_MODE_LOW_LATENCY = 1;
    @SystemApi
    public static final int MLO_MODE_HIGH_THROUGHPUT = 2;
    @SystemApi
    public static final int MLO_MODE_LOW_POWER = 3;
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static final int ROAMING_MODE_NONE = 0;
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static final int ROAMING_MODE_NORMAL = 1;
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static final int ROAMING_MODE_AGGRESSIVE = 2;
    public static final int WIFI_FEATURE_INFRA = 0;
    public static final int WIFI_FEATURE_PASSPOINT = 2;
    public static final int WIFI_FEATURE_P2P = 3;
    public static final int WIFI_FEATURE_MOBILE_HOTSPOT = 4;
    public static final int WIFI_FEATURE_SCANNER = 5;
    public static final int WIFI_FEATURE_AWARE = 6;
    public static final int WIFI_FEATURE_D2D_RTT = 7;
    public static final int WIFI_FEATURE_D2AP_RTT = 8;
    public static final int WIFI_FEATURE_PNO = 10;
    public static final int WIFI_FEATURE_TDLS = 12;
    public static final int WIFI_FEATURE_TDLS_OFFCHANNEL = 13;
    public static final int WIFI_FEATURE_AP_STA = 15;
    public static final int WIFI_FEATURE_LINK_LAYER_STATS = 16;
    public static final int WIFI_FEATURE_LOGGER = 17;
    public static final int WIFI_FEATURE_RSSI_MONITOR = 19;
    public static final int WIFI_FEATURE_MKEEP_ALIVE = 20;
    public static final int WIFI_FEATURE_CONFIG_NDO = 21;
    public static final int WIFI_FEATURE_CONTROL_ROAMING = 23;
    public static final int WIFI_FEATURE_IE_WHITELIST = 24;
    public static final int WIFI_FEATURE_SCAN_RAND = 25;
    public static final int WIFI_FEATURE_TX_POWER_LIMIT = 26;
    public static final int WIFI_FEATURE_WPA3_SAE = 27;
    public static final int WIFI_FEATURE_WPA3_SUITE_B = 28;
    public static final int WIFI_FEATURE_OWE = 29;
    public static final int WIFI_FEATURE_LOW_LATENCY = 30;
    public static final int WIFI_FEATURE_DPP = 31;
    public static final int WIFI_FEATURE_P2P_RAND_MAC = 32;
    public static final int WIFI_FEATURE_CONNECTED_RAND_MAC = 33;
    public static final int WIFI_FEATURE_AP_RAND_MAC = 34;
    public static final int WIFI_FEATURE_MBO = 35;
    public static final int WIFI_FEATURE_OCE = 36;
    public static final int WIFI_FEATURE_WAPI = 37;
    public static final int WIFI_FEATURE_FILS_SHA256 = 38;
    public static final int WIFI_FEATURE_FILS_SHA384 = 39;
    public static final int WIFI_FEATURE_SAE_PK = 40;
    public static final int WIFI_FEATURE_STA_BRIDGED_AP = 41;
    public static final int WIFI_FEATURE_BRIDGED_AP = 42;
    public static final int WIFI_FEATURE_INFRA_60G = 43;
    public static final int WIFI_FEATURE_ADDITIONAL_STA_LOCAL_ONLY = 44;
    public static final int WIFI_FEATURE_ADDITIONAL_STA_MBB = 45;
    public static final int WIFI_FEATURE_ADDITIONAL_STA_RESTRICTED = 46;
    public static final int WIFI_FEATURE_DPP_ENROLLEE_RESPONDER = 47;
    public static final int WIFI_FEATURE_PASSPOINT_TERMS_AND_CONDITIONS = 48;
    public static final int WIFI_FEATURE_SAE_H2E = 49;
    public static final int WIFI_FEATURE_WFD_R2 = 50;
    public static final int WIFI_FEATURE_DECORATED_IDENTITY = 51;
    public static final int WIFI_FEATURE_TRUST_ON_FIRST_USE = 52;
    public static final int WIFI_FEATURE_ADDITIONAL_STA_MULTI_INTERNET = 53;
    public static final int WIFI_FEATURE_DPP_AKM = 54;
    public static final int WIFI_FEATURE_SET_TLS_MINIMUM_VERSION = 55;
    public static final int WIFI_FEATURE_TLS_V1_3 = 56;
    public static final int WIFI_FEATURE_DUAL_BAND_SIMULTANEOUS = 57;
    public static final int WIFI_FEATURE_T2LM_NEGOTIATION = 58;
    public static final int WIFI_FEATURE_WEP = 59;
    public static final int WIFI_FEATURE_WPA_PERSONAL = 60;
    public static final int WIFI_FEATURE_AGGRESSIVE_ROAMING_MODE_SUPPORT = 61;
    public static final int WIFI_FEATURE_D2D_WHEN_INFRA_STA_DISABLED = 62;
    public static final int WIFI_FEATURE_SOFTAP_MLO = 63;
    public static final int WIFI_FEATURE_MULTIPLE_MLD_ON_SAP = 64;
    @SystemApi
    @RequiresApi(value=31)
    public static final int COEX_RESTRICTION_WIFI_DIRECT = 1;
    @SystemApi
    @RequiresApi(value=31)
    public static final int COEX_RESTRICTION_SOFTAP = 2;
    @SystemApi
    @RequiresApi(value=31)
    public static final int COEX_RESTRICTION_WIFI_AWARE = 4;
    public static final int WPS_OVERLAP_ERROR = 3;
    public static final int WPS_WEP_PROHIBITED = 4;
    public static final int WPS_TKIP_ONLY_PROHIBITED = 5;
    public static final int WPS_AUTH_FAILURE = 6;
    public static final int WPS_TIMED_OUT = 7;
    @SystemApi
    public static final int DEVICE_MOBILITY_STATE_UNKNOWN = 0;
    @SystemApi
    public static final int DEVICE_MOBILITY_STATE_HIGH_MVMT = 1;
    @SystemApi
    public static final int DEVICE_MOBILITY_STATE_LOW_MVMT = 2;
    @SystemApi
    public static final int DEVICE_MOBILITY_STATE_STATIONARY = 3;
    @SystemApi
    public static final int EASY_CONNECT_NETWORK_ROLE_STA = 0;
    @SystemApi
    public static final int EASY_CONNECT_NETWORK_ROLE_AP = 1;
    private static final int EASY_CONNECT_DEVICE_INFO_MAXIMUM_LENGTH = 40;
    @SystemApi
    public static final int EASY_CONNECT_CRYPTOGRAPHY_CURVE_PRIME256V1 = 0;
    @SystemApi
    public static final int EASY_CONNECT_CRYPTOGRAPHY_CURVE_SECP384R1 = 1;
    @SystemApi
    public static final int EASY_CONNECT_CRYPTOGRAPHY_CURVE_SECP521R1 = 2;
    @SystemApi
    public static final int EASY_CONNECT_CRYPTOGRAPHY_CURVE_BRAINPOOLP256R1 = 3;
    @SystemApi
    public static final int EASY_CONNECT_CRYPTOGRAPHY_CURVE_BRAINPOOLP384R1 = 4;
    @SystemApi
    public static final int EASY_CONNECT_CRYPTOGRAPHY_CURVE_BRAINPOOLP512R1 = 5;
    @SystemApi
    public static final int VERBOSE_LOGGING_LEVEL_DISABLED = 0;
    @SystemApi
    public static final int VERBOSE_LOGGING_LEVEL_ENABLED = 1;
    @SystemApi
    public static final int VERBOSE_LOGGING_LEVEL_ENABLED_SHOW_KEY = 2;
    @SystemApi
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static final int VERBOSE_LOGGING_LEVEL_WIFI_AWARE_ENABLED_ONLY = 3;
    public static final String ACTION_LAUNCH_DIALOG = "android.net.wifi.action.LAUNCH_DIALOG";
    public static final String ACTION_DISMISS_DIALOG = "android.net.wifi.action.DISMISS_DIALOG";
    public static final int DIALOG_TYPE_UNKNOWN = 0;
    public static final int DIALOG_TYPE_SIMPLE = 1;
    public static final int DIALOG_TYPE_P2P_INVITATION_SENT = 2;
    public static final int DIALOG_TYPE_P2P_INVITATION_RECEIVED = 3;
    public static final int DIALOG_REPLY_POSITIVE = 0;
    public static final int DIALOG_REPLY_NEGATIVE = 1;
    public static final int DIALOG_REPLY_NEUTRAL = 2;
    public static final int DIALOG_REPLY_CANCELLED = 3;
    public static final int INVALID_DIALOG_ID = -1;
    public static final String EXTRA_DIALOG_TYPE = "android.net.wifi.extra.DIALOG_TYPE";
    public static final String EXTRA_DIALOG_ID = "android.net.wifi.extra.DIALOG_ID";
    public static final String EXTRA_DIALOG_TITLE = "android.net.wifi.extra.DIALOG_TITLE";
    public static final String EXTRA_DIALOG_MESSAGE = "android.net.wifi.extra.DIALOG_MESSAGE";
    public static final String EXTRA_DIALOG_MESSAGE_URL = "android.net.wifi.extra.DIALOG_MESSAGE_URL";
    public static final String EXTRA_DIALOG_MESSAGE_URL_START = "android.net.wifi.extra.DIALOG_MESSAGE_URL_START";
    public static final String EXTRA_DIALOG_MESSAGE_URL_END = "android.net.wifi.extra.DIALOG_MESSAGE_URL_END";
    public static final String EXTRA_DIALOG_POSITIVE_BUTTON_TEXT = "android.net.wifi.extra.DIALOG_POSITIVE_BUTTON_TEXT";
    public static final String EXTRA_DIALOG_NEGATIVE_BUTTON_TEXT = "android.net.wifi.extra.DIALOG_NEGATIVE_BUTTON_TEXT";
    public static final String EXTRA_DIALOG_NEUTRAL_BUTTON_TEXT = "android.net.wifi.extra.DIALOG_NEUTRAL_BUTTON_TEXT";
    public static final String EXTRA_DIALOG_TIMEOUT_MS = "android.net.wifi.extra.DIALOG_TIMEOUT_MS";
    public static final String EXTRA_P2P_DEVICE_NAME = "android.net.wifi.extra.P2P_DEVICE_NAME";
    public static final String EXTRA_P2P_PIN_REQUESTED = "android.net.wifi.extra.P2P_PIN_REQUESTED";
    public static final String EXTRA_P2P_DISPLAY_PIN = "android.net.wifi.extra.P2P_DISPLAY_PIN";
    public static final String EXTRA_CLOSE_SYSTEM_DIALOGS_EXCEPT_WIFI = "android.net.wifi.extra.CLOSE_SYSTEM_DIALOGS_EXCEPT_WIFI";
    public static final int WIFI_INTERFACE_TYPE_STA = 0;
    public static final int WIFI_INTERFACE_TYPE_AP = 1;
    public static final int WIFI_INTERFACE_TYPE_AWARE = 2;
    public static final int WIFI_INTERFACE_TYPE_DIRECT = 3;
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static final int FLAG_SEND_DHCP_HOSTNAME_RESTRICTION_OPEN = 1;
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static final int FLAG_SEND_DHCP_HOSTNAME_RESTRICTION_SECURE = 2;
    @SystemApi
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static final String TWT_CAPABILITIES_KEY_BOOLEAN_TWT_REQUESTER = "key_requester";
    @SystemApi
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static final String TWT_CAPABILITIES_KEY_INT_MIN_WAKE_DURATION_MICROS = "key_min_wake_duration";
    @SystemApi
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static final String TWT_CAPABILITIES_KEY_INT_MAX_WAKE_DURATION_MICROS = "key_max_wake_duration";
    @SystemApi
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static final String TWT_CAPABILITIES_KEY_LONG_MIN_WAKE_INTERVAL_MICROS = "key_min_wake_interval";
    @SystemApi
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static final String TWT_CAPABILITIES_KEY_LONG_MAX_WAKE_INTERVAL_MICROS = "key_max_wake_interval";

    @SystemApi
    public static int getMaxNumberOfPoliciesPerQosRequest() {
        return 16;
    }

    public WifiManager(@NonNull Context context, @NonNull IWifiManager service) {
        this.mContext = context;
        this.mService = service;
        this.mTargetSdkVersion = context.getApplicationInfo().targetSdkVersion;
        this.updateVerboseLoggingEnabledFromService();
    }

    @Deprecated
    @RequiresPermission(allOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_WIFI_STATE"})
    public List<WifiConfiguration> getConfiguredNetworks() {
        try {
            ParceledListSlice parceledList = this.mService.getConfiguredNetworks(this.mContext.getOpPackageName(), this.mContext.getAttributionTag(), false);
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    @NonNull
    public List<WifiConfiguration> getCallerConfiguredNetworks() {
        try {
            ParceledListSlice parceledList = this.mService.getConfiguredNetworks(this.mContext.getOpPackageName(), this.mContext.getAttributionTag(), true);
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.NEARBY_WIFI_DEVICES", "android.permission.ACCESS_WIFI_STATE", "android.permission.READ_WIFI_CREDENTIAL"}, conditional=true)
    public List<WifiConfiguration> getPrivilegedConfiguredNetworks() {
        try {
            ParceledListSlice parceledList;
            Bundle extras = new Bundle();
            if (SdkLevel.isAtLeastS()) {
                extras.putParcelable(EXTRA_PARAM_KEY_ATTRIBUTION_SOURCE, this.mContext.getAttributionSource());
            }
            if ((parceledList = this.mService.getPrivilegedConfiguredNetworks(this.mContext.getOpPackageName(), this.mContext.getAttributionTag(), extras)) == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.NEARBY_WIFI_DEVICES", "android.permission.ACCESS_WIFI_STATE", "android.permission.READ_WIFI_CREDENTIAL"}, conditional=true)
    @Nullable
    public WifiConfiguration getPrivilegedConnectedNetwork() {
        try {
            Bundle extras = new Bundle();
            if (SdkLevel.isAtLeastS()) {
                extras.putParcelable(EXTRA_PARAM_KEY_ATTRIBUTION_SOURCE, this.mContext.getAttributionSource());
            }
            return this.mService.getPrivilegedConnectedNetwork(this.mContext.getOpPackageName(), this.mContext.getAttributionTag(), extras);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    @NonNull
    public List<Pair<WifiConfiguration, Map<Integer, List<ScanResult>>>> getAllMatchingWifiConfigs(@NonNull List<ScanResult> scanResults) {
        ArrayList<Pair<WifiConfiguration, Map<Integer, List<ScanResult>>>> configs = new ArrayList<Pair<WifiConfiguration, Map<Integer, List<ScanResult>>>>();
        try {
            Map results = this.mService.getAllMatchingPasspointProfilesForScanResults(new ParceledListSlice<ScanResult>(scanResults));
            if (results.isEmpty()) {
                return configs;
            }
            List wifiConfigurations = this.mService.getWifiConfigsForPasspointProfiles(new StringParceledListSlice((List<String>)new ArrayList<String>(results.keySet()))).getList();
            for (WifiConfiguration configuration : wifiConfigurations) {
                Map scanResultsPerNetworkType = (Map)results.get(configuration.getProfileKey());
                if (scanResultsPerNetworkType == null) continue;
                configs.add(Pair.create(configuration, scanResultsPerNetworkType));
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return configs;
    }

    @SystemApi
    @RequiresApi(value=33)
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.MANAGE_WIFI_NETWORK_SELECTION"})
    public void setNetworkSelectionConfig(@NonNull WifiNetworkSelectionConfig nsConfig) {
        try {
            if (nsConfig == null) {
                throw new IllegalArgumentException("nsConfig can not be null");
            }
            this.mService.setNetworkSelectionConfig(nsConfig);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=33)
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.MANAGE_WIFI_NETWORK_SELECTION"})
    public void getNetworkSelectionConfig(final @NonNull Executor executor, final @NonNull Consumer<WifiNetworkSelectionConfig> resultsCallback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(resultsCallback, "resultsCallback cannot be null");
        try {
            this.mService.getNetworkSelectionConfig(new IWifiNetworkSelectionConfigListener.Stub(this){

                @Override
                public void onResult(WifiNetworkSelectionConfig value) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> resultsCallback.accept(value));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public void setThirdPartyAppEnablingWifiConfirmationDialogEnabled(boolean enable) {
        try {
            this.mService.setThirdPartyAppEnablingWifiConfirmationDialogEnabled(enable);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public boolean isThirdPartyAppEnablingWifiConfirmationDialogEnabled() {
        try {
            return this.mService.isThirdPartyAppEnablingWifiConfirmationDialogEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=33)
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.MANAGE_WIFI_NETWORK_SELECTION"})
    public void setScreenOnScanSchedule(@Nullable List<ScreenOnScanSchedule> screenOnScanSchedule) {
        try {
            if (screenOnScanSchedule == null) {
                this.mService.setScreenOnScanSchedule(null, null);
                return;
            }
            if (screenOnScanSchedule.isEmpty()) {
                throw new IllegalArgumentException("The input should either be null or a non-empty list");
            }
            int[] scanSchedule = new int[screenOnScanSchedule.size()];
            int[] scanType = new int[screenOnScanSchedule.size()];
            for (int i = 0; i < screenOnScanSchedule.size(); ++i) {
                scanSchedule[i] = (int)screenOnScanSchedule.get(i).getScanInterval().toSeconds();
                scanType[i] = screenOnScanSchedule.get(i).getScanType();
            }
            this.mService.setScreenOnScanSchedule(scanSchedule, scanType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=33)
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.MANAGE_WIFI_NETWORK_SELECTION"})
    public void setOneShotScreenOnConnectivityScanDelayMillis(int delayMs) {
        try {
            this.mService.setOneShotScreenOnConnectivityScanDelayMillis(delayMs);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    @NonNull
    public List<WifiConfiguration> getWifiConfigForMatchedNetworkSuggestionsSharedWithUser(@NonNull List<ScanResult> scanResults) {
        try {
            return this.mService.getWifiConfigForMatchedNetworkSuggestionsSharedWithUser(new ParceledListSlice<ScanResult>(scanResults)).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.MANAGE_WIFI_NETWORK_SELECTION"}, conditional=true)
    public void setSsidsAllowlist(@NonNull Set<WifiSsid> ssids) {
        if (ssids == null) {
            throw new IllegalArgumentException("WifiManager: ssids can not be null");
        }
        try {
            this.mService.setSsidsAllowlist(this.mContext.getOpPackageName(), new ParceledListSlice<WifiSsid>(new ArrayList<WifiSsid>(ssids)));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.MANAGE_WIFI_NETWORK_SELECTION"}, conditional=true)
    @NonNull
    public Set<WifiSsid> getSsidsAllowlist() {
        try {
            return new ArraySet<WifiSsid>(this.mService.getSsidsAllowlist(this.mContext.getOpPackageName()).getList());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    @NonNull
    public Map<OsuProvider, List<ScanResult>> getMatchingOsuProviders(@Nullable List<ScanResult> scanResults) {
        if (scanResults == null) {
            return new HashMap<OsuProvider, List<ScanResult>>();
        }
        try {
            return this.mService.getMatchingOsuProviders(new ParceledListSlice<ScanResult>(scanResults));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    @NonNull
    public Map<OsuProvider, PasspointConfiguration> getMatchingPasspointConfigsForOsuProviders(@NonNull Set<OsuProvider> osuProviders) {
        try {
            return this.mService.getMatchingPasspointConfigsForOsuProviders(new ParceledListSlice<OsuProvider>(new ArrayList<OsuProvider>(osuProviders)));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public int addNetwork(WifiConfiguration config) {
        if (config == null) {
            return -1;
        }
        config.networkId = -1;
        return this.addOrUpdateNetwork(config);
    }

    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_STACK", "android.permission.NETWORK_SETUP_WIZARD", "android.permission.NETWORK_MANAGED_PROVISIONING"}, conditional=true)
    @NonNull
    public AddNetworkResult addNetworkPrivileged(@NonNull WifiConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException("config cannot be null");
        }
        if (config.isSecurityType(13) && !this.isFeatureSupported(54)) {
            throw new IllegalArgumentException("dpp akm is not supported");
        }
        config.networkId = -1;
        try {
            return this.mService.addOrUpdateNetworkPrivileged(config, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public int updateNetwork(WifiConfiguration config) {
        if (config == null || config.networkId < 0) {
            return -1;
        }
        return this.addOrUpdateNetwork(config);
    }

    private int addOrUpdateNetwork(WifiConfiguration config) {
        Bundle extras = new Bundle();
        if (SdkLevel.isAtLeastS()) {
            extras.putParcelable(EXTRA_PARAM_KEY_ATTRIBUTION_SOURCE, this.mContext.getAttributionSource());
        }
        try {
            return this.mService.addOrUpdateNetwork(config, this.mContext.getOpPackageName(), extras);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void registerNetworkRequestMatchCallback(@NonNull Executor executor, @NonNull NetworkRequestMatchCallback callback) {
        if (executor == null) {
            throw new IllegalArgumentException("executor cannot be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        Log.v(TAG, "registerNetworkRequestMatchCallback: callback=" + callback + ", executor=" + executor);
        try {
            SparseArray<INetworkRequestMatchCallback> sparseArray = sNetworkRequestMatchCallbackMap;
            synchronized (sparseArray) {
                NetworkRequestMatchCallbackProxy binderCallback = new NetworkRequestMatchCallbackProxy(executor, callback);
                sNetworkRequestMatchCallbackMap.put(System.identityHashCode(callback), binderCallback);
                this.mService.registerNetworkRequestMatchCallback(binderCallback);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void unregisterNetworkRequestMatchCallback(@NonNull NetworkRequestMatchCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        Log.v(TAG, "unregisterNetworkRequestMatchCallback: callback=" + callback);
        try {
            SparseArray<INetworkRequestMatchCallback> sparseArray = sNetworkRequestMatchCallbackMap;
            synchronized (sparseArray) {
                int callbackIdentifier = System.identityHashCode(callback);
                if (!sNetworkRequestMatchCallbackMap.contains(callbackIdentifier)) {
                    Log.w(TAG, "Unknown external callback " + callbackIdentifier);
                    return;
                }
                this.mService.unregisterNetworkRequestMatchCallback(sNetworkRequestMatchCallbackMap.get(callbackIdentifier));
                sNetworkRequestMatchCallbackMap.remove(callbackIdentifier);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void removeAppState(int targetAppUid, @NonNull String targetAppPackageName) {
        try {
            this.mService.removeAppState(targetAppUid, targetAppPackageName);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @RequiresPermission(value="android.permission.CHANGE_WIFI_STATE")
    public int addNetworkSuggestions(@NonNull List<WifiNetworkSuggestion> networkSuggestions) {
        try {
            return this.mService.addNetworkSuggestions(new ParceledListSlice<WifiNetworkSuggestion>(networkSuggestions), this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.CHANGE_WIFI_STATE")
    public int removeNetworkSuggestions(@NonNull List<WifiNetworkSuggestion> networkSuggestions) {
        return this.removeNetworkSuggestions(networkSuggestions, 2);
    }

    @RequiresPermission(value="android.permission.CHANGE_WIFI_STATE")
    public int removeNetworkSuggestions(@NonNull List<WifiNetworkSuggestion> networkSuggestions, int action) {
        try {
            return this.mService.removeNetworkSuggestions(new ParceledListSlice<WifiNetworkSuggestion>(networkSuggestions), this.mContext.getOpPackageName(), action);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    @NonNull
    public List<WifiNetworkSuggestion> getNetworkSuggestions() {
        try {
            return this.mService.getNetworkSuggestions(this.mContext.getOpPackageName()).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public int getMaxNumberOfNetworkSuggestionsPerApp() {
        return WifiManager.getMaxNumberOfNetworkSuggestionsPerApp(this.mContext.getSystemService(ActivityManager.class).isLowRamDevice());
    }

    public static int getMaxNumberOfNetworkSuggestionsPerApp(boolean isLowRamDevice) {
        return isLowRamDevice ? 256 : 1024;
    }

    public void addOrUpdatePasspointConfiguration(PasspointConfiguration config) {
        try {
            if (!this.mService.addOrUpdatePasspointConfiguration(config, this.mContext.getOpPackageName())) {
                throw new IllegalArgumentException();
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void removePasspointConfiguration(String fqdn) {
        try {
            if (!this.mService.removePasspointConfiguration(fqdn, this.mContext.getOpPackageName())) {
                throw new IllegalArgumentException();
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public List<PasspointConfiguration> getPasspointConfigurations() {
        try {
            return this.mService.getPasspointConfigurations(this.mContext.getOpPackageName()).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void queryPasspointIcon(long bssid, String fileName) {
        try {
            this.mService.queryPasspointIcon(bssid, fileName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int matchProviderWithCurrentNetwork(String fqdn) {
        try {
            return this.mService.matchProviderWithCurrentNetwork(fqdn);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public boolean removeNetwork(int netId) {
        try {
            return this.mService.removeNetwork(netId, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.CHANGE_WIFI_STATE")
    public boolean removeNonCallerConfiguredNetworks() {
        try {
            return this.mService.removeNonCallerConfiguredNetworks(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public boolean enableNetwork(int netId, boolean attemptConnect) {
        try {
            return this.mService.enableNetwork(netId, attemptConnect, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public boolean disableNetwork(int netId) {
        try {
            return this.mService.disableNetwork(netId, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public boolean disconnect() {
        try {
            return this.mService.disconnect(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public boolean reconnect() {
        try {
            return this.mService.reconnect(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public boolean reassociate() {
        try {
            return this.mService.reassociate(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public boolean pingSupplicant() {
        return this.isWifiEnabled();
    }

    private boolean isFeatureSupported(int feature) {
        try {
            return this.mService.isFeatureSupported(feature);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isPasspointSupported() {
        return this.mContext.getPackageManager().hasSystemFeature("android.hardware.wifi.passpoint") && this.isFeatureSupported(2);
    }

    public boolean isP2pSupported() {
        return this.mContext.getPackageManager().hasSystemFeature("android.hardware.wifi.direct") && this.isFeatureSupported(3);
    }

    @SystemApi
    public boolean isPortableHotspotSupported() {
        return this.isFeatureSupported(4);
    }

    @SystemApi
    public boolean isWifiScannerSupported() {
        return this.isFeatureSupported(5);
    }

    public boolean isWifiAwareSupported() {
        return this.mContext.getPackageManager().hasSystemFeature("android.hardware.wifi.aware") && this.isFeatureSupported(6);
    }

    public boolean isStaApConcurrencySupported() {
        return this.isFeatureSupported(15);
    }

    public boolean isStaConcurrencyForLocalOnlyConnectionsSupported() {
        return this.isFeatureSupported(44);
    }

    public boolean isMakeBeforeBreakWifiSwitchingSupported() {
        return this.isFeatureSupported(45);
    }

    @RequiresApi(value=33)
    public boolean isStaConcurrencyForMultiInternetSupported() {
        return this.isFeatureSupported(53);
    }

    @SystemApi
    public boolean isStaConcurrencyForRestrictedConnectionsSupported() {
        return this.isFeatureSupported(46);
    }

    @Deprecated
    @SystemApi
    public boolean isDeviceToDeviceRttSupported() {
        return this.isFeatureSupported(7);
    }

    @Deprecated
    public boolean isDeviceToApRttSupported() {
        return this.isFeatureSupported(8);
    }

    public boolean isPreferredNetworkOffloadSupported() {
        try {
            return this.mService.isPnoSupported();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isTdlsSupported() {
        return this.isFeatureSupported(12);
    }

    public boolean isOffChannelTdlsSupported() {
        return this.isFeatureSupported(13);
    }

    public boolean isEnhancedPowerReportingSupported() {
        return this.isFeatureSupported(16);
    }

    @SystemApi
    public boolean isConnectedMacRandomizationSupported() {
        return this.isFeatureSupported(33);
    }

    @SystemApi
    public boolean isApMacRandomizationSupported() {
        return this.isFeatureSupported(34);
    }

    @SystemApi
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public boolean isLowLatencyModeSupported() {
        return this.isFeatureSupported(30);
    }

    public boolean is24GHzBandSupported() {
        try {
            return this.mService.is24GHzBandSupported();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean is5GHzBandSupported() {
        try {
            return this.mService.is5GHzBandSupported();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresApi(value=31)
    public boolean is60GHzBandSupported() {
        try {
            return this.mService.is60GHzBandSupported();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean is6GHzBandSupported() {
        try {
            return this.mService.is6GHzBandSupported();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isWifiStandardSupported(int standard) {
        try {
            return this.mService.isWifiStandardSupported(standard);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isStaBridgedApConcurrencySupported() {
        return this.isFeatureSupported(41);
    }

    public boolean isBridgedApConcurrencySupported() {
        return this.isFeatureSupported(42);
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public boolean isD2dSupportedWhenInfraStaDisabled() {
        return this.isFeatureSupported(62);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public void getWifiActivityEnergyInfoAsync(@NonNull Executor executor, @NonNull OnWifiActivityEnergyInfoListener listener) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(listener, "listener cannot be null");
        try {
            this.mService.getWifiActivityEnergyInfoAsync(new OnWifiActivityEnergyInfoProxy(executor, listener));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public boolean startScan() {
        return this.startScan(null);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.UPDATE_DEVICE_STATS")
    public boolean startScan(WorkSource workSource) {
        try {
            String packageName = this.mContext.getOpPackageName();
            String attributionTag = this.mContext.getAttributionTag();
            return this.mService.startScan(packageName, attributionTag);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public String getCurrentNetworkWpsNfcConfigurationToken() {
        return null;
    }

    @Deprecated
    @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE", "android.permission.ACCESS_FINE_LOCATION"}, conditional=true)
    public WifiInfo getConnectionInfo() {
        try {
            return this.mService.getConnectionInfo(this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE", "android.permission.ACCESS_FINE_LOCATION"})
    public List<ScanResult> getScanResults() {
        try {
            ParceledListSlice parceledList = this.mService.getScanResults(this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_WIFI_STATE"})
    @NonNull
    public Map<WifiNetworkSuggestion, List<ScanResult>> getMatchingScanResults(@NonNull List<WifiNetworkSuggestion> networkSuggestionsToMatch, @Nullable List<ScanResult> scanResults) {
        if (networkSuggestionsToMatch == null) {
            throw new IllegalArgumentException("networkSuggestions must not be null.");
        }
        try {
            return this.mService.getMatchingScanResults(new ParceledListSlice<WifiNetworkSuggestion>(networkSuggestionsToMatch), new ParceledListSlice<ScanResult>(scanResults), this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void setScanAlwaysAvailable(boolean isAvailable) {
        try {
            this.mService.setScanAlwaysAvailable(isAvailable, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public boolean isScanAlwaysAvailable() {
        try {
            return this.mService.isScanAlwaysAvailable();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresApi(value=33)
    @RequiresPermission(value="android.permission.NEARBY_WIFI_DEVICES")
    public void getChannelData(final @NonNull Executor executor, final @NonNull Consumer<List<Bundle>> resultsCallback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(resultsCallback, "resultsCallback cannot be null");
        try {
            Bundle extras = new Bundle();
            extras.putParcelable(EXTRA_PARAM_KEY_ATTRIBUTION_SOURCE, this.mContext.getAttributionSource());
            this.mService.getChannelData(new IListListener.Stub(this){

                @Override
                public void onResult(List value) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> resultsCallback.accept(value));
                }
            }, this.mContext.getOpPackageName(), extras);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public boolean saveConfiguration() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresApi(value=33)
    @RequiresPermission(value="android.permission.ACCESS_COARSE_LOCATION")
    public void registerActiveCountryCodeChangedCallback(@NonNull Executor executor, @NonNull ActiveCountryCodeChangedCallback callback) {
        if (!SdkLevel.isAtLeastT()) {
            throw new UnsupportedOperationException();
        }
        if (executor == null) {
            throw new IllegalArgumentException("executor cannot be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        if (this.mVerboseLoggingEnabled) {
            Log.d(TAG, "registerActiveCountryCodeChangedCallback: callback=" + callback + ", executor=" + executor);
        }
        int callbackIdentifier = System.identityHashCode(callback);
        SparseArray<IOnWifiDriverCountryCodeChangedListener> sparseArray = sActiveCountryCodeChangedCallbackMap;
        synchronized (sparseArray) {
            try {
                OnDriverCountryCodeChangedProxy binderListener = new OnDriverCountryCodeChangedProxy(executor, callback);
                sActiveCountryCodeChangedCallbackMap.put(callbackIdentifier, binderListener);
                this.mService.registerDriverCountryCodeChangedListener(binderListener, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
            catch (RemoteException e) {
                sActiveCountryCodeChangedCallbackMap.remove(callbackIdentifier);
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresApi(value=33)
    public void unregisterActiveCountryCodeChangedCallback(@NonNull ActiveCountryCodeChangedCallback callback) {
        if (!SdkLevel.isAtLeastT()) {
            throw new UnsupportedOperationException();
        }
        if (callback == null) {
            throw new IllegalArgumentException("Callback cannot be null");
        }
        if (this.mVerboseLoggingEnabled) {
            Log.d(TAG, "unregisterActiveCountryCodeChangedCallback: callback=" + callback);
        }
        int callbackIdentifier = System.identityHashCode(callback);
        SparseArray<IOnWifiDriverCountryCodeChangedListener> sparseArray = sActiveCountryCodeChangedCallbackMap;
        synchronized (sparseArray) {
            try {
                if (!sActiveCountryCodeChangedCallbackMap.contains(callbackIdentifier)) {
                    Log.w(TAG, "Unknown external listener " + callbackIdentifier);
                    return;
                }
                this.mService.unregisterDriverCountryCodeChangedListener(sActiveCountryCodeChangedCallbackMap.get(callbackIdentifier));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            finally {
                sActiveCountryCodeChangedCallbackMap.remove(callbackIdentifier);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void addWifiNetworkStateChangedListener(@NonNull Executor executor, @NonNull WifiNetworkStateChangedListener listener) {
        if (executor == null) {
            throw new IllegalArgumentException("executor cannot be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        if (this.mVerboseLoggingEnabled) {
            Log.d(TAG, "addWifiNetworkStateChangedListener: listener=" + listener + ", executor=" + executor);
        }
        int listenerIdentifier = System.identityHashCode(listener);
        SparseArray<IWifiNetworkStateChangedListener> sparseArray = sOnWifiNetworkStateChangedListenerMap;
        synchronized (sparseArray) {
            try {
                OnWifiNetworkStateChangedProxy listenerProxy = new OnWifiNetworkStateChangedProxy(executor, listener);
                sOnWifiNetworkStateChangedListenerMap.put(listenerIdentifier, listenerProxy);
                this.mService.addWifiNetworkStateChangedListener(listenerProxy);
            }
            catch (RemoteException e) {
                sOnWifiNetworkStateChangedListenerMap.remove(listenerIdentifier);
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresApi(value=33)
    public void removeWifiNetworkStateChangedListener(@NonNull WifiNetworkStateChangedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        if (this.mVerboseLoggingEnabled) {
            Log.d(TAG, "removeWifiNetworkStateChangedListener: listener=" + listener);
        }
        int listenerIdentifier = System.identityHashCode(listener);
        SparseArray<IWifiNetworkStateChangedListener> sparseArray = sOnWifiNetworkStateChangedListenerMap;
        synchronized (sparseArray) {
            try {
                if (!sOnWifiNetworkStateChangedListenerMap.contains(listenerIdentifier)) {
                    Log.w(TAG, "Unknown external listener " + listenerIdentifier);
                    return;
                }
                this.mService.removeWifiNetworkStateChangedListener(sOnWifiNetworkStateChangedListenerMap.get(listenerIdentifier));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            finally {
                sOnWifiNetworkStateChangedListenerMap.remove(listenerIdentifier);
            }
        }
    }

    @SystemApi
    @Nullable
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.ACCESS_COARSE_LOCATION"})
    public String getCountryCode() {
        try {
            return this.mService.getCountryCode(this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=31)
    @RequiresPermission(value="android.permission.MANAGE_WIFI_COUNTRY_CODE")
    public void setOverrideCountryCode(@NonNull String country) {
        try {
            this.mService.setOverrideCountryCode(country);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=31)
    @RequiresPermission(value="android.permission.MANAGE_WIFI_COUNTRY_CODE")
    public void clearOverrideCountryCode() {
        try {
            this.mService.clearOverrideCountryCode();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=31)
    @RequiresPermission(value="android.permission.MANAGE_WIFI_COUNTRY_CODE")
    public void setDefaultCountryCode(@NonNull String country) {
        try {
            this.mService.setDefaultCountryCode(country);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public DhcpInfo getDhcpInfo() {
        try {
            return this.mService.getDhcpInfo(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public boolean setWifiEnabled(boolean enabled) {
        try {
            return this.mService.setWifiEnabled(this.mContext.getOpPackageName(), enabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresApi(value=31)
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public void registerSubsystemRestartTrackingCallback(@NonNull Executor executor, @NonNull SubsystemRestartTrackingCallback callback) {
        if (executor == null) {
            throw new IllegalArgumentException("executor must not be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        SubsystemRestartTrackingCallback.SubsystemRestartCallbackProxy proxy = callback.getProxy();
        proxy.initProxy(executor, callback);
        try {
            this.mService.registerSubsystemRestartCallback(proxy);
        }
        catch (RemoteException e) {
            proxy.cleanUpProxy();
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresApi(value=31)
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public void unregisterSubsystemRestartTrackingCallback(@NonNull SubsystemRestartTrackingCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        SubsystemRestartTrackingCallback.SubsystemRestartCallbackProxy proxy = callback.getProxy();
        try {
            this.mService.unregisterSubsystemRestartCallback(proxy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        finally {
            proxy.cleanUpProxy();
        }
    }

    @SystemApi
    @RequiresApi(value=31)
    @RequiresPermission(value="android.permission.RESTART_WIFI_SUBSYSTEM")
    public void restartWifiSubsystem() {
        try {
            this.mService.restartWifiSubsystem();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getWifiState() {
        try {
            return this.mService.getWifiEnabledState();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isWifiEnabled() {
        return this.getWifiState() == 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="com.android.wifi.flags.wifi_state_changed_listener")
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public void addWifiStateChangedListener(@NonNull Executor executor, @NonNull WifiStateChangedListener listener) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(listener);
        if (this.mVerboseLoggingEnabled) {
            Log.d(TAG, "addWifiStateChangedListener: listener=" + listener + ", executor=" + executor);
        }
        int listenerIdentifier = System.identityHashCode(listener);
        SparseArray<IWifiStateChangedListener> sparseArray = sWifiStateChangedListenerMap;
        synchronized (sparseArray) {
            try {
                if (sWifiStateChangedListenerMap.contains(listenerIdentifier)) {
                    Log.w(TAG, "Same listener already registered");
                    return;
                }
                WifiStateChangedListenerProxy listenerProxy = new WifiStateChangedListenerProxy(executor, listener);
                sWifiStateChangedListenerMap.put(listenerIdentifier, listenerProxy);
                this.mService.addWifiStateChangedListener(listenerProxy);
            }
            catch (RemoteException e) {
                sWifiStateChangedListenerMap.remove(listenerIdentifier);
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="com.android.wifi.flags.wifi_state_changed_listener")
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public void removeWifiStateChangedListener(@NonNull WifiStateChangedListener listener) {
        Objects.requireNonNull(listener);
        if (this.mVerboseLoggingEnabled) {
            Log.d(TAG, "removeWifiStateChangedListener: listener=" + listener);
        }
        int listenerIdentifier = System.identityHashCode(listener);
        SparseArray<IWifiStateChangedListener> sparseArray = sWifiStateChangedListenerMap;
        synchronized (sparseArray) {
            try {
                if (!sWifiStateChangedListenerMap.contains(listenerIdentifier)) {
                    Log.w(TAG, "Unknown external listener " + listenerIdentifier);
                    return;
                }
                this.mService.removeWifiStateChangedListener(sWifiStateChangedListenerMap.get(listenerIdentifier));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            finally {
                sWifiStateChangedListenerMap.remove(listenerIdentifier);
            }
        }
    }

    @Deprecated
    public static int calculateSignalLevel(int rssi, int numLevels) {
        if (rssi <= -100) {
            return 0;
        }
        if (rssi >= -55) {
            return numLevels - 1;
        }
        float inputRange = 45.0f;
        float outputRange = numLevels - 1;
        return (int)((float)(rssi - -100) * outputRange / inputRange);
    }

    public int calculateSignalLevel(int rssi) {
        try {
            return this.mService.calculateSignalLevel(rssi);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getMaxSignalLevel() {
        return this.calculateSignalLevel(Integer.MAX_VALUE);
    }

    public static int compareSignalLevel(int rssiA, int rssiB) {
        return rssiA - rssiB;
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_STACK", "android.permission.MAINLINE_NETWORK_STACK"})
    public void updateInterfaceIpState(@Nullable String ifaceName, int mode) {
        try {
            this.mService.updateInterfaceIpState(ifaceName, mode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isDefaultCoexAlgorithmEnabled() {
        try {
            return this.mService.isDefaultCoexAlgorithmEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WIFI_UPDATE_COEX_UNSAFE_CHANNELS")
    @RequiresApi(value=31)
    public void setCoexUnsafeChannels(@NonNull List<CoexUnsafeChannel> unsafeChannels, int restrictions) {
        if (unsafeChannels == null) {
            throw new IllegalArgumentException("unsafeChannels must not be null");
        }
        try {
            this.mService.setCoexUnsafeChannels(unsafeChannels, restrictions);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WIFI_ACCESS_COEX_UNSAFE_CHANNELS")
    @RequiresApi(value=31)
    public void registerCoexCallback(@NonNull Executor executor, @NonNull CoexCallback callback) {
        if (executor == null) {
            throw new IllegalArgumentException("executor must not be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        CoexCallback.CoexCallbackProxy proxy = callback.getProxy();
        proxy.initProxy(executor, callback);
        try {
            this.mService.registerCoexCallback(proxy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WIFI_ACCESS_COEX_UNSAFE_CHANNELS")
    @RequiresApi(value=31)
    public void unregisterCoexCallback(@NonNull CoexCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        CoexCallback.CoexCallbackProxy proxy = callback.getProxy();
        try {
            this.mService.unregisterCoexCallback(proxy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        finally {
            proxy.cleanUpProxy();
        }
    }

    @RequiresPermission(anyOf={"android.permission.NETWORK_STACK", "android.permission.MAINLINE_NETWORK_STACK"})
    public boolean startSoftAp(@Nullable WifiConfiguration wifiConfig) {
        try {
            return this.mService.startSoftAp(wifiConfig, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @Deprecated
    @RequiresPermission(anyOf={"android.permission.NETWORK_STACK", "android.permission.MAINLINE_NETWORK_STACK"})
    public boolean startTetheredHotspot(@Nullable SoftApConfiguration softApConfig) {
        try {
            return this.mService.startTetheredHotspot(softApConfig, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @RequiresPermission(anyOf={"android.permission.NETWORK_STACK", "android.permission.MAINLINE_NETWORK_STACK"})
    public void startTetheredHotspot(@NonNull TetheringManager.TetheringRequest request, @NonNull Executor executor, @NonNull SoftApCallback callback) {
        if (executor == null) {
            throw new IllegalArgumentException("executor cannot be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        SoftApCallbackProxy binderCallback = new SoftApCallbackProxy(executor, callback, 1);
        try {
            this.mService.startTetheredHotspotRequest(request, binderCallback, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_STACK", "android.permission.MAINLINE_NETWORK_STACK"})
    public boolean stopSoftAp() {
        try {
            return this.mService.stopSoftAp();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean validateSoftApConfiguration(@NonNull SoftApConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException("WifiManager: config can not be null");
        }
        try {
            return this.mService.validateSoftApConfiguration(config);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(allOf={"android.permission.CHANGE_WIFI_STATE", "android.permission.ACCESS_FINE_LOCATION", "android.permission.NEARBY_WIFI_DEVICES"}, conditional=true)
    public void startLocalOnlyHotspot(LocalOnlyHotspotCallback callback, @Nullable Handler handler) {
        HandlerExecutor executor = handler == null ? null : new HandlerExecutor(handler);
        this.startLocalOnlyHotspotInternal(null, executor, callback, false);
    }

    @RequiresPermission(allOf={"android.permission.CHANGE_WIFI_STATE", "android.permission.NEARBY_WIFI_DEVICES"})
    @FlaggedApi(value="com.android.wifi.flags.public_bands_for_lohs")
    public void startLocalOnlyHotspotWithConfiguration(@NonNull SoftApConfiguration config, @NonNull Executor executor, @NonNull LocalOnlyHotspotCallback callback) {
        Objects.requireNonNull(config);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        this.startLocalOnlyHotspotInternal(config, executor, callback, false);
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD", "android.permission.NEARBY_WIFI_DEVICES"})
    public void startLocalOnlyHotspot(@NonNull SoftApConfiguration config, @Nullable Executor executor, @Nullable LocalOnlyHotspotCallback callback) {
        Objects.requireNonNull(config);
        this.startLocalOnlyHotspotInternal(config, executor, callback, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLocalOnlyHotspotInternal(@Nullable SoftApConfiguration config, @Nullable Executor executor, @Nullable LocalOnlyHotspotCallback callback, boolean isCalledFromSystemApi) {
        if (executor == null) {
            executor = this.mContext.getMainExecutor();
        }
        Object object = this.mLock;
        synchronized (object) {
            LocalOnlyHotspotCallbackProxy proxy = new LocalOnlyHotspotCallbackProxy(this, executor, callback);
            try {
                int returnCode;
                String packageName = this.mContext.getOpPackageName();
                String featureId = this.mContext.getAttributionTag();
                Bundle extras = new Bundle();
                if (SdkLevel.isAtLeastS()) {
                    extras.putParcelable(EXTRA_PARAM_KEY_ATTRIBUTION_SOURCE, this.mContext.getAttributionSource());
                }
                if ((returnCode = this.mService.startLocalOnlyHotspot(proxy, packageName, featureId, config, extras, isCalledFromSystemApi)) != 0) {
                    proxy.onHotspotFailed(returnCode);
                    return;
                }
                this.mLOHSCallbackProxy = proxy;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public void cancelLocalOnlyHotspotRequest() {
        Object object = this.mLock;
        synchronized (object) {
            this.stopLocalOnlyHotspot();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopLocalOnlyHotspot() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mLOHSCallbackProxy == null) {
                return;
            }
            this.mLOHSCallbackProxy = null;
            try {
                this.mService.stopLocalOnlyHotspot();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresApi(value=33)
    @RequiresPermission(value="android.permission.NEARBY_WIFI_DEVICES")
    public void registerLocalOnlyHotspotSoftApCallback(@NonNull Executor executor, @NonNull SoftApCallback callback) {
        if (!SdkLevel.isAtLeastT()) {
            throw new UnsupportedOperationException();
        }
        if (executor == null) {
            throw new IllegalArgumentException("executor cannot be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        Log.v(TAG, "registerLocalOnlyHotspotSoftApCallback: callback=" + callback + ", executor=" + executor);
        try {
            SparseArray<ISoftApCallback> sparseArray = sLocalOnlyHotspotSoftApCallbackMap;
            synchronized (sparseArray) {
                SoftApCallbackProxy binderCallback = new SoftApCallbackProxy(executor, callback, 2);
                sLocalOnlyHotspotSoftApCallbackMap.put(System.identityHashCode(callback), binderCallback);
                Bundle extras = new Bundle();
                extras.putParcelable(EXTRA_PARAM_KEY_ATTRIBUTION_SOURCE, this.mContext.getAttributionSource());
                this.mService.registerLocalOnlyHotspotSoftApCallback(binderCallback, extras);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresApi(value=33)
    @RequiresPermission(value="android.permission.NEARBY_WIFI_DEVICES")
    public void unregisterLocalOnlyHotspotSoftApCallback(@NonNull SoftApCallback callback) {
        if (!SdkLevel.isAtLeastT()) {
            throw new UnsupportedOperationException();
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        Log.v(TAG, "unregisterLocalOnlyHotspotSoftApCallback: callback=" + callback);
        try {
            SparseArray<ISoftApCallback> sparseArray = sLocalOnlyHotspotSoftApCallbackMap;
            synchronized (sparseArray) {
                int callbackIdentifier = System.identityHashCode(callback);
                if (!sLocalOnlyHotspotSoftApCallbackMap.contains(callbackIdentifier)) {
                    Log.w(TAG, "Unknown external callback " + callbackIdentifier);
                    return;
                }
                Bundle extras = new Bundle();
                extras.putParcelable(EXTRA_PARAM_KEY_ATTRIBUTION_SOURCE, this.mContext.getAttributionSource());
                this.mService.unregisterLocalOnlyHotspotSoftApCallback(sLocalOnlyHotspotSoftApCallbackMap.get(callbackIdentifier), extras);
                sLocalOnlyHotspotSoftApCallbackMap.remove(callbackIdentifier);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watchLocalOnlyHotspot(LocalOnlyHotspotObserver observer, @Nullable Handler handler) {
        Executor executor = handler == null ? this.mContext.getMainExecutor() : new HandlerExecutor(handler);
        Object object = this.mLock;
        synchronized (object) {
            this.mLOHSObserverProxy = new LocalOnlyHotspotObserverProxy(this, executor, observer);
            try {
                this.mService.startWatchLocalOnlyHotspot(this.mLOHSObserverProxy);
                this.mLOHSObserverProxy.registered();
            }
            catch (RemoteException e) {
                this.mLOHSObserverProxy = null;
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterLocalOnlyHotspotObserver() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mLOHSObserverProxy == null) {
                return;
            }
            this.mLOHSObserverProxy = null;
            try {
                this.mService.stopWatchLocalOnlyHotspot();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public int getWifiApState() {
        try {
            return this.mService.getWifiApEnabledState();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public boolean isWifiApEnabled() {
        return this.getWifiApState() == 13;
    }

    @SystemApi
    @Deprecated
    @Nullable
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public WifiConfiguration getWifiApConfiguration() {
        try {
            return this.mService.getWifiApConfiguration();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @NonNull
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.OVERRIDE_WIFI_CONFIG"})
    public SoftApConfiguration getSoftApConfiguration() {
        try {
            return this.mService.getSoftApConfiguration();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @Nullable
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void queryLastConfiguredTetheredApPassphraseSinceBoot(final @NonNull Executor executor, final @NonNull Consumer<String> resultCallback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(resultCallback, "resultsCallback cannot be null");
        try {
            this.mService.queryLastConfiguredTetheredApPassphraseSinceBoot(new IStringListener.Stub(this){

                @Override
                public void onResult(String value) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> resultCallback.accept(value));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @Deprecated
    @RequiresPermission(value="android.permission.CHANGE_WIFI_STATE")
    public boolean setWifiApConfiguration(WifiConfiguration wifiConfig) {
        try {
            return this.mService.setWifiApConfiguration(wifiConfig, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.OVERRIDE_WIFI_CONFIG"})
    public boolean setSoftApConfiguration(@NonNull SoftApConfiguration softApConfig) {
        try {
            return this.mService.setSoftApConfiguration(softApConfig, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setTdlsEnabled(InetAddress remoteIPAddress, boolean enable) {
        try {
            this.mService.enableTdls(remoteIPAddress.getHostAddress(), enable);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setTdlsEnabled(@NonNull InetAddress remoteIPAddress, boolean enable, final @NonNull Executor executor, final @NonNull Consumer<Boolean> resultsCallback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(resultsCallback, "resultsCallback cannot be null");
        Objects.requireNonNull(remoteIPAddress, "remote IP address cannot be null");
        try {
            this.mService.enableTdlsWithRemoteIpAddress(remoteIPAddress.getHostAddress(), enable, new IBooleanListener.Stub(this){

                @Override
                public void onResult(boolean value) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> resultsCallback.accept(value));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setTdlsEnabledWithMacAddress(String remoteMacAddress, boolean enable) {
        try {
            this.mService.enableTdlsWithMacAddress(remoteMacAddress, enable);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setTdlsEnabledWithMacAddress(@NonNull String remoteMacAddress, boolean enable, final @NonNull Executor executor, final @NonNull Consumer<Boolean> resultsCallback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(resultsCallback, "resultsCallback cannot be null");
        Objects.requireNonNull(remoteMacAddress, "remote Mac address cannot be null");
        try {
            this.mService.enableTdlsWithRemoteMacAddress(remoteMacAddress, enable, new IBooleanListener.Stub(this){

                @Override
                public void onResult(boolean value) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> resultsCallback.accept(value));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void isTdlsOperationCurrentlyAvailable(final @NonNull Executor executor, final @NonNull Consumer<Boolean> resultsCallback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(resultsCallback, "resultsCallback cannot be null");
        try {
            this.mService.isTdlsOperationCurrentlyAvailable(new IBooleanListener.Stub(this){

                @Override
                public void onResult(boolean value) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> resultsCallback.accept(value));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresApi(value=34)
    public void getMaxSupportedConcurrentTdlsSessions(final @NonNull Executor executor, final @NonNull Consumer<Integer> resultsCallback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(resultsCallback, "resultsCallback cannot be null");
        try {
            this.mService.getMaxSupportedConcurrentTdlsSessions(new IIntegerListener.Stub(this){

                @Override
                public void onResult(int value) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> resultsCallback.accept(value));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void getNumberOfEnabledTdlsSessions(final @NonNull Executor executor, final @NonNull Consumer<Integer> resultsCallback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(resultsCallback, "resultsCallback cannot be null");
        try {
            this.mService.getNumberOfEnabledTdlsSessions(new IIntegerListener.Stub(this){

                @Override
                public void onResult(int value) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> resultsCallback.accept(value));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.MAINLINE_NETWORK_STACK", "android.permission.OVERRIDE_WIFI_CONFIG"})
    public void registerSoftApCallback(@NonNull Executor executor, @NonNull SoftApCallback callback) {
        if (executor == null) {
            throw new IllegalArgumentException("executor cannot be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        Log.v(TAG, "registerSoftApCallback: callback=" + callback + ", executor=" + executor);
        try {
            SparseArray<ISoftApCallback> sparseArray = sSoftApCallbackMap;
            synchronized (sparseArray) {
                SoftApCallbackProxy binderCallback = new SoftApCallbackProxy(executor, callback, 1);
                sSoftApCallbackMap.put(System.identityHashCode(callback), binderCallback);
                this.mService.registerSoftApCallback(binderCallback);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.MAINLINE_NETWORK_STACK", "android.permission.OVERRIDE_WIFI_CONFIG"})
    public void unregisterSoftApCallback(@NonNull SoftApCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        Log.v(TAG, "unregisterSoftApCallback: callback=" + callback);
        try {
            SparseArray<ISoftApCallback> sparseArray = sSoftApCallbackMap;
            synchronized (sparseArray) {
                int callbackIdentifier = System.identityHashCode(callback);
                if (!sSoftApCallbackMap.contains(callbackIdentifier)) {
                    Log.w(TAG, "Unknown external callback " + callbackIdentifier);
                    return;
                }
                this.mService.unregisterSoftApCallback(sSoftApCallbackMap.get(callbackIdentifier));
                sSoftApCallbackMap.remove(callbackIdentifier);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void connectInternal(@Nullable WifiConfiguration config, int networkId, @Nullable ActionListener listener) {
        block6: {
            ActionListenerProxy listenerProxy = null;
            if (listener != null) {
                listenerProxy = new ActionListenerProxy("connect", this.mContext.getMainLooper(), listener);
            }
            try {
                Bundle extras = new Bundle();
                if (SdkLevel.isAtLeastS()) {
                    extras.putParcelable(EXTRA_PARAM_KEY_ATTRIBUTION_SOURCE, this.mContext.getAttributionSource());
                }
                this.mService.connect(config, networkId, listenerProxy, this.mContext.getOpPackageName(), extras);
            }
            catch (RemoteException e) {
                if (listenerProxy != null) {
                    listenerProxy.onFailure(0);
                }
            }
            catch (SecurityException e) {
                if (listenerProxy == null) break block6;
                listenerProxy.onFailure(4);
            }
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD", "android.permission.NETWORK_STACK"})
    public void connect(@NonNull WifiConfiguration config, @Nullable ActionListener listener) {
        if (config == null) {
            throw new IllegalArgumentException("config cannot be null");
        }
        this.connectInternal(config, -1, listener);
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD", "android.permission.NETWORK_STACK"})
    public void connect(int networkId, @Nullable ActionListener listener) {
        if (networkId < 0) {
            throw new IllegalArgumentException("Network id cannot be negative");
        }
        this.connectInternal(null, networkId, listener);
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    @RequiresApi(value=31)
    public void startRestrictingAutoJoinToSubscriptionId(int subscriptionId) {
        try {
            this.mService.startRestrictingAutoJoinToSubscriptionId(subscriptionId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    @RequiresApi(value=31)
    public void stopRestrictingAutoJoinToSubscriptionId() {
        try {
            this.mService.stopRestrictingAutoJoinToSubscriptionId();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD", "android.permission.NETWORK_STACK"})
    public void save(@NonNull WifiConfiguration config, @Nullable ActionListener listener) {
        block6: {
            if (config == null) {
                throw new IllegalArgumentException("config cannot be null");
            }
            ActionListenerProxy listenerProxy = null;
            if (listener != null) {
                listenerProxy = new ActionListenerProxy("save", this.mContext.getMainLooper(), listener);
            }
            try {
                this.mService.save(config, listenerProxy, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                if (listenerProxy != null) {
                    listenerProxy.onFailure(0);
                }
            }
            catch (SecurityException e) {
                if (listenerProxy == null) break block6;
                listenerProxy.onFailure(4);
            }
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD", "android.permission.NETWORK_STACK"})
    public void forget(int netId, @Nullable ActionListener listener) {
        block6: {
            if (netId < 0) {
                throw new IllegalArgumentException("Network id cannot be negative");
            }
            ActionListenerProxy listenerProxy = null;
            if (listener != null) {
                listenerProxy = new ActionListenerProxy("forget", this.mContext.getMainLooper(), listener);
            }
            try {
                this.mService.forget(netId, listenerProxy);
            }
            catch (RemoteException e) {
                if (listenerProxy != null) {
                    listenerProxy.onFailure(0);
                }
            }
            catch (SecurityException e) {
                if (listenerProxy == null) break block6;
                listenerProxy.onFailure(4);
            }
        }
    }

    @SystemApi
    @Deprecated
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD", "android.permission.NETWORK_STACK"})
    public void disable(int netId, @Nullable ActionListener listener) {
        if (netId < 0) {
            throw new IllegalArgumentException("Network id cannot be negative");
        }
        boolean status = this.disableNetwork(netId);
        if (listener != null) {
            if (status) {
                listener.onSuccess();
            } else {
                listener.onFailure(0);
            }
        }
    }

    public void allowAutojoinGlobal(boolean allowAutojoin) {
        try {
            Bundle extras = new Bundle();
            if (SdkLevel.isAtLeastS()) {
                extras.putParcelable(EXTRA_PARAM_KEY_ATTRIBUTION_SOURCE, this.mContext.getAttributionSource());
            }
            this.mService.allowAutojoinGlobal(allowAutojoin, this.mContext.getOpPackageName(), extras);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void queryAutojoinGlobal(final @NonNull Executor executor, final @NonNull Consumer<Boolean> resultsCallback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(resultsCallback, "resultsCallback cannot be null");
        try {
            this.mService.queryAutojoinGlobal(new IBooleanListener.Stub(this){

                @Override
                public void onResult(boolean value) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> resultsCallback.accept(value));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void allowAutojoin(int netId, boolean allowAutojoin) {
        try {
            this.mService.allowAutojoin(netId, allowAutojoin);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void allowAutojoinPasspoint(@NonNull String fqdn, boolean allowAutojoin) {
        try {
            this.mService.allowAutojoinPasspoint(fqdn, allowAutojoin);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void setMacRandomizationSettingPasspointEnabled(@NonNull String fqdn, boolean enable) {
        try {
            this.mService.setMacRandomizationSettingPasspointEnabled(fqdn, enable);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void setPasspointMeteredOverride(@NonNull String fqdn, int meteredOverride) {
        try {
            this.mService.setPasspointMeteredOverride(fqdn, meteredOverride);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_STACK"})
    public void disableEphemeralNetwork(@NonNull String network) {
        if (TextUtils.isEmpty(network)) {
            throw new IllegalArgumentException("SSID cannot be null or empty!");
        }
        try {
            this.mService.disableEphemeralNetwork(network, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void startWps(WpsInfo config, WpsCallback listener) {
        if (listener != null) {
            listener.onFailed(0);
        }
    }

    public void cancelWps(WpsCallback listener) {
        if (listener != null) {
            listener.onFailed(0);
        }
    }

    public WifiLock createWifiLock(int lockType, String tag) {
        return new WifiLock(lockType, tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @RequiresApi(value=33)
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.MANAGE_WIFI_NETWORK_SELECTION"})
    public void addWifiLowLatencyLockListener(@NonNull Executor executor, @NonNull WifiLowLatencyLockListener listener) {
        if (executor == null) {
            throw new IllegalArgumentException("executor cannot be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        if (this.mVerboseLoggingEnabled) {
            Log.d(TAG, "addWifiLowLatencyLockListener: listener=" + listener + ", executor=" + executor);
        }
        int listenerIdentifier = System.identityHashCode(listener);
        try {
            SparseArray<IWifiLowLatencyLockListener> sparseArray = sWifiLowLatencyLockListenerMap;
            synchronized (sparseArray) {
                OnWifiLowLatencyLockProxy listenerProxy = new OnWifiLowLatencyLockProxy(executor, listener);
                sWifiLowLatencyLockListenerMap.put(listenerIdentifier, listenerProxy);
                this.mService.addWifiLowLatencyLockListener(listenerProxy);
            }
        }
        catch (RemoteException e) {
            sWifiLowLatencyLockListenerMap.remove(listenerIdentifier);
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @RequiresApi(value=33)
    public void removeWifiLowLatencyLockListener(@NonNull WifiLowLatencyLockListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        if (this.mVerboseLoggingEnabled) {
            Log.d(TAG, "removeWifiLowLatencyLockListener: listener=" + listener);
        }
        int listenerIdentifier = System.identityHashCode(listener);
        SparseArray<IWifiLowLatencyLockListener> sparseArray = sWifiLowLatencyLockListenerMap;
        synchronized (sparseArray) {
            try {
                if (!sWifiLowLatencyLockListenerMap.contains(listenerIdentifier)) {
                    Log.w(TAG, "Unknown external listener " + listenerIdentifier);
                    return;
                }
                this.mService.removeWifiLowLatencyLockListener(sWifiLowLatencyLockListenerMap.get(listenerIdentifier));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            finally {
                sWifiLowLatencyLockListenerMap.remove(listenerIdentifier);
            }
        }
    }

    @Deprecated
    public WifiLock createWifiLock(String tag) {
        return new WifiLock(1, tag);
    }

    public MulticastLock createMulticastLock(String tag) {
        return new MulticastLock(tag);
    }

    public boolean isMulticastEnabled() {
        try {
            return this.mService.isMulticastEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public boolean initializeMulticastFiltering() {
        try {
            this.mService.initializeMulticastFiltering();
            return true;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.DUMP"})
    public void setVerboseLoggingEnabled(boolean enable) {
        this.enableVerboseLogging(enable ? 1 : 0);
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.DUMP"})
    public void setVerboseLoggingLevel(int verbose) {
        this.enableVerboseLogging(verbose);
    }

    @UnsupportedAppUsage(maxTargetSdk=29, publicAlternatives="Use {@code #setVerboseLoggingEnabled(boolean)} instead.")
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.DUMP"})
    public void enableVerboseLogging(int verbose) {
        try {
            this.mService.enableVerboseLogging(verbose);
            this.mVerboseLoggingEnabled = verbose == 2 || verbose == 1;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public boolean isVerboseLoggingEnabled() {
        int verboseLoggingLevel = this.getVerboseLoggingLevel();
        return verboseLoggingLevel == 2 || verboseLoggingLevel == 1;
    }

    @SystemApi
    public int getVerboseLoggingLevel() {
        try {
            return this.mService.getVerboseLoggingLevel();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void factoryReset() {
        try {
            this.mService.factoryReset(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @Nullable
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public Network getCurrentNetwork() {
        try {
            return this.mService.getCurrentNetwork();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean setEnableAutoJoinWhenAssociated(boolean enabled) {
        return false;
    }

    public boolean getEnableAutoJoinWhenAssociated() {
        return false;
    }

    @SystemApi
    @RequiresApi(value=35)
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public void retrieveWifiBackupData(final @NonNull Executor executor, final @NonNull Consumer<byte[]> resultsCallback) {
        if (!SdkLevel.isAtLeastV()) {
            throw new UnsupportedOperationException();
        }
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(resultsCallback, "resultsCallback cannot be null");
        try {
            this.mService.retrieveWifiBackupData(new IByteArrayListener.Stub(this){

                @Override
                public void onResult(byte[] value) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> resultsCallback.accept(value));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=35)
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public void restoreWifiBackupData(@NonNull byte[] data) {
        if (!SdkLevel.isAtLeastV()) {
            throw new UnsupportedOperationException();
        }
        try {
            this.mService.restoreWifiBackupData(data);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @NonNull
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public byte[] retrieveBackupData() {
        try {
            return this.mService.retrieveBackupData();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void restoreBackupData(@NonNull byte[] data) {
        try {
            this.mService.restoreBackupData(data);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @NonNull
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public byte[] retrieveSoftApBackupData() {
        try {
            return this.mService.retrieveSoftApBackupData();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @Nullable
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public SoftApConfiguration restoreSoftApBackupData(@NonNull byte[] data) {
        try {
            return this.mService.restoreSoftApBackupData(data);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void restoreSupplicantBackupData(@NonNull byte[] supplicantData, @NonNull byte[] ipConfigData) {
        try {
            this.mService.restoreSupplicantBackupData(supplicantData, ipConfigData);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public void startSubscriptionProvisioning(@NonNull OsuProvider provider, @NonNull Executor executor, @NonNull ProvisioningCallback callback) {
        if (executor == null) {
            throw new IllegalArgumentException("executor must not be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        try {
            this.mService.startSubscriptionProvisioning(provider, new ProvisioningCallbackProxy(executor, callback));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void registerTrafficStateCallback(@NonNull Executor executor, @NonNull TrafficStateCallback callback) {
        if (executor == null) {
            throw new IllegalArgumentException("executor cannot be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        Log.v(TAG, "registerTrafficStateCallback: callback=" + callback + ", executor=" + executor);
        try {
            SparseArray<ITrafficStateCallback> sparseArray = sTrafficStateCallbackMap;
            synchronized (sparseArray) {
                TrafficStateCallbackProxy binderCallback = new TrafficStateCallbackProxy(executor, callback);
                sTrafficStateCallbackMap.put(System.identityHashCode(callback), binderCallback);
                this.mService.registerTrafficStateCallback(binderCallback);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void unregisterTrafficStateCallback(@NonNull TrafficStateCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        Log.v(TAG, "unregisterTrafficStateCallback: callback=" + callback);
        try {
            SparseArray<ITrafficStateCallback> sparseArray = sTrafficStateCallbackMap;
            synchronized (sparseArray) {
                int callbackIdentifier = System.identityHashCode(callback);
                if (!sTrafficStateCallbackMap.contains(callbackIdentifier)) {
                    Log.w(TAG, "Unknown external callback " + callbackIdentifier);
                    return;
                }
                this.mService.unregisterTrafficStateCallback(sTrafficStateCallbackMap.get(callbackIdentifier));
                sTrafficStateCallbackMap.remove(callbackIdentifier);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void updateVerboseLoggingEnabledFromService() {
        this.mVerboseLoggingEnabled = this.isVerboseLoggingEnabled();
    }

    public boolean isWpa3SaeSupported() {
        return this.isFeatureSupported(27);
    }

    public boolean isWpa3SuiteBSupported() {
        return this.isFeatureSupported(28);
    }

    public boolean isEnhancedOpenSupported() {
        return this.isFeatureSupported(29);
    }

    public boolean isEasyConnectSupported() {
        return this.isFeatureSupported(31);
    }

    public boolean isEasyConnectEnrolleeResponderModeSupported() {
        return this.isFeatureSupported(47);
    }

    public boolean isWapiSupported() {
        return this.isFeatureSupported(37);
    }

    public boolean isWpa3SaePublicKeySupported() {
        return false;
    }

    public boolean isPasspointTermsAndConditionsSupported() {
        return this.isFeatureSupported(48);
    }

    public boolean isWpa3SaeH2eSupported() {
        return this.isFeatureSupported(49);
    }

    public boolean isWifiDisplayR2Supported() {
        return this.isFeatureSupported(50);
    }

    public boolean isDecoratedIdentitySupported() {
        return this.isFeatureSupported(51);
    }

    public boolean isTrustOnFirstUseSupported() {
        return this.isFeatureSupported(52);
    }

    public boolean isEasyConnectDppAkmSupported() {
        return this.isFeatureSupported(54);
    }

    public boolean isTlsMinimumVersionSupported() {
        return this.isFeatureSupported(55);
    }

    public boolean isTlsV13Supported() {
        return this.isFeatureSupported(56);
    }

    public boolean isDualBandSimultaneousSupported() {
        return this.isFeatureSupported(57);
    }

    public boolean isTidToLinkMappingNegotiationSupported() {
        return this.isFeatureSupported(58);
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public boolean isWepSupported() {
        return this.isFeatureSupported(59);
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public boolean isWpaPersonalSupported() {
        return this.isFeatureSupported(60);
    }

    @SystemApi
    @NonNull
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public String[] getFactoryMacAddresses() {
        try {
            return this.mService.getFactoryMacAddresses();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WIFI_SET_DEVICE_MOBILITY_STATE")
    public void setDeviceMobilityState(int state) {
        try {
            this.mService.setDeviceMobilityState(state);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public void startEasyConnectAsConfiguratorInitiator(@NonNull String enrolleeUri, int selectedNetworkId, int enrolleeNetworkRole, @NonNull Executor executor, @NonNull EasyConnectStatusCallback callback) {
        Binder binder = new Binder();
        try {
            this.mService.startDppAsConfiguratorInitiator(binder, this.mContext.getOpPackageName(), enrolleeUri, selectedNetworkId, enrolleeNetworkRole, new EasyConnectCallbackProxy(executor, callback));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public void startEasyConnectAsEnrolleeInitiator(@NonNull String configuratorUri, @NonNull Executor executor, @NonNull EasyConnectStatusCallback callback) {
        Binder binder = new Binder();
        try {
            this.mService.startDppAsEnrolleeInitiator(binder, configuratorUri, new EasyConnectCallbackProxy(executor, callback));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    @RequiresApi(value=31)
    public void startEasyConnectAsEnrolleeResponder(@Nullable String deviceInfo, int curve, @NonNull Executor executor, @NonNull EasyConnectStatusCallback callback) {
        Binder binder = new Binder();
        try {
            this.mService.startDppAsEnrolleeResponder(binder, deviceInfo, curve, new EasyConnectCallbackProxy(executor, callback));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public static int getEasyConnectMaxAllowedResponderDeviceInfoLength() {
        return 40;
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public void stopEasyConnectSession() {
        try {
            this.mService.stopDppSession();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.WIFI_UPDATE_USABILITY_STATS_SCORE")
    public void addOnWifiUsabilityStatsListener(final @NonNull Executor executor, final @NonNull OnWifiUsabilityStatsListener listener) {
        if (executor == null) {
            throw new IllegalArgumentException("executor cannot be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        if (this.mVerboseLoggingEnabled) {
            Log.v(TAG, "addOnWifiUsabilityStatsListener: listener=" + listener);
        }
        try {
            SparseArray<IOnWifiUsabilityStatsListener> sparseArray = sOnWifiUsabilityStatsListenerMap;
            synchronized (sparseArray) {
                IOnWifiUsabilityStatsListener.Stub binderCallback = new IOnWifiUsabilityStatsListener.Stub(){

                    @Override
                    public void onWifiUsabilityStats(int seqNum, boolean isSameBssidAndFreq, WifiUsabilityStatsEntry stats) {
                        if (WifiManager.this.mVerboseLoggingEnabled) {
                            Log.v(WifiManager.TAG, "OnWifiUsabilityStatsListener: onWifiUsabilityStats: seqNum=" + seqNum);
                        }
                        Binder.clearCallingIdentity();
                        executor.execute(() -> listener.onWifiUsabilityStats(seqNum, isSameBssidAndFreq, stats));
                    }
                };
                sOnWifiUsabilityStatsListenerMap.put(System.identityHashCode(listener), binderCallback);
                this.mService.addOnWifiUsabilityStatsListener(binderCallback);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.WIFI_UPDATE_USABILITY_STATS_SCORE")
    public void removeOnWifiUsabilityStatsListener(@NonNull OnWifiUsabilityStatsListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        if (this.mVerboseLoggingEnabled) {
            Log.v(TAG, "removeOnWifiUsabilityStatsListener: listener=" + listener);
        }
        try {
            SparseArray<IOnWifiUsabilityStatsListener> sparseArray = sOnWifiUsabilityStatsListenerMap;
            synchronized (sparseArray) {
                int listenerIdentifier = System.identityHashCode(listener);
                if (!sOnWifiUsabilityStatsListenerMap.contains(listenerIdentifier)) {
                    Log.w(TAG, "Unknown external callback " + listenerIdentifier);
                    return;
                }
                this.mService.removeOnWifiUsabilityStatsListener(sOnWifiUsabilityStatsListenerMap.get(listenerIdentifier));
                sOnWifiUsabilityStatsListenerMap.remove(listenerIdentifier);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WIFI_UPDATE_USABILITY_STATS_SCORE")
    public void updateWifiUsabilityScore(int seqNum, int score, int predictionHorizonSec) {
        try {
            this.mService.updateWifiUsabilityScore(seqNum, score, predictionHorizonSec);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.wifi.flags.get_bssid_blocklist_api")
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public void getBssidBlocklist(@NonNull List<WifiSsid> ssids, final @NonNull Executor executor, final @NonNull Consumer<List<MacAddress>> resultListener) {
        Objects.requireNonNull(ssids, "ssids cannot be null");
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(resultListener, "resultsCallback cannot be null");
        try {
            this.mService.getBssidBlocklist(new ParceledListSlice<WifiSsid>(ssids), new IMacAddressListListener.Stub(this){

                @Override
                public void onResult(ParceledListSlice<MacAddress> value) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> resultListener.accept(value.getList()));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public void registerScanResultsCallback(@NonNull Executor executor, @NonNull ScanResultsCallback callback) {
        if (executor == null) {
            throw new IllegalArgumentException("executor cannot be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        Log.v(TAG, "registerScanResultsCallback: callback=" + callback + ", executor=" + executor);
        ScanResultsCallback.ScanResultsCallbackProxy proxy = callback.getProxy();
        proxy.initProxy(executor, callback);
        try {
            this.mService.registerScanResultsCallback(proxy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public void unregisterScanResultsCallback(@NonNull ScanResultsCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        Log.v(TAG, "unregisterScanResultsCallback: Callback=" + callback);
        ScanResultsCallback.ScanResultsCallbackProxy proxy = callback.getProxy();
        try {
            this.mService.unregisterScanResultsCallback(proxy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        finally {
            proxy.cleanUpProxy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public void addWifiVerboseLoggingStatusChangedListener(final @NonNull Executor executor, final @NonNull WifiVerboseLoggingStatusChangedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Executor cannot be null");
        }
        if (this.mVerboseLoggingEnabled) {
            Log.v(TAG, "addWifiVerboseLoggingStatusChangedListener listener=" + listener + ", executor=" + executor);
        }
        try {
            SparseArray<IWifiVerboseLoggingStatusChangedListener> sparseArray = sWifiVerboseLoggingStatusChangedListenerMap;
            synchronized (sparseArray) {
                IWifiVerboseLoggingStatusChangedListener.Stub binderCallback = new IWifiVerboseLoggingStatusChangedListener.Stub(){

                    @Override
                    public void onStatusChanged(boolean enabled) {
                        if (WifiManager.this.mVerboseLoggingEnabled) {
                            Log.v(WifiManager.TAG, "WifiVerboseLoggingStatusListener: onVerboseLoggingStatusChanged: enabled=" + enabled);
                        }
                        Binder.clearCallingIdentity();
                        executor.execute(() -> listener.onWifiVerboseLoggingStatusChanged(enabled));
                    }
                };
                sWifiVerboseLoggingStatusChangedListenerMap.put(System.identityHashCode(listener), binderCallback);
                this.mService.addWifiVerboseLoggingStatusChangedListener(binderCallback);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public void removeWifiVerboseLoggingStatusChangedListener(@NonNull WifiVerboseLoggingStatusChangedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        Log.v(TAG, "removeWifiVerboseLoggingStatusChangedListener: listener=" + listener);
        try {
            SparseArray<IWifiVerboseLoggingStatusChangedListener> sparseArray = sWifiVerboseLoggingStatusChangedListenerMap;
            synchronized (sparseArray) {
                int listenerIdentifier = System.identityHashCode(listener);
                if (!sWifiVerboseLoggingStatusChangedListenerMap.contains(listenerIdentifier)) {
                    Log.w(TAG, "Unknown external callback " + listenerIdentifier);
                    return;
                }
                this.mService.removeWifiVerboseLoggingStatusChangedListener(sWifiVerboseLoggingStatusChangedListenerMap.get(listenerIdentifier));
                sWifiVerboseLoggingStatusChangedListenerMap.remove(listenerIdentifier);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_WIFI_STATE"})
    public void addSuggestionConnectionStatusListener(@NonNull Executor executor, @NonNull SuggestionConnectionStatusListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Executor cannot be null");
        }
        Log.v(TAG, "addSuggestionConnectionStatusListener listener=" + listener + ", executor=" + executor);
        try {
            SparseArray<ISuggestionConnectionStatusListener> sparseArray = sSuggestionConnectionStatusListenerMap;
            synchronized (sparseArray) {
                SuggestionConnectionStatusListenerProxy binderCallback = new SuggestionConnectionStatusListenerProxy(this, executor, listener);
                sSuggestionConnectionStatusListenerMap.put(System.identityHashCode(listener), binderCallback);
                this.mService.registerSuggestionConnectionStatusListener(binderCallback, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public void removeSuggestionConnectionStatusListener(@NonNull SuggestionConnectionStatusListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        Log.v(TAG, "removeSuggestionConnectionStatusListener: listener=" + listener);
        try {
            SparseArray<ISuggestionConnectionStatusListener> sparseArray = sSuggestionConnectionStatusListenerMap;
            synchronized (sparseArray) {
                int listenerIdentifier = System.identityHashCode(listener);
                if (!sSuggestionConnectionStatusListenerMap.contains(listenerIdentifier)) {
                    Log.w(TAG, "Unknown external callback " + listenerIdentifier);
                    return;
                }
                this.mService.unregisterSuggestionConnectionStatusListener(sSuggestionConnectionStatusListenerMap.get(listenerIdentifier), this.mContext.getOpPackageName());
                sSuggestionConnectionStatusListenerMap.remove(listenerIdentifier);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public void addLocalOnlyConnectionFailureListener(@NonNull Executor executor, @NonNull LocalOnlyConnectionFailureListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Executor cannot be null");
        }
        try {
            SparseArray<ILocalOnlyConnectionStatusListener> sparseArray = sLocalOnlyConnectionStatusListenerMap;
            synchronized (sparseArray) {
                if (sLocalOnlyConnectionStatusListenerMap.contains(System.identityHashCode(listener))) {
                    Log.w(TAG, "Same listener already registered");
                    return;
                }
                LocalOnlyConnectionStatusListenerProxy binderCallback = new LocalOnlyConnectionStatusListenerProxy(executor, listener);
                sLocalOnlyConnectionStatusListenerMap.put(System.identityHashCode(listener), binderCallback);
                this.mService.addLocalOnlyConnectionStatusListener(binderCallback, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public void removeLocalOnlyConnectionFailureListener(@NonNull LocalOnlyConnectionFailureListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        try {
            SparseArray<ILocalOnlyConnectionStatusListener> sparseArray = sLocalOnlyConnectionStatusListenerMap;
            synchronized (sparseArray) {
                int listenerIdentifier = System.identityHashCode(listener);
                if (!sLocalOnlyConnectionStatusListenerMap.contains(listenerIdentifier)) {
                    Log.w(TAG, "Unknown external callback " + listenerIdentifier);
                    return;
                }
                this.mService.removeLocalOnlyConnectionStatusListener(sLocalOnlyConnectionStatusListenerMap.get(listenerIdentifier), this.mContext.getOpPackageName());
                sLocalOnlyConnectionStatusListenerMap.remove(listenerIdentifier);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @VisibleForTesting
    public static SparseArray<int[]> parseDppChannelList(String channelList) {
        SparseArray<int[]> channelListArray = new SparseArray<int[]>();
        if (TextUtils.isEmpty(channelList)) {
            return channelListArray;
        }
        StringTokenizer str = new StringTokenizer(channelList, ",");
        String classStr = null;
        ArrayList<Integer> channelsInClass = new ArrayList<Integer>();
        try {
            while (str.hasMoreElements()) {
                String cur = str.nextToken();
                int classDelim = cur.indexOf(47);
                if (classDelim != -1) {
                    if (classStr != null) {
                        int[] channelsArray = new int[channelsInClass.size()];
                        for (int i = 0; i < channelsInClass.size(); ++i) {
                            channelsArray[i] = (Integer)channelsInClass.get(i);
                        }
                        channelListArray.append(Integer.parseInt(classStr), channelsArray);
                        channelsInClass = new ArrayList();
                    }
                    classStr = cur.substring(0, classDelim);
                    String channelStr = cur.substring(classDelim + 1);
                    channelsInClass.add(Integer.parseInt(channelStr));
                    continue;
                }
                if (classStr == null) {
                    Log.e(TAG, "Cannot parse DPP channel list");
                    return new SparseArray<int[]>();
                }
                channelsInClass.add(Integer.parseInt(cur));
            }
            if (classStr != null) {
                int[] channelsArray = new int[channelsInClass.size()];
                for (int i = 0; i < channelsInClass.size(); ++i) {
                    channelsArray[i] = (Integer)channelsInClass.get(i);
                }
                channelListArray.append(Integer.parseInt(classStr), channelsArray);
            }
            return channelListArray;
        }
        catch (NumberFormatException e) {
            Log.e(TAG, "Cannot parse DPP channel list");
            return new SparseArray<int[]>();
        }
    }

    @RequiresPermission(value="android.permission.WIFI_UPDATE_USABILITY_STATS_SCORE")
    public void storeCapturedData(final @NonNull Executor executor, final @NonNull IntConsumer resultsCallback, int triggerType, boolean isFullCapture, long triggerStartTimeMillis, long triggerStopTimeMillis) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(resultsCallback, "resultsCallback cannot be null");
        try {
            this.mService.storeCapturedData(triggerType, isFullCapture, triggerStartTimeMillis, triggerStopTimeMillis, new IIntegerListener.Stub(this){

                @Override
                public void onResult(int value) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> resultsCallback.accept(value));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.REQUEST_COMPANION_PROFILE_AUTOMOTIVE_PROJECTION"})
    @RequiresApi(value=33)
    public void setExternalPnoScanRequest(@NonNull List<WifiSsid> ssids, @Nullable int[] frequencies, @NonNull Executor executor, @NonNull PnoScanResultsCallback callback) {
        if (executor == null) {
            throw new IllegalArgumentException("executor cannot be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        try {
            this.mService.setExternalPnoScanRequest(new Binder(), new PnoScanResultsCallbackProxy(executor, callback), ssids, frequencies == null ? new int[]{} : frequencies, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @RequiresPermission(anyOf={"android.permission.MANAGE_WIFI_NETWORK_SELECTION", "android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public void setPnoScanState(int pnoScanState) {
        try {
            boolean enabled = false;
            boolean enablePnoScanAfterWifiToggle = false;
            switch (pnoScanState) {
                case 0: {
                    break;
                }
                case 1: {
                    enablePnoScanAfterWifiToggle = true;
                    break;
                }
                case 2: {
                    enabled = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid PnoScanState");
                }
            }
            this.mService.setPnoScanEnabled(enabled, enablePnoScanAfterWifiToggle, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_WIFI_NETWORK_SELECTION", "android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public void setPnoScanEnabled(boolean enabled, boolean enablePnoScanAfterWifiToggle) {
        try {
            this.mService.setPnoScanEnabled(enabled, enablePnoScanAfterWifiToggle, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=33)
    public void clearExternalPnoScanRequest() {
        try {
            this.mService.clearExternalPnoScanRequest();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_STACK", "android.permission.MAINLINE_NETWORK_STACK"})
    public void getLastCallerInfoForApi(int apiType, final @NonNull Executor executor, final @NonNull BiConsumer<String, Boolean> resultsCallback) {
        if (executor == null) {
            throw new IllegalArgumentException("executor can't be null");
        }
        if (resultsCallback == null) {
            throw new IllegalArgumentException("resultsCallback can't be null");
        }
        try {
            this.mService.getLastCallerInfoForApi(apiType, new ILastCallerListener.Stub(this){

                @Override
                public void onResult(String packageName, boolean enabled) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> resultsCallback.accept(packageName, enabled));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WIFI_UPDATE_USABILITY_STATS_SCORE")
    public boolean setWifiConnectedNetworkScorer(@NonNull Executor executor, @NonNull WifiConnectedNetworkScorer scorer) {
        if (executor == null) {
            throw new IllegalArgumentException("executor cannot be null");
        }
        if (scorer == null) {
            throw new IllegalArgumentException("scorer cannot be null");
        }
        if (this.mVerboseLoggingEnabled) {
            Log.v(TAG, "setWifiConnectedNetworkScorer: scorer=" + scorer);
        }
        try {
            return this.mService.setWifiConnectedNetworkScorer(new Binder(), new WifiConnectedNetworkScorerProxy(executor, scorer));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WIFI_UPDATE_USABILITY_STATS_SCORE")
    public void clearWifiConnectedNetworkScorer() {
        if (this.mVerboseLoggingEnabled) {
            Log.v(TAG, "clearWifiConnectedNetworkScorer");
        }
        try {
            this.mService.clearWifiConnectedNetworkScorer();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void setScanThrottleEnabled(boolean enable) {
        try {
            this.mService.setScanThrottleEnabled(enable);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public boolean isScanThrottleEnabled() {
        try {
            return this.mService.isScanThrottleEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void setAutoWakeupEnabled(boolean enable) {
        try {
            this.mService.setAutoWakeupEnabled(enable);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public boolean isAutoWakeupEnabled() {
        try {
            return this.mService.isAutoWakeupEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public void setCarrierNetworkOffloadEnabled(int subscriptionId, boolean merged, boolean enabled) {
        try {
            this.mService.setCarrierNetworkOffloadEnabled(subscriptionId, merged, enabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public boolean isCarrierNetworkOffloadEnabled(int subscriptionId, boolean merged) {
        try {
            return this.mService.isCarrierNetworkOffloadEnabled(subscriptionId, merged);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public void addSuggestionUserApprovalStatusListener(@NonNull Executor executor, @NonNull SuggestionUserApprovalStatusListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null");
        }
        if (executor == null) {
            throw new NullPointerException("Executor cannot be null");
        }
        Log.v(TAG, "addSuggestionUserApprovalStatusListener listener=" + listener + ", executor=" + executor);
        try {
            SparseArray<ISuggestionUserApprovalStatusListener> sparseArray = sSuggestionUserApprovalStatusListenerMap;
            synchronized (sparseArray) {
                SuggestionUserApprovalStatusListenerProxy binderCallback = new SuggestionUserApprovalStatusListenerProxy(this, executor, listener);
                sSuggestionUserApprovalStatusListenerMap.put(System.identityHashCode(listener), binderCallback);
                this.mService.addSuggestionUserApprovalStatusListener(binderCallback, this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public void removeSuggestionUserApprovalStatusListener(@NonNull SuggestionUserApprovalStatusListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        Log.v(TAG, "removeSuggestionUserApprovalStatusListener: listener=" + listener);
        try {
            SparseArray<ISuggestionUserApprovalStatusListener> sparseArray = sSuggestionUserApprovalStatusListenerMap;
            synchronized (sparseArray) {
                int listenerIdentifier = System.identityHashCode(listener);
                if (!sSuggestionUserApprovalStatusListenerMap.contains(listenerIdentifier)) {
                    Log.w(TAG, "Unknown external callback " + listenerIdentifier);
                    return;
                }
                this.mService.removeSuggestionUserApprovalStatusListener(sSuggestionUserApprovalStatusListenerMap.get(listenerIdentifier), this.mContext.getOpPackageName());
                sSuggestionUserApprovalStatusListenerMap.remove(listenerIdentifier);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.NETWORK_STACK")
    public void setEmergencyScanRequestInProgress(boolean inProgress) {
        try {
            this.mService.setEmergencyScanRequestInProgress(inProgress);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public boolean setWifiScoringEnabled(boolean enabled) {
        if (this.mVerboseLoggingEnabled) {
            Log.v(TAG, "setWifiScoringEnabled: " + enabled);
        }
        try {
            return this.mService.setWifiScoringEnabled(enabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_MANAGED_PROVISIONING", "android.permission.NETWORK_CARRIER_PROVISIONING"}, conditional=true)
    public void flushPasspointAnqpCache() {
        try {
            this.mService.flushPasspointAnqpCache(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresApi(value=31)
    @NonNull
    @RequiresPermission(value="android.permission.NEARBY_WIFI_DEVICES")
    public List<WifiAvailableChannel> getAllowedChannels(int band, int mode) {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        try {
            Bundle extras = new Bundle();
            if (SdkLevel.isAtLeastS()) {
                extras.putParcelable(EXTRA_PARAM_KEY_ATTRIBUTION_SOURCE, this.mContext.getAttributionSource());
            }
            return this.mService.getUsableChannels(band, mode, 0, this.mContext.getOpPackageName(), extras);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresApi(value=31)
    @NonNull
    @RequiresPermission(value="android.permission.NEARBY_WIFI_DEVICES")
    public List<WifiAvailableChannel> getUsableChannels(int band, int mode) {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        try {
            Bundle extras = new Bundle();
            if (SdkLevel.isAtLeastS()) {
                extras.putParcelable(EXTRA_PARAM_KEY_ATTRIBUTION_SOURCE, this.mContext.getAttributionSource());
            }
            return this.mService.getUsableChannels(band, mode, WifiAvailableChannel.getUsableFilter(), this.mContext.getOpPackageName(), extras);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public boolean isWifiPasspointEnabled() {
        try {
            return this.mService.isWifiPasspointEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public void setWifiPasspointEnabled(boolean enabled) {
        if (this.mVerboseLoggingEnabled) {
            Log.v(TAG, "setWifiPasspointEnabled: " + enabled);
        }
        try {
            this.mService.setWifiPasspointEnabled(enabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresApi(value=33)
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public int getStaConcurrencyForMultiInternetMode() {
        try {
            return this.mService.getStaConcurrencyForMultiInternetMode();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=33)
    @RequiresPermission(value="android.permission.MANAGE_DEVICE_ADMINS")
    public void notifyMinimumRequiredWifiSecurityLevelChanged(int level) {
        if (this.mVerboseLoggingEnabled) {
            Log.v(TAG, "notifyMinimumRequiredWifiSecurityLevelChanged");
        }
        try {
            this.mService.notifyMinimumRequiredWifiSecurityLevelChanged(level);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=33)
    @RequiresPermission(value="android.permission.MANAGE_DEVICE_ADMINS")
    public void notifyWifiSsidPolicyChanged(@NonNull WifiSsidPolicy policy) {
        if (this.mVerboseLoggingEnabled) {
            Log.v(TAG, "notifyWifiSsidPolicyChanged");
        }
        try {
            if (policy != null) {
                this.mService.notifyWifiSsidPolicyChanged(policy.getPolicyType(), new ParceledListSlice<WifiSsid>(new ArrayList<WifiSsid>(policy.getSsids())));
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=33)
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public boolean setStaConcurrencyForMultiInternetMode(int mode) {
        if (this.mVerboseLoggingEnabled) {
            Log.v(TAG, "setStaConcurrencyForMultiInternetMode: " + mode);
        }
        try {
            return this.mService.setStaConcurrencyForMultiInternetMode(mode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    @NonNull
    public Set<String> getOemPrivilegedWifiAdminPackages() {
        try {
            return new ArraySet<String>(this.mService.getOemPrivilegedWifiAdminPackages());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void replyToSimpleDialog(int dialogId, int reply) {
        if (this.mVerboseLoggingEnabled) {
            Log.v(TAG, "replyToWifiEnableRequestDialog: dialogId=" + dialogId + " reply=" + reply);
        }
        try {
            this.mService.replyToSimpleDialog(dialogId, reply);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void replyToP2pInvitationReceivedDialog(int dialogId, boolean accepted, @Nullable String optionalPin) {
        if (this.mVerboseLoggingEnabled) {
            Log.v(TAG, "replyToP2pInvitationReceivedDialog: dialogId=" + dialogId + ", accepted=" + accepted + ", pin=" + optionalPin);
        }
        try {
            this.mService.replyToP2pInvitationReceivedDialog(dialogId, accepted, optionalPin);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresApi(value=33)
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.OVERRIDE_WIFI_CONFIG"})
    public void addCustomDhcpOptions(@NonNull WifiSsid ssid, @NonNull byte[] oui, @NonNull List<DhcpOption> options) {
        try {
            this.mService.addCustomDhcpOptions(ssid, oui, new ParceledListSlice<DhcpOption>(options));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresApi(value=33)
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.OVERRIDE_WIFI_CONFIG"})
    public void removeCustomDhcpOptions(@NonNull WifiSsid ssid, @NonNull byte[] oui) {
        try {
            this.mService.removeCustomDhcpOptions(ssid, oui);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresApi(value=33)
    @RequiresPermission(allOf={"android.permission.MANAGE_WIFI_INTERFACES", "android.permission.ACCESS_WIFI_STATE"})
    public void reportCreateInterfaceImpact(int interfaceType, boolean requireNewInterface, final @NonNull Executor executor, final @NonNull BiConsumer<Boolean, Set<InterfaceCreationImpact>> resultCallback) {
        Objects.requireNonNull(executor, "Non-null executor required");
        Objects.requireNonNull(resultCallback, "Non-null resultCallback required");
        try {
            this.mService.reportCreateInterfaceImpact(this.mContext.getOpPackageName(), interfaceType, requireNewInterface, new IInterfaceCreationInfoCallback.Stub(this){

                @Override
                public void onResults(boolean canCreate, int[] interfacesToDelete, String[] packagesForInterfaces) {
                    ArraySet<InterfaceCreationImpact> finalSet;
                    Binder.clearCallingIdentity();
                    if (interfacesToDelete == null && packagesForInterfaces != null || interfacesToDelete != null && packagesForInterfaces == null || canCreate && (interfacesToDelete == null || interfacesToDelete.length != packagesForInterfaces.length)) {
                        Log.e(WifiManager.TAG, "reportImpactToCreateIfaceRequest: Invalid callback parameters - canCreate=" + canCreate + ", interfacesToDelete=" + Arrays.toString(interfacesToDelete) + ", worksourcesForInterfaces=" + Arrays.toString(packagesForInterfaces));
                        return;
                    }
                    ArraySet<InterfaceCreationImpact> arraySet = finalSet = canCreate && interfacesToDelete.length > 0 ? new ArraySet<InterfaceCreationImpact>() : Collections.emptySet();
                    if (canCreate) {
                        for (int i = 0; i < interfacesToDelete.length; ++i) {
                            finalSet.add(new InterfaceCreationImpact(interfacesToDelete[i], (Set<String>)(packagesForInterfaces[i] == null ? Collections.emptySet() : new ArraySet<String>(packagesForInterfaces[i].split(",")))));
                        }
                    }
                    executor.execute(() -> resultCallback.accept(canCreate, finalSet));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getMaxNumberOfChannelsPerNetworkSpecifierRequest() {
        try {
            return this.mService.getMaxNumberOfChannelsPerRequest();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=34)
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.MANAGE_WIFI_NETWORK_SELECTION"})
    public void addQosPolicies(@NonNull List<QosPolicyParams> policyParamsList, final @NonNull Executor executor, final @NonNull Consumer<List<Integer>> resultsCallback) {
        Objects.requireNonNull(policyParamsList, "policyParamsList cannot be null");
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(resultsCallback, "resultsCallback cannot be null");
        try {
            this.mService.addQosPolicies(new ParceledListSlice<QosPolicyParams>(policyParamsList), new Binder(), this.mContext.getOpPackageName(), new IListListener.Stub(this){

                @Override
                public void onResult(List value) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> resultsCallback.accept(value));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=34)
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.MANAGE_WIFI_NETWORK_SELECTION"})
    public void removeQosPolicies(@NonNull int[] policyIdList) {
        Objects.requireNonNull(policyIdList, "policyIdList cannot be null");
        try {
            this.mService.removeQosPolicies(policyIdList, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=34)
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.MANAGE_WIFI_NETWORK_SELECTION"})
    public void removeAllQosPolicies() {
        try {
            this.mService.removeAllQosPolicies(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=33)
    @RequiresPermission(value="android.permission.MANAGE_WIFI_NETWORK_SELECTION")
    public void setLinkLayerStatsPollingInterval(int intervalMs) {
        try {
            this.mService.setLinkLayerStatsPollingInterval(intervalMs);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=33)
    @RequiresPermission(value="android.permission.MANAGE_WIFI_NETWORK_SELECTION")
    public void getLinkLayerStatsPollingInterval(final @NonNull Executor executor, final @NonNull Consumer<Integer> resultsCallback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(resultsCallback, "resultsCallback cannot be null");
        try {
            this.mService.getLinkLayerStatsPollingInterval(new IIntegerListener.Stub(this){

                @Override
                public void onResult(int value) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> resultsCallback.accept(value));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=34)
    @RequiresPermission(value="android.permission.MANAGE_WIFI_NETWORK_SELECTION")
    public void setMloMode(int mode, final @NonNull Executor executor, final @NonNull Consumer<Boolean> resultsCallback) {
        if (mode < 0 || mode > 3) {
            throw new IllegalArgumentException("invalid mode: " + mode);
        }
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(resultsCallback, "resultsCallback cannot be null");
        try {
            this.mService.setMloMode(mode, new IBooleanListener.Stub(this){

                @Override
                public void onResult(boolean value) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> resultsCallback.accept(value));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=34)
    @RequiresPermission(value="android.permission.MANAGE_WIFI_NETWORK_SELECTION")
    public void getMloMode(final @NonNull Executor executor, final @NonNull Consumer<Integer> resultsCallback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(resultsCallback, "resultsCallback cannot be null");
        try {
            this.mService.getMloMode(new IIntegerListener.Stub(this){

                @Override
                public void onResult(int value) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> resultsCallback.accept(value));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @RequiresApi(value=34)
    @RequiresPermission(value="android.permission.MANAGE_WIFI_NETWORK_SELECTION")
    public void getMaxMloAssociationLinkCount(final @NonNull Executor executor, final @NonNull Consumer<Integer> resultsCallback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(resultsCallback, "resultsCallback cannot be null");
        try {
            Bundle extras = new Bundle();
            if (SdkLevel.isAtLeastS()) {
                extras.putParcelable(EXTRA_PARAM_KEY_ATTRIBUTION_SOURCE, this.mContext.getAttributionSource());
            }
            this.mService.getMaxMloAssociationLinkCount(new IIntegerListener.Stub(this){

                @Override
                public void onResult(int value) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> resultsCallback.accept(value));
                }
            }, extras);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @RequiresApi(value=34)
    @RequiresPermission(value="android.permission.MANAGE_WIFI_NETWORK_SELECTION")
    public void getMaxMloStrLinkCount(final @NonNull Executor executor, final @NonNull Consumer<Integer> resultsCallback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(resultsCallback, "resultsCallback cannot be null");
        try {
            Bundle extras = new Bundle();
            if (SdkLevel.isAtLeastS()) {
                extras.putParcelable(EXTRA_PARAM_KEY_ATTRIBUTION_SOURCE, this.mContext.getAttributionSource());
            }
            this.mService.getMaxMloStrLinkCount(new IIntegerListener.Stub(this){

                @Override
                public void onResult(int value) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> resultsCallback.accept(value));
                }
            }, extras);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @RequiresApi(value=34)
    @RequiresPermission(value="android.permission.MANAGE_WIFI_NETWORK_SELECTION")
    public void getSupportedSimultaneousBandCombinations(final @NonNull Executor executor, final @NonNull Consumer<List<int[]>> resultsCallback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(resultsCallback, "resultsCallback cannot be null");
        try {
            Bundle extras = new Bundle();
            if (SdkLevel.isAtLeastS()) {
                extras.putParcelable(EXTRA_PARAM_KEY_ATTRIBUTION_SOURCE, this.mContext.getAttributionSource());
            }
            this.mService.getSupportedSimultaneousBandCombinations(new IWifiBandsListener.Stub(this){

                @Override
                public void onResult(WifiBands[] supportedBands) {
                    Binder.clearCallingIdentity();
                    ArrayList<int[]> bandCombinations = new ArrayList<int[]>();
                    for (WifiBands wifiBands : supportedBands) {
                        bandCombinations.add(wifiBands.bands);
                    }
                    executor.execute(() -> resultsCallback.accept(bandCombinations));
                }
            }, extras);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public void setWepAllowed(boolean isAllowed) {
        try {
            this.mService.setWepAllowed(isAllowed);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public void queryWepAllowed(final @NonNull Executor executor, final @NonNull Consumer<Boolean> resultsCallback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(resultsCallback, "resultsCallback cannot be null");
        try {
            this.mService.queryWepAllowed(new IBooleanListener.Stub(this){

                @Override
                public void onResult(boolean value) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> resultsCallback.accept(value));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=35)
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @RequiresPermission(anyOf={"android.permission.MANAGE_WIFI_NETWORK_SELECTION"})
    public void enableMscs(@NonNull MscsParams mscsParams) {
        Objects.requireNonNull(mscsParams);
        try {
            this.mService.enableMscs(mscsParams);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=35)
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @RequiresPermission(anyOf={"android.permission.MANAGE_WIFI_NETWORK_SELECTION"})
    public void disableMscs() {
        try {
            this.mService.disableMscs();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public void setSendDhcpHostnameRestriction(int restriction) {
        try {
            this.mService.setSendDhcpHostnameRestriction(this.mContext.getOpPackageName(), restriction);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public void querySendDhcpHostnameRestriction(final @NonNull Executor executor, final @NonNull IntConsumer resultsCallback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(resultsCallback, "resultsCallback cannot be null");
        try {
            this.mService.querySendDhcpHostnameRestriction(this.mContext.getOpPackageName(), new IIntegerListener.Stub(this){

                @Override
                public void onResult(int value) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> resultsCallback.accept(value));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public boolean isAggressiveRoamingModeSupported() {
        return this.isFeatureSupported(61);
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @RequiresApi(value=35)
    @SuppressLint(value={"RequiresPermission"})
    public void setPerSsidRoamingMode(@NonNull WifiSsid ssid, int roamingMode) {
        if (roamingMode < 0 || roamingMode > 2) {
            throw new IllegalArgumentException("invalid roaming mode: " + roamingMode);
        }
        Objects.requireNonNull(ssid, "ssid cannot be null");
        try {
            this.mService.setPerSsidRoamingMode(ssid, roamingMode, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @RequiresApi(value=35)
    @SuppressLint(value={"RequiresPermission"})
    public void removePerSsidRoamingMode(@NonNull WifiSsid ssid) {
        Objects.requireNonNull(ssid, "ssid cannot be null");
        try {
            this.mService.removePerSsidRoamingMode(ssid, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @RequiresApi(value=35)
    @SuppressLint(value={"RequiresPermission"})
    public void getPerSsidRoamingModes(final @NonNull Executor executor, final @NonNull Consumer<Map<String, Integer>> resultsCallback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(resultsCallback, "resultsCallback cannot be null");
        try {
            this.mService.getPerSsidRoamingModes(this.mContext.getOpPackageName(), new IMapListener.Stub(this){

                @Override
                public void onResult(Map roamingPolicies) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> resultsCallback.accept(roamingPolicies));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=35)
    @RequiresPermission(value="android.permission.MANAGE_WIFI_NETWORK_SELECTION")
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public void getTwtCapabilities(final @NonNull Executor executor, final @NonNull Consumer<Bundle> resultCallback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(resultCallback, "resultCallback cannot be null");
        if (!SdkLevel.isAtLeastV()) {
            throw new UnsupportedOperationException();
        }
        try {
            Bundle extras = new Bundle();
            extras.putParcelable(EXTRA_PARAM_KEY_ATTRIBUTION_SOURCE, this.mContext.getAttributionSource());
            this.mService.getTwtCapabilities(new ITwtCapabilitiesListener.Stub(this){

                @Override
                public void onResult(Bundle value) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> resultCallback.accept(value));
                }
            }, extras);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=35)
    @RequiresPermission(value="android.permission.MANAGE_WIFI_NETWORK_SELECTION")
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public void setupTwtSession(@NonNull TwtRequest twtRequest, @NonNull Executor executor, @NonNull TwtSessionCallback callback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(callback, "callback cannot be null");
        Objects.requireNonNull(twtRequest, "twtRequest cannot be null");
        if (!SdkLevel.isAtLeastV()) {
            throw new UnsupportedOperationException();
        }
        try {
            TwtCallbackProxy binderCallback = new TwtCallbackProxy(executor, callback);
            Bundle extras = new Bundle();
            extras.putParcelable(EXTRA_PARAM_KEY_ATTRIBUTION_SOURCE, this.mContext.getAttributionSource());
            this.mService.setupTwtSession(twtRequest, binderCallback, extras);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void getStatsTwtSession(@NonNull int sessionId, final @NonNull Executor executor, final @NonNull Consumer<Bundle> resultCallback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(resultCallback, "resultsCallback cannot be null");
        if (!SdkLevel.isAtLeastV()) {
            throw new UnsupportedOperationException();
        }
        try {
            Bundle extras = new Bundle();
            if (SdkLevel.isAtLeastS()) {
                extras.putParcelable(EXTRA_PARAM_KEY_ATTRIBUTION_SOURCE, this.mContext.getAttributionSource());
            }
            this.mService.getStatsTwtSession(sessionId, new ITwtStatsListener.Stub(this){

                @Override
                public void onResult(Bundle value) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> resultCallback.accept(value));
                }
            }, extras);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void teardownTwtSession(int sessionId) {
        if (!SdkLevel.isAtLeastV()) {
            throw new UnsupportedOperationException();
        }
        try {
            Bundle extras = new Bundle();
            if (SdkLevel.isAtLeastS()) {
                extras.putParcelable(EXTRA_PARAM_KEY_ATTRIBUTION_SOURCE, this.mContext.getAttributionSource());
            }
            this.mService.teardownTwtSession(sessionId, extras);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    @RequiresApi(value=33)
    public void setD2dAllowedWhenInfraStaDisabled(boolean isAllowed) {
        try {
            this.mService.setD2dAllowedWhenInfraStaDisabled(isAllowed);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public void queryD2dAllowedWhenInfraStaDisabled(final @NonNull Executor executor, final @NonNull Consumer<Boolean> resultsCallback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(resultsCallback, "resultsCallback cannot be null");
        try {
            this.mService.queryD2dAllowedWhenInfraStaDisabled(new IBooleanListener.Stub(this){

                @Override
                public void onResult(boolean value) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> resultsCallback.accept(value));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.wifi.flags.autojoin_restriction_security_types_api")
    @RequiresApi(value=33)
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.MANAGE_WIFI_NETWORK_SELECTION"})
    public void setAutojoinDisallowedSecurityTypes(@NonNull int[] restrictions) {
        if (!SdkLevel.isAtLeastT()) {
            throw new UnsupportedOperationException();
        }
        Objects.requireNonNull(restrictions, "restrictions cannot be null");
        try {
            Bundle extras = new Bundle();
            extras.putParcelable(EXTRA_PARAM_KEY_ATTRIBUTION_SOURCE, this.mContext.getAttributionSource());
            int restrictionBitmap = 0;
            for (int securityType : restrictions) {
                restrictionBitmap |= 1 << securityType;
            }
            this.mService.setAutojoinDisallowedSecurityTypes(restrictionBitmap, extras);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.wifi.flags.autojoin_restriction_security_types_api")
    @RequiresApi(value=33)
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.MANAGE_WIFI_NETWORK_SELECTION"})
    public void getAutojoinDisallowedSecurityTypes(final @NonNull Executor executor, final @NonNull Consumer<int[]> resultsCallback) {
        if (!SdkLevel.isAtLeastT()) {
            throw new UnsupportedOperationException();
        }
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(resultsCallback, "resultsCallback cannot be null");
        try {
            Bundle extras = new Bundle();
            extras.putParcelable(EXTRA_PARAM_KEY_ATTRIBUTION_SOURCE, this.mContext.getAttributionSource());
            this.mService.getAutojoinDisallowedSecurityTypes(new IIntegerListener.Stub(this){

                @Override
                public void onResult(int value) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> {
                        ArrayList<Integer> restrictions = new ArrayList<Integer>();
                        for (int i = 0; i < 32; ++i) {
                            if ((1 << i & value) == 0) continue;
                            restrictions.add(i);
                        }
                        int[] results = new int[restrictions.size()];
                        for (int i = 0; i < restrictions.size(); ++i) {
                            results[i] = (Integer)restrictions.get(i);
                        }
                        resultsCallback.accept(results);
                    });
                }
            }, extras);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @FlaggedApi(value="android.security.aapm_api")
    @RequiresApi(value=36)
    @NonNull
    @SuppressLint(value={"NewApi"})
    public List<AdvancedProtectionFeature> getAvailableAdvancedProtectionFeatures() {
        if (!Environment.isSdkAtLeastB()) {
            throw new UnsupportedOperationException();
        }
        ArrayList<AdvancedProtectionFeature> features = new ArrayList<AdvancedProtectionFeature>();
        if (com.android.wifi.x.com.android.wifi.flags.Flags.wepDisabledInApm() && Flags.aapmApi()) {
            features.add(new AdvancedProtectionFeature(3));
        }
        return features;
    }

    @FlaggedApi(value="com.android.wifi.flags.bssid_blocklist_for_suggestion")
    @RequiresPermission(value="android.permission.CHANGE_WIFI_STATE")
    public void disallowCurrentSuggestedNetwork(@NonNull BlockingOption blockingOption) {
        Objects.requireNonNull(blockingOption, "blockingOption cannot be null");
        try {
            this.mService.disallowCurrentSuggestedNetwork(blockingOption, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @android.annotation.RequiresApi(value=36)
    @FlaggedApi(value="android.net.wifi.flags.usd")
    @RequiresPermission(value="android.permission.MANAGE_WIFI_NETWORK_SELECTION")
    public boolean isUsdSubscriberSupported() {
        if (!Environment.isSdkAtLeastB()) {
            throw new UnsupportedOperationException();
        }
        try {
            return this.mService.isUsdSubscriberSupported();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @android.annotation.RequiresApi(value=36)
    @FlaggedApi(value="android.net.wifi.flags.usd")
    @RequiresPermission(value="android.permission.MANAGE_WIFI_NETWORK_SELECTION")
    public boolean isUsdPublisherSupported() {
        if (!Environment.isSdkAtLeastB()) {
            throw new UnsupportedOperationException();
        }
        try {
            return this.mService.isUsdPublisherSupported();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public static class ScreenOnScanSchedule {
        private final Duration mScanInterval;
        private final int mScanType;

        public ScreenOnScanSchedule(@NonNull Duration scanInterval, int scanType) {
            if (scanInterval == null) {
                throw new IllegalArgumentException("scanInterval can't be null");
            }
            this.mScanInterval = scanInterval;
            this.mScanType = scanType;
        }

        @NonNull
        public Duration getScanInterval() {
            return this.mScanInterval;
        }

        public int getScanType() {
            return this.mScanType;
        }
    }

    public static class AddNetworkResult
    implements Parcelable {
        public static final int STATUS_SUCCESS = 0;
        public static final int STATUS_FAILURE_UNKNOWN = 1;
        public static final int STATUS_NO_PERMISSION = 2;
        public static final int STATUS_ADD_PASSPOINT_FAILURE = 3;
        public static final int STATUS_ADD_WIFI_CONFIG_FAILURE = 4;
        public static final int STATUS_INVALID_CONFIGURATION = 5;
        public static final int STATUS_NO_PERMISSION_MODIFY_CONFIG = 6;
        public static final int STATUS_NO_PERMISSION_MODIFY_PROXY_SETTING = 7;
        public static final int STATUS_NO_PERMISSION_MODIFY_MAC_RANDOMIZATION = 8;
        public static final int STATUS_FAILURE_UPDATE_NETWORK_KEYS = 9;
        public static final int STATUS_INVALID_CONFIGURATION_ENTERPRISE = 10;
        @NonNull
        public static final Parcelable.Creator<AddNetworkResult> CREATOR = new Parcelable.Creator<AddNetworkResult>(){

            @Override
            public AddNetworkResult createFromParcel(Parcel in) {
                return new AddNetworkResult(in.readInt(), in.readInt());
            }

            public AddNetworkResult[] newArray(int size) {
                return new AddNetworkResult[size];
            }
        };
        public final int statusCode;
        public final int networkId;

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.statusCode);
            dest.writeInt(this.networkId);
        }

        public AddNetworkResult(int statusCode, int networkId) {
            this.statusCode = statusCode;
            this.networkId = networkId;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface AddNetworkStatusCode {
        }
    }

    private class NetworkRequestMatchCallbackProxy
    extends INetworkRequestMatchCallback.Stub {
        private final Executor mExecutor;
        private final NetworkRequestMatchCallback mCallback;

        NetworkRequestMatchCallbackProxy(Executor executor, NetworkRequestMatchCallback callback) {
            this.mExecutor = executor;
            this.mCallback = callback;
        }

        @Override
        public void onUserSelectionCallbackRegistration(INetworkRequestUserSelectionCallback userSelectionCallback) {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "NetworkRequestMatchCallbackProxy: onUserSelectionCallbackRegistration callback: " + userSelectionCallback);
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onUserSelectionCallbackRegistration(new NetworkRequestUserSelectionCallbackProxy(userSelectionCallback)));
        }

        @Override
        public void onAbort() {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "NetworkRequestMatchCallbackProxy: onAbort");
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onAbort());
        }

        @Override
        public void onMatch(List<ScanResult> scanResults) {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "NetworkRequestMatchCallbackProxy: onMatch scanResults: " + scanResults);
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onMatch(scanResults));
        }

        @Override
        public void onUserSelectionConnectSuccess(WifiConfiguration wifiConfiguration) {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "NetworkRequestMatchCallbackProxy: onUserSelectionConnectSuccess  wificonfiguration: " + wifiConfiguration);
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onUserSelectionConnectSuccess(wifiConfiguration));
        }

        @Override
        public void onUserSelectionConnectFailure(WifiConfiguration wifiConfiguration) {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "NetworkRequestMatchCallbackProxy: onUserSelectionConnectFailure wificonfiguration: " + wifiConfiguration);
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onUserSelectionConnectFailure(wifiConfiguration));
        }
    }

    @SystemApi
    public static interface NetworkRequestMatchCallback {
        default public void onUserSelectionCallbackRegistration(@NonNull NetworkRequestUserSelectionCallback userSelectionCallback) {
        }

        default public void onAbort() {
        }

        default public void onMatch(@NonNull List<ScanResult> scanResults) {
        }

        default public void onUserSelectionConnectSuccess(@NonNull WifiConfiguration wifiConfiguration) {
        }

        default public void onUserSelectionConnectFailure(@NonNull WifiConfiguration wifiConfiguration) {
        }
    }

    private static class OnWifiActivityEnergyInfoProxy
    extends IOnWifiActivityEnergyInfoListener.Stub {
        private final Object mLock = new Object();
        @Nullable
        @GuardedBy(value={"mLock"})
        private Executor mExecutor;
        @Nullable
        @GuardedBy(value={"mLock"})
        private OnWifiActivityEnergyInfoListener mListener;

        OnWifiActivityEnergyInfoProxy(Executor executor, OnWifiActivityEnergyInfoListener listener) {
            this.mExecutor = executor;
            this.mListener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWifiActivityEnergyInfo(WifiActivityEnergyInfo info) {
            OnWifiActivityEnergyInfoListener listener;
            Executor executor;
            Object object = this.mLock;
            synchronized (object) {
                if (this.mExecutor == null || this.mListener == null) {
                    return;
                }
                executor = this.mExecutor;
                listener = this.mListener;
                this.mExecutor = null;
                this.mListener = null;
            }
            Binder.clearCallingIdentity();
            executor.execute(() -> listener.onWifiActivityEnergyInfo(info));
        }
    }

    @SystemApi
    public static interface OnWifiActivityEnergyInfoListener {
        public void onWifiActivityEnergyInfo(@Nullable WifiActivityEnergyInfo var1);
    }

    private static class OnDriverCountryCodeChangedProxy
    extends IOnWifiDriverCountryCodeChangedListener.Stub {
        @NonNull
        private Executor mExecutor;
        @NonNull
        private ActiveCountryCodeChangedCallback mCallback;

        OnDriverCountryCodeChangedProxy(@NonNull Executor executor, @NonNull ActiveCountryCodeChangedCallback callback) {
            Objects.requireNonNull(executor);
            Objects.requireNonNull(callback);
            this.mExecutor = executor;
            this.mCallback = callback;
        }

        @Override
        public void onDriverCountryCodeChanged(String countryCode) {
            Log.i(WifiManager.TAG, "OnDriverCountryCodeChangedProxy: receive onDriverCountryCodeChanged: " + countryCode);
            Binder.clearCallingIdentity();
            if (countryCode != null) {
                this.mExecutor.execute(() -> this.mCallback.onActiveCountryCodeChanged(countryCode));
            } else {
                this.mExecutor.execute(() -> this.mCallback.onCountryCodeInactive());
            }
        }
    }

    @SystemApi
    public static interface ActiveCountryCodeChangedCallback {
        public void onActiveCountryCodeChanged(@NonNull String var1);

        public void onCountryCodeInactive();
    }

    private static class OnWifiNetworkStateChangedProxy
    extends IWifiNetworkStateChangedListener.Stub {
        @NonNull
        private Executor mExecutor;
        @NonNull
        private WifiNetworkStateChangedListener mListener;

        OnWifiNetworkStateChangedProxy(@NonNull Executor executor, @NonNull WifiNetworkStateChangedListener listener) {
            Objects.requireNonNull(executor);
            Objects.requireNonNull(listener);
            this.mExecutor = executor;
            this.mListener = listener;
        }

        @Override
        public void onWifiNetworkStateChanged(int cmmRole, int state) {
            Log.i(WifiManager.TAG, "OnWifiNetworkStateChangedProxy: onWifiNetworkStateChanged: " + cmmRole + ", " + state);
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mListener.onWifiNetworkStateChanged(cmmRole, state));
        }
    }

    @SystemApi
    public static interface WifiNetworkStateChangedListener {
        public static final int WIFI_ROLE_CLIENT_PRIMARY = 1;
        public static final int WIFI_ROLE_CLIENT_SECONDARY_INTERNET = 2;
        public static final int WIFI_ROLE_CLIENT_SECONDARY_LOCAL_ONLY = 3;
        public static final int WIFI_NETWORK_STATUS_IDLE = 1;
        public static final int WIFI_NETWORK_STATUS_SCANNING = 2;
        public static final int WIFI_NETWORK_STATUS_CONNECTING = 3;
        public static final int WIFI_NETWORK_STATUS_AUTHENTICATING = 4;
        public static final int WIFI_NETWORK_STATUS_OBTAINING_IPADDR = 5;
        public static final int WIFI_NETWORK_STATUS_CONNECTED = 6;
        public static final int WIFI_NETWORK_STATUS_DISCONNECTED = 7;
        public static final int WIFI_NETWORK_STATUS_FAILED = 8;

        public void onWifiNetworkStateChanged(int var1, int var2);

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface WifiNetworkState {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface WifiClientModeRole {
        }
    }

    @RequiresApi(value=31)
    public static abstract class SubsystemRestartTrackingCallback {
        private final SubsystemRestartCallbackProxy mProxy = new SubsystemRestartCallbackProxy();

        @NonNull
        SubsystemRestartCallbackProxy getProxy() {
            return this.mProxy;
        }

        public abstract void onSubsystemRestarting();

        public abstract void onSubsystemRestarted();

        private static class SubsystemRestartCallbackProxy
        extends ISubsystemRestartCallback.Stub {
            private final Object mLock = new Object();
            @Nullable
            @GuardedBy(value={"mLock"})
            private Executor mExecutor = null;
            @Nullable
            @GuardedBy(value={"mLock"})
            private SubsystemRestartTrackingCallback mCallback = null;

            SubsystemRestartCallbackProxy() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void initProxy(@NonNull Executor executor, @NonNull SubsystemRestartTrackingCallback callback) {
                Object object = this.mLock;
                synchronized (object) {
                    this.mExecutor = executor;
                    this.mCallback = callback;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void cleanUpProxy() {
                Object object = this.mLock;
                synchronized (object) {
                    this.mExecutor = null;
                    this.mCallback = null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSubsystemRestarting() {
                SubsystemRestartTrackingCallback callback;
                Executor executor;
                Object object = this.mLock;
                synchronized (object) {
                    executor = this.mExecutor;
                    callback = this.mCallback;
                }
                if (executor == null || callback == null) {
                    return;
                }
                Binder.clearCallingIdentity();
                executor.execute(callback::onSubsystemRestarting);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSubsystemRestarted() {
                SubsystemRestartTrackingCallback callback;
                Executor executor;
                Object object = this.mLock;
                synchronized (object) {
                    executor = this.mExecutor;
                    callback = this.mCallback;
                }
                if (executor == null || callback == null) {
                    return;
                }
                Binder.clearCallingIdentity();
                executor.execute(callback::onSubsystemRestarted);
            }
        }
    }

    private static class WifiStateChangedListenerProxy
    extends IWifiStateChangedListener.Stub {
        private Executor mExecutor;
        private WifiStateChangedListener mListener;

        WifiStateChangedListenerProxy(@NonNull Executor executor, @NonNull WifiStateChangedListener listener) {
            Objects.requireNonNull(executor);
            Objects.requireNonNull(listener);
            this.mExecutor = executor;
            this.mListener = listener;
        }

        @Override
        public void onWifiStateChanged() {
            Log.i(WifiManager.TAG, "WifiStateChangedListenerProxy: onWifiStateChanged");
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mListener.onWifiStateChanged());
        }
    }

    @FlaggedApi(value="com.android.wifi.flags.wifi_state_changed_listener")
    public static interface WifiStateChangedListener {
        public void onWifiStateChanged();
    }

    @SystemApi
    @RequiresApi(value=31)
    public static abstract class CoexCallback {
        private final CoexCallbackProxy mCoexCallbackProxy;

        public CoexCallback() {
            if (!SdkLevel.isAtLeastS()) {
                throw new UnsupportedOperationException();
            }
            this.mCoexCallbackProxy = new CoexCallbackProxy();
        }

        @NonNull
        CoexCallbackProxy getProxy() {
            return this.mCoexCallbackProxy;
        }

        public abstract void onCoexUnsafeChannelsChanged(@NonNull List<CoexUnsafeChannel> var1, int var2);

        private static class CoexCallbackProxy
        extends ICoexCallback.Stub {
            private final Object mLock = new Object();
            @Nullable
            @GuardedBy(value={"mLock"})
            private Executor mExecutor = null;
            @Nullable
            @GuardedBy(value={"mLock"})
            private CoexCallback mCallback = null;

            CoexCallbackProxy() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void initProxy(@NonNull Executor executor, @NonNull CoexCallback callback) {
                Object object = this.mLock;
                synchronized (object) {
                    this.mExecutor = executor;
                    this.mCallback = callback;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void cleanUpProxy() {
                Object object = this.mLock;
                synchronized (object) {
                    this.mExecutor = null;
                    this.mCallback = null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCoexUnsafeChannelsChanged(@NonNull List<CoexUnsafeChannel> unsafeChannels, int restrictions) {
                CoexCallback callback;
                Executor executor;
                Object object = this.mLock;
                synchronized (object) {
                    executor = this.mExecutor;
                    callback = this.mCallback;
                }
                if (executor == null || callback == null) {
                    return;
                }
                Binder.clearCallingIdentity();
                executor.execute(() -> callback.onCoexUnsafeChannelsChanged(unsafeChannels, restrictions));
            }
        }
    }

    private class SoftApCallbackProxy
    extends ISoftApCallback.Stub {
        private final Executor mExecutor;
        private final SoftApCallback mCallback;
        private final int mIpMode;
        private Map<String, List<WifiClient>> mCurrentClients = new HashMap<String, List<WifiClient>>();
        private Map<String, SoftApInfo> mCurrentInfos = new HashMap<String, SoftApInfo>();

        private List<WifiClient> getConnectedClientList(Map<String, List<WifiClient>> clientsMap) {
            ArrayList<WifiClient> connectedClientList = new ArrayList<WifiClient>();
            for (List<WifiClient> it : clientsMap.values()) {
                connectedClientList.addAll(it);
            }
            return connectedClientList;
        }

        SoftApCallbackProxy(Executor executor, SoftApCallback callback, int mode) {
            this.mExecutor = executor;
            this.mCallback = callback;
            this.mIpMode = mode;
        }

        @Override
        public void onStateChanged(SoftApState state) {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "SoftApCallbackProxy on mode " + this.mIpMode + ", onStateChanged: " + state);
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onStateChanged(state));
        }

        @Override
        public void onConnectedClientsOrInfoChanged(Map<String, SoftApInfo> infos, Map<String, List<WifiClient>> clients, boolean isBridged, boolean isRegistration) {
            boolean isInfoChanged;
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "SoftApCallbackProxy on mode " + this.mIpMode + ", onConnectedClientsOrInfoChanged: clients: " + clients + ", infos: " + infos + ", isBridged is " + isBridged + ", isRegistration is " + isRegistration);
            }
            ArrayList<SoftApInfo> changedInfoList = new ArrayList<SoftApInfo>(infos.values());
            HashMap<SoftApInfo, List<WifiClient>> changedInfoClients = new HashMap<SoftApInfo, List<WifiClient>>();
            boolean areClientsChangedWithoutInfosChanged = infos.size() == 0 && this.getConnectedClientList(clients).size() != this.getConnectedClientList(this.mCurrentClients).size();
            boolean bl = isInfoChanged = infos.size() != this.mCurrentInfos.size();
            if (isRegistration) {
                for (SoftApInfo currentInfo : infos.values()) {
                    String instance = currentInfo.getApInstanceIdentifier();
                    if (clients.getOrDefault(instance, Collections.emptyList()).size() <= 0) continue;
                    changedInfoClients.put(currentInfo, clients.get(instance));
                }
            }
            for (SoftApInfo info : this.mCurrentInfos.values()) {
                String changedInstance = info.getApInstanceIdentifier();
                List changedClientList = clients.getOrDefault(changedInstance, Collections.emptyList());
                if (!changedInfoList.contains(info)) {
                    isInfoChanged = true;
                    if (this.mCurrentClients.getOrDefault(changedInstance, Collections.emptyList()).size() <= 0) continue;
                    SoftApInfo changedInfo = infos.get(changedInstance);
                    if (changedInfo == null || changedInfo.getFrequency() == 0) {
                        Log.d(WifiManager.TAG, "SoftApCallbackProxy on mode " + this.mIpMode + ", info changed on client connected instance(AP disabled)");
                        changedInfoClients.put(info, Collections.emptyList());
                        continue;
                    }
                    Log.d(WifiManager.TAG, "SoftApCallbackProxy on mode " + this.mIpMode + ", info changed on client connected instance");
                    changedInfoClients.put(changedInfo, changedClientList);
                    continue;
                }
                if (changedClientList.size() == this.mCurrentClients.getOrDefault(changedInstance, Collections.emptyList()).size()) continue;
                changedInfoClients.put(info, changedClientList);
            }
            this.mCurrentClients = clients;
            this.mCurrentInfos = infos;
            if (!isInfoChanged && changedInfoClients.isEmpty() && !isRegistration && !areClientsChangedWithoutInfosChanged) {
                Log.v(WifiManager.TAG, "SoftApCallbackProxy on mode " + this.mIpMode + ", No changed & Not Registration don't need to notify the client");
                return;
            }
            Binder.clearCallingIdentity();
            for (SoftApInfo changedInfo : changedInfoClients.keySet()) {
                Log.v(WifiManager.TAG, "SoftApCallbackProxy on mode " + this.mIpMode + ", send onConnectedClientsChanged, changedInfo is " + changedInfo + " and clients are " + changedInfoClients.get(changedInfo));
                this.mExecutor.execute(() -> this.mCallback.onConnectedClientsChanged(changedInfo, (List)changedInfoClients.get(changedInfo)));
            }
            if (isInfoChanged || isRegistration) {
                if (!isBridged) {
                    SoftApInfo newInfo = changedInfoList.isEmpty() ? new SoftApInfo() : (SoftApInfo)changedInfoList.get(0);
                    Log.v(WifiManager.TAG, "SoftApCallbackProxy on mode " + this.mIpMode + ", send InfoChanged, newInfo: " + newInfo);
                    this.mExecutor.execute(() -> this.mCallback.onInfoChanged(newInfo));
                }
                Log.v(WifiManager.TAG, "SoftApCallbackProxy on mode " + this.mIpMode + ", send InfoChanged, changedInfoList: " + changedInfoList);
                this.mExecutor.execute(() -> this.mCallback.onInfoChanged(changedInfoList));
            }
            if (isRegistration || !changedInfoClients.isEmpty() || areClientsChangedWithoutInfosChanged) {
                Log.v(WifiManager.TAG, "SoftApCallbackProxy on mode " + this.mIpMode + ", send onConnectedClientsChanged(clients): " + this.getConnectedClientList(clients));
                this.mExecutor.execute(() -> this.mCallback.onConnectedClientsChanged(this.getConnectedClientList(clients)));
            }
        }

        @Override
        public void onCapabilityChanged(SoftApCapability capability) {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "SoftApCallbackProxy on mode " + this.mIpMode + ",  onCapabilityChanged: SoftApCapability = " + capability);
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onCapabilityChanged(capability));
        }

        @Override
        public void onBlockedClientConnecting(@NonNull WifiClient client, int blockedReason) {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "SoftApCallbackProxy on mode " + this.mIpMode + ", onBlockedClientConnecting: client =" + client + " with reason = " + blockedReason);
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onBlockedClientConnecting(client, blockedReason));
        }

        @Override
        public void onClientsDisconnected(SoftApInfo info, List<WifiClient> clients) {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "SoftApCallbackProxy on mode " + this.mIpMode + ", onClientsDisconnected: info =" + info + " with clients = " + clients);
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onClientsDisconnected(info, clients));
        }
    }

    @SystemApi
    public static interface SoftApCallback {
        default public void onStateChanged(int state, int failureReason) {
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        default public void onStateChanged(@NonNull SoftApState state) {
            this.onStateChanged(state.mState, state.mFailureReason);
        }

        @Deprecated
        default public void onConnectedClientsChanged(@NonNull List<WifiClient> clients) {
        }

        default public void onConnectedClientsChanged(@NonNull SoftApInfo info, @NonNull List<WifiClient> clients) {
        }

        @Deprecated
        default public void onInfoChanged(@NonNull SoftApInfo softApInfo) {
        }

        default public void onInfoChanged(@NonNull List<SoftApInfo> softApInfoList) {
        }

        default public void onCapabilityChanged(@NonNull SoftApCapability softApCapability) {
        }

        default public void onBlockedClientConnecting(@NonNull WifiClient client, int blockedReason) {
        }

        @FlaggedApi(value="com.android.wifi.flags.softap_disconnect_reason")
        default public void onClientsDisconnected(@NonNull SoftApInfo info, @NonNull List<WifiClient> clients) {
        }
    }

    public static class LocalOnlyHotspotCallback {
        public static final int REQUEST_REGISTERED = 0;
        public static final int ERROR_NO_CHANNEL = 1;
        public static final int ERROR_GENERIC = 2;
        public static final int ERROR_INCOMPATIBLE_MODE = 3;
        public static final int ERROR_TETHERING_DISALLOWED = 4;

        public void onStarted(LocalOnlyHotspotReservation reservation) {
        }

        public void onStopped() {
        }

        public void onFailed(int reason) {
        }
    }

    private static class LocalOnlyHotspotCallbackProxy
    extends ILocalOnlyHotspotCallback.Stub {
        private final WeakReference<WifiManager> mWifiManager;
        private final Executor mExecutor;
        private final LocalOnlyHotspotCallback mCallback;

        LocalOnlyHotspotCallbackProxy(@NonNull WifiManager manager, @NonNull Executor executor, @Nullable LocalOnlyHotspotCallback callback) {
            this.mWifiManager = new WeakReference<WifiManager>(manager);
            this.mExecutor = executor;
            this.mCallback = callback;
        }

        @Override
        public void onHotspotStarted(SoftApConfiguration config) {
            WifiManager manager = (WifiManager)this.mWifiManager.get();
            if (manager == null) {
                return;
            }
            if (config == null) {
                Log.e(WifiManager.TAG, "LocalOnlyHotspotCallbackProxy: config cannot be null.");
                this.onHotspotFailed(2);
                return;
            }
            WifiManager wifiManager = manager;
            Objects.requireNonNull(wifiManager);
            LocalOnlyHotspotReservation reservation = wifiManager.new LocalOnlyHotspotReservation(config);
            if (this.mCallback == null) {
                return;
            }
            this.mExecutor.execute(() -> this.mCallback.onStarted(reservation));
        }

        @Override
        public void onHotspotStopped() {
            WifiManager manager = (WifiManager)this.mWifiManager.get();
            if (manager == null) {
                return;
            }
            Log.w(WifiManager.TAG, "LocalOnlyHotspotCallbackProxy: hotspot stopped");
            if (this.mCallback == null) {
                return;
            }
            this.mExecutor.execute(() -> this.mCallback.onStopped());
        }

        @Override
        public void onHotspotFailed(int reason) {
            WifiManager manager = (WifiManager)this.mWifiManager.get();
            if (manager == null) {
                return;
            }
            Log.w(WifiManager.TAG, "LocalOnlyHotspotCallbackProxy: failed to start.  reason: " + reason);
            if (this.mCallback == null) {
                return;
            }
            this.mExecutor.execute(() -> this.mCallback.onFailed(reason));
        }
    }

    private static class LocalOnlyHotspotObserverProxy
    extends ILocalOnlyHotspotCallback.Stub {
        private final WeakReference<WifiManager> mWifiManager;
        private final Executor mExecutor;
        private final LocalOnlyHotspotObserver mObserver;

        LocalOnlyHotspotObserverProxy(WifiManager manager, Executor executor, LocalOnlyHotspotObserver observer) {
            this.mWifiManager = new WeakReference<WifiManager>(manager);
            this.mExecutor = executor;
            this.mObserver = observer;
        }

        public void registered() throws RemoteException {
            WifiManager manager = (WifiManager)this.mWifiManager.get();
            if (manager == null) {
                return;
            }
            this.mExecutor.execute(() -> this.mObserver.onRegistered(manager.new LocalOnlyHotspotSubscription()));
        }

        @Override
        public void onHotspotStarted(SoftApConfiguration config) {
            WifiManager manager = (WifiManager)this.mWifiManager.get();
            if (manager == null) {
                return;
            }
            if (config == null) {
                Log.e(WifiManager.TAG, "LocalOnlyHotspotObserverProxy: config cannot be null.");
                return;
            }
            this.mExecutor.execute(() -> this.mObserver.onStarted(config));
        }

        @Override
        public void onHotspotStopped() {
            WifiManager manager = (WifiManager)this.mWifiManager.get();
            if (manager == null) {
                return;
            }
            this.mExecutor.execute(() -> this.mObserver.onStopped());
        }

        @Override
        public void onHotspotFailed(int reason) {
        }
    }

    public static class LocalOnlyHotspotObserver {
        public void onRegistered(LocalOnlyHotspotSubscription subscription) {
        }

        public void onStarted(SoftApConfiguration config) {
        }

        public void onStopped() {
        }
    }

    private class ActionListenerProxy
    extends IActionListener.Stub {
        private final String mActionTag;
        private final Handler mHandler;
        private final ActionListener mCallback;

        ActionListenerProxy(String actionTag, Looper looper, ActionListener callback) {
            this.mActionTag = actionTag;
            this.mHandler = new Handler(looper);
            this.mCallback = callback;
        }

        @Override
        public void onSuccess() {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "ActionListenerProxy:" + this.mActionTag + ": onSuccess");
            }
            this.mHandler.post(() -> this.mCallback.onSuccess());
        }

        @Override
        public void onFailure(int reason) {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "ActionListenerProxy:" + this.mActionTag + ": onFailure=" + reason);
            }
            this.mHandler.post(() -> this.mCallback.onFailure(reason));
        }
    }

    @SystemApi
    public static interface ActionListener {
        public static final int FAILURE_INTERNAL_ERROR = 0;
        public static final int FAILURE_IN_PROGRESS = 1;
        public static final int FAILURE_BUSY = 2;
        public static final int FAILURE_INVALID_ARGS = 3;
        public static final int FAILURE_NOT_AUTHORIZED = 4;

        public void onSuccess();

        public void onFailure(int var1);
    }

    public static abstract class WpsCallback {
        public abstract void onStarted(String var1);

        public abstract void onSucceeded();

        public abstract void onFailed(int var1);
    }

    public class WifiLock {
        private String mTag;
        private final IBinder mBinder;
        private int mRefCount;
        int mLockType;
        private boolean mRefCounted;
        private boolean mHeld;
        private WorkSource mWorkSource;

        private WifiLock(int lockType, String tag) {
            this.mTag = tag;
            this.mLockType = lockType;
            this.mBinder = new Binder();
            this.mRefCount = 0;
            this.mRefCounted = true;
            this.mHeld = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                if (this.mRefCounted ? ++this.mRefCount == 1 : !this.mHeld) {
                    try {
                        Bundle extras = new Bundle();
                        if (SdkLevel.isAtLeastS()) {
                            extras.putParcelable(WifiManager.EXTRA_PARAM_KEY_ATTRIBUTION_SOURCE, WifiManager.this.mContext.getAttributionSource());
                        }
                        WifiManager.this.mService.acquireWifiLock(this.mBinder, this.mLockType, this.mTag, this.mWorkSource, WifiManager.this.mContext.getOpPackageName(), extras);
                        WifiManager wifiManager = WifiManager.this;
                        synchronized (wifiManager) {
                            if (WifiManager.this.mActiveLockCount >= 50) {
                                WifiManager.this.mService.releaseWifiLock(this.mBinder);
                                throw new UnsupportedOperationException("Exceeded maximum number of wifi locks");
                            }
                            ++WifiManager.this.mActiveLockCount;
                        }
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                    this.mHeld = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                if (this.mRefCounted ? --this.mRefCount == 0 : this.mHeld) {
                    try {
                        WifiManager.this.mService.releaseWifiLock(this.mBinder);
                        WifiManager wifiManager = WifiManager.this;
                        synchronized (wifiManager) {
                            --WifiManager.this.mActiveLockCount;
                        }
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                    this.mHeld = false;
                }
                if (this.mRefCount < 0) {
                    throw new RuntimeException("WifiLock under-locked " + this.mTag);
                }
            }
        }

        public void setReferenceCounted(boolean refCounted) {
            this.mRefCounted = refCounted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isHeld() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                return this.mHeld;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setWorkSource(WorkSource ws) {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                if (ws != null && ws.isEmpty()) {
                    ws = null;
                }
                boolean changed = true;
                if (ws == null) {
                    this.mWorkSource = null;
                } else {
                    ws = ws.withoutNames();
                    if (this.mWorkSource == null) {
                        changed = this.mWorkSource != null;
                        this.mWorkSource = new WorkSource(ws);
                    } else {
                        boolean bl = changed = !((Object)this.mWorkSource).equals(ws);
                        if (changed) {
                            this.mWorkSource.set(ws);
                        }
                    }
                }
                if (changed && this.mHeld) {
                    try {
                        Bundle extras = new Bundle();
                        if (SdkLevel.isAtLeastS()) {
                            extras.putParcelable(WifiManager.EXTRA_PARAM_KEY_ATTRIBUTION_SOURCE, WifiManager.this.mContext.getAttributionSource());
                        }
                        WifiManager.this.mService.updateWifiLockWorkSource(this.mBinder, this.mWorkSource, WifiManager.this.mContext.getOpPackageName(), extras);
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                String s1 = Integer.toHexString(System.identityHashCode(this));
                String s2 = this.mHeld ? "held; " : "";
                String s3 = this.mRefCounted ? "refcounted: refcount = " + this.mRefCount : "not refcounted";
                return "WifiLock{ " + s1 + "; " + s2 + s3 + " }";
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            super.finalize();
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                if (this.mHeld) {
                    try {
                        WifiManager.this.mService.releaseWifiLock(this.mBinder);
                        WifiManager wifiManager = WifiManager.this;
                        synchronized (wifiManager) {
                            --WifiManager.this.mActiveLockCount;
                        }
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                }
            }
        }
    }

    private static class OnWifiLowLatencyLockProxy
    extends IWifiLowLatencyLockListener.Stub {
        @NonNull
        private Executor mExecutor;
        @NonNull
        private WifiLowLatencyLockListener mListener;

        OnWifiLowLatencyLockProxy(@NonNull Executor executor, @NonNull WifiLowLatencyLockListener listener) {
            Objects.requireNonNull(executor);
            Objects.requireNonNull(listener);
            this.mExecutor = executor;
            this.mListener = listener;
        }

        @Override
        public void onActivatedStateChanged(boolean activated) {
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mListener.onActivatedStateChanged(activated));
        }

        @Override
        public void onOwnershipChanged(@NonNull int[] ownerUids) {
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mListener.onOwnershipChanged(ownerUids));
        }

        @Override
        public void onActiveUsersChanged(@NonNull int[] activeUids) {
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mListener.onActiveUsersChanged(activeUids));
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static interface WifiLowLatencyLockListener {
        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        public void onActivatedStateChanged(boolean var1);

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        default public void onOwnershipChanged(@NonNull int[] ownerUids) {
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        default public void onActiveUsersChanged(@NonNull int[] activeUids) {
        }
    }

    public class MulticastLock {
        private String mTag;
        private final IBinder mBinder;
        private int mRefCount;
        private boolean mRefCounted;
        private boolean mHeld;

        private MulticastLock(String tag) {
            this.mTag = tag;
            this.mBinder = new Binder();
            this.mRefCount = 0;
            this.mRefCounted = true;
            this.mHeld = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                if (this.mRefCounted ? ++this.mRefCount == 1 : !this.mHeld) {
                    try {
                        WifiManager.this.mService.acquireMulticastLock(this.mBinder, this.mTag, WifiManager.this.mContext.getAttributionTag(), WifiManager.this.mContext.getOpPackageName());
                        WifiManager wifiManager = WifiManager.this;
                        synchronized (wifiManager) {
                            if (WifiManager.this.mActiveLockCount >= 50) {
                                WifiManager.this.mService.releaseMulticastLock(this.mBinder, this.mTag);
                                throw new UnsupportedOperationException("Exceeded maximum number of wifi locks");
                            }
                            ++WifiManager.this.mActiveLockCount;
                        }
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                    this.mHeld = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                if (this.mRefCounted ? --this.mRefCount == 0 : this.mHeld) {
                    try {
                        WifiManager.this.mService.releaseMulticastLock(this.mBinder, this.mTag);
                        WifiManager wifiManager = WifiManager.this;
                        synchronized (wifiManager) {
                            --WifiManager.this.mActiveLockCount;
                        }
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                    this.mHeld = false;
                }
                if (this.mRefCount < 0) {
                    throw new RuntimeException("MulticastLock under-locked " + this.mTag);
                }
            }
        }

        public void setReferenceCounted(boolean refCounted) {
            this.mRefCounted = refCounted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isHeld() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                return this.mHeld;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                String s1 = Integer.toHexString(System.identityHashCode(this));
                String s2 = this.mHeld ? "held; " : "";
                String s3 = this.mRefCounted ? "refcounted: refcount = " + this.mRefCount : "not refcounted";
                return "MulticastLock{ " + s1 + "; " + s2 + s3 + " }";
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.setReferenceCounted(false);
            this.release();
        }
    }

    private static class ProvisioningCallbackProxy
    extends IProvisioningCallback.Stub {
        private final Executor mExecutor;
        private final ProvisioningCallback mCallback;

        ProvisioningCallbackProxy(Executor executor, ProvisioningCallback callback) {
            this.mExecutor = executor;
            this.mCallback = callback;
        }

        @Override
        public void onProvisioningStatus(int status) {
            this.mExecutor.execute(() -> this.mCallback.onProvisioningStatus(status));
        }

        @Override
        public void onProvisioningFailure(int status) {
            this.mExecutor.execute(() -> this.mCallback.onProvisioningFailure(status));
        }

        @Override
        public void onProvisioningComplete() {
            this.mExecutor.execute(() -> this.mCallback.onProvisioningComplete());
        }
    }

    private class TrafficStateCallbackProxy
    extends ITrafficStateCallback.Stub {
        private final Executor mExecutor;
        private final TrafficStateCallback mCallback;

        TrafficStateCallbackProxy(Executor executor, TrafficStateCallback callback) {
            this.mExecutor = executor;
            this.mCallback = callback;
        }

        @Override
        public void onStateChanged(int state) {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "TrafficStateCallbackProxy: onStateChanged state=" + state);
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onStateChanged(state));
        }
    }

    @SystemApi
    public static interface TrafficStateCallback {
        public static final int DATA_ACTIVITY_NONE = 0;
        public static final int DATA_ACTIVITY_IN = 1;
        public static final int DATA_ACTIVITY_OUT = 2;
        public static final int DATA_ACTIVITY_INOUT = 3;

        public void onStateChanged(int var1);

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface DataActivity {
        }
    }

    private static class EasyConnectCallbackProxy
    extends IDppCallback.Stub {
        private final Executor mExecutor;
        private final EasyConnectStatusCallback mEasyConnectStatusCallback;

        EasyConnectCallbackProxy(Executor executor, EasyConnectStatusCallback easyConnectStatusCallback) {
            this.mExecutor = executor;
            this.mEasyConnectStatusCallback = easyConnectStatusCallback;
        }

        @Override
        public void onSuccessConfigReceived(int newNetworkId) {
            Log.d(WifiManager.TAG, "Easy Connect onSuccessConfigReceived callback");
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mEasyConnectStatusCallback.onEnrolleeSuccess(newNetworkId));
        }

        @Override
        public void onSuccess(int status) {
            Log.d(WifiManager.TAG, "Easy Connect onSuccess callback");
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mEasyConnectStatusCallback.onConfiguratorSuccess(status));
        }

        @Override
        public void onFailure(int status, String ssid, String channelList, int[] operatingClassArray) {
            Log.d(WifiManager.TAG, "Easy Connect onFailure callback");
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> {
                SparseArray<int[]> channelListArray = WifiManager.parseDppChannelList(channelList);
                this.mEasyConnectStatusCallback.onFailure(status, ssid, channelListArray, operatingClassArray);
            });
        }

        @Override
        public void onProgress(int status) {
            Log.d(WifiManager.TAG, "Easy Connect onProgress callback");
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mEasyConnectStatusCallback.onProgress(status));
        }

        @Override
        public void onBootstrapUriGenerated(@NonNull String uri) {
            Log.d(WifiManager.TAG, "Easy Connect onBootstrapUriGenerated callback");
            if (!SdkLevel.isAtLeastS()) {
                Log.e(WifiManager.TAG, "Easy Connect bootstrap URI callback supported only on S+");
                return;
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mEasyConnectStatusCallback.onBootstrapUriGenerated(Uri.parse(uri)));
        }
    }

    @SystemApi
    public static interface OnWifiUsabilityStatsListener {
        public void onWifiUsabilityStats(int var1, boolean var2, @NonNull WifiUsabilityStatsEntry var3);
    }

    public static abstract class ScanResultsCallback {
        private final ScanResultsCallbackProxy mScanResultsCallbackProxy = new ScanResultsCallbackProxy();

        public abstract void onScanResultsAvailable();

        @NonNull
        ScanResultsCallbackProxy getProxy() {
            return this.mScanResultsCallbackProxy;
        }

        private static class ScanResultsCallbackProxy
        extends IScanResultsCallback.Stub {
            private final Object mLock = new Object();
            @Nullable
            @GuardedBy(value={"mLock"})
            private Executor mExecutor = null;
            @Nullable
            @GuardedBy(value={"mLock"})
            private ScanResultsCallback mCallback = null;

            ScanResultsCallbackProxy() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void initProxy(@NonNull Executor executor, @NonNull ScanResultsCallback callback) {
                Object object = this.mLock;
                synchronized (object) {
                    this.mExecutor = executor;
                    this.mCallback = callback;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void cleanUpProxy() {
                Object object = this.mLock;
                synchronized (object) {
                    this.mExecutor = null;
                    this.mCallback = null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onScanResultsAvailable() {
                ScanResultsCallback callback;
                Executor executor;
                Object object = this.mLock;
                synchronized (object) {
                    executor = this.mExecutor;
                    callback = this.mCallback;
                }
                if (callback == null || executor == null) {
                    return;
                }
                Binder.clearCallingIdentity();
                executor.execute(callback::onScanResultsAvailable);
            }
        }
    }

    @SystemApi
    public static interface WifiVerboseLoggingStatusChangedListener {
        public void onWifiVerboseLoggingStatusChanged(boolean var1);
    }

    private class SuggestionConnectionStatusListenerProxy
    extends ISuggestionConnectionStatusListener.Stub {
        private final Executor mExecutor;
        private final SuggestionConnectionStatusListener mListener;

        SuggestionConnectionStatusListenerProxy(@NonNull WifiManager wifiManager, @NonNull Executor executor, SuggestionConnectionStatusListener listener) {
            this.mExecutor = executor;
            this.mListener = listener;
        }

        @Override
        public void onConnectionStatus(@NonNull WifiNetworkSuggestion wifiNetworkSuggestion, int failureReason) {
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mListener.onConnectionStatus(wifiNetworkSuggestion, failureReason));
        }
    }

    public static interface SuggestionConnectionStatusListener {
        public void onConnectionStatus(@NonNull WifiNetworkSuggestion var1, int var2);
    }

    private static class LocalOnlyConnectionStatusListenerProxy
    extends ILocalOnlyConnectionStatusListener.Stub {
        private final Executor mExecutor;
        private final LocalOnlyConnectionFailureListener mListener;

        LocalOnlyConnectionStatusListenerProxy(@NonNull Executor executor, @NonNull LocalOnlyConnectionFailureListener listener) {
            this.mExecutor = executor;
            this.mListener = listener;
        }

        @Override
        public void onConnectionStatus(@NonNull WifiNetworkSpecifier networkSpecifier, int failureReason) {
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mListener.onConnectionFailed(networkSpecifier, failureReason));
        }
    }

    public static interface LocalOnlyConnectionFailureListener {
        public void onConnectionFailed(@NonNull WifiNetworkSpecifier var1, int var2);
    }

    private class PnoScanResultsCallbackProxy
    extends IPnoScanResultsCallback.Stub {
        private Executor mExecutor;
        private PnoScanResultsCallback mCallback;

        PnoScanResultsCallbackProxy(@NonNull Executor executor, PnoScanResultsCallback callback) {
            this.mExecutor = executor;
            this.mCallback = callback;
        }

        @Override
        public void onScanResultsAvailable(List<ScanResult> scanResults) {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "PnoScanResultsCallback: onScanResultsAvailable");
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onScanResultsAvailable(scanResults));
        }

        @Override
        public void onRegisterSuccess() {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "PnoScanResultsCallback: onRegisterSuccess");
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onRegisterSuccess());
        }

        @Override
        public void onRegisterFailed(int reason) {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "PnoScanResultsCallback: onRegisterFailed " + reason);
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onRegisterFailed(reason));
        }

        @Override
        public void onRemoved(int reason) {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "PnoScanResultsCallback: onRemoved");
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onRemoved(reason));
        }
    }

    @SystemApi
    public static interface PnoScanResultsCallback {
        public static final int REGISTER_PNO_CALLBACK_UNKNOWN = 0;
        public static final int REGISTER_PNO_CALLBACK_ALREADY_REGISTERED = 1;
        public static final int REGISTER_PNO_CALLBACK_RESOURCE_BUSY = 2;
        public static final int REGISTER_PNO_CALLBACK_PNO_NOT_SUPPORTED = 3;
        public static final int REMOVE_PNO_CALLBACK_UNKNOWN = 0;
        public static final int REMOVE_PNO_CALLBACK_RESULTS_DELIVERED = 1;
        public static final int REMOVE_PNO_CALLBACK_UNREGISTERED = 2;

        public void onScanResultsAvailable(@NonNull List<ScanResult> var1);

        public void onRegisterSuccess();

        public void onRegisterFailed(int var1);

        public void onRemoved(int var1);

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface RemovalReason {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface RegisterFailureReason {
        }
    }

    private class WifiConnectedNetworkScorerProxy
    extends IWifiConnectedNetworkScorer.Stub {
        private Executor mExecutor;
        private WifiConnectedNetworkScorer mScorer;

        WifiConnectedNetworkScorerProxy(Executor executor, WifiConnectedNetworkScorer scorer) {
            this.mExecutor = executor;
            this.mScorer = scorer;
        }

        @Override
        public void onStart(@NonNull WifiConnectedSessionInfo sessionInfo) {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "WifiConnectedNetworkScorer: onStart: sessionInfo=" + sessionInfo);
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mScorer.onStart(sessionInfo));
        }

        @Override
        public void onStop(int sessionId) {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "WifiConnectedNetworkScorer: onStop: sessionId=" + sessionId);
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mScorer.onStop(sessionId));
        }

        @Override
        public void onSetScoreUpdateObserver(IScoreUpdateObserver observerImpl) {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "WifiConnectedNetworkScorer: onSetScoreUpdateObserver: observerImpl=" + observerImpl);
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mScorer.onSetScoreUpdateObserver(new ScoreUpdateObserverProxy(WifiManager.this, observerImpl)));
        }

        @Override
        public void onNetworkSwitchAccepted(int sessionId, int targetNetworkId, @NonNull String targetBssid) {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "WifiConnectedNetworkScorer: onNetworkSwitchAccepted: sessionId=" + sessionId + " targetNetworkId=" + targetNetworkId + " targetBssid=" + targetBssid);
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mScorer.onNetworkSwitchAccepted(sessionId, targetNetworkId, targetBssid));
        }

        @Override
        public void onNetworkSwitchRejected(int sessionId, int targetNetworkId, @NonNull String targetBssid) {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "WifiConnectedNetworkScorer: onNetworkSwitchRejected: sessionId=" + sessionId + " targetNetworkId=" + targetNetworkId + " targetBssid=" + targetBssid);
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mScorer.onNetworkSwitchRejected(sessionId, targetNetworkId, targetBssid));
        }
    }

    @SystemApi
    public static interface WifiConnectedNetworkScorer {
        @Deprecated
        default public void onStart(int sessionId) {
        }

        default public void onStart(@NonNull WifiConnectedSessionInfo sessionInfo) {
            this.onStart(sessionInfo.getSessionId());
        }

        public void onStop(int var1);

        public void onSetScoreUpdateObserver(@NonNull ScoreUpdateObserver var1);

        default public void onNetworkSwitchAccepted(int sessionId, int targetNetworkId, @NonNull String targetBssid) {
        }

        default public void onNetworkSwitchRejected(int sessionId, int targetNetworkId, @NonNull String targetBssid) {
        }
    }

    private class SuggestionUserApprovalStatusListenerProxy
    extends ISuggestionUserApprovalStatusListener.Stub {
        private final Executor mExecutor;
        private final SuggestionUserApprovalStatusListener mListener;

        SuggestionUserApprovalStatusListenerProxy(@NonNull WifiManager wifiManager, @NonNull Executor executor, SuggestionUserApprovalStatusListener listener) {
            this.mExecutor = executor;
            this.mListener = listener;
        }

        @Override
        public void onUserApprovalStatusChange(int status) {
            this.mExecutor.execute(() -> this.mListener.onUserApprovalStatusChange(status));
        }
    }

    public static interface SuggestionUserApprovalStatusListener {
        public void onUserApprovalStatusChange(int var1);
    }

    private class TwtCallbackProxy
    extends ITwtCallback.Stub {
        private final Executor mExecutor;
        private final TwtSessionCallback mCallback;

        private TwtCallbackProxy(Executor executor, TwtSessionCallback callback) {
            this.mExecutor = executor;
            this.mCallback = callback;
        }

        @Override
        public void onFailure(int errorCode) throws RemoteException {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "TwtCallbackProxy: onFailure(errorCode = " + errorCode + " )");
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onFailure(errorCode));
        }

        @Override
        public void onTeardown(int reasonCode) throws RemoteException {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "TwtCallbackProxy: onTeardown(errorCode = " + reasonCode + " )");
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onTeardown(reasonCode));
        }

        @Override
        public void onCreate(int wakeDuration, long wakeInterval, int mloLinkId, int owner, int sessionId) throws RemoteException {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "TwtCallbackProxy: onCreate " + sessionId);
            }
            WifiTwtSession wifiTwtSession = new WifiTwtSession(WifiManager.this, wakeDuration, wakeInterval, mloLinkId, owner, sessionId);
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onCreate(wifiTwtSession));
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TwtCapabilities {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SendDhcpHostnameRestriction {
    }

    public static class InterfaceCreationImpact {
        private final int mInterfaceType;
        private final Set<String> mPackages;

        public InterfaceCreationImpact(int interfaceType, @NonNull Set<String> packages) {
            this.mInterfaceType = interfaceType;
            this.mPackages = packages;
        }

        public int getInterfaceType() {
            return this.mInterfaceType;
        }

        @NonNull
        public Set<String> getPackages() {
            return this.mPackages;
        }

        public int hashCode() {
            return Objects.hash(this.mInterfaceType, this.mPackages);
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (!(that instanceof InterfaceCreationImpact)) {
                return false;
            }
            InterfaceCreationImpact thatInterfaceCreationImpact = (InterfaceCreationImpact)that;
            return this.mInterfaceType == thatInterfaceCreationImpact.mInterfaceType && Objects.equals(this.mPackages, thatInterfaceCreationImpact.mPackages);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WifiInterfaceType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DialogReply {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DialogType {
    }

    private class ScoreUpdateObserverProxy
    implements ScoreUpdateObserver {
        private final IScoreUpdateObserver mScoreUpdateObserver;

        private ScoreUpdateObserverProxy(WifiManager wifiManager, IScoreUpdateObserver observer) {
            this.mScoreUpdateObserver = observer;
        }

        @Override
        public void notifyScoreUpdate(int sessionId, int score) {
            try {
                this.mScoreUpdateObserver.notifyScoreUpdate(sessionId, score);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        @Override
        public void triggerUpdateOfWifiUsabilityStats(int sessionId) {
            try {
                this.mScoreUpdateObserver.triggerUpdateOfWifiUsabilityStats(sessionId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        @Override
        public void notifyStatusUpdate(int sessionId, boolean isUsable) {
            if (!SdkLevel.isAtLeastS()) {
                throw new UnsupportedOperationException();
            }
            try {
                this.mScoreUpdateObserver.notifyStatusUpdate(sessionId, isUsable);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        @Override
        public void requestNudOperation(int sessionId) {
            if (!SdkLevel.isAtLeastS()) {
                throw new UnsupportedOperationException();
            }
            try {
                this.mScoreUpdateObserver.requestNudOperation(sessionId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        @Override
        public void blocklistCurrentBssid(int sessionId) {
            if (!SdkLevel.isAtLeastS()) {
                throw new UnsupportedOperationException();
            }
            try {
                this.mScoreUpdateObserver.blocklistCurrentBssid(sessionId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @SystemApi
    public static interface ScoreUpdateObserver {
        public void notifyScoreUpdate(int var1, int var2);

        public void triggerUpdateOfWifiUsabilityStats(int var1);

        @RequiresApi(value=31)
        default public void notifyStatusUpdate(int sessionId, boolean isUsable) {
        }

        @RequiresApi(value=31)
        default public void requestNudOperation(int sessionId) {
        }

        @RequiresApi(value=31)
        default public void blocklistCurrentBssid(int sessionId) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VerboseLoggingLevel {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EasyConnectCryptographyCurve {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EasyConnectNetworkRole {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeviceMobilityState {
    }

    public class LocalOnlyHotspotSubscription
    implements AutoCloseable {
        private final CloseGuard mCloseGuard = new CloseGuard();

        @VisibleForTesting
        public LocalOnlyHotspotSubscription() {
            this.mCloseGuard.open("close");
        }

        @Override
        public void close() {
            try {
                WifiManager.this.unregisterLocalOnlyHotspotObserver();
                this.mCloseGuard.close();
            }
            catch (Exception e) {
                Log.e(WifiManager.TAG, "Failed to unregister LocalOnlyHotspotObserver.");
            }
            finally {
                Reference.reachabilityFence(this);
            }
        }

        protected void finalize() throws Throwable {
            try {
                if (this.mCloseGuard != null) {
                    this.mCloseGuard.warnIfOpen();
                }
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }

    public class LocalOnlyHotspotReservation
    implements AutoCloseable {
        private final CloseGuard mCloseGuard = new CloseGuard();
        private final SoftApConfiguration mSoftApConfig;
        private final WifiConfiguration mWifiConfig;
        private boolean mClosed = false;

        @VisibleForTesting
        public LocalOnlyHotspotReservation(SoftApConfiguration config) {
            this.mSoftApConfig = config;
            this.mWifiConfig = config.toWifiConfiguration();
            this.mCloseGuard.open("close");
        }

        @Deprecated
        @Nullable
        public WifiConfiguration getWifiConfiguration() {
            return this.mWifiConfig;
        }

        @NonNull
        public SoftApConfiguration getSoftApConfiguration() {
            return this.mSoftApConfig;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            try {
                Object object = WifiManager.this.mLock;
                synchronized (object) {
                    if (!this.mClosed) {
                        this.mClosed = true;
                        WifiManager.this.stopLocalOnlyHotspot();
                        this.mCloseGuard.close();
                    }
                }
            }
            catch (Exception e) {
                Log.e(WifiManager.TAG, "Failed to stop Local Only Hotspot.");
            }
            finally {
                Reference.reachabilityFence(this);
            }
        }

        protected void finalize() throws Throwable {
            try {
                if (this.mCloseGuard != null) {
                    this.mCloseGuard.warnIfOpen();
                }
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ActionListenerFailureReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RequiresApi(value=31)
    public static @interface CoexRestriction {
    }

    private class NetworkRequestUserSelectionCallbackProxy
    implements NetworkRequestUserSelectionCallback {
        private final INetworkRequestUserSelectionCallback mCallback;

        NetworkRequestUserSelectionCallbackProxy(INetworkRequestUserSelectionCallback callback) {
            this.mCallback = callback;
        }

        @Override
        public void select(@NonNull WifiConfiguration wifiConfiguration) {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "NetworkRequestUserSelectionCallbackProxy: select wificonfiguration: " + wifiConfiguration);
            }
            try {
                this.mCallback.select(wifiConfiguration);
            }
            catch (RemoteException e) {
                Log.e(WifiManager.TAG, "Failed to invoke onSelected", e);
                throw e.rethrowFromSystemServer();
            }
        }

        @Override
        public void reject() {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "NetworkRequestUserSelectionCallbackProxy: reject");
            }
            try {
                this.mCallback.reject();
            }
            catch (RemoteException e) {
                Log.e(WifiManager.TAG, "Failed to invoke onRejected", e);
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @SystemApi
    public static interface NetworkRequestUserSelectionCallback {
        @SuppressLint(value={"CallbackMethodName"})
        default public void select(@NonNull WifiConfiguration wifiConfiguration) {
        }

        @SuppressLint(value={"CallbackMethodName"})
        default public void reject() {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RoamingMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MloMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface QosRequestStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WifiMultiInternetMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IfaceIpMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SapClientBlockedReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SapStartFailure {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WifiApState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WifiState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ApiType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ActionAfterRemovingSuggestion {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PnoScanState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SuggestionUserApprovalStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LocalOnlyConnectionStatusCode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SuggestionConnectionStatusCode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NetworkSuggestionsStatusCode {
    }
}

