/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.app.compat.CompatChanges;
import android.net.MacAddress;
import android.net.wifi.OuiKeyedData;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiManager;
import android.net.wifi.WifiSsid;
import android.net.wifi.util.Environment;
import android.net.wifi.util.HexEncoding;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseIntArray;
import com.android.layoutlib.androidx.annotation.Keep;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import com.android.layoutlib.androidx.annotation.VisibleForTesting;
import com.android.wifi.x.com.android.internal.util.Preconditions;
import com.android.wifi.x.com.android.modules.utils.build.SdkLevel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class SoftApConfiguration
implements Parcelable {
    private static final String TAG = "SoftApConfiguration";
    @VisibleForTesting
    static final int PSK_MIN_LEN = 8;
    @VisibleForTesting
    static final int PSK_MAX_LEN = 63;
    @FlaggedApi(value="com.android.wifi.flags.public_bands_for_lohs")
    public static final int BAND_2GHZ = 1;
    @FlaggedApi(value="com.android.wifi.flags.public_bands_for_lohs")
    public static final int BAND_5GHZ = 2;
    @FlaggedApi(value="com.android.wifi.flags.public_bands_for_lohs")
    public static final int BAND_6GHZ = 4;
    @FlaggedApi(value="com.android.wifi.flags.public_bands_for_lohs")
    public static final int BAND_60GHZ = 8;
    @SystemApi
    public static final int BAND_ANY = 7;
    @SystemApi
    public static final long DEFAULT_TIMEOUT = -1L;
    public static int[] BAND_TYPES = new int[]{1, 2, 4, 8};
    private static final int MIN_CH_2G_BAND = 1;
    private static final int MAX_CH_2G_BAND = 14;
    private static final int MIN_CH_5G_BAND = 34;
    private static final int MAX_CH_5G_BAND = 196;
    private static final int MIN_CH_6G_BAND = 1;
    private static final int MAX_CH_6G_BAND = 253;
    private static final int MIN_CH_60G_BAND = 1;
    private static final int MAX_CH_60G_BAND = 6;
    private static final long FORCE_MUTUAL_EXCLUSIVE_BSSID_MAC_RAMDONIZATION_SETTING = 215656264L;
    public static final long REMOVE_ZERO_FOR_TIMEOUT_SETTING = 213289672L;
    @Nullable
    private final WifiSsid mWifiSsid;
    @Nullable
    private final MacAddress mBssid;
    @NonNull
    private final List<ScanResult.InformationElement> mVendorElements;
    @Nullable
    private final String mPassphrase;
    private final boolean mHiddenSsid;
    @NonNull
    private final SparseIntArray mChannels;
    @NonNull
    private final Set<Integer> mAllowedAcsChannels2g;
    @NonNull
    private final Set<Integer> mAllowedAcsChannels5g;
    @NonNull
    private final Set<Integer> mAllowedAcsChannels6g;
    private final int mMaxChannelBandwidth;
    private final int mMaxNumberOfClients;
    private final int mSecurityType;
    private final boolean mClientControlByUser;
    private final List<MacAddress> mBlockedClientList;
    private final List<MacAddress> mAllowedClientList;
    private final boolean mAutoShutdownEnabled;
    private final long mShutdownTimeoutMillis;
    @SystemApi
    public static final int RANDOMIZATION_NONE = 0;
    @SystemApi
    public static final int RANDOMIZATION_PERSISTENT = 1;
    @SystemApi
    public static final int RANDOMIZATION_NON_PERSISTENT = 2;
    private int mMacRandomizationSetting;
    private boolean mBridgedModeOpportunisticShutdownEnabled;
    private boolean mIeee80211axEnabled;
    private boolean mIeee80211beEnabled;
    private boolean mIsUserConfiguration;
    @Nullable
    private final MacAddress mPersistentRandomizedMacAddress;
    private final long mBridgedModeOpportunisticShutdownTimeoutMillis;
    @NonNull
    private List<OuiKeyedData> mVendorData;
    private boolean mIsClientIsolationEnabled;
    public static final int SECURITY_TYPE_OPEN = 0;
    public static final int SECURITY_TYPE_WPA2_PSK = 1;
    public static final int SECURITY_TYPE_WPA3_SAE_TRANSITION = 2;
    public static final int SECURITY_TYPE_WPA3_SAE = 3;
    public static final int SECURITY_TYPE_WPA3_OWE_TRANSITION = 4;
    public static final int SECURITY_TYPE_WPA3_OWE = 5;
    @NonNull
    public static final Parcelable.Creator<SoftApConfiguration> CREATOR = new Parcelable.Creator<SoftApConfiguration>(){

        @Override
        public SoftApConfiguration createFromParcel(Parcel in) {
            return new SoftApConfiguration((WifiSsid)in.readParcelable(WifiSsid.class.getClassLoader()), (MacAddress)in.readParcelable(MacAddress.class.getClassLoader()), in.readString(), in.readBoolean(), SoftApConfiguration.readSparseIntArray(in), in.readInt(), in.readInt(), in.readBoolean(), in.readLong(), in.readBoolean(), in.createTypedArrayList(MacAddress.CREATOR), in.createTypedArrayList(MacAddress.CREATOR), in.readInt(), in.readBoolean(), in.readBoolean(), in.readBoolean(), in.readBoolean(), in.readLong(), in.createTypedArrayList(ScanResult.InformationElement.CREATOR), (MacAddress)in.readParcelable(MacAddress.class.getClassLoader()), SoftApConfiguration.readHashSetInt(in), SoftApConfiguration.readHashSetInt(in), SoftApConfiguration.readHashSetInt(in), in.readInt(), SoftApConfiguration.readOuiKeyedDataList(in), in.readBoolean());
        }

        public SoftApConfiguration[] newArray(int size) {
            return new SoftApConfiguration[size];
        }
    };

    private static boolean isBandValid(int band) {
        int bandAny = 15;
        return band != 0 && (band & ~bandAny) == 0;
    }

    private static boolean isChannelBandPairValid(int channel, int band) {
        switch (band) {
            case 1: {
                if (channel >= 1 && channel <= 14) break;
                return false;
            }
            case 2: {
                if (channel >= 34 && channel <= 196) break;
                return false;
            }
            case 4: {
                if (channel >= 1 && channel <= 253) break;
                return false;
            }
            case 8: {
                if (channel >= 1 && channel <= 6) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private SoftApConfiguration(@Nullable WifiSsid ssid, @Nullable MacAddress bssid, @Nullable String passphrase, boolean hiddenSsid, @NonNull SparseIntArray channels, int securityType, int maxNumberOfClients, boolean shutdownTimeoutEnabled, long shutdownTimeoutMillis, boolean clientControlByUser, @NonNull List<MacAddress> blockedList, @NonNull List<MacAddress> allowedList, int macRandomizationSetting, boolean bridgedModeOpportunisticShutdownEnabled, boolean ieee80211axEnabled, boolean ieee80211beEnabled, boolean isUserConfiguration, long bridgedModeOpportunisticShutdownTimeoutMillis, @NonNull List<ScanResult.InformationElement> vendorElements, @Nullable MacAddress persistentRandomizedMacAddress, @NonNull Set<Integer> allowedAcsChannels24g, @NonNull Set<Integer> allowedAcsChannels5g, @NonNull Set<Integer> allowedAcsChannels6g, int maxChannelBandwidth, @Nullable List<OuiKeyedData> vendorData, boolean isClientIsolationEnabled) {
        this.mWifiSsid = ssid;
        this.mBssid = bssid;
        this.mPassphrase = passphrase;
        this.mHiddenSsid = hiddenSsid;
        if (channels.size() != 0) {
            this.mChannels = channels.clone();
        } else {
            this.mChannels = new SparseIntArray(1);
            this.mChannels.put(1, 0);
        }
        this.mSecurityType = securityType;
        this.mMaxNumberOfClients = maxNumberOfClients;
        this.mAutoShutdownEnabled = shutdownTimeoutEnabled;
        this.mShutdownTimeoutMillis = shutdownTimeoutMillis;
        this.mClientControlByUser = clientControlByUser;
        this.mBlockedClientList = new ArrayList<MacAddress>(blockedList);
        this.mAllowedClientList = new ArrayList<MacAddress>(allowedList);
        this.mMacRandomizationSetting = macRandomizationSetting;
        this.mBridgedModeOpportunisticShutdownEnabled = bridgedModeOpportunisticShutdownEnabled;
        this.mIeee80211axEnabled = ieee80211axEnabled;
        this.mIeee80211beEnabled = ieee80211beEnabled;
        this.mIsUserConfiguration = isUserConfiguration;
        this.mBridgedModeOpportunisticShutdownTimeoutMillis = bridgedModeOpportunisticShutdownTimeoutMillis;
        this.mVendorElements = new ArrayList<ScanResult.InformationElement>(vendorElements);
        this.mPersistentRandomizedMacAddress = persistentRandomizedMacAddress;
        this.mAllowedAcsChannels2g = new HashSet<Integer>(allowedAcsChannels24g);
        this.mAllowedAcsChannels5g = new HashSet<Integer>(allowedAcsChannels5g);
        this.mAllowedAcsChannels6g = new HashSet<Integer>(allowedAcsChannels6g);
        this.mMaxChannelBandwidth = maxChannelBandwidth;
        this.mVendorData = new ArrayList<OuiKeyedData>(vendorData);
        this.mIsClientIsolationEnabled = isClientIsolationEnabled;
    }

    public boolean equals(Object otherObj) {
        if (this == otherObj) {
            return true;
        }
        if (!(otherObj instanceof SoftApConfiguration)) {
            return false;
        }
        SoftApConfiguration other = (SoftApConfiguration)otherObj;
        return Objects.equals(this.mWifiSsid, other.mWifiSsid) && Objects.equals(this.mBssid, other.mBssid) && Objects.equals(this.mPassphrase, other.mPassphrase) && this.mHiddenSsid == other.mHiddenSsid && ((Object)this.mChannels).toString().equals(((Object)other.mChannels).toString()) && this.mSecurityType == other.mSecurityType && this.mMaxNumberOfClients == other.mMaxNumberOfClients && this.mAutoShutdownEnabled == other.mAutoShutdownEnabled && this.mShutdownTimeoutMillis == other.mShutdownTimeoutMillis && this.mClientControlByUser == other.mClientControlByUser && Objects.equals(this.mBlockedClientList, other.mBlockedClientList) && Objects.equals(this.mAllowedClientList, other.mAllowedClientList) && this.mMacRandomizationSetting == other.mMacRandomizationSetting && this.mBridgedModeOpportunisticShutdownEnabled == other.mBridgedModeOpportunisticShutdownEnabled && this.mIeee80211axEnabled == other.mIeee80211axEnabled && this.mIeee80211beEnabled == other.mIeee80211beEnabled && this.mIsUserConfiguration == other.mIsUserConfiguration && this.mBridgedModeOpportunisticShutdownTimeoutMillis == other.mBridgedModeOpportunisticShutdownTimeoutMillis && Objects.equals(this.mVendorElements, other.mVendorElements) && Objects.equals(this.mPersistentRandomizedMacAddress, other.mPersistentRandomizedMacAddress) && Objects.equals(this.mAllowedAcsChannels2g, other.mAllowedAcsChannels2g) && Objects.equals(this.mAllowedAcsChannels5g, other.mAllowedAcsChannels5g) && Objects.equals(this.mAllowedAcsChannels6g, other.mAllowedAcsChannels6g) && this.mMaxChannelBandwidth == other.mMaxChannelBandwidth && Objects.equals(this.mVendorData, other.mVendorData) && this.mIsClientIsolationEnabled == other.mIsClientIsolationEnabled;
    }

    public int hashCode() {
        return Objects.hash(this.mWifiSsid, this.mBssid, this.mPassphrase, this.mHiddenSsid, ((Object)this.mChannels).toString(), this.mSecurityType, this.mMaxNumberOfClients, this.mAutoShutdownEnabled, this.mShutdownTimeoutMillis, this.mClientControlByUser, this.mBlockedClientList, this.mAllowedClientList, this.mMacRandomizationSetting, this.mBridgedModeOpportunisticShutdownEnabled, this.mIeee80211axEnabled, this.mIeee80211beEnabled, this.mIsUserConfiguration, this.mBridgedModeOpportunisticShutdownTimeoutMillis, this.mVendorElements, this.mPersistentRandomizedMacAddress, this.mAllowedAcsChannels2g, this.mAllowedAcsChannels5g, this.mAllowedAcsChannels6g, this.mMaxChannelBandwidth, this.mVendorData, this.mIsClientIsolationEnabled);
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("ssid = ").append(this.mWifiSsid == null ? null : this.mWifiSsid.toString());
        if (this.mBssid != null) {
            sbuf.append(" \n bssid = ").append(((Object)this.mBssid).toString());
        }
        sbuf.append(" \n Passphrase = ").append(TextUtils.isEmpty(this.mPassphrase) ? "<empty>" : "<non-empty>");
        sbuf.append(" \n HiddenSsid = ").append(this.mHiddenSsid);
        sbuf.append(" \n Channels = ").append(this.mChannels);
        sbuf.append(" \n SecurityType = ").append(this.getSecurityType());
        sbuf.append(" \n MaxClient = ").append(this.mMaxNumberOfClients);
        sbuf.append(" \n AutoShutdownEnabled = ").append(this.mAutoShutdownEnabled);
        sbuf.append(" \n ShutdownTimeoutMillis = ").append(this.mShutdownTimeoutMillis);
        sbuf.append(" \n ClientControlByUser = ").append(this.mClientControlByUser);
        sbuf.append(" \n BlockedClientList = ").append(this.mBlockedClientList);
        sbuf.append(" \n AllowedClientList= ").append(this.mAllowedClientList);
        sbuf.append(" \n MacRandomizationSetting = ").append(this.mMacRandomizationSetting);
        sbuf.append(" \n BridgedModeInstanceOpportunisticEnabled = ").append(this.mBridgedModeOpportunisticShutdownEnabled);
        sbuf.append(" \n BridgedModeOpportunisticShutdownTimeoutMillis = ").append(this.mBridgedModeOpportunisticShutdownTimeoutMillis);
        sbuf.append(" \n Ieee80211axEnabled = ").append(this.mIeee80211axEnabled);
        sbuf.append(" \n Ieee80211beEnabled = ").append(this.mIeee80211beEnabled);
        sbuf.append(" \n isUserConfiguration = ").append(this.mIsUserConfiguration);
        sbuf.append(" \n vendorElements = ").append(this.mVendorElements);
        sbuf.append(" \n mPersistentRandomizedMacAddress = ").append(this.mPersistentRandomizedMacAddress);
        sbuf.append(" \n mAllowedAcsChannels2g = ").append(this.mAllowedAcsChannels2g);
        sbuf.append(" \n mAllowedAcsChannels5g = ").append(this.mAllowedAcsChannels5g);
        sbuf.append(" \n mAllowedAcsChannels6g = ").append(this.mAllowedAcsChannels6g);
        sbuf.append(" \n mMaxChannelBandwidth = ").append(this.mMaxChannelBandwidth);
        sbuf.append(" \n mVendorData = ").append(this.mVendorData);
        sbuf.append(" \n mIsClientIsolationEnabled = ").append(this.mIsClientIsolationEnabled);
        return sbuf.toString();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeParcelable(this.mWifiSsid, 0);
        dest.writeParcelable(this.mBssid, flags);
        dest.writeString(this.mPassphrase);
        dest.writeBoolean(this.mHiddenSsid);
        SoftApConfiguration.writeSparseIntArray(dest, this.mChannels);
        dest.writeInt(this.mSecurityType);
        dest.writeInt(this.mMaxNumberOfClients);
        dest.writeBoolean(this.mAutoShutdownEnabled);
        dest.writeLong(this.mShutdownTimeoutMillis);
        dest.writeBoolean(this.mClientControlByUser);
        dest.writeTypedList(this.mBlockedClientList);
        dest.writeTypedList(this.mAllowedClientList);
        dest.writeInt(this.mMacRandomizationSetting);
        dest.writeBoolean(this.mBridgedModeOpportunisticShutdownEnabled);
        dest.writeBoolean(this.mIeee80211axEnabled);
        dest.writeBoolean(this.mIeee80211beEnabled);
        dest.writeBoolean(this.mIsUserConfiguration);
        dest.writeLong(this.mBridgedModeOpportunisticShutdownTimeoutMillis);
        dest.writeTypedList(this.mVendorElements);
        dest.writeParcelable(this.mPersistentRandomizedMacAddress, flags);
        SoftApConfiguration.writeHashSetInt(dest, this.mAllowedAcsChannels2g);
        SoftApConfiguration.writeHashSetInt(dest, this.mAllowedAcsChannels5g);
        SoftApConfiguration.writeHashSetInt(dest, this.mAllowedAcsChannels6g);
        dest.writeInt(this.mMaxChannelBandwidth);
        dest.writeList(this.mVendorData);
        dest.writeBoolean(this.mIsClientIsolationEnabled);
    }

    private static void writeSparseIntArray(@NonNull Parcel dest, @Nullable SparseIntArray val) {
        if (val == null) {
            dest.writeInt(-1);
            return;
        }
        int n = val.size();
        dest.writeInt(n);
        for (int i = 0; i < n; ++i) {
            dest.writeInt(val.keyAt(i));
            dest.writeInt(val.valueAt(i));
        }
    }

    @NonNull
    private static SparseIntArray readSparseIntArray(@NonNull Parcel in) {
        int n = in.readInt();
        if (n < 0) {
            return new SparseIntArray();
        }
        SparseIntArray sa = new SparseIntArray(n);
        while (n > 0) {
            int key = in.readInt();
            int value = in.readInt();
            sa.append(key, value);
            --n;
        }
        return sa;
    }

    private static void writeHashSetInt(@NonNull Parcel dest, @NonNull Set<Integer> set) {
        if (set.isEmpty()) {
            dest.writeInt(-1);
            return;
        }
        dest.writeInt(set.size());
        for (int val : set) {
            dest.writeInt(val);
        }
    }

    @NonNull
    private static Set<Integer> readHashSetInt(@NonNull Parcel in) {
        HashSet<Integer> set = new HashSet<Integer>();
        int len = in.readInt();
        if (len < 0) {
            return set;
        }
        for (int i = 0; i < len; ++i) {
            set.add(in.readInt());
        }
        return set;
    }

    @NonNull
    private static List<OuiKeyedData> readOuiKeyedDataList(@NonNull Parcel in) {
        ArrayList<OuiKeyedData> dataList = new ArrayList<OuiKeyedData>();
        if (SdkLevel.isAtLeastT()) {
            in.readList(dataList, OuiKeyedData.class.getClassLoader(), OuiKeyedData.class);
        } else {
            in.readList(dataList, OuiKeyedData.class.getClassLoader());
        }
        return dataList;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Deprecated
    @Nullable
    public String getSsid() {
        if (this.mWifiSsid == null) {
            return null;
        }
        CharSequence utf8Text = this.mWifiSsid.getUtf8Text();
        return utf8Text != null ? utf8Text.toString() : "<unknown ssid>";
    }

    @Nullable
    public WifiSsid getWifiSsid() {
        return this.mWifiSsid;
    }

    @SystemApi
    @NonNull
    @RequiresApi(value=33)
    public List<ScanResult.InformationElement> getVendorElements() {
        if (!SdkLevel.isAtLeastT()) {
            throw new UnsupportedOperationException();
        }
        return this.getVendorElementsInternal();
    }

    public List<ScanResult.InformationElement> getVendorElementsInternal() {
        return new ArrayList<ScanResult.InformationElement>(this.mVendorElements);
    }

    @Nullable
    public MacAddress getBssid() {
        return this.mBssid;
    }

    @Nullable
    public String getPassphrase() {
        return this.mPassphrase;
    }

    public boolean isHiddenSsid() {
        return this.mHiddenSsid;
    }

    @Deprecated
    @SystemApi
    public int getBand() {
        return this.mChannels.keyAt(0);
    }

    @Keep
    @NonNull
    public int[] getBands() {
        int[] bands = new int[this.mChannels.size()];
        for (int i = 0; i < bands.length; ++i) {
            bands[i] = this.mChannels.keyAt(i);
        }
        return bands;
    }

    @Deprecated
    @SystemApi
    public int getChannel() {
        return this.mChannels.valueAt(0);
    }

    @FlaggedApi(value="com.android.wifi.flags.public_bands_for_lohs")
    @RequiresApi(value=31)
    @NonNull
    public SparseIntArray getChannels() {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        return this.mChannels.clone();
    }

    public int getSecurityType() {
        return this.mSecurityType;
    }

    @SystemApi
    public int getMaxNumberOfClients() {
        return this.mMaxNumberOfClients;
    }

    @SystemApi
    public boolean isAutoShutdownEnabled() {
        return this.mAutoShutdownEnabled;
    }

    @SystemApi
    public long getShutdownTimeoutMillis() {
        if (!CompatChanges.isChangeEnabled(213289672L) && this.mShutdownTimeoutMillis == -1L) {
            return 0L;
        }
        return this.mShutdownTimeoutMillis;
    }

    @SystemApi
    public boolean isClientControlByUserEnabled() {
        return this.mClientControlByUser;
    }

    @SystemApi
    @NonNull
    public List<MacAddress> getBlockedClientList() {
        return this.mBlockedClientList;
    }

    @SystemApi
    @NonNull
    public List<MacAddress> getAllowedClientList() {
        return this.mAllowedClientList;
    }

    @SystemApi
    @RequiresApi(value=31)
    public int getMacRandomizationSetting() {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        return this.getMacRandomizationSettingInternal();
    }

    public int getMacRandomizationSettingInternal() {
        return this.mMacRandomizationSetting;
    }

    @SystemApi
    @RequiresApi(value=31)
    public boolean isBridgedModeOpportunisticShutdownEnabled() {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        return this.isBridgedModeOpportunisticShutdownEnabledInternal();
    }

    public boolean isBridgedModeOpportunisticShutdownEnabledInternal() {
        return this.mBridgedModeOpportunisticShutdownEnabled;
    }

    public boolean isIeee80211axEnabledInternal() {
        return this.mIeee80211axEnabled;
    }

    @SystemApi
    @RequiresApi(value=31)
    public boolean isIeee80211axEnabled() {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        return this.isIeee80211axEnabledInternal();
    }

    @SystemApi
    @RequiresApi(value=33)
    public boolean isIeee80211beEnabled() {
        if (!SdkLevel.isAtLeastT()) {
            throw new UnsupportedOperationException();
        }
        return this.mIeee80211beEnabled;
    }

    @SystemApi
    @RequiresApi(value=33)
    @NonNull
    public int[] getAllowedAcsChannels(int band) {
        if (!SdkLevel.isAtLeastT()) {
            throw new UnsupportedOperationException();
        }
        switch (band) {
            case 1: {
                return this.mAllowedAcsChannels2g.stream().mapToInt(Integer::intValue).toArray();
            }
            case 2: {
                return this.mAllowedAcsChannels5g.stream().mapToInt(Integer::intValue).toArray();
            }
            case 4: {
                return this.mAllowedAcsChannels6g.stream().mapToInt(Integer::intValue).toArray();
            }
        }
        throw new IllegalArgumentException("getAllowedAcsChannels: Invalid band: " + band);
    }

    @SystemApi
    @RequiresApi(value=33)
    public int getMaxChannelBandwidth() {
        if (!SdkLevel.isAtLeastT()) {
            throw new UnsupportedOperationException();
        }
        return this.mMaxChannelBandwidth;
    }

    @SystemApi
    @RequiresApi(value=31)
    public boolean isUserConfiguration() {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        return this.isUserConfigurationInternal();
    }

    @SystemApi
    @NonNull
    public MacAddress getPersistentRandomizedMacAddress() {
        return this.mPersistentRandomizedMacAddress;
    }

    public boolean isUserConfigurationInternal() {
        return this.mIsUserConfiguration;
    }

    @SystemApi
    @RequiresApi(value=33)
    public long getBridgedModeOpportunisticShutdownTimeoutMillis() {
        if (!SdkLevel.isAtLeastT()) {
            throw new UnsupportedOperationException();
        }
        return this.mBridgedModeOpportunisticShutdownTimeoutMillis;
    }

    public long getBridgedModeOpportunisticShutdownTimeoutMillisInternal() {
        return this.mBridgedModeOpportunisticShutdownTimeoutMillis;
    }

    @SystemApi
    @RequiresApi(value=35)
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @NonNull
    public List<OuiKeyedData> getVendorData() {
        if (!SdkLevel.isAtLeastV()) {
            throw new UnsupportedOperationException();
        }
        return this.mVendorData;
    }

    @SystemApi
    @RequiresApi(value=36)
    @FlaggedApi(value="com.android.wifi.flags.ap_isolate")
    public boolean isClientIsolationEnabled() {
        if (!Environment.isSdkAtLeastB()) {
            throw new UnsupportedOperationException();
        }
        return this.mIsClientIsolationEnabled;
    }

    @SystemApi
    @Nullable
    public WifiConfiguration toWifiConfiguration() {
        WifiConfiguration wifiConfig = new WifiConfiguration();
        CharSequence utf8Text = this.mWifiSsid != null ? this.mWifiSsid.getUtf8Text() : null;
        wifiConfig.SSID = utf8Text != null ? utf8Text.toString() : "<unknown ssid>";
        wifiConfig.preSharedKey = this.mPassphrase;
        wifiConfig.hiddenSSID = this.mHiddenSsid;
        wifiConfig.apChannel = this.getChannel();
        switch (this.mSecurityType) {
            case 0: {
                wifiConfig.allowedKeyManagement.set(0);
                break;
            }
            case 1: 
            case 2: {
                wifiConfig.allowedKeyManagement.set(4);
                break;
            }
            default: {
                Log.e(TAG, "Convert fail, unsupported security type :" + this.mSecurityType);
                return null;
            }
        }
        switch (this.getBand()) {
            case 1: {
                wifiConfig.apBand = 0;
                break;
            }
            case 2: {
                wifiConfig.apBand = 1;
                break;
            }
            case 3: {
                wifiConfig.apBand = -1;
                break;
            }
            case 7: {
                wifiConfig.apBand = -1;
                break;
            }
            default: {
                Log.e(TAG, "Convert fail, unsupported band setting :" + this.getBand());
                return null;
            }
        }
        return wifiConfig;
    }

    @FlaggedApi(value="com.android.wifi.flags.public_bands_for_lohs")
    public static class Builder {
        private WifiSsid mWifiSsid;
        private MacAddress mBssid;
        private String mPassphrase;
        private boolean mHiddenSsid;
        private SparseIntArray mChannels;
        private int mMaxNumberOfClients;
        private int mSecurityType;
        private boolean mAutoShutdownEnabled;
        private long mShutdownTimeoutMillis;
        private boolean mClientControlByUser;
        private List<MacAddress> mBlockedClientList;
        private List<MacAddress> mAllowedClientList;
        private int mMacRandomizationSetting;
        private boolean mBridgedModeOpportunisticShutdownEnabled;
        private boolean mIeee80211axEnabled;
        private boolean mIeee80211beEnabled;
        private boolean mIsUserConfiguration;
        private long mBridgedModeOpportunisticShutdownTimeoutMillis;
        private List<ScanResult.InformationElement> mVendorElements;
        private MacAddress mPersistentRandomizedMacAddress;
        private Set<Integer> mAllowedAcsChannels2g;
        private Set<Integer> mAllowedAcsChannels5g;
        private Set<Integer> mAllowedAcsChannels6g;
        private int mMaxChannelBandwidth;
        @Nullable
        private List<OuiKeyedData> mVendorData;
        private boolean mIsClientIsolationEnabled;

        public Builder() {
            this.mWifiSsid = null;
            this.mBssid = null;
            this.mPassphrase = null;
            this.mHiddenSsid = false;
            this.mChannels = new SparseIntArray(1);
            this.mChannels.put(1, 0);
            this.mMaxNumberOfClients = 0;
            this.mSecurityType = 0;
            this.mAutoShutdownEnabled = true;
            this.mShutdownTimeoutMillis = -1L;
            this.mClientControlByUser = false;
            this.mBlockedClientList = new ArrayList<MacAddress>();
            this.mAllowedClientList = new ArrayList<MacAddress>();
            this.mMacRandomizationSetting = SdkLevel.isAtLeastT() ? 2 : 1;
            this.mBridgedModeOpportunisticShutdownEnabled = true;
            this.mIeee80211axEnabled = true;
            this.mIeee80211beEnabled = true;
            this.mIsUserConfiguration = true;
            this.mBridgedModeOpportunisticShutdownTimeoutMillis = -1L;
            this.mVendorElements = new ArrayList<ScanResult.InformationElement>();
            this.mPersistentRandomizedMacAddress = null;
            this.mAllowedAcsChannels2g = new HashSet<Integer>();
            this.mAllowedAcsChannels5g = new HashSet<Integer>();
            this.mAllowedAcsChannels6g = new HashSet<Integer>();
            this.mMaxChannelBandwidth = -1;
            this.mVendorData = new ArrayList<OuiKeyedData>();
            this.mIsClientIsolationEnabled = false;
        }

        @SystemApi
        public Builder(@NonNull SoftApConfiguration other) {
            if (other == null) {
                Log.e(SoftApConfiguration.TAG, "Cannot provide a null SoftApConfiguration");
                return;
            }
            this.mWifiSsid = other.mWifiSsid;
            this.mBssid = other.mBssid;
            this.mPassphrase = other.mPassphrase;
            this.mHiddenSsid = other.mHiddenSsid;
            this.mChannels = other.mChannels.clone();
            this.mMaxNumberOfClients = other.mMaxNumberOfClients;
            this.mSecurityType = other.mSecurityType;
            this.mAutoShutdownEnabled = other.mAutoShutdownEnabled;
            this.mShutdownTimeoutMillis = other.mShutdownTimeoutMillis;
            this.mClientControlByUser = other.mClientControlByUser;
            this.mBlockedClientList = new ArrayList<MacAddress>(other.mBlockedClientList);
            this.mAllowedClientList = new ArrayList<MacAddress>(other.mAllowedClientList);
            this.mMacRandomizationSetting = other.mMacRandomizationSetting;
            this.mBridgedModeOpportunisticShutdownEnabled = other.mBridgedModeOpportunisticShutdownEnabled;
            this.mIeee80211axEnabled = other.mIeee80211axEnabled;
            this.mIeee80211beEnabled = other.mIeee80211beEnabled;
            this.mIsUserConfiguration = other.mIsUserConfiguration;
            this.mBridgedModeOpportunisticShutdownTimeoutMillis = other.mBridgedModeOpportunisticShutdownTimeoutMillis;
            this.mVendorElements = new ArrayList<ScanResult.InformationElement>(other.mVendorElements);
            this.mPersistentRandomizedMacAddress = other.mPersistentRandomizedMacAddress;
            this.mAllowedAcsChannels2g = new HashSet<Integer>(other.mAllowedAcsChannels2g);
            this.mAllowedAcsChannels5g = new HashSet<Integer>(other.mAllowedAcsChannels5g);
            this.mAllowedAcsChannels6g = new HashSet<Integer>(other.mAllowedAcsChannels6g);
            this.mMaxChannelBandwidth = other.mMaxChannelBandwidth;
            if (SdkLevel.isAtLeastS() && this.mBssid != null) {
                this.mMacRandomizationSetting = 0;
            }
            this.mVendorData = new ArrayList<OuiKeyedData>(other.mVendorData);
            this.mIsClientIsolationEnabled = other.mIsClientIsolationEnabled;
        }

        @VisibleForTesting
        @NonNull
        public SoftApConfiguration buildWithoutCheck() {
            return new SoftApConfiguration(this.mWifiSsid, this.mBssid, this.mPassphrase, this.mHiddenSsid, this.mChannels, this.mSecurityType, this.mMaxNumberOfClients, this.mAutoShutdownEnabled, this.mShutdownTimeoutMillis, this.mClientControlByUser, this.mBlockedClientList, this.mAllowedClientList, this.mMacRandomizationSetting, this.mBridgedModeOpportunisticShutdownEnabled, this.mIeee80211axEnabled, this.mIeee80211beEnabled, this.mIsUserConfiguration, this.mBridgedModeOpportunisticShutdownTimeoutMillis, this.mVendorElements, this.mPersistentRandomizedMacAddress, this.mAllowedAcsChannels2g, this.mAllowedAcsChannels5g, this.mAllowedAcsChannels6g, this.mMaxChannelBandwidth, this.mVendorData, this.mIsClientIsolationEnabled);
        }

        @NonNull
        public SoftApConfiguration build() {
            for (MacAddress client : this.mAllowedClientList) {
                if (!this.mBlockedClientList.contains(client)) continue;
                throw new IllegalArgumentException("A MacAddress exist in both client list");
            }
            if (SdkLevel.isAtLeastS() && CompatChanges.isChangeEnabled(215656264L) && this.mBssid != null && this.mMacRandomizationSetting != 0) {
                throw new IllegalArgumentException("A BSSID had configured but MAC randomization setting is not NONE");
            }
            if (!CompatChanges.isChangeEnabled(213289672L) && this.mShutdownTimeoutMillis == -1L) {
                this.mShutdownTimeoutMillis = 0L;
            }
            if (SdkLevel.isAtLeastB() && !this.mIeee80211axEnabled) {
                this.mIeee80211beEnabled = false;
            }
            return new SoftApConfiguration(this.mWifiSsid, this.mBssid, this.mPassphrase, this.mHiddenSsid, this.mChannels, this.mSecurityType, this.mMaxNumberOfClients, this.mAutoShutdownEnabled, this.mShutdownTimeoutMillis, this.mClientControlByUser, this.mBlockedClientList, this.mAllowedClientList, this.mMacRandomizationSetting, this.mBridgedModeOpportunisticShutdownEnabled, this.mIeee80211axEnabled, this.mIeee80211beEnabled, this.mIsUserConfiguration, this.mBridgedModeOpportunisticShutdownTimeoutMillis, this.mVendorElements, this.mPersistentRandomizedMacAddress, this.mAllowedAcsChannels2g, this.mAllowedAcsChannels5g, this.mAllowedAcsChannels6g, this.mMaxChannelBandwidth, this.mVendorData, this.mIsClientIsolationEnabled);
        }

        @Deprecated
        @SystemApi
        @NonNull
        public Builder setSsid(@Nullable String ssid) {
            if (ssid == null) {
                this.mWifiSsid = null;
                return this;
            }
            Preconditions.checkStringNotEmpty(ssid);
            Preconditions.checkArgument(StandardCharsets.UTF_8.newEncoder().canEncode(ssid));
            this.mWifiSsid = WifiSsid.fromUtf8Text(ssid);
            return this;
        }

        @SystemApi
        @NonNull
        @RequiresApi(value=33)
        public Builder setWifiSsid(@Nullable WifiSsid wifiSsid) {
            if (!SdkLevel.isAtLeastT()) {
                throw new UnsupportedOperationException();
            }
            this.mWifiSsid = wifiSsid;
            return this;
        }

        @SystemApi
        @NonNull
        @RequiresApi(value=33)
        public Builder setVendorElements(@NonNull List<ScanResult.InformationElement> vendorElements) {
            if (!SdkLevel.isAtLeastT()) {
                throw new UnsupportedOperationException();
            }
            for (ScanResult.InformationElement e : vendorElements) {
                if (e.id == 221) continue;
                throw new IllegalArgumentException("received InformationElement which is not related to VendorElements. VendorElement block should start with " + HexEncoding.encodeToString(new byte[]{-35}));
            }
            HashSet<ScanResult.InformationElement> set = new HashSet<ScanResult.InformationElement>(vendorElements);
            if (set.size() < vendorElements.size()) {
                throw new IllegalArgumentException("vendor elements array contain duplicates. Please avoid passing duplicated and keep structure clean.");
            }
            this.mVendorElements = new ArrayList<ScanResult.InformationElement>(vendorElements);
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setBssid(@Nullable MacAddress bssid) {
            if (bssid != null) {
                Preconditions.checkArgument(!((Object)bssid).equals(WifiManager.ALL_ZEROS_MAC_ADDRESS));
                if (bssid.getAddressType() != 1) {
                    throw new IllegalArgumentException("bssid doesn't support multicast or broadcast mac address");
                }
            }
            this.mBssid = bssid;
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setPassphrase(@Nullable String passphrase, int securityType) {
            if (!(SdkLevel.isAtLeastT() || securityType != 4 && securityType != 5)) {
                throw new UnsupportedOperationException();
            }
            if (securityType == 0 || securityType == 4 || securityType == 5) {
                if (passphrase != null) {
                    throw new IllegalArgumentException("passphrase should be null when security type is open");
                }
            } else {
                Preconditions.checkStringNotEmpty(passphrase);
                if (!(SdkLevel.isAtLeastT() || securityType != 1 && securityType != 2)) {
                    int passphraseByteLength = 0;
                    if (!TextUtils.isEmpty(passphrase)) {
                        passphraseByteLength = passphrase.getBytes(StandardCharsets.UTF_8).length;
                    }
                    if (passphraseByteLength < 8 || passphraseByteLength > 63) {
                        throw new IllegalArgumentException("Passphrase length must be at least 8 and no more than 63 for WPA2_PSK and WPA3_SAE_TRANSITION Mode");
                    }
                }
            }
            this.mSecurityType = securityType;
            this.mPassphrase = passphrase;
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setHiddenSsid(boolean hiddenSsid) {
            this.mHiddenSsid = hiddenSsid;
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setBand(int band) {
            if (!SoftApConfiguration.isBandValid(band)) {
                throw new IllegalArgumentException("Invalid band type: " + band);
            }
            this.mChannels = new SparseIntArray(1);
            this.mChannels.put(band, 0);
            return this;
        }

        @SystemApi
        @RequiresApi(value=31)
        @NonNull
        public Builder setBands(@NonNull int[] bands) {
            if (!SdkLevel.isAtLeastS()) {
                throw new UnsupportedOperationException();
            }
            if (bands.length == 0 || bands.length > 2) {
                throw new IllegalArgumentException("Unsupported number of bands(" + bands.length + ") configured");
            }
            SparseIntArray channels = new SparseIntArray(bands.length);
            for (int val : bands) {
                if (!SoftApConfiguration.isBandValid(val)) {
                    throw new IllegalArgumentException("Invalid band type: " + val);
                }
                channels.put(val, 0);
            }
            this.mChannels = channels;
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setChannel(int channel, int band) {
            if (!SoftApConfiguration.isChannelBandPairValid(channel, band)) {
                throw new IllegalArgumentException("Invalid channel(" + channel + ") & band (" + band + ") configured");
            }
            this.mChannels = new SparseIntArray(1);
            this.mChannels.put(band, channel);
            return this;
        }

        @RequiresApi(value=31)
        @NonNull
        public Builder setChannels(@NonNull SparseIntArray channels) {
            if (!SdkLevel.isAtLeastS()) {
                throw new UnsupportedOperationException();
            }
            if (channels.size() == 0 || channels.size() > 2) {
                throw new IllegalArgumentException("Unsupported number of channels(" + channels.size() + ") configured");
            }
            for (int i = 0; i < channels.size(); ++i) {
                int channel = channels.valueAt(i);
                int band = channels.keyAt(i);
                if (channel == 0) {
                    if (SoftApConfiguration.isBandValid(band)) continue;
                    throw new IllegalArgumentException("Invalid band type: " + band);
                }
                if (SoftApConfiguration.isChannelBandPairValid(channel, band)) continue;
                throw new IllegalArgumentException("Invalid channel(" + channel + ") & band (" + band + ") configured");
            }
            this.mChannels = channels.clone();
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setMaxNumberOfClients(int maxNumberOfClients) {
            if (maxNumberOfClients < 0) {
                throw new IllegalArgumentException("maxNumberOfClients should be not negative");
            }
            this.mMaxNumberOfClients = maxNumberOfClients;
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setAutoShutdownEnabled(boolean enable) {
            this.mAutoShutdownEnabled = enable;
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setShutdownTimeoutMillis(long timeoutMillis) {
            if (CompatChanges.isChangeEnabled(213289672L) && timeoutMillis < 1L) {
                if (timeoutMillis != -1L) {
                    throw new IllegalArgumentException("Invalid timeout value: " + timeoutMillis);
                }
            } else if (timeoutMillis < 0L) {
                throw new IllegalArgumentException("Invalid timeout value from legacy app: " + timeoutMillis);
            }
            this.mShutdownTimeoutMillis = timeoutMillis;
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setClientControlByUserEnabled(boolean enabled) {
            this.mClientControlByUser = enabled;
            return this;
        }

        @SystemApi
        @NonNull
        @RequiresApi(value=33)
        public Builder setAllowedAcsChannels(int band, @NonNull int[] channels) {
            if (!SdkLevel.isAtLeastT()) {
                throw new UnsupportedOperationException();
            }
            if (channels == null) {
                throw new IllegalArgumentException("Passing a null object to setAllowedAcsChannels");
            }
            if (band != 1 && band != 2 && band != 4) {
                throw new IllegalArgumentException("Passing an invalid band to setAllowedAcsChannels");
            }
            for (int channel : channels) {
                if (SoftApConfiguration.isChannelBandPairValid(channel, band)) continue;
                throw new IllegalArgumentException("Invalid channel to setAllowedAcsChannels: band: " + band + "channel: " + channel);
            }
            HashSet set = IntStream.of(channels).boxed().collect(Collectors.toCollection(HashSet::new));
            switch (band) {
                case 1: {
                    this.mAllowedAcsChannels2g = set;
                    break;
                }
                case 2: {
                    this.mAllowedAcsChannels5g = set;
                    break;
                }
                case 4: {
                    this.mAllowedAcsChannels6g = set;
                }
            }
            return this;
        }

        @SystemApi
        @NonNull
        @RequiresApi(value=33)
        public Builder setMaxChannelBandwidth(int maxChannelBandwidth) {
            if (!SdkLevel.isAtLeastT()) {
                throw new UnsupportedOperationException();
            }
            switch (maxChannelBandwidth) {
                case -1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 11: {
                    this.mMaxChannelBandwidth = maxChannelBandwidth;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid channel bandwidth value(" + maxChannelBandwidth + ")  configured");
                }
            }
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setAllowedClientList(@NonNull List<MacAddress> allowedClientList) {
            this.mAllowedClientList = new ArrayList<MacAddress>(allowedClientList);
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setBlockedClientList(@NonNull List<MacAddress> blockedClientList) {
            this.mBlockedClientList = new ArrayList<MacAddress>(blockedClientList);
            return this;
        }

        @SystemApi
        @RequiresApi(value=31)
        @NonNull
        public Builder setMacRandomizationSetting(int macRandomizationSetting) {
            if (!SdkLevel.isAtLeastS()) {
                throw new UnsupportedOperationException();
            }
            this.mMacRandomizationSetting = macRandomizationSetting;
            return this;
        }

        @SystemApi
        @RequiresApi(value=31)
        @NonNull
        public Builder setBridgedModeOpportunisticShutdownEnabled(boolean enable) {
            if (!SdkLevel.isAtLeastS()) {
                throw new UnsupportedOperationException();
            }
            this.mBridgedModeOpportunisticShutdownEnabled = enable;
            return this;
        }

        @SystemApi
        @RequiresApi(value=31)
        @NonNull
        public Builder setIeee80211axEnabled(boolean enable) {
            if (!SdkLevel.isAtLeastS()) {
                throw new UnsupportedOperationException();
            }
            this.mIeee80211axEnabled = enable;
            return this;
        }

        @SystemApi
        @RequiresApi(value=33)
        @NonNull
        public Builder setIeee80211beEnabled(boolean enable) {
            if (!SdkLevel.isAtLeastT()) {
                throw new UnsupportedOperationException();
            }
            this.mIeee80211beEnabled = enable;
            return this;
        }

        @NonNull
        public Builder setUserConfiguration(boolean isUserConfigured) {
            this.mIsUserConfiguration = isUserConfigured;
            return this;
        }

        @SystemApi
        @RequiresApi(value=33)
        @NonNull
        public Builder setBridgedModeOpportunisticShutdownTimeoutMillis(long timeoutMillis) {
            if (!SdkLevel.isAtLeastT()) {
                throw new UnsupportedOperationException();
            }
            if (timeoutMillis < 1L && timeoutMillis != -1L) {
                throw new IllegalArgumentException("Invalid timeout value: " + timeoutMillis);
            }
            this.mBridgedModeOpportunisticShutdownTimeoutMillis = timeoutMillis;
            return this;
        }

        @NonNull
        public Builder setRandomizedMacAddress(@NonNull MacAddress mac) {
            if (mac == null) {
                throw new IllegalArgumentException("setRandomizedMacAddress received null MacAddress.");
            }
            this.mPersistentRandomizedMacAddress = mac;
            return this;
        }

        @SystemApi
        @RequiresApi(value=35)
        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder setVendorData(@NonNull List<OuiKeyedData> vendorData) {
            if (!SdkLevel.isAtLeastV()) {
                throw new UnsupportedOperationException();
            }
            if (vendorData == null) {
                throw new IllegalArgumentException("setVendorData received a null value");
            }
            this.mVendorData = vendorData;
            return this;
        }

        @SystemApi
        @FlaggedApi(value="com.android.wifi.flags.ap_isolate")
        @RequiresApi(value=36)
        @NonNull
        public Builder setClientIsolationEnabled(boolean isClientIsolationEnabled) {
            if (!Environment.isSdkAtLeastB()) {
                throw new UnsupportedOperationException();
            }
            this.mIsClientIsolationEnabled = isClientIsolationEnabled;
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SecurityType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MacRandomizationSetting {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BandType {
    }
}

