/*
 * Decompiled with CFR 0.152.
 */
package android.net.nsd;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresApi;
import android.annotation.SystemApi;
import android.net.connectivity.com.android.net.module.util.HexDump;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="com.android.net.flags.register_nsd_offload_engine_api")
@RequiresApi(value=33)
public class OffloadServiceInfo
implements Parcelable {
    @NonNull
    private final Key mKey;
    @NonNull
    private final String mHostname;
    @NonNull
    final List<String> mSubtypes;
    @Nullable
    private final byte[] mOffloadPayload;
    private final int mPriority;
    private final long mOffloadType;
    @NonNull
    public static final Parcelable.Creator<OffloadServiceInfo> CREATOR = new Parcelable.Creator<OffloadServiceInfo>(){

        @Override
        public OffloadServiceInfo createFromParcel(Parcel in) {
            return new OffloadServiceInfo(in);
        }

        public OffloadServiceInfo[] newArray(int size) {
            return new OffloadServiceInfo[size];
        }
    };

    public OffloadServiceInfo(@NonNull Key key, @NonNull List<String> subtypes, @NonNull String hostname, @Nullable byte[] offloadPayload, int priority, long offloadType) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(subtypes);
        Objects.requireNonNull(hostname);
        this.mKey = key;
        this.mSubtypes = subtypes;
        this.mHostname = hostname;
        this.mOffloadPayload = offloadPayload;
        this.mPriority = priority;
        this.mOffloadType = offloadType;
    }

    public OffloadServiceInfo(@NonNull Parcel in) {
        this.mKey = in.readParcelable(Key.class.getClassLoader(), Key.class);
        this.mSubtypes = in.createStringArrayList();
        this.mHostname = in.readString();
        this.mOffloadPayload = in.createByteArray();
        this.mPriority = in.readInt();
        this.mOffloadType = in.readLong();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeParcelable(this.mKey, flags);
        dest.writeStringList(this.mSubtypes);
        dest.writeString(this.mHostname);
        dest.writeByteArray(this.mOffloadPayload);
        dest.writeInt(this.mPriority);
        dest.writeLong(this.mOffloadType);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @NonNull
    public Key getKey() {
        return this.mKey;
    }

    @NonNull
    public String getHostname() {
        return this.mHostname;
    }

    @NonNull
    public List<String> getSubtypes() {
        return Collections.unmodifiableList(this.mSubtypes);
    }

    @Nullable
    public byte[] getOffloadPayload() {
        if (this.mOffloadPayload == null) {
            return null;
        }
        return (byte[])this.mOffloadPayload.clone();
    }

    @NonNull
    public OffloadServiceInfo withOffloadPayload(@NonNull byte[] offloadPayload) {
        return new OffloadServiceInfo(this.getKey(), this.getSubtypes(), this.getHostname(), offloadPayload, this.getPriority(), this.getOffloadType());
    }

    public long getOffloadType() {
        return this.mOffloadType;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public String toString() {
        return String.format("OffloadServiceInfo{ mOffloadServiceInfoKey=%s, mHostName=%s, mOffloadPayload=%s, mPriority=%d, mOffloadType=%d, mSubTypes=%s }", this.mKey, this.mHostname, HexDump.dumpHexString(this.mOffloadPayload), this.mPriority, this.mOffloadType, this.mSubtypes.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OffloadServiceInfo)) {
            return false;
        }
        OffloadServiceInfo that = (OffloadServiceInfo)o;
        return this.mPriority == that.mPriority && this.mOffloadType == that.mOffloadType && this.mKey.equals(that.mKey) && this.mHostname.equals(that.mHostname) && Arrays.equals(this.mOffloadPayload, that.mOffloadPayload) && this.mSubtypes.equals(that.mSubtypes);
    }

    public int hashCode() {
        int result = Objects.hash(this.mKey, this.mHostname, this.mPriority, this.mOffloadType, this.mSubtypes);
        result = 31 * result + Arrays.hashCode(this.mOffloadPayload);
        return result;
    }

    public static class Key
    implements Parcelable {
        @NonNull
        private final String mServiceName;
        @NonNull
        private final String mServiceType;
        @NonNull
        public static final Parcelable.Creator<Key> CREATOR = new Parcelable.Creator<Key>(){

            @Override
            public Key createFromParcel(Parcel in) {
                return new Key(in);
            }

            public Key[] newArray(int size) {
                return new Key[size];
            }
        };

        public Key(@NonNull String serviceName, @NonNull String serviceType) {
            Objects.requireNonNull(serviceName);
            Objects.requireNonNull(serviceType);
            this.mServiceName = serviceName;
            this.mServiceType = serviceType;
        }

        public Key(@NonNull Parcel in) {
            this.mServiceName = in.readString();
            this.mServiceType = in.readString();
        }

        @NonNull
        public String getServiceName() {
            return this.mServiceName;
        }

        @NonNull
        public String getServiceType() {
            return this.mServiceType;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeString(this.mServiceName);
            dest.writeString(this.mServiceType);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key that = (Key)o;
            return Objects.equals(this.mServiceName, that.mServiceName) && Objects.equals(this.mServiceType, that.mServiceType);
        }

        public int hashCode() {
            return Objects.hash(this.mServiceName, this.mServiceType);
        }

        public String toString() {
            return String.format("OffloadServiceInfoKey{ mServiceName=%s, mServiceType=%s }", this.mServiceName, this.mServiceType);
        }
    }
}

