/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.http.HeaderBlock;
import android.net.http.UrlResponseInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class UrlResponseInfoWrapper
extends UrlResponseInfo {
    private final android.net.connectivity.org.chromium.net.UrlResponseInfo backend;

    public UrlResponseInfoWrapper(android.net.connectivity.org.chromium.net.UrlResponseInfo backend) {
        this.backend = backend;
    }

    @Override
    public String getUrl() {
        return this.backend.getUrl();
    }

    @Override
    public List<String> getUrlChain() {
        return this.backend.getUrlChain();
    }

    @Override
    public int getHttpStatusCode() {
        return this.backend.getHttpStatusCode();
    }

    @Override
    public String getHttpStatusText() {
        return this.backend.getHttpStatusText();
    }

    @Override
    public HeaderBlock getHeaders() {
        return new HeaderBlockImpl(this.backend.getAllHeadersAsList());
    }

    @Override
    public boolean wasCached() {
        return this.backend.wasCached();
    }

    @Override
    public String getNegotiatedProtocol() {
        return this.backend.getNegotiatedProtocol();
    }

    @Override
    public long getReceivedByteCount() {
        return this.backend.getReceivedByteCount();
    }

    private static class HeaderBlockImpl
    extends HeaderBlock {
        private final List<Map.Entry<String, String>> mAllHeadersList;
        private Map<String, List<String>> mHeadersMap;

        public HeaderBlockImpl(List<Map.Entry<String, String>> allHeadersList) {
            this.mAllHeadersList = Collections.unmodifiableList(allHeadersList);
        }

        @Override
        public List<Map.Entry<String, String>> getAsList() {
            return this.mAllHeadersList;
        }

        @Override
        public Map<String, List<String>> getAsMap() {
            if (this.mHeadersMap != null) {
                return this.mHeadersMap;
            }
            TreeMap<String, List> map = new TreeMap<String, List>(String.CASE_INSENSITIVE_ORDER);
            for (Map.Entry<String, String> entry : this.mAllHeadersList) {
                List values2 = map.computeIfAbsent(entry.getKey(), key -> new ArrayList());
                values2.add(entry.getValue());
            }
            map.replaceAll((key, values) -> Collections.unmodifiableList(values));
            this.mHeadersMap = Collections.unmodifiableMap(map);
            return this.mHeadersMap;
        }
    }
}

