/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.net.impl;

import android.net.connectivity.javax.annotation.concurrent.GuardedBy;
import android.net.connectivity.org.chromium.base.Log;
import android.net.connectivity.org.chromium.base.metrics.ScopedSysTraceEvent;
import android.net.connectivity.org.chromium.net.CronetException;
import android.net.connectivity.org.chromium.net.ExperimentalUrlRequest;
import android.net.connectivity.org.chromium.net.InlineExecutionProhibitedException;
import android.net.connectivity.org.chromium.net.RequestFinishedInfo;
import android.net.connectivity.org.chromium.net.UploadDataProvider;
import android.net.connectivity.org.chromium.net.UrlRequest;
import android.net.connectivity.org.chromium.net.impl.CallbackExceptionImpl;
import android.net.connectivity.org.chromium.net.impl.CronetExceptionImpl;
import android.net.connectivity.org.chromium.net.impl.CronetLogger;
import android.net.connectivity.org.chromium.net.impl.CronetMetrics;
import android.net.connectivity.org.chromium.net.impl.CronetRequestCommon;
import android.net.connectivity.org.chromium.net.impl.CronetUploadDataStream;
import android.net.connectivity.org.chromium.net.impl.CronetUrlRequestContext;
import android.net.connectivity.org.chromium.net.impl.CronetUrlRequestJni;
import android.net.connectivity.org.chromium.net.impl.NetworkExceptionImpl;
import android.net.connectivity.org.chromium.net.impl.Preconditions;
import android.net.connectivity.org.chromium.net.impl.QuicExceptionImpl;
import android.net.connectivity.org.chromium.net.impl.RefCountDelegate;
import android.net.connectivity.org.chromium.net.impl.RequestFinishedInfoImpl;
import android.net.connectivity.org.chromium.net.impl.UrlRequestUtil;
import android.net.connectivity.org.chromium.net.impl.UrlResponseInfoImpl;
import android.net.connectivity.org.chromium.net.impl.VersionSafeCallbacks;
import android.net.connectivity.org.jni_zero.CalledByNative;
import android.net.connectivity.org.jni_zero.JNINamespace;
import android.net.connectivity.org.jni_zero.NativeClassQualifiedName;
import android.os.Process;
import android.os._Original_Build;
import com.android.layoutlib.androidx.annotation.NonNull;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import com.android.layoutlib.androidx.annotation.VisibleForTesting;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

@JNINamespace(value="cronet")
@VisibleForTesting
public class CronetUrlRequest
extends ExperimentalUrlRequest {
    private final boolean mAllowDirectExecutor;
    @GuardedBy(value="mUrlRequestAdapterLock")
    private long mUrlRequestAdapter;
    @GuardedBy(value="mUrlRequestAdapterLock")
    private boolean mStarted;
    @GuardedBy(value="mUrlRequestAdapterLock")
    private boolean mWaitingOnRedirect;
    @GuardedBy(value="mUrlRequestAdapterLock")
    private boolean mWaitingOnRead;
    private final Object mUrlRequestAdapterLock = new Object();
    private final CronetUrlRequestContext mRequestContext;
    private final Executor mExecutor;
    private final List<String> mUrlChain = new ArrayList<String>();
    private final VersionSafeCallbacks.UrlRequestCallback mCallback;
    private final String mInitialUrl;
    private final int mPriority;
    private final int mIdempotency;
    private final String mInitialMethod;
    private final List<Map.Entry<String, String>> mRequestHeaders;
    private final Collection<Object> mRequestAnnotations;
    private final boolean mDisableCache;
    private final boolean mDisableConnectionMigration;
    private final boolean mTrafficStatsTagSet;
    private final int mTrafficStatsTag;
    private final boolean mTrafficStatsUidSet;
    private final int mTrafficStatsUid;
    private final VersionSafeCallbacks.RequestFinishedInfoListener mRequestFinishedListener;
    private byte[] mDictionarySha256Hash;
    private ByteBuffer mDictionary;
    private final String mDictionaryId;
    private final long mNetworkHandle;
    private final CronetLogger mLogger;
    private final CronetUploadDataStream mUploadDataStream;
    private UrlResponseInfoImpl mResponseInfo;
    private int mFinishedReason;
    private CronetException mException;
    private CronetMetrics mMetrics;
    private boolean mQuicConnectionMigrationAttempted;
    private boolean mQuicConnectionMigrationSuccessful;
    private int mReadCount;
    private int mNonfinalUserCallbackExceptionCount;
    private boolean mFinalUserCallbackThrew;
    private OnReadCompletedRunnable mOnReadCompletedTask;
    @GuardedBy(value="mUrlRequestAdapterLock")
    private Runnable mOnDestroyedCallbackForTesting;

    CronetUrlRequest(CronetUrlRequestContext requestContext, String url, int priority, UrlRequest.Callback callback, Executor executor, Collection<Object> requestAnnotations, boolean disableCache, boolean disableConnectionMigration, boolean allowDirectExecutor, boolean trafficStatsTagSet, int trafficStatsTag, boolean trafficStatsUidSet, int trafficStatsUid, RequestFinishedInfo.Listener requestFinishedListener, int idempotency, long networkHandle, String method, ArrayList<Map.Entry<String, String>> requestHeaders, UploadDataProvider uploadDataProvider, Executor uploadDataProviderExecutor, byte[] dictionarySha256Hash, ByteBuffer dictionary, @NonNull String dictionaryId) {
        Objects.requireNonNull(url, "URL is required");
        Objects.requireNonNull(callback, "Listener is required");
        Objects.requireNonNull(executor, "Executor is required");
        Objects.requireNonNull(dictionaryId, "Dictionary ID is expect to be an empty string if not specified");
        this.mAllowDirectExecutor = allowDirectExecutor;
        this.mRequestContext = requestContext;
        this.mLogger = requestContext.getCronetLogger();
        this.mInitialUrl = url;
        this.mUrlChain.add(url);
        this.mPriority = CronetUrlRequest.convertRequestPriority(priority);
        this.mCallback = new VersionSafeCallbacks.UrlRequestCallback(callback);
        this.mExecutor = executor;
        this.mRequestAnnotations = requestAnnotations;
        this.mDisableCache = disableCache;
        this.mDisableConnectionMigration = disableConnectionMigration;
        this.mTrafficStatsTagSet = trafficStatsTagSet;
        this.mTrafficStatsTag = trafficStatsTag;
        this.mTrafficStatsUidSet = trafficStatsUidSet;
        this.mTrafficStatsUid = trafficStatsUid;
        this.mRequestFinishedListener = requestFinishedListener != null ? new VersionSafeCallbacks.RequestFinishedInfoListener(requestFinishedListener) : null;
        this.mDictionarySha256Hash = dictionarySha256Hash;
        this.mDictionary = dictionary;
        this.mDictionaryId = dictionaryId;
        this.mIdempotency = CronetUrlRequest.convertIdempotency(idempotency);
        this.mNetworkHandle = networkHandle;
        this.mInitialMethod = method;
        this.mRequestHeaders = Collections.unmodifiableList(new ArrayList<Map.Entry<String, String>>(requestHeaders));
        this.mUploadDataStream = uploadDataProvider == null ? null : new CronetUploadDataStream(uploadDataProvider, uploadDataProviderExecutor, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void start() {
        try (ScopedSysTraceEvent traceEvent = ScopedSysTraceEvent.scoped("CronetUrlRequest#start");){
            Object object = this.mUrlRequestAdapterLock;
            synchronized (object) {
                this.checkNotStarted();
                try {
                    this.mUrlRequestAdapter = CronetUrlRequestJni.get().createRequestAdapter(this, this.mRequestContext.getUrlRequestContextAdapter(), this.mInitialUrl, this.mPriority, this.mDisableCache, this.mDisableConnectionMigration, this.mTrafficStatsTagSet, this.mTrafficStatsTag, this.mTrafficStatsUidSet, this.mTrafficStatsUid, this.mIdempotency, this.mDictionarySha256Hash, this.mDictionary, this.mDictionary != null ? this.mDictionary.position() : 0, this.mDictionary != null ? this.mDictionary.limit() : 0, this.mDictionaryId, this.mNetworkHandle);
                    this.mRequestContext.onRequestStarted();
                    if (!CronetUrlRequestJni.get().setHttpMethod(this.mUrlRequestAdapter, this, this.mInitialMethod)) {
                        throw new IllegalArgumentException("Invalid http method " + this.mInitialMethod);
                    }
                    boolean hasContentType = false;
                    for (Map.Entry<String, String> header : this.mRequestHeaders) {
                        if (header.getKey().equalsIgnoreCase("Content-Type") && !header.getValue().isEmpty()) {
                            hasContentType = true;
                        }
                        if (CronetUrlRequestJni.get().addRequestHeader(this.mUrlRequestAdapter, this, header.getKey(), header.getValue())) continue;
                        throw new IllegalArgumentException("Invalid header with headername: " + header.getKey());
                    }
                    if (this.mUploadDataStream != null) {
                        if (!hasContentType) {
                            throw new IllegalArgumentException("Requests with upload data must have a Content-Type.");
                        }
                        this.mStarted = true;
                        this.mUploadDataStream.postTaskToExecutor(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                CronetUrlRequest.this.mUploadDataStream.initializeWithRequest();
                                Object object = CronetUrlRequest.this.mUrlRequestAdapterLock;
                                synchronized (object) {
                                    if (CronetUrlRequest.this.isDoneLocked()) {
                                        return;
                                    }
                                    CronetUrlRequest.this.mUploadDataStream.attachNativeAdapterToRequest(CronetUrlRequest.this.mUrlRequestAdapter);
                                    CronetUrlRequest.this.startInternalLocked();
                                }
                            }
                        }, "CronetUrlRequest#start");
                        return;
                    }
                }
                catch (RuntimeException e) {
                    this.destroyRequestAdapterLocked(1);
                    this.mRequestContext.onRequestFinished();
                    throw e;
                }
                this.mStarted = true;
                this.startInternalLocked();
                return;
            }
        }
    }

    @GuardedBy(value="mUrlRequestAdapterLock")
    private void startInternalLocked() {
        CronetUrlRequestJni.get().start(this.mUrlRequestAdapter, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void followRedirect() {
        try (ScopedSysTraceEvent traceEvent = ScopedSysTraceEvent.scoped("CronetUrlRequest#followRedirect");){
            Object object = this.mUrlRequestAdapterLock;
            synchronized (object) {
                block12: {
                    if (!this.mWaitingOnRedirect) {
                        throw new IllegalStateException("No redirect to follow.");
                    }
                    this.mWaitingOnRedirect = false;
                    if (!this.isDoneLocked()) break block12;
                    return;
                }
                CronetUrlRequestJni.get().followDeferredRedirect(this.mUrlRequestAdapter, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(ByteBuffer buffer) {
        try (ScopedSysTraceEvent traceEvent = ScopedSysTraceEvent.scoped("CronetUrlRequest#read");){
            Preconditions.checkHasRemaining(buffer);
            Preconditions.checkDirect(buffer);
            Object object = this.mUrlRequestAdapterLock;
            synchronized (object) {
                block13: {
                    if (!this.mWaitingOnRead) {
                        throw new IllegalStateException("Unexpected read attempt.");
                    }
                    this.mWaitingOnRead = false;
                    if (!this.isDoneLocked()) break block13;
                    return;
                }
                if (!CronetUrlRequestJni.get().readData(this.mUrlRequestAdapter, this, buffer, buffer.position(), buffer.limit())) {
                    this.mWaitingOnRead = true;
                    throw new IllegalArgumentException("Unable to call native read");
                }
                ++this.mReadCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        try (ScopedSysTraceEvent traceEvent = ScopedSysTraceEvent.scoped("CronetUrlRequest#cancel");){
            Object object = this.mUrlRequestAdapterLock;
            synchronized (object) {
                block11: {
                    if (!this.isDoneLocked() && this.mStarted) break block11;
                    return;
                }
                this.destroyRequestAdapterLocked(2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.mUrlRequestAdapterLock;
        synchronized (object) {
            return this.isDoneLocked();
        }
    }

    @GuardedBy(value="mUrlRequestAdapterLock")
    private boolean isDoneLocked() {
        return this.mStarted && this.mUrlRequestAdapter == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getStatus(UrlRequest.StatusListener unsafeListener) {
        final VersionSafeCallbacks.UrlRequestStatusListener listener = new VersionSafeCallbacks.UrlRequestStatusListener(unsafeListener);
        Object object = this.mUrlRequestAdapterLock;
        synchronized (object) {
            if (this.mUrlRequestAdapter != 0L) {
                CronetUrlRequestJni.get().getStatus(this.mUrlRequestAdapter, this, listener);
                return;
            }
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try (ScopedSysTraceEvent callbackTraceEvent = ScopedSysTraceEvent.scoped("CronetUrlRequest#getStatus running callback");){
                    listener.onStatus(-1);
                }
            }
        };
        this.postTaskToExecutor(task, "getStatus");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnDestroyedCallbackForTesting(Runnable onDestroyedCallbackForTesting) {
        Object object = this.mUrlRequestAdapterLock;
        synchronized (object) {
            this.mOnDestroyedCallbackForTesting = onDestroyedCallbackForTesting;
        }
    }

    public void setOnDestroyedUploadCallbackForTesting(Runnable onDestroyedUploadCallbackForTesting) {
        this.mUploadDataStream.setOnDestroyedCallbackForTesting(onDestroyedUploadCallbackForTesting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUrlRequestAdapterForTesting() {
        Object object = this.mUrlRequestAdapterLock;
        synchronized (object) {
            return this.mUrlRequestAdapter;
        }
    }

    private void postTaskToExecutor(Runnable task, String name) {
        try (ScopedSysTraceEvent traceEvent = ScopedSysTraceEvent.scoped("CronetUrlRequest#postTaskToExecutor " + name);){
            try {
                this.mExecutor.execute(() -> {
                    try (ScopedSysTraceEvent callbackTraceEvent = ScopedSysTraceEvent.scoped("CronetUrlRequest#postTaskToExecutor " + name + " running callback");){
                        task.run();
                    }
                });
            }
            catch (RejectedExecutionException failException) {
                Log.e(CronetUrlRequestContext.LOG_TAG, "Exception posting task to executor", failException);
                this.failWithException(new CronetExceptionImpl("Exception posting task to executor", failException));
            }
        }
    }

    private static int convertRequestPriority(int priority) {
        switch (priority) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
        }
        return 4;
    }

    private static int convertIdempotency(int idempotency) {
        switch (idempotency) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    private UrlResponseInfoImpl prepareResponseInfoOnNetworkThread(int httpStatusCode, String httpStatusText, String[] headers, boolean wasCached, String negotiatedProtocol, String proxyServer, long receivedByteCount) {
        ArrayList<Map.Entry<String, String>> headersList = new ArrayList<Map.Entry<String, String>>();
        for (int i = 0; i < headers.length; i += 2) {
            headersList.add(new AbstractMap.SimpleImmutableEntry<String, String>(headers[i], headers[i + 1]));
        }
        return new UrlResponseInfoImpl(new ArrayList<String>(this.mUrlChain), httpStatusCode, httpStatusText, headersList, wasCached, negotiatedProtocol, proxyServer, receivedByteCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNotStarted() {
        Object object = this.mUrlRequestAdapterLock;
        synchronized (object) {
            if (this.mStarted || this.isDoneLocked()) {
                throw new IllegalStateException("Request is already started.");
            }
        }
    }

    @GuardedBy(value="mUrlRequestAdapterLock")
    private void destroyRequestAdapterLocked(int finishedReason) {
        assert (this.mException == null || finishedReason == 1);
        this.mFinishedReason = finishedReason;
        if (this.mUrlRequestAdapter == 0L) {
            return;
        }
        this.mRequestContext.onRequestDestroyed();
        CronetUrlRequestJni.get().destroy(this.mUrlRequestAdapter, this, finishedReason == 2);
        this.mUrlRequestAdapter = 0L;
    }

    private void onNonfinalCallbackException(Exception e) {
        ++this.mNonfinalUserCallbackExceptionCount;
        CallbackExceptionImpl requestError = new CallbackExceptionImpl("Exception received from UrlRequest.Callback", e);
        Log.e(CronetUrlRequestContext.LOG_TAG, "Exception in CalledByNative method", e);
        this.failWithException(requestError);
    }

    private void onFinalCallbackException(String method, Exception e) {
        this.mFinalUserCallbackThrew = true;
        Log.e(CronetUrlRequestContext.LOG_TAG, "Exception in " + method + " method", e);
    }

    void onUploadException(Throwable e) {
        CallbackExceptionImpl uploadError = new CallbackExceptionImpl("Exception received from UploadDataProvider", e);
        Log.e(CronetUrlRequestContext.LOG_TAG, "Exception in upload method", e);
        this.failWithException(uploadError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failWithException(CronetException exception) {
        Object object = this.mUrlRequestAdapterLock;
        synchronized (object) {
            if (this.isDoneLocked()) {
                return;
            }
            assert (this.mException == null);
            this.mException = exception;
            this.destroyRequestAdapterLocked(1);
        }
    }

    @CalledByNative
    private void onRedirectReceived(final String newLocation, int httpStatusCode, String httpStatusText, String[] headers, boolean wasCached, String negotiatedProtocol, String proxyServer, long receivedByteCount) {
        final UrlResponseInfoImpl responseInfo = this.prepareResponseInfoOnNetworkThread(httpStatusCode, httpStatusText, headers, wasCached, negotiatedProtocol, proxyServer, receivedByteCount);
        this.mUrlChain.add(newLocation);
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CronetUrlRequest.this.checkCallingThread();
                Object object = CronetUrlRequest.this.mUrlRequestAdapterLock;
                synchronized (object) {
                    if (CronetUrlRequest.this.isDoneLocked()) {
                        return;
                    }
                    CronetUrlRequest.this.mWaitingOnRedirect = true;
                }
                try {
                    CronetUrlRequest.this.mCallback.onRedirectReceived(CronetUrlRequest.this, responseInfo, newLocation);
                }
                catch (Exception e) {
                    CronetUrlRequest.this.onNonfinalCallbackException(e);
                }
            }
        };
        this.postTaskToExecutor(task, "onRedirectReceived");
    }

    @CalledByNative
    private void onResponseStarted(int httpStatusCode, String httpStatusText, String[] headers, boolean wasCached, String negotiatedProtocol, String proxyServer, long receivedByteCount) {
        this.mResponseInfo = this.prepareResponseInfoOnNetworkThread(httpStatusCode, httpStatusText, headers, wasCached, negotiatedProtocol, proxyServer, receivedByteCount);
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CronetUrlRequest.this.checkCallingThread();
                Object object = CronetUrlRequest.this.mUrlRequestAdapterLock;
                synchronized (object) {
                    if (CronetUrlRequest.this.isDoneLocked()) {
                        return;
                    }
                    CronetUrlRequest.this.mWaitingOnRead = true;
                }
                try {
                    CronetUrlRequest.this.mCallback.onResponseStarted(CronetUrlRequest.this, CronetUrlRequest.this.mResponseInfo);
                }
                catch (Exception e) {
                    CronetUrlRequest.this.onNonfinalCallbackException(e);
                }
            }
        };
        this.postTaskToExecutor(task, "onResponseStarted");
    }

    @CalledByNative
    private void onReadCompleted(ByteBuffer byteBuffer, int bytesRead, int initialPosition, int initialLimit, long receivedByteCount) {
        this.mResponseInfo.setReceivedByteCount(receivedByteCount);
        if (byteBuffer.position() != initialPosition || byteBuffer.limit() != initialLimit) {
            this.failWithException(new CronetExceptionImpl("ByteBuffer modified externally during read", null));
            return;
        }
        if (this.mOnReadCompletedTask == null) {
            this.mOnReadCompletedTask = new OnReadCompletedRunnable();
        }
        byteBuffer.position(initialPosition + bytesRead);
        this.mOnReadCompletedTask.mByteBuffer = byteBuffer;
        this.postTaskToExecutor(this.mOnReadCompletedTask, "onReadCompleted");
    }

    @CalledByNative
    private void onSucceeded(long receivedByteCount) {
        this.mResponseInfo.setReceivedByteCount(receivedByteCount);
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = CronetUrlRequest.this.mUrlRequestAdapterLock;
                synchronized (object) {
                    if (CronetUrlRequest.this.isDoneLocked()) {
                        return;
                    }
                    CronetUrlRequest.this.destroyRequestAdapterLocked(0);
                }
                try {
                    CronetUrlRequest.this.mCallback.onSucceeded(CronetUrlRequest.this, CronetUrlRequest.this.mResponseInfo);
                }
                catch (Exception e) {
                    CronetUrlRequest.this.onFinalCallbackException("onSucceeded", e);
                }
                CronetUrlRequest.this.maybeReportMetrics();
            }
        };
        this.postTaskToExecutor(task, "onSucceeded");
    }

    @CalledByNative
    private void onError(int errorCode, int nativeError, int nativeQuicError, int source, String errorString, long receivedByteCount) {
        if (this.mResponseInfo != null) {
            this.mResponseInfo.setReceivedByteCount(receivedByteCount);
        }
        if (errorCode == 10 || nativeQuicError != 0) {
            this.failWithException(new QuicExceptionImpl("Exception in CronetUrlRequest: " + errorString, errorCode, nativeError, nativeQuicError, source));
        } else {
            int javaError = this.mapUrlRequestErrorToApiErrorCode(errorCode);
            this.failWithException(new NetworkExceptionImpl("Exception in CronetUrlRequest: " + errorString, javaError, nativeError));
        }
    }

    @CalledByNative
    private void onCanceled() {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    CronetUrlRequest.this.mCallback.onCanceled(CronetUrlRequest.this, CronetUrlRequest.this.mResponseInfo);
                }
                catch (Exception e) {
                    CronetUrlRequest.this.onFinalCallbackException("onCanceled", e);
                }
                CronetUrlRequest.this.maybeReportMetrics();
            }
        };
        this.postTaskToExecutor(task, "onCanceled");
    }

    @CalledByNative
    private void onStatus(final VersionSafeCallbacks.UrlRequestStatusListener listener, final int loadState) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                listener.onStatus(UrlRequestUtil.convertLoadState(loadState));
            }
        };
        this.postTaskToExecutor(task, "onStatus");
    }

    @CalledByNative
    private void onMetricsCollected(long requestStartMs, long dnsStartMs, long dnsEndMs, long connectStartMs, long connectEndMs, long sslStartMs, long sslEndMs, long sendingStartMs, long sendingEndMs, long pushStartMs, long pushEndMs, long responseStartMs, long requestEndMs, boolean socketReused, long sentByteCount, long receivedByteCount, boolean quicConnectionMigrationAttempted, boolean quicConnectionMigrationSuccessful) {
        if (this.mMetrics != null) {
            throw new IllegalStateException("Metrics collection should only happen once.");
        }
        this.mMetrics = new CronetMetrics(requestStartMs, dnsStartMs, dnsEndMs, connectStartMs, connectEndMs, sslStartMs, sslEndMs, sendingStartMs, sendingEndMs, pushStartMs, pushEndMs, responseStartMs, requestEndMs, socketReused, sentByteCount, receivedByteCount);
        this.mQuicConnectionMigrationAttempted = quicConnectionMigrationAttempted;
        this.mQuicConnectionMigrationSuccessful = quicConnectionMigrationSuccessful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CalledByNative
    private void onNativeAdapterDestroyed() {
        try (ScopedSysTraceEvent traceEvent = ScopedSysTraceEvent.scoped("CronetUrlRequest#onNativeAdapterDestroyed");){
            Object object = this.mUrlRequestAdapterLock;
            synchronized (object) {
                if (this.mOnDestroyedCallbackForTesting != null) {
                    this.mOnDestroyedCallbackForTesting.run();
                }
                if (this.mException == null) {
                    return;
                }
            }
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    try (ScopedSysTraceEvent callbackTraceEvent = ScopedSysTraceEvent.scoped("CronetUrlRequest#onNativeAdapterDestroyed running callback");){
                        try {
                            CronetUrlRequest.this.mCallback.onFailed(CronetUrlRequest.this, CronetUrlRequest.this.mResponseInfo, CronetUrlRequest.this.mException);
                        }
                        catch (Exception e) {
                            CronetUrlRequest.this.onFinalCallbackException("onFailed", e);
                        }
                        CronetUrlRequest.this.maybeReportMetrics();
                    }
                }
            };
            try (ScopedSysTraceEvent callbackTraceEvent = ScopedSysTraceEvent.scoped("CronetUrlRequest#onNativeAdapterDestroyed scheduling callback");){
                try {
                    this.mExecutor.execute(task);
                    return;
                }
                catch (RejectedExecutionException e) {
                    Log.e(CronetUrlRequestContext.LOG_TAG, "Exception posting task to executor", e);
                    return;
                }
            }
        }
    }

    void checkCallingThread() {
        if (!this.mAllowDirectExecutor && this.mRequestContext.isNetworkThread(Thread.currentThread())) {
            throw new InlineExecutionProhibitedException();
        }
    }

    private int mapUrlRequestErrorToApiErrorCode(int errorCode) {
        switch (errorCode) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 10;
            }
            case 11: {
                return 11;
            }
        }
        Log.e(CronetUrlRequestContext.LOG_TAG, "Unknown error code: " + errorCode);
        return errorCode;
    }

    @RequiresApi(value=26)
    private CronetLogger.CronetTrafficInfo buildCronetTrafficInfo() {
        long responseHeaderSizeInBytes;
        long responseBodySizeInBytes;
        long requestBodySizeInBytes;
        long requestHeaderSizeInBytes;
        boolean wasCached;
        int httpStatusCode;
        String negotiatedProtocol;
        Map<String, List<String>> responseHeaders;
        assert (this.mMetrics != null);
        assert (this.mRequestHeaders != null);
        if (this.mResponseInfo != null) {
            responseHeaders = this.mResponseInfo.getAllHeaders();
            negotiatedProtocol = this.mResponseInfo.getNegotiatedProtocol();
            httpStatusCode = this.mResponseInfo.getHttpStatusCode();
            wasCached = this.mResponseInfo.wasCached();
        } else {
            responseHeaders = Collections.emptyMap();
            negotiatedProtocol = "";
            httpStatusCode = 0;
            wasCached = false;
        }
        long requestTotalSizeInBytes = this.mMetrics.getSentByteCount();
        if (wasCached && requestTotalSizeInBytes == 0L) {
            requestHeaderSizeInBytes = 0L;
            requestBodySizeInBytes = 0L;
        } else {
            requestHeaderSizeInBytes = CronetRequestCommon.estimateHeadersSizeInBytes(this.mRequestHeaders);
            requestBodySizeInBytes = Math.max(0L, requestTotalSizeInBytes - requestHeaderSizeInBytes);
        }
        long responseTotalSizeInBytes = this.mMetrics.getReceivedByteCount();
        if (wasCached && responseTotalSizeInBytes == 0L) {
            responseBodySizeInBytes = 0L;
            responseHeaderSizeInBytes = 0L;
        } else {
            responseHeaderSizeInBytes = CronetRequestCommon.estimateHeadersSizeInBytes(responseHeaders);
            responseBodySizeInBytes = Math.max(0L, responseTotalSizeInBytes - responseHeaderSizeInBytes);
        }
        Duration headersLatency = this.mMetrics.getRequestStart() != null && this.mMetrics.getResponseStart() != null ? Duration.ofMillis(this.mMetrics.getResponseStart().getTime() - this.mMetrics.getRequestStart().getTime()) : Duration.ofSeconds(0L);
        Duration totalLatency = this.mMetrics.getRequestStart() != null && this.mMetrics.getRequestEnd() != null ? Duration.ofMillis(this.mMetrics.getRequestEnd().getTime() - this.mMetrics.getRequestStart().getTime()) : Duration.ofSeconds(0L);
        int networkInternalErrorCode = 0;
        int quicNetworkErrorCode = 0;
        int source = 0;
        CronetLogger.CronetTrafficInfo.RequestFailureReason failureReason = CronetLogger.CronetTrafficInfo.RequestFailureReason.UNKNOWN;
        CronetException cronetException = this.mException;
        if (cronetException instanceof NetworkExceptionImpl) {
            NetworkExceptionImpl networkException = (NetworkExceptionImpl)cronetException;
            networkInternalErrorCode = networkException.getCronetInternalErrorCode();
            failureReason = CronetLogger.CronetTrafficInfo.RequestFailureReason.NETWORK;
        } else {
            cronetException = this.mException;
            if (cronetException instanceof QuicExceptionImpl) {
                QuicExceptionImpl quicException = (QuicExceptionImpl)cronetException;
                networkInternalErrorCode = quicException.getCronetInternalErrorCode();
                quicNetworkErrorCode = quicException.getQuicDetailedErrorCode();
                source = quicException.getConnectionCloseSource();
                failureReason = CronetLogger.CronetTrafficInfo.RequestFailureReason.NETWORK;
            } else if (this.mException != null) {
                failureReason = CronetLogger.CronetTrafficInfo.RequestFailureReason.OTHER;
            }
        }
        return new CronetLogger.CronetTrafficInfo(requestHeaderSizeInBytes, requestBodySizeInBytes, responseHeaderSizeInBytes, responseBodySizeInBytes, httpStatusCode, headersLatency, totalLatency, negotiatedProtocol, this.mQuicConnectionMigrationAttempted, this.mQuicConnectionMigrationSuccessful, CronetRequestCommon.finishedReasonToCronetTrafficInfoRequestTerminalState(this.mFinishedReason), this.mNonfinalUserCallbackExceptionCount, this.mReadCount, this.mUploadDataStream == null ? 0 : this.mUploadDataStream.getReadCount(), false, this.mFinalUserCallbackThrew, Process.myUid(), networkInternalErrorCode, quicNetworkErrorCode, source, failureReason, this.mMetrics.getSocketReused());
    }

    private void maybeReportMetrics() {
        RefCountDelegate inflightCallbackCount = new RefCountDelegate(() -> this.mRequestContext.onRequestFinished());
        try {
            if (this.mMetrics == null) {
                return;
            }
            if (_Original_Build.VERSION.SDK_INT >= 26) {
                try {
                    this.mLogger.logCronetTrafficInfo(this.mRequestContext.getLogId(), this.buildCronetTrafficInfo());
                }
                catch (RuntimeException e) {
                    Log.e(CronetUrlRequestContext.LOG_TAG, "Error while trying to log CronetTrafficInfo: ", e);
                }
            }
            RequestFinishedInfoImpl requestInfo = new RequestFinishedInfoImpl(this.mInitialUrl, this.mRequestAnnotations, this.mMetrics, this.mFinishedReason, this.mResponseInfo, this.mException);
            this.mRequestContext.reportRequestFinished(requestInfo, inflightCallbackCount, this.mRequestFinishedListener);
        }
        finally {
            inflightCallbackCount.decrement();
        }
    }

    static interface Natives {
        public long createRequestAdapter(CronetUrlRequest var1, long var2, String var4, int var5, boolean var6, boolean var7, boolean var8, int var9, boolean var10, int var11, int var12, byte[] var13, ByteBuffer var14, int var15, int var16, String var17, long var18);

        @NativeClassQualifiedName(value="CronetURLRequestAdapter")
        public boolean setHttpMethod(long var1, CronetUrlRequest var3, String var4);

        @NativeClassQualifiedName(value="CronetURLRequestAdapter")
        public boolean addRequestHeader(long var1, CronetUrlRequest var3, String var4, String var5);

        @NativeClassQualifiedName(value="CronetURLRequestAdapter")
        public void start(long var1, CronetUrlRequest var3);

        @NativeClassQualifiedName(value="CronetURLRequestAdapter")
        public void followDeferredRedirect(long var1, CronetUrlRequest var3);

        @NativeClassQualifiedName(value="CronetURLRequestAdapter")
        public boolean readData(long var1, CronetUrlRequest var3, ByteBuffer var4, int var5, int var6);

        @NativeClassQualifiedName(value="CronetURLRequestAdapter")
        public void destroy(long var1, CronetUrlRequest var3, boolean var4);

        @NativeClassQualifiedName(value="CronetURLRequestAdapter")
        public void getStatus(long var1, CronetUrlRequest var3, VersionSafeCallbacks.UrlRequestStatusListener var4);
    }

    private class OnReadCompletedRunnable
    implements Runnable {
        ByteBuffer mByteBuffer;

        private OnReadCompletedRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CronetUrlRequest.this.checkCallingThread();
            ByteBuffer buffer = this.mByteBuffer;
            this.mByteBuffer = null;
            try {
                Object object = CronetUrlRequest.this.mUrlRequestAdapterLock;
                synchronized (object) {
                    if (CronetUrlRequest.this.isDoneLocked()) {
                        return;
                    }
                    CronetUrlRequest.this.mWaitingOnRead = true;
                }
                CronetUrlRequest.this.mCallback.onReadCompleted(CronetUrlRequest.this, CronetUrlRequest.this.mResponseInfo, buffer);
            }
            catch (Exception e) {
                CronetUrlRequest.this.onNonfinalCallbackException(e);
            }
        }
    }
}

