/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.net.httpflags;

import android.net.connectivity.com.google.protobuf.ByteString;
import android.net.connectivity.org.chromium.base.metrics.ScopedSysTraceEvent;
import android.net.connectivity.org.chromium.net.httpflags.FlagValue;
import android.net.connectivity.org.chromium.net.httpflags.Flags;
import com.android.layoutlib.androidx.annotation.Nullable;
import com.android.layoutlib.androidx.annotation.VisibleForTesting;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class ResolvedFlags {
    private final Map<String, Value> mFlags;

    public static ResolvedFlags resolve(Flags flags, String appId, String cronetVersion) {
        try (ScopedSysTraceEvent traceEvent = ScopedSysTraceEvent.scoped("Cronet ResolvedFlags#resolve");){
            int[] parsedCronetVersion = ResolvedFlags.parseVersionString(cronetVersion);
            HashMap<String, Value> resolvedFlags = new HashMap<String, Value>();
            for (Map.Entry<String, FlagValue> flag : flags.getFlagsMap().entrySet()) {
                try {
                    Value value = Value.resolve(flag.getValue(), appId, parsedCronetVersion);
                    if (value == null) continue;
                    resolvedFlags.put(flag.getKey(), value);
                }
                catch (RuntimeException exception) {
                    throw new IllegalArgumentException("Unable to resolve HTTP flag `" + flag.getKey() + "`", exception);
                }
            }
            ResolvedFlags resolvedFlags2 = new ResolvedFlags(resolvedFlags);
            return resolvedFlags2;
        }
    }

    @VisibleForTesting
    public ResolvedFlags(Map<String, Value> flags) {
        this.mFlags = flags;
    }

    public Map<String, Value> flags() {
        return Collections.unmodifiableMap(this.mFlags);
    }

    private static int[] parseVersionString(String versionString) {
        try {
            if (versionString.isEmpty()) {
                throw new IllegalArgumentException("Version string is empty");
            }
            StringTokenizer tokenizer = new StringTokenizer(versionString, ".");
            int[] components = new int[tokenizer.countTokens()];
            for (int i = 0; i < components.length; ++i) {
                components[i] = Integer.parseInt(tokenizer.nextToken());
            }
            return components;
        }
        catch (RuntimeException exception) {
            throw new IllegalArgumentException("Unable to parse HTTP flags version string: `" + versionString + "`", exception);
        }
    }

    public static class Value {
        private final Object mValue;

        @Nullable
        private static Value resolve(FlagValue flagValue, String appId, int[] cronetVersion) {
            for (FlagValue.ConstrainedValue constrainedValue : flagValue.getConstrainedValuesList()) {
                if (constrainedValue.hasAppId() && !constrainedValue.getAppId().equals(appId) || constrainedValue.hasMinVersion() && !Value.matchesVersion(cronetVersion, ResolvedFlags.parseVersionString(constrainedValue.getMinVersion()))) continue;
                return Value.fromConstrainedValue(constrainedValue);
            }
            return null;
        }

        private static boolean matchesVersion(int[] cronetVersion, int[] minVersion) {
            for (int i = 0; i < Math.max(cronetVersion.length, minVersion.length); ++i) {
                int minComponent;
                int cronetComponent = i < cronetVersion.length ? cronetVersion[i] : 0;
                int n = minComponent = i < minVersion.length ? minVersion[i] : 0;
                if (cronetComponent > minComponent) {
                    return true;
                }
                if (cronetComponent >= minComponent) continue;
                return false;
            }
            return true;
        }

        private static Value fromConstrainedValue(FlagValue.ConstrainedValue constrainedValue) {
            FlagValue.ConstrainedValue.ValueCase valueCase = constrainedValue.getValueCase();
            switch (valueCase) {
                case BOOL_VALUE: {
                    return new Value(constrainedValue.getBoolValue());
                }
                case INT_VALUE: {
                    return new Value(constrainedValue.getIntValue());
                }
                case FLOAT_VALUE: {
                    return new Value(constrainedValue.getFloatValue());
                }
                case STRING_VALUE: {
                    return new Value(constrainedValue.getStringValue());
                }
                case BYTES_VALUE: {
                    return new Value(constrainedValue.getBytesValue());
                }
                case VALUE_NOT_SET: {
                    return null;
                }
            }
            throw new IllegalArgumentException("Flag value uses unknown value type " + (Object)((Object)valueCase));
        }

        @VisibleForTesting
        public Value(boolean value) {
            this.mValue = value;
        }

        @VisibleForTesting
        public Value(long value) {
            this.mValue = value;
        }

        @VisibleForTesting
        public Value(float value) {
            this.mValue = Float.valueOf(value);
        }

        @VisibleForTesting
        public Value(String value) {
            this.mValue = value;
        }

        @VisibleForTesting
        public Value(ByteString value) {
            this.mValue = value;
        }

        public Type getType() {
            if (this.mValue instanceof Boolean) {
                return Type.BOOL;
            }
            if (this.mValue instanceof Long) {
                return Type.INT;
            }
            if (this.mValue instanceof Float) {
                return Type.FLOAT;
            }
            if (this.mValue instanceof String) {
                return Type.STRING;
            }
            if (this.mValue instanceof ByteString) {
                return Type.BYTES;
            }
            throw new IllegalStateException("Unexpected flag value type: " + this.mValue.getClass().getName());
        }

        private void checkType(Type requestedType) {
            Type actualType = this.getType();
            if (requestedType != actualType) {
                throw new IllegalStateException("Attempted to access flag value as " + (Object)((Object)requestedType) + ", but actual type is " + (Object)((Object)actualType));
            }
        }

        public boolean getBoolValue() {
            this.checkType(Type.BOOL);
            return (Boolean)this.mValue;
        }

        public long getIntValue() {
            this.checkType(Type.INT);
            return (Long)this.mValue;
        }

        public float getFloatValue() {
            this.checkType(Type.FLOAT);
            return ((Float)this.mValue).floatValue();
        }

        public String getStringValue() {
            this.checkType(Type.STRING);
            return (String)this.mValue;
        }

        public ByteString getBytesValue() {
            this.checkType(Type.BYTES);
            return (ByteString)this.mValue;
        }

        public static enum Type {
            BOOL,
            INT,
            FLOAT,
            STRING,
            BYTES;

        }
    }
}

