/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.net;

import android.net.connectivity.org.jni_zero.CalledByNative;
import android.net.connectivity.org.jni_zero.JNINamespace;
import java.net.InetAddress;
import java.util.List;

@JNINamespace(value="net::android")
public class DnsStatus {
    private final List<InetAddress> mDnsServers;
    private final boolean mPrivateDnsActive;
    private final String mPrivateDnsServerName;
    private final String mSearchDomains;

    public DnsStatus(List<InetAddress> dnsServers, boolean privateDnsActive, String privateDnsServerName, String searchDomains) {
        this.mDnsServers = dnsServers;
        this.mPrivateDnsActive = privateDnsActive;
        this.mPrivateDnsServerName = privateDnsServerName != null ? privateDnsServerName : "";
        this.mSearchDomains = searchDomains != null ? searchDomains : "";
    }

    @CalledByNative
    public byte[][] getDnsServers() {
        byte[][] dnsServers = new byte[this.mDnsServers.size()][];
        for (int i = 0; i < this.mDnsServers.size(); ++i) {
            dnsServers[i] = this.mDnsServers.get(i).getAddress();
        }
        return dnsServers;
    }

    @CalledByNative
    public boolean getPrivateDnsActive() {
        return this.mPrivateDnsActive;
    }

    @CalledByNative
    public String getPrivateDnsServerName() {
        return this.mPrivateDnsServerName;
    }

    @CalledByNative
    public String getSearchDomains() {
        return this.mSearchDomains;
    }
}

