/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.net;

import android.net.connectivity.org.jni_zero.CalledByNative;
import android.net.connectivity.org.jni_zero.JNINamespace;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@JNINamespace(value="net::android")
public class AndroidCertVerifyResult {
    private final int mStatus;
    private final boolean mIsIssuedByKnownRoot;
    private final List<X509Certificate> mCertificateChain;

    public AndroidCertVerifyResult(int status, boolean isIssuedByKnownRoot, List<X509Certificate> certificateChain) {
        this.mStatus = status;
        this.mIsIssuedByKnownRoot = isIssuedByKnownRoot;
        this.mCertificateChain = new ArrayList<X509Certificate>(certificateChain);
    }

    public AndroidCertVerifyResult(int status) {
        this.mStatus = status;
        this.mIsIssuedByKnownRoot = false;
        this.mCertificateChain = Collections.emptyList();
    }

    @CalledByNative
    public int getStatus() {
        return this.mStatus;
    }

    @CalledByNative
    public boolean isIssuedByKnownRoot() {
        return this.mIsIssuedByKnownRoot;
    }

    @CalledByNative
    public byte[][] getCertificateChainEncoded() {
        byte[][] verifiedChainArray = new byte[this.mCertificateChain.size()][];
        try {
            for (int i = 0; i < this.mCertificateChain.size(); ++i) {
                verifiedChainArray[i] = this.mCertificateChain.get(i).getEncoded();
            }
        }
        catch (CertificateEncodingException e) {
            return new byte[0][];
        }
        return verifiedChainArray;
    }
}

