/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.base.task;

import android.net.connectivity.javax.annotation.concurrent.GuardedBy;
import android.net.connectivity.org.chromium.base.JavaUtils;
import android.net.connectivity.org.chromium.base.Log;
import android.net.connectivity.org.chromium.base.ResettersForTesting;
import android.net.connectivity.org.chromium.base.ThreadUtils;
import android.net.connectivity.org.chromium.base.task.ChromeThreadPoolExecutor;
import android.net.connectivity.org.chromium.base.task.SequencedTaskRunner;
import android.net.connectivity.org.chromium.base.task.SequencedTaskRunnerImpl;
import android.net.connectivity.org.chromium.base.task.TaskOriginException;
import android.net.connectivity.org.chromium.base.task.TaskRunner;
import android.net.connectivity.org.chromium.base.task.TaskRunnerImpl;
import android.net.connectivity.org.chromium.base.task.UiThreadTaskRunnerImpl;
import android.net.connectivity.org.chromium.build.BuildConfig;
import android.net.connectivity.org.jni_zero.CalledByNative;
import android.net.connectivity.org.jni_zero.JNINamespace;
import com.android.layoutlib.androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;

@JNINamespace(value="base")
public class PostTask {
    private static final String TAG = "PostTask";
    static final boolean ENABLE_TASK_ORIGINS;
    private static final Object sPreNativeTaskRunnerLock;
    @GuardedBy(value="sPreNativeTaskRunnerLock")
    private static List<TaskRunnerImpl> sPreNativeTaskRunners;
    private static volatile boolean sNativeInitialized;
    private static ChromeThreadPoolExecutor sPrenativeThreadPoolExecutor;
    private static volatile Executor sPrenativeThreadPoolExecutorForTesting;
    private static final ThreadLocal<TaskOriginException> sTaskOrigin;
    private static final TaskRunner[] sTraitsToRunnerMap;
    static int sTestIterationForTesting;

    private static boolean isUiTaskTraits(int taskTraits) {
        return taskTraits >= 6;
    }

    public static TaskRunner createTaskRunner(int taskTraits) {
        if (PostTask.isUiTaskTraits(taskTraits)) {
            return sTraitsToRunnerMap[taskTraits];
        }
        return new TaskRunnerImpl(taskTraits);
    }

    public static SequencedTaskRunner createSequencedTaskRunner(int taskTraits) {
        if (PostTask.isUiTaskTraits(taskTraits)) {
            return (SequencedTaskRunner)sTraitsToRunnerMap[taskTraits];
        }
        return new SequencedTaskRunnerImpl(taskTraits);
    }

    public static void postTask(int taskTraits, Runnable task) {
        PostTask.postDelayedTask(taskTraits, task, 0L);
    }

    public static void postDelayedTask(int taskTraits, Runnable task, long delay) {
        sTraitsToRunnerMap[taskTraits].postDelayedTask(task, delay);
    }

    public static void runOrPostTask(int taskTraits, Runnable task) {
        if (PostTask.canRunTaskImmediately(taskTraits)) {
            task.run();
        } else {
            PostTask.postTask(taskTraits, task);
        }
    }

    public static boolean canRunTaskImmediately(int taskTraits) {
        if (PostTask.isUiTaskTraits(taskTraits)) {
            return ThreadUtils.runningOnUiThread();
        }
        return false;
    }

    public static <T> T runSynchronously(int taskTraits, Callable<T> c) {
        return PostTask.runSynchronouslyInternal(taskTraits, new FutureTask<T>(c));
    }

    public static void runSynchronously(int taskTraits, Runnable r) {
        PostTask.runSynchronouslyInternal(taskTraits, new FutureTask<Object>(r, null));
    }

    private static <T> T runSynchronouslyInternal(int taskTraits, FutureTask<T> task) {
        FutureTask<T> r = ENABLE_TASK_ORIGINS ? PostTask.populateTaskOrigin(null, task) : task;
        PostTask.runOrPostTask(taskTraits, r);
        try {
            return task.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public static void setPrenativeThreadPoolExecutorForTesting(Executor executor) {
        sPrenativeThreadPoolExecutorForTesting = executor;
        ResettersForTesting.register(() -> {
            sPrenativeThreadPoolExecutorForTesting = null;
        });
    }

    static Executor getPrenativeThreadPoolExecutor() {
        if (sPrenativeThreadPoolExecutorForTesting != null) {
            return sPrenativeThreadPoolExecutorForTesting;
        }
        return sPrenativeThreadPoolExecutor;
    }

    @Nullable
    public static Exception getTaskOrigin() {
        return ENABLE_TASK_ORIGINS ? (Exception)sTaskOrigin.get() : null;
    }

    public static <T extends Throwable> T maybeAddTaskOrigin(T exception) {
        Exception taskOrigin = PostTask.getTaskOrigin();
        if (taskOrigin != null) {
            Object t = exception;
            while (t.getCause() != null) {
                t = t.getCause();
                assert (!(t instanceof TaskOriginException)) : "Already wrapped: " + Log.getStackTraceString(exception);
            }
            try {
                t.initCause(taskOrigin);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return exception;
    }

    static Runnable populateTaskOrigin(@Nullable TaskOriginException taskOrigin, Runnable origTask) {
        if (origTask instanceof TaskOriginRunnable) {
            return origTask;
        }
        return new TaskOriginRunnable(taskOrigin, origTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean registerPreNativeTaskRunner(TaskRunnerImpl taskRunner) {
        Object object = sPreNativeTaskRunnerLock;
        synchronized (object) {
            if (sPreNativeTaskRunners == null) {
                return false;
            }
            sPreNativeTaskRunners.add(taskRunner);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private static void onNativeSchedulerReady() {
        List<TaskRunnerImpl> preNativeTaskRunners;
        if (sNativeInitialized) {
            return;
        }
        sNativeInitialized = true;
        Iterator<TaskRunnerImpl> iterator = sPreNativeTaskRunnerLock;
        synchronized (iterator) {
            preNativeTaskRunners = sPreNativeTaskRunners;
            sPreNativeTaskRunners = null;
        }
        for (TaskRunnerImpl taskRunner : preNativeTaskRunners) {
            taskRunner.initNativeTaskRunner();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushJobsAndResetForTesting() throws InterruptedException {
        ChromeThreadPoolExecutor executor = sPrenativeThreadPoolExecutor;
        int taskCount = executor.getQueue().size() + executor.getActiveCount();
        if (taskCount > 0) {
            executor.shutdownNow();
            executor.awaitTermination(1L, TimeUnit.SECONDS);
            sPrenativeThreadPoolExecutor = new ChromeThreadPoolExecutor();
        }
        Object object = sPreNativeTaskRunnerLock;
        synchronized (object) {
            if (sPreNativeTaskRunners != null) {
                for (TaskRunnerImpl taskRunner : sPreNativeTaskRunners) {
                    taskCount += taskRunner.clearTaskQueueForTesting();
                }
            }
            ++sTestIterationForTesting;
        }
        sPrenativeThreadPoolExecutorForTesting = null;
        if (taskCount > 0) {
            Log.w(TAG, "%d background task(s) existed after test finished.", (Object)taskCount);
        }
    }

    public static void resetUiThreadForTesting() {
        assert (!sNativeInitialized);
    }

    static {
        int i;
        ENABLE_TASK_ORIGINS = BuildConfig.ENABLE_ASSERTS;
        sPreNativeTaskRunnerLock = new Object();
        sPreNativeTaskRunners = new ArrayList<TaskRunnerImpl>();
        sPrenativeThreadPoolExecutor = new ChromeThreadPoolExecutor();
        sTaskOrigin = ENABLE_TASK_ORIGINS ? new ThreadLocal() : null;
        sTraitsToRunnerMap = new TaskRunner[9];
        for (i = 0; i <= 5; ++i) {
            PostTask.sTraitsToRunnerMap[i] = new TaskRunnerImpl(i);
        }
        for (i = 6; i <= 8; ++i) {
            PostTask.sTraitsToRunnerMap[i] = new UiThreadTaskRunnerImpl(i);
        }
    }

    private static class TaskOriginRunnable
    implements Runnable {
        @Nullable
        private final TaskOriginException mTaskOrigin;
        private final Runnable mWrappedRunnable;

        TaskOriginRunnable(@Nullable TaskOriginException taskOrigin, Runnable wrappedRunnable) {
            this.mTaskOrigin = taskOrigin;
            this.mWrappedRunnable = wrappedRunnable;
        }

        @Override
        public void run() {
            sTaskOrigin.set(this.mTaskOrigin);
            try {
                this.mWrappedRunnable.run();
            }
            catch (Throwable t) {
                JavaUtils.throwUnchecked(PostTask.maybeAddTaskOrigin(t));
            }
            finally {
                sTaskOrigin.remove();
            }
        }
    }
}

