/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.base.metrics;

import android.net.connectivity.org.chromium.base.metrics.HistogramBucket;
import android.net.connectivity.org.chromium.base.metrics.UmaRecorderHolder;
import java.util.List;

public class RecordHistogram {
    public static void recordBooleanHistogram(String name, boolean sample) {
        UmaRecorderHolder.get().recordBooleanHistogram(name, sample);
    }

    public static void recordEnumeratedHistogram(String name, int sample, int max) {
        RecordHistogram.recordExactLinearHistogram(name, sample, max);
    }

    public static void recordCount1MHistogram(String name, int sample) {
        UmaRecorderHolder.get().recordExponentialHistogram(name, sample, 1, 1000000, 50);
    }

    public static void recordCount100Histogram(String name, int sample) {
        UmaRecorderHolder.get().recordExponentialHistogram(name, sample, 1, 100, 50);
    }

    public static void recordCount1000Histogram(String name, int sample) {
        UmaRecorderHolder.get().recordExponentialHistogram(name, sample, 1, 1000, 50);
    }

    public static void recordCount100000Histogram(String name, int sample) {
        UmaRecorderHolder.get().recordExponentialHistogram(name, sample, 1, 100000, 50);
    }

    public static void recordCustomCountHistogram(String name, int sample, int min, int max, int numBuckets) {
        UmaRecorderHolder.get().recordExponentialHistogram(name, sample, min, max, numBuckets);
    }

    public static void recordLinearCountHistogram(String name, int sample, int min, int max, int numBuckets) {
        UmaRecorderHolder.get().recordLinearHistogram(name, sample, min, max, numBuckets);
    }

    public static void recordPercentageHistogram(String name, int sample) {
        RecordHistogram.recordExactLinearHistogram(name, sample, 101);
    }

    public static void recordSparseHistogram(String name, int sample) {
        UmaRecorderHolder.get().recordSparseHistogram(name, sample);
    }

    public static void recordTimesHistogram(String name, long durationMs) {
        RecordHistogram.recordCustomTimesHistogramMilliseconds(name, durationMs, 1L, 10000L, 50);
    }

    public static void recordMediumTimesHistogram(String name, long durationMs) {
        RecordHistogram.recordCustomTimesHistogramMilliseconds(name, durationMs, 1L, 180000L, 50);
    }

    @Deprecated
    public static void deprecatedRecordMediumTimesHistogram(String name, long durationMs) {
        RecordHistogram.recordCustomTimesHistogramMilliseconds(name, durationMs, 10L, 180000L, 50);
    }

    public static void recordLongTimesHistogram(String name, long durationMs) {
        RecordHistogram.recordCustomTimesHistogramMilliseconds(name, durationMs, 1L, 3600000L, 50);
    }

    public static void recordLongTimesHistogram100(String name, long durationMs) {
        RecordHistogram.recordCustomTimesHistogramMilliseconds(name, durationMs, 1L, 3600000L, 100);
    }

    public static void recordCustomTimesHistogram(String name, long durationMs, long min, long max, int numBuckets) {
        RecordHistogram.recordCustomTimesHistogramMilliseconds(name, durationMs, min, max, numBuckets);
    }

    public static void recordMemoryKBHistogram(String name, int sizeInKB) {
        UmaRecorderHolder.get().recordExponentialHistogram(name, sizeInKB, 1000, 500000, 50);
    }

    public static void recordMemoryMediumMBHistogram(String name, int sizeInMB) {
        UmaRecorderHolder.get().recordExponentialHistogram(name, sizeInMB, 1, 4000, 100);
    }

    public static void recordExactLinearHistogram(String name, int sample, int max) {
        boolean min = true;
        int numBuckets = max + 1;
        UmaRecorderHolder.get().recordLinearHistogram(name, sample, 1, max, numBuckets);
    }

    private static int clampToInt(long value) {
        if (value > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (value < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)value;
    }

    private static void recordCustomTimesHistogramMilliseconds(String name, long duration, long min, long max, int numBuckets) {
        UmaRecorderHolder.get().recordExponentialHistogram(name, RecordHistogram.clampToInt(duration), RecordHistogram.clampToInt(min), RecordHistogram.clampToInt(max), numBuckets);
    }

    @Deprecated
    public static int getHistogramValueCountForTesting(String name, int sample) {
        return UmaRecorderHolder.get().getHistogramValueCountForTesting(name, sample);
    }

    @Deprecated
    public static int getHistogramTotalCountForTesting(String name) {
        return UmaRecorderHolder.get().getHistogramTotalCountForTesting(name);
    }

    public static List<HistogramBucket> getHistogramSamplesForTesting(String name) {
        return UmaRecorderHolder.get().getHistogramSamplesForTesting(name);
    }
}

