/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.base;

import android.net.connectivity.org.chromium.base.ResettersForTesting;
import android.net.connectivity.org.chromium.base.TraceEvent;
import android.net.connectivity.org.chromium.base.task.PostTask;
import android.net.connectivity.org.chromium.build.BuildConfig;
import android.net.connectivity.org.jni_zero.CalledByNative;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public class ThreadUtils {
    private static final Object sLock = new Object();
    private static volatile boolean sWillOverride;
    private static volatile Handler sUiThreadHandler;
    private static Throwable sUiThreadInitializer;
    private static boolean sThreadAssertsDisabledForTesting;
    private static Thread sInstrumentationThreadForTesting;

    public static void setWillOverrideUiThread() {
        sWillOverride = true;
        if (BuildConfig.ENABLE_ASSERTS && sUiThreadHandler != null) {
            throw new AssertionError("UI Thread already set", sUiThreadInitializer);
        }
    }

    public static void clearUiThreadForTesting() {
        sWillOverride = false;
        PostTask.resetUiThreadForTesting();
        sUiThreadHandler = null;
        sUiThreadInitializer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUiThread(Looper looper) {
        assert (looper != null);
        Object object = sLock;
        synchronized (object) {
            if (sUiThreadHandler == null) {
                Handler uiThreadHandler;
                if (BuildConfig.ENABLE_ASSERTS) {
                    sUiThreadInitializer = new Throwable("This is who set sUiThreadHandler.");
                }
                sUiThreadHandler = uiThreadHandler = new Handler(looper);
                TraceEvent.onUiThreadReady();
            } else if (sUiThreadHandler.getLooper() != looper) {
                RuntimeException exception = new RuntimeException("UI thread looper is already set to " + sUiThreadHandler.getLooper() + " (Main thread looper is " + Looper.getMainLooper() + "), cannot set to new looper " + looper);
                if (BuildConfig.ENABLE_ASSERTS) {
                    exception.initCause(sUiThreadInitializer);
                }
                throw exception;
            }
        }
    }

    public static void recordInstrumentationThreadForTesting() {
        assert (sInstrumentationThreadForTesting == null);
        assert (Looper.getMainLooper() != Looper.myLooper());
        sInstrumentationThreadForTesting = Thread.currentThread();
    }

    public static Handler getUiThreadHandler() {
        if (sUiThreadHandler != null) {
            return sUiThreadHandler;
        }
        if (sWillOverride) {
            throw new RuntimeException("Did not yet override the UI thread");
        }
        ThreadUtils.setUiThread(Looper.getMainLooper());
        return sUiThreadHandler;
    }

    public static void runOnUiThreadBlocking(Runnable r) {
        PostTask.runSynchronously(7, r);
    }

    public static <T> T runOnUiThreadBlocking(Callable<T> c) {
        return PostTask.runSynchronously(7, c);
    }

    public static <T> FutureTask<T> runOnUiThread(FutureTask<T> task) {
        PostTask.runOrPostTask(7, task);
        return task;
    }

    public static void runOnUiThread(Runnable r) {
        PostTask.runOrPostTask(7, r);
    }

    public static <T> FutureTask<T> postOnUiThread(FutureTask<T> task) {
        PostTask.postTask(7, task);
        return task;
    }

    public static void postOnUiThread(Runnable r) {
        PostTask.postTask(7, r);
    }

    public static void postOnUiThreadDelayed(Runnable r, long delayMillis) {
        PostTask.postDelayedTask(7, r, delayMillis);
    }

    public static void assertOnUiThread() {
        if (sThreadAssertsDisabledForTesting) {
            return;
        }
        assert (ThreadUtils.runningOnUiThread()) : "Must be called on the UI thread.";
    }

    public static void checkUiThread() {
        if (!sThreadAssertsDisabledForTesting && !ThreadUtils.runningOnUiThread()) {
            throw new IllegalStateException("Must be called on the UI thread.");
        }
    }

    public static void assertOnBackgroundThread() {
        if (sThreadAssertsDisabledForTesting) {
            return;
        }
        assert (!ThreadUtils.runningOnUiThread()) : "Must be called on a thread other than UI.";
    }

    public static void hasSubtleSideEffectsSetThreadAssertsDisabledForTesting(boolean disabled) {
        sThreadAssertsDisabledForTesting = disabled;
        ResettersForTesting.register(() -> {
            sThreadAssertsDisabledForTesting = false;
        });
    }

    @Deprecated
    public static void setThreadAssertsDisabledForTesting(boolean disabled) {
        sThreadAssertsDisabledForTesting = disabled;
        ResettersForTesting.register(() -> {
            sThreadAssertsDisabledForTesting = false;
        });
    }

    public static boolean runningOnUiThread() {
        return ThreadUtils.getUiThreadHandler().getLooper() == Looper.myLooper();
    }

    public static boolean runningOnInstrumentationThread() {
        return sInstrumentationThreadForTesting != null && sInstrumentationThreadForTesting == Thread.currentThread();
    }

    public static Looper getUiThreadLooper() {
        return ThreadUtils.getUiThreadHandler().getLooper();
    }

    @CalledByNative
    public static void setThreadPriorityAudio(int tid) {
        Process.setThreadPriority(tid, -16);
    }

    @CalledByNative
    private static boolean isThreadPriorityAudio(int tid) {
        return Process.getThreadPriority(tid) == -16;
    }

    public static class ThreadChecker {
        private Thread mThread;

        public ThreadChecker() {
            this.resetThreadId();
        }

        public void resetThreadId() {
            if (BuildConfig.ENABLE_ASSERTS) {
                this.mThread = Thread.currentThread();
            }
        }

        public void assertOnValidThread() {
            this.assertOnValidThreadHelper(false);
        }

        public void assertOnValidOrInstrumentationThread() {
            this.assertOnValidThreadHelper(true);
        }

        private void assertOnValidThreadHelper(boolean allowInstrThread) {
            if (BuildConfig.ENABLE_ASSERTS && !sThreadAssertsDisabledForTesting) {
                Thread curThread = Thread.currentThread();
                if (curThread == this.mThread || allowInstrThread && curThread == sInstrumentationThreadForTesting) {
                    return;
                }
                Thread uiThread = ThreadUtils.getUiThreadLooper().getThread();
                if (curThread == uiThread) {
                    assert (false) : "Background-only class called from UI thread (expected: " + this.mThread + ")";
                } else if (this.mThread == uiThread) assert (false) : "UI-only class called from background thread: " + curThread;
                assert (false) : "Method called from wrong background thread. Expected: " + this.mThread + " Actual: " + curThread;
            }
        }
    }
}

