/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.base;

import android.net.connectivity.javax.annotation.concurrent.NotThreadSafe;
import android.net.connectivity.org.chromium.base.ThreadUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

@NotThreadSafe
public class ObserverList<E>
implements Iterable<E> {
    public final List<E> mObservers = new ArrayList();
    private final ThreadUtils.ThreadChecker mThreadChecker = new ThreadUtils.ThreadChecker();
    private int mIterationDepth;
    private int mCount;
    private boolean mNeedsCompact;
    private boolean mEnableThreadAsserts = true;

    public void disableThreadAsserts() {
        this.mEnableThreadAsserts = false;
    }

    public boolean addObserver(E obs) {
        if (this.mEnableThreadAsserts) {
            this.mThreadChecker.assertOnValidThread();
        }
        if (obs == null || this.mObservers.contains(obs)) {
            return false;
        }
        boolean result = this.mObservers.add(obs);
        assert (result);
        ++this.mCount;
        return true;
    }

    public boolean removeObserver(E obs) {
        if (this.mEnableThreadAsserts) {
            this.mThreadChecker.assertOnValidThread();
        }
        if (obs == null) {
            return false;
        }
        int index = this.mObservers.indexOf(obs);
        if (index == -1) {
            return false;
        }
        if (this.mIterationDepth == 0) {
            this.mObservers.remove(index);
        } else {
            this.mNeedsCompact = true;
            this.mObservers.set(index, null);
        }
        --this.mCount;
        assert (this.mCount >= 0);
        return true;
    }

    public boolean hasObserver(E obs) {
        if (this.mEnableThreadAsserts) {
            this.mThreadChecker.assertOnValidThread();
        }
        return this.mObservers.contains(obs);
    }

    public void clear() {
        if (this.mEnableThreadAsserts) {
            this.mThreadChecker.assertOnValidThread();
        }
        this.mCount = 0;
        if (this.mIterationDepth == 0) {
            this.mObservers.clear();
            return;
        }
        int size = this.mObservers.size();
        this.mNeedsCompact |= size != 0;
        for (int i = 0; i < size; ++i) {
            this.mObservers.set(i, null);
        }
    }

    @Override
    public Iterator<E> iterator() {
        if (this.mEnableThreadAsserts) {
            this.mThreadChecker.assertOnValidThread();
        }
        return new ObserverListIterator();
    }

    public RewindableIterator<E> rewindableIterator() {
        if (this.mEnableThreadAsserts) {
            this.mThreadChecker.assertOnValidThread();
        }
        return new ObserverListIterator();
    }

    public int size() {
        if (this.mEnableThreadAsserts) {
            this.mThreadChecker.assertOnValidThread();
        }
        return this.mCount;
    }

    public boolean isEmpty() {
        if (this.mEnableThreadAsserts) {
            this.mThreadChecker.assertOnValidThread();
        }
        return this.mCount == 0;
    }

    private void compact() {
        assert (this.mIterationDepth == 0);
        for (int i = this.mObservers.size() - 1; i >= 0; --i) {
            if (this.mObservers.get(i) != null) continue;
            this.mObservers.remove(i);
        }
    }

    private void incrementIterationDepth() {
        ++this.mIterationDepth;
    }

    private void decrementIterationDepthAndCompactIfNeeded() {
        --this.mIterationDepth;
        assert (this.mIterationDepth >= 0);
        if (this.mIterationDepth > 0) {
            return;
        }
        if (!this.mNeedsCompact) {
            return;
        }
        this.mNeedsCompact = false;
        this.compact();
    }

    private int capacity() {
        return this.mObservers.size();
    }

    private E getObserverAt(int index) {
        return this.mObservers.get(index);
    }

    private class ObserverListIterator
    implements RewindableIterator<E> {
        private int mListEndMarker;
        private int mIndex;
        private boolean mIsExhausted;

        private ObserverListIterator() {
            ObserverList.this.incrementIterationDepth();
            this.mListEndMarker = ObserverList.this.capacity();
        }

        @Override
        public void rewind() {
            if (ObserverList.this.mEnableThreadAsserts) {
                ObserverList.this.mThreadChecker.assertOnValidThread();
            }
            this.compactListIfNeeded();
            ObserverList.this.incrementIterationDepth();
            this.mListEndMarker = ObserverList.this.capacity();
            this.mIsExhausted = false;
            this.mIndex = 0;
        }

        @Override
        public boolean hasNext() {
            int lookupIndex;
            if (ObserverList.this.mEnableThreadAsserts) {
                ObserverList.this.mThreadChecker.assertOnValidThread();
            }
            for (lookupIndex = this.mIndex; lookupIndex < this.mListEndMarker && ObserverList.this.getObserverAt(lookupIndex) == null; ++lookupIndex) {
            }
            if (lookupIndex < this.mListEndMarker) {
                return true;
            }
            this.compactListIfNeeded();
            return false;
        }

        @Override
        public E next() {
            if (ObserverList.this.mEnableThreadAsserts) {
                ObserverList.this.mThreadChecker.assertOnValidThread();
            }
            while (this.mIndex < this.mListEndMarker && ObserverList.this.getObserverAt(this.mIndex) == null) {
                ++this.mIndex;
            }
            if (this.mIndex < this.mListEndMarker) {
                return ObserverList.this.getObserverAt(this.mIndex++);
            }
            this.compactListIfNeeded();
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void compactListIfNeeded() {
            if (!this.mIsExhausted) {
                this.mIsExhausted = true;
                ObserverList.this.decrementIterationDepthAndCompactIfNeeded();
            }
        }
    }

    public static interface RewindableIterator<E>
    extends Iterator<E> {
        public void rewind();
    }
}

