/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.base;

import android.net.connectivity.javax.annotation.concurrent.GuardedBy;
import android.net.connectivity.org.chromium.base.CommandLine;
import android.net.connectivity.org.chromium.base.ContextUtils;
import android.net.connectivity.org.chromium.base.EarlyTraceEventJni;
import android.net.connectivity.org.chromium.base.StrictModeContext;
import android.net.connectivity.org.chromium.base.ThreadUtils;
import android.net.connectivity.org.chromium.base.TraceEventJni;
import android.net.connectivity.org.jni_zero.CalledByNative;
import android.net.connectivity.org.jni_zero.JNINamespace;
import android.os.Process;
import android.os.StrictMode;
import android.os.SystemClock;
import com.android.internal.lang.System_Delegate;
import com.android.layoutlib.androidx.annotation.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

@JNINamespace(value="base::android")
public class EarlyTraceEvent {
    @VisibleForTesting
    static final int STATE_DISABLED = 0;
    @VisibleForTesting
    static final int STATE_ENABLED = 1;
    @VisibleForTesting
    static final int STATE_FINISHED = 2;
    @VisibleForTesting
    static volatile int sState = 0;
    private static volatile boolean sEnabledInChildProcessBeforeCommandLine;
    private static final String BACKGROUND_STARTUP_TRACING_ENABLED_KEY = "bg_startup_tracing";
    private static boolean sCachedBackgroundStartupTracingFlag;
    private static final String TRACE_CONFIG_FILENAME = "/data/local/chrome-trace-config.json";
    private static final String TRACE_STARTUP_SWITCH = "trace-startup";
    public static final String TRACE_EARLY_JAVA_IN_CHILD_SWITCH = "trace-early-java-in-child";
    @VisibleForTesting
    static final Object sLock;
    @GuardedBy(value="sLock")
    @VisibleForTesting
    static List<Event> sEvents;
    @GuardedBy(value="sLock")
    @VisibleForTesting
    static List<AsyncEvent> sAsyncEvents;
    @GuardedBy(value="sLock")
    @VisibleForTesting
    static final List<ActivityStartupEvent> sActivityStartupEvents;
    @GuardedBy(value="sLock")
    @VisibleForTesting
    static final List<ActivityLaunchCauseEvent> sActivityLaunchCauseEvents;

    static void maybeEnableInBrowserProcess() {
        ThreadUtils.assertOnUiThread();
        assert (!sEnabledInChildProcessBeforeCommandLine) : "Should not have been initialized in a child process";
        if (sState != 0) {
            return;
        }
        boolean shouldEnable = false;
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
        try {
            if (CommandLine.getInstance().hasSwitch(TRACE_STARTUP_SWITCH)) {
                shouldEnable = true;
            } else {
                try {
                    shouldEnable = new File(TRACE_CONFIG_FILENAME).exists();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            if (ContextUtils.getAppSharedPreferences().getBoolean(BACKGROUND_STARTUP_TRACING_ENABLED_KEY, false)) {
                if (shouldEnable) {
                    EarlyTraceEvent.setBackgroundStartupTracingFlag(false);
                    sCachedBackgroundStartupTracingFlag = false;
                } else {
                    sCachedBackgroundStartupTracingFlag = true;
                    shouldEnable = true;
                }
            }
        }
        finally {
            StrictMode.setThreadPolicy(oldPolicy);
        }
        if (shouldEnable) {
            EarlyTraceEvent.enable();
        }
    }

    public static void earlyEnableInChildWithoutCommandLine() {
        sEnabledInChildProcessBeforeCommandLine = true;
        assert (sState == 0);
        EarlyTraceEvent.enable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onCommandLineAvailableInChildProcess() {
        if (!sEnabledInChildProcessBeforeCommandLine) {
            return;
        }
        Object object = sLock;
        synchronized (object) {
            if (!CommandLine.getInstance().hasSwitch(TRACE_EARLY_JAVA_IN_CHILD_SWITCH)) {
                EarlyTraceEvent.reset();
                return;
            }
            if (sState == 0) {
                EarlyTraceEvent.enable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void enable() {
        Object object = sLock;
        synchronized (object) {
            if (sState != 0) {
                return;
            }
            sEvents = new ArrayList<Event>();
            sAsyncEvents = new ArrayList<AsyncEvent>();
            sState = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disable() {
        Object object = sLock;
        synchronized (object) {
            if (!EarlyTraceEvent.enabled()) {
                return;
            }
            if (!sEvents.isEmpty()) {
                EarlyTraceEvent.dumpEvents(sEvents);
                sEvents.clear();
            }
            if (!sAsyncEvents.isEmpty()) {
                EarlyTraceEvent.dumpAsyncEvents(sAsyncEvents);
                sAsyncEvents.clear();
            }
            sState = 2;
            sEvents = null;
            sAsyncEvents = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static void reset() {
        Object object = sLock;
        synchronized (object) {
            sState = 0;
            sEvents = null;
            sAsyncEvents = null;
        }
    }

    static boolean enabled() {
        return sState == 1;
    }

    @CalledByNative
    static void setBackgroundStartupTracingFlag(boolean enabled) {
        try (StrictModeContext ignored = StrictModeContext.allowDiskWrites();){
            ContextUtils.getAppSharedPreferences().edit().putBoolean(BACKGROUND_STARTUP_TRACING_ENABLED_KEY, enabled).apply();
        }
    }

    @CalledByNative
    public static boolean getBackgroundStartupTracingFlag() {
        return sCachedBackgroundStartupTracingFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void begin(String name, boolean isToplevel) {
        if (!EarlyTraceEvent.enabled()) {
            return;
        }
        Event event = new Event(name, true, isToplevel);
        Object object = sLock;
        synchronized (object) {
            if (!EarlyTraceEvent.enabled()) {
                return;
            }
            sEvents.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void end(String name, boolean isToplevel) {
        if (!EarlyTraceEvent.enabled()) {
            return;
        }
        Event event = new Event(name, false, isToplevel);
        Object object = sLock;
        synchronized (object) {
            if (!EarlyTraceEvent.enabled()) {
                return;
            }
            sEvents.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startAsync(String name, long id2) {
        if (!EarlyTraceEvent.enabled()) {
            return;
        }
        AsyncEvent event = new AsyncEvent(name, id2, true);
        Object object = sLock;
        synchronized (object) {
            if (!EarlyTraceEvent.enabled()) {
                return;
            }
            sAsyncEvents.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finishAsync(String name, long id2) {
        if (!EarlyTraceEvent.enabled()) {
            return;
        }
        AsyncEvent event = new AsyncEvent(name, id2, false);
        Object object = sLock;
        synchronized (object) {
            if (!EarlyTraceEvent.enabled()) {
                return;
            }
            sAsyncEvents.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startupActivityStart(long activityId, long startTimeMs) {
        ActivityStartupEvent event = new ActivityStartupEvent(activityId, startTimeMs);
        Object object = sLock;
        synchronized (object) {
            sActivityStartupEvents.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startupLaunchCause(long activityId, int launchCause) {
        ActivityLaunchCauseEvent event = new ActivityLaunchCauseEvent(activityId, launchCause);
        Object object = sLock;
        synchronized (object) {
            sActivityLaunchCauseEvents.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<Event> getMatchingCompletedEventsForTesting(String eventName) {
        Object object = sLock;
        synchronized (object) {
            ArrayList<Event> matchingEvents = new ArrayList<Event>();
            for (Event evt : sEvents) {
                if (!evt.mName.equals(eventName)) continue;
                matchingEvents.add(evt);
            }
            return matchingEvents;
        }
    }

    private static void dumpEvents(List<Event> events) {
        for (Event e : events) {
            if (e.mIsStart) {
                if (e.mIsToplevel) {
                    EarlyTraceEventJni.get().recordEarlyToplevelBeginEvent(e.mName, e.mTimeNanos, e.mThreadId, e.mThreadTimeMillis);
                    continue;
                }
                EarlyTraceEventJni.get().recordEarlyBeginEvent(e.mName, e.mTimeNanos, e.mThreadId, e.mThreadTimeMillis);
                continue;
            }
            if (e.mIsToplevel) {
                EarlyTraceEventJni.get().recordEarlyToplevelEndEvent(e.mName, e.mTimeNanos, e.mThreadId, e.mThreadTimeMillis);
                continue;
            }
            EarlyTraceEventJni.get().recordEarlyEndEvent(e.mName, e.mTimeNanos, e.mThreadId, e.mThreadTimeMillis);
        }
    }

    private static void dumpAsyncEvents(List<AsyncEvent> events) {
        for (AsyncEvent e : events) {
            if (e.mIsStart) {
                EarlyTraceEventJni.get().recordEarlyAsyncBeginEvent(e.mName, e.mId, e.mTimeNanos);
                continue;
            }
            EarlyTraceEventJni.get().recordEarlyAsyncEndEvent(e.mId, e.mTimeNanos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpActivityStartupEvents() {
        Object object = sLock;
        synchronized (object) {
            if (!sActivityStartupEvents.isEmpty()) {
                for (ActivityStartupEvent activityStartupEvent : sActivityStartupEvents) {
                    TraceEventJni.get().startupActivityStart(activityStartupEvent.mId, activityStartupEvent.mTimeMs);
                }
                sActivityStartupEvents.clear();
            }
            if (!sActivityLaunchCauseEvents.isEmpty()) {
                for (ActivityLaunchCauseEvent activityLaunchCauseEvent : sActivityLaunchCauseEvents) {
                    TraceEventJni.get().startupLaunchCause(activityLaunchCauseEvent.mId, activityLaunchCauseEvent.mTimeMs, activityLaunchCauseEvent.mLaunchCause);
                }
                sActivityLaunchCauseEvents.clear();
            }
        }
    }

    static {
        sLock = new Object();
        sActivityStartupEvents = new ArrayList<ActivityStartupEvent>();
        sActivityLaunchCauseEvents = new ArrayList<ActivityLaunchCauseEvent>();
    }

    @VisibleForTesting
    static class Event {
        final boolean mIsStart;
        final boolean mIsToplevel;
        final String mName;
        final int mThreadId;
        final long mTimeNanos;
        final long mThreadTimeMillis;

        Event(String name, boolean isStart, boolean isToplevel) {
            this.mIsStart = isStart;
            this.mIsToplevel = isToplevel;
            this.mName = name;
            this.mThreadId = Process.myTid();
            this.mTimeNanos = System_Delegate.nanoTime();
            this.mThreadTimeMillis = SystemClock.currentThreadTimeMillis();
        }
    }

    @VisibleForTesting
    static class AsyncEvent {
        final boolean mIsStart;
        final String mName;
        final long mId;
        final long mTimeNanos;

        AsyncEvent(String name, long id2, boolean isStart) {
            this.mName = name;
            this.mId = id2;
            this.mIsStart = isStart;
            this.mTimeNanos = System_Delegate.nanoTime();
        }
    }

    @VisibleForTesting
    static class ActivityStartupEvent {
        final long mId;
        final long mTimeMs;

        ActivityStartupEvent(long id2, long timeMs) {
            this.mId = id2;
            this.mTimeMs = timeMs;
        }
    }

    @VisibleForTesting
    static class ActivityLaunchCauseEvent {
        final long mId;
        final long mTimeMs;
        final int mLaunchCause;

        ActivityLaunchCauseEvent(long id2, int launchCause) {
            this.mId = id2;
            this.mTimeMs = SystemClock.uptimeMillis();
            this.mLaunchCause = launchCause;
        }
    }

    static interface Natives {
        public void recordEarlyBeginEvent(String var1, long var2, int var4, long var5);

        public void recordEarlyEndEvent(String var1, long var2, int var4, long var5);

        public void recordEarlyToplevelBeginEvent(String var1, long var2, int var4, long var5);

        public void recordEarlyToplevelEndEvent(String var1, long var2, int var4, long var5);

        public void recordEarlyAsyncBeginEvent(String var1, long var2, long var4);

        public void recordEarlyAsyncEndEvent(long var1, long var3);
    }
}

