/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.base;

import android.app.Activity;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.net.connectivity.org.chromium.base.JavaUtils;
import android.net.connectivity.org.chromium.base.ResettersForTesting;
import android.net.connectivity.org.chromium.base.StrictModeContext;
import android.net.connectivity.org.chromium.build.BuildConfig;
import android.net.connectivity.org.jni_zero.JNINamespace;
import android.os.Handler;
import android.os.Process;
import android.os._Original_Build;
import android.preference.PreferenceManager;
import com.android.layoutlib.androidx.annotation.Nullable;

@JNINamespace(value="base::android")
public class ContextUtils {
    private static final String TAG = "ContextUtils";
    private static Context sApplicationContext;
    public static final int RECEIVER_EXPORTED = 2;
    public static final int RECEIVER_NOT_EXPORTED = 4;

    public static Context getApplicationContext() {
        return sApplicationContext;
    }

    public static void initApplicationContext(Context appContext) {
        assert (sApplicationContext == null || sApplicationContext == appContext || ((ContextWrapper)sApplicationContext).getBaseContext() == appContext);
        ContextUtils.initJavaSideApplicationContext(appContext);
    }

    private static SharedPreferences fetchAppSharedPreferences() {
        try (StrictModeContext ignored = StrictModeContext.allowDiskWrites();){
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences(sApplicationContext);
            return sharedPreferences;
        }
    }

    public static SharedPreferences getAppSharedPreferences() {
        return Holder.sSharedPreferences;
    }

    public static void initApplicationContextForTests(Context appContext) {
        Context prevValue = sApplicationContext;
        ContextUtils.initJavaSideApplicationContext(appContext);
        SharedPreferences prevPrefs = Holder.sSharedPreferences;
        Holder.sSharedPreferences = ContextUtils.fetchAppSharedPreferences();
        ResettersForTesting.register(() -> {
            sApplicationContext = prevValue;
            Holder.sSharedPreferences = prevPrefs;
        });
    }

    private static void initJavaSideApplicationContext(Context appContext) {
        assert (appContext != null);
        if (BuildConfig.ENABLE_ASSERTS && appContext instanceof Application) {
            appContext = new ContextWrapper(appContext);
        }
        sApplicationContext = appContext;
    }

    public static boolean isIsolatedProcess() {
        return Process.isIsolated();
    }

    public static boolean isSdkSandboxProcess() {
        if (_Original_Build.VERSION.SDK_INT >= 33) {
            return Process.isSdkSandbox();
        }
        return false;
    }

    public static String getProcessName() {
        if (_Original_Build.VERSION.SDK_INT >= 28) {
            return Application.getProcessName();
        }
        try {
            Class<?> activityThreadClazz = Class.forName("android.app.ActivityThread");
            return (String)activityThreadClazz.getMethod("currentProcessName", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw JavaUtils.throwUnchecked(e);
        }
    }

    public static boolean isProcess64Bit() {
        return Process.is64Bit();
    }

    @Nullable
    public static Activity activityFromContext(@Nullable Context context) {
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }

    public static Intent registerProtectedBroadcastReceiver(Context context, BroadcastReceiver receiver, IntentFilter filter) {
        return ContextUtils.registerBroadcastReceiver(context, receiver, filter, null, null, 0);
    }

    public static Intent registerProtectedBroadcastReceiver(Context context, BroadcastReceiver receiver, IntentFilter filter, Handler scheduler) {
        return ContextUtils.registerBroadcastReceiver(context, receiver, filter, null, scheduler, 0);
    }

    public static Intent registerExportedBroadcastReceiver(Context context, BroadcastReceiver receiver, IntentFilter filter, String permission2) {
        return ContextUtils.registerBroadcastReceiver(context, receiver, filter, permission2, null, 2);
    }

    public static Intent registerNonExportedBroadcastReceiver(Context context, BroadcastReceiver receiver, IntentFilter filter) {
        return ContextUtils.registerBroadcastReceiver(context, receiver, filter, null, null, 4);
    }

    public static Intent registerNonExportedBroadcastReceiver(Context context, BroadcastReceiver receiver, IntentFilter filter, Handler scheduler) {
        return ContextUtils.registerBroadcastReceiver(context, receiver, filter, null, scheduler, 4);
    }

    private static Intent registerBroadcastReceiver(Context context, BroadcastReceiver receiver, IntentFilter filter, String permission2, Handler scheduler, int flags) {
        if (_Original_Build.VERSION.SDK_INT >= 26) {
            return context.registerReceiver(receiver, filter, permission2, scheduler, flags);
        }
        return context.registerReceiver(receiver, filter, permission2, scheduler);
    }

    private static class Holder {
        private static SharedPreferences sSharedPreferences = ContextUtils.fetchAppSharedPreferences();

        private Holder() {
        }
    }
}

