/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.base;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.ImageDecoder;
import android.graphics.drawable.Drawable;
import android.hardware.display.DisplayManager;
import android.net.Uri;
import android.net.connectivity.org.chromium.base.ContextUtils;
import android.os.StrictMode;
import android.os.UserManager;
import android.os._Original_Build;
import android.provider.MediaStore;
import android.view.Display;
import android.view.View;
import com.android.layoutlib.androidx.annotation.NonNull;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class ApiCompatibilityUtils {
    private static final String TAG = "ApiCompatUtil";

    private ApiCompatibilityUtils() {
    }

    public static byte[] getBytesUtf8(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }

    public static Drawable getDrawable(Resources res, int id2) throws Resources.NotFoundException {
        return ApiCompatibilityUtils.getDrawableForDensity(res, id2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Drawable getDrawableForDensity(Resources res, int id2, int density) {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
        try {
            if (density == 0) {
                Drawable drawable2 = res.getDrawable(id2, null);
                return drawable2;
            }
            Drawable drawable3 = res.getDrawableForDensity(id2, density, null);
            return drawable3;
        }
        finally {
            StrictMode.setThreadPolicy(oldPolicy);
        }
    }

    public static boolean isDemoUser() {
        UserManager userManager = (UserManager)ContextUtils.getApplicationContext().getSystemService("user");
        return userManager.isDemoUser();
    }

    public static int checkPermission(Context context, String permission2, int pid, int uid) {
        try {
            return context.checkPermission(permission2, pid, uid);
        }
        catch (RuntimeException e) {
            return -1;
        }
    }

    @NonNull
    public static List<Integer> getTargetableDisplayIds(Activity activity) {
        if (_Original_Build.VERSION.SDK_INT >= 29) {
            ArrayList<Integer> displayList = new ArrayList<Integer>();
            if (activity == null) {
                return displayList;
            }
            DisplayManager displayManager = (DisplayManager)activity.getSystemService("display");
            if (displayManager == null) {
                return displayList;
            }
            Display[] displays = displayManager.getDisplays();
            ActivityManager am = (ActivityManager)activity.getSystemService("activity");
            for (Display display : displays) {
                if (display.getState() != 2 || !am.isActivityStartAllowedOnDisplay(activity, display.getDisplayId(), new Intent(activity, activity.getClass()))) continue;
                displayList.add(display.getDisplayId());
            }
            return displayList;
        }
        return new ArrayList<Integer>();
    }

    public static void setActivityOptionsBackgroundActivityStartMode(@NonNull ActivityOptions options) {
        if (_Original_Build.VERSION.SDK_INT < 34) {
            return;
        }
        options.setPendingIntentBackgroundActivityStartMode(1);
    }

    public static void setCreatorActivityOptionsBackgroundActivityStartMode(@NonNull ActivityOptions options) {
        if (_Original_Build.VERSION.SDK_INT < 34) {
            return;
        }
        options.setPendingIntentCreatorBackgroundActivityStartMode(1);
    }

    public static void clearHandwritingBoundsOffsetBottom(View view) {
        if (_Original_Build.VERSION.SDK_INT < 34) {
            return;
        }
        try {
            float offsetTop = ((Float)View.class.getMethod("getHandwritingBoundsOffsetTop", new Class[0]).invoke((Object)view, new Object[0])).floatValue();
            float offsetLeft = ((Float)View.class.getMethod("getHandwritingBoundsOffsetLeft", new Class[0]).invoke((Object)view, new Object[0])).floatValue();
            float offsetRight = ((Float)View.class.getMethod("getHandwritingBoundsOffsetRight", new Class[0]).invoke((Object)view, new Object[0])).floatValue();
            Method setHandwritingBoundsOffsets = View.class.getMethod("setHandwritingBoundsOffsets", Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
            setHandwritingBoundsOffsets.invoke((Object)view, Float.valueOf(offsetLeft), Float.valueOf(offsetTop), Float.valueOf(offsetRight), 0);
        }
        catch (IllegalAccessException | NoSuchMethodException | NullPointerException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    public static boolean isRunningInUserTestHarness() {
        if (_Original_Build.VERSION.SDK_INT >= 29) {
            return ActivityManager.isRunningInUserTestHarness();
        }
        return false;
    }

    public static Bitmap getBitmapByUri(ContentResolver cr, Uri uri) throws IOException {
        if (_Original_Build.VERSION.SDK_INT >= 28) {
            return ImageDecoder.decodeBitmap(ImageDecoder.createSource(cr, uri));
        }
        return MediaStore.Images.Media.getBitmap(cr, uri);
    }
}

