/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.android.net.nsd;

import android.net.nsd.OffloadServiceInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IOffloadEngine
extends IInterface {
    public static final String DESCRIPTOR = "android.net.connectivity.android.net.nsd.IOffloadEngine";

    public void onOffloadServiceUpdated(OffloadServiceInfo var1) throws RemoteException;

    public void onOffloadServiceRemoved(OffloadServiceInfo var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IOffloadEngine {
        static final int TRANSACTION_onOffloadServiceUpdated = 1;
        static final int TRANSACTION_onOffloadServiceRemoved = 2;

        public Stub() {
            this.attachInterface(this, IOffloadEngine.DESCRIPTOR);
        }

        public static IOffloadEngine asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IOffloadEngine.DESCRIPTOR);
            if (iin != null && iin instanceof IOffloadEngine) {
                return (IOffloadEngine)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onOffloadServiceUpdated";
                }
                case 2: {
                    return "onOffloadServiceRemoved";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IOffloadEngine.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    OffloadServiceInfo _arg0 = data.readTypedObject(OffloadServiceInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onOffloadServiceUpdated(_arg0);
                    break;
                }
                case 2: {
                    OffloadServiceInfo _arg0 = data.readTypedObject(OffloadServiceInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onOffloadServiceRemoved(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IOffloadEngine {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IOffloadEngine.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onOffloadServiceUpdated(OffloadServiceInfo info) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IOffloadEngine.DESCRIPTOR);
                    _data.writeTypedObject(info, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onOffloadServiceRemoved(OffloadServiceInfo info) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IOffloadEngine.DESCRIPTOR);
                    _data.writeTypedObject(info, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IOffloadEngine {
        @Override
        public void onOffloadServiceUpdated(OffloadServiceInfo info) throws RemoteException {
        }

        @Override
        public void onOffloadServiceRemoved(OffloadServiceInfo info) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

