/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.android.net;

import android.annotation.NonNull;
import android.annotation.RequiresApi;
import android.net.connectivity.android.net.BpfNetMapsUtils;
import android.net.connectivity.android.net.UidOwnerValue;
import android.net.connectivity.com.android.modules.utils.build.SdkLevel;
import android.net.connectivity.com.android.net.module.util.BpfMap;
import android.net.connectivity.com.android.net.module.util.IBpfMap;
import android.net.connectivity.com.android.net.module.util.Struct;
import android.system.ErrnoException;
import com.android.internal.annotations.VisibleForTesting;

@RequiresApi(value=34)
public class NetworkStackBpfNetMaps {
    private static final String TAG = NetworkStackBpfNetMaps.class.getSimpleName();
    private final IBpfMap<Struct.S32, Struct.U32> mConfigurationMap;
    private final IBpfMap<Struct.S32, UidOwnerValue> mUidOwnerMap;
    private final IBpfMap<Struct.S32, Struct.U8> mDataSaverEnabledMap;
    private final Dependencies mDeps;

    @NonNull
    public static NetworkStackBpfNetMaps getInstance() {
        return SingletonHolder.sInstance;
    }

    private NetworkStackBpfNetMaps() {
        this(new Dependencies());
    }

    @VisibleForTesting
    public NetworkStackBpfNetMaps(@NonNull Dependencies deps) {
        if (!SdkLevel.isAtLeastT()) {
            throw new UnsupportedOperationException(NetworkStackBpfNetMaps.class.getSimpleName() + " is not supported below Android T");
        }
        this.mDeps = deps;
        this.mConfigurationMap = this.mDeps.getConfigurationMap();
        this.mUidOwnerMap = this.mDeps.getUidOwnerMap();
        this.mDataSaverEnabledMap = this.mDeps.getDataSaverEnabledMap();
    }

    public boolean isChainEnabled(int chain) {
        return BpfNetMapsUtils.isChainEnabled(this.mConfigurationMap, chain);
    }

    public int getUidRule(int chain, int uid) {
        return BpfNetMapsUtils.getUidRule(this.mUidOwnerMap, chain, uid);
    }

    public boolean isUidNetworkingBlocked(int uid, boolean isNetworkMetered) {
        return BpfNetMapsUtils.isUidNetworkingBlocked(uid, isNetworkMetered, this.mConfigurationMap, this.mUidOwnerMap, this.mDataSaverEnabledMap);
    }

    public boolean getDataSaverEnabled() {
        return BpfNetMapsUtils.getDataSaverEnabled(this.mDataSaverEnabledMap);
    }

    private static class SingletonHolder {
        static final NetworkStackBpfNetMaps sInstance = new NetworkStackBpfNetMaps();

        private SingletonHolder() {
        }
    }

    @VisibleForTesting
    public static class Dependencies {
        public IBpfMap<Struct.S32, Struct.U32> getConfigurationMap() {
            try {
                return new BpfMap<Struct.S32, Struct.U32>("/sys/fs/bpf/netd_shared/map_netd_configuration_map", 8, Struct.S32.class, Struct.U32.class);
            }
            catch (ErrnoException e) {
                throw new IllegalStateException("Cannot open configuration map", e);
            }
        }

        public IBpfMap<Struct.S32, UidOwnerValue> getUidOwnerMap() {
            try {
                return new BpfMap<Struct.S32, UidOwnerValue>("/sys/fs/bpf/netd_shared/map_netd_uid_owner_map", 8, Struct.S32.class, UidOwnerValue.class);
            }
            catch (ErrnoException e) {
                throw new IllegalStateException("Cannot open uid owner map", e);
            }
        }

        public IBpfMap<Struct.S32, Struct.U8> getDataSaverEnabledMap() {
            try {
                return new BpfMap<Struct.S32, Struct.U8>("/sys/fs/bpf/netd_shared/map_netd_data_saver_enabled_map", 8, Struct.S32.class, Struct.U8.class);
            }
            catch (ErrnoException e) {
                throw new IllegalStateException("Cannot open data saver enabled map", e);
            }
        }
    }
}

