/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.content.Context;
import android.net.IIntResultListener;
import android.net.ITetheringConnector;
import android.net.ITetheringEventCallback;
import android.net.IpPrefix;
import android.net.LinkAddress;
import android.net.Network;
import android.net.TetherStatesParcel;
import android.net.TetheredClient;
import android.net.TetheringCallbackStartedParcel;
import android.net.TetheringConfigurationParcel;
import android.net.TetheringInterface;
import android.net.TetheringRequestParcel;
import android.net.http.internal.com.android.modules.utils.build.SdkLevel;
import android.net.wifi.SoftApConfiguration;
import android.os.Bundle;
import android.os.ConditionVariable;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

@SuppressLint(value={"NotCloseable", "UnflaggedApi"})
public class TetheringManager {
    private static final String TAG = TetheringManager.class.getSimpleName();
    private static final int DEFAULT_TIMEOUT_MS = 60000;
    private static final long CONNECTOR_POLL_INTERVAL_MILLIS = 200L;
    @GuardedBy(value={"mConnectorWaitQueue"})
    @Nullable
    private ITetheringConnector mConnector;
    @GuardedBy(value={"mConnectorWaitQueue"})
    @NonNull
    private final List<ConnectorConsumer> mConnectorWaitQueue = new ArrayList<ConnectorConsumer>();
    private final Supplier<IBinder> mConnectorSupplier;
    private final TetheringCallbackInternal mCallback;
    private final Context mContext;
    private final ArrayMap<TetheringEventCallback, ITetheringEventCallback> mTetheringEventCallbacks = new ArrayMap();
    private volatile TetheringConfigurationParcel mTetheringConfiguration;
    private volatile TetherStatesParcel mTetherStatesParcel;
    @Deprecated
    @SystemApi
    public static final String ACTION_TETHER_STATE_CHANGED = "android.net.conn.TETHER_STATE_CHANGED";
    @SystemApi
    public static final String EXTRA_AVAILABLE_TETHER = "availableArray";
    @SystemApi
    public static final String EXTRA_ACTIVE_LOCAL_ONLY = "android.net.extra.ACTIVE_LOCAL_ONLY";
    @SystemApi
    public static final String EXTRA_ACTIVE_TETHER = "tetherArray";
    @SystemApi
    public static final String EXTRA_ERRORED_TETHER = "erroredArray";
    @SystemApi
    public static final int TETHERING_INVALID = -1;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int TETHERING_WIFI = 0;
    @SystemApi
    public static final int TETHERING_USB = 1;
    @SystemApi
    public static final int TETHERING_BLUETOOTH = 2;
    @SystemApi
    public static final int TETHERING_WIFI_P2P = 3;
    @SystemApi
    public static final int TETHERING_NCM = 4;
    @SystemApi
    public static final int TETHERING_ETHERNET = 5;
    public static final int TETHERING_WIGIG = 6;
    @SystemApi
    @FlaggedApi(value="com.android.net.flags.tethering_request_virtual")
    public static final int TETHERING_VIRTUAL = 7;
    public static final int MAX_TETHERING_TYPE = 7;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int TETHER_ERROR_NO_ERROR = 0;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int TETHER_ERROR_UNKNOWN_IFACE = 1;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int TETHER_ERROR_SERVICE_UNAVAIL = 2;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int TETHER_ERROR_UNSUPPORTED = 3;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int TETHER_ERROR_UNAVAIL_IFACE = 4;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int TETHER_ERROR_INTERNAL_ERROR = 5;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int TETHER_ERROR_TETHER_IFACE_ERROR = 6;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int TETHER_ERROR_UNTETHER_IFACE_ERROR = 7;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int TETHER_ERROR_ENABLE_FORWARDING_ERROR = 8;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int TETHER_ERROR_DISABLE_FORWARDING_ERROR = 9;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int TETHER_ERROR_IFACE_CFG_ERROR = 10;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int TETHER_ERROR_PROVISIONING_FAILED = 11;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int TETHER_ERROR_DHCPSERVER_ERROR = 12;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int TETHER_ERROR_ENTITLEMENT_UNKNOWN = 13;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int TETHER_ERROR_NO_CHANGE_TETHERING_PERMISSION = 14;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int TETHER_ERROR_NO_ACCESS_TETHERING_PERMISSION = 15;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int TETHER_ERROR_UNKNOWN_TYPE = 16;
    @FlaggedApi(value="com.android.net.flags.tethering_with_soft_ap_config")
    public static final int TETHER_ERROR_UNKNOWN_REQUEST = 17;
    @FlaggedApi(value="com.android.net.flags.tethering_with_soft_ap_config")
    public static final int TETHER_ERROR_DUPLICATE_REQUEST = 18;
    public static final int TETHER_ERROR_BLUETOOTH_SERVICE_PENDING = 19;
    public static final int TETHER_ERROR_SOFT_AP_CALLBACK_PENDING = 20;
    @SystemApi
    public static final int TETHER_HARDWARE_OFFLOAD_STOPPED = 0;
    @SystemApi
    public static final int TETHER_HARDWARE_OFFLOAD_STARTED = 1;
    @SystemApi
    public static final int TETHER_HARDWARE_OFFLOAD_FAILED = 2;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int CONNECTIVITY_SCOPE_GLOBAL = 1;
    @SystemApi
    public static final int CONNECTIVITY_SCOPE_LOCAL = 2;

    private static String typeToString(int type) {
        switch (type) {
            case -1: {
                return "TETHERING_INVALID";
            }
            case 0: {
                return "TETHERING_WIFI";
            }
            case 1: {
                return "TETHERING_USB";
            }
            case 2: {
                return "TETHERING_BLUETOOTH";
            }
            case 3: {
                return "TETHERING_WIFI_P2P";
            }
            case 4: {
                return "TETHERING_NCM";
            }
            case 5: {
                return "TETHERING_ETHERNET";
            }
        }
        return "TETHERING_UNKNOWN(" + type + ")";
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public TetheringManager(@NonNull Context context, @NonNull Supplier<IBinder> connectorSupplier) {
        this.mContext = context;
        this.mCallback = new TetheringCallbackInternal(this);
        this.mConnectorSupplier = connectorSupplier;
        String pkgName = this.mContext.getOpPackageName();
        IBinder connector = this.mConnectorSupplier.get();
        if (connector != null && connector.isBinderAlive()) {
            this.mConnector = ITetheringConnector.Stub.asInterface(connector);
        } else {
            this.startPollingForConnector();
        }
        Log.i(TAG, "registerTetheringEventCallback:" + pkgName);
        this.getConnector(c -> c.registerTetheringEventCallback(this.mCallback, pkgName));
    }

    protected void finalize() throws Throwable {
        String pkgName = this.mContext.getOpPackageName();
        Log.i(TAG, "unregisterTetheringEventCallback:" + pkgName);
        if (this.mConnector == null) {
            Log.wtf(TAG, "null connector in finalize!");
        }
        this.getConnector(c -> c.unregisterTetheringEventCallback(this.mCallback, pkgName));
        super.finalize();
    }

    private void startPollingForConnector() {
        new Thread(() -> {
            IBinder connector;
            do {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while ((connector = this.mConnectorSupplier.get()) == null || !connector.isBinderAlive());
            this.onTetheringConnected(ITetheringConnector.Stub.asInterface(connector));
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTetheringConnected(ITetheringConnector connector) {
        while (true) {
            ArrayList<ConnectorConsumer> localWaitQueue;
            List<ConnectorConsumer> list = this.mConnectorWaitQueue;
            synchronized (list) {
                localWaitQueue = new ArrayList<ConnectorConsumer>(this.mConnectorWaitQueue);
                this.mConnectorWaitQueue.clear();
            }
            for (ConnectorConsumer task : localWaitQueue) {
                try {
                    task.onConnectorAvailable(connector);
                }
                catch (RemoteException e) {
                    Log.wtf(TAG, "Error processing request for the tethering connector", e);
                }
            }
            list = this.mConnectorWaitQueue;
            synchronized (list) {
                if (this.mConnectorWaitQueue.size() == 0) {
                    this.mConnector = connector;
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getConnector(ConnectorConsumer consumer) {
        ITetheringConnector connector;
        List<ConnectorConsumer> list = this.mConnectorWaitQueue;
        synchronized (list) {
            connector = this.mConnector;
            if (connector == null) {
                this.mConnectorWaitQueue.add(consumer);
                return;
            }
        }
        try {
            consumer.onConnectorAvailable(connector);
        }
        catch (RemoteException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void throwIfPermissionFailure(int errorCode) {
        switch (errorCode) {
            case 14: {
                throw new SecurityException("No android.permission.TETHER_PRIVILEGED or android.permission.WRITE_SETTINGS permission");
            }
            case 15: {
                throw new SecurityException("No android.permission.ACCESS_NETWORK_STATE permission");
            }
        }
    }

    private void unsupportedAfterV() {
        if (SdkLevel.isAtLeastB()) {
            throw new UnsupportedOperationException("Not supported after SDK version 35");
        }
    }

    @Deprecated
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public int tether(@NonNull String iface) {
        this.unsupportedAfterV();
        String callerPkg = this.mContext.getOpPackageName();
        Log.i(TAG, "tether caller:" + callerPkg);
        RequestDispatcher dispatcher = new RequestDispatcher();
        return dispatcher.waitForResult((connector, listener) -> {
            try {
                connector.tether(iface, callerPkg, this.getAttributionTag(), listener);
            }
            catch (RemoteException e) {
                throw new IllegalStateException(e);
            }
        }, this);
    }

    @Nullable
    private String getAttributionTag() {
        return this.mContext.getAttributionTag();
    }

    @Deprecated
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public int untether(@NonNull String iface) {
        this.unsupportedAfterV();
        String callerPkg = this.mContext.getOpPackageName();
        Log.i(TAG, "untether caller:" + callerPkg);
        RequestDispatcher dispatcher = new RequestDispatcher();
        return dispatcher.waitForResult((connector, listener) -> {
            try {
                connector.untether(iface, callerPkg, this.getAttributionTag(), listener);
            }
            catch (RemoteException e) {
                throw new IllegalStateException(e);
            }
        }, this);
    }

    @Deprecated
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public int setUsbTethering(boolean enable) {
        String callerPkg = this.mContext.getOpPackageName();
        Log.i(TAG, "setUsbTethering caller:" + callerPkg);
        RequestDispatcher dispatcher = new RequestDispatcher();
        return dispatcher.waitForResult((connector, listener) -> {
            try {
                connector.setUsbTethering(enable, callerPkg, this.getAttributionTag(), listener);
            }
            catch (RemoteException e) {
                throw new IllegalStateException(e);
            }
        }, this);
    }

    private static String connectivityScopeToString(int scope) {
        switch (scope) {
            case 1: {
                return "CONNECTIVITY_SCOPE_GLOBAL";
            }
            case 2: {
                return "CONNECTIVITY_SCOPE_LOCAL";
            }
        }
        return "CONNECTIVITY_SCOPE_UNKNOWN(" + scope + ")";
    }

    @RequiresPermission(value="android.permission.TETHER_PRIVILEGED", conditional=true)
    @SuppressLint(value={"UnflaggedApi"})
    public void startTethering(@NonNull TetheringRequest request, final @NonNull Executor executor, final @NonNull StartTetheringCallback callback) {
        String callerPkg = this.mContext.getOpPackageName();
        Log.i(TAG, "startTethering caller:" + callerPkg);
        IIntResultListener.Stub listener = new IIntResultListener.Stub(this){

            @Override
            public void onResult(int resultCode) {
                executor.execute(() -> {
                    if (resultCode == 0) {
                        callback.onTetheringStarted();
                    } else {
                        callback.onTetheringFailed(resultCode);
                    }
                });
            }
        };
        this.getConnector(c -> c.startTethering(request.getParcel(), callerPkg, this.getAttributionTag(), listener));
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(value="android.permission.TETHER_PRIVILEGED")
    public void startTethering(int type, @NonNull Executor executor, @NonNull StartTetheringCallback callback) {
        this.startTethering(new TetheringRequest.Builder(type).build(), executor, callback);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.TETHER_PRIVILEGED")
    public void stopTethering(int type) {
        String callerPkg = this.mContext.getOpPackageName();
        Log.i(TAG, "stopTethering caller:" + callerPkg);
        this.getConnector(c -> c.stopTethering(type, callerPkg, this.getAttributionTag(), new IIntResultListener.Stub(this){

            @Override
            public void onResult(int resultCode) {
            }
        }));
    }

    @RequiresPermission(value="android.permission.TETHER_PRIVILEGED", conditional=true)
    @FlaggedApi(value="com.android.net.flags.tethering_with_soft_ap_config")
    public void stopTethering(@NonNull TetheringRequest request, final @NonNull Executor executor, final @NonNull StopTetheringCallback callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        String callerPkg = this.mContext.getOpPackageName();
        Log.i(TAG, "stopTethering: request=" + request + ", caller=" + callerPkg);
        this.getConnector(c -> c.stopTetheringRequest(request, callerPkg, this.getAttributionTag(), new IIntResultListener.Stub(this){

            @Override
            public void onResult(int resultCode) {
                executor.execute(() -> {
                    if (resultCode == 0) {
                        callback.onStopTetheringSucceeded();
                    } else {
                        callback.onStopTetheringFailed(resultCode);
                    }
                });
            }
        }));
    }

    @SystemApi
    @RequiresPermission(value="android.permission.TETHER_PRIVILEGED")
    public void requestLatestTetheringEntitlementResult(int type, boolean showEntitlementUi, final @NonNull Executor executor, final @NonNull OnTetheringEntitlementResultListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("OnTetheringEntitlementResultListener cannot be null.");
        }
        ResultReceiver wrappedListener = new ResultReceiver(this, null){

            @Override
            protected void onReceiveResult(int resultCode, Bundle resultData) {
                executor.execute(() -> listener.onTetheringEntitlementResult(resultCode));
            }
        };
        this.requestLatestTetheringEntitlementResult(type, wrappedListener, showEntitlementUi);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public void requestLatestTetheringEntitlementResult(int type, @NonNull ResultReceiver receiver, boolean showEntitlementUi) {
        String callerPkg = this.mContext.getOpPackageName();
        Log.i(TAG, "getLatestTetheringEntitlementResult caller:" + callerPkg);
        this.getConnector(c -> c.requestLatestTetheringEntitlementResult(type, receiver, showEntitlementUi, callerPkg, this.getAttributionTag()));
    }

    public static ArrayList<String> toIfaces(Collection<TetheringInterface> tetherIfaces) {
        ArrayList<String> ifaces = new ArrayList<String>();
        for (TetheringInterface tether : tetherIfaces) {
            ifaces.add(tether.getInterface());
        }
        return ifaces;
    }

    private static String[] toIfaces(TetheringInterface[] tetherIfaces) {
        String[] ifaces = new String[tetherIfaces.length];
        for (int i = 0; i < tetherIfaces.length; ++i) {
            ifaces[i] = tetherIfaces[i].getInterface();
        }
        return ifaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    @SuppressLint(value={"UnflaggedApi"})
    public void registerTetheringEventCallback(final @NonNull Executor executor, final @NonNull TetheringEventCallback callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        String callerPkg = this.mContext.getOpPackageName();
        Log.i(TAG, "registerTetheringEventCallback caller:" + callerPkg);
        ArrayMap<TetheringEventCallback, ITetheringEventCallback> arrayMap = this.mTetheringEventCallbacks;
        synchronized (arrayMap) {
            if (this.mTetheringEventCallbacks.containsKey(callback)) {
                throw new IllegalArgumentException("callback was already registered.");
            }
            ITetheringEventCallback.Stub remoteCallback = new ITetheringEventCallback.Stub(this){
                private final HashMap<TetheringInterface, Integer> mErrorStates = new HashMap();
                private TetheringInterface[] mLastTetherableInterfaces = null;
                private TetheringInterface[] mLastTetheredInterfaces = null;
                private TetheringInterface[] mLastLocalOnlyInterfaces = null;

                @Override
                public void onUpstreamChanged(Network network) throws RemoteException {
                    executor.execute(() -> callback.onUpstreamChanged(network));
                }

                private synchronized void sendErrorCallbacks(TetherStatesParcel newStates) {
                    for (int i = 0; i < newStates.erroredIfaceList.length; ++i) {
                        TetheringInterface tetherIface = newStates.erroredIfaceList[i];
                        Integer lastError = this.mErrorStates.get(tetherIface);
                        int newError = newStates.lastErrorList[i];
                        if (newError != 0 && !Objects.equals(lastError, newError)) {
                            callback.onError(tetherIface, newError);
                        }
                        this.mErrorStates.put(tetherIface, newError);
                    }
                }

                private synchronized void maybeSendTetherableIfacesChangedCallback(TetherStatesParcel newStates) {
                    if (Arrays.equals(this.mLastTetherableInterfaces, newStates.availableList)) {
                        return;
                    }
                    this.mLastTetherableInterfaces = (TetheringInterface[])newStates.availableList.clone();
                    callback.onTetherableInterfacesChanged(Collections.unmodifiableSet(new ArraySet<TetheringInterface>(this.mLastTetherableInterfaces)));
                }

                private synchronized void maybeSendTetheredIfacesChangedCallback(TetherStatesParcel newStates) {
                    if (Arrays.equals(this.mLastTetheredInterfaces, newStates.tetheredList)) {
                        return;
                    }
                    this.mLastTetheredInterfaces = (TetheringInterface[])newStates.tetheredList.clone();
                    callback.onTetheredInterfacesChanged(Collections.unmodifiableSet(new ArraySet<TetheringInterface>(this.mLastTetheredInterfaces)));
                }

                private synchronized void maybeSendLocalOnlyIfacesChangedCallback(TetherStatesParcel newStates) {
                    if (Arrays.equals(this.mLastLocalOnlyInterfaces, newStates.localOnlyList)) {
                        return;
                    }
                    this.mLastLocalOnlyInterfaces = (TetheringInterface[])newStates.localOnlyList.clone();
                    callback.onLocalOnlyInterfacesChanged(Collections.unmodifiableSet(new ArraySet<TetheringInterface>(this.mLastLocalOnlyInterfaces)));
                }

                @Override
                public void onCallbackStarted(TetheringCallbackStartedParcel parcel) {
                    executor.execute(() -> {
                        callback.onSupportedTetheringTypes(TetheringManager.unpackBits(parcel.supportedTypes));
                        callback.onTetheringSupported(parcel.supportedTypes != 0L);
                        callback.onUpstreamChanged(parcel.upstreamNetwork);
                        this.sendErrorCallbacks(parcel.states);
                        this.sendRegexpsChanged(parcel.config);
                        this.maybeSendTetherableIfacesChangedCallback(parcel.states);
                        this.maybeSendTetheredIfacesChangedCallback(parcel.states);
                        this.maybeSendLocalOnlyIfacesChangedCallback(parcel.states);
                        callback.onClientsChanged(parcel.tetheredClients);
                        callback.onOffloadStatusChanged(parcel.offloadStatus);
                    });
                }

                @Override
                public void onCallbackStopped(int errorCode) {
                    executor.execute(() -> TetheringManager.throwIfPermissionFailure(errorCode));
                }

                @Override
                public void onSupportedTetheringTypes(long supportedBitmap) {
                    executor.execute(() -> callback.onSupportedTetheringTypes(TetheringManager.unpackBits(supportedBitmap)));
                }

                private void sendRegexpsChanged(TetheringConfigurationParcel parcel) {
                    callback.onTetherableInterfaceRegexpsChanged(new TetheringInterfaceRegexps(parcel.tetherableBluetoothRegexs, parcel.tetherableUsbRegexs, parcel.tetherableWifiRegexs));
                }

                @Override
                public void onConfigurationChanged(TetheringConfigurationParcel config) {
                    executor.execute(() -> this.sendRegexpsChanged(config));
                }

                @Override
                public void onTetherStatesChanged(TetherStatesParcel states) {
                    executor.execute(() -> {
                        this.sendErrorCallbacks(states);
                        this.maybeSendTetherableIfacesChangedCallback(states);
                        this.maybeSendTetheredIfacesChangedCallback(states);
                        this.maybeSendLocalOnlyIfacesChangedCallback(states);
                    });
                }

                @Override
                public void onTetherClientsChanged(List<TetheredClient> clients) {
                    executor.execute(() -> callback.onClientsChanged(clients));
                }

                @Override
                public void onOffloadStatusChanged(int status) {
                    executor.execute(() -> callback.onOffloadStatusChanged(status));
                }
            };
            this.getConnector(c -> c.registerTetheringEventCallback(remoteCallback, callerPkg));
            this.mTetheringEventCallbacks.put(callback, remoteCallback);
        }
    }

    public static ArraySet<Integer> unpackBits(long val) {
        ArraySet<Integer> result = new ArraySet<Integer>(Long.bitCount(val));
        int bitPos = 0;
        while (val != 0L) {
            if ((val & 1L) == 1L) {
                result.add(bitPos);
            }
            val >>>= 1;
            ++bitPos;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(anyOf={"android.permission.TETHER_PRIVILEGED", "android.permission.ACCESS_NETWORK_STATE"})
    @SuppressLint(value={"UnflaggedApi"})
    public void unregisterTetheringEventCallback(@NonNull TetheringEventCallback callback) {
        Objects.requireNonNull(callback);
        String callerPkg = this.mContext.getOpPackageName();
        Log.i(TAG, "unregisterTetheringEventCallback caller:" + callerPkg);
        ArrayMap<TetheringEventCallback, ITetheringEventCallback> arrayMap = this.mTetheringEventCallbacks;
        synchronized (arrayMap) {
            ITetheringEventCallback remoteCallback = this.mTetheringEventCallbacks.remove(callback);
            if (remoteCallback == null) {
                throw new IllegalArgumentException("callback was not registered.");
            }
            this.getConnector(c -> c.unregisterTetheringEventCallback(remoteCallback, callerPkg));
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public int getLastTetherError(@NonNull String iface) {
        this.mCallback.waitForStarted();
        if (this.mTetherStatesParcel == null) {
            return 0;
        }
        int i = 0;
        for (TetheringInterface errored : this.mTetherStatesParcel.erroredIfaceList) {
            if (iface.equals(errored.getInterface())) {
                return this.mTetherStatesParcel.lastErrorList[i];
            }
            ++i;
        }
        return 0;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @NonNull
    public String[] getTetherableUsbRegexs() {
        this.mCallback.waitForStarted();
        return this.mTetheringConfiguration.tetherableUsbRegexs;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @NonNull
    public String[] getTetherableWifiRegexs() {
        this.mCallback.waitForStarted();
        return this.mTetheringConfiguration.tetherableWifiRegexs;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @NonNull
    public String[] getTetherableBluetoothRegexs() {
        this.mCallback.waitForStarted();
        return this.mTetheringConfiguration.tetherableBluetoothRegexs;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @NonNull
    public String[] getTetherableIfaces() {
        this.mCallback.waitForStarted();
        if (this.mTetherStatesParcel == null) {
            return new String[0];
        }
        return TetheringManager.toIfaces(this.mTetherStatesParcel.availableList);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @NonNull
    public String[] getTetheredIfaces() {
        this.mCallback.waitForStarted();
        if (this.mTetherStatesParcel == null) {
            return new String[0];
        }
        return TetheringManager.toIfaces(this.mTetherStatesParcel.tetheredList);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @NonNull
    public String[] getTetheringErroredIfaces() {
        this.mCallback.waitForStarted();
        if (this.mTetherStatesParcel == null) {
            return new String[0];
        }
        return TetheringManager.toIfaces(this.mTetherStatesParcel.erroredIfaceList);
    }

    @Deprecated
    @NonNull
    public String[] getTetheredDhcpRanges() {
        this.mCallback.waitForStarted();
        return this.mTetheringConfiguration.legacyDhcpRanges;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public boolean isTetheringSupported() {
        String callerPkg = this.mContext.getOpPackageName();
        return this.isTetheringSupported(callerPkg);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public boolean isTetheringSupported(@NonNull String callerPkg) {
        RequestDispatcher dispatcher = new RequestDispatcher();
        int ret = dispatcher.waitForResult((connector, listener) -> {
            try {
                connector.isTetheringSupported(callerPkg, this.getAttributionTag(), listener);
            }
            catch (RemoteException e) {
                throw new IllegalStateException(e);
            }
        }, this);
        return ret == 0;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.TETHER_PRIVILEGED")
    public void stopAllTethering() {
        String callerPkg = this.mContext.getOpPackageName();
        Log.i(TAG, "stopAllTethering caller:" + callerPkg);
        this.getConnector(c -> c.stopAllTethering(callerPkg, this.getAttributionTag(), new IIntResultListener.Stub(this){

            @Override
            public void onResult(int resultCode) {
            }
        }));
    }

    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void setPreferTestNetworks(boolean prefer) {
        Log.i(TAG, "setPreferTestNetworks caller: " + this.mContext.getOpPackageName());
        RequestDispatcher dispatcher = new RequestDispatcher();
        int ret = dispatcher.waitForResult((connector, listener) -> {
            try {
                connector.setPreferTestNetworks(prefer, listener);
            }
            catch (RemoteException e) {
                throw new IllegalStateException(e);
            }
        }, this);
    }

    private static class TetheringCallbackInternal
    extends ITetheringEventCallback.Stub {
        private volatile int mError = 0;
        private final ConditionVariable mWaitForCallback = new ConditionVariable();
        private final WeakReference<TetheringManager> mTetheringMgrRef;

        TetheringCallbackInternal(TetheringManager tm) {
            this.mTetheringMgrRef = new WeakReference<TetheringManager>(tm);
        }

        @Override
        public void onCallbackStarted(TetheringCallbackStartedParcel parcel) {
            TetheringManager tetheringMgr = (TetheringManager)this.mTetheringMgrRef.get();
            if (tetheringMgr != null) {
                tetheringMgr.mTetheringConfiguration = parcel.config;
                tetheringMgr.mTetherStatesParcel = parcel.states;
                this.mWaitForCallback.open();
            }
        }

        @Override
        public void onCallbackStopped(int errorCode) {
            TetheringManager tetheringMgr = (TetheringManager)this.mTetheringMgrRef.get();
            if (tetheringMgr != null) {
                this.mError = errorCode;
                this.mWaitForCallback.open();
            }
        }

        @Override
        public void onSupportedTetheringTypes(long supportedBitmap) {
        }

        @Override
        public void onUpstreamChanged(Network network) {
        }

        @Override
        public void onConfigurationChanged(TetheringConfigurationParcel config) {
            TetheringManager tetheringMgr = (TetheringManager)this.mTetheringMgrRef.get();
            if (tetheringMgr != null) {
                tetheringMgr.mTetheringConfiguration = config;
            }
        }

        @Override
        public void onTetherStatesChanged(TetherStatesParcel states) {
            TetheringManager tetheringMgr = (TetheringManager)this.mTetheringMgrRef.get();
            if (tetheringMgr != null) {
                tetheringMgr.mTetherStatesParcel = states;
            }
        }

        @Override
        public void onTetherClientsChanged(List<TetheredClient> clients) {
        }

        @Override
        public void onOffloadStatusChanged(int status) {
        }

        public void waitForStarted() {
            this.mWaitForCallback.block(60000L);
            TetheringManager.throwIfPermissionFailure(this.mError);
        }
    }

    private static interface ConnectorConsumer {
        public void onConnectorAvailable(ITetheringConnector var1) throws RemoteException;
    }

    private static class RequestDispatcher {
        private final ConditionVariable mWaiting;
        public volatile int mRemoteResult;
        private final IIntResultListener mListener = new IIntResultListener.Stub(){

            @Override
            public void onResult(int resultCode) {
                mRemoteResult = resultCode;
                mWaiting.open();
            }
        };

        RequestDispatcher() {
            this.mWaiting = new ConditionVariable();
        }

        int waitForResult(RequestHelper request, TetheringManager mgr) {
            mgr.getConnector(c -> request.runRequest(c, this.mListener));
            if (!this.mWaiting.block(60000L)) {
                throw new IllegalStateException("Callback timeout");
            }
            TetheringManager.throwIfPermissionFailure(this.mRemoteResult);
            return this.mRemoteResult;
        }
    }

    private static interface RequestHelper {
        public void runRequest(ITetheringConnector var1, IIntResultListener var2);
    }

    @SuppressLint(value={"UnflaggedApi"})
    public static interface StartTetheringCallback {
        @SuppressLint(value={"UnflaggedApi"})
        default public void onTetheringStarted() {
        }

        @SuppressLint(value={"UnflaggedApi"})
        default public void onTetheringFailed(int error) {
        }
    }

    @SuppressLint(value={"UnflaggedApi"})
    public static class TetheringRequest
    implements Parcelable {
        public static final int REQUEST_TYPE_EXPLICIT = 0;
        public static final int REQUEST_TYPE_IMPLICIT = 1;
        public static final int REQUEST_TYPE_LEGACY = 2;
        public static final int REQUEST_TYPE_PLACEHOLDER = 3;
        private final TetheringRequestParcel mRequestParcel;
        @FlaggedApi(value="com.android.net.flags.tethering_with_soft_ap_config")
        @NonNull
        public static final Parcelable.Creator<TetheringRequest> CREATOR = new Parcelable.Creator<TetheringRequest>(){

            @Override
            public TetheringRequest createFromParcel(@NonNull Parcel in) {
                return new TetheringRequest(in);
            }

            public TetheringRequest[] newArray(int size) {
                return new TetheringRequest[size];
            }
        };

        @FlaggedApi(value="com.android.net.flags.tethering_with_soft_ap_config")
        public TetheringRequest(@NonNull TetheringRequestParcel request) {
            this.mRequestParcel = request;
        }

        private TetheringRequest(@NonNull Parcel in) {
            this.mRequestParcel = (TetheringRequestParcel)in.readParcelable(TetheringRequestParcel.class.getClassLoader());
        }

        @Override
        @FlaggedApi(value="com.android.net.flags.tethering_with_soft_ap_config")
        public int describeContents() {
            return 0;
        }

        @Override
        @FlaggedApi(value="com.android.net.flags.tethering_with_soft_ap_config")
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeParcelable(this.mRequestParcel, flags);
        }

        @SystemApi
        @Nullable
        public LinkAddress getLocalIpv4Address() {
            return this.mRequestParcel.localIPv4Address;
        }

        @SystemApi
        @Nullable
        public LinkAddress getClientStaticIpv4Address() {
            return this.mRequestParcel.staticClientAddress;
        }

        @SystemApi
        public int getTetheringType() {
            return this.mRequestParcel.tetheringType;
        }

        @SystemApi
        public int getConnectivityScope() {
            return this.mRequestParcel.connectivityScope;
        }

        @SystemApi
        public boolean isExemptFromEntitlementCheck() {
            return this.mRequestParcel.exemptFromEntitlementCheck;
        }

        @SystemApi
        public boolean getShouldShowEntitlementUi() {
            return this.mRequestParcel.showProvisioningUi;
        }

        @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
        @FlaggedApi(value="com.android.net.flags.tethering_with_soft_ap_config")
        @Nullable
        public String getInterfaceName() {
            return this.mRequestParcel.interfaceName;
        }

        public static boolean checkStaticAddressConfiguration(@NonNull LinkAddress localIPv4Address, @NonNull LinkAddress clientAddress) {
            return localIPv4Address.getPrefixLength() == clientAddress.getPrefixLength() && localIPv4Address.isIpv4() && clientAddress.isIpv4() && ((Object)new IpPrefix(((Object)localIPv4Address).toString())).equals(new IpPrefix(((Object)clientAddress).toString()));
        }

        public static int getDefaultConnectivityScope(int tetheringType) {
            return tetheringType != 4 ? 1 : 2;
        }

        private static boolean checkConnectivityScope(int type, int scope) {
            if (scope == 1) {
                return true;
            }
            return type == 1 || type == 5 || type == 4;
        }

        @FlaggedApi(value="com.android.net.flags.tethering_with_soft_ap_config")
        @Nullable
        public SoftApConfiguration getSoftApConfiguration() {
            return this.mRequestParcel.softApConfig;
        }

        public void setUid(int uid) {
            this.mRequestParcel.uid = uid;
        }

        public void setPackageName(String packageName) {
            this.mRequestParcel.packageName = packageName;
        }

        @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
        @FlaggedApi(value="com.android.net.flags.tethering_with_soft_ap_config")
        public int getUid() {
            return this.mRequestParcel.uid;
        }

        @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
        @FlaggedApi(value="com.android.net.flags.tethering_with_soft_ap_config")
        @Nullable
        public String getPackageName() {
            return this.mRequestParcel.packageName;
        }

        public TetheringRequestParcel getParcel() {
            return this.mRequestParcel;
        }

        public int getRequestType() {
            return this.mRequestParcel.requestType;
        }

        @SystemApi
        public String toString() {
            StringJoiner sj = new StringJoiner(", ", "TetheringRequest[ ", " ]");
            sj.add(TetheringManager.typeToString(this.mRequestParcel.tetheringType));
            if (this.mRequestParcel.requestType == 1) {
                sj.add("IMPLICIT");
            } else if (this.mRequestParcel.requestType == 2) {
                sj.add("LEGACY");
            } else if (this.mRequestParcel.requestType == 3) {
                sj.add("PLACEHOLDER");
            }
            if (this.mRequestParcel.localIPv4Address != null) {
                sj.add("localIpv4Address=" + this.mRequestParcel.localIPv4Address);
            }
            if (this.mRequestParcel.staticClientAddress != null) {
                sj.add("staticClientAddress=" + this.mRequestParcel.staticClientAddress);
            }
            if (this.mRequestParcel.exemptFromEntitlementCheck) {
                sj.add("exemptFromEntitlementCheck");
            }
            if (this.mRequestParcel.showProvisioningUi) {
                sj.add("showProvisioningUi");
            }
            sj.add(TetheringManager.connectivityScopeToString(this.mRequestParcel.connectivityScope));
            if (this.mRequestParcel.softApConfig != null) {
                sj.add("softApConfig=" + this.mRequestParcel.softApConfig);
            }
            if (this.mRequestParcel.uid != -1) {
                sj.add("uid=" + this.mRequestParcel.uid);
            }
            if (this.mRequestParcel.packageName != null) {
                sj.add("packageName=" + this.mRequestParcel.packageName);
            }
            if (this.mRequestParcel.interfaceName != null) {
                sj.add("interfaceName=" + this.mRequestParcel.interfaceName);
            }
            return ((Object)sj).toString();
        }

        @SuppressLint(value={"UnflaggedApi"})
        private static boolean supportsInterfaceName(int tetheringType) {
            return tetheringType == 7;
        }

        private static boolean supportsConcurrentConnectivityScopes(int tetheringType) {
            return tetheringType == 0;
        }

        public boolean fuzzyMatches(TetheringRequest other) {
            if (other == null) {
                return false;
            }
            int type = this.getTetheringType();
            if (type != other.getTetheringType()) {
                return false;
            }
            if (TetheringRequest.supportsInterfaceName(type) && !TextUtils.equals(this.getInterfaceName(), other.getInterfaceName())) {
                return false;
            }
            return !TetheringRequest.supportsConcurrentConnectivityScopes(type) || this.getConnectivityScope() == other.getConnectivityScope();
        }

        @SystemApi
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TetheringRequest)) {
                return false;
            }
            TetheringRequest otherRequest = (TetheringRequest)obj;
            if (!this.equalsIgnoreUidPackage(otherRequest)) {
                return false;
            }
            TetheringRequestParcel parcel = this.getParcel();
            TetheringRequestParcel otherParcel = otherRequest.getParcel();
            return parcel.uid == otherParcel.uid && Objects.equals(parcel.packageName, otherParcel.packageName);
        }

        public boolean equalsIgnoreUidPackage(TetheringRequest otherRequest) {
            TetheringRequestParcel parcel = this.getParcel();
            TetheringRequestParcel otherParcel = otherRequest.getParcel();
            return parcel.requestType == otherParcel.requestType && parcel.tetheringType == otherParcel.tetheringType && Objects.equals(parcel.localIPv4Address, otherParcel.localIPv4Address) && Objects.equals(parcel.staticClientAddress, otherParcel.staticClientAddress) && parcel.exemptFromEntitlementCheck == otherParcel.exemptFromEntitlementCheck && parcel.showProvisioningUi == otherParcel.showProvisioningUi && parcel.connectivityScope == otherParcel.connectivityScope && Objects.equals(parcel.softApConfig, otherParcel.softApConfig) && Objects.equals(parcel.interfaceName, otherParcel.interfaceName);
        }

        @SystemApi
        public int hashCode() {
            TetheringRequestParcel parcel = this.getParcel();
            return Objects.hash(parcel.tetheringType, parcel.localIPv4Address, parcel.staticClientAddress, parcel.exemptFromEntitlementCheck, parcel.showProvisioningUi, parcel.connectivityScope, parcel.softApConfig, parcel.uid, parcel.packageName, parcel.interfaceName);
        }

        @SuppressLint(value={"UnflaggedApi", "StaticFinalBuilder"})
        public static class Builder {
            private final TetheringRequestParcel mBuilderParcel = new TetheringRequestParcel();

            @SuppressLint(value={"UnflaggedApi"})
            public Builder(int type) {
                this.mBuilderParcel.tetheringType = type;
                this.mBuilderParcel.localIPv4Address = null;
                this.mBuilderParcel.staticClientAddress = null;
                this.mBuilderParcel.exemptFromEntitlementCheck = false;
                this.mBuilderParcel.showProvisioningUi = true;
                this.mBuilderParcel.connectivityScope = TetheringRequest.getDefaultConnectivityScope(type);
                this.mBuilderParcel.uid = -1;
                this.mBuilderParcel.softApConfig = null;
                this.mBuilderParcel.interfaceName = null;
                this.mBuilderParcel.requestType = 0;
            }

            @SystemApi
            @RequiresPermission(value="android.permission.TETHER_PRIVILEGED")
            @NonNull
            public Builder setStaticIpv4Addresses(@NonNull LinkAddress localIPv4Address, @NonNull LinkAddress clientAddress) {
                Objects.requireNonNull(localIPv4Address);
                Objects.requireNonNull(clientAddress);
                if (!TetheringRequest.checkStaticAddressConfiguration(localIPv4Address, clientAddress)) {
                    throw new IllegalArgumentException("Invalid server or client addresses");
                }
                this.mBuilderParcel.localIPv4Address = localIPv4Address;
                this.mBuilderParcel.staticClientAddress = clientAddress;
                return this;
            }

            @SystemApi
            @RequiresPermission(value="android.permission.TETHER_PRIVILEGED")
            @NonNull
            public Builder setExemptFromEntitlementCheck(boolean exempt) {
                this.mBuilderParcel.exemptFromEntitlementCheck = exempt;
                return this;
            }

            @SystemApi
            @RequiresPermission(value="android.permission.TETHER_PRIVILEGED")
            @NonNull
            public Builder setShouldShowEntitlementUi(boolean showUi) {
                this.mBuilderParcel.showProvisioningUi = showUi;
                return this;
            }

            @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
            @FlaggedApi(value="com.android.net.flags.tethering_with_soft_ap_config")
            @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_STACK", "android.permission.MAINLINE_NETWORK_STACK"})
            @NonNull
            public Builder setInterfaceName(@Nullable String interfaceName) {
                switch (this.mBuilderParcel.tetheringType) {
                    case 0: 
                    case 3: 
                    case 7: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Interface name cannot be set for tethering type " + interfaceName);
                    }
                }
                this.mBuilderParcel.interfaceName = interfaceName;
                return this;
            }

            @SystemApi
            @RequiresPermission(value="android.permission.TETHER_PRIVILEGED")
            @NonNull
            public Builder setConnectivityScope(int scope) {
                if (!TetheringRequest.checkConnectivityScope(this.mBuilderParcel.tetheringType, scope)) {
                    throw new IllegalArgumentException("Invalid connectivity scope " + scope);
                }
                this.mBuilderParcel.connectivityScope = scope;
                return this;
            }

            @FlaggedApi(value="com.android.net.flags.tethering_with_soft_ap_config")
            @RequiresPermission(value="android.permission.TETHER_PRIVILEGED")
            @NonNull
            public Builder setSoftApConfiguration(@Nullable SoftApConfiguration softApConfig) {
                if (this.mBuilderParcel.tetheringType != 0) {
                    throw new IllegalArgumentException("SoftApConfiguration can only be set for TETHERING_WIFI");
                }
                this.mBuilderParcel.softApConfig = softApConfig;
                return this;
            }

            @NonNull
            @SuppressLint(value={"UnflaggedApi"})
            public TetheringRequest build() {
                return new TetheringRequest(this.mBuilderParcel);
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface RequestType {
        }
    }

    @FlaggedApi(value="com.android.net.flags.tethering_with_soft_ap_config")
    public static interface StopTetheringCallback {
        default public void onStopTetheringSucceeded() {
        }

        default public void onStopTetheringFailed(int error) {
        }
    }

    @SystemApi
    public static interface OnTetheringEntitlementResultListener {
        public void onTetheringEntitlementResult(int var1);
    }

    @SuppressLint(value={"UnflaggedApi"})
    public static interface TetheringEventCallback {
        @SystemApi
        default public void onTetheringSupported(boolean supported) {
        }

        default public void onSupportedTetheringTypes(@NonNull Set<Integer> supportedTypes) {
        }

        @SystemApi
        default public void onUpstreamChanged(@Nullable Network network) {
        }

        @Deprecated
        @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
        default public void onTetherableInterfaceRegexpsChanged(@NonNull TetheringInterfaceRegexps reg) {
        }

        @SystemApi
        default public void onTetherableInterfacesChanged(@NonNull List<String> interfaces) {
        }

        @SystemApi
        default public void onTetherableInterfacesChanged(@NonNull Set<TetheringInterface> interfaces) {
            this.onTetherableInterfacesChanged(TetheringManager.toIfaces(interfaces));
        }

        @SystemApi
        default public void onTetheredInterfacesChanged(@NonNull List<String> interfaces) {
        }

        @SuppressLint(value={"UnflaggedApi"})
        default public void onTetheredInterfacesChanged(@NonNull Set<TetheringInterface> interfaces) {
            this.onTetheredInterfacesChanged(TetheringManager.toIfaces(interfaces));
        }

        @SystemApi
        default public void onLocalOnlyInterfacesChanged(@NonNull List<String> interfaces) {
        }

        @SystemApi
        default public void onLocalOnlyInterfacesChanged(@NonNull Set<TetheringInterface> interfaces) {
            this.onLocalOnlyInterfacesChanged(TetheringManager.toIfaces(interfaces));
        }

        @SystemApi
        default public void onError(@NonNull String ifName, int error) {
        }

        @SystemApi
        default public void onError(@NonNull TetheringInterface iface, int error) {
            this.onError(iface.getInterface(), error);
        }

        @SystemApi
        default public void onClientsChanged(@NonNull Collection<TetheredClient> clients) {
        }

        @SystemApi
        default public void onOffloadStatusChanged(int status) {
        }
    }

    @Deprecated
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static class TetheringInterfaceRegexps {
        private final String[] mTetherableBluetoothRegexs;
        private final String[] mTetherableUsbRegexs;
        private final String[] mTetherableWifiRegexs;

        public TetheringInterfaceRegexps(@NonNull String[] tetherableBluetoothRegexs, @NonNull String[] tetherableUsbRegexs, @NonNull String[] tetherableWifiRegexs) {
            this.mTetherableBluetoothRegexs = (String[])tetherableBluetoothRegexs.clone();
            this.mTetherableUsbRegexs = (String[])tetherableUsbRegexs.clone();
            this.mTetherableWifiRegexs = (String[])tetherableWifiRegexs.clone();
        }

        @NonNull
        public List<String> getTetherableBluetoothRegexs() {
            return Collections.unmodifiableList(Arrays.asList(this.mTetherableBluetoothRegexs));
        }

        @NonNull
        public List<String> getTetherableUsbRegexs() {
            return Collections.unmodifiableList(Arrays.asList(this.mTetherableUsbRegexs));
        }

        @NonNull
        public List<String> getTetherableWifiRegexs() {
            return Collections.unmodifiableList(Arrays.asList(this.mTetherableWifiRegexs));
        }

        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.mTetherableBluetoothRegexs), Arrays.hashCode(this.mTetherableUsbRegexs), Arrays.hashCode(this.mTetherableWifiRegexs));
        }

        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof TetheringInterfaceRegexps)) {
                return false;
            }
            TetheringInterfaceRegexps other = (TetheringInterfaceRegexps)obj;
            return Arrays.equals(this.mTetherableBluetoothRegexs, other.mTetherableBluetoothRegexs) && Arrays.equals(this.mTetherableUsbRegexs, other.mTetherableUsbRegexs) && Arrays.equals(this.mTetherableWifiRegexs, other.mTetherableWifiRegexs);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConnectivityScope {
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static interface TetheredInterfaceCallback {
        public void onAvailable(@NonNull String var1);

        public void onUnavailable();
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @SuppressLint(value={"NotCloseable"})
    public static interface TetheredInterfaceRequest {
        public void release();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TetherOffloadStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StopTetheringError {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StartTetheringError {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TetheringIfaceError {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EntitlementResult {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TetheringType {
    }
}

