/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.net.NetworkSpecifier;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.Objects;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public class TestNetworkSpecifier
extends NetworkSpecifier
implements Parcelable {
    @NonNull
    private final String mInterfaceName;
    @NonNull
    public static final Parcelable.Creator<TestNetworkSpecifier> CREATOR = new Parcelable.Creator<TestNetworkSpecifier>(){

        @Override
        public TestNetworkSpecifier createFromParcel(Parcel in) {
            return new TestNetworkSpecifier(in.readString());
        }

        public TestNetworkSpecifier[] newArray(int size) {
            return new TestNetworkSpecifier[size];
        }
    };

    public TestNetworkSpecifier(@NonNull String interfaceName) {
        if (TextUtils.isEmpty(interfaceName)) {
            throw new IllegalArgumentException("Empty interfaceName");
        }
        this.mInterfaceName = interfaceName;
    }

    @Nullable
    public String getInterfaceName() {
        return this.mInterfaceName;
    }

    @Override
    public boolean canBeSatisfiedBy(@Nullable NetworkSpecifier other) {
        return this.equals(other);
    }

    public boolean equals(Object o) {
        if (!(o instanceof TestNetworkSpecifier)) {
            return false;
        }
        return TextUtils.equals(this.mInterfaceName, ((TestNetworkSpecifier)o).mInterfaceName);
    }

    public int hashCode() {
        return Objects.hashCode(this.mInterfaceName);
    }

    public String toString() {
        return "TestNetworkSpecifier (" + this.mInterfaceName + ")";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mInterfaceName);
    }
}

