/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.ServiceManager;
import android.util.Log;
import com.android.net.IProxyService;
import com.google.android.collect.Lists;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

public class PacProxySelector
extends ProxySelector {
    private static final String TAG = "PacProxySelector";
    public static final String PROXY_SERVICE = "com.android.net.IProxyService";
    private static final String SOCKS = "SOCKS ";
    private static final String PROXY = "PROXY ";
    private IProxyService mProxyService = IProxyService.Stub.asInterface(ServiceManager.getService("com.android.net.IProxyService"));
    private final List<Proxy> mDefaultList;

    public PacProxySelector() {
        if (this.mProxyService == null) {
            Log.e(TAG, "PacProxyService: no proxy service");
        }
        this.mDefaultList = Lists.newArrayList(Proxy.NO_PROXY);
    }

    @Override
    public List<Proxy> select(URI uri) {
        String urlString;
        if (this.mProxyService == null) {
            this.mProxyService = IProxyService.Stub.asInterface(ServiceManager.getService(PROXY_SERVICE));
        }
        if (this.mProxyService == null) {
            Log.e(TAG, "select: no proxy service return NO_PROXY");
            return Lists.newArrayList(Proxy.NO_PROXY);
        }
        String response = null;
        try {
            if (!"http".equalsIgnoreCase(uri.getScheme())) {
                uri = new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), "/", null, null);
            }
            urlString = ((Object)uri.toURL()).toString();
        }
        catch (URISyntaxException e) {
            urlString = uri.getHost();
        }
        catch (MalformedURLException e) {
            urlString = uri.getHost();
        }
        try {
            response = this.mProxyService.resolvePacFile(uri.getHost(), urlString);
        }
        catch (Exception e) {
            Log.e(TAG, "Error resolving PAC File", e);
        }
        if (response == null) {
            return this.mDefaultList;
        }
        return PacProxySelector.parseResponse(response);
    }

    private static List<Proxy> parseResponse(String response) {
        String[] split = response.split(";");
        ArrayList<Proxy> ret = Lists.newArrayList();
        for (String s : split) {
            Proxy proxy;
            String trimmed = s.trim();
            if (trimmed.equals("DIRECT")) {
                ret.add(Proxy.NO_PROXY);
                continue;
            }
            if (trimmed.startsWith(PROXY)) {
                proxy = PacProxySelector.proxyFromHostPort(Proxy.Type.HTTP, trimmed.substring(PROXY.length()));
                if (proxy == null) continue;
                ret.add(proxy);
                continue;
            }
            if (!trimmed.startsWith(SOCKS) || (proxy = PacProxySelector.proxyFromHostPort(Proxy.Type.SOCKS, trimmed.substring(SOCKS.length()))) == null) continue;
            ret.add(proxy);
        }
        if (ret.size() == 0) {
            ret.add(Proxy.NO_PROXY);
        }
        return ret;
    }

    private static Proxy proxyFromHostPort(Proxy.Type type, String hostPortString) {
        try {
            String[] hostPort = hostPortString.split(":");
            String host = hostPort[0];
            int port = Integer.parseInt(hostPort[1]);
            return new Proxy(type, InetSocketAddress.createUnresolved(host, port));
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            Log.d(TAG, "Unable to parse proxy " + hostPortString + " " + e);
            return null;
        }
    }

    @Override
    public void connectFailed(URI uri, SocketAddress address, IOException failure) {
    }
}

