/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.net.connectivity.com.android.net.module.util.HexDump;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import com.android.internal.annotations.VisibleForTesting;
import java.util.Objects;

@FlaggedApi(value="com.android.net.flags.ipsec_transform_state")
public class IpSecTransformState
implements Parcelable {
    private final long mTimestamp;
    private final long mTxHighestSequenceNumber;
    private final long mRxHighestSequenceNumber;
    private final long mPacketCount;
    private final long mByteCount;
    private final byte[] mReplayBitmap;
    @NonNull
    public static final Parcelable.Creator<IpSecTransformState> CREATOR = new Parcelable.Creator<IpSecTransformState>(){

        @Override
        @NonNull
        public IpSecTransformState createFromParcel(Parcel in) {
            return new IpSecTransformState(in);
        }

        @NonNull
        public IpSecTransformState[] newArray(int size) {
            return new IpSecTransformState[size];
        }
    };

    private IpSecTransformState(long timestamp, long txHighestSequenceNumber, long rxHighestSequenceNumber, long packetCount, long byteCount, byte[] replayBitmap) {
        this.mTimestamp = timestamp;
        this.mTxHighestSequenceNumber = txHighestSequenceNumber;
        this.mRxHighestSequenceNumber = rxHighestSequenceNumber;
        this.mPacketCount = packetCount;
        this.mByteCount = byteCount;
        Objects.requireNonNull(replayBitmap, "replayBitmap is null");
        this.mReplayBitmap = (byte[])replayBitmap.clone();
        this.validate();
    }

    private void validate() {
        Objects.requireNonNull(this.mReplayBitmap, "mReplayBitmap is null");
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public IpSecTransformState(@NonNull Parcel in) {
        Objects.requireNonNull(in, "The input PersistableBundle is null");
        this.mTimestamp = in.readLong();
        this.mTxHighestSequenceNumber = in.readLong();
        this.mRxHighestSequenceNumber = in.readLong();
        this.mPacketCount = in.readLong();
        this.mByteCount = in.readLong();
        this.mReplayBitmap = HexDump.hexStringToByteArray(in.readString());
        this.validate();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeLong(this.mTimestamp);
        out.writeLong(this.mTxHighestSequenceNumber);
        out.writeLong(this.mRxHighestSequenceNumber);
        out.writeLong(this.mPacketCount);
        out.writeLong(this.mByteCount);
        out.writeString(HexDump.toHexString(this.mReplayBitmap));
    }

    public long getTimestampMillis() {
        return this.mTimestamp;
    }

    public long getTxHighestSequenceNumber() {
        return this.mTxHighestSequenceNumber;
    }

    public long getRxHighestSequenceNumber() {
        return this.mRxHighestSequenceNumber;
    }

    public long getPacketCount() {
        return this.mPacketCount;
    }

    public long getByteCount() {
        return this.mByteCount;
    }

    @NonNull
    public byte[] getReplayBitmap() {
        return (byte[])this.mReplayBitmap.clone();
    }

    @FlaggedApi(value="com.android.net.flags.ipsec_transform_state")
    public static class Builder {
        private long mTimestamp = SystemClock.elapsedRealtime();
        private long mTxHighestSequenceNumber;
        private long mRxHighestSequenceNumber;
        private long mPacketCount;
        private long mByteCount;
        private byte[] mReplayBitmap;

        @NonNull
        public Builder setTimestampMillis(long timestamp) {
            this.mTimestamp = timestamp;
            return this;
        }

        @NonNull
        public Builder setTxHighestSequenceNumber(long seqNum) {
            this.mTxHighestSequenceNumber = seqNum;
            return this;
        }

        @NonNull
        public Builder setRxHighestSequenceNumber(long seqNum) {
            this.mRxHighestSequenceNumber = seqNum;
            return this;
        }

        @NonNull
        public Builder setPacketCount(long packetCount) {
            this.mPacketCount = packetCount;
            return this;
        }

        @NonNull
        public Builder setByteCount(long byteCount) {
            this.mByteCount = byteCount;
            return this;
        }

        @NonNull
        public Builder setReplayBitmap(@NonNull byte[] bitMap) {
            this.mReplayBitmap = (byte[])bitMap.clone();
            return this;
        }

        @NonNull
        public IpSecTransformState build() {
            return new IpSecTransformState(this.mTimestamp, this.mTxHighestSequenceNumber, this.mRxHighestSequenceNumber, this.mPacketCount, this.mByteCount, this.mReplayBitmap);
        }
    }
}

