/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.net.IpSecAlgorithm;
import android.net.IpSecConfig;
import android.net.IpSecManager;
import android.net.IpSecTransformResponse;
import android.net.IpSecTransformState;
import android.os.Binder;
import android.os.OutcomeReceiver;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import dalvik.system.CloseGuard;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.InetAddress;
import java.util.Objects;
import java.util.concurrent.Executor;

public class IpSecTransform
implements AutoCloseable {
    private static final String TAG = "IpSecTransform";
    public static final int MODE_TRANSPORT = 0;
    public static final int MODE_TUNNEL = 1;
    public static final int ENCAP_NONE = 0;
    public static final int ENCAP_ESPINUDP_NON_IKE = 1;
    public static final int ENCAP_ESPINUDP = 2;
    private final IpSecConfig mConfig;
    private final Object mLock = new Object();
    private int mResourceId;
    private final Context mContext;
    private final CloseGuard mCloseGuard = CloseGuard.get();

    @VisibleForTesting
    public IpSecTransform(Context context, IpSecConfig config) {
        this.mContext = context;
        this.mConfig = new IpSecConfig(config);
        this.mResourceId = -1;
    }

    private IpSecManager getIpSecManager(Context context) {
        return context.getSystemService(IpSecManager.class);
    }

    private void checkResultStatus(int status) throws IOException, IpSecManager.ResourceUnavailableException, IpSecManager.SpiUnavailableException {
        switch (status) {
            case 0: {
                return;
            }
            case 1: {
                throw new IpSecManager.ResourceUnavailableException("Failed to allocate a new IpSecTransform");
            }
            case 2: {
                Log.wtf(TAG, "Attempting to use an SPI that was somehow not reserved");
            }
        }
        throw new IllegalStateException("Failed to Create a Transform with status code " + status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IpSecTransform activate() throws IOException, IpSecManager.ResourceUnavailableException, IpSecManager.SpiUnavailableException {
        Object object = this.mLock;
        synchronized (object) {
            try {
                IpSecTransformResponse result = this.getIpSecManager(this.mContext).createTransform(this.mConfig, new Binder(), this.mContext.getOpPackageName());
                int status = result.status;
                this.checkResultStatus(status);
                this.mResourceId = result.resourceId;
                Log.d(TAG, "Added Transform with Id " + this.mResourceId);
                this.mCloseGuard.open("close");
            }
            catch (ServiceSpecificException e) {
                throw IpSecManager.rethrowUncheckedExceptionFromServiceSpecificException(e);
            }
        }
        return this;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IpSecTransform)) {
            return false;
        }
        IpSecTransform rhs = (IpSecTransform)other;
        return this.getConfig().equals(rhs.getConfig()) && this.mResourceId == rhs.mResourceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Log.d(TAG, "Removing Transform with Id " + this.mResourceId);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mResourceId == -1) {
                this.mCloseGuard.close();
                return;
            }
            try {
                this.getIpSecManager(this.mContext).deleteTransform(this.mResourceId);
            }
            catch (Exception e) {
                Log.e(TAG, "Failed to close " + this + ", Exception=" + e);
            }
            finally {
                this.mResourceId = -1;
                this.mCloseGuard.close();
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.mCloseGuard != null) {
            this.mCloseGuard.warnIfOpen();
        }
        this.close();
    }

    IpSecConfig getConfig() {
        return this.mConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public int getResourceId() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mResourceId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="com.android.net.flags.ipsec_transform_state")
    public void requestIpSecTransformState(@NonNull Executor executor, @NonNull OutcomeReceiver<IpSecTransformState, RuntimeException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            IpSecTransformState ipSecTransformState;
            Object object = this.mLock;
            synchronized (object) {
                ipSecTransformState = this.getIpSecManager(this.mContext).getTransformState(this.mResourceId);
            }
            executor.execute(() -> callback.onResult(ipSecTransformState));
        }
        catch (IllegalStateException e) {
            executor.execute(() -> callback.onError(e));
        }
        catch (RemoteException e) {
            executor.execute(() -> callback.onError(e.rethrowFromSystemServer()));
        }
    }

    public String toString() {
        return "IpSecTransform{resourceId=" + this.mResourceId + "}";
    }

    public static class Builder {
        private Context mContext;
        private IpSecConfig mConfig;

        @NonNull
        public Builder setEncryption(@NonNull IpSecAlgorithm algo) {
            Objects.requireNonNull(algo);
            this.mConfig.setEncryption(algo);
            return this;
        }

        @NonNull
        public Builder setAuthentication(@NonNull IpSecAlgorithm algo) {
            Objects.requireNonNull(algo);
            this.mConfig.setAuthentication(algo);
            return this;
        }

        @NonNull
        public Builder setAuthenticatedEncryption(@NonNull IpSecAlgorithm algo) {
            Objects.requireNonNull(algo);
            this.mConfig.setAuthenticatedEncryption(algo);
            return this;
        }

        @NonNull
        public Builder setIpv4Encapsulation(@NonNull IpSecManager.UdpEncapsulationSocket localSocket, int remotePort) {
            Objects.requireNonNull(localSocket);
            this.mConfig.setEncapType(2);
            if (localSocket.getResourceId() == -1) {
                throw new IllegalArgumentException("Invalid UdpEncapsulationSocket");
            }
            this.mConfig.setEncapSocketResourceId(localSocket.getResourceId());
            this.mConfig.setEncapRemotePort(remotePort);
            return this;
        }

        @NonNull
        public IpSecTransform buildTransportModeTransform(@NonNull InetAddress sourceAddress, @NonNull IpSecManager.SecurityParameterIndex spi) throws IpSecManager.ResourceUnavailableException, IpSecManager.SpiUnavailableException, IOException {
            Objects.requireNonNull(sourceAddress);
            Objects.requireNonNull(spi);
            if (spi.getResourceId() == -1) {
                throw new IllegalArgumentException("Invalid SecurityParameterIndex");
            }
            this.mConfig.setMode(0);
            this.mConfig.setSourceAddress(sourceAddress.getHostAddress());
            this.mConfig.setSpiResourceId(spi.getResourceId());
            return new IpSecTransform(this.mContext, this.mConfig).activate();
        }

        @SystemApi
        @NonNull
        @RequiresPermission(value="android.permission.MANAGE_IPSEC_TUNNELS")
        public IpSecTransform buildTunnelModeTransform(@NonNull InetAddress sourceAddress, @NonNull IpSecManager.SecurityParameterIndex spi) throws IpSecManager.ResourceUnavailableException, IpSecManager.SpiUnavailableException, IOException {
            Objects.requireNonNull(sourceAddress);
            Objects.requireNonNull(spi);
            if (spi.getResourceId() == -1) {
                throw new IllegalArgumentException("Invalid SecurityParameterIndex");
            }
            this.mConfig.setMode(1);
            this.mConfig.setSourceAddress(sourceAddress.getHostAddress());
            this.mConfig.setSpiResourceId(spi.getResourceId());
            return new IpSecTransform(this.mContext, this.mConfig).activate();
        }

        public Builder(@NonNull Context context) {
            Objects.requireNonNull(context);
            this.mContext = context;
            this.mConfig = new IpSecConfig();
        }
    }

    public static class NattKeepaliveCallback {
        public static final int ERROR_INVALID_NETWORK = 1;
        public static final int ERROR_HARDWARE_UNSUPPORTED = 2;
        public static final int ERROR_HARDWARE_ERROR = 3;

        public void onStarted() {
        }

        public void onStopped() {
        }

        public void onError(int error) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EncapType {
    }
}

