/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.NetworkSpecifier;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.Objects;

public class EthernetNetworkSpecifier
extends NetworkSpecifier
implements Parcelable {
    @NonNull
    private final String mInterfaceName;
    @NonNull
    public static final Parcelable.Creator<EthernetNetworkSpecifier> CREATOR = new Parcelable.Creator<EthernetNetworkSpecifier>(){

        @Override
        public EthernetNetworkSpecifier createFromParcel(Parcel in) {
            return new EthernetNetworkSpecifier(in.readString());
        }

        public EthernetNetworkSpecifier[] newArray(int size) {
            return new EthernetNetworkSpecifier[size];
        }
    };

    public EthernetNetworkSpecifier(@NonNull String interfaceName) {
        if (TextUtils.isEmpty(interfaceName)) {
            throw new IllegalArgumentException();
        }
        this.mInterfaceName = interfaceName;
    }

    @Nullable
    public String getInterfaceName() {
        return this.mInterfaceName;
    }

    @Override
    public boolean canBeSatisfiedBy(@Nullable NetworkSpecifier other) {
        return this.equals(other);
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof EthernetNetworkSpecifier)) {
            return false;
        }
        return TextUtils.equals(this.mInterfaceName, ((EthernetNetworkSpecifier)o).mInterfaceName);
    }

    public int hashCode() {
        return Objects.hashCode(this.mInterfaceName);
    }

    public String toString() {
        return "EthernetNetworkSpecifier (" + this.mInterfaceName + ")";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mInterfaceName);
    }
}

