/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.media.tv.BroadcastInfoResponse;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;

public class TimelineResponse
extends BroadcastInfoResponse
implements Parcelable {
    private static final int RESPONSE_TYPE = 8;
    @NonNull
    public static final Parcelable.Creator<TimelineResponse> CREATOR = new Parcelable.Creator<TimelineResponse>(){

        @Override
        public TimelineResponse createFromParcel(Parcel source) {
            source.readInt();
            return TimelineResponse.createFromParcelBody(source);
        }

        public TimelineResponse[] newArray(int size) {
            return new TimelineResponse[size];
        }
    };
    private final String mSelector;
    private final int mUnitsPerTick;
    private final int mUnitsPerSecond;
    private final long mWallClock;
    private final long mTicks;

    static TimelineResponse createFromParcelBody(Parcel in) {
        return new TimelineResponse(in);
    }

    public TimelineResponse(int requestId, int sequence, int responseResult, @Nullable String selector, int unitsPerTick, int unitsPerSecond, long wallClock, long ticks) {
        super(8, requestId, sequence, responseResult);
        this.mSelector = selector;
        this.mUnitsPerTick = unitsPerTick;
        this.mUnitsPerSecond = unitsPerSecond;
        this.mWallClock = wallClock;
        this.mTicks = ticks;
    }

    TimelineResponse(Parcel source) {
        super(8, source);
        this.mSelector = source.readString();
        this.mUnitsPerTick = source.readInt();
        this.mUnitsPerSecond = source.readInt();
        this.mWallClock = source.readLong();
        this.mTicks = source.readLong();
    }

    @Nullable
    public Uri getSelector() {
        return Uri.parse(this.mSelector);
    }

    public int getUnitsPerTick() {
        return this.mUnitsPerTick;
    }

    public int getUnitsPerSecond() {
        return this.mUnitsPerSecond;
    }

    public long getWallClock() {
        return this.mWallClock;
    }

    public long getTicks() {
        return this.mTicks;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.mSelector);
        dest.writeInt(this.mUnitsPerTick);
        dest.writeInt(this.mUnitsPerSecond);
        dest.writeLong(this.mWallClock);
        dest.writeLong(this.mTicks);
    }
}

