/*
 * Decompiled with CFR 0.152.
 */
package android.media.quality;

import android.media.quality.AmbientBacklightSettings;
import android.media.quality.IActiveProcessingPictureListener;
import android.media.quality.IAmbientBacklightCallback;
import android.media.quality.IPictureProfileCallback;
import android.media.quality.ISoundProfileCallback;
import android.media.quality.ParameterCapability;
import android.media.quality.PictureProfile;
import android.media.quality.PictureProfileHandle;
import android.media.quality.SoundProfile;
import android.media.quality.SoundProfileHandle;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IMediaQualityManager
extends IInterface {
    public static final String DESCRIPTOR = "android.media.quality.IMediaQualityManager";

    public void createPictureProfile(PictureProfile var1, int var2) throws RemoteException;

    public void updatePictureProfile(String var1, PictureProfile var2, int var3) throws RemoteException;

    public void removePictureProfile(String var1, int var2) throws RemoteException;

    public boolean setDefaultPictureProfile(String var1, int var2) throws RemoteException;

    public PictureProfile getPictureProfile(int var1, String var2, boolean var3, int var4) throws RemoteException;

    public List<PictureProfile> getPictureProfilesByPackage(String var1, boolean var2, int var3) throws RemoteException;

    public List<PictureProfile> getAvailablePictureProfiles(boolean var1, int var2) throws RemoteException;

    public List<String> getPictureProfilePackageNames(int var1) throws RemoteException;

    public List<String> getPictureProfileAllowList(int var1) throws RemoteException;

    public void setPictureProfileAllowList(List<String> var1, int var2) throws RemoteException;

    public List<PictureProfileHandle> getPictureProfileHandle(String[] var1, int var2) throws RemoteException;

    public long getPictureProfileHandleValue(String var1, int var2) throws RemoteException;

    public long getDefaultPictureProfileHandleValue(int var1) throws RemoteException;

    public void notifyPictureProfileHandleSelection(long var1, int var3) throws RemoteException;

    public long getPictureProfileForTvInput(String var1, int var2) throws RemoteException;

    public void createSoundProfile(SoundProfile var1, int var2) throws RemoteException;

    public void updateSoundProfile(String var1, SoundProfile var2, int var3) throws RemoteException;

    public void removeSoundProfile(String var1, int var2) throws RemoteException;

    public boolean setDefaultSoundProfile(String var1, int var2) throws RemoteException;

    public SoundProfile getSoundProfile(int var1, String var2, boolean var3, int var4) throws RemoteException;

    public List<SoundProfile> getSoundProfilesByPackage(String var1, boolean var2, int var3) throws RemoteException;

    public List<SoundProfile> getAvailableSoundProfiles(boolean var1, int var2) throws RemoteException;

    public List<String> getSoundProfilePackageNames(int var1) throws RemoteException;

    public List<String> getSoundProfileAllowList(int var1) throws RemoteException;

    public void setSoundProfileAllowList(List<String> var1, int var2) throws RemoteException;

    public List<SoundProfileHandle> getSoundProfileHandle(String[] var1, int var2) throws RemoteException;

    public void registerPictureProfileCallback(IPictureProfileCallback var1) throws RemoteException;

    public void registerSoundProfileCallback(ISoundProfileCallback var1) throws RemoteException;

    public void registerAmbientBacklightCallback(IAmbientBacklightCallback var1) throws RemoteException;

    public void registerActiveProcessingPictureListener(IActiveProcessingPictureListener var1) throws RemoteException;

    public List<ParameterCapability> getParameterCapabilities(List<String> var1, int var2) throws RemoteException;

    public boolean isSupported(int var1) throws RemoteException;

    public void setAutoPictureQualityEnabled(boolean var1, int var2) throws RemoteException;

    public boolean isAutoPictureQualityEnabled(int var1) throws RemoteException;

    public void setSuperResolutionEnabled(boolean var1, int var2) throws RemoteException;

    public boolean isSuperResolutionEnabled(int var1) throws RemoteException;

    public void setAutoSoundQualityEnabled(boolean var1, int var2) throws RemoteException;

    public boolean isAutoSoundQualityEnabled(int var1) throws RemoteException;

    public void setAmbientBacklightSettings(AmbientBacklightSettings var1, int var2) throws RemoteException;

    public void setAmbientBacklightEnabled(boolean var1, int var2) throws RemoteException;

    public boolean isAmbientBacklightEnabled(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMediaQualityManager {
        static final int TRANSACTION_createPictureProfile = 1;
        static final int TRANSACTION_updatePictureProfile = 2;
        static final int TRANSACTION_removePictureProfile = 3;
        static final int TRANSACTION_setDefaultPictureProfile = 4;
        static final int TRANSACTION_getPictureProfile = 5;
        static final int TRANSACTION_getPictureProfilesByPackage = 6;
        static final int TRANSACTION_getAvailablePictureProfiles = 7;
        static final int TRANSACTION_getPictureProfilePackageNames = 8;
        static final int TRANSACTION_getPictureProfileAllowList = 9;
        static final int TRANSACTION_setPictureProfileAllowList = 10;
        static final int TRANSACTION_getPictureProfileHandle = 11;
        static final int TRANSACTION_getPictureProfileHandleValue = 12;
        static final int TRANSACTION_getDefaultPictureProfileHandleValue = 13;
        static final int TRANSACTION_notifyPictureProfileHandleSelection = 14;
        static final int TRANSACTION_getPictureProfileForTvInput = 15;
        static final int TRANSACTION_createSoundProfile = 16;
        static final int TRANSACTION_updateSoundProfile = 17;
        static final int TRANSACTION_removeSoundProfile = 18;
        static final int TRANSACTION_setDefaultSoundProfile = 19;
        static final int TRANSACTION_getSoundProfile = 20;
        static final int TRANSACTION_getSoundProfilesByPackage = 21;
        static final int TRANSACTION_getAvailableSoundProfiles = 22;
        static final int TRANSACTION_getSoundProfilePackageNames = 23;
        static final int TRANSACTION_getSoundProfileAllowList = 24;
        static final int TRANSACTION_setSoundProfileAllowList = 25;
        static final int TRANSACTION_getSoundProfileHandle = 26;
        static final int TRANSACTION_registerPictureProfileCallback = 27;
        static final int TRANSACTION_registerSoundProfileCallback = 28;
        static final int TRANSACTION_registerAmbientBacklightCallback = 29;
        static final int TRANSACTION_registerActiveProcessingPictureListener = 30;
        static final int TRANSACTION_getParameterCapabilities = 31;
        static final int TRANSACTION_isSupported = 32;
        static final int TRANSACTION_setAutoPictureQualityEnabled = 33;
        static final int TRANSACTION_isAutoPictureQualityEnabled = 34;
        static final int TRANSACTION_setSuperResolutionEnabled = 35;
        static final int TRANSACTION_isSuperResolutionEnabled = 36;
        static final int TRANSACTION_setAutoSoundQualityEnabled = 37;
        static final int TRANSACTION_isAutoSoundQualityEnabled = 38;
        static final int TRANSACTION_setAmbientBacklightSettings = 39;
        static final int TRANSACTION_setAmbientBacklightEnabled = 40;
        static final int TRANSACTION_isAmbientBacklightEnabled = 41;

        public Stub() {
            this.attachInterface(this, IMediaQualityManager.DESCRIPTOR);
        }

        public static IMediaQualityManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IMediaQualityManager.DESCRIPTOR);
            if (iin != null && iin instanceof IMediaQualityManager) {
                return (IMediaQualityManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IMediaQualityManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    PictureProfile _arg0 = data.readTypedObject(PictureProfile.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.createPictureProfile(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    PictureProfile _arg1 = data.readTypedObject(PictureProfile.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.updatePictureProfile(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.removePictureProfile(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.setDefaultPictureProfile(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    boolean _arg2 = data.readBoolean();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    PictureProfile _result = this.getPictureProfile(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    List<PictureProfile> _result = this.getPictureProfilesByPackage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 7: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    List<PictureProfile> _result = this.getAvailablePictureProfiles(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<String> _result = this.getPictureProfilePackageNames(_arg0);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<String> _result = this.getPictureProfileAllowList(_arg0);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 10: {
                    ArrayList<String> _arg0 = data.createStringArrayList();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setPictureProfileAllowList(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    String[] _arg0 = data.createStringArray();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    List<PictureProfileHandle> _result = this.getPictureProfileHandle(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 12: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    long _result = this.getPictureProfileHandleValue(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    long _result = this.getDefaultPictureProfileHandleValue(_arg0);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 14: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyPictureProfileHandleSelection(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    long _result = this.getPictureProfileForTvInput(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 16: {
                    SoundProfile _arg0 = data.readTypedObject(SoundProfile.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.createSoundProfile(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    String _arg0 = data.readString();
                    SoundProfile _arg1 = data.readTypedObject(SoundProfile.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.updateSoundProfile(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.removeSoundProfile(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.setDefaultSoundProfile(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 20: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    boolean _arg2 = data.readBoolean();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    SoundProfile _result = this.getSoundProfile(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 21: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    List<SoundProfile> _result = this.getSoundProfilesByPackage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 22: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    List<SoundProfile> _result = this.getAvailableSoundProfiles(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 23: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<String> _result = this.getSoundProfilePackageNames(_arg0);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 24: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<String> _result = this.getSoundProfileAllowList(_arg0);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 25: {
                    ArrayList<String> _arg0 = data.createStringArrayList();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setSoundProfileAllowList(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    String[] _arg0 = data.createStringArray();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    List<SoundProfileHandle> _result = this.getSoundProfileHandle(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 27: {
                    IPictureProfileCallback _arg0 = IPictureProfileCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerPictureProfileCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    ISoundProfileCallback _arg0 = ISoundProfileCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerSoundProfileCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 29: {
                    IAmbientBacklightCallback _arg0 = IAmbientBacklightCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerAmbientBacklightCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 30: {
                    IActiveProcessingPictureListener _arg0 = IActiveProcessingPictureListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerActiveProcessingPictureListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 31: {
                    ArrayList<String> _arg0 = data.createStringArrayList();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    List<ParameterCapability> _result = this.getParameterCapabilities(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 32: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isSupported(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 33: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setAutoPictureQualityEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 34: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isAutoPictureQualityEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 35: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setSuperResolutionEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 36: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isSuperResolutionEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 37: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setAutoSoundQualityEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 38: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isAutoSoundQualityEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 39: {
                    AmbientBacklightSettings _arg0 = data.readTypedObject(AmbientBacklightSettings.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setAmbientBacklightSettings(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 40: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setAmbientBacklightEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 41: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isAmbientBacklightEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IMediaQualityManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IMediaQualityManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createPictureProfile(PictureProfile pp, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeTypedObject(pp, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updatePictureProfile(String id2, PictureProfile pp, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeString(id2);
                    _data.writeTypedObject(pp, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removePictureProfile(String id2, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeString(id2);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setDefaultPictureProfile(String id2, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeString(id2);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PictureProfile getPictureProfile(int type, String name, boolean includeParams, int userId) throws RemoteException {
                PictureProfile _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeInt(type);
                    _data.writeString(name);
                    _data.writeBoolean(includeParams);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PictureProfile.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<PictureProfile> getPictureProfilesByPackage(String packageName, boolean includeParams, int userId) throws RemoteException {
                ArrayList<PictureProfile> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeBoolean(includeParams);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(PictureProfile.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<PictureProfile> getAvailablePictureProfiles(boolean includeParams, int userId) throws RemoteException {
                ArrayList<PictureProfile> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeBoolean(includeParams);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(PictureProfile.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getPictureProfilePackageNames(int userId) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getPictureProfileAllowList(int userId) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPictureProfileAllowList(List<String> packages, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeStringList(packages);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<PictureProfileHandle> getPictureProfileHandle(String[] id2, int userId) throws RemoteException {
                ArrayList<PictureProfileHandle> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeStringArray(id2);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(PictureProfileHandle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getPictureProfileHandleValue(String id2, int userId) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeString(id2);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getDefaultPictureProfileHandleValue(int userId) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyPictureProfileHandleSelection(long handle, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeLong(handle);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getPictureProfileForTvInput(String inputId, int userId) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeString(inputId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createSoundProfile(SoundProfile pp, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeTypedObject(pp, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateSoundProfile(String id2, SoundProfile pp, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeString(id2);
                    _data.writeTypedObject(pp, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeSoundProfile(String id2, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeString(id2);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setDefaultSoundProfile(String id2, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeString(id2);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SoundProfile getSoundProfile(int type, String name, boolean includeParams, int userId) throws RemoteException {
                SoundProfile _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeInt(type);
                    _data.writeString(name);
                    _data.writeBoolean(includeParams);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(SoundProfile.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SoundProfile> getSoundProfilesByPackage(String packageName, boolean includeParams, int userId) throws RemoteException {
                ArrayList<SoundProfile> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeBoolean(includeParams);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(SoundProfile.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SoundProfile> getAvailableSoundProfiles(boolean includeParams, int userId) throws RemoteException {
                ArrayList<SoundProfile> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeBoolean(includeParams);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(SoundProfile.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getSoundProfilePackageNames(int userId) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getSoundProfileAllowList(int userId) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSoundProfileAllowList(List<String> packages, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeStringList(packages);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SoundProfileHandle> getSoundProfileHandle(String[] id2, int userId) throws RemoteException {
                ArrayList<SoundProfileHandle> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeStringArray(id2);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(SoundProfileHandle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerPictureProfileCallback(IPictureProfileCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSoundProfileCallback(ISoundProfileCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerAmbientBacklightCallback(IAmbientBacklightCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeStrongInterface(cb);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerActiveProcessingPictureListener(IActiveProcessingPictureListener l) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeStrongInterface(l);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ParameterCapability> getParameterCapabilities(List<String> names, int userId) throws RemoteException {
                ArrayList<ParameterCapability> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeStringList(names);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(ParameterCapability.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSupported(int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAutoPictureQualityEnabled(boolean enabled, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAutoPictureQualityEnabled(int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSuperResolutionEnabled(boolean enabled, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSuperResolutionEnabled(int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAutoSoundQualityEnabled(boolean enabled, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAutoSoundQualityEnabled(int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAmbientBacklightSettings(AmbientBacklightSettings settings, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeTypedObject(settings, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAmbientBacklightEnabled(boolean enabled, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAmbientBacklightEnabled(int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMediaQualityManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IMediaQualityManager {
        @Override
        public void createPictureProfile(PictureProfile pp, int userId) throws RemoteException {
        }

        @Override
        public void updatePictureProfile(String id2, PictureProfile pp, int userId) throws RemoteException {
        }

        @Override
        public void removePictureProfile(String id2, int userId) throws RemoteException {
        }

        @Override
        public boolean setDefaultPictureProfile(String id2, int userId) throws RemoteException {
            return false;
        }

        @Override
        public PictureProfile getPictureProfile(int type, String name, boolean includeParams, int userId) throws RemoteException {
            return null;
        }

        @Override
        public List<PictureProfile> getPictureProfilesByPackage(String packageName, boolean includeParams, int userId) throws RemoteException {
            return null;
        }

        @Override
        public List<PictureProfile> getAvailablePictureProfiles(boolean includeParams, int userId) throws RemoteException {
            return null;
        }

        @Override
        public List<String> getPictureProfilePackageNames(int userId) throws RemoteException {
            return null;
        }

        @Override
        public List<String> getPictureProfileAllowList(int userId) throws RemoteException {
            return null;
        }

        @Override
        public void setPictureProfileAllowList(List<String> packages, int userId) throws RemoteException {
        }

        @Override
        public List<PictureProfileHandle> getPictureProfileHandle(String[] id2, int userId) throws RemoteException {
            return null;
        }

        @Override
        public long getPictureProfileHandleValue(String id2, int userId) throws RemoteException {
            return 0L;
        }

        @Override
        public long getDefaultPictureProfileHandleValue(int userId) throws RemoteException {
            return 0L;
        }

        @Override
        public void notifyPictureProfileHandleSelection(long handle, int userId) throws RemoteException {
        }

        @Override
        public long getPictureProfileForTvInput(String inputId, int userId) throws RemoteException {
            return 0L;
        }

        @Override
        public void createSoundProfile(SoundProfile pp, int userId) throws RemoteException {
        }

        @Override
        public void updateSoundProfile(String id2, SoundProfile pp, int userId) throws RemoteException {
        }

        @Override
        public void removeSoundProfile(String id2, int userId) throws RemoteException {
        }

        @Override
        public boolean setDefaultSoundProfile(String id2, int userId) throws RemoteException {
            return false;
        }

        @Override
        public SoundProfile getSoundProfile(int type, String name, boolean includeParams, int userId) throws RemoteException {
            return null;
        }

        @Override
        public List<SoundProfile> getSoundProfilesByPackage(String packageName, boolean includeParams, int userId) throws RemoteException {
            return null;
        }

        @Override
        public List<SoundProfile> getAvailableSoundProfiles(boolean includeParams, int userId) throws RemoteException {
            return null;
        }

        @Override
        public List<String> getSoundProfilePackageNames(int userId) throws RemoteException {
            return null;
        }

        @Override
        public List<String> getSoundProfileAllowList(int userId) throws RemoteException {
            return null;
        }

        @Override
        public void setSoundProfileAllowList(List<String> packages, int userId) throws RemoteException {
        }

        @Override
        public List<SoundProfileHandle> getSoundProfileHandle(String[] id2, int userId) throws RemoteException {
            return null;
        }

        @Override
        public void registerPictureProfileCallback(IPictureProfileCallback cb) throws RemoteException {
        }

        @Override
        public void registerSoundProfileCallback(ISoundProfileCallback cb) throws RemoteException {
        }

        @Override
        public void registerAmbientBacklightCallback(IAmbientBacklightCallback cb) throws RemoteException {
        }

        @Override
        public void registerActiveProcessingPictureListener(IActiveProcessingPictureListener l) throws RemoteException {
        }

        @Override
        public List<ParameterCapability> getParameterCapabilities(List<String> names, int userId) throws RemoteException {
            return null;
        }

        @Override
        public boolean isSupported(int userId) throws RemoteException {
            return false;
        }

        @Override
        public void setAutoPictureQualityEnabled(boolean enabled, int userId) throws RemoteException {
        }

        @Override
        public boolean isAutoPictureQualityEnabled(int userId) throws RemoteException {
            return false;
        }

        @Override
        public void setSuperResolutionEnabled(boolean enabled, int userId) throws RemoteException {
        }

        @Override
        public boolean isSuperResolutionEnabled(int userId) throws RemoteException {
            return false;
        }

        @Override
        public void setAutoSoundQualityEnabled(boolean enabled, int userId) throws RemoteException {
        }

        @Override
        public boolean isAutoSoundQualityEnabled(int userId) throws RemoteException {
            return false;
        }

        @Override
        public void setAmbientBacklightSettings(AmbientBacklightSettings settings, int userId) throws RemoteException {
        }

        @Override
        public void setAmbientBacklightEnabled(boolean enabled, int userId) throws RemoteException {
        }

        @Override
        public boolean isAmbientBacklightEnabled(int userId) throws RemoteException {
            return false;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

