/*
 * Decompiled with CFR 0.152.
 */
package android.media.quality;

import android.annotation.FlaggedApi;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.layoutlib.androidx.annotation.NonNull;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@FlaggedApi(value="android.media.tv.flags.media_quality_fw")
public class AmbientBacklightSettings
implements Parcelable {
    public static final int SOURCE_NONE = 0;
    public static final int SOURCE_AUDIO = 1;
    public static final int SOURCE_VIDEO = 2;
    public static final int SOURCE_AUDIO_VIDEO = 3;
    private final int mSource;
    private final int mMaxFps;
    private final int mColorFormat;
    private final int mHorizontalZonesNumber;
    private final int mVerticalZonesNumber;
    private final boolean mIsLetterboxOmitted;
    private final int mThreshold;
    @NonNull
    public static final Parcelable.Creator<AmbientBacklightSettings> CREATOR = new Parcelable.Creator<AmbientBacklightSettings>(){

        @Override
        public AmbientBacklightSettings createFromParcel(Parcel in) {
            return new AmbientBacklightSettings(in);
        }

        public AmbientBacklightSettings[] newArray(int size) {
            return new AmbientBacklightSettings[size];
        }
    };

    public AmbientBacklightSettings(int source, int maxFps, int colorFormat, int horizontalZonesNumber, int verticalZonesNumber, boolean isLetterboxOmitted, int threshold) {
        this.mSource = source;
        this.mMaxFps = maxFps;
        this.mColorFormat = colorFormat;
        this.mHorizontalZonesNumber = horizontalZonesNumber;
        this.mVerticalZonesNumber = verticalZonesNumber;
        this.mIsLetterboxOmitted = isLetterboxOmitted;
        this.mThreshold = threshold;
    }

    private AmbientBacklightSettings(Parcel in) {
        this.mSource = in.readInt();
        this.mMaxFps = in.readInt();
        this.mColorFormat = in.readInt();
        this.mHorizontalZonesNumber = in.readInt();
        this.mVerticalZonesNumber = in.readInt();
        this.mIsLetterboxOmitted = in.readBoolean();
        this.mThreshold = in.readInt();
    }

    public int getSource() {
        return this.mSource;
    }

    public int getMaxFps() {
        return this.mMaxFps;
    }

    public int getColorFormat() {
        return this.mColorFormat;
    }

    public int getHorizontalZonesCount() {
        return this.mHorizontalZonesNumber;
    }

    public int getVerticalZonesCount() {
        return this.mVerticalZonesNumber;
    }

    public boolean isLetterboxOmitted() {
        return this.mIsLetterboxOmitted;
    }

    public int getThreshold() {
        return this.mThreshold;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mSource);
        dest.writeInt(this.mMaxFps);
        dest.writeInt(this.mColorFormat);
        dest.writeInt(this.mHorizontalZonesNumber);
        dest.writeInt(this.mVerticalZonesNumber);
        dest.writeBoolean(this.mIsLetterboxOmitted);
        dest.writeInt(this.mThreshold);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "AmbientBacklightSettings{Source=" + this.mSource + ", MaxFps=" + this.mMaxFps + ", ColorFormat=" + this.mColorFormat + ", HorizontalZonesNumber=" + this.mHorizontalZonesNumber + ", VerticalZonesNumber=" + this.mVerticalZonesNumber + ", IsLetterboxOmitted=" + this.mIsLetterboxOmitted + ", Threshold=" + this.mThreshold + "}";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Source {
    }
}

