/*
 * Decompiled with CFR 0.152.
 */
package android.media.projection;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.media.projection.flags.Flags;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Objects;

public class MediaProjectionConfig
implements Parcelable {
    @FlaggedApi(value="com.android.media.projection.flags.app_content_sharing")
    public static final int PROJECTION_SOURCE_DISPLAY = 2;
    public static final int PROJECTION_SOURCE_DISPLAY_REGION = 4;
    @FlaggedApi(value="com.android.media.projection.flags.app_content_sharing")
    public static final int PROJECTION_SOURCE_APP = 8;
    @FlaggedApi(value="com.android.media.projection.flags.app_content_sharing")
    public static final int PROJECTION_SOURCE_APP_CONTENT = 16;
    public static final int CAPTURE_REGION_USER_CHOICE = 0;
    public static final int DEFAULT_PROJECTION_SOURCES = 10;
    public static final int CAPTURE_REGION_FIXED_DISPLAY = 1;
    private static final int[] PROJECTION_SOURCES = new int[]{2, 4, 8, 16};
    private static final String[] PROJECTION_SOURCES_STRING = new String[]{"PROJECTION_SOURCE_DISPLAY", "PROJECTION_SOURCE_DISPLAY_REGION", "PROJECTION_SOURCE_APP", "PROJECTION_SOURCE_APP_CONTENT"};
    private static final int VALID_PROJECTION_SOURCES = MediaProjectionConfig.createValidSourcesMask();
    private final int mInitialSelection;
    private final int mDisplayToCapture;
    @Deprecated
    private int mRegionToCapture;
    private final int mProjectionSources;
    @Nullable
    private final String mRequesterHint;
    @NonNull
    public static final Parcelable.Creator<MediaProjectionConfig> CREATOR = new Parcelable.Creator<MediaProjectionConfig>(){

        public MediaProjectionConfig[] newArray(int size) {
            return new MediaProjectionConfig[size];
        }

        @Override
        public MediaProjectionConfig createFromParcel(@NonNull Parcel in) {
            return new MediaProjectionConfig(in);
        }
    };

    @Deprecated
    private MediaProjectionConfig(int captureRegion) {
        if (Flags.appContentSharing()) {
            throw new UnsupportedOperationException("Flag FLAG_APP_CONTENT_SHARING enabled. This method must not be called.");
        }
        this.mRegionToCapture = captureRegion;
        this.mDisplayToCapture = 0;
        this.mRequesterHint = null;
        this.mInitialSelection = -1;
        this.mProjectionSources = -1;
    }

    private MediaProjectionConfig(int projectionSource, @Nullable String requesterHint, int displayId, int initialSelection) {
        if (!Flags.appContentSharing()) {
            throw new UnsupportedOperationException("Flag FLAG_APP_CONTENT_SHARING disabled. This method must not be called");
        }
        this.mProjectionSources = projectionSource == 0 ? 10 : projectionSource;
        this.mRequesterHint = requesterHint;
        this.mDisplayToCapture = displayId;
        this.mInitialSelection = initialSelection;
    }

    @NonNull
    public static MediaProjectionConfig createConfigForDefaultDisplay() {
        if (Flags.appContentSharing()) {
            return new Builder().setSourceEnabled(2, true).build();
        }
        return new MediaProjectionConfig(1);
    }

    @NonNull
    public static MediaProjectionConfig createConfigForUserChoice() {
        if (Flags.appContentSharing()) {
            return new Builder().build();
        }
        return new MediaProjectionConfig(0);
    }

    @Deprecated
    @NonNull
    private static String captureRegionToString(int value) {
        String string2;
        switch (value) {
            case 0: {
                string2 = "CAPTURE_REGION_USERS_CHOICE";
                break;
            }
            case 1: {
                string2 = "CAPTURE_REGION_GIVEN_DISPLAY";
                break;
            }
            default: {
                string2 = Integer.toHexString(value);
            }
        }
        return string2;
    }

    @NonNull
    private static String projectionSourceToString(int value) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < PROJECTION_SOURCES.length; ++i) {
            if ((value & PROJECTION_SOURCES[i]) <= 0) continue;
            stringBuilder.append(PROJECTION_SOURCES_STRING[i]);
            stringBuilder.append(" ");
            value &= ~PROJECTION_SOURCES[i];
        }
        if (value > 0) {
            stringBuilder.append("Unknown projection sources: ");
            stringBuilder.append(Integer.toHexString(value));
        }
        return stringBuilder.toString();
    }

    public String toString() {
        if (Flags.appContentSharing()) {
            return "MediaProjectionConfig{mInitialSelection=%d, mDisplayToCapture=%d, mProjectionSource=%s, mRequesterHint='%s'}".formatted(this.mInitialSelection, this.mDisplayToCapture, MediaProjectionConfig.projectionSourceToString(this.mProjectionSources), this.mRequesterHint);
        }
        return "MediaProjectionConfig { displayToCapture = " + this.mDisplayToCapture + ", regionToCapture = " + MediaProjectionConfig.captureRegionToString(this.mRegionToCapture) + " }";
    }

    public int getDisplayToCapture() {
        return this.mDisplayToCapture;
    }

    public int getRegionToCapture() {
        return this.mRegionToCapture;
    }

    @FlaggedApi(value="com.android.media.projection.flags.app_content_sharing")
    public int getProjectionSources() {
        return this.mProjectionSources;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaProjectionConfig that = (MediaProjectionConfig)o;
        if (Flags.appContentSharing()) {
            return this.mDisplayToCapture == that.mDisplayToCapture && this.mProjectionSources == that.mProjectionSources && this.mInitialSelection == that.mInitialSelection && Objects.equals(this.mRequesterHint, that.mRequesterHint);
        }
        return this.mDisplayToCapture == that.mDisplayToCapture && this.mRegionToCapture == that.mRegionToCapture;
    }

    public int hashCode() {
        int _hash = 1;
        if (Flags.appContentSharing()) {
            return Objects.hash(this.mDisplayToCapture, this.mProjectionSources, this.mInitialSelection, this.mRequesterHint);
        }
        _hash = 31 * _hash + this.mDisplayToCapture;
        _hash = 31 * _hash + this.mRegionToCapture;
        return _hash;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mDisplayToCapture);
        if (Flags.appContentSharing()) {
            dest.writeInt(this.mProjectionSources);
            dest.writeString(this.mRequesterHint);
            dest.writeInt(this.mInitialSelection);
        } else {
            dest.writeInt(this.mRegionToCapture);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    MediaProjectionConfig(@NonNull Parcel in) {
        this.mDisplayToCapture = in.readInt();
        if (Flags.appContentSharing()) {
            this.mProjectionSources = in.readInt();
            this.mRequesterHint = in.readString();
            this.mInitialSelection = in.readInt();
        } else {
            this.mRegionToCapture = in.readInt();
            this.mProjectionSources = -1;
            this.mRequesterHint = null;
            this.mInitialSelection = -1;
        }
    }

    @FlaggedApi(value="com.android.media.projection.flags.app_content_sharing")
    public boolean isSourceEnabled(int projectionSource) {
        return (this.mProjectionSources & projectionSource) > 0;
    }

    @FlaggedApi(value="com.android.media.projection.flags.app_content_sharing")
    public int getInitiallySelectedSource() {
        return this.mInitialSelection;
    }

    @FlaggedApi(value="com.android.media.projection.flags.app_content_sharing")
    @Nullable
    public CharSequence getRequesterHint() {
        return this.mRequesterHint;
    }

    private static int createValidSourcesMask() {
        int validSources = 0;
        for (int projectionSource : PROJECTION_SOURCES) {
            validSources |= projectionSource;
        }
        return validSources;
    }

    @FlaggedApi(value="com.android.media.projection.flags.app_content_sharing")
    public static class Builder {
        private int mOptions = 0;
        private String mRequesterHint = null;
        private int mInitialSelection;

        public Builder() {
            if (!Flags.appContentSharing()) {
                throw new UnsupportedOperationException("Flag FLAG_APP_CONTENT_SHARING disabled");
            }
        }

        @NonNull
        public Builder setInitiallySelectedSource(int projectionSource) {
            for (int source : PROJECTION_SOURCES) {
                if (projectionSource != source) continue;
                this.mInitialSelection = projectionSource;
                return this;
            }
            throw new IllegalArgumentException("projectionSource is no a valid projection source. projectionSource must be one of %s but was %s".formatted(Arrays.toString(PROJECTION_SOURCES_STRING), MediaProjectionConfig.projectionSourceToString(projectionSource)));
        }

        @NonNull
        public Builder setRequesterHint(@Nullable String requesterHint) {
            this.mRequesterHint = requesterHint;
            return this;
        }

        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setSourceEnabled(int source, boolean enabled) {
            if ((source & VALID_PROJECTION_SOURCES) == 0) {
                throw new IllegalArgumentException("source is no a valid projection source. source must be any of %s but was %s".formatted(Arrays.toString(PROJECTION_SOURCES_STRING), MediaProjectionConfig.projectionSourceToString(source)));
            }
            this.mOptions = enabled ? this.mOptions | source : this.mOptions & ~source;
            return this;
        }

        @NonNull
        public MediaProjectionConfig build() {
            return new MediaProjectionConfig(this.mOptions, this.mRequesterHint, 0, this.mInitialSelection);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MediaProjectionSource {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Deprecated
    public static @interface CaptureRegion {
    }
}

