/*
 * Decompiled with CFR 0.152.
 */
package android.media.projection;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.compat.CompatChanges;
import android.content.Context;
import android.hardware.display.DisplayManager;
import android.hardware.display.VirtualDisplay;
import android.hardware.display.VirtualDisplayConfig;
import android.media.projection.IMediaProjection;
import android.media.projection.IMediaProjectionCallback;
import android.media.projection.StopReason;
import android.os.Handler;
import android.os.RemoteException;
import android.os.UserManager;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Slog;
import android.view.Surface;
import com.android.internal.annotations.VisibleForTesting;
import com.android.media.projection.flags.Flags;
import java.util.Map;
import java.util.Objects;

public class MediaProjection {
    private static final String TAG = "MediaProjection";
    @VisibleForTesting
    static final long MEDIA_PROJECTION_REQUIRES_CALLBACK = 269849258L;
    private final IMediaProjection mImpl;
    private final Context mContext;
    private final DisplayManager mDisplayManager;
    @NonNull
    private final Map<Callback, CallbackRecord> mCallbacks = new ArrayMap<Callback, CallbackRecord>();
    private final int mDisplayId;

    public MediaProjection(Context context, IMediaProjection impl) {
        this(context, impl, context.getSystemService(DisplayManager.class));
    }

    @VisibleForTesting
    public MediaProjection(Context context, IMediaProjection impl, DisplayManager displayManager) {
        this.mContext = context;
        this.mImpl = impl;
        this.mDisplayManager = displayManager;
        try {
            int displayId;
            this.mImpl.start(new MediaProjectionCallback());
            if (Flags.mediaProjectionConnectedDisplay() && (displayId = this.mImpl.getDisplayId()) != 0) {
                this.mDisplayId = displayId;
                Log.v(TAG, "Created MediaProjection for display " + this.mDisplayId);
                return;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Content Recording: Failed to start media projection", e);
            throw new RuntimeException("Failed to start media projection", e);
        }
        UserManager userManager = context.getSystemService(UserManager.class);
        this.mDisplayId = userManager.isVisibleBackgroundUsersSupported() ? userManager.getMainDisplayIdAssignedToUser() : 0;
    }

    public void registerCallback(@NonNull Callback callback, @Nullable Handler handler) {
        try {
            Callback c = Objects.requireNonNull(callback);
            if (handler == null) {
                handler = new Handler(this.mContext.getMainLooper());
            }
            this.mCallbacks.put(c, new CallbackRecord(c, handler));
        }
        catch (NullPointerException e) {
            Log.e(TAG, "Content Recording: cannot register null Callback", e);
            throw e;
        }
        catch (RuntimeException e) {
            Log.e(TAG, "Content Recording: failed to create new Handler to register Callback", e);
        }
    }

    public void unregisterCallback(@NonNull Callback callback) {
        try {
            Callback c = Objects.requireNonNull(callback);
            this.mCallbacks.remove(c);
        }
        catch (NullPointerException e) {
            Log.d(TAG, "Content Recording: cannot unregister null Callback", e);
            throw e;
        }
    }

    @Nullable
    public VirtualDisplay createVirtualDisplay(@NonNull String name, int width, int height, int dpi, boolean isSecure, @Nullable Surface surface, @Nullable VirtualDisplay.Callback callback, @Nullable Handler handler) {
        int flags = 18;
        if (isSecure) {
            flags |= 4;
        }
        VirtualDisplayConfig.Builder builder = new VirtualDisplayConfig.Builder(name, width, height, dpi).setFlags(flags);
        if (surface != null) {
            builder.setSurface(surface);
        }
        builder.setDisplayIdToMirror(this.mDisplayId);
        return this.createVirtualDisplay(builder, callback, handler);
    }

    @Nullable
    public VirtualDisplay createVirtualDisplay(@NonNull String name, int width, int height, int dpi, int flags, @Nullable Surface surface, @Nullable VirtualDisplay.Callback callback, @Nullable Handler handler) {
        if (this.shouldMediaProjectionRequireCallback() && this.mCallbacks.isEmpty()) {
            IllegalStateException e = new IllegalStateException("Must register a callback before starting capture, to manage resources in response to MediaProjection states.");
            Log.e(TAG, "Content Recording: no callback registered for virtual display", e);
            throw e;
        }
        VirtualDisplayConfig.Builder builder = new VirtualDisplayConfig.Builder(name, width, height, dpi).setFlags(flags);
        if (surface != null) {
            builder.setSurface(surface);
        }
        builder.setDisplayIdToMirror(this.mDisplayId);
        return this.createVirtualDisplay(builder, callback, handler);
    }

    @Nullable
    public VirtualDisplay createVirtualDisplay(@NonNull VirtualDisplayConfig.Builder virtualDisplayConfig, @Nullable VirtualDisplay.Callback callback, @Nullable Handler handler) {
        virtualDisplayConfig.setWindowManagerMirroringEnabled(true);
        VirtualDisplay virtualDisplay = this.mDisplayManager.createVirtualDisplay(this, virtualDisplayConfig.build(), callback, handler);
        if (virtualDisplay == null) {
            Slog.w(TAG, "Failed to create virtual display.");
            return null;
        }
        return virtualDisplay;
    }

    private boolean shouldMediaProjectionRequireCallback() {
        return CompatChanges.isChangeEnabled(269849258L);
    }

    public void stop() {
        try {
            Log.d(TAG, "Content Recording: stopping projection");
            this.mImpl.stop(1);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Unable to stop projection", e);
        }
    }

    public void stop(@StopReason int stopReason) {
        try {
            Log.d(TAG, "Content Recording: stopping projection");
            this.mImpl.stop(stopReason);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Unable to stop projection", e);
        }
    }

    public IMediaProjection getProjection() {
        return this.mImpl;
    }

    private class MediaProjectionCallback
    extends IMediaProjectionCallback.Stub {
        private MediaProjectionCallback() {
        }

        @Override
        public void onStop() {
            Slog.v(MediaProjection.TAG, "Dispatch stop to " + MediaProjection.this.mCallbacks.size() + " callbacks.");
            for (CallbackRecord cbr : MediaProjection.this.mCallbacks.values()) {
                cbr.onStop();
            }
        }

        @Override
        public void onCapturedContentResize(int width, int height) {
            for (CallbackRecord cbr : MediaProjection.this.mCallbacks.values()) {
                cbr.onCapturedContentResize(width, height);
            }
        }

        @Override
        public void onCapturedContentVisibilityChanged(boolean isVisible) {
            for (CallbackRecord cbr : MediaProjection.this.mCallbacks.values()) {
                cbr.onCapturedContentVisibilityChanged(isVisible);
            }
        }
    }

    public static abstract class Callback {
        public void onStop() {
        }

        public void onCapturedContentResize(int width, int height) {
        }

        public void onCapturedContentVisibilityChanged(boolean isVisible) {
        }
    }

    private static class CallbackRecord
    extends Callback {
        private final Callback mCallback;
        private final Handler mHandler;

        public CallbackRecord(Callback callback, Handler handler) {
            this.mCallback = callback;
            this.mHandler = handler;
        }

        @Override
        public void onStop() {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mCallback.onStop();
                }
            });
        }

        @Override
        public void onCapturedContentResize(int width, int height) {
            this.mHandler.post(() -> this.mCallback.onCapturedContentResize(width, height));
        }

        @Override
        public void onCapturedContentVisibilityChanged(boolean isVisible) {
            this.mHandler.post(() -> this.mCallback.onCapturedContentVisibilityChanged(isVisible));
        }
    }
}

