/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiopolicy;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.media.AudioAttributes;
import android.media.AudioSystem;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@SystemApi
public class AudioProductStrategy
implements Parcelable {
    public static final int DEFAULT_GROUP = -1;
    private static final String TAG = "AudioProductStrategy";
    private static final int AUDIO_FLAGS_AFFECT_STRATEGY_SELECTION = 13;
    private final AudioAttributesGroup[] mAudioAttributesGroups;
    private final String mName;
    private int mId;
    private static final Object sLock = new Object();
    @GuardedBy(value={"sLock"})
    private static List<AudioProductStrategy> sAudioProductStrategies;
    @NonNull
    public static final Parcelable.Creator<AudioProductStrategy> CREATOR;
    @NonNull
    private static final AudioAttributes DEFAULT_ATTRIBUTES;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static List<AudioProductStrategy> getAudioProductStrategies() {
        if (sAudioProductStrategies == null) {
            Object object = sLock;
            synchronized (object) {
                if (sAudioProductStrategies == null) {
                    sAudioProductStrategies = AudioProductStrategy.initializeAudioProductStrategies();
                }
            }
        }
        return sAudioProductStrategies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static AudioProductStrategy getAudioProductStrategyWithId(int id2) {
        Object object = sLock;
        synchronized (object) {
            if (sAudioProductStrategies == null) {
                sAudioProductStrategies = AudioProductStrategy.initializeAudioProductStrategies();
            }
            for (AudioProductStrategy strategy : sAudioProductStrategies) {
                if (strategy.getId() != id2) continue;
                return strategy;
            }
        }
        return null;
    }

    @SystemApi
    @NonNull
    public static AudioProductStrategy createInvalidAudioProductStrategy(int id2) {
        return new AudioProductStrategy("dummy strategy", id2, new AudioAttributesGroup[0]);
    }

    @NonNull
    public static AudioAttributes getAudioAttributesForStrategyWithLegacyStreamType(int streamType) {
        for (AudioProductStrategy productStrategy : AudioProductStrategy.getAudioProductStrategies()) {
            AudioAttributes aa = productStrategy.getAudioAttributesForLegacyStreamType(streamType);
            if (aa == null) continue;
            return aa;
        }
        return DEFAULT_ATTRIBUTES;
    }

    public static int getLegacyStreamTypeForStrategyWithAudioAttributes(@NonNull AudioAttributes audioAttributes) {
        Objects.requireNonNull(audioAttributes, "AudioAttributes must not be null");
        for (AudioProductStrategy productStrategy : AudioProductStrategy.getAudioProductStrategies()) {
            if (!productStrategy.supportsAudioAttributes(audioAttributes)) continue;
            int streamType = productStrategy.getLegacyStreamTypeForAudioAttributes(audioAttributes);
            if (streamType == -1) {
                Log.w(TAG, "Attributes " + audioAttributes + " supported by strategy " + productStrategy.getId() + " have no associated stream type, therefore falling back to STREAM_MUSIC");
                return 3;
            }
            if (streamType >= AudioSystem.getNumStreamTypes()) continue;
            return streamType;
        }
        return 3;
    }

    public static int getVolumeGroupIdForAudioAttributes(@NonNull AudioAttributes attributes, boolean fallbackOnDefault) {
        Objects.requireNonNull(attributes, "attributes must not be null");
        int volumeGroupId = AudioProductStrategy.getVolumeGroupIdForAudioAttributesInt(attributes);
        if (volumeGroupId != -1) {
            return volumeGroupId;
        }
        if (fallbackOnDefault) {
            return AudioProductStrategy.getVolumeGroupIdForAudioAttributesInt(AudioProductStrategy.getDefaultAttributes());
        }
        return -1;
    }

    private static List<AudioProductStrategy> initializeAudioProductStrategies() {
        ArrayList<AudioProductStrategy> apsList = new ArrayList<AudioProductStrategy>();
        int status = AudioProductStrategy.native_list_audio_product_strategies(apsList);
        if (status != 0) {
            Log.w(TAG, ": initializeAudioProductStrategies failed");
        }
        return apsList;
    }

    private static int native_list_audio_product_strategies(ArrayList<AudioProductStrategy> arrayList) {
        return OverrideMethod.invokeI("android.media.audiopolicy.AudioProductStrategy#native_list_audio_product_strategies(Ljava/util/ArrayList;)I", true, null);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudioProductStrategy thatStrategy = (AudioProductStrategy)o;
        return this.mId == thatStrategy.mId && Objects.equals(this.mName, thatStrategy.mName) && Arrays.equals(this.mAudioAttributesGroups, thatStrategy.mAudioAttributesGroups);
    }

    public int hashCode() {
        return Objects.hash(this.mId, this.mName, Arrays.hashCode(this.mAudioAttributesGroups));
    }

    private AudioProductStrategy(@NonNull String name, int id2, @NonNull AudioAttributesGroup[] aag) {
        Objects.requireNonNull(name, "name must not be null");
        Objects.requireNonNull(aag, "AudioAttributesGroups must not be null");
        this.mName = name;
        this.mId = id2;
        this.mAudioAttributesGroups = aag;
    }

    @SystemApi
    public int getId() {
        return this.mId;
    }

    @SystemApi
    @NonNull
    public String getName() {
        return this.mName;
    }

    @SystemApi
    @NonNull
    public AudioAttributes getAudioAttributes() {
        return this.mAudioAttributesGroups.length == 0 ? DEFAULT_ATTRIBUTES : this.mAudioAttributesGroups[0].getAudioAttributes();
    }

    @Nullable
    public AudioAttributes getAudioAttributesForLegacyStreamType(int streamType) {
        for (AudioAttributesGroup aag : this.mAudioAttributesGroups) {
            if (!aag.supportsStreamType(streamType)) continue;
            return aag.getAudioAttributes();
        }
        return null;
    }

    public int getLegacyStreamTypeForAudioAttributes(@NonNull AudioAttributes aa) {
        Objects.requireNonNull(aa, "AudioAttributes must not be null");
        for (AudioAttributesGroup aag : this.mAudioAttributesGroups) {
            if (!aag.supportsAttributes(aa)) continue;
            return aag.getStreamType();
        }
        return -1;
    }

    @SystemApi
    public boolean supportsAudioAttributes(@NonNull AudioAttributes aa) {
        Objects.requireNonNull(aa, "AudioAttributes must not be null");
        for (AudioAttributesGroup aag : this.mAudioAttributesGroups) {
            if (!aag.supportsAttributes(aa)) continue;
            return true;
        }
        return false;
    }

    public int getVolumeGroupIdForLegacyStreamType(int streamType) {
        for (AudioAttributesGroup aag : this.mAudioAttributesGroups) {
            if (!aag.supportsStreamType(streamType)) continue;
            return aag.getVolumeGroupId();
        }
        return -1;
    }

    public int getVolumeGroupIdForAudioAttributes(@NonNull AudioAttributes aa) {
        Objects.requireNonNull(aa, "AudioAttributes must not be null");
        for (AudioAttributesGroup aag : this.mAudioAttributesGroups) {
            if (!aag.supportsAttributes(aa)) continue;
            return aag.getVolumeGroupId();
        }
        return -1;
    }

    private static int getVolumeGroupIdForAudioAttributesInt(@NonNull AudioAttributes attributes) {
        Objects.requireNonNull(attributes, "attributes must not be null");
        for (AudioProductStrategy productStrategy : AudioProductStrategy.getAudioProductStrategies()) {
            int volumeGroupId = productStrategy.getVolumeGroupIdForAudioAttributes(attributes);
            if (volumeGroupId == -1) continue;
            return volumeGroupId;
        }
        return -1;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mName);
        dest.writeInt(this.mId);
        dest.writeInt(this.mAudioAttributesGroups.length);
        for (AudioAttributesGroup aag : this.mAudioAttributesGroups) {
            aag.writeToParcel(dest, flags);
        }
    }

    @NonNull
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("\n Name: ");
        s.append(this.mName);
        s.append(" Id: ");
        s.append(Integer.toString(this.mId));
        for (AudioAttributesGroup aag : this.mAudioAttributesGroups) {
            s.append(aag.toString());
        }
        return s.toString();
    }

    @NonNull
    public static AudioAttributes getDefaultAttributes() {
        return DEFAULT_ATTRIBUTES;
    }

    private static boolean attributesMatches(@NonNull AudioAttributes refAttr, @NonNull AudioAttributes attr2) {
        Objects.requireNonNull(refAttr, "reference AudioAttributes must not be null");
        Objects.requireNonNull(attr2, "requester's AudioAttributes must not be null");
        String refFormattedTags = TextUtils.join((CharSequence)";", refAttr.getTags());
        String cliFormattedTags = TextUtils.join((CharSequence)";", attr2.getTags());
        if (refAttr.equals(DEFAULT_ATTRIBUTES)) {
            return false;
        }
        return !(refAttr.getSystemUsage() != 0 && attr2.getSystemUsage() != refAttr.getSystemUsage() || refAttr.getContentType() != 0 && attr2.getContentType() != refAttr.getContentType() || (refAttr.getAllFlags() & 0xD) != 0 && ((attr2.getAllFlags() & 0xD) == 0 || (attr2.getAllFlags() & refAttr.getAllFlags()) != refAttr.getAllFlags()) || refFormattedTags.length() != 0 && !refFormattedTags.equals(cliFormattedTags));
    }

    static {
        CREATOR = new Parcelable.Creator<AudioProductStrategy>(){

            @Override
            public AudioProductStrategy createFromParcel(@NonNull Parcel in) {
                String name = in.readString();
                int id2 = in.readInt();
                int nbAttributesGroups = in.readInt();
                AudioAttributesGroup[] aag = new AudioAttributesGroup[nbAttributesGroups];
                for (int index = 0; index < nbAttributesGroups; ++index) {
                    aag[index] = AudioAttributesGroup.CREATOR.createFromParcel(in);
                }
                return new AudioProductStrategy(name, id2, aag);
            }

            @NonNull
            public AudioProductStrategy[] newArray(int size) {
                return new AudioProductStrategy[size];
            }
        };
        DEFAULT_ATTRIBUTES = new AudioAttributes.Builder().build();
    }

    private static class AudioAttributesGroup
    implements Parcelable {
        private int mVolumeGroupId;
        private int mLegacyStreamType;
        private final AudioAttributes[] mAudioAttributes;
        @NonNull
        public static final Parcelable.Creator<AudioAttributesGroup> CREATOR = new Parcelable.Creator<AudioAttributesGroup>(){

            @Override
            public AudioAttributesGroup createFromParcel(@NonNull Parcel in) {
                int volumeGroupId = in.readInt();
                int streamType = in.readInt();
                int nbAttributes = in.readInt();
                AudioAttributes[] aa = new AudioAttributes[nbAttributes];
                for (int index = 0; index < nbAttributes; ++index) {
                    aa[index] = AudioAttributes.CREATOR.createFromParcel(in);
                }
                return new AudioAttributesGroup(volumeGroupId, streamType, aa);
            }

            @NonNull
            public AudioAttributesGroup[] newArray(int size) {
                return new AudioAttributesGroup[size];
            }
        };

        AudioAttributesGroup(int volumeGroupId, int streamType, @NonNull AudioAttributes[] audioAttributes) {
            this.mVolumeGroupId = volumeGroupId;
            this.mLegacyStreamType = streamType;
            this.mAudioAttributes = audioAttributes;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AudioAttributesGroup thatAag = (AudioAttributesGroup)o;
            return this.mVolumeGroupId == thatAag.mVolumeGroupId && this.mLegacyStreamType == thatAag.mLegacyStreamType && Arrays.equals(this.mAudioAttributes, thatAag.mAudioAttributes);
        }

        public int hashCode() {
            return Objects.hash(this.mVolumeGroupId, this.mLegacyStreamType, Arrays.hashCode(this.mAudioAttributes));
        }

        public int getStreamType() {
            return this.mLegacyStreamType;
        }

        public int getVolumeGroupId() {
            return this.mVolumeGroupId;
        }

        @NonNull
        public AudioAttributes getAudioAttributes() {
            return this.mAudioAttributes.length == 0 ? DEFAULT_ATTRIBUTES : this.mAudioAttributes[0];
        }

        public boolean supportsAttributes(@NonNull AudioAttributes attributes) {
            for (AudioAttributes refAa : this.mAudioAttributes) {
                if (!refAa.equals(attributes) && !AudioProductStrategy.attributesMatches(refAa, attributes)) continue;
                return true;
            }
            return false;
        }

        public boolean supportsStreamType(int streamType) {
            return this.mLegacyStreamType == streamType;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.mVolumeGroupId);
            dest.writeInt(this.mLegacyStreamType);
            dest.writeInt(this.mAudioAttributes.length);
            for (AudioAttributes attributes : this.mAudioAttributes) {
                attributes.writeToParcel(dest, flags | 1);
            }
        }

        @NonNull
        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append("\n    Legacy Stream Type: ");
            s.append(Integer.toString(this.mLegacyStreamType));
            s.append(" Volume Group Id: ");
            s.append(Integer.toString(this.mVolumeGroupId));
            for (AudioAttributes attribute : this.mAudioAttributes) {
                s.append("\n    -");
                s.append(attribute.toString());
            }
            return s.toString();
        }
    }
}

