/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiopolicy;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.media.AudioAttributes;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@SystemApi
public class AudioMixingRule
implements Parcelable {
    public static final int RULE_MATCH_ATTRIBUTE_USAGE = 1;
    public static final int RULE_MATCH_ATTRIBUTE_CAPTURE_PRESET = 2;
    public static final int RULE_MATCH_UID = 4;
    public static final int RULE_MATCH_USERID = 8;
    public static final int RULE_MATCH_AUDIO_SESSION_ID = 16;
    private static final int RULE_EXCLUSION_MASK = 32768;
    public static final int RULE_EXCLUDE_ATTRIBUTE_USAGE = 32769;
    public static final int RULE_EXCLUDE_ATTRIBUTE_CAPTURE_PRESET = 32770;
    public static final int RULE_EXCLUDE_UID = 32772;
    public static final int RULE_EXCLUDE_USERID = 32776;
    public static final int RULE_EXCLUDE_AUDIO_SESSION_ID = 32784;
    private final int mTargetMixType;
    public static final int MIX_ROLE_PLAYERS = 0;
    public static final int MIX_ROLE_INJECTOR = 1;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private final ArrayList<AudioMixMatchCriterion> mCriteria;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private boolean mAllowPrivilegedPlaybackCapture = false;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private boolean mVoiceCommunicationCaptureAllowed = false;
    @NonNull
    public static final Parcelable.Creator<AudioMixingRule> CREATOR = new Parcelable.Creator<AudioMixingRule>(){

        @Override
        public AudioMixingRule createFromParcel(Parcel source) {
            Builder ruleBuilder = new Builder();
            ruleBuilder.allowPrivilegedPlaybackCapture(source.readBoolean());
            ruleBuilder.voiceCommunicationCaptureAllowed(source.readBoolean());
            ruleBuilder.setTargetMixRole(source.readInt());
            int nbRules = source.readInt();
            for (int j = 0; j < nbRules; ++j) {
                ruleBuilder.addRuleInternal(AudioMixMatchCriterion.CREATOR.createFromParcel(source));
            }
            return ruleBuilder.build();
        }

        public AudioMixingRule[] newArray(int size) {
            return new AudioMixingRule[size];
        }
    };

    private AudioMixingRule(int mixType, Collection<AudioMixMatchCriterion> criteria, boolean allowPrivilegedMediaPlaybackCapture, boolean voiceCommunicationCaptureAllowed) {
        this.mCriteria = new ArrayList<AudioMixMatchCriterion>(criteria);
        this.mTargetMixType = mixType;
        this.mAllowPrivilegedPlaybackCapture = allowPrivilegedMediaPlaybackCapture;
        this.mVoiceCommunicationCaptureAllowed = voiceCommunicationCaptureAllowed;
    }

    boolean isAffectingUsage(int usage) {
        for (AudioMixMatchCriterion criterion : this.mCriteria) {
            if ((criterion.mRule & 1) == 0 || criterion.mAttr == null || criterion.mAttr.getSystemUsage() != usage) continue;
            return true;
        }
        return false;
    }

    boolean containsMatchAttributeRuleForUsage(int usage) {
        for (AudioMixMatchCriterion criterion : this.mCriteria) {
            if (criterion.mRule != 1 || criterion.mAttr == null || criterion.mAttr.getSystemUsage() != usage) continue;
            return true;
        }
        return false;
    }

    int getTargetMixType() {
        return this.mTargetMixType;
    }

    public int getTargetMixRole() {
        return this.mTargetMixType == 1 ? 1 : 0;
    }

    public ArrayList<AudioMixMatchCriterion> getCriteria() {
        return this.mCriteria;
    }

    public boolean allowPrivilegedMediaPlaybackCapture() {
        return this.mAllowPrivilegedPlaybackCapture;
    }

    public boolean voiceCommunicationCaptureAllowed() {
        return this.mVoiceCommunicationCaptureAllowed;
    }

    public void setVoiceCommunicationCaptureAllowed(boolean allowed) {
        this.mVoiceCommunicationCaptureAllowed = allowed;
    }

    public boolean isForCallRedirection() {
        for (AudioMixMatchCriterion criterion : this.mCriteria) {
            if (criterion.mAttr == null || !criterion.mAttr.isForCallRedirection() || (criterion.mRule != 1 || criterion.mAttr.getUsage() != 2 && criterion.mAttr.getUsage() != 3) && (criterion.mRule != 2 || criterion.mAttr.getCapturePreset() != 7)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudioMixingRule that = (AudioMixingRule)o;
        return this.mTargetMixType == that.mTargetMixType && Objects.equals(this.mCriteria, that.mCriteria) && this.mAllowPrivilegedPlaybackCapture == that.mAllowPrivilegedPlaybackCapture && this.mVoiceCommunicationCaptureAllowed == that.mVoiceCommunicationCaptureAllowed;
    }

    public int hashCode() {
        return Objects.hash(this.mTargetMixType, this.mCriteria, this.mAllowPrivilegedPlaybackCapture, this.mVoiceCommunicationCaptureAllowed);
    }

    private static boolean isValidSystemApiRule(int rule) {
        switch (rule) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    private static boolean isValidAttributesSystemApiRule(int rule) {
        switch (rule) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    private static boolean isValidRule(int rule) {
        int match_rule = rule & 0xFFFF7FFF;
        switch (match_rule) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    private static boolean isPlayerRule(int rule) {
        int match_rule = rule & 0xFFFF7FFF;
        switch (match_rule) {
            case 1: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    private static boolean isRecorderRule(int rule) {
        int match_rule = rule & 0xFFFF7FFF;
        switch (match_rule) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    private static boolean isAudioAttributeRule(int match_rule) {
        switch (match_rule) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeBoolean(this.mAllowPrivilegedPlaybackCapture);
        dest.writeBoolean(this.mVoiceCommunicationCaptureAllowed);
        dest.writeInt(this.mTargetMixType);
        dest.writeInt(this.mCriteria.size());
        for (AudioMixMatchCriterion criterion : this.mCriteria) {
            criterion.writeToParcel(dest, flags);
        }
    }

    public static class AudioMixMatchCriterion
    implements Parcelable {
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        final AudioAttributes mAttr;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        final int mIntProp;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        final int mRule;
        @NonNull
        public static final Parcelable.Creator<AudioMixMatchCriterion> CREATOR = new Parcelable.Creator<AudioMixMatchCriterion>(){

            @Override
            public AudioMixMatchCriterion createFromParcel(Parcel p) {
                return new AudioMixMatchCriterion(p);
            }

            public AudioMixMatchCriterion[] newArray(int size) {
                return new AudioMixMatchCriterion[size];
            }
        };

        @VisibleForTesting
        public AudioMixMatchCriterion(AudioAttributes attributes, int rule) {
            this.mAttr = attributes;
            this.mIntProp = Integer.MIN_VALUE;
            this.mRule = rule;
        }

        @VisibleForTesting
        public AudioMixMatchCriterion(Integer intProp, int rule) {
            this.mAttr = null;
            this.mIntProp = intProp;
            this.mRule = rule;
        }

        private AudioMixMatchCriterion(@NonNull Parcel in) {
            Objects.requireNonNull(in);
            this.mRule = in.readInt();
            int match_rule = this.mRule & 0xFFFF7FFF;
            switch (match_rule) {
                case 1: 
                case 2: {
                    this.mAttr = AudioAttributes.CREATOR.createFromParcel(in);
                    this.mIntProp = Integer.MIN_VALUE;
                    break;
                }
                case 4: 
                case 8: 
                case 16: {
                    this.mIntProp = in.readInt();
                    this.mAttr = null;
                    break;
                }
                default: {
                    in.readInt();
                    throw new IllegalArgumentException("Illegal rule value " + this.mRule + " in parcel");
                }
            }
        }

        public int hashCode() {
            return Objects.hash(this.mAttr, this.mIntProp, this.mRule);
        }

        public boolean equals(Object object) {
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            if (object == this) {
                return true;
            }
            AudioMixMatchCriterion other = (AudioMixMatchCriterion)object;
            return this.mRule == other.mRule && this.mIntProp == other.mIntProp && Objects.equals(this.mAttr, other.mAttr);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.mRule);
            int match_rule = this.mRule & 0xFFFF7FFF;
            switch (match_rule) {
                case 1: 
                case 2: {
                    this.mAttr.writeToParcel(dest, 1);
                    break;
                }
                case 4: 
                case 8: 
                case 16: {
                    dest.writeInt(this.mIntProp);
                    break;
                }
                default: {
                    Log.e("AudioMixMatchCriterion", "Unknown match rule" + match_rule + " when writing to Parcel");
                    dest.writeInt(-1);
                }
            }
        }

        public AudioAttributes getAudioAttributes() {
            return this.mAttr;
        }

        public int getIntProp() {
            return this.mIntProp;
        }

        public int getRule() {
            return this.mRule;
        }
    }

    public static class Builder {
        private final Set<AudioMixMatchCriterion> mCriteria = new HashSet<AudioMixMatchCriterion>();
        private int mTargetMixType = -1;
        private boolean mAllowPrivilegedMediaPlaybackCapture = false;
        private boolean mVoiceCommunicationCaptureAllowed = false;

        public Builder addRule(AudioAttributes attrToMatch, int rule) throws IllegalArgumentException {
            if (!AudioMixingRule.isValidAttributesSystemApiRule(rule)) {
                throw new IllegalArgumentException("Illegal rule value " + rule);
            }
            return this.checkAddRuleObjInternal(rule, attrToMatch);
        }

        public Builder excludeRule(AudioAttributes attrToMatch, int rule) throws IllegalArgumentException {
            if (!AudioMixingRule.isValidAttributesSystemApiRule(rule)) {
                throw new IllegalArgumentException("Illegal rule value " + rule);
            }
            return this.checkAddRuleObjInternal(rule | 0x8000, attrToMatch);
        }

        public Builder addMixRule(int rule, Object property) throws IllegalArgumentException {
            if (!AudioMixingRule.isValidSystemApiRule(rule)) {
                throw new IllegalArgumentException("Illegal rule value " + rule);
            }
            return this.checkAddRuleObjInternal(rule, property);
        }

        public Builder excludeMixRule(int rule, Object property) throws IllegalArgumentException {
            if (!AudioMixingRule.isValidSystemApiRule(rule)) {
                throw new IllegalArgumentException("Illegal rule value " + rule);
            }
            return this.checkAddRuleObjInternal(rule | 0x8000, property);
        }

        @NonNull
        public Builder allowPrivilegedPlaybackCapture(boolean allow) {
            this.mAllowPrivilegedMediaPlaybackCapture = allow;
            return this;
        }

        @NonNull
        public Builder voiceCommunicationCaptureAllowed(boolean allowed) {
            this.mVoiceCommunicationCaptureAllowed = allowed;
            return this;
        }

        @NonNull
        public Builder setTargetMixRole(int mixRole) {
            if (mixRole != 0 && mixRole != 1) {
                throw new IllegalArgumentException("Illegal argument for mix role");
            }
            if (this.mCriteria.stream().map(AudioMixMatchCriterion::getRule).anyMatch(mixRole == 0 ? AudioMixingRule::isRecorderRule : AudioMixingRule::isPlayerRule)) {
                throw new IllegalArgumentException("Target mix role is not compatible with mix rules.");
            }
            this.mTargetMixType = mixRole == 1 ? 1 : 0;
            return this;
        }

        private Builder checkAddRuleObjInternal(int rule, Object property) throws IllegalArgumentException {
            if (property == null) {
                throw new IllegalArgumentException("Illegal null argument for mixing rule");
            }
            if (!AudioMixingRule.isValidRule(rule)) {
                throw new IllegalArgumentException("Illegal rule value " + rule);
            }
            int match_rule = rule & 0xFFFF7FFF;
            if (AudioMixingRule.isAudioAttributeRule(match_rule)) {
                if (!(property instanceof AudioAttributes)) {
                    throw new IllegalArgumentException("Invalid AudioAttributes argument");
                }
                return this.addRuleInternal(new AudioMixMatchCriterion((AudioAttributes)property, rule));
            }
            if (!(property instanceof Integer)) {
                throw new IllegalArgumentException("Invalid Integer argument");
            }
            return this.addRuleInternal(new AudioMixMatchCriterion((Integer)property, rule));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Builder addRuleInternal(AudioMixMatchCriterion criterion) throws IllegalArgumentException {
            int rule = criterion.mRule;
            if (this.mTargetMixType == -1) {
                if (AudioMixingRule.isPlayerRule(rule)) {
                    this.mTargetMixType = 0;
                } else if (AudioMixingRule.isRecorderRule(rule)) {
                    this.mTargetMixType = 1;
                }
            } else if (AudioMixingRule.isPlayerRule(rule) && this.mTargetMixType != 0 || AudioMixingRule.isRecorderRule(rule) && this.mTargetMixType != 1) {
                throw new IllegalArgumentException("Incompatible rule for mix");
            }
            Set<AudioMixMatchCriterion> set = this.mCriteria;
            synchronized (set) {
                int oppositeRule = rule ^ 0x8000;
                if (this.mCriteria.stream().anyMatch(otherCriterion -> otherCriterion.mRule == oppositeRule)) {
                    throw new IllegalArgumentException("AudioMixingRule cannot contain RULE_MATCH_* and RULE_EXCLUDE_* for the same dimension.");
                }
                this.mCriteria.add(criterion);
            }
            return this;
        }

        public AudioMixingRule build() {
            if (this.mCriteria.isEmpty()) {
                throw new IllegalArgumentException("Cannot build AudioMixingRule with no rules.");
            }
            return new AudioMixingRule(this.mTargetMixType == -1 ? 0 : this.mTargetMixType, this.mCriteria, this.mAllowPrivilegedMediaPlaybackCapture, this.mVoiceCommunicationCaptureAllowed);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MixRole {
    }
}

