/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiopolicy;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.media.AudioDeviceInfo;
import android.media.AudioFormat;
import android.media.AudioSystem;
import android.media.audiopolicy.AudioMixingRule;
import android.media.audiopolicy.Flags;
import android.os.Binder;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
public class AudioMix
implements Parcelable {
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @NonNull
    private AudioMixingRule mRule;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @NonNull
    private AudioFormat mFormat;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private int mRouteFlags;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private int mMixType = -1;
    private final IBinder mToken;
    int mMixState = -1;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    int mCallbackFlags;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @NonNull
    String mDeviceAddress;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    final int mDeviceSystemType;
    private int mVirtualDeviceId;
    public static final int CALLBACK_FLAG_NOTIFY_ACTIVITY = 1;
    private static final int CALLBACK_FLAGS_ALL = 1;
    public static final int ROUTE_FLAG_RENDER = 1;
    public static final int ROUTE_FLAG_LOOP_BACK = 2;
    public static final int ROUTE_FLAG_LOOP_BACK_RENDER = 3;
    private static final int ROUTE_FLAG_SUPPORTED = 3;
    public static final int MIX_TYPE_INVALID = -1;
    public static final int MIX_TYPE_PLAYERS = 0;
    public static final int MIX_TYPE_RECORDERS = 1;
    public static final int MIX_STATE_DISABLED = -1;
    public static final int MIX_STATE_IDLE = 0;
    public static final int MIX_STATE_MIXING = 1;
    private static final int PRIVILEDGED_CAPTURE_MAX_SAMPLE_RATE = 16000;
    private static final int PRIVILEDGED_CAPTURE_MAX_CHANNEL_NUMBER = 1;
    private static final int PRIVILEDGED_CAPTURE_MAX_BYTES_PER_SAMPLE = 2;
    @NonNull
    public static final Parcelable.Creator<AudioMix> CREATOR = new Parcelable.Creator<AudioMix>(){

        @Override
        public AudioMix createFromParcel(Parcel p) {
            Builder mixBuilder = new Builder();
            mixBuilder.setRouteFlags(p.readInt());
            mixBuilder.setCallbackFlags(p.readInt());
            mixBuilder.setDevice(p.readInt(), p.readString8());
            mixBuilder.setFormat(AudioFormat.CREATOR.createFromParcel(p));
            mixBuilder.setMixingRule(AudioMixingRule.CREATOR.createFromParcel(p));
            mixBuilder.setToken(p.readStrongBinder());
            mixBuilder.setVirtualDeviceId(p.readInt());
            return mixBuilder.build();
        }

        public AudioMix[] newArray(int size) {
            return new AudioMix[size];
        }
    };

    private AudioMix(@NonNull AudioMixingRule rule, @NonNull AudioFormat format, int routeFlags, int callbackFlags, int deviceType, @Nullable String deviceAddress, IBinder token, int virtualDeviceId) {
        this.mRule = Objects.requireNonNull(rule);
        this.mFormat = Objects.requireNonNull(format);
        this.mRouteFlags = routeFlags;
        this.mMixType = rule.getTargetMixType();
        this.mCallbackFlags = callbackFlags;
        this.mDeviceSystemType = deviceType;
        this.mDeviceAddress = deviceAddress == null ? new String("") : deviceAddress;
        this.mToken = token;
        this.mVirtualDeviceId = virtualDeviceId;
    }

    public int getMixState() {
        return this.mMixState;
    }

    public int getRouteFlags() {
        return this.mRouteFlags;
    }

    public AudioFormat getFormat() {
        return this.mFormat;
    }

    public AudioMixingRule getRule() {
        return this.mRule;
    }

    public int getMixType() {
        return this.mMixType;
    }

    void setRegistration(String regId) {
        this.mDeviceAddress = regId;
    }

    public void setAudioMixingRule(@NonNull AudioMixingRule rule) {
        if (this.mRule.getTargetMixType() != rule.getTargetMixType()) {
            throw new UnsupportedOperationException("Target mix role of updated rule doesn't match the mix role of the AudioMix");
        }
        this.mRule = Objects.requireNonNull(rule);
    }

    public String getRegistration() {
        return this.mDeviceAddress;
    }

    public boolean isAffectingUsage(int usage) {
        return this.mRule.isAffectingUsage(usage);
    }

    public boolean containsMatchAttributeRuleForUsage(int usage) {
        return this.mRule.containsMatchAttributeRuleForUsage(usage);
    }

    public boolean isRoutedToDevice(int deviceType, @NonNull String deviceAddress) {
        if ((this.mRouteFlags & 1) != 1) {
            return false;
        }
        if (deviceType != this.mDeviceSystemType) {
            return false;
        }
        return deviceAddress.equals(this.mDeviceAddress);
    }

    public static String canBeUsedForPrivilegedMediaCapture(AudioFormat format) {
        int encoding;
        block7: {
            block6: {
                int sampleRate = format.getSampleRate();
                if (sampleRate > 16000 || sampleRate <= 0) {
                    return "Privileged audio capture sample rate " + sampleRate + " can not be over " + 16000 + "kHz";
                }
                int channelCount = format.getChannelCount();
                if (channelCount > 1 || channelCount <= 0) {
                    return "Privileged audio capture channel count " + channelCount + " can not be over " + 1;
                }
                encoding = format.getEncoding();
                if (!AudioFormat.isPublicEncoding(encoding)) break block6;
                if (AudioFormat.isEncodingLinearPcm(encoding)) break block7;
            }
            return "Privileged audio capture encoding " + encoding + "is not linear";
        }
        if (AudioFormat.getBytesPerSample(encoding) > 2) {
            return "Privileged audio capture encoding " + encoding + " can not be over " + 2 + " bytes per sample";
        }
        return null;
    }

    public boolean isForCallRedirection() {
        return this.mRule.isForCallRedirection();
    }

    public boolean matchesVirtualDeviceId(int deviceId) {
        return this.mVirtualDeviceId == deviceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudioMix that = (AudioMix)o;
        boolean tokenMatch = Flags.audioMixOwnership() ? Objects.equals(this.mToken, that.mToken) : true;
        return Objects.equals(this.mRouteFlags, that.mRouteFlags) && Objects.equals(this.mRule, that.mRule) && Objects.equals(this.mMixType, that.mMixType) && Objects.equals(this.mFormat, that.mFormat) && tokenMatch;
    }

    public int hashCode() {
        if (Flags.audioMixOwnership()) {
            return Objects.hash(this.mRouteFlags, this.mRule, this.mMixType, this.mFormat, this.mToken);
        }
        return Objects.hash(this.mRouteFlags, this.mRule, this.mMixType, this.mFormat);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mRouteFlags);
        dest.writeInt(this.mCallbackFlags);
        dest.writeInt(this.mDeviceSystemType);
        dest.writeString8(this.mDeviceAddress);
        this.mFormat.writeToParcel(dest, flags);
        this.mRule.writeToParcel(dest, flags);
        dest.writeStrongBinder(this.mToken);
        dest.writeInt(this.mVirtualDeviceId);
    }

    public void setVirtualDeviceId(int virtualDeviceId) {
        this.mVirtualDeviceId = virtualDeviceId;
    }

    public static class Builder {
        private AudioMixingRule mRule = null;
        private AudioFormat mFormat = null;
        private int mRouteFlags = 0;
        private int mCallbackFlags = 0;
        private IBinder mToken = null;
        private int mVirtualDeviceId = 0;
        private int mDeviceSystemType = 0;
        private String mDeviceAddress = null;

        Builder() {
        }

        public Builder(@NonNull AudioMixingRule rule) throws IllegalArgumentException {
            if (rule == null) {
                throw new IllegalArgumentException("Illegal null AudioMixingRule argument");
            }
            this.mRule = rule;
        }

        Builder setMixingRule(@NonNull AudioMixingRule rule) throws IllegalArgumentException {
            if (rule == null) {
                throw new IllegalArgumentException("Illegal null AudioMixingRule argument");
            }
            this.mRule = rule;
            return this;
        }

        Builder setToken(IBinder token) {
            this.mToken = token;
            return this;
        }

        Builder setVirtualDeviceId(int virtualDeviceId) {
            this.mVirtualDeviceId = virtualDeviceId;
            return this;
        }

        Builder setCallbackFlags(int flags) throws IllegalArgumentException {
            if (flags != 0 && (flags & 1) == 0) {
                throw new IllegalArgumentException("Illegal callback flags 0x" + Integer.toHexString(flags).toUpperCase());
            }
            this.mCallbackFlags = flags;
            return this;
        }

        @VisibleForTesting
        public Builder setDevice(int deviceType, String address) {
            this.mDeviceSystemType = deviceType;
            this.mDeviceAddress = address;
            return this;
        }

        public Builder setFormat(@NonNull AudioFormat format) throws IllegalArgumentException {
            if (format == null) {
                throw new IllegalArgumentException("Illegal null AudioFormat argument");
            }
            this.mFormat = format;
            return this;
        }

        public Builder setRouteFlags(int routeFlags) throws IllegalArgumentException {
            if (routeFlags == 0) {
                throw new IllegalArgumentException("Illegal empty route flags");
            }
            if ((routeFlags & 3) == 0) {
                throw new IllegalArgumentException("Invalid route flags 0x" + Integer.toHexString(routeFlags) + "when configuring an AudioMix");
            }
            if ((routeFlags & 0xFFFFFFFC) != 0) {
                throw new IllegalArgumentException("Unknown route flags 0x" + Integer.toHexString(routeFlags) + "when configuring an AudioMix");
            }
            this.mRouteFlags = routeFlags;
            return this;
        }

        public Builder setDevice(@NonNull AudioDeviceInfo device) throws IllegalArgumentException {
            if (device == null) {
                throw new IllegalArgumentException("Illegal null AudioDeviceInfo argument");
            }
            if (!device.isSink()) {
                throw new IllegalArgumentException("Unsupported device type on mix, not a sink");
            }
            this.mDeviceSystemType = AudioDeviceInfo.convertDeviceTypeToInternalDevice(device.getType());
            this.mDeviceAddress = device.getAddress();
            return this;
        }

        public AudioMix build() throws IllegalArgumentException {
            String error;
            if (this.mRule == null) {
                throw new IllegalArgumentException("Illegal null AudioMixingRule");
            }
            if (this.mRouteFlags == 0) {
                this.mRouteFlags = 2;
            }
            if (this.mFormat == null) {
                int rate = AudioSystem.getPrimaryOutputSamplingRate();
                if (rate <= 0) {
                    rate = 44100;
                }
                this.mFormat = new AudioFormat.Builder().setSampleRate(rate).build();
            } else if ((this.mFormat.getPropertySetMask() & 4) != 0 && this.mFormat.getChannelCount() == 1 && this.mFormat.getChannelMask() == 16) {
                this.mFormat = new AudioFormat.Builder(this.mFormat).setChannelMask(4).build();
            }
            if ((this.mRouteFlags & 2) == 2) {
                if (this.mDeviceSystemType == 0) {
                    this.mDeviceSystemType = this.getLoopbackDeviceSystemTypeForAudioMixingRule(this.mRule);
                } else if (!AudioSystem.isRemoteSubmixDevice(this.mDeviceSystemType)) {
                    throw new IllegalArgumentException("Device " + AudioSystem.getDeviceName(this.mDeviceSystemType) + "is not supported for loopback mix.");
                }
            }
            if ((this.mRouteFlags & 1) == 1) {
                if (this.mDeviceSystemType == 0) {
                    throw new IllegalArgumentException("Can't have flag ROUTE_FLAG_RENDER without an audio device");
                }
                if (AudioSystem.DEVICE_IN_ALL_SET.contains(this.mDeviceSystemType)) {
                    throw new IllegalArgumentException("Input device is not supported with ROUTE_FLAG_RENDER");
                }
                if (this.mRule.getTargetMixType() == 1) {
                    throw new IllegalArgumentException("ROUTE_FLAG_RENDER/ROUTE_FLAG_LOOP_BACK_RENDER is not supported for non-playback mix rule");
                }
            }
            if (this.mRule.allowPrivilegedMediaPlaybackCapture() && (error = AudioMix.canBeUsedForPrivilegedMediaCapture(this.mFormat)) != null) {
                throw new IllegalArgumentException(error);
            }
            if (this.mToken == null) {
                this.mToken = new Binder();
            }
            return new AudioMix(this.mRule, this.mFormat, this.mRouteFlags, this.mCallbackFlags, this.mDeviceSystemType, this.mDeviceAddress, this.mToken, this.mVirtualDeviceId);
        }

        private int getLoopbackDeviceSystemTypeForAudioMixingRule(AudioMixingRule rule) {
            switch (this.mRule.getTargetMixType()) {
                case 0: {
                    return 32768;
                }
                case 1: {
                    return -2147483392;
                }
            }
            throw new IllegalArgumentException("Unknown mixing rule type - 0x" + Integer.toHexString(rule.getTargetMixType()));
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RouteFlags {
    }
}

