/*
 * Decompiled with CFR 0.152.
 */
package android.media.audio.common;

import android.media.audio.common.AudioChannelLayout;
import android.media.audio.common.AudioFormatDescription;
import android.os.BadParcelableException;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;

public class AudioProfile
implements Parcelable {
    public String name;
    public AudioFormatDescription format;
    public AudioChannelLayout[] channelMasks;
    public int[] sampleRates;
    public int encapsulationType = 0;
    public static final Parcelable.Creator<AudioProfile> CREATOR = new Parcelable.Creator<AudioProfile>(){

        @Override
        public AudioProfile createFromParcel(Parcel _aidl_source) {
            AudioProfile _aidl_out = new AudioProfile();
            _aidl_out.readFromParcel(_aidl_source);
            return _aidl_out;
        }

        public AudioProfile[] newArray(int _aidl_size) {
            return new AudioProfile[_aidl_size];
        }
    };

    @Override
    public int getStability() {
        return 1;
    }

    @Override
    public void writeToParcel(Parcel _aidl_parcel, int _aidl_flag) {
        int _aidl_start_pos = _aidl_parcel.dataPosition();
        _aidl_parcel.writeInt(0);
        _aidl_parcel.writeString(this.name);
        _aidl_parcel.writeTypedObject(this.format, _aidl_flag);
        _aidl_parcel.writeTypedArray(this.channelMasks, _aidl_flag);
        _aidl_parcel.writeIntArray(this.sampleRates);
        _aidl_parcel.writeInt(this.encapsulationType);
        int _aidl_end_pos = _aidl_parcel.dataPosition();
        _aidl_parcel.setDataPosition(_aidl_start_pos);
        _aidl_parcel.writeInt(_aidl_end_pos - _aidl_start_pos);
        _aidl_parcel.setDataPosition(_aidl_end_pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFromParcel(Parcel _aidl_parcel) {
        int _aidl_start_pos = _aidl_parcel.dataPosition();
        int _aidl_parcelable_size = _aidl_parcel.readInt();
        try {
            if (_aidl_parcelable_size < 4) {
                throw new BadParcelableException("Parcelable too small");
            }
            if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                return;
            }
            this.name = _aidl_parcel.readString();
            if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                return;
            }
            this.format = _aidl_parcel.readTypedObject(AudioFormatDescription.CREATOR);
            if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                return;
            }
            this.channelMasks = _aidl_parcel.createTypedArray(AudioChannelLayout.CREATOR);
            if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                return;
            }
            this.sampleRates = _aidl_parcel.createIntArray();
            if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                return;
            }
            this.encapsulationType = _aidl_parcel.readInt();
        }
        finally {
            if (_aidl_start_pos > Integer.MAX_VALUE - _aidl_parcelable_size) {
                throw new BadParcelableException("Overflow in the size of parcelable");
            }
            _aidl_parcel.setDataPosition(_aidl_start_pos + _aidl_parcelable_size);
        }
    }

    public String toString() {
        StringJoiner _aidl_sj = new StringJoiner(", ", "{", "}");
        _aidl_sj.add("name: " + Objects.toString(this.name));
        _aidl_sj.add("format: " + Objects.toString(this.format));
        _aidl_sj.add("channelMasks: " + Arrays.toString(this.channelMasks));
        _aidl_sj.add("sampleRates: " + Arrays.toString(this.sampleRates));
        _aidl_sj.add("encapsulationType: " + this.encapsulationType);
        return "AudioProfile" + ((Object)_aidl_sj).toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof AudioProfile)) {
            return false;
        }
        AudioProfile that = (AudioProfile)other;
        if (!Objects.deepEquals(this.name, that.name)) {
            return false;
        }
        if (!Objects.deepEquals(this.format, that.format)) {
            return false;
        }
        if (!Objects.deepEquals(this.channelMasks, that.channelMasks)) {
            return false;
        }
        if (!Objects.deepEquals(this.sampleRates, that.sampleRates)) {
            return false;
        }
        return Objects.deepEquals(this.encapsulationType, that.encapsulationType);
    }

    public int hashCode() {
        return Arrays.deepHashCode(Arrays.asList(this.name, this.format, this.channelMasks, this.sampleRates, this.encapsulationType).toArray());
    }

    @Override
    public int describeContents() {
        int _mask = 0;
        _mask |= this.describeContents(this.format);
        return _mask |= this.describeContents(this.channelMasks);
    }

    private int describeContents(Object _v) {
        if (_v == null) {
            return 0;
        }
        if (_v instanceof Object[]) {
            int _mask = 0;
            for (Object o : (Object[])_v) {
                _mask |= this.describeContents(o);
            }
            return _mask;
        }
        if (_v instanceof Parcelable) {
            return ((Parcelable)_v).describeContents();
        }
        return 0;
    }
}

