/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.Activity;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.database.StaleDataException;
import android.media.AudioAttributes;
import android.media.AudioManager;
import android.media.ExternalRingtonesCursorWrapper;
import android.media.Ringtone;
import android.media.Utils;
import android.media.VolumeShaper;
import android.net.Uri;
import android.os.Environment;
import android.os.FileUtils;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.MediaStore;
import android.provider.Settings;
import android.util.Log;
import com.android.internal.database.SortCursor;
import com.android.internal.hidden_from_bootclasspath.android.media.audio.Flags;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class RingtoneManager {
    private static final String TAG = "RingtoneManager";
    public static final int TYPE_RINGTONE = 1;
    public static final int TYPE_NOTIFICATION = 2;
    public static final int TYPE_ALARM = 4;
    public static final int TYPE_ALL = 7;
    public static final String ACTION_RINGTONE_PICKER = "android.intent.action.RINGTONE_PICKER";
    public static final String EXTRA_RINGTONE_SHOW_DEFAULT = "android.intent.extra.ringtone.SHOW_DEFAULT";
    public static final String EXTRA_RINGTONE_SHOW_SILENT = "android.intent.extra.ringtone.SHOW_SILENT";
    @Deprecated
    public static final String EXTRA_RINGTONE_INCLUDE_DRM = "android.intent.extra.ringtone.INCLUDE_DRM";
    public static final String EXTRA_RINGTONE_EXISTING_URI = "android.intent.extra.ringtone.EXISTING_URI";
    public static final String EXTRA_RINGTONE_DEFAULT_URI = "android.intent.extra.ringtone.DEFAULT_URI";
    public static final String EXTRA_RINGTONE_TYPE = "android.intent.extra.ringtone.TYPE";
    public static final String EXTRA_RINGTONE_TITLE = "android.intent.extra.ringtone.TITLE";
    public static final String EXTRA_RINGTONE_AUDIO_ATTRIBUTES_FLAGS = "android.intent.extra.ringtone.AUDIO_ATTRIBUTES_FLAGS";
    public static final String EXTRA_RINGTONE_PICKED_URI = "android.intent.extra.ringtone.PICKED_URI";
    private static final String[] INTERNAL_COLUMNS = new String[]{"_id", "title", "title", "title_key"};
    private static final String[] MEDIA_COLUMNS = new String[]{"_id", "title", "title", "title_key"};
    public static final int ID_COLUMN_INDEX = 0;
    public static final int TITLE_COLUMN_INDEX = 1;
    public static final int URI_COLUMN_INDEX = 2;
    private final Activity mActivity;
    private final Context mContext;
    @UnsupportedAppUsage
    private Cursor mCursor;
    private int mType = 1;
    private final List<String> mFilterColumns = new ArrayList<String>();
    private boolean mStopPreviousRingtone = true;
    private Ringtone mPreviousRingtone;
    private boolean mIncludeParentRingtones;

    public RingtoneManager(Activity activity) {
        this(activity, false);
    }

    public RingtoneManager(Activity activity, boolean includeParentRingtones) {
        this.mActivity = activity;
        this.mContext = activity;
        this.setType(this.mType);
        this.mIncludeParentRingtones = includeParentRingtones;
    }

    public RingtoneManager(Context context) {
        this(context, false);
    }

    public RingtoneManager(Context context, boolean includeParentRingtones) {
        this.mActivity = null;
        this.mContext = context;
        this.setType(this.mType);
        this.mIncludeParentRingtones = includeParentRingtones;
    }

    public void setType(int type) {
        if (this.mCursor != null) {
            throw new IllegalStateException("Setting filter columns should be done before querying for ringtones.");
        }
        this.mType = type;
        this.setFilterColumnsList(type);
    }

    public int inferStreamType() {
        switch (this.mType) {
            case 4: {
                return 4;
            }
            case 2: {
                return 5;
            }
        }
        return 2;
    }

    public void setStopPreviousRingtone(boolean stopPreviousRingtone) {
        this.mStopPreviousRingtone = stopPreviousRingtone;
    }

    public boolean getStopPreviousRingtone() {
        return this.mStopPreviousRingtone;
    }

    public void stopPreviousRingtone() {
        if (this.mPreviousRingtone != null) {
            this.mPreviousRingtone.stop();
        }
    }

    @Deprecated
    public boolean getIncludeDrm() {
        return false;
    }

    @Deprecated
    public void setIncludeDrm(boolean includeDrm) {
        if (includeDrm) {
            Log.w(TAG, "setIncludeDrm no longer supported");
        }
    }

    public Cursor getCursor() {
        Cursor parentRingtonesCursor;
        if (this.mCursor != null && this.mCursor.requery()) {
            return this.mCursor;
        }
        ArrayList<Cursor> ringtoneCursors = new ArrayList<Cursor>();
        ringtoneCursors.add(this.getInternalRingtones());
        ringtoneCursors.add(this.getMediaRingtones());
        if (this.mIncludeParentRingtones && (parentRingtonesCursor = this.getParentProfileRingtones()) != null) {
            ringtoneCursors.add(parentRingtonesCursor);
        }
        this.mCursor = new SortCursor(ringtoneCursors.toArray(new Cursor[ringtoneCursors.size()]), "title_key");
        return this.mCursor;
    }

    private Cursor getParentProfileRingtones() {
        Context parentContext;
        UserManager um = UserManager.get(this.mContext);
        UserInfo parentInfo = um.getProfileParent(this.mContext.getUserId());
        if (parentInfo != null && parentInfo.id != this.mContext.getUserId() && (parentContext = RingtoneManager.createPackageContextAsUser(this.mContext, parentInfo.id)) != null) {
            Cursor res = this.getMediaRingtones(parentContext);
            return new ExternalRingtonesCursorWrapper(res, ContentProvider.maybeAddUserId(MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, parentInfo.id));
        }
        return null;
    }

    public Ringtone getRingtone(int position) {
        if (this.mStopPreviousRingtone && this.mPreviousRingtone != null) {
            this.mPreviousRingtone.stop();
        }
        this.mPreviousRingtone = RingtoneManager.getRingtone(this.mContext, this.getRingtoneUri(position), this.inferStreamType(), true);
        return this.mPreviousRingtone;
    }

    public Uri getRingtoneUri(int position) {
        try {
            if (this.mCursor == null || !this.mCursor.moveToPosition(position)) {
                return null;
            }
        }
        catch (StaleDataException | IllegalStateException e) {
            Log.e(TAG, "Unexpected Exception has been catched.", e);
            return null;
        }
        return RingtoneManager.getUriFromCursor(this.mContext, this.mCursor);
    }

    @Nullable
    public static Uri getRingtoneUriForRestore(@NonNull ContentResolver contentResolver, @Nullable String value, int ringtoneType) throws FileNotFoundException, IllegalArgumentException {
        if (value == null) {
            return null;
        }
        Uri canonicalUri = Uri.parse(value);
        Uri ringtoneUri = contentResolver.uncanonicalize(canonicalUri);
        if (ringtoneUri != null) {
            ringtoneUri = contentResolver.canonicalize(ringtoneUri);
            return ringtoneUri;
        }
        String title = canonicalUri.getQueryParameter("title");
        Uri baseUri = ContentUris.removeId(canonicalUri).buildUpon().clearQuery().build();
        String ringtoneTypeSelection = "";
        switch (ringtoneType) {
            case 1: {
                ringtoneTypeSelection = "is_ringtone";
                break;
            }
            case 2: {
                ringtoneTypeSelection = "is_notification";
                break;
            }
            case 4: {
                ringtoneTypeSelection = "is_alarm";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ringtone type: " + ringtoneType);
            }
        }
        String selection = ringtoneTypeSelection + "=1 AND " + "title" + "=?";
        Cursor cursor = null;
        try {
            cursor = contentResolver.query(baseUri, new String[]{"_id"}, selection, new String[]{title}, null, null);
        }
        catch (IllegalArgumentException e) {
            throw new FileNotFoundException("Volume not found for " + baseUri);
        }
        if (cursor == null) {
            throw new FileNotFoundException("Missing cursor for " + baseUri);
        }
        if (cursor.getCount() == 0) {
            FileUtils.closeQuietly(cursor);
            throw new FileNotFoundException("No item found for " + baseUri);
        }
        if (cursor.getCount() > 1) {
            int resultCount = cursor.getCount();
            FileUtils.closeQuietly(cursor);
            throw new FileNotFoundException("Find multiple ringtone candidates by title+ringtone_type query: count: " + resultCount);
        }
        if (!cursor.moveToFirst()) {
            FileUtils.closeQuietly(cursor);
            throw new FileNotFoundException("Failed to read row from the result.");
        }
        ringtoneUri = ContentUris.withAppendedId(baseUri, cursor.getLong(0));
        FileUtils.closeQuietly(cursor);
        ringtoneUri = contentResolver.canonicalize(ringtoneUri);
        Log.v(TAG, "Find a valid result: " + ringtoneUri);
        return ringtoneUri;
    }

    private static Uri getUriFromCursor(Context context, Cursor cursor) {
        Uri uri = ContentUris.withAppendedId(Uri.parse(cursor.getString(2)), cursor.getLong(0));
        return context.getContentResolver().canonicalizeOrElse(uri);
    }

    public int getRingtonePosition(Uri ringtoneUri) {
        try {
            if (ringtoneUri == null) {
                return -1;
            }
            Cursor cursor = this.getCursor();
            cursor.moveToPosition(-1);
            while (cursor.moveToNext()) {
                Uri uriFromCursor = RingtoneManager.getUriFromCursor(this.mContext, cursor);
                if (!ringtoneUri.equals(uriFromCursor)) continue;
                return cursor.getPosition();
            }
        }
        catch (NumberFormatException e) {
            Log.e(TAG, "NumberFormatException while getting ringtone position, returning -1", e);
        }
        return -1;
    }

    public static Uri getValidRingtoneUri(Context context) {
        RingtoneManager rm = new RingtoneManager(context);
        Uri uri = RingtoneManager.getValidRingtoneUriFromCursorAndClose(context, rm.getInternalRingtones());
        if (uri == null) {
            uri = RingtoneManager.getValidRingtoneUriFromCursorAndClose(context, rm.getMediaRingtones());
        }
        return uri;
    }

    private static Uri getValidRingtoneUriFromCursorAndClose(Context context, Cursor cursor) {
        if (cursor != null) {
            Uri uri = null;
            if (cursor.moveToFirst()) {
                uri = RingtoneManager.getUriFromCursor(context, cursor);
            }
            cursor.close();
            return uri;
        }
        return null;
    }

    @UnsupportedAppUsage
    private Cursor getInternalRingtones() {
        Cursor res = this.query(MediaStore.Audio.Media.INTERNAL_CONTENT_URI, INTERNAL_COLUMNS, RingtoneManager.constructBooleanTrueWhereClause(this.mFilterColumns), null, "title_key");
        return new ExternalRingtonesCursorWrapper(res, MediaStore.Audio.Media.INTERNAL_CONTENT_URI);
    }

    private Cursor getMediaRingtones() {
        Cursor res = this.getMediaRingtones(this.mContext);
        return new ExternalRingtonesCursorWrapper(res, MediaStore.Audio.Media.EXTERNAL_CONTENT_URI);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private Cursor getMediaRingtones(Context context) {
        return this.query(MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, MEDIA_COLUMNS, RingtoneManager.constructBooleanTrueWhereClause(this.mFilterColumns), null, "title_key", context);
    }

    private void setFilterColumnsList(int type) {
        List<String> columns = this.mFilterColumns;
        columns.clear();
        if ((type & 1) != 0) {
            columns.add("is_ringtone");
        }
        if ((type & 2) != 0) {
            columns.add("is_notification");
        }
        if ((type & 4) != 0) {
            columns.add("is_alarm");
        }
    }

    private static String constructBooleanTrueWhereClause(List<String> columns) {
        if (columns == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = columns.size() - 1; i >= 0; --i) {
            sb.append(columns.get(i)).append("=1 or ");
        }
        if (columns.size() > 0) {
            sb.setLength(sb.length() - 4);
        }
        sb.append(")");
        return sb.toString();
    }

    private Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return this.query(uri, projection, selection, selectionArgs, sortOrder, this.mContext);
    }

    private Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder, Context context) {
        if (this.mActivity != null) {
            return this.mActivity.managedQuery(uri, projection, selection, selectionArgs, sortOrder);
        }
        return context.getContentResolver().query(uri, projection, selection, selectionArgs, sortOrder);
    }

    public static Ringtone getRingtone(Context context, Uri ringtoneUri) {
        return RingtoneManager.getRingtone(context, ringtoneUri, -1, true);
    }

    public static Ringtone getRingtone(Context context, Uri ringtoneUri, @Nullable VolumeShaper.Configuration volumeShaperConfig) {
        return RingtoneManager.getRingtone(context, ringtoneUri, -1, volumeShaperConfig, true);
    }

    public static Ringtone getRingtone(Context context, Uri ringtoneUri, @Nullable VolumeShaper.Configuration volumeShaperConfig, boolean createLocalMediaPlayer) {
        return RingtoneManager.getRingtone(context, ringtoneUri, -1, volumeShaperConfig, createLocalMediaPlayer);
    }

    public static Ringtone getRingtone(Context context, Uri ringtoneUri, @Nullable VolumeShaper.Configuration volumeShaperConfig, AudioAttributes audioAttributes) {
        Ringtone ringtone = RingtoneManager.getRingtone(context, ringtoneUri, -1, volumeShaperConfig, false);
        if (RingtoneManager.muteHapticChannelForVibration(context, ringtoneUri)) {
            audioAttributes = new AudioAttributes.Builder(audioAttributes).setHapticChannelsMuted(true).build();
        }
        if (ringtone != null) {
            ringtone.setAudioAttributesField(audioAttributes);
            if (!ringtone.createLocalMediaPlayer()) {
                Log.e(TAG, "Failed to open ringtone " + ringtoneUri);
                return null;
            }
        }
        return ringtone;
    }

    @UnsupportedAppUsage
    private static Ringtone getRingtone(Context context, Uri ringtoneUri, int streamType, boolean createLocalMediaPlayer) {
        return RingtoneManager.getRingtone(context, ringtoneUri, streamType, null, createLocalMediaPlayer);
    }

    private static Ringtone getRingtone(Context context, Uri ringtoneUri, int streamType, @Nullable VolumeShaper.Configuration volumeShaperConfig, boolean createLocalMediaPlayer) {
        try {
            Ringtone r = new Ringtone(context, true);
            if (streamType >= 0) {
                r.setStreamType(streamType);
            }
            r.setVolumeShaperConfig(volumeShaperConfig);
            r.setUri(ringtoneUri, volumeShaperConfig);
            if (createLocalMediaPlayer && !r.createLocalMediaPlayer()) {
                Log.e(TAG, "Failed to open ringtone " + ringtoneUri);
                return null;
            }
            return r;
        }
        catch (Exception ex) {
            Log.e(TAG, "Failed to open ringtone " + ringtoneUri + ": " + ex);
            return null;
        }
    }

    public static Uri getActualDefaultRingtoneUri(Context context, int type) {
        Uri ringtoneUri;
        String setting = RingtoneManager.getSettingForType(type);
        if (setting == null) {
            return null;
        }
        String uriString = Settings.System.getStringForUser(context.getContentResolver(), setting, context.getUserId());
        Uri uri = ringtoneUri = uriString != null ? Uri.parse(uriString) : null;
        if (ringtoneUri != null && ContentProvider.getUserIdFromUri(ringtoneUri) == context.getUserId()) {
            ringtoneUri = ContentProvider.getUriWithoutUserId(ringtoneUri);
        }
        return ringtoneUri;
    }

    public static void setActualDefaultRingtoneUri(Context context, int type, Uri ringtoneUri) {
        String setting = RingtoneManager.getSettingForType(type);
        if (setting == null) {
            return;
        }
        ContentResolver resolver = context.getContentResolver();
        if (!RingtoneManager.isInternalRingtoneUri(ringtoneUri)) {
            ringtoneUri = ContentProvider.maybeAddUserId(ringtoneUri, context.getUserId());
        }
        if (ringtoneUri != null) {
            String mimeType = resolver.getType(ringtoneUri);
            if (mimeType == null) {
                Log.e(TAG, "setActualDefaultRingtoneUri for URI:" + ringtoneUri + " ignored: failure to find mimeType (no access from this context?)");
                return;
            }
            if (!(mimeType.startsWith("audio/") || mimeType.equals("application/ogg") || mimeType.equals("application/x-flac") || mimeType.startsWith("video/") || mimeType.equals("application/mp4"))) {
                Log.e(TAG, "setActualDefaultRingtoneUri for URI:" + ringtoneUri + " ignored: associated MIME type:" + mimeType + " is not a recognized audio or video type");
                return;
            }
        }
        Settings.System.putStringForUser(resolver, setting, ringtoneUri != null ? ringtoneUri.toString() : null, context.getUserId());
    }

    private static boolean isInternalRingtoneUri(Uri uri) {
        return RingtoneManager.isRingtoneUriInStorage(uri, MediaStore.Audio.Media.INTERNAL_CONTENT_URI);
    }

    private static boolean isExternalRingtoneUri(Uri uri) {
        return RingtoneManager.isRingtoneUriInStorage(uri, MediaStore.Audio.Media.EXTERNAL_CONTENT_URI);
    }

    private static boolean isRingtoneUriInStorage(Uri ringtone, Uri storage) {
        Uri uriWithoutUserId = ContentProvider.getUriWithoutUserId(ringtone);
        return uriWithoutUserId == null ? false : uriWithoutUserId.toString().startsWith(storage.toString());
    }

    public Uri addCustomExternalRingtone(@NonNull Uri fileUri, int type) throws FileNotFoundException, IllegalArgumentException, IOException {
        if (!Environment.getExternalStorageState().equals("mounted")) {
            throw new IOException("External storage is not mounted. Unable to install ringtones.");
        }
        String mimeType = this.mContext.getContentResolver().getType(fileUri);
        if (mimeType == null || !mimeType.startsWith("audio/") && !mimeType.equals("application/ogg")) {
            throw new IllegalArgumentException("Ringtone file must have MIME type \"audio/*\". Given file has MIME type \"" + mimeType + "\"");
        }
        String subdirectory = RingtoneManager.getExternalDirectoryForType(type);
        File outFile = Utils.getUniqueExternalFile(this.mContext, subdirectory, FileUtils.buildValidFatFilename(Utils.getFileDisplayNameFromUri(this.mContext, fileUri)), mimeType);
        try (InputStream input = this.mContext.getContentResolver().openInputStream(fileUri);
             FileOutputStream output = new FileOutputStream(outFile);){
            FileUtils.copy(input, output);
        }
        return MediaStore.scanFile(this.mContext.getContentResolver(), outFile);
    }

    private static String getExternalDirectoryForType(int type) {
        switch (type) {
            case 1: {
                return Environment.DIRECTORY_RINGTONES;
            }
            case 2: {
                return Environment.DIRECTORY_NOTIFICATIONS;
            }
            case 4: {
                return Environment.DIRECTORY_ALARMS;
            }
        }
        throw new IllegalArgumentException("Unsupported ringtone type: " + type);
    }

    private static String getSettingForType(int type) {
        if ((type & 1) != 0) {
            return "ringtone";
        }
        if ((type & 2) != 0) {
            return "notification_sound";
        }
        if ((type & 4) != 0) {
            return "alarm_alert";
        }
        return null;
    }

    public static Uri getCacheForType(int type) {
        return RingtoneManager.getCacheForType(type, UserHandle.getCallingUserId());
    }

    public static Uri getCacheForType(int type, int userId) {
        if ((type & 1) != 0) {
            return ContentProvider.maybeAddUserId(Settings.System.RINGTONE_CACHE_URI, userId);
        }
        if ((type & 2) != 0) {
            return ContentProvider.maybeAddUserId(Settings.System.NOTIFICATION_SOUND_CACHE_URI, userId);
        }
        if ((type & 4) != 0) {
            return ContentProvider.maybeAddUserId(Settings.System.ALARM_ALERT_CACHE_URI, userId);
        }
        return null;
    }

    public static boolean isDefault(Uri ringtoneUri) {
        return RingtoneManager.getDefaultType(ringtoneUri) != -1;
    }

    public static int getDefaultType(Uri defaultRingtoneUri) {
        if ((defaultRingtoneUri = ContentProvider.getUriWithoutUserId(defaultRingtoneUri)) == null) {
            return -1;
        }
        if (Flags.enableRingtoneHapticsCustomization() && Utils.hasVibration(defaultRingtoneUri)) {
            if (defaultRingtoneUri.toString().contains(Settings.System.DEFAULT_RINGTONE_URI.toString())) {
                return 1;
            }
            if (defaultRingtoneUri.toString().contains(Settings.System.DEFAULT_NOTIFICATION_URI.toString())) {
                return 2;
            }
            if (defaultRingtoneUri.toString().contains(Settings.System.DEFAULT_ALARM_ALERT_URI.toString())) {
                return 4;
            }
        }
        if (defaultRingtoneUri.equals(Settings.System.DEFAULT_RINGTONE_URI)) {
            return 1;
        }
        if (defaultRingtoneUri.equals(Settings.System.DEFAULT_NOTIFICATION_URI)) {
            return 2;
        }
        if (defaultRingtoneUri.equals(Settings.System.DEFAULT_ALARM_ALERT_URI)) {
            return 4;
        }
        return -1;
    }

    public static Uri getDefaultUri(int type) {
        if ((type & 1) != 0) {
            return Settings.System.DEFAULT_RINGTONE_URI;
        }
        if ((type & 2) != 0) {
            return Settings.System.DEFAULT_NOTIFICATION_URI;
        }
        if ((type & 4) != 0) {
            return Settings.System.DEFAULT_ALARM_ALERT_URI;
        }
        return null;
    }

    @Nullable
    public static AssetFileDescriptor openDefaultRingtoneUri(@NonNull Context context, @NonNull Uri uri) throws FileNotFoundException {
        int type = RingtoneManager.getDefaultType(uri);
        Uri cacheUri = RingtoneManager.getCacheForType(type, context.getUserId());
        Uri actualUri = RingtoneManager.getActualDefaultRingtoneUri(context, type);
        ContentResolver resolver = context.getContentResolver();
        AssetFileDescriptor afd = null;
        if (cacheUri != null && (afd = resolver.openAssetFileDescriptor(cacheUri, "r")) != null) {
            return afd;
        }
        if (actualUri != null) {
            afd = resolver.openAssetFileDescriptor(actualUri, "r");
        }
        return afd;
    }

    public boolean hasHapticChannels(int position) {
        return AudioManager.hasHapticChannels((Context)this.mContext, (Uri)this.getRingtoneUri(position));
    }

    public static boolean hasHapticChannels(@NonNull Uri ringtoneUri) {
        return AudioManager.hasHapticChannels(null, (Uri)ringtoneUri);
    }

    public static boolean hasHapticChannels(@NonNull Context context, @NonNull Uri ringtoneUri) {
        return AudioManager.hasHapticChannels((Context)context, (Uri)ringtoneUri);
    }

    private static Context createPackageContextAsUser(Context context, int userId) {
        try {
            return context.createPackageContextAsUser(context.getPackageName(), 0, UserHandle.of(userId));
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(TAG, "Unable to create package context", e);
            return null;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_SETTINGS")
    public static void ensureDefaultRingtones(@NonNull Context context) {
        for (int type : new int[]{1, 2, 4}) {
            Uri ringtoneUri;
            String setting = RingtoneManager.getDefaultRingtoneSetting(type);
            if (Settings.System.getInt(context.getContentResolver(), setting, 0) != 0 || (ringtoneUri = RingtoneManager.computeDefaultRingtoneUri(context, type)) == null) continue;
            RingtoneManager.setActualDefaultRingtoneUri(context, type, ringtoneUri);
            Settings.System.putInt(context.getContentResolver(), setting, 1);
        }
    }

    private static Uri computeDefaultRingtoneUri(@NonNull Context context, int type) {
        String filename = RingtoneManager.getDefaultRingtoneFilename(type);
        String whichAudio = RingtoneManager.getQueryStringForType(type);
        String where = "_display_name=? AND " + whichAudio + "=?";
        Uri baseUri = MediaStore.Audio.Media.INTERNAL_CONTENT_URI;
        try (Cursor cursor = context.getContentResolver().query(baseUri, new String[]{"_id"}, where, new String[]{filename, "1"}, null);){
            if (cursor.moveToFirst()) {
                Uri ringtoneUri;
                Uri uri = ringtoneUri = context.getContentResolver().canonicalizeOrElse(ContentUris.withAppendedId(baseUri, cursor.getLong(0)));
                return uri;
            }
        }
        return null;
    }

    private static String getDefaultRingtoneSetting(int type) {
        switch (type) {
            case 1: {
                return "ringtone_set";
            }
            case 2: {
                return "notification_sound_set";
            }
            case 4: {
                return "alarm_alert_set";
            }
        }
        throw new IllegalArgumentException();
    }

    private static String getDefaultRingtoneFilename(int type) {
        switch (type) {
            case 1: {
                return SystemProperties.get("ro.config.ringtone");
            }
            case 2: {
                return SystemProperties.get("ro.config.notification_sound");
            }
            case 4: {
                return SystemProperties.get("ro.config.alarm_alert");
            }
        }
        throw new IllegalArgumentException();
    }

    private static String getQueryStringForType(int type) {
        switch (type) {
            case 1: {
                return "is_ringtone";
            }
            case 2: {
                return "is_notification";
            }
            case 4: {
                return "is_alarm";
            }
        }
        throw new IllegalArgumentException();
    }

    private static boolean muteHapticChannelForVibration(Context context, Uri ringtoneUri) {
        Uri vibrationUri = Utils.getVibrationUri(ringtoneUri);
        if (vibrationUri == null) {
            return false;
        }
        if (Objects.equals(vibrationUri.toString(), "synchronized")) {
            return false;
        }
        return Flags.enableRingtoneHapticsCustomization() && Utils.isRingtoneVibrationSettingsSupported(context) && RingtoneManager.hasHapticChannels(ringtoneUri);
    }
}

