/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.media.MediaRouter2Utils;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.android.internal.util.Preconditions;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class MediaRoute2Info
implements Parcelable {
    @NonNull
    public static final Parcelable.Creator<MediaRoute2Info> CREATOR = new Parcelable.Creator<MediaRoute2Info>(){

        @Override
        public MediaRoute2Info createFromParcel(Parcel in) {
            return new MediaRoute2Info(in);
        }

        public MediaRoute2Info[] newArray(int size) {
            return new MediaRoute2Info[size];
        }
    };
    public static final String ROUTE_ID_DEVICE = "DEVICE_ROUTE";
    public static final String ROUTE_ID_DEFAULT = "DEFAULT_ROUTE";
    public static final int CONNECTION_STATE_DISCONNECTED = 0;
    public static final int CONNECTION_STATE_CONNECTING = 1;
    public static final int CONNECTION_STATE_CONNECTED = 2;
    public static final int PLAYBACK_VOLUME_FIXED = 0;
    public static final int PLAYBACK_VOLUME_VARIABLE = 1;
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_BUILTIN_SPEAKER = 2;
    public static final int TYPE_WIRED_HEADSET = 3;
    public static final int TYPE_WIRED_HEADPHONES = 4;
    public static final int TYPE_BLUETOOTH_A2DP = 8;
    public static final int TYPE_HDMI = 9;
    @FlaggedApi(value="com.android.media.flags.enable_audio_policies_device_and_bluetooth_controller")
    public static final int TYPE_HDMI_ARC = 10;
    @FlaggedApi(value="com.android.media.flags.enable_audio_policies_device_and_bluetooth_controller")
    public static final int TYPE_HDMI_EARC = 29;
    @FlaggedApi(value="com.android.media.flags.enable_new_wired_media_route_2_info_types")
    public static final int TYPE_LINE_DIGITAL = 6;
    @FlaggedApi(value="com.android.media.flags.enable_new_wired_media_route_2_info_types")
    public static final int TYPE_LINE_ANALOG = 5;
    @FlaggedApi(value="com.android.media.flags.enable_new_wired_media_route_2_info_types")
    public static final int TYPE_AUX_LINE = 19;
    public static final int TYPE_USB_DEVICE = 11;
    public static final int TYPE_USB_ACCESSORY = 12;
    public static final int TYPE_DOCK = 13;
    public static final int TYPE_USB_HEADSET = 22;
    public static final int TYPE_HEARING_AID = 23;
    public static final int TYPE_BLE_HEADSET = 26;
    @FlaggedApi(value="android.media.audio.enable_multichannel_group_device")
    public static final int TYPE_MULTICHANNEL_SPEAKER_GROUP = 32;
    public static final int TYPE_REMOTE_TV = 1001;
    public static final int TYPE_REMOTE_SPEAKER = 1002;
    public static final int TYPE_REMOTE_AUDIO_VIDEO_RECEIVER = 1003;
    @FlaggedApi(value="com.android.media.flags.enable_new_media_route_2_info_types")
    public static final int TYPE_REMOTE_TABLET = 1004;
    @FlaggedApi(value="com.android.media.flags.enable_new_media_route_2_info_types")
    public static final int TYPE_REMOTE_TABLET_DOCKED = 1005;
    @FlaggedApi(value="com.android.media.flags.enable_new_media_route_2_info_types")
    public static final int TYPE_REMOTE_COMPUTER = 1006;
    @FlaggedApi(value="com.android.media.flags.enable_new_media_route_2_info_types")
    public static final int TYPE_REMOTE_GAME_CONSOLE = 1007;
    @FlaggedApi(value="com.android.media.flags.enable_new_media_route_2_info_types")
    public static final int TYPE_REMOTE_CAR = 1008;
    @FlaggedApi(value="com.android.media.flags.enable_new_media_route_2_info_types")
    public static final int TYPE_REMOTE_SMARTWATCH = 1009;
    @FlaggedApi(value="com.android.media.flags.enable_new_media_route_2_info_types")
    public static final int TYPE_REMOTE_SMARTPHONE = 1010;
    public static final int TYPE_GROUP = 2000;
    @FlaggedApi(value="com.android.media.flags.enable_mirroring_in_media_router_2")
    public static final int FLAG_ROUTING_TYPE_SYSTEM_AUDIO = 1;
    @FlaggedApi(value="com.android.media.flags.enable_mirroring_in_media_router_2")
    public static final int FLAG_ROUTING_TYPE_SYSTEM_VIDEO = 2;
    @FlaggedApi(value="com.android.media.flags.enable_mirroring_in_media_router_2")
    public static final int FLAG_ROUTING_TYPE_REMOTE = 4;
    private static final int FLAG_ROUTING_TYPE_ALL = 7;
    public static final String FEATURE_LIVE_AUDIO = "android.media.route.feature.LIVE_AUDIO";
    public static final String FEATURE_LIVE_VIDEO = "android.media.route.feature.LIVE_VIDEO";
    public static final String FEATURE_LOCAL_PLAYBACK = "android.media.route.feature.LOCAL_PLAYBACK";
    public static final String FEATURE_REMOTE_PLAYBACK = "android.media.route.feature.REMOTE_PLAYBACK";
    public static final String FEATURE_REMOTE_AUDIO_PLAYBACK = "android.media.route.feature.REMOTE_AUDIO_PLAYBACK";
    public static final String FEATURE_REMOTE_VIDEO_PLAYBACK = "android.media.route.feature.REMOTE_VIDEO_PLAYBACK";
    public static final String FEATURE_REMOTE_GROUP_PLAYBACK = "android.media.route.feature.REMOTE_GROUP_PLAYBACK";
    @FlaggedApi(value="com.android.media.flags.enable_built_in_speaker_route_suitability_statuses")
    public static final int SUITABILITY_STATUS_SUITABLE_FOR_DEFAULT_TRANSFER = 0;
    @FlaggedApi(value="com.android.media.flags.enable_built_in_speaker_route_suitability_statuses")
    public static final int SUITABILITY_STATUS_SUITABLE_FOR_MANUAL_TRANSFER = 1;
    @FlaggedApi(value="com.android.media.flags.enable_built_in_speaker_route_suitability_statuses")
    public static final int SUITABILITY_STATUS_NOT_SUITABLE_FOR_TRANSFER = 2;
    private final String mId;
    private final CharSequence mName;
    private final List<String> mFeatures;
    private final int mType;
    private final int mRoutingTypeFlags;
    private final boolean mIsSystem;
    private final Uri mIconUri;
    private final CharSequence mDescription;
    private final int mConnectionState;
    private final String mClientPackageName;
    private final String mProviderPackageName;
    private final int mVolumeHandling;
    private final int mVolumeMax;
    private final int mVolume;
    private final String mAddress;
    private final Set<String> mDeduplicationIds;
    private final Bundle mExtras;
    private final String mProviderId;
    private final boolean mIsVisibilityRestricted;
    private final Set<String> mAllowedPackages;
    private final List<Set<String>> mRequiredPermissions;
    private final int mSuitabilityStatus;

    MediaRoute2Info(@NonNull Builder builder) {
        this.mId = builder.mId;
        this.mName = builder.mName;
        this.mFeatures = builder.mFeatures;
        this.mType = builder.mType;
        this.mRoutingTypeFlags = builder.mRoutingTypeFlags;
        this.mIsSystem = builder.mIsSystem;
        this.mIconUri = builder.mIconUri;
        this.mDescription = builder.mDescription;
        this.mConnectionState = builder.mConnectionState;
        this.mClientPackageName = builder.mClientPackageName;
        this.mProviderPackageName = builder.mProviderPackageName;
        this.mVolumeHandling = builder.mVolumeHandling;
        this.mVolumeMax = builder.mVolumeMax;
        this.mVolume = builder.mVolume;
        this.mAddress = builder.mAddress;
        this.mDeduplicationIds = builder.mDeduplicationIds;
        this.mExtras = builder.mExtras;
        this.mProviderId = builder.mProviderId;
        this.mIsVisibilityRestricted = builder.mIsVisibilityRestricted;
        this.mAllowedPackages = builder.mAllowedPackages;
        this.mSuitabilityStatus = builder.mSuitabilityStatus;
        this.mRequiredPermissions = List.copyOf(builder.mRequiredPermissions);
    }

    MediaRoute2Info(@NonNull Parcel in) {
        this.mId = in.readString();
        Preconditions.checkArgument(!TextUtils.isEmpty(this.mId));
        this.mName = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        this.mFeatures = in.createStringArrayList();
        this.mType = in.readInt();
        this.mRoutingTypeFlags = MediaRoute2Info.validateRoutingTypeFlags(in.readInt());
        this.mIsSystem = in.readBoolean();
        this.mIconUri = in.readParcelable(null, Uri.class);
        this.mDescription = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        this.mConnectionState = in.readInt();
        this.mClientPackageName = in.readString();
        this.mProviderPackageName = in.readString();
        this.mVolumeHandling = in.readInt();
        this.mVolumeMax = in.readInt();
        this.mVolume = in.readInt();
        this.mAddress = in.readString();
        this.mDeduplicationIds = Set.of(in.readStringArray());
        this.mExtras = in.readBundle();
        this.mProviderId = in.readString();
        this.mIsVisibilityRestricted = in.readBoolean();
        this.mAllowedPackages = Set.of(in.createString8Array());
        ArrayList<Set<String>> requiredPermissions = new ArrayList<Set<String>>();
        int numRequiredPermissionSets = in.readInt();
        for (int i = 0; i < numRequiredPermissionSets; ++i) {
            requiredPermissions.add(Set.of(in.createString8Array()));
        }
        this.mRequiredPermissions = List.copyOf(requiredPermissions);
        this.mSuitabilityStatus = in.readInt();
    }

    @NonNull
    public String getId() {
        if (!TextUtils.isEmpty(this.mProviderId)) {
            return MediaRouter2Utils.toUniqueId(this.mProviderId, this.mId);
        }
        return this.mId;
    }

    @NonNull
    public CharSequence getName() {
        return this.mName;
    }

    @NonNull
    public List<String> getFeatures() {
        return this.mFeatures;
    }

    public int getType() {
        return this.mType;
    }

    @FlaggedApi(value="com.android.media.flags.enable_mirroring_in_media_router_2")
    public int getSupportedRoutingTypes() {
        return this.mRoutingTypeFlags;
    }

    public boolean isSystemRoute() {
        return this.mIsSystem;
    }

    @Nullable
    public Uri getIconUri() {
        return this.mIconUri;
    }

    @Nullable
    public CharSequence getDescription() {
        return this.mDescription;
    }

    public int getConnectionState() {
        return this.mConnectionState;
    }

    @Nullable
    public String getClientPackageName() {
        return this.mClientPackageName;
    }

    @FlaggedApi(value="com.android.media.flags.enable_media_route_2_info_provider_package_name")
    @Nullable
    public String getProviderPackageName() {
        return this.mProviderPackageName;
    }

    public int getVolumeHandling() {
        return this.mVolumeHandling;
    }

    public int getVolumeMax() {
        return this.mVolumeMax;
    }

    public int getVolume() {
        return this.mVolume;
    }

    @Nullable
    public String getAddress() {
        return this.mAddress;
    }

    @NonNull
    public Set<String> getDeduplicationIds() {
        return this.mDeduplicationIds;
    }

    @Nullable
    public Bundle getExtras() {
        return this.mExtras == null ? null : new Bundle(this.mExtras);
    }

    @NonNull
    public String getOriginalId() {
        return this.mId;
    }

    @Nullable
    public String getProviderId() {
        return this.mProviderId;
    }

    public boolean hasAnyFeatures(@NonNull Collection<String> features) {
        Objects.requireNonNull(features, "features must not be null");
        for (String feature : features) {
            if (!this.getFeatures().contains(feature)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAllFeatures(@NonNull Collection<String> features) {
        Objects.requireNonNull(features, "features must not be null");
        for (String feature : features) {
            if (this.getFeatures().contains(feature)) continue;
            return false;
        }
        return true;
    }

    public boolean supportsSystemMediaRouting() {
        return (this.mRoutingTypeFlags & 3) != 0;
    }

    public boolean supportsRemoteRouting() {
        return (this.mRoutingTypeFlags & 4) != 0;
    }

    public boolean isValid() {
        return !TextUtils.isEmpty(this.getId()) && !TextUtils.isEmpty(this.getName()) && !TextUtils.isEmpty(this.getProviderId());
    }

    public boolean isVisibleTo(@NonNull String packageName) {
        return !this.mIsVisibilityRestricted || TextUtils.equals(this.getProviderPackageName(), packageName) || this.mAllowedPackages.contains(packageName);
    }

    @NonNull
    @FlaggedApi(value="com.android.media.flags.enable_route_visibility_control_api")
    public List<Set<String>> getRequiredPermissions() {
        return this.mRequiredPermissions;
    }

    @SuppressLint(value={"SwitchIntDef"})
    public boolean isSystemRouteType() {
        boolean bl;
        switch (this.mType) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 22: 
            case 23: 
            case 26: 
            case 29: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @FlaggedApi(value="com.android.media.flags.enable_built_in_speaker_route_suitability_statuses")
    public int getSuitabilityStatus() {
        return this.mSuitabilityStatus;
    }

    public void dump(@NonNull PrintWriter pw, @NonNull String prefix) {
        pw.println(prefix + "MediaRoute2Info");
        String indent = prefix + "  ";
        pw.println(indent + "mId=" + this.mId);
        pw.println(indent + "mName=" + this.mName);
        pw.println(indent + "mFeatures=" + this.mFeatures);
        pw.println(indent + "mType=" + MediaRoute2Info.getDeviceTypeString(this.mType));
        pw.println(indent + "mRoutingTypeFlags=" + MediaRoute2Info.getRoutingTypeFlagsString(this.mRoutingTypeFlags));
        pw.println(indent + "mIsSystem=" + this.mIsSystem);
        pw.println(indent + "mIconUri=" + this.mIconUri);
        pw.println(indent + "mDescription=" + this.mDescription);
        pw.println(indent + "mConnectionState=" + this.mConnectionState);
        pw.println(indent + "mClientPackageName=" + this.mClientPackageName);
        pw.println(indent + "mProviderPackageName=" + this.mProviderPackageName);
        this.dumpVolume(pw, indent);
        pw.println(indent + "mAddress=" + this.mAddress);
        pw.println(indent + "mDeduplicationIds=" + this.mDeduplicationIds);
        pw.println(indent + "mExtras=" + this.mExtras);
        pw.println(indent + "mProviderId=" + this.mProviderId);
        pw.println(indent + "mIsVisibilityRestricted=" + this.mIsVisibilityRestricted);
        pw.println(indent + "mAllowedPackages=" + this.mAllowedPackages);
        pw.println(indent + "mSuitabilityStatus=" + this.mSuitabilityStatus);
        pw.println(indent + "mRequiredPermissions=" + this.mRequiredPermissions);
    }

    private void dumpVolume(@NonNull PrintWriter pw, @NonNull String prefix) {
        pw.println(prefix + MediaRoute2Info.getVolumeString(this.mVolume, this.mVolumeMax, this.mVolumeHandling));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MediaRoute2Info)) {
            return false;
        }
        MediaRoute2Info other = (MediaRoute2Info)obj;
        return Objects.equals(this.mId, other.mId) && Objects.equals(this.mName, other.mName) && Objects.equals(this.mFeatures, other.mFeatures) && this.mType == other.mType && this.mRoutingTypeFlags == other.mRoutingTypeFlags && this.mIsSystem == other.mIsSystem && Objects.equals(this.mIconUri, other.mIconUri) && Objects.equals(this.mDescription, other.mDescription) && this.mConnectionState == other.mConnectionState && Objects.equals(this.mClientPackageName, other.mClientPackageName) && Objects.equals(this.mProviderPackageName, other.mProviderPackageName) && this.mVolumeHandling == other.mVolumeHandling && this.mVolumeMax == other.mVolumeMax && this.mVolume == other.mVolume && Objects.equals(this.mAddress, other.mAddress) && Objects.equals(this.mDeduplicationIds, other.mDeduplicationIds) && Objects.equals(this.mProviderId, other.mProviderId) && this.mIsVisibilityRestricted == other.mIsVisibilityRestricted && Objects.equals(this.mAllowedPackages, other.mAllowedPackages) && Objects.equals(this.mRequiredPermissions, other.mRequiredPermissions) && this.mSuitabilityStatus == other.mSuitabilityStatus;
    }

    public int hashCode() {
        return Objects.hash(this.mId, this.mName, this.mFeatures, this.mType, this.mRoutingTypeFlags, this.mIsSystem, this.mIconUri, this.mDescription, this.mConnectionState, this.mClientPackageName, this.mProviderPackageName, this.mVolumeHandling, this.mVolumeMax, this.mVolume, this.mAddress, this.mDeduplicationIds, this.mProviderId, this.mIsVisibilityRestricted, this.mAllowedPackages, this.mRequiredPermissions, this.mSuitabilityStatus);
    }

    public String toString() {
        return "MediaRoute2Info{ " + "id=" + this.getId() + ", name=" + this.getName() + ", type=" + MediaRoute2Info.getDeviceTypeString(this.getType()) + ", routingTypes=" + MediaRoute2Info.getRoutingTypeFlagsString(this.getSupportedRoutingTypes()) + ", isSystem=" + this.isSystemRoute() + ", features=" + this.getFeatures() + ", iconUri=" + this.getIconUri() + ", description=" + this.getDescription() + ", connectionState=" + this.getConnectionState() + ", clientPackageName=" + this.getClientPackageName() + ", " + MediaRoute2Info.getVolumeString(this.mVolume, this.mVolumeMax, this.mVolumeHandling) + ", address=" + this.getAddress() + ", deduplicationIds=" + String.join((CharSequence)",", this.getDeduplicationIds()) + ", providerId=" + this.getProviderId() + ", isVisibilityRestricted=" + this.mIsVisibilityRestricted + ", allowedPackages=" + String.join((CharSequence)",", this.mAllowedPackages) + ", mRequiredPermissions=" + this.mRequiredPermissions.stream().map(set -> String.join((CharSequence)",", set)).collect(Collectors.joining("),(", "(", ")")) + ", suitabilityStatus=" + this.mSuitabilityStatus + " }";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mId);
        TextUtils.writeToParcel(this.mName, dest, flags);
        dest.writeStringList(this.mFeatures);
        dest.writeInt(this.mType);
        dest.writeInt(this.mRoutingTypeFlags);
        dest.writeBoolean(this.mIsSystem);
        dest.writeParcelable(this.mIconUri, flags);
        TextUtils.writeToParcel(this.mDescription, dest, flags);
        dest.writeInt(this.mConnectionState);
        dest.writeString(this.mClientPackageName);
        dest.writeString(this.mProviderPackageName);
        dest.writeInt(this.mVolumeHandling);
        dest.writeInt(this.mVolumeMax);
        dest.writeInt(this.mVolume);
        dest.writeString(this.mAddress);
        dest.writeStringArray(this.mDeduplicationIds.toArray(new String[this.mDeduplicationIds.size()]));
        dest.writeBundle(this.mExtras);
        dest.writeString(this.mProviderId);
        dest.writeBoolean(this.mIsVisibilityRestricted);
        dest.writeString8Array(this.mAllowedPackages.toArray(new String[0]));
        dest.writeInt(this.mRequiredPermissions.size());
        for (Set<String> permissionSet : this.mRequiredPermissions) {
            dest.writeString8Array(permissionSet.toArray(new String[0]));
        }
        dest.writeInt(this.mSuitabilityStatus);
    }

    static String getVolumeString(int volume, int maxVolume, int volumeHandling) {
        String volumeHandlingName;
        switch (volumeHandling) {
            case 0: {
                volumeHandlingName = "FIXED";
                break;
            }
            case 1: {
                volumeHandlingName = "VARIABLE";
                break;
            }
            default: {
                volumeHandlingName = "UNKNOWN";
            }
        }
        return String.format(Locale.US, "volume(current=%d, max=%d, handling=%s(%d))", volume, maxVolume, volumeHandlingName, volumeHandling);
    }

    private static String getDeviceTypeString(int deviceType) {
        switch (deviceType) {
            case 2: {
                return "BUILTIN_SPEAKER";
            }
            case 3: {
                return "WIRED_HEADSET";
            }
            case 4: {
                return "WIRED_HEADPHONES";
            }
            case 8: {
                return "BLUETOOTH_A2DP";
            }
            case 9: {
                return "HDMI";
            }
            case 10: {
                return "HDMI_ARC";
            }
            case 29: {
                return "HDMI_EARC";
            }
            case 6: {
                return "LINE_DIGITAL";
            }
            case 5: {
                return "LINE_ANALOG";
            }
            case 19: {
                return "AUX_LINE";
            }
            case 13: {
                return "DOCK";
            }
            case 11: {
                return "USB_DEVICE";
            }
            case 12: {
                return "USB_ACCESSORY";
            }
            case 22: {
                return "USB_HEADSET";
            }
            case 23: {
                return "HEARING_AID";
            }
            case 1001: {
                return "REMOTE_TV";
            }
            case 1002: {
                return "REMOTE_SPEAKER";
            }
            case 1003: {
                return "REMOTE_AUDIO_VIDEO_RECEIVER";
            }
            case 1004: {
                return "REMOTE_TABLET";
            }
            case 1005: {
                return "REMOTE_TABLET_DOCKED";
            }
            case 1006: {
                return "REMOTE_COMPUTER";
            }
            case 1007: {
                return "REMOTE_GAME_CONSOLE";
            }
            case 1008: {
                return "REMOTE_CAR";
            }
            case 1009: {
                return "REMOTE_SMARTWATCH";
            }
            case 1010: {
                return "REMOTE_SMARTPHONE";
            }
            case 2000: {
                return "GROUP";
            }
        }
        return TextUtils.formatSimple("UNKNOWN(%d)", deviceType);
    }

    private static String getRoutingTypeFlagsString(int routingTypeFlags) {
        ArrayList<String> typeStrings = new ArrayList<String>();
        if ((routingTypeFlags & 1) != 0) {
            typeStrings.add("SYSTEM_AUDIO");
        }
        if ((routingTypeFlags & 2) != 0) {
            typeStrings.add("SYSTEM_VIDEO");
        }
        if ((routingTypeFlags & 4) != 0) {
            typeStrings.add("REMOTE");
        }
        return String.join((CharSequence)"|", typeStrings);
    }

    private static int validateRoutingTypeFlags(int routingTypeFlags) {
        if (routingTypeFlags == 0 || (routingTypeFlags & 0xFFFFFFF8) != 0) {
            throw new IllegalArgumentException("Invalid routing type flags: " + Integer.toHexString(routingTypeFlags));
        }
        return routingTypeFlags;
    }

    public static class Builder {
        private final String mId;
        private final CharSequence mName;
        private final List<String> mFeatures;
        private int mType = 0;
        private int mRoutingTypeFlags = 4;
        private boolean mIsSystem;
        private Uri mIconUri;
        private CharSequence mDescription;
        private int mConnectionState;
        private String mClientPackageName;
        private String mProviderPackageName;
        private int mVolumeHandling = 0;
        private int mVolumeMax;
        private int mVolume;
        private String mAddress;
        private Set<String> mDeduplicationIds;
        private Bundle mExtras;
        private String mProviderId;
        private boolean mIsVisibilityRestricted;
        private Set<String> mAllowedPackages;
        private List<Set<String>> mRequiredPermissions;
        private int mSuitabilityStatus;

        public Builder(@NonNull String id2, @NonNull CharSequence name) {
            if (TextUtils.isEmpty(id2)) {
                throw new IllegalArgumentException("id must not be empty");
            }
            if (TextUtils.isEmpty(name)) {
                throw new IllegalArgumentException("name must not be empty");
            }
            this.mId = id2;
            this.mName = name;
            this.mFeatures = new ArrayList<String>();
            this.mDeduplicationIds = Set.of();
            this.mAllowedPackages = Set.of();
            this.mSuitabilityStatus = 0;
            this.mRequiredPermissions = List.of();
        }

        public Builder(@NonNull MediaRoute2Info routeInfo) {
            this(routeInfo.mId, routeInfo);
        }

        public Builder(@NonNull String id2, @NonNull MediaRoute2Info routeInfo) {
            if (TextUtils.isEmpty(id2)) {
                throw new IllegalArgumentException("id must not be empty");
            }
            Objects.requireNonNull(routeInfo, "routeInfo must not be null");
            this.mId = id2;
            this.mName = routeInfo.mName;
            this.mFeatures = new ArrayList<String>(routeInfo.mFeatures);
            this.mType = routeInfo.mType;
            this.mRoutingTypeFlags = routeInfo.mRoutingTypeFlags;
            this.mIsSystem = routeInfo.mIsSystem;
            this.mIconUri = routeInfo.mIconUri;
            this.mDescription = routeInfo.mDescription;
            this.mConnectionState = routeInfo.mConnectionState;
            this.mClientPackageName = routeInfo.mClientPackageName;
            this.mProviderPackageName = routeInfo.mProviderPackageName;
            this.mVolumeHandling = routeInfo.mVolumeHandling;
            this.mVolumeMax = routeInfo.mVolumeMax;
            this.mVolume = routeInfo.mVolume;
            this.mAddress = routeInfo.mAddress;
            this.mDeduplicationIds = Set.copyOf(routeInfo.mDeduplicationIds);
            if (routeInfo.mExtras != null) {
                this.mExtras = new Bundle(routeInfo.mExtras);
            }
            this.mProviderId = routeInfo.mProviderId;
            this.mIsVisibilityRestricted = routeInfo.mIsVisibilityRestricted;
            this.mAllowedPackages = routeInfo.mAllowedPackages;
            this.mSuitabilityStatus = routeInfo.mSuitabilityStatus;
            this.mRequiredPermissions = routeInfo.mRequiredPermissions;
        }

        @NonNull
        public Builder addFeature(@NonNull String feature) {
            if (TextUtils.isEmpty(feature)) {
                throw new IllegalArgumentException("feature must not be null or empty");
            }
            this.mFeatures.add(feature);
            return this;
        }

        @NonNull
        public Builder addFeatures(@NonNull Collection<String> features) {
            Objects.requireNonNull(features, "features must not be null");
            for (String feature : features) {
                this.addFeature(feature);
            }
            return this;
        }

        @NonNull
        public Builder clearFeatures() {
            this.mFeatures.clear();
            return this;
        }

        @NonNull
        public Builder setType(int type) {
            this.mType = type;
            return this;
        }

        @NonNull
        @FlaggedApi(value="com.android.media.flags.enable_mirroring_in_media_router_2")
        public Builder setSupportedRoutingTypes(int routingTypeFlags) {
            this.mRoutingTypeFlags = MediaRoute2Info.validateRoutingTypeFlags(routingTypeFlags);
            return this;
        }

        @NonNull
        public Builder setSystemRoute(boolean isSystem) {
            this.mIsSystem = isSystem;
            return this;
        }

        @NonNull
        public Builder setIconUri(@Nullable Uri iconUri) {
            this.mIconUri = iconUri;
            return this;
        }

        @NonNull
        public Builder setDescription(@Nullable CharSequence description) {
            this.mDescription = description;
            return this;
        }

        @NonNull
        public Builder setConnectionState(int connectionState) {
            this.mConnectionState = connectionState;
            return this;
        }

        @NonNull
        public Builder setClientPackageName(@Nullable String packageName) {
            this.mClientPackageName = packageName;
            return this;
        }

        @NonNull
        public Builder setProviderPackageName(@NonNull String providerPackageName) {
            this.mProviderPackageName = providerPackageName;
            return this;
        }

        @NonNull
        public Builder setVolumeHandling(int volumeHandling) {
            this.mVolumeHandling = volumeHandling;
            return this;
        }

        @NonNull
        public Builder setVolumeMax(int volumeMax) {
            this.mVolumeMax = volumeMax;
            return this;
        }

        @NonNull
        public Builder setVolume(int volume) {
            this.mVolume = volume;
            return this;
        }

        @NonNull
        public Builder setAddress(String address) {
            this.mAddress = address;
            return this;
        }

        @NonNull
        public Builder setDeduplicationIds(@NonNull Set<String> id2) {
            this.mDeduplicationIds = Set.copyOf(id2);
            return this;
        }

        @NonNull
        public Builder setExtras(@Nullable Bundle extras) {
            if (extras == null) {
                this.mExtras = null;
                return this;
            }
            this.mExtras = new Bundle(extras);
            return this;
        }

        @NonNull
        public Builder setProviderId(@NonNull String providerId) {
            if (TextUtils.isEmpty(providerId)) {
                throw new IllegalArgumentException("providerId must not be null or empty");
            }
            this.mProviderId = providerId;
            return this;
        }

        @NonNull
        public Builder setVisibilityPublic() {
            this.mIsVisibilityRestricted = false;
            this.mAllowedPackages = Set.of();
            this.mRequiredPermissions = List.of();
            return this;
        }

        @NonNull
        public Builder setVisibilityRestricted(@NonNull Set<String> allowedPackages) {
            this.mIsVisibilityRestricted = true;
            this.mAllowedPackages = Set.copyOf(allowedPackages);
            return this;
        }

        @NonNull
        @FlaggedApi(value="com.android.media.flags.enable_route_visibility_control_api")
        public Builder setRequiredPermissions(@NonNull Set<String> requiredPermissions) {
            return this.setRequiredPermissions(List.of(requiredPermissions));
        }

        @NonNull
        @FlaggedApi(value="com.android.media.flags.enable_route_visibility_control_api")
        public Builder setRequiredPermissions(@NonNull List<Set<String>> requiresOneOf) {
            this.mRequiredPermissions = List.copyOf(requiresOneOf);
            return this;
        }

        @NonNull
        @FlaggedApi(value="com.android.media.flags.enable_built_in_speaker_route_suitability_statuses")
        public Builder setSuitabilityStatus(int suitabilityStatus) {
            this.mSuitabilityStatus = suitabilityStatus;
            return this;
        }

        @NonNull
        public MediaRoute2Info build() {
            if (this.mFeatures.isEmpty()) {
                throw new IllegalArgumentException("features must not be empty!");
            }
            return new MediaRoute2Info(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @FlaggedApi(value="com.android.media.flags.enable_built_in_speaker_route_suitability_statuses")
    public static @interface SuitabilityStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RoutingType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PlaybackVolume {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConnectionState {
    }
}

