/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.media.IMediaCommunicationService;
import android.media.IMediaCommunicationServiceCallback;
import android.media.MediaFrameworkInitializer;
import android.media.MediaParceledListSlice;
import android.media.Session2Token;
import android.media.internal.annotation.MinSdk;
import android.media.internal.flags.Flags;
import android.media.internal.utils.build.SdkLevel;
import android.media.session.MediaSessionManager;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Log;
import android.view.KeyEvent;
import com.android.internal.annotations.GuardedBy;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;

@MinSdk(value=31)
@RequiresApi(value=31)
public class MediaCommunicationManager {
    private static final String TAG = "MediaCommunicationManager";
    private static final int VERSION_1 = 1;
    private static final int CURRENT_VERSION = 1;
    private final Context mContext;
    private IMediaCommunicationService mService;
    private final Object mLock = new Object();
    private final CopyOnWriteArrayList<SessionCallbackRecord> mTokenCallbackRecords = new CopyOnWriteArrayList();
    @GuardedBy(value={"mLock"})
    private MediaCommunicationServiceCallbackStub mCallbackStub;
    private MediaSessionManager mMediaSessionManager;

    public MediaCommunicationManager(@NonNull Context context) {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException("Android version must be S or greater.");
        }
        this.mContext = context;
    }

    public int getVersion() {
        return 1;
    }

    public void notifySession2Created(@NonNull Session2Token token) {
        Objects.requireNonNull(token, "token shouldn't be null");
        if (token.getType() != 0) {
            throw new IllegalArgumentException("token's type should be TYPE_SESSION");
        }
        try {
            this.getService().notifySession2Created(token);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public boolean isTrustedForMediaControl(@NonNull MediaSessionManager.RemoteUserInfo userInfo) {
        Objects.requireNonNull(userInfo, "userInfo shouldn't be null");
        if (userInfo.getPackageName() == null) {
            return false;
        }
        try {
            return this.getService().isTrusted(userInfo.getPackageName(), userInfo.getPid(), userInfo.getUid());
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot communicate with the service.", e);
            return false;
        }
    }

    @NonNull
    public List<Session2Token> getSession2Tokens() {
        return this.getSession2Tokens(UserHandle.myUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(value="android.permission.MEDIA_CONTENT_CONTROL")
    public void registerSessionCallback(@NonNull Executor executor, @NonNull SessionCallback callback) {
        Objects.requireNonNull(executor, "executor must not be null");
        Objects.requireNonNull(callback, "callback must not be null");
        if (!this.mTokenCallbackRecords.addIfAbsent(new SessionCallbackRecord(executor, callback))) {
            Log.w(TAG, "registerSession2TokenCallback: Ignoring the same callback");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCallbackStub == null) {
                MediaCommunicationServiceCallbackStub callbackStub = new MediaCommunicationServiceCallbackStub();
                try {
                    this.getService().registerCallback(callbackStub, this.mContext.getPackageName());
                    this.mCallbackStub = callbackStub;
                }
                catch (RemoteException ex) {
                    ex.rethrowFromSystemServer();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public void unregisterSessionCallback(@NonNull SessionCallback callback) {
        if (!this.mTokenCallbackRecords.remove(new SessionCallbackRecord(null, callback))) {
            Log.w(TAG, "unregisterSession2TokenCallback: Ignoring an unknown callback.");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCallbackStub != null && this.mTokenCallbackRecords.isEmpty()) {
                try {
                    this.getService().unregisterCallback(this.mCallbackStub);
                }
                catch (RemoteException ex) {
                    Log.e(TAG, "Failed to unregister callback.", ex);
                }
                this.mCallbackStub = null;
            }
        }
    }

    private IMediaCommunicationService getService() {
        if (this.mService == null) {
            this.mService = IMediaCommunicationService.Stub.asInterface(MediaFrameworkInitializer.getMediaServiceManager().getMediaCommunicationServiceRegisterer().get());
        }
        return this.mService;
    }

    private MediaSessionManager getMediaSessionManager() {
        if (this.mMediaSessionManager == null) {
            this.mMediaSessionManager = this.mContext.getSystemService(MediaSessionManager.class);
        }
        return this.mMediaSessionManager;
    }

    private List<Session2Token> getSession2Tokens(int userId) {
        try {
            MediaParceledListSlice slice = this.getService().getSession2Tokens(userId);
            return slice == null ? Collections.emptyList() : slice.getList();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to get session tokens", e);
            return Collections.emptyList();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public void dispatchMediaKeyEvent(@NonNull KeyEvent keyEvent, boolean asSystemService) {
        Objects.requireNonNull(keyEvent, "keyEvent shouldn't be null");
        if (!asSystemService) {
            this.getMediaSessionManager().dispatchMediaKeyEvent(keyEvent, false);
            return;
        }
        try {
            this.getService().dispatchMediaKeyEvent(this.mContext.getPackageName(), keyEvent, asSystemService);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to send key event.", e);
        }
    }

    private static class SessionCallbackRecord {
        public final Executor executor;
        public final SessionCallback callback;

        SessionCallbackRecord(Executor executor, SessionCallback callback) {
            this.executor = executor;
            this.callback = callback;
        }

        public int hashCode() {
            return Objects.hash(this.callback);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SessionCallbackRecord)) {
                return false;
            }
            return Objects.equals(this.callback, ((SessionCallbackRecord)obj).callback);
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static interface SessionCallback {
        default public void onSession2TokenCreated(@NonNull Session2Token token) {
        }

        @FlaggedApi(value="android.media.internal.flags.enable_pid_to_media_session_2")
        default public void onSession2TokenCreated(@NonNull Session2Token token, int pid) {
            this.onSession2TokenCreated(token);
        }

        default public void onSession2TokensChanged(@NonNull List<Session2Token> tokens) {
        }
    }

    class MediaCommunicationServiceCallbackStub
    extends IMediaCommunicationServiceCallback.Stub {
        MediaCommunicationServiceCallbackStub() {
        }

        @Override
        public void onSession2Created(Session2Token token, int pid) throws RemoteException {
            for (SessionCallbackRecord record : MediaCommunicationManager.this.mTokenCallbackRecords) {
                record.executor.execute(() -> {
                    if (Flags.enablePidToMediaSession2()) {
                        record.callback.onSession2TokenCreated(token, pid);
                    } else {
                        record.callback.onSession2TokenCreated(token);
                    }
                });
            }
        }

        @Override
        public void onSession2Changed(MediaParceledListSlice tokens) throws RemoteException {
            List tokenList = tokens.getList();
            for (SessionCallbackRecord record : MediaCommunicationManager.this.mTokenCallbackRecords) {
                record.executor.execute(() -> record.callback.onSession2TokensChanged(tokenList));
            }
        }
    }
}

