/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.compat.annotation.UnsupportedAppUsage;
import android.media.AudioSystem;
import android.media.MediaCodec;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.media.Utils;
import android.media.codec.Flags;
import android.os.Process;
import android.os.SystemProperties;
import android.sysprop.MediaProperties;
import android.util.Log;
import android.util.Pair;
import android.util.Range;
import android.util.Rational;
import android.util.Size;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class MediaCodecInfo {
    private static final String TAG = "MediaCodecInfo";
    private static final int FLAG_IS_ENCODER = 1;
    private static final int FLAG_IS_VENDOR = 2;
    private static final int FLAG_IS_SOFTWARE_ONLY = 4;
    private static final int FLAG_IS_HARDWARE_ACCELERATED = 8;
    private int mFlags;
    private String mName;
    private String mCanonicalName;
    private Map<String, CodecCapabilities> mCaps;
    private static final Range<Integer> POSITIVE_INTEGERS = Range.create(1, Integer.MAX_VALUE);
    private static final Range<Long> POSITIVE_LONGS = Range.create(1L, Long.MAX_VALUE);
    private static final Range<Rational> POSITIVE_RATIONALS = Range.create(new Rational(1, Integer.MAX_VALUE), new Rational(Integer.MAX_VALUE, 1));
    private static final Range<Integer> FRAME_RATE_RANGE = Range.create(0, 960);
    private static final Range<Integer> BITRATE_RANGE = Range.create(0, 500000000);
    private static final int DEFAULT_MAX_SUPPORTED_INSTANCES = 32;
    private static final int MAX_SUPPORTED_INSTANCES_LIMIT = 256;
    private static Range<Integer> SIZE_RANGE;
    private static final int ERROR_UNRECOGNIZED = 1;
    private static final int ERROR_UNSUPPORTED = 2;
    private static final int ERROR_NONE_SUPPORTED = 4;
    @FlaggedApi(value="android.media.codec.in_process_sw_audio_codec")
    public static final int SECURITY_MODEL_SANDBOXED = 0;
    @FlaggedApi(value="android.media.codec.in_process_sw_audio_codec")
    public static final int SECURITY_MODEL_MEMORY_SAFE = 1;
    @FlaggedApi(value="android.media.codec.in_process_sw_audio_codec")
    public static final int SECURITY_MODEL_TRUSTED_CONTENT_ONLY = 2;

    MediaCodecInfo(String name, String canonicalName, int flags, CodecCapabilities[] caps) {
        this.mName = name;
        this.mCanonicalName = canonicalName;
        this.mFlags = flags;
        this.mCaps = new HashMap<String, CodecCapabilities>();
        for (CodecCapabilities c : caps) {
            this.mCaps.put(c.getMimeType(), c);
        }
    }

    @NonNull
    public String getName() {
        return this.mName;
    }

    @NonNull
    public String getCanonicalName() {
        return this.mCanonicalName;
    }

    public boolean isAlias() {
        return !this.mName.equals(this.mCanonicalName);
    }

    public boolean isEncoder() {
        return (this.mFlags & 1) != 0;
    }

    public boolean isVendor() {
        return (this.mFlags & 2) != 0;
    }

    public boolean isSoftwareOnly() {
        return (this.mFlags & 4) != 0;
    }

    public boolean isHardwareAccelerated() {
        return (this.mFlags & 8) != 0;
    }

    public String[] getSupportedTypes() {
        Set<String> typeSet = this.mCaps.keySet();
        Object[] types = typeSet.toArray(new String[typeSet.size()]);
        Arrays.sort(types);
        return types;
    }

    private static int checkPowerOfTwo(int value, String message) {
        if ((value & value - 1) != 0) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    private static synchronized Range<Integer> getSizeRange() {
        if (SIZE_RANGE == null) {
            SIZE_RANGE = Process.is64Bit() ? Range.create(1, 32768) : Range.create(1, MediaProperties.resolution_limit_32bit().orElse(4096));
        }
        return SIZE_RANGE;
    }

    @FlaggedApi(value="android.media.codec.in_process_sw_audio_codec")
    public int getSecurityModel() {
        return 0;
    }

    public CodecCapabilities getCapabilitiesForType(String type) {
        CodecCapabilities caps = this.mCaps.get(type);
        if (caps == null) {
            throw new IllegalArgumentException("codec does not support type");
        }
        return caps.dup();
    }

    public MediaCodecInfo makeRegular() {
        ArrayList<CodecCapabilities> caps = new ArrayList<CodecCapabilities>();
        for (CodecCapabilities c : this.mCaps.values()) {
            if (!c.isRegular()) continue;
            caps.add(c);
        }
        if (caps.size() == 0) {
            return null;
        }
        if (caps.size() == this.mCaps.size()) {
            return this;
        }
        return new MediaCodecInfo(this.mName, this.mCanonicalName, this.mFlags, caps.toArray(new CodecCapabilities[caps.size()]));
    }

    public static class CodecCapabilities {
        private String mMime;
        private int mMaxSupportedInstances;
        public CodecProfileLevel[] profileLevels;
        public static final int COLOR_FormatMonochrome = 1;
        public static final int COLOR_Format8bitRGB332 = 2;
        public static final int COLOR_Format12bitRGB444 = 3;
        public static final int COLOR_Format16bitARGB4444 = 4;
        public static final int COLOR_Format16bitARGB1555 = 5;
        public static final int COLOR_Format16bitRGB565 = 6;
        public static final int COLOR_Format16bitBGR565 = 7;
        public static final int COLOR_Format18bitRGB666 = 8;
        public static final int COLOR_Format18bitARGB1665 = 9;
        public static final int COLOR_Format19bitARGB1666 = 10;
        public static final int COLOR_Format24bitRGB888 = 11;
        public static final int COLOR_Format24bitBGR888 = 12;
        public static final int COLOR_Format24bitARGB1887 = 13;
        public static final int COLOR_Format25bitARGB1888 = 14;
        public static final int COLOR_Format32bitBGRA8888 = 15;
        public static final int COLOR_Format32bitARGB8888 = 16;
        public static final int COLOR_FormatYUV411Planar = 17;
        public static final int COLOR_FormatYUV411PackedPlanar = 18;
        public static final int COLOR_FormatYUV420Planar = 19;
        public static final int COLOR_FormatYUV420PackedPlanar = 20;
        public static final int COLOR_FormatYUV420SemiPlanar = 21;
        public static final int COLOR_FormatYUV422Planar = 22;
        public static final int COLOR_FormatYUV422PackedPlanar = 23;
        public static final int COLOR_FormatYUV422SemiPlanar = 24;
        public static final int COLOR_FormatYCbYCr = 25;
        public static final int COLOR_FormatYCrYCb = 26;
        public static final int COLOR_FormatCbYCrY = 27;
        public static final int COLOR_FormatCrYCbY = 28;
        public static final int COLOR_FormatYUV444Interleaved = 29;
        public static final int COLOR_FormatRawBayer8bit = 30;
        public static final int COLOR_FormatRawBayer10bit = 31;
        public static final int COLOR_FormatRawBayer8bitcompressed = 32;
        public static final int COLOR_FormatL2 = 33;
        public static final int COLOR_FormatL4 = 34;
        public static final int COLOR_FormatL8 = 35;
        public static final int COLOR_FormatL16 = 36;
        public static final int COLOR_FormatL24 = 37;
        public static final int COLOR_FormatL32 = 38;
        public static final int COLOR_FormatYUV420PackedSemiPlanar = 39;
        public static final int COLOR_FormatYUV422PackedSemiPlanar = 40;
        public static final int COLOR_Format18BitBGR666 = 41;
        public static final int COLOR_Format24BitARGB6666 = 42;
        public static final int COLOR_Format24BitABGR6666 = 43;
        @SuppressLint(value={"AllUpper"})
        public static final int COLOR_FormatYUVP010 = 54;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.p210_format_support")
        public static final int COLOR_FormatYUVP210 = 60;
        public static final int COLOR_TI_FormatYUV420PackedSemiPlanar = 2130706688;
        public static final int COLOR_FormatSurface = 2130708361;
        @SuppressLint(value={"AllUpper"})
        public static final int COLOR_Format64bitABGRFloat = 2130710294;
        public static final int COLOR_Format32bitABGR8888 = 2130747392;
        @SuppressLint(value={"AllUpper"})
        public static final int COLOR_Format32bitABGR2101010 = 2130750114;
        public static final int COLOR_FormatYUV420Flexible = 2135033992;
        public static final int COLOR_FormatYUV422Flexible = 2135042184;
        public static final int COLOR_FormatYUV444Flexible = 2135181448;
        public static final int COLOR_FormatRGBFlexible = 2134292616;
        public static final int COLOR_FormatRGBAFlexible = 2134288520;
        public static final int COLOR_QCOM_FormatYUV420SemiPlanar = 2141391872;
        public int[] colorFormats;
        private int mFlagsSupported;
        private int mFlagsRequired;
        private int mFlagsVerified;
        public static final String FEATURE_AdaptivePlayback = "adaptive-playback";
        public static final String FEATURE_SecurePlayback = "secure-playback";
        public static final String FEATURE_TunneledPlayback = "tunneled-playback";
        public static final String FEATURE_DynamicTimestamp = "dynamic-timestamp";
        public static final String FEATURE_FrameParsing = "frame-parsing";
        public static final String FEATURE_MultipleFrames = "multiple-frames";
        public static final String FEATURE_PartialFrame = "partial-frame";
        public static final String FEATURE_IntraRefresh = "intra-refresh";
        public static final String FEATURE_LowLatency = "low-latency";
        private static final String FEATURE_SpecialCodec = "special-codec";
        @SuppressLint(value={"AllUpper"})
        public static final String FEATURE_QpBounds = "qp-bounds";
        @SuppressLint(value={"AllUpper"})
        public static final String FEATURE_EncodingStatistics = "encoding-statistics";
        @SuppressLint(value={"AllUpper"})
        public static final String FEATURE_HdrEditing = "hdr-editing";
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.hlg_editing")
        public static final String FEATURE_HlgEditing = "hlg-editing";
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.dynamic_color_aspects")
        public static final String FEATURE_DynamicColorAspects = "dynamic-color-aspects";
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.region_of_interest")
        public static final String FEATURE_Roi = "region-of-interest";
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.null_output_surface")
        public static final String FEATURE_DetachedSurface = "detached-surface";
        int mError;
        private static final String TAG = "CodecCapabilities";
        @Nullable
        private AudioCapabilities mAudioCaps;
        @Nullable
        private VideoCapabilities mVideoCaps;
        @Nullable
        private EncoderCapabilities mEncoderCaps;
        private MediaFormat mDefaultFormat;
        private MediaFormat mCapabilitiesInfo;

        public CodecCapabilities() {
        }

        public boolean isFeatureSupported(String name) {
            return this.checkFeature(name, this.mFlagsSupported);
        }

        public boolean isFeatureRequired(String name) {
            return this.checkFeature(name, this.mFlagsRequired);
        }

        public String[] validFeatures() {
            Feature[] features = this.getValidFeatures();
            ArrayList<String> res = new ArrayList<String>();
            for (int i = 0; i < features.length; ++i) {
                if (features[i].mInternal) continue;
                res.add(features[i].mName);
            }
            return res.toArray(new String[0]);
        }

        private Feature[] getValidFeatures() {
            return FeatureList.getFeatures(this.isEncoder());
        }

        private boolean checkFeature(String name, int flags) {
            for (Feature feat : this.getValidFeatures()) {
                if (!feat.mName.equals(name)) continue;
                return (flags & feat.mValue) != 0;
            }
            return false;
        }

        public boolean isRegular() {
            for (Feature feat : this.getValidFeatures()) {
                if (feat.mDefault || !this.isFeatureRequired(feat.mName)) continue;
                return false;
            }
            return true;
        }

        public boolean isFormatSupported(MediaFormat format) {
            Map<String, Object> map = format.getMap();
            String mime = (String)map.get("mime");
            if (mime != null && !this.mMime.equalsIgnoreCase(mime)) {
                return false;
            }
            for (Feature feat : this.getValidFeatures()) {
                CodecProfileLevel[] yesNo;
                if (feat.mInternal || (yesNo = (CodecProfileLevel[])map.get("feature-" + feat.mName)) == null || (yesNo.intValue() != 1 || this.isFeatureSupported(feat.mName)) && (yesNo.intValue() != 0 || !this.isFeatureRequired(feat.mName))) continue;
                return false;
            }
            Integer profile = (Integer)map.get("profile");
            Integer level = (Integer)map.get("level");
            if (profile != null) {
                Set<String> criticalKeys;
                if (!this.supportsProfileLevel(profile, level)) {
                    return false;
                }
                CodecCapabilities levelCaps = null;
                int maxLevel = 0;
                for (CodecProfileLevel pl : this.profileLevels) {
                    if (pl.profile != profile || pl.level <= maxLevel || this.mMime.equalsIgnoreCase("video/3gpp") && pl.level == 16 && maxLevel != 1) continue;
                    maxLevel = pl.level;
                }
                levelCaps = CodecCapabilities.createFromProfileLevel(this.mMime, profile, maxLevel);
                HashMap<String, Object> levelCriticalFormatMap = new HashMap<String, Object>(map);
                Set<String> set = this.isVideo() ? VideoCapabilities.VIDEO_LEVEL_CRITICAL_FORMAT_KEYS : (criticalKeys = this.isAudio() ? AudioCapabilities.AUDIO_LEVEL_CRITICAL_FORMAT_KEYS : null);
                if (criticalKeys != null && criticalKeys.size() > 1 && levelCaps != null) {
                    levelCriticalFormatMap.keySet().retainAll(criticalKeys);
                    MediaFormat levelCriticalFormat = new MediaFormat(levelCriticalFormatMap);
                    if (!levelCaps.isFormatSupported(levelCriticalFormat)) {
                        return false;
                    }
                }
            }
            if (this.mAudioCaps != null && !this.mAudioCaps.supportsFormat(format)) {
                return false;
            }
            if (this.mVideoCaps != null && !this.mVideoCaps.supportsFormat(format)) {
                return false;
            }
            return this.mEncoderCaps == null || this.mEncoderCaps.supportsFormat(format);
        }

        private static boolean supportsBitrate(Range<Integer> bitrateRange, MediaFormat format) {
            Map<String, Object> map = format.getMap();
            Integer maxBitrate = (Integer)map.get("max-bitrate");
            Integer bitrate = (Integer)map.get("bitrate");
            if (bitrate == null) {
                bitrate = maxBitrate;
            } else if (maxBitrate != null) {
                bitrate = Math.max(bitrate, maxBitrate);
            }
            if (bitrate != null && bitrate > 0) {
                return bitrateRange.contains(bitrate);
            }
            return true;
        }

        private boolean supportsProfileLevel(int profile, Integer level) {
            for (CodecProfileLevel pl : this.profileLevels) {
                if (pl.profile != profile) continue;
                if (level == null) {
                    return true;
                }
                if (this.mMime.equalsIgnoreCase("audio/mp4a-latm")) {
                    return true;
                }
                if (this.mMime.equalsIgnoreCase("audio/vnd.dts") || this.mMime.equalsIgnoreCase("audio/vnd.dts.hd") || this.mMime.equalsIgnoreCase("audio/vnd.dts.uhd")) {
                    return true;
                }
                if (this.mMime.equalsIgnoreCase("video/3gpp") && pl.level != level && pl.level == 16 && level > 1 || this.mMime.equalsIgnoreCase("video/mp4v-es") && pl.level != level && pl.level == 4 && level > 1) continue;
                if (this.mMime.equalsIgnoreCase("video/hevc")) {
                    boolean checkingHighTier;
                    boolean supportsHighTier = (pl.level & 0x2AAAAAA) != 0;
                    boolean bl = checkingHighTier = (level & 0x2AAAAAA) != 0;
                    if (checkingHighTier && !supportsHighTier) continue;
                }
                if (pl.level < level) continue;
                if (CodecCapabilities.createFromProfileLevel(this.mMime, profile, pl.level) != null) {
                    return CodecCapabilities.createFromProfileLevel(this.mMime, profile, level) != null;
                }
                return true;
            }
            return false;
        }

        public MediaFormat getDefaultFormat() {
            return this.mDefaultFormat;
        }

        public String getMimeType() {
            return this.mMime;
        }

        public int getMaxSupportedInstances() {
            return this.mMaxSupportedInstances;
        }

        private boolean isAudio() {
            return this.mAudioCaps != null;
        }

        @Nullable
        public AudioCapabilities getAudioCapabilities() {
            return this.mAudioCaps;
        }

        private boolean isEncoder() {
            return this.mEncoderCaps != null;
        }

        @Nullable
        public EncoderCapabilities getEncoderCapabilities() {
            return this.mEncoderCaps;
        }

        private boolean isVideo() {
            return this.mVideoCaps != null;
        }

        @Nullable
        public VideoCapabilities getVideoCapabilities() {
            return this.mVideoCaps;
        }

        public CodecCapabilities dup() {
            CodecCapabilities caps = new CodecCapabilities();
            caps.profileLevels = Arrays.copyOf(this.profileLevels, this.profileLevels.length);
            caps.colorFormats = Arrays.copyOf(this.colorFormats, this.colorFormats.length);
            caps.mMime = this.mMime;
            caps.mMaxSupportedInstances = this.mMaxSupportedInstances;
            caps.mFlagsRequired = this.mFlagsRequired;
            caps.mFlagsSupported = this.mFlagsSupported;
            caps.mFlagsVerified = this.mFlagsVerified;
            caps.mAudioCaps = this.mAudioCaps;
            caps.mVideoCaps = this.mVideoCaps;
            caps.mEncoderCaps = this.mEncoderCaps;
            caps.mDefaultFormat = this.mDefaultFormat;
            caps.mCapabilitiesInfo = this.mCapabilitiesInfo;
            return caps;
        }

        public static CodecCapabilities createFromProfileLevel(String mime, int profile, int level) {
            CodecProfileLevel pl = new CodecProfileLevel();
            pl.profile = profile;
            pl.level = level;
            MediaFormat defaultFormat = new MediaFormat();
            defaultFormat.setString("mime", mime);
            CodecCapabilities ret = new CodecCapabilities(new CodecProfileLevel[]{pl}, new int[0], true, defaultFormat, new MediaFormat());
            if (ret.mError != 0) {
                return null;
            }
            return ret;
        }

        CodecCapabilities(CodecProfileLevel[] profLevs, int[] colFmts, boolean encoder, Map<String, Object> defaultFormatMap, Map<String, Object> capabilitiesMap) {
            this(profLevs, colFmts, encoder, new MediaFormat(defaultFormatMap), new MediaFormat(capabilitiesMap));
        }

        CodecCapabilities(CodecProfileLevel[] profLevs, int[] colFmts, boolean encoder, MediaFormat defaultFormat, MediaFormat info) {
            Map<String, Object> map = info.getMap();
            this.colorFormats = colFmts;
            this.mFlagsVerified = 0;
            this.mDefaultFormat = defaultFormat;
            this.mCapabilitiesInfo = info;
            this.mMime = this.mDefaultFormat.getString("mime");
            if (profLevs.length == 0 && this.mMime.equalsIgnoreCase("video/x-vnd.on2.vp9")) {
                CodecProfileLevel profLev = new CodecProfileLevel();
                profLev.profile = 1;
                profLev.level = VideoCapabilities.equivalentVP9Level(info);
                profLevs = new CodecProfileLevel[]{profLev};
            }
            this.profileLevels = profLevs;
            if (this.mMime.toLowerCase().startsWith("audio/")) {
                this.mAudioCaps = AudioCapabilities.create(info, this);
                this.mAudioCaps.getDefaultFormat(this.mDefaultFormat);
            } else if (this.mMime.toLowerCase().startsWith("video/") || this.mMime.equalsIgnoreCase("image/vnd.android.heic")) {
                this.mVideoCaps = VideoCapabilities.create(info, this);
            }
            if (encoder) {
                this.mEncoderCaps = EncoderCapabilities.create(info, this);
                this.mEncoderCaps.getDefaultFormat(this.mDefaultFormat);
            }
            Map<String, Object> global = MediaCodecList.getGlobalSettings();
            this.mMaxSupportedInstances = Utils.parseIntSafely(global.get("max-concurrent-instances"), 32);
            int maxInstances = Utils.parseIntSafely(map.get("max-concurrent-instances"), this.mMaxSupportedInstances);
            this.mMaxSupportedInstances = Range.create(1, 256).clamp(maxInstances);
            for (Feature feat : this.getValidFeatures()) {
                String key = "feature-" + feat.mName;
                Integer yesNo = (Integer)map.get(key);
                if (yesNo == null) continue;
                if (yesNo > 0) {
                    this.mFlagsRequired |= feat.mValue;
                }
                this.mFlagsSupported |= feat.mValue;
                if (feat.mInternal) continue;
                this.mDefaultFormat.setInteger(key, 1);
            }
        }

        private static class FeatureList {
            private static Feature[] decoderFeatures = FeatureList.getDecoderFeatures();
            private static Feature[] encoderFeatures = FeatureList.getEncoderFeatures();

            private FeatureList() {
            }

            private static Feature[] getDecoderFeatures() {
                ArrayList<Feature> features = new ArrayList<Feature>();
                features.add(new Feature(CodecCapabilities.FEATURE_AdaptivePlayback, 1, true));
                features.add(new Feature(CodecCapabilities.FEATURE_SecurePlayback, 2, false));
                features.add(new Feature(CodecCapabilities.FEATURE_TunneledPlayback, 4, false));
                features.add(new Feature(CodecCapabilities.FEATURE_PartialFrame, 8, false));
                features.add(new Feature(CodecCapabilities.FEATURE_FrameParsing, 16, false));
                features.add(new Feature(CodecCapabilities.FEATURE_MultipleFrames, 32, false));
                features.add(new Feature(CodecCapabilities.FEATURE_DynamicTimestamp, 64, false));
                features.add(new Feature(CodecCapabilities.FEATURE_LowLatency, 128, true));
                if (MediaCodec.GetFlag(() -> Flags.dynamicColorAspects())) {
                    features.add(new Feature(CodecCapabilities.FEATURE_DynamicColorAspects, 256, true));
                }
                if (MediaCodec.GetFlag(() -> Flags.nullOutputSurface())) {
                    features.add(new Feature(CodecCapabilities.FEATURE_DetachedSurface, 512, true));
                }
                features.add(new Feature(CodecCapabilities.FEATURE_SpecialCodec, 0x40000000, false, true));
                return features.toArray(new Feature[0]);
            }

            private static Feature[] getEncoderFeatures() {
                ArrayList<Feature> features = new ArrayList<Feature>();
                features.add(new Feature(CodecCapabilities.FEATURE_IntraRefresh, 1, false));
                features.add(new Feature(CodecCapabilities.FEATURE_MultipleFrames, 2, false));
                features.add(new Feature(CodecCapabilities.FEATURE_DynamicTimestamp, 4, false));
                features.add(new Feature(CodecCapabilities.FEATURE_QpBounds, 8, false));
                features.add(new Feature(CodecCapabilities.FEATURE_EncodingStatistics, 16, false));
                features.add(new Feature(CodecCapabilities.FEATURE_HdrEditing, 32, false));
                if (MediaCodec.GetFlag(() -> Flags.hlgEditing())) {
                    features.add(new Feature(CodecCapabilities.FEATURE_HlgEditing, 64, true));
                }
                if (MediaCodec.GetFlag(() -> Flags.regionOfInterest())) {
                    features.add(new Feature(CodecCapabilities.FEATURE_Roi, 128, true));
                }
                features.add(new Feature(CodecCapabilities.FEATURE_SpecialCodec, 0x40000000, false, true));
                return features.toArray(new Feature[0]);
            }

            public static Feature[] getFeatures(boolean isEncoder) {
                if (isEncoder) {
                    return encoderFeatures;
                }
                return decoderFeatures;
            }
        }
    }

    public static class CodecProfileLevel {
        public static final int AVCProfileBaseline = 1;
        public static final int AVCProfileMain = 2;
        public static final int AVCProfileExtended = 4;
        public static final int AVCProfileHigh = 8;
        public static final int AVCProfileHigh10 = 16;
        public static final int AVCProfileHigh422 = 32;
        public static final int AVCProfileHigh444 = 64;
        public static final int AVCProfileConstrainedBaseline = 65536;
        public static final int AVCProfileConstrainedHigh = 524288;
        public static final int AVCLevel1 = 1;
        public static final int AVCLevel1b = 2;
        public static final int AVCLevel11 = 4;
        public static final int AVCLevel12 = 8;
        public static final int AVCLevel13 = 16;
        public static final int AVCLevel2 = 32;
        public static final int AVCLevel21 = 64;
        public static final int AVCLevel22 = 128;
        public static final int AVCLevel3 = 256;
        public static final int AVCLevel31 = 512;
        public static final int AVCLevel32 = 1024;
        public static final int AVCLevel4 = 2048;
        public static final int AVCLevel41 = 4096;
        public static final int AVCLevel42 = 8192;
        public static final int AVCLevel5 = 16384;
        public static final int AVCLevel51 = 32768;
        public static final int AVCLevel52 = 65536;
        public static final int AVCLevel6 = 131072;
        public static final int AVCLevel61 = 262144;
        public static final int AVCLevel62 = 524288;
        public static final int H263ProfileBaseline = 1;
        public static final int H263ProfileH320Coding = 2;
        public static final int H263ProfileBackwardCompatible = 4;
        public static final int H263ProfileISWV2 = 8;
        public static final int H263ProfileISWV3 = 16;
        public static final int H263ProfileHighCompression = 32;
        public static final int H263ProfileInternet = 64;
        public static final int H263ProfileInterlace = 128;
        public static final int H263ProfileHighLatency = 256;
        public static final int H263Level10 = 1;
        public static final int H263Level20 = 2;
        public static final int H263Level30 = 4;
        public static final int H263Level40 = 8;
        public static final int H263Level45 = 16;
        public static final int H263Level50 = 32;
        public static final int H263Level60 = 64;
        public static final int H263Level70 = 128;
        public static final int MPEG4ProfileSimple = 1;
        public static final int MPEG4ProfileSimpleScalable = 2;
        public static final int MPEG4ProfileCore = 4;
        public static final int MPEG4ProfileMain = 8;
        public static final int MPEG4ProfileNbit = 16;
        public static final int MPEG4ProfileScalableTexture = 32;
        public static final int MPEG4ProfileSimpleFace = 64;
        public static final int MPEG4ProfileSimpleFBA = 128;
        public static final int MPEG4ProfileBasicAnimated = 256;
        public static final int MPEG4ProfileHybrid = 512;
        public static final int MPEG4ProfileAdvancedRealTime = 1024;
        public static final int MPEG4ProfileCoreScalable = 2048;
        public static final int MPEG4ProfileAdvancedCoding = 4096;
        public static final int MPEG4ProfileAdvancedCore = 8192;
        public static final int MPEG4ProfileAdvancedScalable = 16384;
        public static final int MPEG4ProfileAdvancedSimple = 32768;
        public static final int MPEG4Level0 = 1;
        public static final int MPEG4Level0b = 2;
        public static final int MPEG4Level1 = 4;
        public static final int MPEG4Level2 = 8;
        public static final int MPEG4Level3 = 16;
        public static final int MPEG4Level3b = 24;
        public static final int MPEG4Level4 = 32;
        public static final int MPEG4Level4a = 64;
        public static final int MPEG4Level5 = 128;
        public static final int MPEG4Level6 = 256;
        public static final int MPEG2ProfileSimple = 0;
        public static final int MPEG2ProfileMain = 1;
        public static final int MPEG2Profile422 = 2;
        public static final int MPEG2ProfileSNR = 3;
        public static final int MPEG2ProfileSpatial = 4;
        public static final int MPEG2ProfileHigh = 5;
        public static final int MPEG2LevelLL = 0;
        public static final int MPEG2LevelML = 1;
        public static final int MPEG2LevelH14 = 2;
        public static final int MPEG2LevelHL = 3;
        public static final int MPEG2LevelHP = 4;
        public static final int AACObjectMain = 1;
        public static final int AACObjectLC = 2;
        public static final int AACObjectSSR = 3;
        public static final int AACObjectLTP = 4;
        public static final int AACObjectHE = 5;
        public static final int AACObjectScalable = 6;
        public static final int AACObjectERLC = 17;
        public static final int AACObjectERScalable = 20;
        public static final int AACObjectLD = 23;
        public static final int AACObjectHE_PS = 29;
        public static final int AACObjectELD = 39;
        public static final int AACObjectXHE = 42;
        public static final int VP8Level_Version0 = 1;
        public static final int VP8Level_Version1 = 2;
        public static final int VP8Level_Version2 = 4;
        public static final int VP8Level_Version3 = 8;
        public static final int VP8ProfileMain = 1;
        public static final int VP9Profile0 = 1;
        public static final int VP9Profile1 = 2;
        public static final int VP9Profile2 = 4;
        public static final int VP9Profile3 = 8;
        public static final int VP9Profile2HDR = 4096;
        public static final int VP9Profile3HDR = 8192;
        public static final int VP9Profile2HDR10Plus = 16384;
        public static final int VP9Profile3HDR10Plus = 32768;
        public static final int VP9Level1 = 1;
        public static final int VP9Level11 = 2;
        public static final int VP9Level2 = 4;
        public static final int VP9Level21 = 8;
        public static final int VP9Level3 = 16;
        public static final int VP9Level31 = 32;
        public static final int VP9Level4 = 64;
        public static final int VP9Level41 = 128;
        public static final int VP9Level5 = 256;
        public static final int VP9Level51 = 512;
        public static final int VP9Level52 = 1024;
        public static final int VP9Level6 = 2048;
        public static final int VP9Level61 = 4096;
        public static final int VP9Level62 = 8192;
        public static final int HEVCProfileMain = 1;
        public static final int HEVCProfileMain10 = 2;
        public static final int HEVCProfileMainStill = 4;
        public static final int HEVCProfileMain10HDR10 = 4096;
        public static final int HEVCProfileMain10HDR10Plus = 8192;
        public static final int HEVCMainTierLevel1 = 1;
        public static final int HEVCHighTierLevel1 = 2;
        public static final int HEVCMainTierLevel2 = 4;
        public static final int HEVCHighTierLevel2 = 8;
        public static final int HEVCMainTierLevel21 = 16;
        public static final int HEVCHighTierLevel21 = 32;
        public static final int HEVCMainTierLevel3 = 64;
        public static final int HEVCHighTierLevel3 = 128;
        public static final int HEVCMainTierLevel31 = 256;
        public static final int HEVCHighTierLevel31 = 512;
        public static final int HEVCMainTierLevel4 = 1024;
        public static final int HEVCHighTierLevel4 = 2048;
        public static final int HEVCMainTierLevel41 = 4096;
        public static final int HEVCHighTierLevel41 = 8192;
        public static final int HEVCMainTierLevel5 = 16384;
        public static final int HEVCHighTierLevel5 = 32768;
        public static final int HEVCMainTierLevel51 = 65536;
        public static final int HEVCHighTierLevel51 = 131072;
        public static final int HEVCMainTierLevel52 = 262144;
        public static final int HEVCHighTierLevel52 = 524288;
        public static final int HEVCMainTierLevel6 = 0x100000;
        public static final int HEVCHighTierLevel6 = 0x200000;
        public static final int HEVCMainTierLevel61 = 0x400000;
        public static final int HEVCHighTierLevel61 = 0x800000;
        public static final int HEVCMainTierLevel62 = 0x1000000;
        public static final int HEVCHighTierLevel62 = 0x2000000;
        private static final int HEVCHighTierLevels = 0x2AAAAAA;
        public static final int DolbyVisionProfileDvavPer = 1;
        public static final int DolbyVisionProfileDvavPen = 2;
        public static final int DolbyVisionProfileDvheDer = 4;
        public static final int DolbyVisionProfileDvheDen = 8;
        public static final int DolbyVisionProfileDvheDtr = 16;
        public static final int DolbyVisionProfileDvheStn = 32;
        public static final int DolbyVisionProfileDvheDth = 64;
        public static final int DolbyVisionProfileDvheDtb = 128;
        public static final int DolbyVisionProfileDvheSt = 256;
        public static final int DolbyVisionProfileDvavSe = 512;
        @SuppressLint(value={"AllUpper"})
        public static final int DolbyVisionProfileDvav110 = 1024;
        public static final int DolbyVisionLevelHd24 = 1;
        public static final int DolbyVisionLevelHd30 = 2;
        public static final int DolbyVisionLevelFhd24 = 4;
        public static final int DolbyVisionLevelFhd30 = 8;
        public static final int DolbyVisionLevelFhd60 = 16;
        public static final int DolbyVisionLevelUhd24 = 32;
        public static final int DolbyVisionLevelUhd30 = 64;
        public static final int DolbyVisionLevelUhd48 = 128;
        public static final int DolbyVisionLevelUhd60 = 256;
        @SuppressLint(value={"AllUpper"})
        public static final int DolbyVisionLevelUhd120 = 512;
        @SuppressLint(value={"AllUpper"})
        public static final int DolbyVisionLevel8k30 = 1024;
        @SuppressLint(value={"AllUpper"})
        public static final int DolbyVisionLevel8k60 = 2048;
        public static final int AV1ProfileMain8 = 1;
        public static final int AV1ProfileMain10 = 2;
        public static final int AV1ProfileMain10HDR10 = 4096;
        public static final int AV1ProfileMain10HDR10Plus = 8192;
        public static final int AV1Level2 = 1;
        public static final int AV1Level21 = 2;
        public static final int AV1Level22 = 4;
        public static final int AV1Level23 = 8;
        public static final int AV1Level3 = 16;
        public static final int AV1Level31 = 32;
        public static final int AV1Level32 = 64;
        public static final int AV1Level33 = 128;
        public static final int AV1Level4 = 256;
        public static final int AV1Level41 = 512;
        public static final int AV1Level42 = 1024;
        public static final int AV1Level43 = 2048;
        public static final int AV1Level5 = 4096;
        public static final int AV1Level51 = 8192;
        public static final int AV1Level52 = 16384;
        public static final int AV1Level53 = 32768;
        public static final int AV1Level6 = 65536;
        public static final int AV1Level61 = 131072;
        public static final int AV1Level62 = 262144;
        public static final int AV1Level63 = 524288;
        public static final int AV1Level7 = 0x100000;
        public static final int AV1Level71 = 0x200000;
        public static final int AV1Level72 = 0x400000;
        public static final int AV1Level73 = 0x800000;
        @SuppressLint(value={"AllUpper"})
        public static final int DTS_HDProfileHRA = 1;
        @SuppressLint(value={"AllUpper"})
        public static final int DTS_HDProfileLBR = 2;
        @SuppressLint(value={"AllUpper"})
        public static final int DTS_HDProfileMA = 4;
        @SuppressLint(value={"AllUpper"})
        public static final int DTS_UHDProfileP1 = 1;
        @SuppressLint(value={"AllUpper"})
        public static final int DTS_UHDProfileP2 = 2;
        @SuppressLint(value={"AllUpper"})
        private static final int AC4BitstreamVersion0 = 1;
        @SuppressLint(value={"AllUpper"})
        private static final int AC4BitstreamVersion1 = 2;
        @SuppressLint(value={"AllUpper"})
        private static final int AC4BitstreamVersion2 = 4;
        @SuppressLint(value={"AllUpper"})
        private static final int AC4PresentationVersion0 = 1;
        @SuppressLint(value={"AllUpper"})
        private static final int AC4PresentationVersion1 = 2;
        @SuppressLint(value={"AllUpper"})
        private static final int AC4PresentationVersion2 = 4;
        @SuppressLint(value={"AllUpper"})
        public static final int AC4Profile00 = 257;
        @SuppressLint(value={"AllUpper"})
        public static final int AC4Profile10 = 513;
        @SuppressLint(value={"AllUpper"})
        public static final int AC4Profile11 = 514;
        @SuppressLint(value={"AllUpper"})
        public static final int AC4Profile21 = 1026;
        @SuppressLint(value={"AllUpper"})
        public static final int AC4Profile22 = 1028;
        @SuppressLint(value={"AllUpper"})
        public static final int AC4Level0 = 1;
        @SuppressLint(value={"AllUpper"})
        public static final int AC4Level1 = 2;
        @SuppressLint(value={"AllUpper"})
        public static final int AC4Level2 = 4;
        @SuppressLint(value={"AllUpper"})
        public static final int AC4Level3 = 8;
        @SuppressLint(value={"AllUpper"})
        public static final int AC4Level4 = 16;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVProfile422_10 = 1;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVProfile422_10HDR10 = 4096;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVProfile422_10HDR10Plus = 8192;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel1Band0 = 257;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel1Band1 = 258;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel1Band2 = 260;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel1Band3 = 264;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel11Band0 = 513;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel11Band1 = 514;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel11Band2 = 516;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel11Band3 = 520;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel2Band0 = 1025;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel2Band1 = 1026;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel2Band2 = 1028;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel2Band3 = 1032;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel21Band0 = 2049;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel21Band1 = 2050;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel21Band2 = 2052;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel21Band3 = 2056;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel3Band0 = 4097;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel3Band1 = 4098;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel3Band2 = 4100;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel3Band3 = 4104;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel31Band0 = 8193;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel31Band1 = 8194;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel31Band2 = 8196;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel31Band3 = 8200;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel4Band0 = 16385;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel4Band1 = 16386;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel4Band2 = 16388;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel4Band3 = 16392;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel41Band0 = 32769;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel41Band1 = 32770;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel41Band2 = 32772;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel41Band3 = 32776;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel5Band0 = 65537;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel5Band1 = 65538;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel5Band2 = 65540;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel5Band3 = 65544;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel51Band0 = 131073;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel51Band1 = 131074;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel51Band2 = 131076;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel51Band3 = 131080;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel6Band0 = 262145;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel6Band1 = 262146;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel6Band2 = 262148;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel6Band3 = 262152;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel61Band0 = 524289;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel61Band1 = 524290;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel61Band2 = 524292;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel61Band3 = 524296;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel7Band0 = 0x100001;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel7Band1 = 0x100002;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel7Band2 = 0x100004;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel7Band3 = 0x100008;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel71Band0 = 0x200001;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel71Band1 = 0x200002;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel71Band2 = 0x200004;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.codec.apv_support")
        public static final int APVLevel71Band3 = 0x200008;
        private static final int IAMF_CODEC_OPUS = 1;
        private static final int IAMF_CODEC_AAC = 2;
        private static final int IAMF_CODEC_FLAC = 4;
        private static final int IAMF_CODEC_PCM = 8;
        private static final int IAMF_PROFILE_SIMPLE = 65536;
        private static final int IAMF_PROFILE_BASE = 131072;
        private static final int IAMF_PROFILE_BASE_ENHANCED = 262144;
        private static final int IAMF_v1 = 0x1000000;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.audio.iamf_definitions_api")
        public static final int IAMFProfileSimpleOpus = 0x1010001;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.audio.iamf_definitions_api")
        public static final int IAMFProfileSimpleAac = 0x1010002;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.audio.iamf_definitions_api")
        public static final int IAMFProfileSimpleFlac = 0x1010004;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.audio.iamf_definitions_api")
        public static final int IAMFProfileSimplePcm = 0x1010008;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.audio.iamf_definitions_api")
        public static final int IAMFProfileBaseOpus = 0x1020001;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.audio.iamf_definitions_api")
        public static final int IAMFProfileBaseAac = 0x1020002;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.audio.iamf_definitions_api")
        public static final int IAMFProfileBaseFlac = 16908292;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.audio.iamf_definitions_api")
        public static final int IAMFProfileBasePcm = 16908296;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.audio.iamf_definitions_api")
        public static final int IAMFProfileBaseEnhancedOpus = 0x1040001;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.audio.iamf_definitions_api")
        public static final int IAMFProfileBaseEnhancedAac = 17039362;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.audio.iamf_definitions_api")
        public static final int IAMFProfileBaseEnhancedFlac = 0x1040004;
        @SuppressLint(value={"AllUpper"})
        @FlaggedApi(value="android.media.audio.iamf_definitions_api")
        public static final int IAMFProfileBaseEnhancedPcm = 17039368;
        public int profile;
        public int level;

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof CodecProfileLevel) {
                CodecProfileLevel other = (CodecProfileLevel)obj;
                return other.profile == this.profile && other.level == this.level;
            }
            return false;
        }

        public int hashCode() {
            return Long.hashCode((long)this.profile << 32 | (long)this.level);
        }
    }

    public static class EncoderCapabilities {
        public static final int BITRATE_MODE_CQ = 0;
        public static final int BITRATE_MODE_VBR = 1;
        public static final int BITRATE_MODE_CBR = 2;
        public static final int BITRATE_MODE_CBR_FD = 3;
        private static final Feature[] bitrates = new Feature[]{new Feature("VBR", 1, true), new Feature("CBR", 2, false), new Feature("CQ", 0, false), new Feature("CBR-FD", 3, false)};
        private Range<Integer> mQualityRange;
        private Range<Integer> mComplexityRange;
        private CodecCapabilities mParent;
        private int mBitControl;
        private Integer mDefaultComplexity;
        private Integer mDefaultQuality;
        private String mQualityScale;

        public Range<Integer> getQualityRange() {
            return this.mQualityRange;
        }

        public Range<Integer> getComplexityRange() {
            return this.mComplexityRange;
        }

        private static int parseBitrateMode(String mode) {
            for (Feature feat : bitrates) {
                if (!feat.mName.equalsIgnoreCase(mode)) continue;
                return feat.mValue;
            }
            return 0;
        }

        public boolean isBitrateModeSupported(int mode) {
            for (Feature feat : bitrates) {
                if (mode != feat.mValue) continue;
                return (this.mBitControl & 1 << mode) != 0;
            }
            return false;
        }

        private EncoderCapabilities() {
        }

        public static EncoderCapabilities create(MediaFormat info, CodecCapabilities parent) {
            EncoderCapabilities caps = new EncoderCapabilities();
            caps.init(info, parent);
            return caps;
        }

        private void init(MediaFormat info, CodecCapabilities parent) {
            this.mParent = parent;
            this.mComplexityRange = Range.create(0, 0);
            this.mQualityRange = Range.create(0, 0);
            this.mBitControl = 2;
            this.applyLevelLimits();
            this.parseFromInfo(info);
        }

        private void applyLevelLimits() {
            String mime = this.mParent.getMimeType();
            if (mime.equalsIgnoreCase("audio/flac")) {
                this.mComplexityRange = Range.create(0, 8);
                this.mBitControl = 1;
            } else if (mime.equalsIgnoreCase("audio/3gpp") || mime.equalsIgnoreCase("audio/amr-wb") || mime.equalsIgnoreCase("audio/g711-alaw") || mime.equalsIgnoreCase("audio/g711-mlaw") || mime.equalsIgnoreCase("audio/gsm")) {
                this.mBitControl = 4;
            }
        }

        private void parseFromInfo(MediaFormat info) {
            Map<String, Object> map = info.getMap();
            if (info.containsKey("complexity-range")) {
                this.mComplexityRange = Utils.parseIntRange(info.getString("complexity-range"), this.mComplexityRange);
            }
            if (info.containsKey("quality-range")) {
                this.mQualityRange = Utils.parseIntRange(info.getString("quality-range"), this.mQualityRange);
            }
            if (info.containsKey("feature-bitrate-modes")) {
                this.mBitControl = 0;
                for (String mode : info.getString("feature-bitrate-modes").split(",")) {
                    this.mBitControl |= 1 << EncoderCapabilities.parseBitrateMode(mode);
                }
            }
            try {
                this.mDefaultComplexity = Integer.parseInt((String)map.get("complexity-default"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                this.mDefaultQuality = Integer.parseInt((String)map.get("quality-default"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.mQualityScale = (String)map.get("quality-scale");
        }

        private boolean supports(Integer complexity, Integer quality, Integer profile) {
            boolean ok = true;
            if (ok && complexity != null) {
                ok = this.mComplexityRange.contains(complexity);
            }
            if (ok && quality != null) {
                ok = this.mQualityRange.contains(quality);
            }
            if (ok && profile != null) {
                for (CodecProfileLevel pl : this.mParent.profileLevels) {
                    if (pl.profile != profile) continue;
                    profile = null;
                    break;
                }
                ok = profile == null;
            }
            return ok;
        }

        public void getDefaultFormat(MediaFormat format) {
            if (!((Object)this.mQualityRange.getUpper()).equals(this.mQualityRange.getLower()) && this.mDefaultQuality != null) {
                format.setInteger("quality", this.mDefaultQuality);
            }
            if (!((Object)this.mComplexityRange.getUpper()).equals(this.mComplexityRange.getLower()) && this.mDefaultComplexity != null) {
                format.setInteger("complexity", this.mDefaultComplexity);
            }
            for (Feature feat : bitrates) {
                if ((this.mBitControl & 1 << feat.mValue) == 0) continue;
                format.setInteger("bitrate-mode", feat.mValue);
                break;
            }
        }

        public boolean supportsFormat(MediaFormat format) {
            Map<String, Object> map = format.getMap();
            String mime = this.mParent.getMimeType();
            Integer mode = (Integer)map.get("bitrate-mode");
            if (mode != null && !this.isBitrateModeSupported(mode)) {
                return false;
            }
            Integer complexity = (Integer)map.get("complexity");
            if ("audio/flac".equalsIgnoreCase(mime)) {
                Integer flacComplexity = (Integer)map.get("flac-compression-level");
                if (complexity == null) {
                    complexity = flacComplexity;
                } else if (flacComplexity != null && !((Object)complexity).equals(flacComplexity)) {
                    throw new IllegalArgumentException("conflicting values for complexity and flac-compression-level");
                }
            }
            Integer profile = (Integer)map.get("profile");
            if ("audio/mp4a-latm".equalsIgnoreCase(mime)) {
                Integer aacProfile = (Integer)map.get("aac-profile");
                if (profile == null) {
                    profile = aacProfile;
                } else if (aacProfile != null && !((Object)aacProfile).equals(profile)) {
                    throw new IllegalArgumentException("conflicting values for profile and aac-profile");
                }
            }
            Integer quality = (Integer)map.get("quality");
            return this.supports(complexity, quality, profile);
        }
    }

    public static class VideoCapabilities {
        private static final String TAG = "VideoCapabilities";
        private CodecCapabilities mParent;
        private Range<Integer> mBitrateRange;
        private Range<Integer> mHeightRange;
        private Range<Integer> mWidthRange;
        private Range<Integer> mBlockCountRange;
        private Range<Integer> mHorizontalBlockRange;
        private Range<Integer> mVerticalBlockRange;
        private Range<Rational> mAspectRatioRange;
        private Range<Rational> mBlockAspectRatioRange;
        private Range<Long> mBlocksPerSecondRange;
        private Map<Size, Range<Long>> mMeasuredFrameRates;
        private List<PerformancePoint> mPerformancePoints;
        private Range<Integer> mFrameRateRange;
        private int mBlockWidth;
        private int mBlockHeight;
        private int mWidthAlignment;
        private int mHeightAlignment;
        private int mSmallerDimensionUpperLimit;
        private boolean mAllowMbOverride;
        static final Set<String> VIDEO_LEVEL_CRITICAL_FORMAT_KEYS = Set.of("width", "height", "frame-rate", "bitrate", "mime");

        public Range<Integer> getBitrateRange() {
            return this.mBitrateRange;
        }

        public Range<Integer> getSupportedWidths() {
            return this.mWidthRange;
        }

        public Range<Integer> getSupportedHeights() {
            return this.mHeightRange;
        }

        public int getWidthAlignment() {
            return this.mWidthAlignment;
        }

        public int getHeightAlignment() {
            return this.mHeightAlignment;
        }

        public int getSmallerDimensionUpperLimit() {
            return this.mSmallerDimensionUpperLimit;
        }

        public Range<Integer> getSupportedFrameRates() {
            return this.mFrameRateRange;
        }

        public Range<Integer> getSupportedWidthsFor(int height) {
            try {
                Range<Integer> range = this.mWidthRange;
                if (!this.mHeightRange.contains(height) || height % this.mHeightAlignment != 0) {
                    throw new IllegalArgumentException("unsupported height");
                }
                int heightInBlocks = Utils.divUp(height, this.mBlockHeight);
                int minWidthInBlocks = Math.max(Utils.divUp(this.mBlockCountRange.getLower(), heightInBlocks), (int)Math.ceil(this.mBlockAspectRatioRange.getLower().doubleValue() * (double)heightInBlocks));
                int maxWidthInBlocks = Math.min(this.mBlockCountRange.getUpper() / heightInBlocks, (int)(this.mBlockAspectRatioRange.getUpper().doubleValue() * (double)heightInBlocks));
                range = range.intersect((minWidthInBlocks - 1) * this.mBlockWidth + this.mWidthAlignment, maxWidthInBlocks * this.mBlockWidth);
                if (height > this.mSmallerDimensionUpperLimit) {
                    range = range.intersect(1, this.mSmallerDimensionUpperLimit);
                }
                range = range.intersect((int)Math.ceil(this.mAspectRatioRange.getLower().doubleValue() * (double)height), (int)(this.mAspectRatioRange.getUpper().doubleValue() * (double)height));
                return range;
            }
            catch (IllegalArgumentException e) {
                Log.v(TAG, "could not get supported widths for " + height);
                throw new IllegalArgumentException("unsupported height");
            }
        }

        public Range<Integer> getSupportedHeightsFor(int width) {
            try {
                Range<Integer> range = this.mHeightRange;
                if (!this.mWidthRange.contains(width) || width % this.mWidthAlignment != 0) {
                    throw new IllegalArgumentException("unsupported width");
                }
                int widthInBlocks = Utils.divUp(width, this.mBlockWidth);
                int minHeightInBlocks = Math.max(Utils.divUp(this.mBlockCountRange.getLower(), widthInBlocks), (int)Math.ceil((double)widthInBlocks / this.mBlockAspectRatioRange.getUpper().doubleValue()));
                int maxHeightInBlocks = Math.min(this.mBlockCountRange.getUpper() / widthInBlocks, (int)((double)widthInBlocks / this.mBlockAspectRatioRange.getLower().doubleValue()));
                range = range.intersect((minHeightInBlocks - 1) * this.mBlockHeight + this.mHeightAlignment, maxHeightInBlocks * this.mBlockHeight);
                if (width > this.mSmallerDimensionUpperLimit) {
                    range = range.intersect(1, this.mSmallerDimensionUpperLimit);
                }
                range = range.intersect((int)Math.ceil((double)width / this.mAspectRatioRange.getUpper().doubleValue()), (int)((double)width / this.mAspectRatioRange.getLower().doubleValue()));
                return range;
            }
            catch (IllegalArgumentException e) {
                Log.v(TAG, "could not get supported heights for " + width);
                throw new IllegalArgumentException("unsupported width");
            }
        }

        public Range<Double> getSupportedFrameRatesFor(int width, int height) {
            Range<Integer> range = this.mHeightRange;
            if (!this.supports(width, height, null)) {
                throw new IllegalArgumentException("unsupported size");
            }
            int blockCount = Utils.divUp(width, this.mBlockWidth) * Utils.divUp(height, this.mBlockHeight);
            return Range.create(Math.max((double)this.mBlocksPerSecondRange.getLower().longValue() / (double)blockCount, (double)this.mFrameRateRange.getLower().intValue()), Math.min((double)this.mBlocksPerSecondRange.getUpper().longValue() / (double)blockCount, (double)this.mFrameRateRange.getUpper().intValue()));
        }

        private int getBlockCount(int width, int height) {
            return Utils.divUp(width, this.mBlockWidth) * Utils.divUp(height, this.mBlockHeight);
        }

        @NonNull
        private Size findClosestSize(int width, int height) {
            int targetBlockCount = this.getBlockCount(width, height);
            Size closestSize = null;
            int minDiff = Integer.MAX_VALUE;
            for (Size size : this.mMeasuredFrameRates.keySet()) {
                int diff = Math.abs(targetBlockCount - this.getBlockCount(size.getWidth(), size.getHeight()));
                if (diff >= minDiff) continue;
                minDiff = diff;
                closestSize = size;
            }
            return closestSize;
        }

        private Range<Double> estimateFrameRatesFor(int width, int height) {
            Size size = this.findClosestSize(width, height);
            Range<Long> range = this.mMeasuredFrameRates.get(size);
            Double ratio = (double)this.getBlockCount(size.getWidth(), size.getHeight()) / (double)Math.max(this.getBlockCount(width, height), 1);
            return Range.create((double)range.getLower().longValue() * ratio, (double)range.getUpper().longValue() * ratio);
        }

        @Nullable
        public Range<Double> getAchievableFrameRatesFor(int width, int height) {
            if (!this.supports(width, height, null)) {
                throw new IllegalArgumentException("unsupported size");
            }
            if (this.mMeasuredFrameRates == null || this.mMeasuredFrameRates.size() <= 0) {
                Log.w(TAG, "Codec did not publish any measurement data.");
                return null;
            }
            return this.estimateFrameRatesFor(width, height);
        }

        @Nullable
        public List<PerformancePoint> getSupportedPerformancePoints() {
            return this.mPerformancePoints;
        }

        public boolean areSizeAndRateSupported(int width, int height, double frameRate) {
            return this.supports(width, height, frameRate);
        }

        public boolean isSizeSupported(int width, int height) {
            return this.supports(width, height, null);
        }

        private boolean supports(Integer width, Integer height, Number rate) {
            boolean ok = true;
            if (ok && width != null) {
                boolean bl = ok = this.mWidthRange.contains(width) && width % this.mWidthAlignment == 0;
            }
            if (ok && height != null) {
                boolean bl = ok = this.mHeightRange.contains(height) && height % this.mHeightAlignment == 0;
            }
            if (ok && rate != null) {
                ok = this.mFrameRateRange.contains(Utils.intRangeFor(rate.doubleValue()));
            }
            if (ok && height != null && width != null) {
                ok = Math.min(height, width) <= this.mSmallerDimensionUpperLimit;
                int widthInBlocks = Utils.divUp(width, this.mBlockWidth);
                int heightInBlocks = Utils.divUp(height, this.mBlockHeight);
                int blockCount = widthInBlocks * heightInBlocks;
                boolean bl = ok = ok && this.mBlockCountRange.contains(blockCount) && this.mBlockAspectRatioRange.contains(new Rational(widthInBlocks, heightInBlocks)) && this.mAspectRatioRange.contains(new Rational(width, height));
                if (ok && rate != null) {
                    double blocksPerSec = (double)blockCount * rate.doubleValue();
                    ok = this.mBlocksPerSecondRange.contains(Utils.longRangeFor(blocksPerSec));
                }
            }
            return ok;
        }

        public boolean supportsFormat(MediaFormat format) {
            Number rate;
            Integer height;
            Map<String, Object> map = format.getMap();
            Integer width = (Integer)map.get("width");
            if (!this.supports(width, height = (Integer)map.get("height"), rate = (Number)map.get("frame-rate"))) {
                return false;
            }
            return CodecCapabilities.supportsBitrate(this.mBitrateRange, format);
        }

        private VideoCapabilities() {
        }

        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
        public static VideoCapabilities create(MediaFormat info, CodecCapabilities parent) {
            VideoCapabilities caps = new VideoCapabilities();
            caps.init(info, parent);
            return caps;
        }

        private void init(MediaFormat info, CodecCapabilities parent) {
            this.mParent = parent;
            this.initWithPlatformLimits();
            this.applyLevelLimits();
            this.parseFromInfo(info);
            this.updateLimits();
        }

        public Size getBlockSize() {
            return new Size(this.mBlockWidth, this.mBlockHeight);
        }

        public Range<Integer> getBlockCountRange() {
            return this.mBlockCountRange;
        }

        public Range<Long> getBlocksPerSecondRange() {
            return this.mBlocksPerSecondRange;
        }

        public Range<Rational> getAspectRatioRange(boolean blocks) {
            return blocks ? this.mBlockAspectRatioRange : this.mAspectRatioRange;
        }

        private void initWithPlatformLimits() {
            this.mBitrateRange = BITRATE_RANGE;
            this.mWidthRange = MediaCodecInfo.getSizeRange();
            this.mHeightRange = MediaCodecInfo.getSizeRange();
            this.mFrameRateRange = FRAME_RATE_RANGE;
            this.mHorizontalBlockRange = MediaCodecInfo.getSizeRange();
            this.mVerticalBlockRange = MediaCodecInfo.getSizeRange();
            this.mBlockCountRange = POSITIVE_INTEGERS;
            this.mBlocksPerSecondRange = POSITIVE_LONGS;
            this.mBlockAspectRatioRange = POSITIVE_RATIONALS;
            this.mAspectRatioRange = POSITIVE_RATIONALS;
            this.mWidthAlignment = 1;
            this.mHeightAlignment = 1;
            this.mBlockWidth = 1;
            this.mBlockHeight = 1;
            this.mSmallerDimensionUpperLimit = MediaCodecInfo.getSizeRange().getUpper();
        }

        @Nullable
        private List<PerformancePoint> getPerformancePoints(Map<String, Object> map) {
            Vector<PerformancePoint> ret = new Vector<PerformancePoint>();
            String prefix = "performance-point-";
            Set<String> keys = map.keySet();
            for (String key : keys) {
                Range<Long> range;
                String sizeStr;
                Size size;
                if (!key.startsWith("performance-point-")) continue;
                String subKey = key.substring("performance-point-".length());
                if (subKey.equals("none") && ret.size() == 0) {
                    return Collections.unmodifiableList(ret);
                }
                String[] temp = key.split("-");
                if (temp.length != 4 || (size = Utils.parseSize(sizeStr = temp[2], null)) == null || size.getWidth() * size.getHeight() <= 0 || (range = Utils.parseLongRange(map.get(key), null)) == null || range.getLower() < 0L || range.getUpper() < 0L) continue;
                PerformancePoint given = new PerformancePoint(size.getWidth(), size.getHeight(), range.getLower().intValue(), range.getUpper().intValue(), new Size(this.mBlockWidth, this.mBlockHeight));
                PerformancePoint rotated = new PerformancePoint(size.getHeight(), size.getWidth(), range.getLower().intValue(), range.getUpper().intValue(), new Size(this.mBlockWidth, this.mBlockHeight));
                ret.add(given);
                if (given.covers(rotated)) continue;
                ret.add(rotated);
            }
            if (ret.size() == 0) {
                return null;
            }
            ret.sort((a, b) -> -(a.getMaxMacroBlocks() != b.getMaxMacroBlocks() ? (a.getMaxMacroBlocks() < b.getMaxMacroBlocks() ? -1 : 1) : (a.getMaxMacroBlockRate() != b.getMaxMacroBlockRate() ? (a.getMaxMacroBlockRate() < b.getMaxMacroBlockRate() ? -1 : 1) : (a.getMaxFrameRate() != b.getMaxFrameRate() ? (a.getMaxFrameRate() < b.getMaxFrameRate() ? -1 : 1) : 0))));
            return Collections.unmodifiableList(ret);
        }

        private Map<Size, Range<Long>> getMeasuredFrameRates(Map<String, Object> map) {
            HashMap<Size, Range<Long>> ret = new HashMap<Size, Range<Long>>();
            String prefix = "measured-frame-rate-";
            Set<String> keys = map.keySet();
            for (String key : keys) {
                Range<Long> range;
                String sizeStr;
                Size size;
                if (!key.startsWith("measured-frame-rate-")) continue;
                String subKey = key.substring("measured-frame-rate-".length());
                String[] temp = key.split("-");
                if (temp.length != 5 || (size = Utils.parseSize(sizeStr = temp[3], null)) == null || size.getWidth() * size.getHeight() <= 0 || (range = Utils.parseLongRange(map.get(key), null)) == null || range.getLower() < 0L || range.getUpper() < 0L) continue;
                ret.put(size, range);
            }
            return ret;
        }

        private static Pair<Range<Integer>, Range<Integer>> parseWidthHeightRanges(Object o) {
            Pair<Size, Size> range = Utils.parseSizeRange(o);
            if (range != null) {
                try {
                    return Pair.create(Range.create(((Size)range.first).getWidth(), ((Size)range.second).getWidth()), Range.create(((Size)range.first).getHeight(), ((Size)range.second).getHeight()));
                }
                catch (IllegalArgumentException e) {
                    Log.w(TAG, "could not parse size range '" + o + "'");
                }
            }
            return null;
        }

        public static int equivalentVP9Level(MediaFormat info) {
            int BR;
            Map<String, Object> map = info.getMap();
            Size blockSize = Utils.parseSize(map.get("block-size"), new Size(8, 8));
            int BS = blockSize.getWidth() * blockSize.getHeight();
            Range<Integer> counts = Utils.parseIntRange(map.get("block-count-range"), null);
            int FS = counts == null ? 0 : BS * counts.getUpper();
            Range<Long> blockRates = Utils.parseLongRange(map.get("blocks-per-second-range"), null);
            long SR = blockRates == null ? 0L : (long)BS * blockRates.getUpper();
            Pair<Range<Integer>, Range<Integer>> dimensionRanges = VideoCapabilities.parseWidthHeightRanges(map.get("size-range"));
            int D = dimensionRanges == null ? 0 : Math.max((Integer)((Range)dimensionRanges.first).getUpper(), (Integer)((Range)dimensionRanges.second).getUpper());
            Range<Integer> bitRates = Utils.parseIntRange(map.get("bitrate-range"), null);
            int n = BR = bitRates == null ? 0 : Utils.divUp(bitRates.getUpper(), 1000);
            if (SR <= 829440L && FS <= 36864 && BR <= 200 && D <= 512) {
                return 1;
            }
            if (SR <= 2764800L && FS <= 73728 && BR <= 800 && D <= 768) {
                return 2;
            }
            if (SR <= 4608000L && FS <= 122880 && BR <= 1800 && D <= 960) {
                return 4;
            }
            if (SR <= 9216000L && FS <= 245760 && BR <= 3600 && D <= 1344) {
                return 8;
            }
            if (SR <= 20736000L && FS <= 552960 && BR <= 7200 && D <= 2048) {
                return 16;
            }
            if (SR <= 36864000L && FS <= 983040 && BR <= 12000 && D <= 2752) {
                return 32;
            }
            if (SR <= 83558400L && FS <= 0x220000 && BR <= 18000 && D <= 4160) {
                return 64;
            }
            if (SR <= 0x9900000L && FS <= 0x220000 && BR <= 30000 && D <= 4160) {
                return 128;
            }
            if (SR <= 311951360L && FS <= 0x880000 && BR <= 60000 && D <= 8384) {
                return 256;
            }
            if (SR <= 588251136L && FS <= 0x880000 && BR <= 120000 && D <= 8384) {
                return 512;
            }
            if (SR <= 1176502272L && FS <= 0x880000 && BR <= 180000 && D <= 8384) {
                return 1024;
            }
            if (SR <= 1176502272L && FS <= 0x2200000 && BR <= 180000 && D <= 16832) {
                return 2048;
            }
            if (SR <= 2353004544L && FS <= 0x2200000 && BR <= 240000 && D <= 16832) {
                return 4096;
            }
            if (SR <= 0x118800000L && FS <= 0x2200000 && BR <= 480000 && D <= 16832) {
                return 8192;
            }
            return 8192;
        }

        private void parseFromInfo(MediaFormat info) {
            Map<String, Object> map = info.getMap();
            Size blockSize = new Size(this.mBlockWidth, this.mBlockHeight);
            Size alignment = new Size(this.mWidthAlignment, this.mHeightAlignment);
            Range<Integer> counts = null;
            Range<Range> widths = null;
            Range<Range> heights = null;
            Range<Integer> frameRates = null;
            Range<Integer> bitRates = null;
            Range<Long> blockRates = null;
            Range<Rational> ratios = null;
            Range<Rational> blockRatios = null;
            blockSize = Utils.parseSize(map.get("block-size"), blockSize);
            alignment = Utils.parseSize(map.get("alignment"), alignment);
            counts = Utils.parseIntRange(map.get("block-count-range"), null);
            blockRates = Utils.parseLongRange(map.get("blocks-per-second-range"), null);
            this.mMeasuredFrameRates = this.getMeasuredFrameRates(map);
            this.mPerformancePoints = this.getPerformancePoints(map);
            Pair<Range<Integer>, Range<Integer>> sizeRanges = VideoCapabilities.parseWidthHeightRanges(map.get("size-range"));
            if (sizeRanges != null) {
                widths = (Range<Range>)sizeRanges.first;
                heights = (Range<Range>)sizeRanges.second;
            }
            if (map.containsKey("feature-can-swap-width-height")) {
                if (widths != null) {
                    this.mSmallerDimensionUpperLimit = Math.min((Integer)widths.getUpper(), (Integer)heights.getUpper());
                    widths = heights = widths.extend((Range)heights);
                } else {
                    Log.w(TAG, "feature can-swap-width-height is best used with size-range");
                    this.mSmallerDimensionUpperLimit = Math.min(this.mWidthRange.getUpper(), this.mHeightRange.getUpper());
                    this.mHeightRange = this.mWidthRange.extend((Integer)((Object)this.mHeightRange));
                    this.mWidthRange = this.mHeightRange;
                }
            }
            ratios = Utils.parseRationalRange(map.get("block-aspect-ratio-range"), null);
            blockRatios = Utils.parseRationalRange(map.get("pixel-aspect-ratio-range"), null);
            frameRates = Utils.parseIntRange(map.get("frame-rate-range"), null);
            if (frameRates != null) {
                try {
                    frameRates = frameRates.intersect(FRAME_RATE_RANGE);
                }
                catch (IllegalArgumentException e) {
                    Log.w(TAG, "frame rate range (" + frameRates + ") is out of limits: " + FRAME_RATE_RANGE);
                    frameRates = null;
                }
            }
            if ((bitRates = Utils.parseIntRange(map.get("bitrate-range"), null)) != null) {
                try {
                    bitRates = bitRates.intersect(BITRATE_RANGE);
                }
                catch (IllegalArgumentException e) {
                    Log.w(TAG, "bitrate range (" + bitRates + ") is out of limits: " + BITRATE_RANGE);
                    bitRates = null;
                }
            }
            MediaCodecInfo.checkPowerOfTwo(blockSize.getWidth(), "block-size width must be power of two");
            MediaCodecInfo.checkPowerOfTwo(blockSize.getHeight(), "block-size height must be power of two");
            MediaCodecInfo.checkPowerOfTwo(alignment.getWidth(), "alignment width must be power of two");
            MediaCodecInfo.checkPowerOfTwo(alignment.getHeight(), "alignment height must be power of two");
            this.applyMacroBlockLimits(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Long.MAX_VALUE, blockSize.getWidth(), blockSize.getHeight(), alignment.getWidth(), alignment.getHeight());
            if ((this.mParent.mError & 2) != 0 || this.mAllowMbOverride) {
                if (widths != null) {
                    this.mWidthRange = MediaCodecInfo.getSizeRange().intersect(widths);
                }
                if (heights != null) {
                    this.mHeightRange = MediaCodecInfo.getSizeRange().intersect(heights);
                }
                if (counts != null) {
                    this.mBlockCountRange = POSITIVE_INTEGERS.intersect(Utils.factorRange(counts, this.mBlockWidth * this.mBlockHeight / blockSize.getWidth() / blockSize.getHeight()));
                }
                if (blockRates != null) {
                    this.mBlocksPerSecondRange = POSITIVE_LONGS.intersect(Utils.factorRange(blockRates, (long)(this.mBlockWidth * this.mBlockHeight / blockSize.getWidth() / blockSize.getHeight())));
                }
                if (blockRatios != null) {
                    this.mBlockAspectRatioRange = POSITIVE_RATIONALS.intersect(Utils.scaleRange(blockRatios, this.mBlockHeight / blockSize.getHeight(), this.mBlockWidth / blockSize.getWidth()));
                }
                if (ratios != null) {
                    this.mAspectRatioRange = POSITIVE_RATIONALS.intersect(ratios);
                }
                if (frameRates != null) {
                    this.mFrameRateRange = FRAME_RATE_RANGE.intersect(frameRates);
                }
                if (bitRates != null) {
                    this.mBitrateRange = (this.mParent.mError & 2) != 0 ? BITRATE_RANGE.intersect(bitRates) : this.mBitrateRange.intersect(bitRates);
                }
            } else {
                if (widths != null) {
                    this.mWidthRange = this.mWidthRange.intersect(widths);
                }
                if (heights != null) {
                    this.mHeightRange = this.mHeightRange.intersect(heights);
                }
                if (counts != null) {
                    this.mBlockCountRange = this.mBlockCountRange.intersect(Utils.factorRange(counts, this.mBlockWidth * this.mBlockHeight / blockSize.getWidth() / blockSize.getHeight()));
                }
                if (blockRates != null) {
                    this.mBlocksPerSecondRange = this.mBlocksPerSecondRange.intersect(Utils.factorRange(blockRates, (long)(this.mBlockWidth * this.mBlockHeight / blockSize.getWidth() / blockSize.getHeight())));
                }
                if (blockRatios != null) {
                    this.mBlockAspectRatioRange = this.mBlockAspectRatioRange.intersect(Utils.scaleRange(blockRatios, this.mBlockHeight / blockSize.getHeight(), this.mBlockWidth / blockSize.getWidth()));
                }
                if (ratios != null) {
                    this.mAspectRatioRange = this.mAspectRatioRange.intersect(ratios);
                }
                if (frameRates != null) {
                    this.mFrameRateRange = this.mFrameRateRange.intersect(frameRates);
                }
                if (bitRates != null) {
                    this.mBitrateRange = this.mBitrateRange.intersect(bitRates);
                }
            }
            this.updateLimits();
        }

        private void applyBlockLimits(int blockWidth, int blockHeight, Range<Integer> counts, Range<Long> rates, Range<Rational> ratios) {
            MediaCodecInfo.checkPowerOfTwo(blockWidth, "blockWidth must be a power of two");
            MediaCodecInfo.checkPowerOfTwo(blockHeight, "blockHeight must be a power of two");
            int newBlockWidth = Math.max(blockWidth, this.mBlockWidth);
            int newBlockHeight = Math.max(blockHeight, this.mBlockHeight);
            int factor = newBlockWidth * newBlockHeight / this.mBlockWidth / this.mBlockHeight;
            if (factor != 1) {
                this.mBlockCountRange = Utils.factorRange(this.mBlockCountRange, factor);
                this.mBlocksPerSecondRange = Utils.factorRange(this.mBlocksPerSecondRange, (long)factor);
                this.mBlockAspectRatioRange = Utils.scaleRange(this.mBlockAspectRatioRange, newBlockHeight / this.mBlockHeight, newBlockWidth / this.mBlockWidth);
                this.mHorizontalBlockRange = Utils.factorRange(this.mHorizontalBlockRange, newBlockWidth / this.mBlockWidth);
                this.mVerticalBlockRange = Utils.factorRange(this.mVerticalBlockRange, newBlockHeight / this.mBlockHeight);
            }
            if ((factor = newBlockWidth * newBlockHeight / blockWidth / blockHeight) != 1) {
                counts = Utils.factorRange(counts, factor);
                rates = Utils.factorRange(rates, (long)factor);
                ratios = Utils.scaleRange(ratios, newBlockHeight / blockHeight, newBlockWidth / blockWidth);
            }
            this.mBlockCountRange = this.mBlockCountRange.intersect(counts);
            this.mBlocksPerSecondRange = this.mBlocksPerSecondRange.intersect(rates);
            this.mBlockAspectRatioRange = this.mBlockAspectRatioRange.intersect(ratios);
            this.mBlockWidth = newBlockWidth;
            this.mBlockHeight = newBlockHeight;
        }

        private void applyAlignment(int widthAlignment, int heightAlignment) {
            MediaCodecInfo.checkPowerOfTwo(widthAlignment, "widthAlignment must be a power of two");
            MediaCodecInfo.checkPowerOfTwo(heightAlignment, "heightAlignment must be a power of two");
            if (widthAlignment > this.mBlockWidth || heightAlignment > this.mBlockHeight) {
                this.applyBlockLimits(Math.max(widthAlignment, this.mBlockWidth), Math.max(heightAlignment, this.mBlockHeight), POSITIVE_INTEGERS, POSITIVE_LONGS, POSITIVE_RATIONALS);
            }
            this.mWidthAlignment = Math.max(widthAlignment, this.mWidthAlignment);
            this.mHeightAlignment = Math.max(heightAlignment, this.mHeightAlignment);
            this.mWidthRange = Utils.alignRange(this.mWidthRange, this.mWidthAlignment);
            this.mHeightRange = Utils.alignRange(this.mHeightRange, this.mHeightAlignment);
        }

        private void updateLimits() {
            this.mHorizontalBlockRange = this.mHorizontalBlockRange.intersect(Utils.factorRange(this.mWidthRange, this.mBlockWidth));
            this.mHorizontalBlockRange = this.mHorizontalBlockRange.intersect(Range.create(this.mBlockCountRange.getLower() / this.mVerticalBlockRange.getUpper(), this.mBlockCountRange.getUpper() / this.mVerticalBlockRange.getLower()));
            this.mVerticalBlockRange = this.mVerticalBlockRange.intersect(Utils.factorRange(this.mHeightRange, this.mBlockHeight));
            this.mVerticalBlockRange = this.mVerticalBlockRange.intersect(Range.create(this.mBlockCountRange.getLower() / this.mHorizontalBlockRange.getUpper(), this.mBlockCountRange.getUpper() / this.mHorizontalBlockRange.getLower()));
            this.mBlockCountRange = this.mBlockCountRange.intersect(Range.create(this.mHorizontalBlockRange.getLower() * this.mVerticalBlockRange.getLower(), this.mHorizontalBlockRange.getUpper() * this.mVerticalBlockRange.getUpper()));
            this.mBlockAspectRatioRange = this.mBlockAspectRatioRange.intersect(new Rational(this.mHorizontalBlockRange.getLower(), this.mVerticalBlockRange.getUpper()), new Rational(this.mHorizontalBlockRange.getUpper(), this.mVerticalBlockRange.getLower()));
            this.mWidthRange = this.mWidthRange.intersect((this.mHorizontalBlockRange.getLower() - 1) * this.mBlockWidth + this.mWidthAlignment, this.mHorizontalBlockRange.getUpper() * this.mBlockWidth);
            this.mHeightRange = this.mHeightRange.intersect((this.mVerticalBlockRange.getLower() - 1) * this.mBlockHeight + this.mHeightAlignment, this.mVerticalBlockRange.getUpper() * this.mBlockHeight);
            this.mAspectRatioRange = this.mAspectRatioRange.intersect(new Rational(this.mWidthRange.getLower(), this.mHeightRange.getUpper()), new Rational(this.mWidthRange.getUpper(), this.mHeightRange.getLower()));
            this.mSmallerDimensionUpperLimit = Math.min(this.mSmallerDimensionUpperLimit, Math.min(this.mWidthRange.getUpper(), this.mHeightRange.getUpper()));
            this.mBlocksPerSecondRange = this.mBlocksPerSecondRange.intersect((long)this.mBlockCountRange.getLower().intValue() * (long)this.mFrameRateRange.getLower().intValue(), (long)this.mBlockCountRange.getUpper().intValue() * (long)this.mFrameRateRange.getUpper().intValue());
            this.mFrameRateRange = this.mFrameRateRange.intersect((int)(this.mBlocksPerSecondRange.getLower() / (long)this.mBlockCountRange.getUpper().intValue()), (int)((double)this.mBlocksPerSecondRange.getUpper().longValue() / (double)this.mBlockCountRange.getLower().intValue()));
        }

        private void applyMacroBlockLimits(int maxHorizontalBlocks, int maxVerticalBlocks, int maxBlocks, long maxBlocksPerSecond, int blockWidth, int blockHeight, int widthAlignment, int heightAlignment) {
            this.applyMacroBlockLimits(1, 1, maxHorizontalBlocks, maxVerticalBlocks, maxBlocks, maxBlocksPerSecond, blockWidth, blockHeight, widthAlignment, heightAlignment);
        }

        private void applyMacroBlockLimits(int minHorizontalBlocks, int minVerticalBlocks, int maxHorizontalBlocks, int maxVerticalBlocks, int maxBlocks, long maxBlocksPerSecond, int blockWidth, int blockHeight, int widthAlignment, int heightAlignment) {
            this.applyAlignment(widthAlignment, heightAlignment);
            this.applyBlockLimits(blockWidth, blockHeight, Range.create(1, maxBlocks), Range.create(1L, maxBlocksPerSecond), Range.create(new Rational(1, maxVerticalBlocks), new Rational(maxHorizontalBlocks, 1)));
            this.mHorizontalBlockRange = this.mHorizontalBlockRange.intersect(Utils.divUp(minHorizontalBlocks, this.mBlockWidth / blockWidth), maxHorizontalBlocks / (this.mBlockWidth / blockWidth));
            this.mVerticalBlockRange = this.mVerticalBlockRange.intersect(Utils.divUp(minVerticalBlocks, this.mBlockHeight / blockHeight), maxVerticalBlocks / (this.mBlockHeight / blockHeight));
        }

        private void applyLevelLimits() {
            long maxBlocksPerSecond = 0L;
            int maxBlocks = 0;
            int maxBps = 0;
            int maxDPBBlocks = 0;
            int errors = 4;
            CodecProfileLevel[] profileLevels = this.mParent.profileLevels;
            String mime = this.mParent.getMimeType();
            if (mime.equalsIgnoreCase("video/avc")) {
                maxBlocks = 99;
                maxBlocksPerSecond = 1485L;
                maxBps = 64000;
                maxDPBBlocks = 396;
                for (CodecProfileLevel profileLevel : profileLevels) {
                    int MBPS = 0;
                    int FS = 0;
                    int BR = 0;
                    int DPB = 0;
                    boolean supported = true;
                    switch (profileLevel.level) {
                        case 1: {
                            MBPS = 1485;
                            FS = 99;
                            BR = 64;
                            DPB = 396;
                            break;
                        }
                        case 2: {
                            MBPS = 1485;
                            FS = 99;
                            BR = 128;
                            DPB = 396;
                            break;
                        }
                        case 4: {
                            MBPS = 3000;
                            FS = 396;
                            BR = 192;
                            DPB = 900;
                            break;
                        }
                        case 8: {
                            MBPS = 6000;
                            FS = 396;
                            BR = 384;
                            DPB = 2376;
                            break;
                        }
                        case 16: {
                            MBPS = 11880;
                            FS = 396;
                            BR = 768;
                            DPB = 2376;
                            break;
                        }
                        case 32: {
                            MBPS = 11880;
                            FS = 396;
                            BR = 2000;
                            DPB = 2376;
                            break;
                        }
                        case 64: {
                            MBPS = 19800;
                            FS = 792;
                            BR = 4000;
                            DPB = 4752;
                            break;
                        }
                        case 128: {
                            MBPS = 20250;
                            FS = 1620;
                            BR = 4000;
                            DPB = 8100;
                            break;
                        }
                        case 256: {
                            MBPS = 40500;
                            FS = 1620;
                            BR = 10000;
                            DPB = 8100;
                            break;
                        }
                        case 512: {
                            MBPS = 108000;
                            FS = 3600;
                            BR = 14000;
                            DPB = 18000;
                            break;
                        }
                        case 1024: {
                            MBPS = 216000;
                            FS = 5120;
                            BR = 20000;
                            DPB = 20480;
                            break;
                        }
                        case 2048: {
                            MBPS = 245760;
                            FS = 8192;
                            BR = 20000;
                            DPB = 32768;
                            break;
                        }
                        case 4096: {
                            MBPS = 245760;
                            FS = 8192;
                            BR = 50000;
                            DPB = 32768;
                            break;
                        }
                        case 8192: {
                            MBPS = 522240;
                            FS = 8704;
                            BR = 50000;
                            DPB = 34816;
                            break;
                        }
                        case 16384: {
                            MBPS = 589824;
                            FS = 22080;
                            BR = 135000;
                            DPB = 110400;
                            break;
                        }
                        case 32768: {
                            MBPS = 983040;
                            FS = 36864;
                            BR = 240000;
                            DPB = 184320;
                            break;
                        }
                        case 65536: {
                            MBPS = 2073600;
                            FS = 36864;
                            BR = 240000;
                            DPB = 184320;
                            break;
                        }
                        case 131072: {
                            MBPS = 4177920;
                            FS = 139264;
                            BR = 240000;
                            DPB = 696320;
                            break;
                        }
                        case 262144: {
                            MBPS = 8355840;
                            FS = 139264;
                            BR = 480000;
                            DPB = 696320;
                            break;
                        }
                        case 524288: {
                            MBPS = 0xFF0000;
                            FS = 139264;
                            BR = 800000;
                            DPB = 696320;
                            break;
                        }
                        default: {
                            Log.w(TAG, "Unrecognized level " + profileLevel.level + " for " + mime);
                            errors |= 1;
                        }
                    }
                    switch (profileLevel.profile) {
                        case 8: 
                        case 524288: {
                            BR *= 1250;
                            break;
                        }
                        case 16: {
                            BR *= 3000;
                            break;
                        }
                        case 4: 
                        case 32: 
                        case 64: {
                            Log.w(TAG, "Unsupported profile " + profileLevel.profile + " for " + mime);
                            errors |= 2;
                            supported = false;
                        }
                        case 1: 
                        case 2: 
                        case 65536: {
                            BR *= 1000;
                            break;
                        }
                        default: {
                            Log.w(TAG, "Unrecognized profile " + profileLevel.profile + " for " + mime);
                            errors |= 1;
                            BR *= 1000;
                        }
                    }
                    if (supported) {
                        errors &= 0xFFFFFFFB;
                    }
                    maxBlocksPerSecond = Math.max((long)MBPS, maxBlocksPerSecond);
                    maxBlocks = Math.max(FS, maxBlocks);
                    maxBps = Math.max(BR, maxBps);
                    maxDPBBlocks = Math.max(maxDPBBlocks, DPB);
                }
                int maxLengthInBlocks = (int)Math.sqrt(maxBlocks * 8);
                this.applyMacroBlockLimits(maxLengthInBlocks, maxLengthInBlocks, maxBlocks, maxBlocksPerSecond, 16, 16, 1, 1);
            } else if (mime.equalsIgnoreCase("video/mpeg2")) {
                int maxWidth = 11;
                int maxHeight = 9;
                int maxRate = 15;
                maxBlocks = 99;
                maxBlocksPerSecond = 1485L;
                maxBps = 64000;
                for (CodecProfileLevel profileLevel : profileLevels) {
                    int MBPS = 0;
                    int FS = 0;
                    int BR = 0;
                    int FR = 0;
                    int W2 = 0;
                    int H2 = 0;
                    boolean supported = true;
                    block28 : switch (profileLevel.profile) {
                        case 0: {
                            switch (profileLevel.level) {
                                case 1: {
                                    FR = 30;
                                    W2 = 45;
                                    H2 = 36;
                                    MBPS = 40500;
                                    FS = 1620;
                                    BR = 15000;
                                    break block28;
                                }
                            }
                            Log.w(TAG, "Unrecognized profile/level " + profileLevel.profile + "/" + profileLevel.level + " for " + mime);
                            errors |= 1;
                            break;
                        }
                        case 1: {
                            switch (profileLevel.level) {
                                case 0: {
                                    FR = 30;
                                    W2 = 22;
                                    H2 = 18;
                                    MBPS = 11880;
                                    FS = 396;
                                    BR = 4000;
                                    break block28;
                                }
                                case 1: {
                                    FR = 30;
                                    W2 = 45;
                                    H2 = 36;
                                    MBPS = 40500;
                                    FS = 1620;
                                    BR = 15000;
                                    break block28;
                                }
                                case 2: {
                                    FR = 60;
                                    W2 = 90;
                                    H2 = 68;
                                    MBPS = 183600;
                                    FS = 6120;
                                    BR = 60000;
                                    break block28;
                                }
                                case 3: {
                                    FR = 60;
                                    W2 = 120;
                                    H2 = 68;
                                    MBPS = 244800;
                                    FS = 8160;
                                    BR = 80000;
                                    break block28;
                                }
                                case 4: {
                                    FR = 60;
                                    W2 = 120;
                                    H2 = 68;
                                    MBPS = 489600;
                                    FS = 8160;
                                    BR = 80000;
                                    break block28;
                                }
                            }
                            Log.w(TAG, "Unrecognized profile/level " + profileLevel.profile + "/" + profileLevel.level + " for " + mime);
                            errors |= 1;
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            Log.i(TAG, "Unsupported profile " + profileLevel.profile + " for " + mime);
                            errors |= 2;
                            supported = false;
                            break;
                        }
                        default: {
                            Log.w(TAG, "Unrecognized profile " + profileLevel.profile + " for " + mime);
                            errors |= 1;
                        }
                    }
                    if (supported) {
                        errors &= 0xFFFFFFFB;
                    }
                    maxBlocksPerSecond = Math.max((long)MBPS, maxBlocksPerSecond);
                    maxBlocks = Math.max(FS, maxBlocks);
                    maxBps = Math.max(BR * 1000, maxBps);
                    maxWidth = Math.max(W2, maxWidth);
                    maxHeight = Math.max(H2, maxHeight);
                    maxRate = Math.max(FR, maxRate);
                }
                this.applyMacroBlockLimits(maxWidth, maxHeight, maxBlocks, maxBlocksPerSecond, 16, 16, 1, 1);
                this.mFrameRateRange = this.mFrameRateRange.intersect(12, maxRate);
            } else if (mime.equalsIgnoreCase("video/mp4v-es")) {
                int maxWidth = 11;
                int maxHeight = 9;
                int maxRate = 15;
                maxBlocks = 99;
                maxBlocksPerSecond = 1485L;
                maxBps = 64000;
                for (CodecProfileLevel profileLevel : profileLevels) {
                    int MBPS = 0;
                    int FS = 0;
                    int BR = 0;
                    int FR = 0;
                    int W3 = 0;
                    int H3 = 0;
                    boolean strict = false;
                    boolean supported = true;
                    block43 : switch (profileLevel.profile) {
                        case 1: {
                            switch (profileLevel.level) {
                                case 1: {
                                    strict = true;
                                    FR = 15;
                                    W3 = 11;
                                    H3 = 9;
                                    MBPS = 1485;
                                    FS = 99;
                                    BR = 64;
                                    break block43;
                                }
                                case 4: {
                                    FR = 30;
                                    W3 = 11;
                                    H3 = 9;
                                    MBPS = 1485;
                                    FS = 99;
                                    BR = 64;
                                    break block43;
                                }
                                case 2: {
                                    strict = true;
                                    FR = 15;
                                    W3 = 11;
                                    H3 = 9;
                                    MBPS = 1485;
                                    FS = 99;
                                    BR = 128;
                                    break block43;
                                }
                                case 8: {
                                    FR = 30;
                                    W3 = 22;
                                    H3 = 18;
                                    MBPS = 5940;
                                    FS = 396;
                                    BR = 128;
                                    break block43;
                                }
                                case 16: {
                                    FR = 30;
                                    W3 = 22;
                                    H3 = 18;
                                    MBPS = 11880;
                                    FS = 396;
                                    BR = 384;
                                    break block43;
                                }
                                case 64: {
                                    FR = 30;
                                    W3 = 40;
                                    H3 = 30;
                                    MBPS = 36000;
                                    FS = 1200;
                                    BR = 4000;
                                    break block43;
                                }
                                case 128: {
                                    FR = 30;
                                    W3 = 45;
                                    H3 = 36;
                                    MBPS = 40500;
                                    FS = 1620;
                                    BR = 8000;
                                    break block43;
                                }
                                case 256: {
                                    FR = 30;
                                    W3 = 80;
                                    H3 = 45;
                                    MBPS = 108000;
                                    FS = 3600;
                                    BR = 12000;
                                    break block43;
                                }
                            }
                            Log.w(TAG, "Unrecognized profile/level " + profileLevel.profile + "/" + profileLevel.level + " for " + mime);
                            errors |= 1;
                            break;
                        }
                        case 32768: {
                            switch (profileLevel.level) {
                                case 1: 
                                case 4: {
                                    FR = 30;
                                    W3 = 11;
                                    H3 = 9;
                                    MBPS = 2970;
                                    FS = 99;
                                    BR = 128;
                                    break block43;
                                }
                                case 8: {
                                    FR = 30;
                                    W3 = 22;
                                    H3 = 18;
                                    MBPS = 5940;
                                    FS = 396;
                                    BR = 384;
                                    break block43;
                                }
                                case 16: {
                                    FR = 30;
                                    W3 = 22;
                                    H3 = 18;
                                    MBPS = 11880;
                                    FS = 396;
                                    BR = 768;
                                    break block43;
                                }
                                case 24: {
                                    FR = 30;
                                    W3 = 22;
                                    H3 = 18;
                                    MBPS = 11880;
                                    FS = 396;
                                    BR = 1500;
                                    break block43;
                                }
                                case 32: {
                                    FR = 30;
                                    W3 = 44;
                                    H3 = 36;
                                    MBPS = 23760;
                                    FS = 792;
                                    BR = 3000;
                                    break block43;
                                }
                                case 128: {
                                    FR = 30;
                                    W3 = 45;
                                    H3 = 36;
                                    MBPS = 48600;
                                    FS = 1620;
                                    BR = 8000;
                                    break block43;
                                }
                            }
                            Log.w(TAG, "Unrecognized profile/level " + profileLevel.profile + "/" + profileLevel.level + " for " + mime);
                            errors |= 1;
                            break;
                        }
                        case 2: 
                        case 4: 
                        case 8: 
                        case 16: 
                        case 32: 
                        case 64: 
                        case 128: 
                        case 256: 
                        case 512: 
                        case 1024: 
                        case 2048: 
                        case 4096: 
                        case 8192: 
                        case 16384: {
                            Log.i(TAG, "Unsupported profile " + profileLevel.profile + " for " + mime);
                            errors |= 2;
                            supported = false;
                            break;
                        }
                        default: {
                            Log.w(TAG, "Unrecognized profile " + profileLevel.profile + " for " + mime);
                            errors |= 1;
                        }
                    }
                    if (supported) {
                        errors &= 0xFFFFFFFB;
                    }
                    maxBlocksPerSecond = Math.max((long)MBPS, maxBlocksPerSecond);
                    maxBlocks = Math.max(FS, maxBlocks);
                    maxBps = Math.max(BR * 1000, maxBps);
                    if (strict) {
                        maxWidth = Math.max(W3, maxWidth);
                        maxHeight = Math.max(H3, maxHeight);
                        maxRate = Math.max(FR, maxRate);
                        continue;
                    }
                    int maxDim = (int)Math.sqrt(FS * 2);
                    maxWidth = Math.max(maxDim, maxWidth);
                    maxHeight = Math.max(maxDim, maxHeight);
                    maxRate = Math.max(Math.max(FR, 60), maxRate);
                }
                this.applyMacroBlockLimits(maxWidth, maxHeight, maxBlocks, maxBlocksPerSecond, 16, 16, 1, 1);
                this.mFrameRateRange = this.mFrameRateRange.intersect(12, maxRate);
            } else if (mime.equalsIgnoreCase("video/3gpp")) {
                int maxWidth = 11;
                int maxHeight = 9;
                int maxRate = 15;
                int minWidth = maxWidth;
                int minHeight = maxHeight;
                int minAlignment = 16;
                maxBlocks = 99;
                maxBlocksPerSecond = 1485L;
                maxBps = 64000;
                for (CodecProfileLevel profileLevel : profileLevels) {
                    int MBPS = 0;
                    int BR = 0;
                    int FR = 0;
                    int W4 = 0;
                    int H4 = 0;
                    int minW = minWidth;
                    int minH = minHeight;
                    boolean strict = false;
                    switch (profileLevel.level) {
                        case 1: {
                            strict = true;
                            FR = 15;
                            W4 = 11;
                            H4 = 9;
                            BR = 1;
                            MBPS = W4 * H4 * FR;
                            break;
                        }
                        case 2: {
                            strict = true;
                            FR = 30;
                            W4 = 22;
                            H4 = 18;
                            BR = 2;
                            MBPS = W4 * H4 * 15;
                            break;
                        }
                        case 4: {
                            strict = true;
                            FR = 30;
                            W4 = 22;
                            H4 = 18;
                            BR = 6;
                            MBPS = W4 * H4 * FR;
                            break;
                        }
                        case 8: {
                            strict = true;
                            FR = 30;
                            W4 = 22;
                            H4 = 18;
                            BR = 32;
                            MBPS = W4 * H4 * FR;
                            break;
                        }
                        case 16: {
                            boolean bl = strict = profileLevel.profile == 1 || profileLevel.profile == 4;
                            if (!strict) {
                                minW = 1;
                                minH = 1;
                                minAlignment = 4;
                            }
                            FR = 15;
                            W4 = 11;
                            H4 = 9;
                            BR = 2;
                            MBPS = W4 * H4 * FR;
                            break;
                        }
                        case 32: {
                            minW = 1;
                            minH = 1;
                            minAlignment = 4;
                            FR = 60;
                            W4 = 22;
                            H4 = 18;
                            BR = 64;
                            MBPS = W4 * H4 * 50;
                            break;
                        }
                        case 64: {
                            minW = 1;
                            minH = 1;
                            minAlignment = 4;
                            FR = 60;
                            W4 = 45;
                            H4 = 18;
                            BR = 128;
                            MBPS = W4 * H4 * 50;
                            break;
                        }
                        case 128: {
                            minW = 1;
                            minH = 1;
                            minAlignment = 4;
                            FR = 60;
                            W4 = 45;
                            H4 = 36;
                            BR = 256;
                            MBPS = W4 * H4 * 50;
                            break;
                        }
                        default: {
                            Log.w(TAG, "Unrecognized profile/level " + profileLevel.profile + "/" + profileLevel.level + " for " + mime);
                            errors |= 1;
                        }
                    }
                    switch (profileLevel.profile) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 8: 
                        case 16: 
                        case 32: 
                        case 64: 
                        case 128: 
                        case 256: {
                            break;
                        }
                        default: {
                            Log.w(TAG, "Unrecognized profile " + profileLevel.profile + " for " + mime);
                            errors |= 1;
                        }
                    }
                    if (strict) {
                        minW = 11;
                        minH = 9;
                    } else {
                        this.mAllowMbOverride = true;
                    }
                    errors &= 0xFFFFFFFB;
                    maxBlocksPerSecond = Math.max((long)MBPS, maxBlocksPerSecond);
                    maxBlocks = Math.max(W4 * H4, maxBlocks);
                    maxBps = Math.max(BR * 64000, maxBps);
                    maxWidth = Math.max(W4, maxWidth);
                    maxHeight = Math.max(H4, maxHeight);
                    maxRate = Math.max(FR, maxRate);
                    minWidth = Math.min(minW, minWidth);
                    minHeight = Math.min(minH, minHeight);
                }
                if (!this.mAllowMbOverride) {
                    this.mBlockAspectRatioRange = Range.create(new Rational(11, 9), new Rational(11, 9));
                }
                this.applyMacroBlockLimits(minWidth, minHeight, maxWidth, maxHeight, maxBlocks, maxBlocksPerSecond, 16, 16, minAlignment, minAlignment);
                this.mFrameRateRange = Range.create(1, maxRate);
            } else if (mime.equalsIgnoreCase("video/x-vnd.on2.vp8")) {
                maxBlocks = Integer.MAX_VALUE;
                maxBlocksPerSecond = Integer.MAX_VALUE;
                maxBps = 100000000;
                for (CodecProfileLevel profileLevel : profileLevels) {
                    switch (profileLevel.level) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 8: {
                            break;
                        }
                        default: {
                            Log.w(TAG, "Unrecognized level " + profileLevel.level + " for " + mime);
                            errors |= 1;
                        }
                    }
                    switch (profileLevel.profile) {
                        case 1: {
                            break;
                        }
                        default: {
                            Log.w(TAG, "Unrecognized profile " + profileLevel.profile + " for " + mime);
                            errors |= 1;
                        }
                    }
                    errors &= 0xFFFFFFFB;
                }
                int blockSize = 16;
                this.applyMacroBlockLimits(Short.MAX_VALUE, Short.MAX_VALUE, maxBlocks, maxBlocksPerSecond, 16, 16, 1, 1);
            } else if (mime.equalsIgnoreCase("video/x-vnd.on2.vp9")) {
                maxBlocksPerSecond = 829440L;
                maxBlocks = 36864;
                maxBps = 200000;
                int maxDim = 512;
                for (CodecProfileLevel profileLevel : profileLevels) {
                    long SR = 0L;
                    int FS = 0;
                    int BR = 0;
                    int D = 0;
                    switch (profileLevel.level) {
                        case 1: {
                            SR = 829440L;
                            FS = 36864;
                            BR = 200;
                            D = 512;
                            break;
                        }
                        case 2: {
                            SR = 2764800L;
                            FS = 73728;
                            BR = 800;
                            D = 768;
                            break;
                        }
                        case 4: {
                            SR = 4608000L;
                            FS = 122880;
                            BR = 1800;
                            D = 960;
                            break;
                        }
                        case 8: {
                            SR = 9216000L;
                            FS = 245760;
                            BR = 3600;
                            D = 1344;
                            break;
                        }
                        case 16: {
                            SR = 20736000L;
                            FS = 552960;
                            BR = 7200;
                            D = 2048;
                            break;
                        }
                        case 32: {
                            SR = 36864000L;
                            FS = 983040;
                            BR = 12000;
                            D = 2752;
                            break;
                        }
                        case 64: {
                            SR = 83558400L;
                            FS = 0x220000;
                            BR = 18000;
                            D = 4160;
                            break;
                        }
                        case 128: {
                            SR = 0x9900000L;
                            FS = 0x220000;
                            BR = 30000;
                            D = 4160;
                            break;
                        }
                        case 256: {
                            SR = 311951360L;
                            FS = 0x880000;
                            BR = 60000;
                            D = 8384;
                            break;
                        }
                        case 512: {
                            SR = 588251136L;
                            FS = 0x880000;
                            BR = 120000;
                            D = 8384;
                            break;
                        }
                        case 1024: {
                            SR = 1176502272L;
                            FS = 0x880000;
                            BR = 180000;
                            D = 8384;
                            break;
                        }
                        case 2048: {
                            SR = 1176502272L;
                            FS = 0x2200000;
                            BR = 180000;
                            D = 16832;
                            break;
                        }
                        case 4096: {
                            SR = 2353004544L;
                            FS = 0x2200000;
                            BR = 240000;
                            D = 16832;
                            break;
                        }
                        case 8192: {
                            SR = 0x118800000L;
                            FS = 0x2200000;
                            BR = 480000;
                            D = 16832;
                            break;
                        }
                        default: {
                            Log.w(TAG, "Unrecognized level " + profileLevel.level + " for " + mime);
                            errors |= 1;
                        }
                    }
                    switch (profileLevel.profile) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 8: 
                        case 4096: 
                        case 8192: 
                        case 16384: 
                        case 32768: {
                            break;
                        }
                        default: {
                            Log.w(TAG, "Unrecognized profile " + profileLevel.profile + " for " + mime);
                            errors |= 1;
                        }
                    }
                    errors &= 0xFFFFFFFB;
                    maxBlocksPerSecond = Math.max(SR, maxBlocksPerSecond);
                    maxBlocks = Math.max(FS, maxBlocks);
                    maxBps = Math.max(BR * 1000, maxBps);
                    maxDim = Math.max(D, maxDim);
                }
                int blockSize = 8;
                int maxLengthInBlocks = Utils.divUp(maxDim, 8);
                maxBlocks = Utils.divUp(maxBlocks, 64);
                maxBlocksPerSecond = Utils.divUp(maxBlocksPerSecond, 64L);
                this.applyMacroBlockLimits(maxLengthInBlocks, maxLengthInBlocks, maxBlocks, maxBlocksPerSecond, 8, 8, 1, 1);
            } else if (mime.equalsIgnoreCase("video/hevc")) {
                maxBlocks = 576;
                maxBlocksPerSecond = maxBlocks * 15;
                maxBps = 128000;
                for (CodecProfileLevel profileLevel : profileLevels) {
                    double FR = 0.0;
                    int FS = 0;
                    int BR = 0;
                    switch (profileLevel.level) {
                        case 1: 
                        case 2: {
                            FR = 15.0;
                            FS = 36864;
                            BR = 128;
                            break;
                        }
                        case 4: 
                        case 8: {
                            FR = 30.0;
                            FS = 122880;
                            BR = 1500;
                            break;
                        }
                        case 16: 
                        case 32: {
                            FR = 30.0;
                            FS = 245760;
                            BR = 3000;
                            break;
                        }
                        case 64: 
                        case 128: {
                            FR = 30.0;
                            FS = 552960;
                            BR = 6000;
                            break;
                        }
                        case 256: 
                        case 512: {
                            FR = 33.75;
                            FS = 983040;
                            BR = 10000;
                            break;
                        }
                        case 1024: {
                            FR = 30.0;
                            FS = 0x220000;
                            BR = 12000;
                            break;
                        }
                        case 2048: {
                            FR = 30.0;
                            FS = 0x220000;
                            BR = 30000;
                            break;
                        }
                        case 4096: {
                            FR = 60.0;
                            FS = 0x220000;
                            BR = 20000;
                            break;
                        }
                        case 8192: {
                            FR = 60.0;
                            FS = 0x220000;
                            BR = 50000;
                            break;
                        }
                        case 16384: {
                            FR = 30.0;
                            FS = 0x880000;
                            BR = 25000;
                            break;
                        }
                        case 32768: {
                            FR = 30.0;
                            FS = 0x880000;
                            BR = 100000;
                            break;
                        }
                        case 65536: {
                            FR = 60.0;
                            FS = 0x880000;
                            BR = 40000;
                            break;
                        }
                        case 131072: {
                            FR = 60.0;
                            FS = 0x880000;
                            BR = 160000;
                            break;
                        }
                        case 262144: {
                            FR = 120.0;
                            FS = 0x880000;
                            BR = 60000;
                            break;
                        }
                        case 524288: {
                            FR = 120.0;
                            FS = 0x880000;
                            BR = 240000;
                            break;
                        }
                        case 0x100000: {
                            FR = 30.0;
                            FS = 0x2200000;
                            BR = 60000;
                            break;
                        }
                        case 0x200000: {
                            FR = 30.0;
                            FS = 0x2200000;
                            BR = 240000;
                            break;
                        }
                        case 0x400000: {
                            FR = 60.0;
                            FS = 0x2200000;
                            BR = 120000;
                            break;
                        }
                        case 0x800000: {
                            FR = 60.0;
                            FS = 0x2200000;
                            BR = 480000;
                            break;
                        }
                        case 0x1000000: {
                            FR = 120.0;
                            FS = 0x2200000;
                            BR = 240000;
                            break;
                        }
                        case 0x2000000: {
                            FR = 120.0;
                            FS = 0x2200000;
                            BR = 800000;
                            break;
                        }
                        default: {
                            Log.w(TAG, "Unrecognized level " + profileLevel.level + " for " + mime);
                            errors |= 1;
                        }
                    }
                    switch (profileLevel.profile) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 4096: 
                        case 8192: {
                            break;
                        }
                        default: {
                            Log.w(TAG, "Unrecognized profile " + profileLevel.profile + " for " + mime);
                            errors |= 1;
                        }
                    }
                    errors &= 0xFFFFFFFB;
                    maxBlocksPerSecond = Math.max((long)((int)(FR * (double)(FS >>= 6))), maxBlocksPerSecond);
                    maxBlocks = Math.max(FS, maxBlocks);
                    maxBps = Math.max(BR * 1000, maxBps);
                }
                int maxLengthInBlocks = (int)Math.sqrt(maxBlocks * 8);
                this.applyMacroBlockLimits(maxLengthInBlocks, maxLengthInBlocks, maxBlocks, maxBlocksPerSecond, 8, 8, 1, 1);
            } else if (mime.equalsIgnoreCase("video/av01")) {
                maxBlocksPerSecond = 829440L;
                maxBlocks = 36864;
                maxBps = 200000;
                int maxDim = 512;
                for (CodecProfileLevel profileLevel : profileLevels) {
                    long SR = 0L;
                    int FS = 0;
                    int BR = 0;
                    int D = 0;
                    switch (profileLevel.level) {
                        case 1: {
                            SR = 5529600L;
                            FS = 147456;
                            BR = 1500;
                            D = 2048;
                            break;
                        }
                        case 2: 
                        case 4: 
                        case 8: {
                            SR = 10454400L;
                            FS = 278784;
                            BR = 3000;
                            D = 2816;
                            break;
                        }
                        case 16: {
                            SR = 24969600L;
                            FS = 665856;
                            BR = 6000;
                            D = 4352;
                            break;
                        }
                        case 32: 
                        case 64: 
                        case 128: {
                            SR = 39938400L;
                            FS = 0x104040;
                            BR = 10000;
                            D = 5504;
                            break;
                        }
                        case 256: {
                            SR = 0x4A40000L;
                            FS = 0x240000;
                            BR = 12000;
                            D = 6144;
                            break;
                        }
                        case 512: 
                        case 1024: 
                        case 2048: {
                            SR = 155713536L;
                            FS = 0x240000;
                            BR = 20000;
                            D = 6144;
                            break;
                        }
                        case 4096: {
                            SR = 273715200L;
                            FS = 0x880000;
                            BR = 30000;
                            D = 8192;
                            break;
                        }
                        case 8192: {
                            SR = 547430400L;
                            FS = 0x880000;
                            BR = 40000;
                            D = 8192;
                            break;
                        }
                        case 16384: {
                            SR = 1094860800L;
                            FS = 0x880000;
                            BR = 60000;
                            D = 8192;
                            break;
                        }
                        case 32768: {
                            SR = 1176502272L;
                            FS = 0x880000;
                            BR = 60000;
                            D = 8192;
                            break;
                        }
                        case 65536: {
                            SR = 1176502272L;
                            FS = 0x2200000;
                            BR = 60000;
                            D = 16384;
                            break;
                        }
                        case 131072: {
                            SR = 2189721600L;
                            FS = 0x2200000;
                            BR = 100000;
                            D = 16384;
                            break;
                        }
                        case 262144: {
                            SR = 4379443200L;
                            FS = 0x2200000;
                            BR = 160000;
                            D = 16384;
                            break;
                        }
                        case 524288: {
                            SR = 0x118800000L;
                            FS = 0x2200000;
                            BR = 160000;
                            D = 16384;
                            break;
                        }
                        default: {
                            Log.w(TAG, "Unrecognized level " + profileLevel.level + " for " + mime);
                            errors |= 1;
                        }
                    }
                    switch (profileLevel.profile) {
                        case 1: 
                        case 2: 
                        case 4096: 
                        case 8192: {
                            break;
                        }
                        default: {
                            Log.w(TAG, "Unrecognized profile " + profileLevel.profile + " for " + mime);
                            errors |= 1;
                        }
                    }
                    errors &= 0xFFFFFFFB;
                    maxBlocksPerSecond = Math.max(SR, maxBlocksPerSecond);
                    maxBlocks = Math.max(FS, maxBlocks);
                    maxBps = Math.max(BR * 1000, maxBps);
                    maxDim = Math.max(D, maxDim);
                }
                int blockSize = 8;
                int maxLengthInBlocks = Utils.divUp(maxDim, 8);
                maxBlocks = Utils.divUp(maxBlocks, 64);
                maxBlocksPerSecond = Utils.divUp(maxBlocksPerSecond, 64L);
                this.applyMacroBlockLimits(maxLengthInBlocks, maxLengthInBlocks, maxBlocks, maxBlocksPerSecond, 8, 8, 1, 1);
            } else if (MediaCodec.GetFlag(() -> Flags.apvSupport()) && mime.equalsIgnoreCase("video/apv")) {
                maxBlocksPerSecond = 11880L;
                maxBps = 7000000;
                for (CodecProfileLevel profileLevel : profileLevels) {
                    long SR = 0L;
                    int BR = 0;
                    switch (profileLevel.level) {
                        case 257: {
                            SR = 3041280L;
                            BR = 7000000;
                            break;
                        }
                        case 258: {
                            SR = 3041280L;
                            BR = 11000000;
                            break;
                        }
                        case 260: {
                            SR = 3041280L;
                            BR = 14000000;
                            break;
                        }
                        case 264: {
                            SR = 3041280L;
                            BR = 21000000;
                            break;
                        }
                        case 513: {
                            SR = 6082560L;
                            BR = 14000000;
                            break;
                        }
                        case 514: {
                            SR = 6082560L;
                            BR = 21000000;
                            break;
                        }
                        case 516: {
                            SR = 6082560L;
                            BR = 28000000;
                            break;
                        }
                        case 520: {
                            SR = 6082560L;
                            BR = 42000000;
                            break;
                        }
                        case 1025: {
                            SR = 15667200L;
                            BR = 36000000;
                            break;
                        }
                        case 1026: {
                            SR = 15667200L;
                            BR = 53000000;
                            break;
                        }
                        case 1028: {
                            SR = 15667200L;
                            BR = 71000000;
                            break;
                        }
                        case 1032: {
                            SR = 15667200L;
                            BR = 106000000;
                            break;
                        }
                        case 2049: {
                            SR = 31334400L;
                            BR = 71000000;
                            break;
                        }
                        case 2050: {
                            SR = 31334400L;
                            BR = 106000000;
                            break;
                        }
                        case 2052: {
                            SR = 31334400L;
                            BR = 141000000;
                            break;
                        }
                        case 2056: {
                            SR = 31334400L;
                            BR = 212000000;
                            break;
                        }
                        case 4097: {
                            SR = 66846720L;
                            BR = 101000000;
                            break;
                        }
                        case 4098: {
                            SR = 66846720L;
                            BR = 151000000;
                            break;
                        }
                        case 4100: {
                            SR = 66846720L;
                            BR = 201000000;
                            break;
                        }
                        case 4104: {
                            SR = 66846720L;
                            BR = 301000000;
                            break;
                        }
                        case 8193: {
                            SR = 133693440L;
                            BR = 201000000;
                            break;
                        }
                        case 8194: {
                            SR = 133693440L;
                            BR = 301000000;
                            break;
                        }
                        case 8196: {
                            SR = 133693440L;
                            BR = 401000000;
                            break;
                        }
                        case 8200: {
                            SR = 133693440L;
                            BR = 602000000;
                            break;
                        }
                        case 16385: {
                            SR = 265420800L;
                            BR = 401000000;
                            break;
                        }
                        case 16386: {
                            SR = 265420800L;
                            BR = 602000000;
                            break;
                        }
                        case 16388: {
                            SR = 265420800L;
                            BR = 780000000;
                            break;
                        }
                        case 16392: {
                            SR = 265420800L;
                            BR = 1170000000;
                            break;
                        }
                        case 32769: {
                            SR = 530841600L;
                            BR = 780000000;
                            break;
                        }
                        case 32770: {
                            SR = 530841600L;
                            BR = 1170000000;
                            break;
                        }
                        case 32772: {
                            SR = 530841600L;
                            BR = 1560000000;
                            break;
                        }
                        case 32776: {
                            SR = 530841600L;
                            BR = Integer.MAX_VALUE;
                            break;
                        }
                        case 65537: {
                            SR = 1061683200L;
                            BR = 1560000000;
                            break;
                        }
                        case 65538: {
                            SR = 1061683200L;
                            BR = Integer.MAX_VALUE;
                            break;
                        }
                        case 65540: {
                            SR = 1061683200L;
                            BR = Integer.MAX_VALUE;
                            break;
                        }
                        case 65544: {
                            SR = 1061683200L;
                            BR = Integer.MAX_VALUE;
                            break;
                        }
                        case 131073: 
                        case 131074: 
                        case 131076: 
                        case 131080: {
                            SR = 2123366400L;
                            BR = Integer.MAX_VALUE;
                            break;
                        }
                        case 262145: 
                        case 262146: 
                        case 262148: 
                        case 262152: {
                            SR = 4777574400L;
                            BR = Integer.MAX_VALUE;
                            break;
                        }
                        case 524289: 
                        case 524290: 
                        case 524292: 
                        case 524296: {
                            SR = 8493465600L;
                            BR = Integer.MAX_VALUE;
                            break;
                        }
                        case 0x100001: 
                        case 0x100002: 
                        case 0x100004: 
                        case 0x100008: {
                            SR = 16986931200L;
                            BR = Integer.MAX_VALUE;
                            break;
                        }
                        case 0x200001: 
                        case 0x200002: 
                        case 0x200004: 
                        case 0x200008: {
                            SR = 33973862400L;
                            BR = Integer.MAX_VALUE;
                            break;
                        }
                        default: {
                            Log.w(TAG, "Unrecognized level " + profileLevel.level + " for " + mime);
                            errors |= 1;
                        }
                    }
                    switch (profileLevel.profile) {
                        case 1: 
                        case 4096: 
                        case 8192: {
                            break;
                        }
                        default: {
                            Log.w(TAG, "Unrecognized profile " + profileLevel.profile + " for " + mime);
                            errors |= 1;
                        }
                    }
                    errors &= 0xFFFFFFFB;
                    maxBlocksPerSecond = Math.max(SR, maxBlocksPerSecond);
                    maxBps = Math.max(BR, maxBps);
                }
                int blockSize = 16;
                maxBlocks = Integer.MAX_VALUE;
                maxBlocksPerSecond = Utils.divUp(maxBlocksPerSecond, 256L);
                maxBlocks = (int)Math.min((long)maxBlocks, maxBlocksPerSecond);
                int maxLengthInBlocks = Utils.divUp((int)Math.pow(2.0, 24.0), 16);
                maxLengthInBlocks = Math.min(maxLengthInBlocks, maxBlocks);
                this.applyMacroBlockLimits(maxLengthInBlocks, maxLengthInBlocks, maxBlocks, maxBlocksPerSecond, 16, 16, 2, 1);
            } else {
                Log.w(TAG, "Unsupported mime " + mime);
                maxBps = 64000;
                errors |= 2;
            }
            this.mBitrateRange = Range.create(1, maxBps);
            this.mParent.mError |= errors;
        }

        public static class PerformancePoint {
            private Size mBlockSize;
            private int mWidth;
            private int mHeight;
            private int mMaxFrameRate;
            private long mMaxMacroBlockRate;
            @NonNull
            public static final PerformancePoint SD_24 = new PerformancePoint(720, 480, 24);
            @NonNull
            public static final PerformancePoint SD_25 = new PerformancePoint(720, 576, 25);
            @NonNull
            public static final PerformancePoint SD_30 = new PerformancePoint(720, 480, 30);
            @NonNull
            public static final PerformancePoint SD_48 = new PerformancePoint(720, 480, 48);
            @NonNull
            public static final PerformancePoint SD_50 = new PerformancePoint(720, 576, 50);
            @NonNull
            public static final PerformancePoint SD_60 = new PerformancePoint(720, 480, 60);
            @NonNull
            public static final PerformancePoint HD_24 = new PerformancePoint(1280, 720, 24);
            @NonNull
            public static final PerformancePoint HD_25 = new PerformancePoint(1280, 720, 25);
            @NonNull
            public static final PerformancePoint HD_30 = new PerformancePoint(1280, 720, 30);
            @NonNull
            public static final PerformancePoint HD_50 = new PerformancePoint(1280, 720, 50);
            @NonNull
            public static final PerformancePoint HD_60 = new PerformancePoint(1280, 720, 60);
            @NonNull
            public static final PerformancePoint HD_100 = new PerformancePoint(1280, 720, 100);
            @NonNull
            public static final PerformancePoint HD_120 = new PerformancePoint(1280, 720, 120);
            @NonNull
            public static final PerformancePoint HD_200 = new PerformancePoint(1280, 720, 200);
            @NonNull
            public static final PerformancePoint HD_240 = new PerformancePoint(1280, 720, 240);
            @NonNull
            public static final PerformancePoint FHD_24 = new PerformancePoint(1920, 1080, 24);
            @NonNull
            public static final PerformancePoint FHD_25 = new PerformancePoint(1920, 1080, 25);
            @NonNull
            public static final PerformancePoint FHD_30 = new PerformancePoint(1920, 1080, 30);
            @NonNull
            public static final PerformancePoint FHD_50 = new PerformancePoint(1920, 1080, 50);
            @NonNull
            public static final PerformancePoint FHD_60 = new PerformancePoint(1920, 1080, 60);
            @NonNull
            public static final PerformancePoint FHD_100 = new PerformancePoint(1920, 1080, 100);
            @NonNull
            public static final PerformancePoint FHD_120 = new PerformancePoint(1920, 1080, 120);
            @NonNull
            public static final PerformancePoint FHD_200 = new PerformancePoint(1920, 1080, 200);
            @NonNull
            public static final PerformancePoint FHD_240 = new PerformancePoint(1920, 1080, 240);
            @NonNull
            public static final PerformancePoint UHD_24 = new PerformancePoint(3840, 2160, 24);
            @NonNull
            public static final PerformancePoint UHD_25 = new PerformancePoint(3840, 2160, 25);
            @NonNull
            public static final PerformancePoint UHD_30 = new PerformancePoint(3840, 2160, 30);
            @NonNull
            public static final PerformancePoint UHD_50 = new PerformancePoint(3840, 2160, 50);
            @NonNull
            public static final PerformancePoint UHD_60 = new PerformancePoint(3840, 2160, 60);
            @NonNull
            public static final PerformancePoint UHD_100 = new PerformancePoint(3840, 2160, 100);
            @NonNull
            public static final PerformancePoint UHD_120 = new PerformancePoint(3840, 2160, 120);
            @NonNull
            public static final PerformancePoint UHD_200 = new PerformancePoint(3840, 2160, 200);
            @NonNull
            public static final PerformancePoint UHD_240 = new PerformancePoint(3840, 2160, 240);

            public int getMaxMacroBlocks() {
                return this.saturateLongToInt((long)this.mWidth * (long)this.mHeight);
            }

            public int getMaxFrameRate() {
                return this.mMaxFrameRate;
            }

            public long getMaxMacroBlockRate() {
                return this.mMaxMacroBlockRate;
            }

            public String toString() {
                int blockWidth = 16 * this.mBlockSize.getWidth();
                int blockHeight = 16 * this.mBlockSize.getHeight();
                int origRate = (int)Utils.divUp(this.mMaxMacroBlockRate, (long)this.getMaxMacroBlocks());
                String info = this.mWidth * 16 + "x" + this.mHeight * 16 + "@" + origRate;
                if (origRate < this.mMaxFrameRate) {
                    info = info + ", max " + this.mMaxFrameRate + "fps";
                }
                if (blockWidth > 16 || blockHeight > 16) {
                    info = info + ", " + blockWidth + "x" + blockHeight + " blocks";
                }
                return "PerformancePoint(" + info + ")";
            }

            public int hashCode() {
                return this.mMaxFrameRate;
            }

            public PerformancePoint(int width, int height, int frameRate, int maxFrameRate, @NonNull Size blockSize) {
                MediaCodecInfo.checkPowerOfTwo(blockSize.getWidth(), "block width");
                MediaCodecInfo.checkPowerOfTwo(blockSize.getHeight(), "block height");
                this.mBlockSize = new Size(Utils.divUp(blockSize.getWidth(), 16), Utils.divUp(blockSize.getHeight(), 16));
                this.mWidth = (int)(Utils.divUp(Math.max(1L, (long)width), (long)Math.max(blockSize.getWidth(), 16)) * (long)this.mBlockSize.getWidth());
                this.mHeight = (int)(Utils.divUp(Math.max(1L, (long)height), (long)Math.max(blockSize.getHeight(), 16)) * (long)this.mBlockSize.getHeight());
                this.mMaxFrameRate = Math.max(1, Math.max(frameRate, maxFrameRate));
                this.mMaxMacroBlockRate = Math.max(1, frameRate) * this.getMaxMacroBlocks();
            }

            public PerformancePoint(@NonNull PerformancePoint pp, @NonNull Size newBlockSize) {
                this(pp.mWidth * 16, pp.mHeight * 16, (int)Utils.divUp(pp.mMaxMacroBlockRate, (long)pp.getMaxMacroBlocks()), pp.mMaxFrameRate, new Size(Math.max(newBlockSize.getWidth(), pp.mBlockSize.getWidth() * 16), Math.max(newBlockSize.getHeight(), pp.mBlockSize.getHeight() * 16)));
            }

            public PerformancePoint(int width, int height, int frameRate) {
                this(width, height, frameRate, frameRate, new Size(16, 16));
            }

            private int saturateLongToInt(long value) {
                if (value < Integer.MIN_VALUE) {
                    return Integer.MIN_VALUE;
                }
                if (value > Integer.MAX_VALUE) {
                    return Integer.MAX_VALUE;
                }
                return (int)value;
            }

            private int align(int value, int alignment) {
                return Utils.divUp(value, alignment) * alignment;
            }

            private void checkPowerOfTwo2(int value, @NonNull String description) {
                if (value == 0 || (value & value - 1) != 0) {
                    throw new IllegalArgumentException(description + " (" + value + ") must be a power of 2");
                }
            }

            public boolean covers(@NonNull MediaFormat format) {
                PerformancePoint other = new PerformancePoint(format.getInteger("width", 0), format.getInteger("height", 0), Math.round((float)Math.ceil(format.getNumber("frame-rate", 0).doubleValue())));
                return this.covers(other);
            }

            public boolean covers(@NonNull PerformancePoint other) {
                Size commonSize = this.getCommonBlockSize(other);
                PerformancePoint aligned = new PerformancePoint(this, commonSize);
                PerformancePoint otherAligned = new PerformancePoint(other, commonSize);
                return aligned.getMaxMacroBlocks() >= otherAligned.getMaxMacroBlocks() && aligned.mMaxFrameRate >= otherAligned.mMaxFrameRate && aligned.mMaxMacroBlockRate >= otherAligned.mMaxMacroBlockRate;
            }

            @NonNull
            private Size getCommonBlockSize(@NonNull PerformancePoint other) {
                return new Size(Math.max(this.mBlockSize.getWidth(), other.mBlockSize.getWidth()) * 16, Math.max(this.mBlockSize.getHeight(), other.mBlockSize.getHeight()) * 16);
            }

            public boolean equals(Object o) {
                if (o instanceof PerformancePoint) {
                    PerformancePoint other = (PerformancePoint)o;
                    Size commonSize = this.getCommonBlockSize(other);
                    PerformancePoint aligned = new PerformancePoint(this, commonSize);
                    PerformancePoint otherAligned = new PerformancePoint(other, commonSize);
                    return aligned.getMaxMacroBlocks() == otherAligned.getMaxMacroBlocks() && aligned.mMaxFrameRate == otherAligned.mMaxFrameRate && aligned.mMaxMacroBlockRate == otherAligned.mMaxMacroBlockRate;
                }
                return false;
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SecurityModel {
    }

    public static class AudioCapabilities {
        private static final String TAG = "AudioCapabilities";
        private CodecCapabilities mParent;
        private Range<Integer> mBitrateRange;
        private int[] mSampleRates;
        private Range<Integer>[] mSampleRateRanges;
        private Range<Integer>[] mInputChannelRanges;
        private static final int MAX_INPUT_CHANNEL_COUNT = 30;
        static final Set<String> AUDIO_LEVEL_CRITICAL_FORMAT_KEYS = Set.of("mime");

        public Range<Integer> getBitrateRange() {
            return this.mBitrateRange;
        }

        public int[] getSupportedSampleRates() {
            return this.mSampleRates != null ? Arrays.copyOf(this.mSampleRates, this.mSampleRates.length) : null;
        }

        public Range<Integer>[] getSupportedSampleRateRanges() {
            return Arrays.copyOf(this.mSampleRateRanges, this.mSampleRateRanges.length);
        }

        public int getMaxInputChannelCount() {
            int overall_max = 0;
            for (int i = this.mInputChannelRanges.length - 1; i >= 0; --i) {
                int lmax = this.mInputChannelRanges[i].getUpper();
                if (lmax <= overall_max) continue;
                overall_max = lmax;
            }
            return overall_max;
        }

        public int getMinInputChannelCount() {
            int overall_min = 30;
            for (int i = this.mInputChannelRanges.length - 1; i >= 0; --i) {
                int lmin = this.mInputChannelRanges[i].getLower();
                if (lmin >= overall_min) continue;
                overall_min = lmin;
            }
            return overall_min;
        }

        @SuppressLint(value={"ArrayReturn"})
        @NonNull
        public Range<Integer>[] getInputChannelCountRanges() {
            return Arrays.copyOf(this.mInputChannelRanges, this.mInputChannelRanges.length);
        }

        private AudioCapabilities() {
        }

        public static AudioCapabilities create(MediaFormat info, CodecCapabilities parent) {
            AudioCapabilities caps = new AudioCapabilities();
            caps.init(info, parent);
            return caps;
        }

        private void init(MediaFormat info, CodecCapabilities parent) {
            this.mParent = parent;
            this.initWithPlatformLimits();
            this.applyLevelLimits();
            this.parseFromInfo(info);
        }

        private void initWithPlatformLimits() {
            this.mBitrateRange = Range.create(0, Integer.MAX_VALUE);
            this.mInputChannelRanges = new Range[]{Range.create(1, 30)};
            int minSampleRate = SystemProperties.getInt("ro.mediacodec.min_sample_rate", 7350);
            int maxSampleRate = SystemProperties.getInt("ro.mediacodec.max_sample_rate", 192000);
            this.mSampleRateRanges = new Range[]{Range.create(minSampleRate, maxSampleRate)};
            this.mSampleRates = null;
        }

        private boolean supports(Integer sampleRate, Integer inputChannels) {
            int ix;
            if (inputChannels != null && (ix = Utils.binarySearchDistinctRanges(this.mInputChannelRanges, inputChannels)) < 0) {
                return false;
            }
            return sampleRate == null || (ix = Utils.binarySearchDistinctRanges(this.mSampleRateRanges, sampleRate)) >= 0;
        }

        public boolean isSampleRateSupported(int sampleRate) {
            return this.supports(sampleRate, null);
        }

        private void limitSampleRates(int[] rates) {
            Arrays.sort(rates);
            ArrayList<Range<Integer>> ranges = new ArrayList<Range<Integer>>();
            for (int rate : rates) {
                if (!this.supports(rate, null)) continue;
                ranges.add(Range.create(rate, rate));
            }
            this.mSampleRateRanges = ranges.toArray(new Range[ranges.size()]);
            this.createDiscreteSampleRates();
        }

        private void createDiscreteSampleRates() {
            this.mSampleRates = new int[this.mSampleRateRanges.length];
            for (int i = 0; i < this.mSampleRateRanges.length; ++i) {
                this.mSampleRates[i] = this.mSampleRateRanges[i].getLower();
            }
        }

        private void limitSampleRates(Range<Integer>[] rateRanges) {
            Utils.sortDistinctRanges(rateRanges);
            for (Range<Integer> range : this.mSampleRateRanges = Utils.intersectSortedDistinctRanges(this.mSampleRateRanges, rateRanges)) {
                if (((Object)range.getLower()).equals(range.getUpper())) continue;
                this.mSampleRates = null;
                return;
            }
            this.createDiscreteSampleRates();
        }

        private void applyLevelLimits() {
            int[] sampleRates = null;
            Range<Integer> sampleRateRange = null;
            Range<Integer> bitRates = null;
            int maxChannels = 30;
            CodecProfileLevel[] profileLevels = this.mParent.profileLevels;
            String mime = this.mParent.getMimeType();
            if (mime.equalsIgnoreCase("audio/mpeg")) {
                sampleRates = new int[]{8000, 11025, 12000, 16000, 22050, 24000, 32000, 44100, 48000};
                bitRates = Range.create(8000, 320000);
                maxChannels = 2;
            } else if (mime.equalsIgnoreCase("audio/3gpp")) {
                sampleRates = new int[]{8000};
                bitRates = Range.create(4750, 12200);
                maxChannels = 1;
            } else if (mime.equalsIgnoreCase("audio/amr-wb")) {
                sampleRates = new int[]{16000};
                bitRates = Range.create(6600, 23850);
                maxChannels = 1;
            } else if (mime.equalsIgnoreCase("audio/mp4a-latm")) {
                sampleRates = new int[]{7350, 8000, 11025, 12000, 16000, 22050, 24000, 32000, 44100, 48000, 64000, 88200, 96000};
                bitRates = Range.create(8000, 510000);
                maxChannels = 48;
            } else if (mime.equalsIgnoreCase("audio/vorbis")) {
                bitRates = Range.create(32000, 500000);
                sampleRateRange = Range.create(8000, 192000);
                maxChannels = 255;
            } else if (mime.equalsIgnoreCase("audio/opus")) {
                bitRates = Range.create(6000, 510000);
                sampleRates = new int[]{8000, 12000, 16000, 24000, 48000};
                maxChannels = 255;
            } else if (mime.equalsIgnoreCase("audio/raw")) {
                sampleRateRange = Range.create(1, 192000);
                bitRates = Range.create(1, 10000000);
                maxChannels = AudioSystem.OUT_CHANNEL_COUNT_MAX;
            } else if (mime.equalsIgnoreCase("audio/flac")) {
                sampleRateRange = Range.create(1, 655350);
                maxChannels = 255;
            } else if (mime.equalsIgnoreCase("audio/g711-alaw") || mime.equalsIgnoreCase("audio/g711-mlaw")) {
                sampleRates = new int[]{8000};
                bitRates = Range.create(64000, 64000);
            } else if (mime.equalsIgnoreCase("audio/gsm")) {
                sampleRates = new int[]{8000};
                bitRates = Range.create(13000, 13000);
                maxChannels = 1;
            } else if (mime.equalsIgnoreCase("audio/ac3")) {
                maxChannels = 6;
            } else if (mime.equalsIgnoreCase("audio/eac3")) {
                maxChannels = 16;
            } else if (mime.equalsIgnoreCase("audio/eac3-joc")) {
                sampleRates = new int[]{48000};
                bitRates = Range.create(32000, 6144000);
                maxChannels = 16;
            } else if (mime.equalsIgnoreCase("audio/ac4")) {
                sampleRates = new int[]{44100, 48000, 96000, 192000};
                bitRates = Range.create(16000, 2688000);
                maxChannels = 24;
            } else if (mime.equalsIgnoreCase("audio/vnd.dts")) {
                sampleRates = new int[]{44100, 48000};
                bitRates = Range.create(96000, 1524000);
                maxChannels = 6;
            } else if (mime.equalsIgnoreCase("audio/vnd.dts.hd")) {
                block8: for (CodecProfileLevel profileLevel : profileLevels) {
                    switch (profileLevel.profile) {
                        case 2: {
                            sampleRates = new int[]{22050, 24000, 44100, 48000};
                            bitRates = Range.create(32000, 768000);
                            continue block8;
                        }
                        case 1: 
                        case 4: {
                            sampleRates = new int[]{44100, 48000, 88200, 96000, 176400, 192000};
                            bitRates = Range.create(96000, 24500000);
                            continue block8;
                        }
                        default: {
                            Log.w(TAG, "Unrecognized profile " + profileLevel.profile + " for " + mime);
                            this.mParent.mError |= 1;
                            sampleRates = new int[]{44100, 48000, 88200, 96000, 176400, 192000};
                            bitRates = Range.create(96000, 24500000);
                        }
                    }
                }
                maxChannels = 8;
            } else if (mime.equalsIgnoreCase("audio/vnd.dts.uhd")) {
                block9: for (CodecProfileLevel profileLevel : profileLevels) {
                    switch (profileLevel.profile) {
                        case 2: {
                            sampleRates = new int[]{48000};
                            bitRates = Range.create(96000, 768000);
                            maxChannels = 10;
                            continue block9;
                        }
                        case 1: {
                            sampleRates = new int[]{44100, 48000, 88200, 96000, 176400, 192000};
                            bitRates = Range.create(96000, 24500000);
                            maxChannels = 32;
                            continue block9;
                        }
                        default: {
                            Log.w(TAG, "Unrecognized profile " + profileLevel.profile + " for " + mime);
                            this.mParent.mError |= 1;
                            sampleRates = new int[]{44100, 48000, 88200, 96000, 176400, 192000};
                            bitRates = Range.create(96000, 24500000);
                            maxChannels = 32;
                        }
                    }
                }
            } else {
                Log.w(TAG, "Unsupported mime " + mime);
                this.mParent.mError |= 2;
            }
            if (sampleRates != null) {
                this.limitSampleRates(sampleRates);
            } else if (sampleRateRange != null) {
                this.limitSampleRates(new Range[]{sampleRateRange});
            }
            Range<Integer> channelRange = Range.create(1, maxChannels);
            this.applyLimits(new Range[]{channelRange}, bitRates);
        }

        private void applyLimits(Range<Integer>[] inputChannels, Range<Integer> bitRates) {
            Range[] myInputChannels = new Range[inputChannels.length];
            for (int i = 0; i < inputChannels.length; ++i) {
                int lower = inputChannels[i].clamp(1);
                int upper = inputChannels[i].clamp(30);
                myInputChannels[i] = Range.create(lower, upper);
            }
            Utils.sortDistinctRanges(myInputChannels);
            Range<Integer>[] joinedChannelList = Utils.intersectSortedDistinctRanges(myInputChannels, this.mInputChannelRanges);
            this.mInputChannelRanges = joinedChannelList;
            if (bitRates != null) {
                this.mBitrateRange = this.mBitrateRange.intersect(bitRates);
            }
        }

        private void parseFromInfo(MediaFormat info) {
            int i;
            int maxInputChannels = 30;
            Range[] channels = new Range[]{Range.create(1, maxInputChannels)};
            Range<Integer> bitRates = POSITIVE_INTEGERS;
            if (info.containsKey("sample-rate-ranges")) {
                String[] rateStrings = info.getString("sample-rate-ranges").split(",");
                Range[] rateRanges = new Range[rateStrings.length];
                for (i = 0; i < rateStrings.length; ++i) {
                    rateRanges[i] = Utils.parseIntRange(rateStrings[i], null);
                }
                this.limitSampleRates(rateRanges);
            }
            if (info.containsKey("channel-ranges")) {
                String[] channelStrings = info.getString("channel-ranges").split(",");
                Range[] channelRanges = new Range[channelStrings.length];
                for (i = 0; i < channelStrings.length; ++i) {
                    channelRanges[i] = Utils.parseIntRange(channelStrings[i], null);
                }
                channels = channelRanges;
            } else if (info.containsKey("channel-range")) {
                Range<Integer> oneRange = Utils.parseIntRange(info.getString("channel-range"), null);
                channels = new Range[]{oneRange};
            } else if (info.containsKey("max-channel-count")) {
                maxInputChannels = Utils.parseIntSafely(info.getString("max-channel-count"), maxInputChannels);
                channels = maxInputChannels == 0 ? new Range[]{Range.create(0, 0)} : new Range[]{Range.create(1, maxInputChannels)};
            } else if ((this.mParent.mError & 2) != 0) {
                maxInputChannels = 0;
                channels = new Range[]{Range.create(0, 0)};
            }
            if (info.containsKey("bitrate-range")) {
                bitRates = bitRates.intersect(Utils.parseIntRange(info.getString("bitrate-range"), bitRates));
            }
            this.applyLimits(channels, bitRates);
        }

        public void getDefaultFormat(MediaFormat format) {
            if (((Object)this.mBitrateRange.getLower()).equals(this.mBitrateRange.getUpper())) {
                format.setInteger("bitrate", this.mBitrateRange.getLower());
            }
            if (this.getMaxInputChannelCount() == 1) {
                format.setInteger("channel-count", 1);
            }
            if (this.mSampleRates != null && this.mSampleRates.length == 1) {
                format.setInteger("sample-rate", this.mSampleRates[0]);
            }
        }

        public boolean supportsFormat(MediaFormat format) {
            Integer channels;
            Map<String, Object> map = format.getMap();
            Integer sampleRate = (Integer)map.get("sample-rate");
            if (!this.supports(sampleRate, channels = (Integer)map.get("channel-count"))) {
                return false;
            }
            return CodecCapabilities.supportsBitrate(this.mBitrateRange, format);
        }
    }

    private static class Feature {
        public String mName;
        public int mValue;
        public boolean mDefault;
        public boolean mInternal;

        public Feature(String name, int value, boolean def) {
            this(name, value, def, false);
        }

        public Feature(String name, int value, boolean def, boolean internal) {
            this.mName = name;
            this.mValue = value;
            this.mDefault = def;
            this.mInternal = internal;
        }
    }
}

