/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.hardware.cas.AidlCasPluginDescriptor;
import android.hardware.cas.ICasListener;
import android.hardware.cas.IMediaCasService;
import android.hardware.cas.V1_0.HidlCasPluginDescriptor;
import android.hardware.cas.V1_0.ICas;
import android.hardware.cas.V1_2.ICas;
import android.hardware.cas.V1_2.ICasListener;
import android.hardware.cas.V1_2.IMediaCasService;
import android.media.MediaCasException;
import android.media.MediaCasStateException;
import android.media.tv.tunerresourcemanager.CasSessionRequest;
import android.media.tv.tunerresourcemanager.ResourceClientProfile;
import android.media.tv.tunerresourcemanager.TunerResourceManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.IHwBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.ServiceSpecificException;
import android.util.Log;
import com.android.internal.util.FrameworkStatsLog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class MediaCas
implements AutoCloseable {
    private static final String TAG = "MediaCas";
    private android.hardware.cas.ICas mICas = null;
    private ICas mICasHidl = null;
    private android.hardware.cas.V1_1.ICas mICasHidl11 = null;
    private android.hardware.cas.V1_2.ICas mICasHidl12 = null;
    private EventListener mListener;
    private HandlerThread mHandlerThread;
    private EventHandler mEventHandler;
    private int mPriorityHint;
    private String mTvInputServiceSessionId;
    private int mClientId;
    private int mCasSystemId;
    private int mUserId;
    private TunerResourceManager mTunerResourceManager = null;
    private final Map<Session, Long> mSessionMap = new HashMap<Session, Long>();
    public static final int SCRAMBLING_MODE_RESERVED = 0;
    public static final int SCRAMBLING_MODE_DVB_CSA1 = 1;
    public static final int SCRAMBLING_MODE_DVB_CSA2 = 2;
    public static final int SCRAMBLING_MODE_DVB_CSA3_STANDARD = 3;
    public static final int SCRAMBLING_MODE_DVB_CSA3_MINIMAL = 4;
    public static final int SCRAMBLING_MODE_DVB_CSA3_ENHANCE = 5;
    public static final int SCRAMBLING_MODE_DVB_CISSA_V1 = 6;
    public static final int SCRAMBLING_MODE_DVB_IDSA = 7;
    public static final int SCRAMBLING_MODE_MULTI2 = 8;
    public static final int SCRAMBLING_MODE_AES128 = 9;
    public static final int SCRAMBLING_MODE_AES_CBC = 14;
    public static final int SCRAMBLING_MODE_AES_ECB = 10;
    public static final int SCRAMBLING_MODE_AES_SCTE52 = 11;
    public static final int SCRAMBLING_MODE_TDES_ECB = 12;
    public static final int SCRAMBLING_MODE_TDES_SCTE52 = 13;
    public static final int SESSION_USAGE_LIVE = 0;
    public static final int SESSION_USAGE_PLAYBACK = 1;
    public static final int SESSION_USAGE_RECORD = 2;
    public static final int SESSION_USAGE_TIMESHIFT = 3;
    public static final int PLUGIN_STATUS_PHYSICAL_MODULE_CHANGED = 0;
    public static final int PLUGIN_STATUS_SESSION_NUMBER_CHANGED = 1;
    private static android.hardware.cas.IMediaCasService sService = null;
    private static Object sAidlLock = new Object();
    private static IBinder.DeathRecipient sDeathListener = new IBinder.DeathRecipient(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = sAidlLock;
            synchronized (object) {
                Log.d(MediaCas.TAG, "The service is dead");
                sService.asBinder().unlinkToDeath(sDeathListener, 0);
                sService = null;
            }
        }
    };
    private static android.hardware.cas.V1_0.IMediaCasService sServiceHidl = null;
    private static Object sHidlLock = new Object();
    private static final long MEDIA_CAS_HIDL_COOKIE = 394L;
    private static IHwBinder.DeathRecipient sDeathListenerHidl = new IHwBinder.DeathRecipient(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serviceDied(long cookie) {
            if (cookie == 394L) {
                Object object = sHidlLock;
                synchronized (object) {
                    sServiceHidl = null;
                }
            }
        }
    };
    private final ICasListener.Stub mBinder = new ICasListener.Stub(){

        @Override
        public void onEvent(int event, int arg, byte[] data) throws RemoteException {
            if (MediaCas.this.mEventHandler != null) {
                MediaCas.this.mEventHandler.sendMessage(MediaCas.this.mEventHandler.obtainMessage(0, event, arg, data));
            }
        }

        @Override
        public void onSessionEvent(byte[] sessionId, int event, int arg, byte[] data) throws RemoteException {
            if (MediaCas.this.mEventHandler != null) {
                Message msg = MediaCas.this.mEventHandler.obtainMessage();
                msg.what = 1;
                msg.arg1 = event;
                msg.arg2 = arg;
                Bundle bundle = new Bundle();
                bundle.putByteArray("sessionId", sessionId);
                bundle.putByteArray("data", data);
                msg.setData(bundle);
                MediaCas.this.mEventHandler.sendMessage(msg);
            }
        }

        @Override
        public void onStatusUpdate(byte status, int arg) throws RemoteException {
            if (MediaCas.this.mEventHandler != null) {
                MediaCas.this.mEventHandler.sendMessage(MediaCas.this.mEventHandler.obtainMessage(2, status, arg));
            }
        }

        @Override
        public synchronized String getInterfaceHash() throws RemoteException {
            return "bc51d8d70a55ec4723d3f73d0acf7003306bf69f";
        }

        @Override
        public int getInterfaceVersion() throws RemoteException {
            return 1;
        }
    };
    private final ICasListener.Stub mBinderHidl = new ICasListener.Stub(){

        @Override
        public void onEvent(int event, int arg, @Nullable ArrayList<Byte> data) throws RemoteException {
            if (MediaCas.this.mEventHandler != null) {
                MediaCas.this.mEventHandler.sendMessage(MediaCas.this.mEventHandler.obtainMessage(0, event, arg, MediaCas.this.toBytes(data)));
            }
        }

        @Override
        public void onSessionEvent(@NonNull ArrayList<Byte> sessionId, int event, int arg, @Nullable ArrayList<Byte> data) throws RemoteException {
            if (MediaCas.this.mEventHandler != null) {
                Message msg = MediaCas.this.mEventHandler.obtainMessage();
                msg.what = 1;
                msg.arg1 = event;
                msg.arg2 = arg;
                Bundle bundle = new Bundle();
                bundle.putByteArray("sessionId", MediaCas.this.toBytes(sessionId));
                bundle.putByteArray("data", MediaCas.this.toBytes(data));
                msg.setData(bundle);
                MediaCas.this.mEventHandler.sendMessage(msg);
            }
        }

        @Override
        public void onStatusUpdate(byte status, int arg) throws RemoteException {
            if (MediaCas.this.mEventHandler != null) {
                MediaCas.this.mEventHandler.sendMessage(MediaCas.this.mEventHandler.obtainMessage(2, status, arg));
            }
        }
    };
    private final TunerResourceManager.ResourcesReclaimListener mResourceListener = new TunerResourceManager.ResourcesReclaimListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReclaimResources() {
            Map<Session, Long> map = MediaCas.this.mSessionMap;
            synchronized (map) {
                ArrayList<Session> sessionList = new ArrayList<Session>(MediaCas.this.mSessionMap.keySet());
                for (Session casSession : sessionList) {
                    casSession.close();
                }
            }
            if (MediaCas.this.mEventHandler != null) {
                MediaCas.this.mEventHandler.sendMessage(MediaCas.this.mEventHandler.obtainMessage(3));
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static android.hardware.cas.IMediaCasService getService() {
        Object object = sAidlLock;
        synchronized (object) {
            if (sService == null || !sService.asBinder().isBinderAlive()) {
                try {
                    Log.d(TAG, "Trying to get AIDL service");
                    sService = IMediaCasService.Stub.asInterface(ServiceManager.waitForDeclaredService((String)(android.hardware.cas.IMediaCasService.DESCRIPTOR + "/default")));
                    if (sService != null) {
                        sService.asBinder().linkToDeath(sDeathListener, 0);
                    }
                }
                catch (Exception eAidl) {
                    Log.d(TAG, "Failed to get cas AIDL service");
                }
            }
            return sService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static android.hardware.cas.V1_0.IMediaCasService getServiceHidl() {
        Object object = sHidlLock;
        synchronized (object) {
            if (sServiceHidl != null) {
                return sServiceHidl;
            }
            try {
                Log.d(TAG, "Trying to get cas@1.2 service");
                IMediaCasService serviceV12 = IMediaCasService.getService(true);
                if (serviceV12 != null) {
                    sServiceHidl = serviceV12;
                    sServiceHidl.linkToDeath(sDeathListenerHidl, 394L);
                    return sServiceHidl;
                }
            }
            catch (Exception eV1_2) {
                Log.d(TAG, "Failed to get cas@1.2 service");
            }
            try {
                Log.d(TAG, "Trying to get cas@1.1 service");
                android.hardware.cas.V1_1.IMediaCasService serviceV11 = android.hardware.cas.V1_1.IMediaCasService.getService(true);
                if (serviceV11 != null) {
                    sServiceHidl = serviceV11;
                    sServiceHidl.linkToDeath(sDeathListenerHidl, 394L);
                    return sServiceHidl;
                }
            }
            catch (Exception eV1_1) {
                Log.d(TAG, "Failed to get cas@1.1 service");
            }
            try {
                Log.d(TAG, "Trying to get cas@1.0 service");
                sServiceHidl = android.hardware.cas.V1_0.IMediaCasService.getService(true);
                if (sServiceHidl != null) {
                    sServiceHidl.linkToDeath(sDeathListenerHidl, 394L);
                }
                return sServiceHidl;
            }
            catch (Exception eV1_0) {
                Log.d(TAG, "Failed to get cas@1.0 service");
            }
        }
        return null;
    }

    private void validateInternalStates() {
        if (this.mICas == null && this.mICasHidl == null) {
            throw new IllegalStateException();
        }
    }

    private void cleanupAndRethrowIllegalState() {
        this.mICas = null;
        this.mICasHidl = null;
        this.mICasHidl11 = null;
        this.mICasHidl12 = null;
        throw new IllegalStateException();
    }

    private ArrayList<Byte> toByteArray(@NonNull byte[] data, int offset, int length) {
        ArrayList<Byte> byteArray = new ArrayList<Byte>(length);
        for (int i = 0; i < length; ++i) {
            byteArray.add(data[offset + i]);
        }
        return byteArray;
    }

    private ArrayList<Byte> toByteArray(@Nullable byte[] data) {
        if (data == null) {
            return new ArrayList<Byte>();
        }
        return this.toByteArray(data, 0, data.length);
    }

    private byte[] toBytes(@NonNull ArrayList<Byte> byteArray) {
        byte[] data = null;
        if (byteArray != null) {
            data = new byte[byteArray.size()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = byteArray.get(i);
            }
        }
        return data;
    }

    Session createFromSessionId(byte[] sessionId) {
        if (sessionId == null || sessionId.length == 0) {
            return null;
        }
        return new Session(sessionId);
    }

    public static boolean isSystemIdSupported(int CA_system_id) {
        android.hardware.cas.IMediaCasService service = MediaCas.getService();
        if (service != null) {
            try {
                return service.isSystemIdSupported(CA_system_id);
            }
            catch (RemoteException e) {
                return false;
            }
        }
        android.hardware.cas.V1_0.IMediaCasService serviceHidl = MediaCas.getServiceHidl();
        if (serviceHidl != null) {
            try {
                return serviceHidl.isSystemIdSupported(CA_system_id);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }

    public static PluginDescriptor[] enumeratePlugins() {
        android.hardware.cas.V1_0.IMediaCasService serviceHidl;
        android.hardware.cas.IMediaCasService service = MediaCas.getService();
        if (service != null) {
            try {
                AidlCasPluginDescriptor[] descriptors = service.enumeratePlugins();
                if (descriptors.length == 0) {
                    return null;
                }
                PluginDescriptor[] results = new PluginDescriptor[descriptors.length];
                for (int i = 0; i < results.length; ++i) {
                    results[i] = new PluginDescriptor(descriptors[i]);
                }
                return results;
            }
            catch (RemoteException e) {
                Log.e(TAG, "Some exception while enumerating plugins");
            }
        }
        if ((serviceHidl = MediaCas.getServiceHidl()) != null) {
            try {
                ArrayList<HidlCasPluginDescriptor> descriptors = serviceHidl.enumeratePlugins();
                if (descriptors.size() == 0) {
                    return null;
                }
                PluginDescriptor[] results = new PluginDescriptor[descriptors.size()];
                for (int i = 0; i < results.length; ++i) {
                    results[i] = new PluginDescriptor(descriptors.get(i));
                }
                return results;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPlugin(int casSystemId) throws MediaCasException.UnsupportedCasException {
        block11: {
            try {
                this.mCasSystemId = casSystemId;
                this.mUserId = Process.myUid();
                android.hardware.cas.IMediaCasService service = MediaCas.getService();
                if (service != null) {
                    Log.d(TAG, "Use CAS AIDL interface to create plugin");
                    this.mICas = service.createPlugin(casSystemId, this.mBinder);
                } else {
                    android.hardware.cas.V1_0.IMediaCasService serviceV10 = MediaCas.getServiceHidl();
                    IMediaCasService serviceV12 = IMediaCasService.castFrom(serviceV10);
                    if (serviceV12 == null) {
                        android.hardware.cas.V1_1.IMediaCasService serviceV11 = android.hardware.cas.V1_1.IMediaCasService.castFrom(serviceV10);
                        if (serviceV11 == null) {
                            Log.d(TAG, "Used cas@1_0 interface to create plugin");
                            this.mICasHidl = serviceV10.createPlugin(casSystemId, this.mBinderHidl);
                        } else {
                            Log.d(TAG, "Used cas@1.1 interface to create plugin");
                            this.mICasHidl11 = serviceV11.createPluginExt(casSystemId, this.mBinderHidl);
                            this.mICasHidl = this.mICasHidl11;
                        }
                    } else {
                        Log.d(TAG, "Used cas@1.2 interface to create plugin");
                        this.mICasHidl12 = android.hardware.cas.V1_2.ICas.castFrom(serviceV12.createPluginExt(casSystemId, this.mBinderHidl));
                        this.mICasHidl11 = this.mICasHidl12;
                        this.mICasHidl = this.mICasHidl12;
                    }
                }
            }
            catch (Exception e) {
                Log.e(TAG, "Failed to create plugin: " + e);
                this.mICas = null;
                this.mICasHidl = null;
            }
            finally {
                if (this.mICas != null || this.mICasHidl != null) break block11;
                throw new MediaCasException.UnsupportedCasException("Unsupported casSystemId " + casSystemId);
            }
        }
    }

    private void registerClient(@NonNull Context context, @Nullable String tvInputServiceSessionId, int priorityHint) {
        this.mTunerResourceManager = (TunerResourceManager)context.getSystemService("tv_tuner_resource_mgr");
        if (this.mTunerResourceManager != null) {
            int[] clientId = new int[1];
            ResourceClientProfile profile = new ResourceClientProfile();
            profile.tvInputSessionId = tvInputServiceSessionId;
            profile.useCase = priorityHint;
            this.mTunerResourceManager.registerClientProfile(profile, context.getMainExecutor(), this.mResourceListener, clientId);
            this.mClientId = clientId[0];
        }
    }

    public MediaCas(int casSystemId) throws MediaCasException.UnsupportedCasException {
        this.createPlugin(casSystemId);
    }

    public MediaCas(@NonNull Context context, int casSystemId, @Nullable String tvInputServiceSessionId, int priorityHint) throws MediaCasException.UnsupportedCasException {
        Objects.requireNonNull(context, "context must not be null");
        this.createPlugin(casSystemId);
        this.registerClient(context, tvInputServiceSessionId, priorityHint);
    }

    public MediaCas(@NonNull Context context, int casSystemId, @Nullable String tvInputServiceSessionId, int priorityHint, @Nullable Handler handler, @Nullable EventListener listener) throws MediaCasException.UnsupportedCasException {
        Objects.requireNonNull(context, "context must not be null");
        this.setEventListener(listener, handler);
        this.createPlugin(casSystemId);
        this.registerClient(context, tvInputServiceSessionId, priorityHint);
    }

    @SystemApi
    @FlaggedApi(value="android.media.tv.flags.mediacas_update_client_profile_priority")
    @RequiresPermission(value="android.permission.TUNER_RESOURCE_ACCESS")
    public boolean updateResourcePriority(int priority, int niceValue) {
        if (this.mTunerResourceManager != null) {
            return this.mTunerResourceManager.updateClientPriority(this.mClientId, priority, niceValue);
        }
        return false;
    }

    @SystemApi
    @FlaggedApi(value="android.media.tv.flags.set_resource_holder_retain")
    @RequiresPermission(value="android.permission.TUNER_RESOURCE_ACCESS")
    public void setResourceOwnershipRetention(boolean enabled) {
        if (this.mTunerResourceManager != null) {
            this.mTunerResourceManager.setResourceOwnershipRetention(this.mClientId, enabled);
        }
    }

    IHwBinder getBinder() {
        if (this.mICas != null) {
            return null;
        }
        this.validateInternalStates();
        return this.mICasHidl.asBinder();
    }

    public boolean isAidlHal() {
        return this.mICas != null;
    }

    public void setEventListener(@Nullable EventListener listener, @Nullable Handler handler) {
        Looper looper;
        this.mListener = listener;
        if (this.mListener == null) {
            this.mEventHandler = null;
            return;
        }
        Looper looper2 = looper = handler != null ? handler.getLooper() : null;
        if (looper == null && (looper = Looper.myLooper()) == null && (looper = Looper.getMainLooper()) == null) {
            if (this.mHandlerThread == null || !this.mHandlerThread.isAlive()) {
                this.mHandlerThread = new HandlerThread("MediaCasEventThread", -2);
                this.mHandlerThread.start();
            }
            looper = this.mHandlerThread.getLooper();
        }
        this.mEventHandler = new EventHandler(looper);
    }

    public void setPrivateData(@NonNull byte[] data) throws MediaCasException {
        this.validateInternalStates();
        try {
            if (this.mICas != null) {
                try {
                    this.mICas.setPrivateData(data);
                }
                catch (ServiceSpecificException se) {
                    MediaCasException.throwExceptionIfNeeded(se.errorCode);
                }
            } else {
                MediaCasException.throwExceptionIfNeeded(this.mICasHidl.setPrivateData(this.toByteArray(data, 0, data.length)));
            }
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
    }

    private long getSessionResourceHandle() throws MediaCasException {
        this.validateInternalStates();
        long[] sessionResourceHandle = new long[]{-1L};
        if (this.mTunerResourceManager != null) {
            CasSessionRequest casSessionRequest = new CasSessionRequest();
            casSessionRequest.clientId = this.mClientId;
            casSessionRequest.casSystemId = this.mCasSystemId;
            if (!this.mTunerResourceManager.requestCasSession(casSessionRequest, sessionResourceHandle)) {
                throw new MediaCasException.InsufficientResourceException("insufficient resource to Open Session");
            }
        }
        return sessionResourceHandle[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSessionToResourceMap(Session session, long sessionResourceHandle) {
        if (sessionResourceHandle != -1L) {
            Map<Session, Long> map = this.mSessionMap;
            synchronized (map) {
                this.mSessionMap.put(session, sessionResourceHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSessionFromResourceMap(Session session) {
        Map<Session, Long> map = this.mSessionMap;
        synchronized (map) {
            if (this.mSessionMap.get(session) != null) {
                this.mTunerResourceManager.releaseCasSession(this.mSessionMap.get(session), this.mClientId);
                this.mSessionMap.remove(session);
            }
        }
    }

    public Session openSession() throws MediaCasException {
        long sessionResourceHandle = this.getSessionResourceHandle();
        try {
            if (this.mICas != null) {
                try {
                    byte[] sessionId = this.mICas.openSessionDefault();
                    Session session = this.createFromSessionId(sessionId);
                    this.addSessionToResourceMap(session, sessionResourceHandle);
                    Log.d(TAG, "Write Stats Log for succeed to Open Session.");
                    FrameworkStatsLog.write(280, this.mUserId, this.mCasSystemId, 1);
                    return session;
                }
                catch (ServiceSpecificException se) {
                    MediaCasException.throwExceptionIfNeeded(se.errorCode);
                }
            } else if (this.mICasHidl != null) {
                OpenSessionCallback cb = new OpenSessionCallback();
                this.mICasHidl.openSession(cb);
                MediaCasException.throwExceptionIfNeeded(cb.mStatus);
                this.addSessionToResourceMap(cb.mSession, sessionResourceHandle);
                Log.d(TAG, "Write Stats Log for succeed to Open Session.");
                FrameworkStatsLog.write(280, this.mUserId, this.mCasSystemId, 1);
                return cb.mSession;
            }
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
        Log.d(TAG, "Write Stats Log for fail to Open Session.");
        FrameworkStatsLog.write(280, this.mUserId, this.mCasSystemId, 2);
        return null;
    }

    @Nullable
    public Session openSession(int sessionUsage, int scramblingMode) throws MediaCasException {
        long sessionResourceHandle = this.getSessionResourceHandle();
        if (this.mICas != null) {
            try {
                byte[] sessionId = this.mICas.openSession(sessionUsage, scramblingMode);
                Session session = this.createFromSessionId(sessionId);
                this.addSessionToResourceMap(session, sessionResourceHandle);
                Log.d(TAG, "Write Stats Log for succeed to Open Session.");
                FrameworkStatsLog.write(280, this.mUserId, this.mCasSystemId, 1);
                return session;
            }
            catch (RemoteException | ServiceSpecificException e) {
                this.cleanupAndRethrowIllegalState();
            }
        }
        if (this.mICasHidl12 == null) {
            Log.d(TAG, "Open Session with scrambling mode is only supported by cas@1.2+ interface");
            throw new MediaCasException.UnsupportedCasException("Open Session with scrambling mode is not supported");
        }
        try {
            OpenSession_1_2_Callback cb = new OpenSession_1_2_Callback();
            this.mICasHidl12.openSession_1_2(sessionUsage, scramblingMode, cb);
            MediaCasException.throwExceptionIfNeeded(cb.mStatus);
            this.addSessionToResourceMap(cb.mSession, sessionResourceHandle);
            Log.d(TAG, "Write Stats Log for succeed to Open Session.");
            FrameworkStatsLog.write(280, this.mUserId, this.mCasSystemId, 1);
            return cb.mSession;
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
            Log.d(TAG, "Write Stats Log for fail to Open Session.");
            FrameworkStatsLog.write(280, this.mUserId, this.mCasSystemId, 2);
            return null;
        }
    }

    public void processEmm(@NonNull byte[] data, int offset, int length) throws MediaCasException {
        this.validateInternalStates();
        try {
            if (this.mICas != null) {
                try {
                    this.mICas.processEmm(Arrays.copyOfRange(data, offset, length));
                }
                catch (ServiceSpecificException se) {
                    MediaCasException.throwExceptionIfNeeded(se.errorCode);
                }
            } else {
                MediaCasException.throwExceptionIfNeeded(this.mICasHidl.processEmm(this.toByteArray(data, offset, length)));
            }
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
    }

    public void processEmm(@NonNull byte[] data) throws MediaCasException {
        this.processEmm(data, 0, data.length);
    }

    public void sendEvent(int event, int arg, @Nullable byte[] data) throws MediaCasException {
        this.validateInternalStates();
        try {
            if (this.mICas != null) {
                try {
                    if (data == null) {
                        data = new byte[]{};
                    }
                    this.mICas.sendEvent(event, arg, data);
                }
                catch (ServiceSpecificException se) {
                    MediaCasException.throwExceptionIfNeeded(se.errorCode);
                }
            } else {
                MediaCasException.throwExceptionIfNeeded(this.mICasHidl.sendEvent(event, arg, this.toByteArray(data)));
            }
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
    }

    public void provision(@NonNull String provisionString) throws MediaCasException {
        this.validateInternalStates();
        try {
            if (this.mICas != null) {
                try {
                    this.mICas.provision(provisionString);
                }
                catch (ServiceSpecificException se) {
                    MediaCasException.throwExceptionIfNeeded(se.errorCode);
                }
            } else {
                MediaCasException.throwExceptionIfNeeded(this.mICasHidl.provision(provisionString));
            }
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
    }

    public void refreshEntitlements(int refreshType, @Nullable byte[] refreshData) throws MediaCasException {
        this.validateInternalStates();
        try {
            if (this.mICas != null) {
                try {
                    if (refreshData == null) {
                        refreshData = new byte[]{};
                    }
                    this.mICas.refreshEntitlements(refreshType, refreshData);
                }
                catch (ServiceSpecificException se) {
                    MediaCasException.throwExceptionIfNeeded(se.errorCode);
                }
            } else {
                MediaCasException.throwExceptionIfNeeded(this.mICasHidl.refreshEntitlements(refreshType, this.toByteArray(refreshData)));
            }
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
    }

    public void forceResourceLost() {
        if (this.mResourceListener != null) {
            this.mResourceListener.onReclaimResources();
        }
    }

    @Override
    public void close() {
        if (this.mICas != null) {
            try {
                this.mICas.release();
            }
            catch (RemoteException remoteException) {
            }
            finally {
                this.mICas = null;
            }
        } else if (this.mICasHidl != null) {
            try {
                this.mICasHidl.release();
            }
            catch (RemoteException remoteException) {
            }
            finally {
                this.mICasHidl12 = null;
                this.mICasHidl11 = null;
                this.mICasHidl = null;
            }
        }
        if (this.mTunerResourceManager != null) {
            this.mTunerResourceManager.unregisterClientProfile(this.mClientId);
            this.mTunerResourceManager = null;
        }
        if (this.mHandlerThread != null) {
            this.mHandlerThread.quit();
            this.mHandlerThread = null;
        }
    }

    protected void finalize() {
        this.close();
    }

    public class Session
    implements AutoCloseable {
        final byte[] mSessionId;
        boolean mIsClosed = false;

        Session(byte[] sessionId) {
            this.mSessionId = sessionId;
        }

        private void validateSessionInternalStates() {
            if (MediaCas.this.mICas == null && MediaCas.this.mICasHidl == null) {
                throw new IllegalStateException();
            }
            if (this.mIsClosed) {
                MediaCasStateException.throwExceptionIfNeeded(3);
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof Session) {
                return Arrays.equals(this.mSessionId, ((Session)obj).mSessionId);
            }
            return false;
        }

        public void setPrivateData(@NonNull byte[] data) throws MediaCasException {
            this.validateSessionInternalStates();
            try {
                if (MediaCas.this.mICas != null) {
                    try {
                        MediaCas.this.mICas.setSessionPrivateData(this.mSessionId, data);
                    }
                    catch (ServiceSpecificException se) {
                        MediaCasException.throwExceptionIfNeeded(se.errorCode);
                    }
                } else {
                    MediaCasException.throwExceptionIfNeeded(MediaCas.this.mICasHidl.setSessionPrivateData(MediaCas.this.toByteArray(this.mSessionId), MediaCas.this.toByteArray(data, 0, data.length)));
                }
            }
            catch (RemoteException e) {
                MediaCas.this.cleanupAndRethrowIllegalState();
            }
        }

        public void processEcm(@NonNull byte[] data, int offset, int length) throws MediaCasException {
            this.validateSessionInternalStates();
            try {
                if (MediaCas.this.mICas != null) {
                    try {
                        MediaCas.this.mICas.processEcm(this.mSessionId, Arrays.copyOfRange(data, offset, length + offset));
                    }
                    catch (ServiceSpecificException se) {
                        MediaCasException.throwExceptionIfNeeded(se.errorCode);
                    }
                } else {
                    MediaCasException.throwExceptionIfNeeded(MediaCas.this.mICasHidl.processEcm(MediaCas.this.toByteArray(this.mSessionId), MediaCas.this.toByteArray(data, offset, length)));
                }
            }
            catch (RemoteException e) {
                MediaCas.this.cleanupAndRethrowIllegalState();
            }
        }

        public void processEcm(@NonNull byte[] data) throws MediaCasException {
            this.processEcm(data, 0, data.length);
        }

        public void sendSessionEvent(int event, int arg, @Nullable byte[] data) throws MediaCasException {
            this.validateSessionInternalStates();
            if (MediaCas.this.mICas != null) {
                try {
                    if (data == null) {
                        data = new byte[]{};
                    }
                    MediaCas.this.mICas.sendSessionEvent(this.mSessionId, event, arg, data);
                }
                catch (RemoteException e) {
                    MediaCas.this.cleanupAndRethrowIllegalState();
                }
            } else {
                if (MediaCas.this.mICasHidl11 == null) {
                    Log.d(MediaCas.TAG, "Send Session Event isn't supported by cas@1.0 interface");
                    throw new MediaCasException.UnsupportedCasException("Send Session Event is not supported");
                }
                try {
                    MediaCasException.throwExceptionIfNeeded(MediaCas.this.mICasHidl11.sendSessionEvent(MediaCas.this.toByteArray(this.mSessionId), event, arg, MediaCas.this.toByteArray(data)));
                }
                catch (RemoteException e) {
                    MediaCas.this.cleanupAndRethrowIllegalState();
                }
            }
        }

        @NonNull
        public byte[] getSessionId() {
            this.validateSessionInternalStates();
            return this.mSessionId;
        }

        @Override
        public void close() {
            this.validateSessionInternalStates();
            try {
                if (MediaCas.this.mICas != null) {
                    MediaCas.this.mICas.closeSession(this.mSessionId);
                } else {
                    MediaCasStateException.throwExceptionIfNeeded(MediaCas.this.mICasHidl.closeSession(MediaCas.this.toByteArray(this.mSessionId)));
                }
                this.mIsClosed = true;
                MediaCas.this.removeSessionFromResourceMap(this);
            }
            catch (RemoteException e) {
                MediaCas.this.cleanupAndRethrowIllegalState();
            }
        }
    }

    public static class PluginDescriptor {
        private final int mCASystemId;
        private final String mName;

        private PluginDescriptor() {
            this.mCASystemId = 65535;
            this.mName = null;
        }

        PluginDescriptor(@NonNull AidlCasPluginDescriptor descriptor) {
            this.mCASystemId = descriptor.caSystemId;
            this.mName = descriptor.name;
        }

        PluginDescriptor(@NonNull HidlCasPluginDescriptor descriptor) {
            this.mCASystemId = descriptor.caSystemId;
            this.mName = descriptor.name;
        }

        public int getSystemId() {
            return this.mCASystemId;
        }

        @NonNull
        public String getName() {
            return this.mName;
        }

        public String toString() {
            return "PluginDescriptor {" + this.mCASystemId + ", " + this.mName + "}";
        }
    }

    public static interface EventListener {
        public void onEvent(@NonNull MediaCas var1, int var2, int var3, @Nullable byte[] var4);

        default public void onSessionEvent(@NonNull MediaCas mediaCas, @NonNull Session session, int event, int arg, @Nullable byte[] data) {
            Log.d(MediaCas.TAG, "Received MediaCas Session event");
        }

        default public void onPluginStatusUpdate(@NonNull MediaCas mediaCas, int status, int arg) {
            Log.d(MediaCas.TAG, "Received MediaCas Plugin Status event");
        }

        default public void onResourceLost(@NonNull MediaCas mediaCas) {
            Log.d(MediaCas.TAG, "Received MediaCas Resource Reclaim event");
        }
    }

    private class EventHandler
    extends Handler {
        private static final int MSG_CAS_EVENT = 0;
        private static final int MSG_CAS_SESSION_EVENT = 1;
        private static final int MSG_CAS_STATUS_EVENT = 2;
        private static final int MSG_CAS_RESOURCE_LOST = 3;
        private static final String SESSION_KEY = "sessionId";
        private static final String DATA_KEY = "data";

        public EventHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            if (msg.what == 0) {
                byte[] data = msg.obj == null ? new byte[]{} : (byte[])msg.obj;
                MediaCas.this.mListener.onEvent(MediaCas.this, msg.arg1, msg.arg2, data);
            } else if (msg.what == 1) {
                Bundle bundle = msg.getData();
                byte[] sessionId = bundle.getByteArray(SESSION_KEY);
                byte[] data = bundle.getByteArray(DATA_KEY);
                MediaCas.this.mListener.onSessionEvent(MediaCas.this, MediaCas.this.createFromSessionId(sessionId), msg.arg1, msg.arg2, data);
            } else if (msg.what == 2) {
                if (msg.arg1 == 1 && MediaCas.this.mTunerResourceManager != null) {
                    MediaCas.this.mTunerResourceManager.updateCasInfo(MediaCas.this.mCasSystemId, msg.arg2);
                }
                MediaCas.this.mListener.onPluginStatusUpdate(MediaCas.this, msg.arg1, msg.arg2);
            } else if (msg.what == 3) {
                MediaCas.this.mListener.onResourceLost(MediaCas.this);
            }
        }
    }

    private class OpenSessionCallback
    implements ICas.openSessionCallback {
        public Session mSession;
        public int mStatus;

        private OpenSessionCallback() {
        }

        @Override
        public void onValues(int status, ArrayList<Byte> sessionId) {
            this.mStatus = status;
            this.mSession = MediaCas.this.createFromSessionId(MediaCas.this.toBytes(sessionId));
        }
    }

    private class OpenSession_1_2_Callback
    implements ICas.openSession_1_2Callback {
        public Session mSession;
        public int mStatus;

        private OpenSession_1_2_Callback() {
        }

        @Override
        public void onValues(int status, ArrayList<Byte> sessionId) {
            this.mStatus = status;
            this.mSession = MediaCas.this.createFromSessionId(MediaCas.this.toBytes(sessionId));
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PluginStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SessionUsage {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ScramblingMode {
    }
}

