/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.AudioDeviceAttributes;
import android.media.VolumeInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IAudioDeviceVolumeDispatcher
extends IInterface {
    public static final String DESCRIPTOR = "android.media.IAudioDeviceVolumeDispatcher";

    public void dispatchDeviceVolumeChanged(AudioDeviceAttributes var1, VolumeInfo var2) throws RemoteException;

    public void dispatchDeviceVolumeAdjusted(AudioDeviceAttributes var1, VolumeInfo var2, int var3, int var4) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAudioDeviceVolumeDispatcher {
        static final int TRANSACTION_dispatchDeviceVolumeChanged = 1;
        static final int TRANSACTION_dispatchDeviceVolumeAdjusted = 2;

        public Stub() {
            this.attachInterface(this, IAudioDeviceVolumeDispatcher.DESCRIPTOR);
        }

        public static IAudioDeviceVolumeDispatcher asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IAudioDeviceVolumeDispatcher.DESCRIPTOR);
            if (iin != null && iin instanceof IAudioDeviceVolumeDispatcher) {
                return (IAudioDeviceVolumeDispatcher)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "dispatchDeviceVolumeChanged";
                }
                case 2: {
                    return "dispatchDeviceVolumeAdjusted";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IAudioDeviceVolumeDispatcher.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    VolumeInfo _arg1 = data.readTypedObject(VolumeInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.dispatchDeviceVolumeChanged(_arg0, _arg1);
                    break;
                }
                case 2: {
                    AudioDeviceAttributes _arg0 = data.readTypedObject(AudioDeviceAttributes.CREATOR);
                    VolumeInfo _arg1 = data.readTypedObject(VolumeInfo.CREATOR);
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.dispatchDeviceVolumeAdjusted(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IAudioDeviceVolumeDispatcher {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IAudioDeviceVolumeDispatcher.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchDeviceVolumeChanged(AudioDeviceAttributes device, VolumeInfo vol) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IAudioDeviceVolumeDispatcher.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(vol, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchDeviceVolumeAdjusted(AudioDeviceAttributes device, VolumeInfo vol, int direction, int mode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IAudioDeviceVolumeDispatcher.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(vol, 0);
                    _data.writeInt(direction);
                    _data.writeInt(mode);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IAudioDeviceVolumeDispatcher {
        @Override
        public void dispatchDeviceVolumeChanged(AudioDeviceAttributes device, VolumeInfo vol) throws RemoteException {
        }

        @Override
        public void dispatchDeviceVolumeAdjusted(AudioDeviceAttributes device, VolumeInfo vol, int direction, int mode) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

