/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.media.AudioAttributes;
import android.media.AudioDeviceAttributes;
import android.media.CallbackUtil;
import android.media.IAudioDeviceVolumeDispatcher;
import android.media.IAudioService;
import android.media.IDeviceVolumeBehaviorDispatcher;
import android.media.VolumeInfo;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import com.android.internal.annotations.GuardedBy;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

@SystemApi
public class AudioDeviceVolumeManager {
    private static final String TAG = "AudioDeviceVolumeManager";
    public static final int DEVICE_VOLUME_BEHAVIOR_UNSET = -1;
    @SystemApi
    @FlaggedApi(value="android.media.audio.unify_absolute_volume_management")
    public static final int DEVICE_VOLUME_BEHAVIOR_VARIABLE = 0;
    @SystemApi
    @FlaggedApi(value="android.media.audio.unify_absolute_volume_management")
    public static final int DEVICE_VOLUME_BEHAVIOR_FULL = 1;
    @SystemApi
    @FlaggedApi(value="android.media.audio.unify_absolute_volume_management")
    public static final int DEVICE_VOLUME_BEHAVIOR_FIXED = 2;
    @SystemApi
    @FlaggedApi(value="android.media.audio.unify_absolute_volume_management")
    public static final int DEVICE_VOLUME_BEHAVIOR_ABSOLUTE = 3;
    @SystemApi
    @FlaggedApi(value="android.media.audio.unify_absolute_volume_management")
    public static final int DEVICE_VOLUME_BEHAVIOR_ABSOLUTE_MULTI_MODE = 4;
    @SystemApi
    @FlaggedApi(value="android.media.audio.unify_absolute_volume_management")
    public static final int DEVICE_VOLUME_BEHAVIOR_ABSOLUTE_ADJUST_ONLY = 5;
    public static final int ADJUST_MODE_NORMAL = 0;
    public static final int ADJUST_MODE_START = 1;
    public static final int ADJUST_MODE_END = 2;
    private static IAudioService sService;
    @NonNull
    private final String mPackageName;
    private final Object mDeviceVolumeListenerLock = new Object();
    @GuardedBy(value={"mDeviceVolumeListenerLock"})
    @Nullable
    private ArrayList<ListenerInfo> mDeviceVolumeListeners;
    @GuardedBy(value={"mDeviceVolumeListenerLock"})
    private DeviceVolumeDispatcherStub mDeviceVolumeDispatcherStub;
    private final CallbackUtil.LazyListenerManager<OnDeviceVolumeBehaviorChangedListener> mDeviceVolumeBehaviorChangedListenerMgr = new CallbackUtil.LazyListenerManager();

    public static void enforceValidVolumeBehavior(int volumeBehavior) {
        switch (volumeBehavior) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return;
            }
        }
        throw new IllegalArgumentException("Illegal volume behavior " + volumeBehavior);
    }

    public AudioDeviceVolumeManager(@NonNull Context context) {
        Objects.requireNonNull(context);
        this.mPackageName = context.getApplicationContext().getOpPackageName();
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED"})
    @FlaggedApi(value="android.media.audio.unify_absolute_volume_management")
    public void setDeviceVolumeBehavior(@NonNull AudioDeviceAttributes device, int deviceVolumeBehavior) {
        Objects.requireNonNull(device);
        AudioDeviceVolumeManager.enforceValidVolumeBehavior(deviceVolumeBehavior);
        IAudioService service = AudioDeviceVolumeManager.getService();
        try {
            service.setDeviceVolumeBehavior(device, deviceVolumeBehavior, this.mPackageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.QUERY_AUDIO_STATE", "android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED"})
    @FlaggedApi(value="android.media.audio.unify_absolute_volume_management")
    public int getDeviceVolumeBehavior(@NonNull AudioDeviceAttributes device) {
        Objects.requireNonNull(device);
        IAudioService service = AudioDeviceVolumeManager.getService();
        try {
            return service.getDeviceVolumeBehavior(device);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.QUERY_AUDIO_STATE", "android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED"})
    public boolean isFullVolumeDevice() {
        List<AudioDeviceAttributes> devices;
        AudioAttributes attributes = new AudioAttributes.Builder().setUsage(1).build();
        IAudioService service = AudioDeviceVolumeManager.getService();
        try {
            devices = service.getDevicesForAttributes(attributes);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        for (AudioDeviceAttributes device : devices) {
            if (this.getDeviceVolumeBehavior(device) != 1) continue;
            return true;
        }
        return false;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", "android.permission.BLUETOOTH_PRIVILEGED", "android.permission.BLUETOOTH_STACK"})
    @FlaggedApi(value="android.media.audio.unify_absolute_volume_management")
    public void setDeviceAbsoluteVolumeBehavior(@NonNull AudioDeviceAttributes device, @NonNull VolumeInfo volume, @NonNull Executor executor, @NonNull OnAudioDeviceVolumeChangedListener vclistener) {
        this.setDeviceAbsoluteVolumeBehavior(device, volume, false, executor, vclistener);
    }

    @RequiresPermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void setDeviceAbsoluteVolumeBehavior(@NonNull AudioDeviceAttributes device, @NonNull VolumeInfo volume, boolean handlesVolumeAdjustment, @NonNull Executor executor, @NonNull OnAudioDeviceVolumeChangedListener vclistener) {
        ArrayList<VolumeInfo> volumes = new ArrayList<VolumeInfo>(1);
        volumes.add(volume);
        this.setDeviceAbsoluteMultiVolumeBehavior(device, volumes, handlesVolumeAdjustment, executor, vclistener);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED", "android.permission.BLUETOOTH_PRIVILEGED", "android.permission.BLUETOOTH_STACK"})
    @FlaggedApi(value="android.media.audio.unify_absolute_volume_management")
    public void setDeviceAbsoluteMultiVolumeBehavior(@NonNull AudioDeviceAttributes device, @NonNull List<VolumeInfo> volumes, @NonNull Executor executor, @NonNull OnAudioDeviceVolumeChangedListener vclistener) {
        this.setDeviceAbsoluteMultiVolumeBehavior(device, volumes, false, executor, vclistener);
    }

    @RequiresPermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void setDeviceAbsoluteMultiVolumeBehavior(@NonNull AudioDeviceAttributes device, @NonNull List<VolumeInfo> volumes, boolean handlesVolumeAdjustment, @NonNull Executor executor, @NonNull OnAudioDeviceVolumeChangedListener vclistener) {
        this.baseSetDeviceAbsoluteMultiVolumeBehavior(device, volumes, executor, vclistener, handlesVolumeAdjustment, 3);
    }

    @RequiresPermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void setDeviceAbsoluteVolumeAdjustOnlyBehavior(@NonNull AudioDeviceAttributes device, @NonNull VolumeInfo volume, boolean handlesVolumeAdjustment, @NonNull Executor executor, @NonNull OnAudioDeviceVolumeChangedListener vclistener) {
        ArrayList<VolumeInfo> volumes = new ArrayList<VolumeInfo>(1);
        volumes.add(volume);
        this.setDeviceAbsoluteMultiVolumeAdjustOnlyBehavior(device, volumes, handlesVolumeAdjustment, executor, vclistener);
    }

    @RequiresPermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void setDeviceAbsoluteMultiVolumeAdjustOnlyBehavior(@NonNull AudioDeviceAttributes device, @NonNull List<VolumeInfo> volumes, boolean handlesVolumeAdjustment, @NonNull Executor executor, @NonNull OnAudioDeviceVolumeChangedListener vclistener) {
        this.baseSetDeviceAbsoluteMultiVolumeBehavior(device, volumes, executor, vclistener, handlesVolumeAdjustment, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.BLUETOOTH_PRIVILEGED"})
    private void baseSetDeviceAbsoluteMultiVolumeBehavior(@NonNull AudioDeviceAttributes device, @NonNull List<VolumeInfo> volumes, @NonNull Executor executor, @NonNull OnAudioDeviceVolumeChangedListener vclistener, boolean handlesVolumeAdjustment, int behavior) {
        Objects.requireNonNull(device);
        Objects.requireNonNull(volumes);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(vclistener);
        ListenerInfo listenerInfo = new ListenerInfo(vclistener, executor, device, handlesVolumeAdjustment);
        Object object = this.mDeviceVolumeListenerLock;
        synchronized (object) {
            if (this.mDeviceVolumeListeners == null) {
                this.mDeviceVolumeListeners = new ArrayList();
            }
            if (this.mDeviceVolumeListeners.size() == 0) {
                if (this.mDeviceVolumeDispatcherStub == null) {
                    this.mDeviceVolumeDispatcherStub = new DeviceVolumeDispatcherStub();
                }
            } else {
                this.mDeviceVolumeListeners.removeIf(info -> info.mDevice.equalTypeAddress(device));
            }
            this.mDeviceVolumeListeners.add(listenerInfo);
            this.mDeviceVolumeDispatcherStub.register(true, device, volumes, handlesVolumeAdjustment, behavior);
        }
    }

    @RequiresPermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.QUERY_AUDIO_STATE"})
    public void addOnDeviceVolumeBehaviorChangedListener(@NonNull Executor executor, @NonNull OnDeviceVolumeBehaviorChangedListener listener) throws SecurityException {
        this.mDeviceVolumeBehaviorChangedListenerMgr.addListener(executor, listener, "addOnDeviceVolumeBehaviorChangedListener", () -> new DeviceVolumeBehaviorDispatcherStub());
    }

    @RequiresPermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.QUERY_AUDIO_STATE"})
    public void removeOnDeviceVolumeBehaviorChangedListener(@NonNull OnDeviceVolumeBehaviorChangedListener listener) {
        this.mDeviceVolumeBehaviorChangedListenerMgr.removeListener(listener, "removeOnDeviceVolumeBehaviorChangedListener");
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED"})
    public void setDeviceVolume(@NonNull VolumeInfo vi, @NonNull AudioDeviceAttributes ada) {
        try {
            AudioDeviceVolumeManager.getService().setDeviceVolume(vi, ada, this.mPackageName);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED"})
    @NonNull
    public VolumeInfo getDeviceVolume(@NonNull VolumeInfo vi, @NonNull AudioDeviceAttributes ada) {
        try {
            return AudioDeviceVolumeManager.getService().getDeviceVolume(vi, ada, this.mPackageName);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return VolumeInfo.getDefaultVolumeInfo();
        }
    }

    @FlaggedApi(value="com.android.media.flags.enable_audio_input_device_routing_and_volume_control")
    @RequiresPermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public void setInputGainIndex(@NonNull AudioDeviceAttributes ada, int index) {
        try {
            AudioDeviceVolumeManager.getService().setInputGainIndex(ada, index);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="com.android.media.flags.enable_audio_input_device_routing_and_volume_control")
    @RequiresPermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public int getInputGainIndex(@NonNull AudioDeviceAttributes ada) {
        try {
            return AudioDeviceVolumeManager.getService().getInputGainIndex(ada);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="com.android.media.flags.enable_audio_input_device_routing_and_volume_control")
    @RequiresPermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public int getMaxInputGainIndex() {
        try {
            return AudioDeviceVolumeManager.getService().getMaxInputGainIndex();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="com.android.media.flags.enable_audio_input_device_routing_and_volume_control")
    @RequiresPermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public int getMinInputGainIndex() {
        try {
            return AudioDeviceVolumeManager.getService().getMinInputGainIndex();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="com.android.media.flags.enable_audio_input_device_routing_and_volume_control")
    @RequiresPermission(value="android.permission.MODIFY_AUDIO_SETTINGS_PRIVILEGED")
    public boolean isInputGainFixed(@NonNull AudioDeviceAttributes ada) {
        try {
            return AudioDeviceVolumeManager.getService().isInputGainFixed(ada);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static String volumeBehaviorName(int behavior) {
        switch (behavior) {
            case 0: {
                return "DEVICE_VOLUME_BEHAVIOR_VARIABLE";
            }
            case 1: {
                return "DEVICE_VOLUME_BEHAVIOR_FULL";
            }
            case 2: {
                return "DEVICE_VOLUME_BEHAVIOR_FIXED";
            }
            case 3: {
                return "DEVICE_VOLUME_BEHAVIOR_ABSOLUTE";
            }
            case 4: {
                return "DEVICE_VOLUME_BEHAVIOR_ABSOLUTE_MULTI_MODE";
            }
            case 5: {
                return "DEVICE_VOLUME_BEHAVIOR_ABSOLUTE_ADJUST_ONLY";
            }
        }
        return "invalid volume behavior " + behavior;
    }

    private static IAudioService getService() {
        if (sService != null) {
            return sService;
        }
        IBinder b = ServiceManager.getService("audio");
        sService = IAudioService.Stub.asInterface(b);
        return sService;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FlaggedApi(value="android.media.audio.unify_absolute_volume_management")
    public static interface OnAudioDeviceVolumeChangedListener {
        public void onAudioDeviceVolumeChanged(@NonNull AudioDeviceAttributes var1, @NonNull VolumeInfo var2);

        public void onAudioDeviceVolumeAdjusted(@NonNull AudioDeviceAttributes var1, @NonNull VolumeInfo var2, int var3, int var4);
    }

    static class ListenerInfo {
        @NonNull
        final OnAudioDeviceVolumeChangedListener mListener;
        @NonNull
        final Executor mExecutor;
        @NonNull
        final AudioDeviceAttributes mDevice;
        @NonNull
        final boolean mHandlesVolumeAdjustment;

        ListenerInfo(@NonNull OnAudioDeviceVolumeChangedListener listener, @NonNull Executor exe, @NonNull AudioDeviceAttributes device, boolean handlesVolumeAdjustment) {
            this.mListener = listener;
            this.mExecutor = exe;
            this.mDevice = device;
            this.mHandlesVolumeAdjustment = handlesVolumeAdjustment;
        }
    }

    class DeviceVolumeDispatcherStub
    extends IAudioDeviceVolumeDispatcher.Stub {
        DeviceVolumeDispatcherStub() {
        }

        @RequiresPermission(anyOf={"android.permission.MODIFY_AUDIO_ROUTING", "android.permission.BLUETOOTH_PRIVILEGED"})
        public void register(boolean register, @NonNull AudioDeviceAttributes device, @NonNull List<VolumeInfo> volumes, boolean handlesVolumeAdjustment, int behavior) {
            try {
                AudioDeviceVolumeManager.getService().registerDeviceVolumeDispatcherForAbsoluteVolume(register, this, AudioDeviceVolumeManager.this.mPackageName, Objects.requireNonNull(device), Objects.requireNonNull(volumes), handlesVolumeAdjustment, behavior);
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatchDeviceVolumeChanged(@NonNull AudioDeviceAttributes device, @NonNull VolumeInfo vol) {
            ArrayList volumeListeners;
            Iterator iterator = AudioDeviceVolumeManager.this.mDeviceVolumeListenerLock;
            synchronized (iterator) {
                volumeListeners = (ArrayList)AudioDeviceVolumeManager.this.mDeviceVolumeListeners.clone();
            }
            for (ListenerInfo listenerInfo : volumeListeners) {
                if (!listenerInfo.mDevice.equalTypeAddress(device)) continue;
                listenerInfo.mExecutor.execute(() -> listenerInfo.mListener.onAudioDeviceVolumeChanged(device, vol));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatchDeviceVolumeAdjusted(@NonNull AudioDeviceAttributes device, @NonNull VolumeInfo vol, int direction, int mode) {
            ArrayList volumeListeners;
            Iterator iterator = AudioDeviceVolumeManager.this.mDeviceVolumeListenerLock;
            synchronized (iterator) {
                volumeListeners = (ArrayList)AudioDeviceVolumeManager.this.mDeviceVolumeListeners.clone();
            }
            for (ListenerInfo listenerInfo : volumeListeners) {
                if (!listenerInfo.mDevice.equalTypeAddress(device)) continue;
                listenerInfo.mExecutor.execute(() -> listenerInfo.mListener.onAudioDeviceVolumeAdjusted(device, vol, direction, mode));
            }
        }
    }

    private class DeviceVolumeBehaviorDispatcherStub
    extends IDeviceVolumeBehaviorDispatcher.Stub
    implements CallbackUtil.DispatcherStub {
        private DeviceVolumeBehaviorDispatcherStub() {
        }

        @Override
        public void register(boolean register) {
            try {
                AudioDeviceVolumeManager.getService().registerDeviceVolumeBehaviorDispatcher(register, this);
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }

        @Override
        public void dispatchDeviceVolumeBehaviorChanged(@NonNull AudioDeviceAttributes device, int volumeBehavior) {
            AudioDeviceVolumeManager.this.mDeviceVolumeBehaviorChangedListenerMgr.callListeners(listener -> listener.onDeviceVolumeBehaviorChanged(device, volumeBehavior));
        }
    }

    public static interface OnDeviceVolumeBehaviorChangedListener {
        public void onDeviceVolumeBehaviorChanged(@NonNull AudioDeviceAttributes var1, int var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VolumeAdjustmentMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AbsoluteDeviceVolumeBehavior {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeviceVolumeBehaviorState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeviceVolumeBehavior {
    }
}

