/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.annotation.Nullable;
import android.location.Criteria;
import android.location.provider.ProviderProperties;

@Deprecated
public class LocationProvider {
    @Deprecated
    public static final int OUT_OF_SERVICE = 0;
    @Deprecated
    public static final int TEMPORARILY_UNAVAILABLE = 1;
    @Deprecated
    public static final int AVAILABLE = 2;
    private final String mName;
    @Nullable
    private final ProviderProperties mProperties;

    LocationProvider(String name, @Nullable ProviderProperties properties) {
        this.mName = name;
        this.mProperties = properties;
    }

    public String getName() {
        return this.mName;
    }

    public boolean meetsCriteria(Criteria criteria) {
        return LocationProvider.propertiesMeetCriteria(this.mName, this.mProperties, criteria);
    }

    public static boolean propertiesMeetCriteria(String name, ProviderProperties properties, Criteria criteria) {
        if ("passive".equals(name)) {
            return false;
        }
        if (properties == null) {
            return false;
        }
        if (criteria.getAccuracy() != 0 && criteria.getAccuracy() < properties.getAccuracy()) {
            return false;
        }
        if (criteria.getPowerRequirement() != 0 && criteria.getPowerRequirement() < properties.getPowerUsage()) {
            return false;
        }
        if (criteria.isAltitudeRequired() && !properties.hasAltitudeSupport()) {
            return false;
        }
        if (criteria.isSpeedRequired() && !properties.hasSpeedSupport()) {
            return false;
        }
        if (criteria.isBearingRequired() && !properties.hasBearingSupport()) {
            return false;
        }
        return criteria.isCostAllowed() || !properties.hasMonetaryCost();
    }

    public boolean requiresNetwork() {
        if (this.mProperties == null) {
            return false;
        }
        return this.mProperties.hasNetworkRequirement();
    }

    public boolean requiresSatellite() {
        if (this.mProperties == null) {
            return false;
        }
        return this.mProperties.hasSatelliteRequirement();
    }

    public boolean requiresCell() {
        if (this.mProperties == null) {
            return false;
        }
        return this.mProperties.hasCellRequirement();
    }

    public boolean hasMonetaryCost() {
        if (this.mProperties == null) {
            return false;
        }
        return this.mProperties.hasMonetaryCost();
    }

    public boolean supportsAltitude() {
        if (this.mProperties == null) {
            return false;
        }
        return this.mProperties.hasAltitudeSupport();
    }

    public boolean supportsSpeed() {
        if (this.mProperties == null) {
            return false;
        }
        return this.mProperties.hasSpeedSupport();
    }

    public boolean supportsBearing() {
        if (this.mProperties == null) {
            return false;
        }
        return this.mProperties.hasBearingSupport();
    }

    public int getPowerRequirement() {
        if (this.mProperties == null) {
            return 3;
        }
        return this.mProperties.getPowerUsage();
    }

    public int getAccuracy() {
        if (this.mProperties == null) {
            return 2;
        }
        return this.mProperties.getAccuracy();
    }
}

