/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.annotation.EnforcePermission;
import android.app.ActivityThread;
import android.app.PendingIntent;
import android.location.Criteria;
import android.location.Geofence;
import android.location.GnssAntennaInfo;
import android.location.GnssCapabilities;
import android.location.GnssMeasurementCorrections;
import android.location.GnssMeasurementRequest;
import android.location.IGnssAntennaInfoListener;
import android.location.IGnssMeasurementsListener;
import android.location.IGnssNavigationMessageListener;
import android.location.IGnssNmeaListener;
import android.location.IGnssStatusListener;
import android.location.ILocationCallback;
import android.location.ILocationListener;
import android.location.LastLocationRequest;
import android.location.Location;
import android.location.LocationRequest;
import android.location.LocationTime;
import android.location.provider.ForwardGeocodeRequest;
import android.location.provider.IGeocodeCallback;
import android.location.provider.IProviderRequestListener;
import android.location.provider.ProviderProperties;
import android.location.provider.ReverseGeocodeRequest;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.ICancellationSignal;
import android.os.IInterface;
import android.os.PackageTagsList;
import android.os.Parcel;
import android.os.PermissionEnforcer;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface ILocationManager
extends IInterface {
    public Location getLastLocation(String var1, LastLocationRequest var2, String var3, String var4) throws RemoteException;

    public ICancellationSignal getCurrentLocation(String var1, LocationRequest var2, ILocationCallback var3, String var4, String var5, String var6) throws RemoteException;

    public void registerLocationListener(String var1, LocationRequest var2, ILocationListener var3, String var4, String var5, String var6) throws RemoteException;

    public void unregisterLocationListener(ILocationListener var1) throws RemoteException;

    public void registerLocationPendingIntent(String var1, LocationRequest var2, PendingIntent var3, String var4, String var5) throws RemoteException;

    public void unregisterLocationPendingIntent(PendingIntent var1) throws RemoteException;

    @EnforcePermission(allOf={"android.permission.LOCATION_HARDWARE", "android.permission.ACCESS_FINE_LOCATION"})
    public void injectLocation(Location var1) throws RemoteException;

    public void requestListenerFlush(String var1, ILocationListener var2, int var3) throws RemoteException;

    public void requestPendingIntentFlush(String var1, PendingIntent var2, int var3) throws RemoteException;

    public void requestGeofence(Geofence var1, PendingIntent var2, String var3, String var4) throws RemoteException;

    public void removeGeofence(PendingIntent var1) throws RemoteException;

    public boolean isGeocodeAvailable() throws RemoteException;

    public void reverseGeocode(ReverseGeocodeRequest var1, IGeocodeCallback var2) throws RemoteException;

    public void forwardGeocode(ForwardGeocodeRequest var1, IGeocodeCallback var2) throws RemoteException;

    public GnssCapabilities getGnssCapabilities() throws RemoteException;

    public int getGnssYearOfHardware() throws RemoteException;

    public String getGnssHardwareModelName() throws RemoteException;

    public List<GnssAntennaInfo> getGnssAntennaInfos() throws RemoteException;

    public void registerGnssStatusCallback(IGnssStatusListener var1, String var2, String var3, String var4) throws RemoteException;

    public void unregisterGnssStatusCallback(IGnssStatusListener var1) throws RemoteException;

    public void registerGnssNmeaCallback(IGnssNmeaListener var1, String var2, String var3, String var4) throws RemoteException;

    public void unregisterGnssNmeaCallback(IGnssNmeaListener var1) throws RemoteException;

    public void addGnssMeasurementsListener(GnssMeasurementRequest var1, IGnssMeasurementsListener var2, String var3, String var4, String var5) throws RemoteException;

    public void removeGnssMeasurementsListener(IGnssMeasurementsListener var1) throws RemoteException;

    public void injectGnssMeasurementCorrections(GnssMeasurementCorrections var1) throws RemoteException;

    public void addGnssNavigationMessageListener(IGnssNavigationMessageListener var1, String var2, String var3, String var4) throws RemoteException;

    public void removeGnssNavigationMessageListener(IGnssNavigationMessageListener var1) throws RemoteException;

    public void addGnssAntennaInfoListener(IGnssAntennaInfoListener var1, String var2, String var3, String var4) throws RemoteException;

    public void removeGnssAntennaInfoListener(IGnssAntennaInfoListener var1) throws RemoteException;

    @EnforcePermission(value="android.permission.INTERACT_ACROSS_USERS")
    public void addProviderRequestListener(IProviderRequestListener var1) throws RemoteException;

    public void removeProviderRequestListener(IProviderRequestListener var1) throws RemoteException;

    public int getGnssBatchSize() throws RemoteException;

    @EnforcePermission(value="android.permission.LOCATION_HARDWARE")
    public void startGnssBatch(long var1, ILocationListener var3, String var4, String var5, String var6) throws RemoteException;

    @EnforcePermission(value="android.permission.LOCATION_HARDWARE")
    public void flushGnssBatch() throws RemoteException;

    @EnforcePermission(value="android.permission.LOCATION_HARDWARE")
    public void stopGnssBatch() throws RemoteException;

    public boolean hasProvider(String var1) throws RemoteException;

    public List<String> getAllProviders() throws RemoteException;

    public List<String> getProviders(Criteria var1, boolean var2) throws RemoteException;

    public String getBestProvider(Criteria var1, boolean var2) throws RemoteException;

    public ProviderProperties getProviderProperties(String var1) throws RemoteException;

    @EnforcePermission(value="android.permission.READ_DEVICE_CONFIG")
    public boolean isProviderPackage(String var1, String var2, String var3) throws RemoteException;

    @EnforcePermission(value="android.permission.READ_DEVICE_CONFIG")
    public List<String> getProviderPackages(String var1) throws RemoteException;

    @EnforcePermission(value="android.permission.LOCATION_HARDWARE")
    public void setExtraLocationControllerPackage(String var1) throws RemoteException;

    public String getExtraLocationControllerPackage() throws RemoteException;

    @EnforcePermission(value="android.permission.LOCATION_HARDWARE")
    public void setExtraLocationControllerPackageEnabled(boolean var1) throws RemoteException;

    public boolean isExtraLocationControllerPackageEnabled() throws RemoteException;

    public boolean isProviderEnabledForUser(String var1, int var2) throws RemoteException;

    public boolean isLocationEnabledForUser(int var1) throws RemoteException;

    public void setLocationEnabledForUser(boolean var1, int var2) throws RemoteException;

    public boolean isAdasGnssLocationEnabledForUser(int var1) throws RemoteException;

    public void setAdasGnssLocationEnabledForUser(boolean var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.CONTROL_AUTOMOTIVE_GNSS")
    public boolean isAutomotiveGnssSuspended() throws RemoteException;

    @EnforcePermission(value="android.permission.CONTROL_AUTOMOTIVE_GNSS")
    public void setAutomotiveGnssSuspended(boolean var1) throws RemoteException;

    public void addTestProvider(String var1, ProviderProperties var2, List<String> var3, String var4, String var5) throws RemoteException;

    public void removeTestProvider(String var1, String var2, String var3) throws RemoteException;

    public void setTestProviderLocation(String var1, Location var2, String var3, String var4) throws RemoteException;

    public void setTestProviderEnabled(String var1, boolean var2, String var3, String var4) throws RemoteException;

    public LocationTime getGnssTimeMillis() throws RemoteException;

    public void sendExtraCommand(String var1, String var2, Bundle var3) throws RemoteException;

    public String[] getBackgroundThrottlingWhitelist() throws RemoteException;

    public PackageTagsList getIgnoreSettingsAllowlist() throws RemoteException;

    public PackageTagsList getAdasAllowlist() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ILocationManager {
        private final PermissionEnforcer mEnforcer;
        public static final String DESCRIPTOR = "android.location.ILocationManager";
        static final int TRANSACTION_getLastLocation = 1;
        static final int TRANSACTION_getCurrentLocation = 2;
        static final int TRANSACTION_registerLocationListener = 3;
        static final int TRANSACTION_unregisterLocationListener = 4;
        static final int TRANSACTION_registerLocationPendingIntent = 5;
        static final int TRANSACTION_unregisterLocationPendingIntent = 6;
        static final int TRANSACTION_injectLocation = 7;
        static final String[] PERMISSIONS_injectLocation = new String[]{"android.permission.LOCATION_HARDWARE", "android.permission.ACCESS_FINE_LOCATION"};
        static final int TRANSACTION_requestListenerFlush = 8;
        static final int TRANSACTION_requestPendingIntentFlush = 9;
        static final int TRANSACTION_requestGeofence = 10;
        static final int TRANSACTION_removeGeofence = 11;
        static final int TRANSACTION_isGeocodeAvailable = 12;
        static final int TRANSACTION_reverseGeocode = 13;
        static final int TRANSACTION_forwardGeocode = 14;
        static final int TRANSACTION_getGnssCapabilities = 15;
        static final int TRANSACTION_getGnssYearOfHardware = 16;
        static final int TRANSACTION_getGnssHardwareModelName = 17;
        static final int TRANSACTION_getGnssAntennaInfos = 18;
        static final int TRANSACTION_registerGnssStatusCallback = 19;
        static final int TRANSACTION_unregisterGnssStatusCallback = 20;
        static final int TRANSACTION_registerGnssNmeaCallback = 21;
        static final int TRANSACTION_unregisterGnssNmeaCallback = 22;
        static final int TRANSACTION_addGnssMeasurementsListener = 23;
        static final int TRANSACTION_removeGnssMeasurementsListener = 24;
        static final int TRANSACTION_injectGnssMeasurementCorrections = 25;
        static final int TRANSACTION_addGnssNavigationMessageListener = 26;
        static final int TRANSACTION_removeGnssNavigationMessageListener = 27;
        static final int TRANSACTION_addGnssAntennaInfoListener = 28;
        static final int TRANSACTION_removeGnssAntennaInfoListener = 29;
        static final int TRANSACTION_addProviderRequestListener = 30;
        static final int TRANSACTION_removeProviderRequestListener = 31;
        static final int TRANSACTION_getGnssBatchSize = 32;
        static final int TRANSACTION_startGnssBatch = 33;
        static final int TRANSACTION_flushGnssBatch = 34;
        static final int TRANSACTION_stopGnssBatch = 35;
        static final int TRANSACTION_hasProvider = 36;
        static final int TRANSACTION_getAllProviders = 37;
        static final int TRANSACTION_getProviders = 38;
        static final int TRANSACTION_getBestProvider = 39;
        static final int TRANSACTION_getProviderProperties = 40;
        static final int TRANSACTION_isProviderPackage = 41;
        static final int TRANSACTION_getProviderPackages = 42;
        static final int TRANSACTION_setExtraLocationControllerPackage = 43;
        static final int TRANSACTION_getExtraLocationControllerPackage = 44;
        static final int TRANSACTION_setExtraLocationControllerPackageEnabled = 45;
        static final int TRANSACTION_isExtraLocationControllerPackageEnabled = 46;
        static final int TRANSACTION_isProviderEnabledForUser = 47;
        static final int TRANSACTION_isLocationEnabledForUser = 48;
        static final int TRANSACTION_setLocationEnabledForUser = 49;
        static final int TRANSACTION_isAdasGnssLocationEnabledForUser = 50;
        static final int TRANSACTION_setAdasGnssLocationEnabledForUser = 51;
        static final int TRANSACTION_isAutomotiveGnssSuspended = 52;
        static final int TRANSACTION_setAutomotiveGnssSuspended = 53;
        static final int TRANSACTION_addTestProvider = 54;
        static final int TRANSACTION_removeTestProvider = 55;
        static final int TRANSACTION_setTestProviderLocation = 56;
        static final int TRANSACTION_setTestProviderEnabled = 57;
        static final int TRANSACTION_getGnssTimeMillis = 58;
        static final int TRANSACTION_sendExtraCommand = 59;
        static final int TRANSACTION_getBackgroundThrottlingWhitelist = 60;
        static final int TRANSACTION_getIgnoreSettingsAllowlist = 61;
        static final int TRANSACTION_getAdasAllowlist = 62;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentActivityThread().getSystemContext()));
        }

        public static ILocationManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ILocationManager) {
                return (ILocationManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getLastLocation";
                }
                case 2: {
                    return "getCurrentLocation";
                }
                case 3: {
                    return "registerLocationListener";
                }
                case 4: {
                    return "unregisterLocationListener";
                }
                case 5: {
                    return "registerLocationPendingIntent";
                }
                case 6: {
                    return "unregisterLocationPendingIntent";
                }
                case 7: {
                    return "injectLocation";
                }
                case 8: {
                    return "requestListenerFlush";
                }
                case 9: {
                    return "requestPendingIntentFlush";
                }
                case 10: {
                    return "requestGeofence";
                }
                case 11: {
                    return "removeGeofence";
                }
                case 12: {
                    return "isGeocodeAvailable";
                }
                case 13: {
                    return "reverseGeocode";
                }
                case 14: {
                    return "forwardGeocode";
                }
                case 15: {
                    return "getGnssCapabilities";
                }
                case 16: {
                    return "getGnssYearOfHardware";
                }
                case 17: {
                    return "getGnssHardwareModelName";
                }
                case 18: {
                    return "getGnssAntennaInfos";
                }
                case 19: {
                    return "registerGnssStatusCallback";
                }
                case 20: {
                    return "unregisterGnssStatusCallback";
                }
                case 21: {
                    return "registerGnssNmeaCallback";
                }
                case 22: {
                    return "unregisterGnssNmeaCallback";
                }
                case 23: {
                    return "addGnssMeasurementsListener";
                }
                case 24: {
                    return "removeGnssMeasurementsListener";
                }
                case 25: {
                    return "injectGnssMeasurementCorrections";
                }
                case 26: {
                    return "addGnssNavigationMessageListener";
                }
                case 27: {
                    return "removeGnssNavigationMessageListener";
                }
                case 28: {
                    return "addGnssAntennaInfoListener";
                }
                case 29: {
                    return "removeGnssAntennaInfoListener";
                }
                case 30: {
                    return "addProviderRequestListener";
                }
                case 31: {
                    return "removeProviderRequestListener";
                }
                case 32: {
                    return "getGnssBatchSize";
                }
                case 33: {
                    return "startGnssBatch";
                }
                case 34: {
                    return "flushGnssBatch";
                }
                case 35: {
                    return "stopGnssBatch";
                }
                case 36: {
                    return "hasProvider";
                }
                case 37: {
                    return "getAllProviders";
                }
                case 38: {
                    return "getProviders";
                }
                case 39: {
                    return "getBestProvider";
                }
                case 40: {
                    return "getProviderProperties";
                }
                case 41: {
                    return "isProviderPackage";
                }
                case 42: {
                    return "getProviderPackages";
                }
                case 43: {
                    return "setExtraLocationControllerPackage";
                }
                case 44: {
                    return "getExtraLocationControllerPackage";
                }
                case 45: {
                    return "setExtraLocationControllerPackageEnabled";
                }
                case 46: {
                    return "isExtraLocationControllerPackageEnabled";
                }
                case 47: {
                    return "isProviderEnabledForUser";
                }
                case 48: {
                    return "isLocationEnabledForUser";
                }
                case 49: {
                    return "setLocationEnabledForUser";
                }
                case 50: {
                    return "isAdasGnssLocationEnabledForUser";
                }
                case 51: {
                    return "setAdasGnssLocationEnabledForUser";
                }
                case 52: {
                    return "isAutomotiveGnssSuspended";
                }
                case 53: {
                    return "setAutomotiveGnssSuspended";
                }
                case 54: {
                    return "addTestProvider";
                }
                case 55: {
                    return "removeTestProvider";
                }
                case 56: {
                    return "setTestProviderLocation";
                }
                case 57: {
                    return "setTestProviderEnabled";
                }
                case 58: {
                    return "getGnssTimeMillis";
                }
                case 59: {
                    return "sendExtraCommand";
                }
                case 60: {
                    return "getBackgroundThrottlingWhitelist";
                }
                case 61: {
                    return "getIgnoreSettingsAllowlist";
                }
                case 62: {
                    return "getAdasAllowlist";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    LastLocationRequest _arg1 = data.readTypedObject(LastLocationRequest.CREATOR);
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    Location _result = this.getLastLocation(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    LocationRequest _arg1 = data.readTypedObject(LocationRequest.CREATOR);
                    ILocationCallback _arg2 = ILocationCallback.Stub.asInterface(data.readStrongBinder());
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    String _arg5 = data.readString();
                    data.enforceNoDataAvail();
                    ICancellationSignal _result = this.getCurrentLocation(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    LocationRequest _arg1 = data.readTypedObject(LocationRequest.CREATOR);
                    ILocationListener _arg2 = ILocationListener.Stub.asInterface(data.readStrongBinder());
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    String _arg5 = data.readString();
                    data.enforceNoDataAvail();
                    this.registerLocationListener(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    ILocationListener _arg0 = ILocationListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterLocationListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    LocationRequest _arg1 = data.readTypedObject(LocationRequest.CREATOR);
                    PendingIntent _arg2 = data.readTypedObject(PendingIntent.CREATOR);
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.registerLocationPendingIntent(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    PendingIntent _arg0 = data.readTypedObject(PendingIntent.CREATOR);
                    data.enforceNoDataAvail();
                    this.unregisterLocationPendingIntent(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    Location _arg0 = data.readTypedObject(Location.CREATOR);
                    data.enforceNoDataAvail();
                    this.injectLocation(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    ILocationListener _arg1 = ILocationListener.Stub.asInterface(data.readStrongBinder());
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.requestListenerFlush(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    PendingIntent _arg1 = data.readTypedObject(PendingIntent.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.requestPendingIntentFlush(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    Geofence _arg0 = data.readTypedObject(Geofence.CREATOR);
                    PendingIntent _arg1 = data.readTypedObject(PendingIntent.CREATOR);
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.requestGeofence(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    PendingIntent _arg0 = data.readTypedObject(PendingIntent.CREATOR);
                    data.enforceNoDataAvail();
                    this.removeGeofence(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    boolean _result = this.isGeocodeAvailable();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 13: {
                    ReverseGeocodeRequest _arg0 = data.readTypedObject(ReverseGeocodeRequest.CREATOR);
                    IGeocodeCallback _arg1 = IGeocodeCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.reverseGeocode(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    ForwardGeocodeRequest _arg0 = data.readTypedObject(ForwardGeocodeRequest.CREATOR);
                    IGeocodeCallback _arg1 = IGeocodeCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.forwardGeocode(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    GnssCapabilities _result = this.getGnssCapabilities();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 16: {
                    int _result = this.getGnssYearOfHardware();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 17: {
                    String _result = this.getGnssHardwareModelName();
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 18: {
                    List<GnssAntennaInfo> _result = this.getGnssAntennaInfos();
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 19: {
                    IGnssStatusListener _arg0 = IGnssStatusListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.registerGnssStatusCallback(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    IGnssStatusListener _arg0 = IGnssStatusListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterGnssStatusCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    IGnssNmeaListener _arg0 = IGnssNmeaListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.registerGnssNmeaCallback(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    IGnssNmeaListener _arg0 = IGnssNmeaListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterGnssNmeaCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    GnssMeasurementRequest _arg0 = data.readTypedObject(GnssMeasurementRequest.CREATOR);
                    IGnssMeasurementsListener _arg1 = IGnssMeasurementsListener.Stub.asInterface(data.readStrongBinder());
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.addGnssMeasurementsListener(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    IGnssMeasurementsListener _arg0 = IGnssMeasurementsListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeGnssMeasurementsListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    GnssMeasurementCorrections _arg0 = data.readTypedObject(GnssMeasurementCorrections.CREATOR);
                    data.enforceNoDataAvail();
                    this.injectGnssMeasurementCorrections(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    IGnssNavigationMessageListener _arg0 = IGnssNavigationMessageListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.addGnssNavigationMessageListener(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 27: {
                    IGnssNavigationMessageListener _arg0 = IGnssNavigationMessageListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeGnssNavigationMessageListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    IGnssAntennaInfoListener _arg0 = IGnssAntennaInfoListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.addGnssAntennaInfoListener(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 29: {
                    IGnssAntennaInfoListener _arg0 = IGnssAntennaInfoListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeGnssAntennaInfoListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 30: {
                    IProviderRequestListener _arg0 = IProviderRequestListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addProviderRequestListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 31: {
                    IProviderRequestListener _arg0 = IProviderRequestListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeProviderRequestListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 32: {
                    int _result = this.getGnssBatchSize();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 33: {
                    long _arg0 = data.readLong();
                    ILocationListener _arg1 = ILocationListener.Stub.asInterface(data.readStrongBinder());
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.startGnssBatch(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 34: {
                    this.flushGnssBatch();
                    reply.writeNoException();
                    break;
                }
                case 35: {
                    this.stopGnssBatch();
                    reply.writeNoException();
                    break;
                }
                case 36: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.hasProvider(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 37: {
                    List<String> _result = this.getAllProviders();
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 38: {
                    Criteria _arg0 = data.readTypedObject(Criteria.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    List<String> _result = this.getProviders(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 39: {
                    Criteria _arg0 = data.readTypedObject(Criteria.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    String _result = this.getBestProvider(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 40: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    ProviderProperties _result = this.getProviderProperties(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 41: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isProviderPackage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 42: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    List<String> _result = this.getProviderPackages(_arg0);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 43: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.setExtraLocationControllerPackage(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 44: {
                    String _result = this.getExtraLocationControllerPackage();
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 45: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setExtraLocationControllerPackageEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 46: {
                    boolean _result = this.isExtraLocationControllerPackageEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 47: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isProviderEnabledForUser(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 48: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isLocationEnabledForUser(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 49: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setLocationEnabledForUser(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 50: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isAdasGnssLocationEnabledForUser(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 51: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setAdasGnssLocationEnabledForUser(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 52: {
                    boolean _result = this.isAutomotiveGnssSuspended();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 53: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setAutomotiveGnssSuspended(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 54: {
                    String _arg0 = data.readString();
                    ProviderProperties _arg1 = data.readTypedObject(ProviderProperties.CREATOR);
                    ArrayList<String> _arg2 = data.createStringArrayList();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.addTestProvider(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 55: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.removeTestProvider(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 56: {
                    String _arg0 = data.readString();
                    Location _arg1 = data.readTypedObject(Location.CREATOR);
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.setTestProviderLocation(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 57: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.setTestProviderEnabled(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 58: {
                    LocationTime _result = this.getGnssTimeMillis();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 59: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.sendExtraCommand(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_arg2, 1);
                    break;
                }
                case 60: {
                    String[] _result = this.getBackgroundThrottlingWhitelist();
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    break;
                }
                case 61: {
                    PackageTagsList _result = this.getIgnoreSettingsAllowlist();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 62: {
                    PackageTagsList _result = this.getAdasAllowlist();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void injectLocation_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAllOf(PERMISSIONS_injectLocation, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void addProviderRequestListener_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.INTERACT_ACROSS_USERS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void startGnssBatch_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.LOCATION_HARDWARE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void flushGnssBatch_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.LOCATION_HARDWARE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void stopGnssBatch_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.LOCATION_HARDWARE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isProviderPackage_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.READ_DEVICE_CONFIG", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getProviderPackages_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.READ_DEVICE_CONFIG", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setExtraLocationControllerPackage_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.LOCATION_HARDWARE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setExtraLocationControllerPackageEnabled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.LOCATION_HARDWARE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isAutomotiveGnssSuspended_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONTROL_AUTOMOTIVE_GNSS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setAutomotiveGnssSuspended_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONTROL_AUTOMOTIVE_GNSS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 61;
        }

        private static class Proxy
        implements ILocationManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Location getLastLocation(String provider, LastLocationRequest request, String packageName, String attributionTag) throws RemoteException {
                Location _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(provider);
                    _data.writeTypedObject(request, 0);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Location.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICancellationSignal getCurrentLocation(String provider, LocationRequest request, ILocationCallback callback, String packageName, String attributionTag, String listenerId) throws RemoteException {
                ICancellationSignal _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(provider);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    _data.writeString(listenerId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = ICancellationSignal.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerLocationListener(String provider, LocationRequest request, ILocationListener listener, String packageName, String attributionTag, String listenerId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(provider);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(listener);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    _data.writeString(listenerId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterLocationListener(ILocationListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerLocationPendingIntent(String provider, LocationRequest request, PendingIntent pendingIntent, String packageName, String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(provider);
                    _data.writeTypedObject(request, 0);
                    _data.writeTypedObject(pendingIntent, 0);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterLocationPendingIntent(PendingIntent pendingIntent) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(pendingIntent, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void injectLocation(Location location) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(location, 0);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestListenerFlush(String provider, ILocationListener listener, int requestCode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(provider);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(requestCode);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestPendingIntentFlush(String provider, PendingIntent pendingIntent, int requestCode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(provider);
                    _data.writeTypedObject(pendingIntent, 0);
                    _data.writeInt(requestCode);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestGeofence(Geofence geofence, PendingIntent intent, String packageName, String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(geofence, 0);
                    _data.writeTypedObject(intent, 0);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeGeofence(PendingIntent intent) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(intent, 0);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isGeocodeAvailable() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reverseGeocode(ReverseGeocodeRequest request, IGeocodeCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forwardGeocode(ForwardGeocodeRequest request, IGeocodeCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public GnssCapabilities getGnssCapabilities() throws RemoteException {
                GnssCapabilities _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(GnssCapabilities.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getGnssYearOfHardware() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getGnssHardwareModelName() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<GnssAntennaInfo> getGnssAntennaInfos() throws RemoteException {
                ArrayList<GnssAntennaInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(GnssAntennaInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerGnssStatusCallback(IGnssStatusListener callback, String packageName, String attributionTag, String listenerId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    _data.writeString(listenerId);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterGnssStatusCallback(IGnssStatusListener callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerGnssNmeaCallback(IGnssNmeaListener callback, String packageName, String attributionTag, String listenerId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    _data.writeString(listenerId);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterGnssNmeaCallback(IGnssNmeaListener callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addGnssMeasurementsListener(GnssMeasurementRequest request, IGnssMeasurementsListener listener, String packageName, String attributionTag, String listenerId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(listener);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    _data.writeString(listenerId);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeGnssMeasurementsListener(IGnssMeasurementsListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void injectGnssMeasurementCorrections(GnssMeasurementCorrections corrections) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(corrections, 0);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addGnssNavigationMessageListener(IGnssNavigationMessageListener listener, String packageName, String attributionTag, String listenerId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    _data.writeString(listenerId);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeGnssNavigationMessageListener(IGnssNavigationMessageListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addGnssAntennaInfoListener(IGnssAntennaInfoListener listener, String packageName, String attributionTag, String listenerId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    _data.writeString(listenerId);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeGnssAntennaInfoListener(IGnssAntennaInfoListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addProviderRequestListener(IProviderRequestListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeProviderRequestListener(IProviderRequestListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getGnssBatchSize() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startGnssBatch(long periodNanos, ILocationListener listener, String packageName, String attributionTag, String listenerId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(periodNanos);
                    _data.writeStrongInterface(listener);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    _data.writeString(listenerId);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void flushGnssBatch() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopGnssBatch() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasProvider(String provider) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(provider);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getAllProviders() throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getProviders(Criteria criteria, boolean enabledOnly) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(criteria, 0);
                    _data.writeBoolean(enabledOnly);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getBestProvider(Criteria criteria, boolean enabledOnly) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(criteria, 0);
                    _data.writeBoolean(enabledOnly);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ProviderProperties getProviderProperties(String provider) throws RemoteException {
                ProviderProperties _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(provider);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ProviderProperties.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isProviderPackage(String provider, String packageName, String attributionTag) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(provider);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getProviderPackages(String provider) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(provider);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setExtraLocationControllerPackage(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getExtraLocationControllerPackage() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setExtraLocationControllerPackageEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isExtraLocationControllerPackageEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isProviderEnabledForUser(String provider, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(provider);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isLocationEnabledForUser(int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLocationEnabledForUser(boolean enabled, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAdasGnssLocationEnabledForUser(int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAdasGnssLocationEnabledForUser(boolean enabled, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAutomotiveGnssSuspended() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAutomotiveGnssSuspended(boolean suspended) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(suspended);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addTestProvider(String name, ProviderProperties properties, List<String> locationTags, String packageName, String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeTypedObject(properties, 0);
                    _data.writeStringList(locationTags);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeTestProvider(String provider, String packageName, String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(provider);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTestProviderLocation(String provider, Location location, String packageName, String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(provider);
                    _data.writeTypedObject(location, 0);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(56, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTestProviderEnabled(String provider, boolean enabled, String packageName, String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(provider);
                    _data.writeBoolean(enabled);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(57, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public LocationTime getGnssTimeMillis() throws RemoteException {
                LocationTime _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(58, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(LocationTime.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendExtraCommand(String provider, String command, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(provider);
                    _data.writeString(command);
                    _data.writeTypedObject(extras, 0);
                    boolean _status = this.mRemote.transact(59, _data, _reply, 0);
                    _reply.readException();
                    if (0 != _reply.readInt()) {
                        extras.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getBackgroundThrottlingWhitelist() throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(60, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PackageTagsList getIgnoreSettingsAllowlist() throws RemoteException {
                PackageTagsList _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(61, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PackageTagsList.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PackageTagsList getAdasAllowlist() throws RemoteException {
                PackageTagsList _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(62, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PackageTagsList.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ILocationManager {
        @Override
        public Location getLastLocation(String provider, LastLocationRequest request, String packageName, String attributionTag) throws RemoteException {
            return null;
        }

        @Override
        public ICancellationSignal getCurrentLocation(String provider, LocationRequest request, ILocationCallback callback, String packageName, String attributionTag, String listenerId) throws RemoteException {
            return null;
        }

        @Override
        public void registerLocationListener(String provider, LocationRequest request, ILocationListener listener, String packageName, String attributionTag, String listenerId) throws RemoteException {
        }

        @Override
        public void unregisterLocationListener(ILocationListener listener) throws RemoteException {
        }

        @Override
        public void registerLocationPendingIntent(String provider, LocationRequest request, PendingIntent pendingIntent, String packageName, String attributionTag) throws RemoteException {
        }

        @Override
        public void unregisterLocationPendingIntent(PendingIntent pendingIntent) throws RemoteException {
        }

        @Override
        public void injectLocation(Location location) throws RemoteException {
        }

        @Override
        public void requestListenerFlush(String provider, ILocationListener listener, int requestCode) throws RemoteException {
        }

        @Override
        public void requestPendingIntentFlush(String provider, PendingIntent pendingIntent, int requestCode) throws RemoteException {
        }

        @Override
        public void requestGeofence(Geofence geofence, PendingIntent intent, String packageName, String attributionTag) throws RemoteException {
        }

        @Override
        public void removeGeofence(PendingIntent intent) throws RemoteException {
        }

        @Override
        public boolean isGeocodeAvailable() throws RemoteException {
            return false;
        }

        @Override
        public void reverseGeocode(ReverseGeocodeRequest request, IGeocodeCallback callback) throws RemoteException {
        }

        @Override
        public void forwardGeocode(ForwardGeocodeRequest request, IGeocodeCallback callback) throws RemoteException {
        }

        @Override
        public GnssCapabilities getGnssCapabilities() throws RemoteException {
            return null;
        }

        @Override
        public int getGnssYearOfHardware() throws RemoteException {
            return 0;
        }

        @Override
        public String getGnssHardwareModelName() throws RemoteException {
            return null;
        }

        @Override
        public List<GnssAntennaInfo> getGnssAntennaInfos() throws RemoteException {
            return null;
        }

        @Override
        public void registerGnssStatusCallback(IGnssStatusListener callback, String packageName, String attributionTag, String listenerId) throws RemoteException {
        }

        @Override
        public void unregisterGnssStatusCallback(IGnssStatusListener callback) throws RemoteException {
        }

        @Override
        public void registerGnssNmeaCallback(IGnssNmeaListener callback, String packageName, String attributionTag, String listenerId) throws RemoteException {
        }

        @Override
        public void unregisterGnssNmeaCallback(IGnssNmeaListener callback) throws RemoteException {
        }

        @Override
        public void addGnssMeasurementsListener(GnssMeasurementRequest request, IGnssMeasurementsListener listener, String packageName, String attributionTag, String listenerId) throws RemoteException {
        }

        @Override
        public void removeGnssMeasurementsListener(IGnssMeasurementsListener listener) throws RemoteException {
        }

        @Override
        public void injectGnssMeasurementCorrections(GnssMeasurementCorrections corrections) throws RemoteException {
        }

        @Override
        public void addGnssNavigationMessageListener(IGnssNavigationMessageListener listener, String packageName, String attributionTag, String listenerId) throws RemoteException {
        }

        @Override
        public void removeGnssNavigationMessageListener(IGnssNavigationMessageListener listener) throws RemoteException {
        }

        @Override
        public void addGnssAntennaInfoListener(IGnssAntennaInfoListener listener, String packageName, String attributionTag, String listenerId) throws RemoteException {
        }

        @Override
        public void removeGnssAntennaInfoListener(IGnssAntennaInfoListener listener) throws RemoteException {
        }

        @Override
        public void addProviderRequestListener(IProviderRequestListener listener) throws RemoteException {
        }

        @Override
        public void removeProviderRequestListener(IProviderRequestListener listener) throws RemoteException {
        }

        @Override
        public int getGnssBatchSize() throws RemoteException {
            return 0;
        }

        @Override
        public void startGnssBatch(long periodNanos, ILocationListener listener, String packageName, String attributionTag, String listenerId) throws RemoteException {
        }

        @Override
        public void flushGnssBatch() throws RemoteException {
        }

        @Override
        public void stopGnssBatch() throws RemoteException {
        }

        @Override
        public boolean hasProvider(String provider) throws RemoteException {
            return false;
        }

        @Override
        public List<String> getAllProviders() throws RemoteException {
            return null;
        }

        @Override
        public List<String> getProviders(Criteria criteria, boolean enabledOnly) throws RemoteException {
            return null;
        }

        @Override
        public String getBestProvider(Criteria criteria, boolean enabledOnly) throws RemoteException {
            return null;
        }

        @Override
        public ProviderProperties getProviderProperties(String provider) throws RemoteException {
            return null;
        }

        @Override
        public boolean isProviderPackage(String provider, String packageName, String attributionTag) throws RemoteException {
            return false;
        }

        @Override
        public List<String> getProviderPackages(String provider) throws RemoteException {
            return null;
        }

        @Override
        public void setExtraLocationControllerPackage(String packageName) throws RemoteException {
        }

        @Override
        public String getExtraLocationControllerPackage() throws RemoteException {
            return null;
        }

        @Override
        public void setExtraLocationControllerPackageEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public boolean isExtraLocationControllerPackageEnabled() throws RemoteException {
            return false;
        }

        @Override
        public boolean isProviderEnabledForUser(String provider, int userId) throws RemoteException {
            return false;
        }

        @Override
        public boolean isLocationEnabledForUser(int userId) throws RemoteException {
            return false;
        }

        @Override
        public void setLocationEnabledForUser(boolean enabled, int userId) throws RemoteException {
        }

        @Override
        public boolean isAdasGnssLocationEnabledForUser(int userId) throws RemoteException {
            return false;
        }

        @Override
        public void setAdasGnssLocationEnabledForUser(boolean enabled, int userId) throws RemoteException {
        }

        @Override
        public boolean isAutomotiveGnssSuspended() throws RemoteException {
            return false;
        }

        @Override
        public void setAutomotiveGnssSuspended(boolean suspended) throws RemoteException {
        }

        @Override
        public void addTestProvider(String name, ProviderProperties properties, List<String> locationTags, String packageName, String attributionTag) throws RemoteException {
        }

        @Override
        public void removeTestProvider(String provider, String packageName, String attributionTag) throws RemoteException {
        }

        @Override
        public void setTestProviderLocation(String provider, Location location, String packageName, String attributionTag) throws RemoteException {
        }

        @Override
        public void setTestProviderEnabled(String provider, boolean enabled, String packageName, String attributionTag) throws RemoteException {
        }

        @Override
        public LocationTime getGnssTimeMillis() throws RemoteException {
            return null;
        }

        @Override
        public void sendExtraCommand(String provider, String command, Bundle extras) throws RemoteException {
        }

        @Override
        public String[] getBackgroundThrottlingWhitelist() throws RemoteException {
            return null;
        }

        @Override
        public PackageTagsList getIgnoreSettingsAllowlist() throws RemoteException {
            return null;
        }

        @Override
        public PackageTagsList getAdasAllowlist() throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

