/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
public class GnssReflectingPlane
implements Parcelable {
    private final double mLatitudeDegrees;
    private final double mLongitudeDegrees;
    private final double mAltitudeMeters;
    private final double mAzimuthDegrees;
    public static final Parcelable.Creator<GnssReflectingPlane> CREATOR = new Parcelable.Creator<GnssReflectingPlane>(){

        @Override
        @NonNull
        public GnssReflectingPlane createFromParcel(@NonNull Parcel parcel) {
            GnssReflectingPlane reflectingPlane = new Builder().setLatitudeDegrees(parcel.readDouble()).setLongitudeDegrees(parcel.readDouble()).setAltitudeMeters(parcel.readDouble()).setAzimuthDegrees(parcel.readDouble()).build();
            return reflectingPlane;
        }

        public GnssReflectingPlane[] newArray(int i) {
            return new GnssReflectingPlane[i];
        }
    };

    private GnssReflectingPlane(Builder builder) {
        this.mLatitudeDegrees = builder.mLatitudeDegrees;
        this.mLongitudeDegrees = builder.mLongitudeDegrees;
        this.mAltitudeMeters = builder.mAltitudeMeters;
        this.mAzimuthDegrees = builder.mAzimuthDegrees;
    }

    public double getLatitudeDegrees() {
        return this.mLatitudeDegrees;
    }

    public double getLongitudeDegrees() {
        return this.mLongitudeDegrees;
    }

    public double getAltitudeMeters() {
        return this.mAltitudeMeters;
    }

    public double getAzimuthDegrees() {
        return this.mAzimuthDegrees;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel parcel, int flags) {
        parcel.writeDouble(this.mLatitudeDegrees);
        parcel.writeDouble(this.mLongitudeDegrees);
        parcel.writeDouble(this.mAltitudeMeters);
        parcel.writeDouble(this.mAzimuthDegrees);
    }

    @NonNull
    public String toString() {
        StringBuilder builder = new StringBuilder("ReflectingPlane[");
        builder.append(" LatitudeDegrees=").append(this.mLatitudeDegrees);
        builder.append(" LongitudeDegrees=").append(this.mLongitudeDegrees);
        builder.append(" AltitudeMeters=").append(this.mAltitudeMeters);
        builder.append(" AzimuthDegrees=").append(this.mAzimuthDegrees);
        builder.append(']');
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GnssReflectingPlane) {
            GnssReflectingPlane that = (GnssReflectingPlane)obj;
            return Double.compare(this.mLatitudeDegrees, that.mLatitudeDegrees) == 0 && Double.compare(this.mLongitudeDegrees, that.mLongitudeDegrees) == 0 && Double.compare(this.mAltitudeMeters, that.mAltitudeMeters) == 0 && Double.compare(this.mAzimuthDegrees, that.mAzimuthDegrees) == 0;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mLatitudeDegrees, this.mLatitudeDegrees, this.mAltitudeMeters, this.mAzimuthDegrees);
    }

    public static class Builder {
        private double mLatitudeDegrees;
        private double mLongitudeDegrees;
        private double mAltitudeMeters;
        private double mAzimuthDegrees;

        @NonNull
        public Builder setLatitudeDegrees(double latitudeDegrees) {
            this.mLatitudeDegrees = latitudeDegrees;
            return this;
        }

        @NonNull
        public Builder setLongitudeDegrees(double longitudeDegrees) {
            this.mLongitudeDegrees = longitudeDegrees;
            return this;
        }

        @NonNull
        public Builder setAltitudeMeters(double altitudeMeters) {
            this.mAltitudeMeters = altitudeMeters;
            return this;
        }

        @NonNull
        public Builder setAzimuthDegrees(double azimuthDegrees) {
            this.mAzimuthDegrees = azimuthDegrees;
            return this;
        }

        @NonNull
        public GnssReflectingPlane build() {
            return new GnssReflectingPlane(this);
        }
    }
}

