/*
 * Decompiled with CFR 0.152.
 */
package android.internal.aconfig.storage;

import android.internal.aconfig.storage.AconfigStorageException;
import android.internal.aconfig.storage.ByteBufferReader;
import android.internal.aconfig.storage.FileType;
import android.internal.aconfig.storage.TableUtils;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PackageTable {
    private static final int FINGERPRINT_BYTES = 8;
    private static final int NODE_SKIP_BYTES = 12;
    private Header mHeader;
    private ByteBuffer mBuffer;

    public static PackageTable fromBytes(ByteBuffer bytes) {
        PackageTable packageTable = new PackageTable();
        packageTable.mBuffer = bytes;
        packageTable.mHeader = Header.fromBytes(new ByteBufferReader(bytes));
        return packageTable;
    }

    public Node get(String packageName) {
        int numBuckets = (this.mHeader.mNodeOffset - this.mHeader.mBucketOffset) / 4;
        int bucketIndex = TableUtils.getBucketIndex(packageName.getBytes(StandardCharsets.UTF_8), numBuckets);
        int newPosition = this.mHeader.mBucketOffset + bucketIndex * 4;
        if (newPosition >= this.mHeader.mNodeOffset) {
            return null;
        }
        ByteBufferReader reader = new ByteBufferReader(this.mBuffer);
        reader.position(newPosition);
        int nodeIndex = reader.readInt();
        if (nodeIndex < this.mHeader.mNodeOffset || nodeIndex >= this.mHeader.mFileSize) {
            return null;
        }
        while (nodeIndex != -1) {
            reader.position(nodeIndex);
            Node node = Node.fromBytes(reader, this.mHeader.mVersion);
            if (Objects.equals(packageName, node.mPackageName)) {
                return node;
            }
            nodeIndex = node.mNextOffset;
        }
        return null;
    }

    public List<String> getPackageList() {
        ArrayList<String> list = new ArrayList<String>(this.mHeader.mNumPackages);
        ByteBufferReader reader = new ByteBufferReader(this.mBuffer);
        reader.position(this.mHeader.mNodeOffset);
        int fingerprintBytes = this.mHeader.mVersion == 1 ? 0 : 8;
        int skipBytes = fingerprintBytes + 12;
        for (int i = 0; i < this.mHeader.mNumPackages; ++i) {
            list.add(reader.readString());
            reader.position(reader.position() + skipBytes);
        }
        return list;
    }

    public Header getHeader() {
        return this.mHeader;
    }

    public static class Header {
        private int mVersion;
        private String mContainer;
        private FileType mFileType;
        private int mFileSize;
        private int mNumPackages;
        private int mBucketOffset;
        private int mNodeOffset;

        private static Header fromBytes(ByteBufferReader reader) {
            Header header = new Header();
            header.mVersion = reader.readInt();
            header.mContainer = reader.readString();
            header.mFileType = FileType.fromInt(reader.readByte());
            header.mFileSize = reader.readInt();
            header.mNumPackages = reader.readInt();
            header.mBucketOffset = reader.readInt();
            header.mNodeOffset = reader.readInt();
            if (header.mFileType != FileType.PACKAGE_MAP) {
                throw new AconfigStorageException("binary file is not a package map");
            }
            return header;
        }

        public int getVersion() {
            return this.mVersion;
        }

        public String getContainer() {
            return this.mContainer;
        }

        public FileType getFileType() {
            return this.mFileType;
        }

        public int getFileSize() {
            return this.mFileSize;
        }

        public int getNumPackages() {
            return this.mNumPackages;
        }

        public int getBucketOffset() {
            return this.mBucketOffset;
        }

        public int getNodeOffset() {
            return this.mNodeOffset;
        }
    }

    public static class Node {
        private String mPackageName;
        private int mPackageId;
        private long mPackageFingerprint;
        private int mBooleanStartIndex;
        private int mNextOffset;
        private boolean mHasPackageFingerprint;

        private static Node fromBytes(ByteBufferReader reader, int version) {
            switch (version) {
                case 1: {
                    return Node.fromBytesV1(reader);
                }
                case 2: {
                    return Node.fromBytesV2(reader);
                }
            }
            return new Node();
        }

        private static Node fromBytesV1(ByteBufferReader reader) {
            Node node = new Node();
            node.mPackageName = reader.readString();
            node.mPackageId = reader.readInt();
            node.mBooleanStartIndex = reader.readInt();
            node.mNextOffset = reader.readInt();
            node.mNextOffset = node.mNextOffset == 0 ? -1 : node.mNextOffset;
            return node;
        }

        private static Node fromBytesV2(ByteBufferReader reader) {
            Node node = new Node();
            node.mPackageName = reader.readString();
            node.mPackageId = reader.readInt();
            node.mPackageFingerprint = reader.readLong();
            node.mBooleanStartIndex = reader.readInt();
            node.mNextOffset = reader.readInt();
            node.mNextOffset = node.mNextOffset == 0 ? -1 : node.mNextOffset;
            node.mHasPackageFingerprint = true;
            return node;
        }

        public int hashCode() {
            return Objects.hash(this.mPackageName, this.mPackageId, this.mBooleanStartIndex, this.mNextOffset);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof Node)) {
                return false;
            }
            Node other = (Node)obj;
            return Objects.equals(this.mPackageName, other.mPackageName) && this.mPackageId == other.mPackageId && this.mBooleanStartIndex == other.mBooleanStartIndex && this.mNextOffset == other.mNextOffset;
        }

        public String getPackageName() {
            return this.mPackageName;
        }

        public int getPackageId() {
            return this.mPackageId;
        }

        public long getPackageFingerprint() {
            return this.mPackageFingerprint;
        }

        public int getBooleanStartIndex() {
            return this.mBooleanStartIndex;
        }

        public int getNextOffset() {
            return this.mNextOffset;
        }

        public boolean hasPackageFingerprint() {
            return this.mHasPackageFingerprint;
        }
    }
}

