/*
 * Decompiled with CFR 0.152.
 */
package android.internal.aconfig.storage;

import android.internal.aconfig.storage.AconfigStorageException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class ByteBufferReader {
    private ByteBuffer mByteBuffer;
    private int mPosition;

    public ByteBufferReader(ByteBuffer byteBuffer) {
        this.mByteBuffer = byteBuffer;
        this.mByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public int readByte() {
        return Byte.toUnsignedInt(this.mByteBuffer.get(this.nextGetIndex(1)));
    }

    public int readShort() {
        return Short.toUnsignedInt(this.mByteBuffer.getShort(this.nextGetIndex(2)));
    }

    public int readInt() {
        return this.mByteBuffer.getInt(this.nextGetIndex(4));
    }

    public long readLong() {
        return this.mByteBuffer.getLong(this.nextGetIndex(8));
    }

    public String readString() {
        int length = this.readInt();
        if (length > 1024) {
            throw new AconfigStorageException("String length exceeds maximum allowed size (1024 bytes): " + length);
        }
        byte[] bytes = new byte[length];
        this.getArray(this.nextGetIndex(length), bytes, 0, length);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public int readByte(int i) {
        return Byte.toUnsignedInt(this.mByteBuffer.get(i));
    }

    public void position(int newPosition) {
        this.mPosition = newPosition;
    }

    public int position() {
        return this.mPosition;
    }

    private int nextGetIndex(int nb) {
        int p = this.mPosition;
        this.mPosition += nb;
        return p;
    }

    private void getArray(int index, byte[] dst, int offset, int length) {
        Objects.checkFromIndexSize(index, length, this.mByteBuffer.limit());
        Objects.checkFromIndexSize(offset, length, dst.length);
        int end = offset + length;
        int i = offset;
        int j = index;
        while (i < end) {
            dst[i] = this.mByteBuffer.get(j);
            ++i;
            ++j;
        }
    }
}

