/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.inputmethodservice.IInputMethodSessionWrapper;
import android.inputmethodservice.InputMethodServiceInternal;
import android.inputmethodservice.RemoteInputConnection;
import android.os.Binder;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.util.Log;
import android.view.InputChannel;
import android.view.MotionEvent;
import android.view.inputmethod.CursorAnchorInfo;
import android.view.inputmethod.ImeTracker;
import android.view.inputmethod.InputBinding;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethod;
import android.view.inputmethod.InputMethodSession;
import android.view.inputmethod.InputMethodSubtype;
import com.android.internal.inputmethod.CancellationGroup;
import com.android.internal.inputmethod.IConnectionlessHandwritingCallback;
import com.android.internal.inputmethod.IInlineSuggestionsRequestCallback;
import com.android.internal.inputmethod.IInputMethod;
import com.android.internal.inputmethod.IInputMethodSession;
import com.android.internal.inputmethod.IInputMethodSessionCallback;
import com.android.internal.inputmethod.IRemoteInputConnection;
import com.android.internal.inputmethod.InlineSuggestionsRequestInfo;
import com.android.internal.os.HandlerCaller;
import com.android.internal.os.SomeArgs;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class IInputMethodWrapper
extends IInputMethod.Stub
implements HandlerCaller.Callback {
    private static final String TAG = "InputMethodWrapper";
    private static final int DO_DUMP = 1;
    private static final int DO_INITIALIZE_INTERNAL = 10;
    private static final int DO_SET_INPUT_CONTEXT = 20;
    private static final int DO_UNSET_INPUT_CONTEXT = 30;
    private static final int DO_START_INPUT = 32;
    private static final int DO_ON_NAV_BUTTON_FLAGS_CHANGED = 35;
    private static final int DO_CREATE_SESSION = 40;
    private static final int DO_SET_SESSION_ENABLED = 45;
    private static final int DO_SHOW_SOFT_INPUT = 60;
    private static final int DO_HIDE_SOFT_INPUT = 70;
    private static final int DO_CHANGE_INPUTMETHOD_SUBTYPE = 80;
    private static final int DO_CREATE_INLINE_SUGGESTIONS_REQUEST = 90;
    private static final int DO_CAN_START_STYLUS_HANDWRITING = 100;
    private static final int DO_START_STYLUS_HANDWRITING = 110;
    private static final int DO_INIT_INK_WINDOW = 120;
    private static final int DO_FINISH_STYLUS_HANDWRITING = 130;
    private static final int DO_UPDATE_TOOL_TYPE = 140;
    private static final int DO_REMOVE_STYLUS_HANDWRITING_WINDOW = 150;
    private static final int DO_SET_STYLUS_WINDOW_IDLE_TIMEOUT = 160;
    private static final int DO_COMMIT_HANDWRITING_DELEGATION_TEXT_IF_AVAILABLE = 170;
    private static final int DO_DISCARD_HANDWRITING_DELEGATION_TEXT = 180;
    final WeakReference<InputMethodServiceInternal> mTarget;
    final Context mContext;
    @UnsupportedAppUsage
    final HandlerCaller mCaller;
    final WeakReference<InputMethod> mInputMethod;
    final int mTargetSdkVersion;
    @Nullable
    CancellationGroup mCancellationGroup = null;

    IInputMethodWrapper(InputMethodServiceInternal imsInternal, InputMethod inputMethod) {
        this.mTarget = new WeakReference<InputMethodServiceInternal>(imsInternal);
        this.mContext = imsInternal.getContext().getApplicationContext();
        this.mCaller = new HandlerCaller(this.mContext, null, this, true);
        this.mInputMethod = new WeakReference<InputMethod>(inputMethod);
        this.mTargetSdkVersion = imsInternal.getContext().getApplicationInfo().targetSdkVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeMessage(Message msg) {
        InputMethod inputMethod = (InputMethod)this.mInputMethod.get();
        InputMethodServiceInternal target = (InputMethodServiceInternal)this.mTarget.get();
        switch (msg.what) {
            case 1: {
                SomeArgs args = (SomeArgs)msg.obj;
                if (IInputMethodWrapper.isValid(inputMethod, target, "DO_DUMP")) {
                    FileDescriptor fd = (FileDescriptor)args.arg1;
                    PrintWriter fout = (PrintWriter)args.arg2;
                    String[] dumpArgs = (String[])args.arg3;
                    CountDownLatch latch = (CountDownLatch)args.arg4;
                    try {
                        target.dump(fd, fout, dumpArgs);
                    }
                    catch (RuntimeException e) {
                        fout.println("Exception: " + e);
                    }
                    finally {
                        latch.countDown();
                    }
                }
                args.recycle();
                return;
            }
            case 10: {
                if (IInputMethodWrapper.isValid(inputMethod, target, "DO_INITIALIZE_INTERNAL")) {
                    inputMethod.initializeInternal((IInputMethod.InitParams)msg.obj);
                }
                return;
            }
            case 20: {
                if (IInputMethodWrapper.isValid(inputMethod, target, "DO_SET_INPUT_CONTEXT")) {
                    inputMethod.bindInput((InputBinding)msg.obj);
                }
                return;
            }
            case 30: {
                if (IInputMethodWrapper.isValid(inputMethod, target, "DO_UNSET_INPUT_CONTEXT")) {
                    inputMethod.unbindInput();
                }
                return;
            }
            case 32: {
                SomeArgs args = (SomeArgs)msg.obj;
                if (IInputMethodWrapper.isValid(inputMethod, target, "DO_START_INPUT")) {
                    InputConnection inputConnection = (InputConnection)args.arg1;
                    IInputMethod.StartInputParams params = (IInputMethod.StartInputParams)args.arg2;
                    inputMethod.dispatchStartInput(inputConnection, params);
                }
                args.recycle();
                return;
            }
            case 35: {
                if (IInputMethodWrapper.isValid(inputMethod, target, "DO_ON_NAV_BUTTON_FLAGS_CHANGED")) {
                    inputMethod.onNavButtonFlagsChanged(msg.arg1);
                }
                return;
            }
            case 40: {
                SomeArgs args = (SomeArgs)msg.obj;
                if (IInputMethodWrapper.isValid(inputMethod, target, "DO_CREATE_SESSION")) {
                    inputMethod.createSession(new InputMethodSessionCallbackWrapper(this.mContext, (InputChannel)args.arg1, (IInputMethodSessionCallback)args.arg2));
                }
                args.recycle();
                return;
            }
            case 45: {
                if (IInputMethodWrapper.isValid(inputMethod, target, "DO_SET_SESSION_ENABLED")) {
                    inputMethod.setSessionEnabled((InputMethodSession)msg.obj, msg.arg1 != 0);
                }
                return;
            }
            case 60: {
                SomeArgs args = (SomeArgs)msg.obj;
                ImeTracker.Token statsToken = (ImeTracker.Token)args.arg3;
                if (IInputMethodWrapper.isValid(inputMethod, target, "DO_SHOW_SOFT_INPUT")) {
                    ImeTracker.forLogging().onProgress(statsToken, 12);
                    inputMethod.showSoftInputWithToken(msg.arg1, (ResultReceiver)args.arg2, (IBinder)args.arg1, statsToken);
                } else {
                    ImeTracker.forLogging().onFailed(statsToken, 12);
                }
                args.recycle();
                return;
            }
            case 70: {
                SomeArgs args = (SomeArgs)msg.obj;
                ImeTracker.Token statsToken = (ImeTracker.Token)args.arg3;
                if (IInputMethodWrapper.isValid(inputMethod, target, "DO_HIDE_SOFT_INPUT")) {
                    ImeTracker.forLogging().onProgress(statsToken, 12);
                    inputMethod.hideSoftInputWithToken(msg.arg1, (ResultReceiver)args.arg2, (IBinder)args.arg1, statsToken);
                } else {
                    ImeTracker.forLogging().onFailed(statsToken, 12);
                }
                args.recycle();
                return;
            }
            case 80: {
                if (IInputMethodWrapper.isValid(inputMethod, target, "DO_CHANGE_INPUTMETHOD_SUBTYPE")) {
                    inputMethod.changeInputMethodSubtype((InputMethodSubtype)msg.obj);
                }
                return;
            }
            case 90: {
                SomeArgs args = (SomeArgs)msg.obj;
                if (IInputMethodWrapper.isValid(inputMethod, target, "DO_CREATE_INLINE_SUGGESTIONS_REQUEST")) {
                    inputMethod.onCreateInlineSuggestionsRequest((InlineSuggestionsRequestInfo)args.arg1, (IInlineSuggestionsRequestCallback)args.arg2);
                }
                args.recycle();
                return;
            }
            case 100: {
                SomeArgs args = (SomeArgs)msg.obj;
                if (IInputMethodWrapper.isValid(inputMethod, target, "DO_CAN_START_STYLUS_HANDWRITING")) {
                    inputMethod.canStartStylusHandwriting(msg.arg1, (IConnectionlessHandwritingCallback)args.arg1, (CursorAnchorInfo)args.arg2, msg.arg2 != 0);
                }
                args.recycle();
                return;
            }
            case 140: {
                if (IInputMethodWrapper.isValid(inputMethod, target, "DO_UPDATE_TOOL_TYPE")) {
                    inputMethod.updateEditorToolType(msg.arg1);
                }
                return;
            }
            case 110: {
                SomeArgs args = (SomeArgs)msg.obj;
                if (IInputMethodWrapper.isValid(inputMethod, target, "DO_START_STYLUS_HANDWRITING")) {
                    inputMethod.startStylusHandwriting(msg.arg1, (InputChannel)args.arg1, (List)args.arg2);
                }
                args.recycle();
                return;
            }
            case 120: {
                if (IInputMethodWrapper.isValid(inputMethod, target, "DO_INIT_INK_WINDOW")) {
                    inputMethod.initInkWindow();
                }
                return;
            }
            case 130: {
                if (IInputMethodWrapper.isValid(inputMethod, target, "DO_FINISH_STYLUS_HANDWRITING")) {
                    inputMethod.finishStylusHandwriting();
                }
                return;
            }
            case 150: {
                if (IInputMethodWrapper.isValid(inputMethod, target, "DO_REMOVE_STYLUS_HANDWRITING_WINDOW")) {
                    inputMethod.removeStylusHandwritingWindow();
                }
                return;
            }
            case 160: {
                if (IInputMethodWrapper.isValid(inputMethod, target, "DO_SET_STYLUS_WINDOW_IDLE_TIMEOUT")) {
                    inputMethod.setStylusWindowIdleTimeoutForTest((Long)msg.obj);
                }
                return;
            }
            case 170: {
                if (IInputMethodWrapper.isValid(inputMethod, target, "DO_COMMIT_HANDWRITING_DELEGATION_TEXT_IF_AVAILABLE")) {
                    inputMethod.commitHandwritingDelegationTextIfAvailable();
                }
                return;
            }
            case 180: {
                if (IInputMethodWrapper.isValid(inputMethod, target, "DO_DISCARD_HANDWRITING_DELEGATION_TEXT")) {
                    inputMethod.discardHandwritingDelegationText();
                }
                return;
            }
        }
        Log.w(TAG, "Unhandled message code: " + msg.what);
    }

    @Override
    protected void dump(FileDescriptor fd, PrintWriter fout, String[] args) {
        InputMethodServiceInternal target = (InputMethodServiceInternal)this.mTarget.get();
        if (target == null) {
            return;
        }
        if (target.getContext().checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            fout.println("Permission Denial: can't dump InputMethodManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        CountDownLatch latch = new CountDownLatch(1);
        this.mCaller.getHandler().sendMessageAtFrontOfQueue(this.mCaller.obtainMessageOOOO(1, fd, fout, args, latch));
        try {
            if (!latch.await(5L, TimeUnit.SECONDS)) {
                fout.println("Timeout waiting for dump");
            }
        }
        catch (InterruptedException e) {
            fout.println("Interrupted waiting for dump");
        }
    }

    @Override
    public void initializeInternal(@NonNull IInputMethod.InitParams params) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(10, params));
    }

    @Override
    public void onCreateInlineSuggestionsRequest(InlineSuggestionsRequestInfo requestInfo, IInlineSuggestionsRequestCallback cb) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOO(90, requestInfo, cb));
    }

    @Override
    public void bindInput(InputBinding binding) {
        if (this.mCancellationGroup != null) {
            Log.e(TAG, "bindInput must be paired with unbindInput.");
        }
        this.mCancellationGroup = new CancellationGroup();
        RemoteInputConnection ic = new RemoteInputConnection(this.mTarget, IRemoteInputConnection.Stub.asInterface(binding.getConnectionToken()), this.mCancellationGroup);
        InputBinding nu = new InputBinding(ic, binding);
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(20, nu));
    }

    @Override
    public void unbindInput() {
        if (this.mCancellationGroup != null) {
            this.mCancellationGroup.cancelAll();
            this.mCancellationGroup = null;
        } else {
            Log.e(TAG, "unbindInput must be paired with bindInput.");
        }
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessage(30));
    }

    @Override
    public void startInput(@NonNull IInputMethod.StartInputParams params) {
        if (this.mCancellationGroup == null) {
            Log.e(TAG, "startInput must be called after bindInput.");
            this.mCancellationGroup = new CancellationGroup();
        }
        params.editorInfo.makeCompatible(this.mTargetSdkVersion);
        RemoteInputConnection ic = params.remoteInputConnection == null ? null : new RemoteInputConnection(this.mTarget, params.remoteInputConnection, this.mCancellationGroup);
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOO(32, ic, params));
    }

    @Override
    public void onNavButtonFlagsChanged(int navButtonFlags) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageI(35, navButtonFlags));
    }

    @Override
    public void createSession(InputChannel channel, IInputMethodSessionCallback callback) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOO(40, channel, callback));
    }

    @Override
    public void setSessionEnabled(IInputMethodSession session, boolean enabled) {
        try {
            InputMethodSession ls = ((IInputMethodSessionWrapper)session).getInternalInputMethodSession();
            if (ls == null) {
                Log.w(TAG, "Session is already finished: " + session);
                return;
            }
            this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIO(45, enabled ? 1 : 0, ls));
        }
        catch (ClassCastException e) {
            Log.w(TAG, "Incoming session not of correct type: " + session, e);
        }
    }

    @Override
    public void showSoftInput(IBinder showInputToken, @NonNull ImeTracker.Token statsToken, int flags, ResultReceiver resultReceiver) {
        ImeTracker.forLogging().onProgress(statsToken, 11);
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIOOO(60, flags, showInputToken, resultReceiver, statsToken));
    }

    @Override
    public void hideSoftInput(IBinder hideInputToken, @NonNull ImeTracker.Token statsToken, int flags, ResultReceiver resultReceiver) {
        ImeTracker.forLogging().onProgress(statsToken, 11);
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIOOO(70, flags, hideInputToken, resultReceiver, statsToken));
    }

    @Override
    public void changeInputMethodSubtype(InputMethodSubtype subtype) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(80, subtype));
    }

    @Override
    public void canStartStylusHandwriting(int requestId, IConnectionlessHandwritingCallback connectionlessCallback, CursorAnchorInfo cursorAnchorInfo, boolean isConnectionlessForDelegation) throws RemoteException {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIIOO(100, requestId, isConnectionlessForDelegation ? 1 : 0, connectionlessCallback, cursorAnchorInfo));
    }

    @Override
    public void updateEditorToolType(int toolType) throws RemoteException {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageI(140, toolType));
    }

    @Override
    public void startStylusHandwriting(int requestId, @NonNull InputChannel channel, @Nullable List<MotionEvent> stylusEvents) throws RemoteException {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIOO(110, requestId, channel, stylusEvents));
    }

    @Override
    public void commitHandwritingDelegationTextIfAvailable() {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessage(170));
    }

    @Override
    public void discardHandwritingDelegationText() {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessage(180));
    }

    @Override
    public void initInkWindow() {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessage(120));
    }

    @Override
    public void finishStylusHandwriting() {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessage(130));
    }

    @Override
    public void removeStylusHandwritingWindow() {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessage(150));
    }

    @Override
    public void setStylusWindowIdleTimeoutForTest(long timeout) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(160, timeout));
    }

    private static boolean isValid(InputMethod inputMethod, InputMethodServiceInternal target, String msg) {
        if (inputMethod != null && target != null && !target.isServiceDestroyed()) {
            return true;
        }
        Log.w(TAG, "Ignoring " + msg + ", InputMethod:" + inputMethod + ", InputMethodServiceInternal:" + target);
        return false;
    }

    static class InputMethodSessionCallbackWrapper
    implements InputMethod.SessionCallback {
        final Context mContext;
        final InputChannel mChannel;
        final IInputMethodSessionCallback mCb;

        InputMethodSessionCallbackWrapper(Context context, InputChannel channel, IInputMethodSessionCallback cb) {
            this.mContext = context;
            this.mChannel = channel;
            this.mCb = cb;
        }

        @Override
        public void sessionCreated(InputMethodSession session) {
            try {
                if (session != null) {
                    IInputMethodSessionWrapper wrap = new IInputMethodSessionWrapper(this.mContext, session, this.mChannel);
                    this.mCb.sessionCreated(wrap);
                } else {
                    if (this.mChannel != null) {
                        this.mChannel.dispose();
                    }
                    this.mCb.sessionCreated(null);
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }
}

